/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanFactory;
import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DialogData;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectConfigs
implements WizardPanelIface,
ActionListener,
FocusListener {
    private SSNResource bundle = new SSNResource(PanelSelectConfigs.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_warningImage = null;
    private JTextArea m_warningMessage = null;
    private JLabel m_findLabel = null;
    private KitTextField m_findText = null;
    private JButton m_findButton = null;
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private ActionListener m_configColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private boolean m_cfgwizardAdd = false;
    private boolean m_levconfigAdd = false;
    private Integer m_previousStepNumber = null;
    private String m_cfgwizardPreProd = null;
    private String m_levconfigPreProd = null;
    private String m_previousPlan = "";
    private String m_previousMachine = "";
    private String m_previousOrder = "";
    private HashMap m_responseProducts = null;
    private Set<String> m_dependOnWebAppList = new HashSet<String>();
    private boolean m_lastDisplayValue = false;

    public PanelSelectConfigs() {
        this.m_componentTableModel = new ComponentTableModel();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectConfigs.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectConfigs.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        boolean oneSelected = false;
        boolean appSrvSelected = false;
        String appSrvName = "";
        String webAppList = "";
        ArrayList componentIds = this.m_componentTableModel.getComponentIds();
        HashMap components = this.m_componentTableModel.getComponents();
        ArrayList<String> configComponents = new ArrayList<String>();
        if (this.m_cfgwizardAdd && this.m_cfgwizardPreProd == null) {
            configComponents.add("cfgwizard");
        }
        if (this.m_levconfigAdd && this.m_levconfigPreProd == null) {
            configComponents.add("levconfig");
        }
        if (Globals.g_mode == 2 && Globals.g_cmtTask == 26 && Globals.g_cmtAddObjectSpawnr) {
            configComponents.add("objectspawnr");
        }
        String id = null;
        ComponentData data = null;
        for (int i = 0; i < componentIds.size(); ++i) {
            id = (String)componentIds.get(i);
            data = (ComponentData)components.get(id);
            if (data.doConfig()) {
                oneSelected = true;
                configComponents.add(data.getIdentifier());
                if (Utils.isWebAppServerCode(id)) {
                    appSrvSelected = true;
                } else if (this.m_dependOnWebAppList != null && this.m_dependOnWebAppList.size() > 0) {
                    boolean isWebApp = false;
                    Iterator<String> iter = this.m_dependOnWebAppList.iterator();
                    while (!isWebApp && iter.hasNext()) {
                        String code = iter.next();
                        if (!id.equalsIgnoreCase(code)) continue;
                        isWebApp = true;
                    }
                    if (isWebApp) {
                        if (webAppList.length() > 0) {
                            webAppList = webAppList + "\n";
                        }
                        webAppList = webAppList + data.getName();
                    }
                }
            }
            if (Utils.isWebAppServerCode(id)) {
                appSrvName = data.getName();
            }
            if (this.m_cfgwizardPreProd != null && id.equalsIgnoreCase(this.m_cfgwizardPreProd)) {
                configComponents.add("cfgwizard");
            }
            if (this.m_levconfigPreProd == null || !id.equalsIgnoreCase(this.m_levconfigPreProd)) continue;
            configComponents.add("levconfig");
        }
        if (this.m_lastDisplayValue && !oneSelected) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectConfigs.NoConfigError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            this.m_componentTable.requestFocus();
            valid = false;
        }
        if (valid && this.m_lastDisplayValue && !Globals.g_skipDependencyCheck && webAppList.length() > 0 && !appSrvSelected) {
            String msgString = this.bundle.messageString("PanelSelectConfigs.NeedWebApp.txt", appSrvName, webAppList);
            if (appSrvName.trim().isEmpty()) {
                msgString = this.bundle.messageString("PanelSelectConfigs.NoWebApp.txt", webAppList);
            }
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), msgString, this.bundle.getString("Common.Warning.txt"), 2);
            this.m_componentTable.requestFocus();
            valid = false;
        }
        if (valid) {
            Globals.g_planConfigs = configComponents.toArray(new String[0]);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (Globals.g_singleAccount) {
            Globals.g_configPromptLevel = 0;
        }
        if (Globals.g_mode == 2) {
            display = true;
        } else if (Globals.g_expertUser || Globals.g_installingSubset || Globals.g_configPromptLevel == 2) {
            display = true;
        } else if (Globals.g_machine != null && (Globals.g_reconfigure || !Globals.g_machine.isConfiguredFullySupported())) {
            display = true;
            if (Globals.g_singleAccount && Globals.g_reconfigure) {
                Globals.g_configPromptLevel = 2;
            }
        }
        this.m_lastDisplayValue = display;
        if (!display && Globals.g_machine != null) {
            this.m_componentTableModel.load();
            this.validateData();
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 2 ? "configoption" : "hostname";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if (Globals.g_mode == 2) {
            this.populate();
        } else if (Globals.g_plan != null && !this.m_previousPlan.equals(Globals.g_plan.getFile()) || Globals.g_machine != null && !this.m_previousMachine.equals(Globals.g_machine.getName()) || Globals.g_stepNumber != null && !Globals.g_stepNumber.equals(this.m_previousStepNumber) || this.m_previousStepNumber != null && !this.m_previousStepNumber.equals(Globals.g_stepNumber) || !this.m_previousOrder.equalsIgnoreCase(Globals.g_order)) {
            if (!this.m_previousOrder.equalsIgnoreCase(Globals.g_order)) {
                this.getDependOnWebAppList();
            }
            this.populate();
            if (Globals.g_plan != null) {
                this.m_previousPlan = Globals.g_plan.getFile();
            }
            if (Globals.g_machine != null) {
                this.m_previousMachine = Globals.g_machine.getName();
            }
            this.m_previousStepNumber = Globals.g_stepNumber;
            this.m_previousOrder = Globals.g_order;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_findText;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        if (this.m_panelLoaded) {
            int count = 0;
            for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                if (Globals.g_planConfigs[i].equalsIgnoreCase("cfgwizard") || Globals.g_planConfigs[i].equalsIgnoreCase("levconfig")) continue;
                data.add(" CONFIGURE_SELECTION" + Integer.toString(++count) + "=" + Globals.g_planConfigs[i]);
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ArrayList componentIds = this.m_componentTableModel.getComponentIds();
        HashMap components = this.m_componentTableModel.getComponents();
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[componentIds.size()];
        String id = null;
        ComponentData data = null;
        for (int i = 0; i < options.length; ++i) {
            id = (String)componentIds.get(i);
            data = (ComponentData)components.get(id);
            options[i] = new ConsoleMode.SelectionItem(data.getName(), data.doConfig());
        }
        String header = this.bundle.getString("PanelSelectConfigs.ComponentTable.NameColumn.Title.txt");
        int returnCode = ConsoleMode.promptMultiChoice(options, header);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = (String)componentIds.get(i);
                data = (ComponentData)components.get(id);
                data.setConfig(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        this.m_responseProducts = null;
        boolean found = true;
        int productCount = 1;
        String responseProduct = null;
        while (found) {
            responseProduct = Wizard.getResponse("CONFIGURE_SELECTION" + Integer.toString(productCount), null);
            if (responseProduct == null) {
                found = false;
            } else {
                if (productCount == 1) {
                    this.m_responseProducts = new HashMap();
                }
                this.m_responseProducts.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
            }
            ++productCount;
        }
        return valid;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningMessage = new JTextArea(this.bundle.getString("PanelSelectConfigs.WarningMessage.txt"));
        this.m_warningMessage.setEditable(false);
        this.m_warningMessage.setFocusable(false);
        this.m_warningMessage.setLineWrap(true);
        this.m_warningMessage.setWrapStyleWord(true);
        this.m_warningMessage.setOpaque(false);
        this.m_findText = new KitTextField();
        this.m_findText.getDocument().addDocumentListener(new TextChangeListener());
        String mtxt = this.bundle.getString("PanelSelectConfigs.Search.Label.txt");
        this.m_findLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findLabel.setLabelFor(this.m_findText);
        mtxt = this.bundle.getString("PanelSelectConfigs.FindNext.Button.txt");
        this.m_findButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_componentTable = new JTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelSelectConfigs.this.m_componentTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configColumnActionListener = new ConfigColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_configColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_configColumnActionListener);
        this.m_findButton.addActionListener(this);
        this.m_findText.addFocusListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_findLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_findText, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_findButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_warningMessage, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
        this.m_componentTable.getTableHeader().setResizingAllowed(false);
        this.m_componentTable.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_findButton) {
            this.findProductText();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_findText && Globals.g_wizard.getFrame() != null) {
            if (this.m_findText.getText().length() > 0) {
                Globals.g_wizard.getFrame().getRootPane().setDefaultButton(this.m_findButton);
            } else {
                Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_findText && Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
        }
    }

    private void findProductText() {
        int rowFound = -1;
        String findText = this.m_findText.getText().trim().toLowerCase();
        if (findText.length() > 0) {
            ComponentData data;
            String id;
            int i;
            ArrayList componentIds = this.m_componentTableModel.getComponentIds();
            HashMap components = this.m_componentTableModel.getComponents();
            for (i = this.m_componentTable.getSelectedRow() + 1; rowFound == -1 && i < this.m_componentTable.getRowCount(); ++i) {
                id = (String)componentIds.get(i);
                data = (ComponentData)components.get(id);
                if (data.getName().toLowerCase().indexOf(findText) <= -1) continue;
                rowFound = i;
            }
            if (rowFound == -1) {
                for (i = 0; rowFound == -1 && i <= this.m_componentTable.getSelectedRow(); ++i) {
                    id = (String)componentIds.get(i);
                    data = (ComponentData)components.get(id);
                    if (data.getName().toLowerCase().indexOf(findText) <= -1) continue;
                    rowFound = i;
                }
            }
            if (rowFound > -1) {
                this.m_componentTable.setRowSelectionInterval(rowFound, rowFound);
                this.m_componentTable.setColumnSelectionInterval(0, 0);
                this.m_componentTable.scrollRectToVisible(this.m_componentTable.getCellRect(rowFound, 0, true));
            } else {
                String title = Globals.g_wizard.getWizardTitle();
                String message = this.bundle.messageString("PanelSelectConfigs.NotFoundMsg.txt", this.m_findText.getText());
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, title, 1);
            }
        }
    }

    private void populate() {
        if (Globals.g_machine == null || Globals.g_machine.isConfiguredFullySupported()) {
            this.m_warningImage.setVisible(false);
            this.m_warningMessage.setVisible(false);
        } else {
            this.m_warningImage.setVisible(true);
            this.m_warningMessage.setVisible(true);
        }
        this.m_componentTableModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_componentTable);
        if (rowHeight > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
    }

    private void getDependOnWebAppList() {
        try {
            DialogData dialogData = DialogData.getConfigDialogData();
            this.m_dependOnWebAppList = dialogData.getDependenciesOnParent("webappsrv");
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
    }

    class ConfigColumnActionListener
    implements ActionListener {
        ConfigColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectConfigs.this.m_selectAllButton) {
                PanelSelectConfigs.this.m_componentTableModel.selectAllConfig(true);
            } else if (e.getSource() == PanelSelectConfigs.this.m_clearAllButton) {
                PanelSelectConfigs.this.m_componentTableModel.selectAllConfig(false);
            }
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -4051351238955803540L;
        private JCheckBox m_checkBox;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectConfigs.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelSelectConfigs.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(data.getName());
                    this.m_checkBox.setSelected(data.doConfig());
                }
            }
            return this.m_checkBox;
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -187140846803284086L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSelectConfigs.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelSelectConfigs.this.m_componentTableModel.getComponents().get(id);
                    this.setText(data.getName());
                    this.setSelected(data.doConfig());
                }
            }
            return this;
        }
    }

    class ComponentData {
        protected String m_identifier = null;
        protected String m_name = null;
        protected boolean m_configurable = false;
        protected boolean m_config = false;

        public ComponentData(String identifier, String name) {
            this.m_identifier = identifier;
            this.m_name = name;
        }

        public String getIdentifier() {
            return this.m_identifier;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean doConfig() {
            return this.m_config;
        }

        public void setConfig(boolean config) {
            this.m_config = config;
        }
    }

    class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6566146763592495308L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        protected String[] m_columnNames;
        protected HashMap m_components = new HashMap();
        protected ArrayList m_componentIds = new ArrayList();

        public ComponentTableModel() {
            this.m_columnNames = new String[]{PanelSelectConfigs.this.bundle.getString("PanelSelectConfigs.ComponentTable.NameColumn.Title.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            if (index == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                if (colIndex == 0) {
                    return component.doConfig();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null && colIndex == 0) {
                return true;
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                component.setConfig((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            PanelSelectConfigs.this.m_cfgwizardAdd = false;
            PanelSelectConfigs.this.m_levconfigAdd = false;
            PanelSelectConfigs.this.m_cfgwizardPreProd = null;
            PanelSelectConfigs.this.m_levconfigPreProd = null;
            if (Globals.g_mode == 2) {
                PanelSelectConfigs.this.m_cfgwizardAdd = true;
                PanelSelectConfigs.this.m_levconfigAdd = true;
                String[] prodCodes = new String[]{"olapcubesrv", "workspacpool", "storprocsrv", "workspacesrv"};
                ProductData prodData = null;
                ComponentData data = null;
                for (int i = 0; i < prodCodes.length; ++i) {
                    prodData = Globals.g_deploymentData.getProduct(Globals.g_order, prodCodes[i], true);
                    data = new ComponentData(prodCodes[i], prodData.getProdName());
                    data.setConfig(false);
                    this.m_componentIds.add(prodCodes[i]);
                    this.m_components.put(prodCodes[i], data);
                }
            } else {
                boolean processAgain;
                Plan.Machine.Component[] configuredComponents = Globals.g_machine.getConfiguredComponents();
                ConfigStatus.StatusEntry[] statusEntries = null;
                if (Globals.g_reconfigure && Globals.g_configStatus != null) {
                    statusEntries = Globals.g_configStatus.getStatusEntries();
                }
                String webAppCode = null;
                String prodCode = null;
                String prodName = null;
                boolean stepIsForced = false;
                try {
                    Plan depPlan = PlanFactory.getPlanFromFile(new File(Globals.g_plan.getFile()));
                    List<Machine> machList = depPlan.getMachines();
                    for (Machine currMach : machList) {
                        if (!currMach.getName().equalsIgnoreCase(Globals.g_machine.getName())) continue;
                        if (Globals.g_stepNumber != null) {
                            stepIsForced = currMach.isStepForced(Globals.g_stepNumber);
                        }
                        break;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    Logging.log.warning(fnfe.getMessage());
                    Logging.logStackTrace(fnfe);
                }
                catch (ParseException pe) {
                    Logging.log.warning(pe.getMessage());
                    Logging.logStackTrace(pe);
                }
                block5: for (int i = 0; i < configuredComponents.length; ++i) {
                    prodCode = configuredComponents[i].getId();
                    if (prodCode.equalsIgnoreCase("cfgwizard")) {
                        PanelSelectConfigs.this.m_cfgwizardAdd = true;
                        if (i <= 0) continue;
                        PanelSelectConfigs.this.m_cfgwizardPreProd = configuredComponents[i - 1].getId();
                        continue;
                    }
                    if (prodCode.equalsIgnoreCase("levconfig")) {
                        PanelSelectConfigs.this.m_levconfigAdd = true;
                        for (int j = i; j > 0; --j) {
                            Plan.Machine.Component component;
                            if (j <= 0 || (prodCode = (component = configuredComponents[j - 1]).getId()).equalsIgnoreCase("cfgwizard") || !component.isSupported()) continue;
                            PanelSelectConfigs.this.m_levconfigPreProd = prodCode;
                            continue block5;
                        }
                        continue;
                    }
                    if (!configuredComponents[i].isSupported()) continue;
                    prodName = configuredComponents[i].getName();
                    if (Globals.g_debug) {
                        prodName = prodName + " (" + prodCode + ")";
                    }
                    ComponentData data = new ComponentData(prodCode, prodName);
                    if (PanelSelectConfigs.this.m_responseProducts != null) {
                        if (PanelSelectConfigs.this.m_responseProducts.containsKey(prodCode.toLowerCase(Locale.ENGLISH))) {
                            data.setConfig(true);
                        } else {
                            data.setConfig(false);
                        }
                    } else {
                        boolean checked = true;
                        if (Globals.g_stepNumber != null) {
                            checked = configuredComponents[i].isInDeploymentStep(Globals.g_stepNumber);
                        }
                        if (statusEntries != null && !stepIsForced && !Globals.g_resumeChain) {
                            boolean found = false;
                            String code = null;
                            for (int j = 0; j < statusEntries.length && !found; ++j) {
                                code = statusEntries[j].getCode();
                                if (!code.equalsIgnoreCase(prodCode)) continue;
                                found = true;
                                checked = false;
                            }
                        }
                        data.setConfig(checked);
                        if (Utils.isWebAppServerCode(prodCode)) {
                            webAppCode = prodCode;
                        }
                    }
                    this.m_componentIds.add(prodCode);
                    this.m_components.put(prodCode, data);
                }
                boolean bl = processAgain = PanelSelectConfigs.this.m_responseProducts == null;
                while (processAgain) {
                    processAgain = false;
                    for (int i = 0; i < configuredComponents.length; ++i) {
                        Plan.Machine.Component currComp = configuredComponents[i];
                        prodCode = currComp.getId();
                        ComponentData recipientData = (ComponentData)this.m_components.get(prodCode);
                        if (recipientData == null || recipientData.doConfig()) continue;
                        ArrayList<String> signalCodes = new ArrayList<String>(currComp.getSignalConfigs());
                        if (prodCode.equals(webAppCode)) {
                            signalCodes.addAll(PanelSelectConfigs.this.m_dependOnWebAppList);
                        }
                        if (!this.isOneOfTheseSelected(signalCodes)) continue;
                        recipientData.setConfig(true);
                        processAgain = true;
                    }
                }
            }
            Globals.g_planConfigs = this.m_componentIds.toArray(new String[0]);
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectConfigs.this.installRenderers();
            PanelSelectConfigs.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelSelectConfigs.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
        }

        private boolean isOneOfTheseSelected(Collection<String> codeList) {
            boolean oneIsSelected = false;
            if (codeList != null && codeList.size() > 0) {
                Iterator<String> codeIt = codeList.iterator();
                while (!oneIsSelected && codeIt.hasNext()) {
                    String currCode = codeIt.next();
                    ComponentData currData = (ComponentData)this.m_components.get(currCode);
                    if (currData == null || !currData.doConfig()) continue;
                    oneIsSelected = true;
                }
            }
            return oneIsSelected;
        }

        public void selectAllConfig(boolean value) {
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                String id = (String)this.m_componentIds.get(i);
                ComponentData data = (ComponentData)this.m_components.get(id);
                if (data == null) continue;
                data.setConfig(value);
            }
            this.fireTableDataChanged();
        }

        public ArrayList getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap getComponents() {
            return this.m_components;
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        private void setDefaultButton() {
            if (Globals.g_wizard.getFrame() != null) {
                if (PanelSelectConfigs.this.m_findText.getText().length() > 0) {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(PanelSelectConfigs.this.m_findButton);
                } else {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
                }
            }
        }
    }
}

