/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.FileTypeManagementData;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallDefaults;
import com.sas.ssn.Logging;
import com.sas.ssn.OsLevelCheck;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropsParser;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SDMTaskData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.extension.ExtensionException;
import com.sas.tools.installs.extension.ExtensionRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class PanelSDMStart
implements WizardPanelIface,
TreeSelectionListener {
    private final double splitRatio = 0.7;
    private SSNResource bundle = new SSNResource(PanelSDMStart.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JSplitPane m_splitPane = new JSplitPane(0);
    private JTree m_tree = null;
    private JPanel m_text = new JPanel(new GridBagLayout());
    private JTextArea m_labelText = new JTextArea();
    private JTextArea m_taskText = new JTextArea();
    private JCheckBox m_checkBox = new JCheckBox();
    private HashMap<String, SDMTaskData.SDMTask> m_sdmTasks = null;
    private SDMTaskData.SDMGroup m_sdmRootGroup = null;
    private boolean m_panelLoaded = false;
    private boolean m_firstSelected = false;
    private TreeGroup m_treeRoot = null;
    private TreeTask m_selectedTask = null;
    public FileTypeManagementData m_fileTypeData = null;

    public PanelSDMStart() {
        Utils.setSASHome();
        this.initTasks();
        this.initialize();
        Globals.g_jreHome = this.getJreHome();
        Logging.log.fine("g_jreHome=" + Globals.g_jreHome);
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSDMStart.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSDMStart.HeaderDesc.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateData() {
        Globals.g_cmtRemoveContent = null;
        Globals.g_processInstances = true;
        if (this.m_selectedTask != null) {
            String message;
            Globals.g_cmtTask = this.m_selectedTask.getID();
            Globals.g_cmtTaskName = this.m_selectedTask.getName();
            if (!this.isValidUserID()) {
                Globals.g_wizard.exitWizard(-1);
            }
            if (Globals.g_cmtTask == 41 && !(message = this.filePermissionMessage()).isEmpty()) {
                if (Globals.g_quietMode) {
                    Logging.log.info("You must have admin rights or have read/write permission to these folders and all the files they contain. " + message);
                } else {
                    CustMsgBox.showErrorMessage(this.bundle.getString("PanelSDMStart.permissions.txt") + message);
                }
                Globals.g_kit.exitKit(-1);
            }
            if (Utils.getOS() == 1 && Globals.g_cmtSASHome != null) {
                String sasDMExeLocation = Utils.getSDMHome(Globals.g_cmtSASHome) + "\\sasdm.exe";
                OsLevelCheck.isAppCompatFlagsSet(sasDMExeLocation);
            }
            if (this.m_checkBox.isVisible()) {
                this.m_selectedTask.setCheckBox(this.m_checkBox.isSelected());
            }
            if (Globals.g_cmtTask == 2) {
                if (this.m_checkBox.isSelected()) {
                    if (Globals.g_quietMode) {
                        Logging.log.info("User content will be removed for SAS Information Delivery Portal.");
                    } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSDMStart.RemovePortalWarning.txt"), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 1) {
                        return false;
                    }
                    Globals.g_cmtRemoveContent = "true";
                } else {
                    Globals.g_cmtRemoveContent = "false";
                }
            } else if (Globals.g_cmtTask == 28 || Globals.g_cmtTask == 26) {
                Globals.g_processInstances = false;
            }
            Globals.g_dynamicInstallDialogs = null;
            Globals.g_cmtInstallTargets = null;
            Globals.g_cmtInstalls = null;
            Globals.g_cmtRunITTarget = false;
            SDMTaskData.SDMTask task = this.m_sdmTasks.get(this.m_selectedTask.getName());
            if (task != null) {
                this.loadDynamicDialogs(task.getDynamicType(), this.m_selectedTask.getName());
                if (task.getTargets() != null && task.getTargets().length > 0) {
                    Globals.g_cmtInstallTargets = task.getTargets();
                }
                if (task.getReqInstall() != null) {
                    ProductData prodData = null;
                    try (RegistryAccess registryAccess = null;){
                        if (Globals.g_cmtSASHome != null) {
                            File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                            registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                        }
                        if (registryAccess != null && registryAccess.open()) {
                            String reqInstallList = task.getReqInstall().trim();
                            StringTokenizer st = new StringTokenizer(reqInstallList);
                            while (st.hasMoreTokens()) {
                                String prodcode = st.nextToken();
                                prodData = Globals.g_deploymentData.getProduct(Globals.g_order, prodcode, true);
                                if (prodData.getProdCode().equals("hadoopcjars") || prodData.getProdCode().equals("hadoop")) {
                                    if (Globals.g_cmtTask == 50) {
                                        prodData.setProdName(this.bundle.getString("PanelSDMStart.hadoop_epvalidation.short.txt"));
                                    } else if (Globals.g_cmtTask == 47) {
                                        prodData.setProdName(this.bundle.getString("PanelSDMStart.hadoop_tkindbsrv.short.txt"));
                                    } else if (Globals.g_cmtTask == 51) {
                                        prodData.setProdName(this.bundle.getString("PanelSDMStart.hadoop_dmsprkhadp.short.txt"));
                                    } else if (Globals.g_cmtTask == 53) {
                                        prodData.setProdName(this.bundle.getString("PanelSDMStart.hadoop_sasqkb.short.txt"));
                                    } else if (Globals.g_cmtTask == 49) {
                                        prodData.setProdName(this.bundle.getString("PanelSDMStart.hadoop_metadata.short.txt"));
                                    }
                                }
                                String installDir = null;
                                if (prodData != null) {
                                    installDir = registryAccess.getInstallLoc(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform());
                                }
                                if (installDir == null || prodData == null) {
                                    String osSuffix = Utils.getOS_Suffix();
                                    if (osSuffix.equals("lax")) {
                                        osSuffix = "lnx";
                                    } else if (osSuffix.equals("wx6")) {
                                        osSuffix = "win";
                                    }
                                    prodData = Globals.g_deploymentData.getProduct(Globals.g_order, prodcode, osSuffix, true);
                                    if (prodData != null) {
                                        installDir = registryAccess.getInstallLoc(prodData.getProdCode(), prodData.getProdVersion(), osSuffix);
                                    }
                                }
                                if (installDir == null) {
                                    prodData = null;
                                    continue;
                                }
                                if (prodData == null) continue;
                                if (Globals.g_cmtInstalls == null) {
                                    Globals.g_cmtInstalls = new ArrayList();
                                }
                                Globals.g_cmtInstalls.add(prodData);
                            }
                        }
                    }
                }
                Globals.g_cmtRunITTarget = task.isITTarget();
                if (Globals.g_cmtTask == 11) {
                    Globals.g_cmtRunInstall = Globals.g_cmtRunITTarget;
                    Globals.g_cmtRunConfigure = Globals.g_enableConfigTasks;
                } else {
                    Globals.g_cmtRunInstall = false;
                    Globals.g_cmtRunConfigure = false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_applyConfigMaint) {
            display = false;
            Globals.g_cmtTask = 5;
            Globals.g_cmtRemoveContent = null;
            Globals.g_processInstances = true;
        }
        if (Globals.g_renewMode) {
            Globals.g_processInstances = true;
            Globals.g_cmtTask = 41;
            display = false;
        }
        if (Utils.getOS() == 1 && Globals.g_cmtSASHome != null) {
            String sasDMExeLocation = Utils.getSDMHome(Globals.g_cmtSASHome) + "\\sasdm.exe";
            OsLevelCheck.isAppCompatFlagsSet(sasDMExeLocation);
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        SDMTaskData.SDMTask task;
        String panelID = "selectconfigdir";
        if (Globals.g_renewMode) {
            String message = this.filePermissionMessage();
            if (!message.isEmpty()) {
                if (Globals.g_quietMode) {
                    Logging.log.info("You must have admin rights or have read/write permission to these folders and all the files they contain. " + message);
                } else {
                    CustMsgBox.showErrorMessage(this.bundle.getString("PanelSDMStart.permissions.txt") + message);
                }
                Globals.g_kit.exitKit(-1);
            }
            panelID = "selectlicensestorenew";
        } else if (this.m_selectedTask != null && (task = this.m_sdmTasks.get(this.m_selectedTask.getName())) != null) {
            String type = task.getDynamicType();
            if (type != null && type.equalsIgnoreCase("install") && Globals.g_dynamicInstallDialogs != null && Globals.g_dynamicInstallDialogs.length > 0) {
                panelID = task.getEntryPanel();
                if (!(panelID.equalsIgnoreCase("connection") || panelID.equalsIgnoreCase("selectconfigdir") || panelID.equalsIgnoreCase("certificateremove"))) {
                    panelID = Globals.g_dynamicInstallDialogs[0];
                }
            } else {
                panelID = task.getEntryPanel();
            }
        }
        if (panelID.equalsIgnoreCase("selectlicensestorenew") || panelID.equalsIgnoreCase("selectsasfoundationtask")) {
            Globals.g_deploywizDepotLocation = Utils.joinPath(new File(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath(), "postinstall");
            Globals.g_cmtDeploymentData = new DeploymentData(Globals.g_deploywizDepotLocation);
            Globals.g_cmtDeploymentData.loadOrder("000000");
        }
        return panelID;
    }

    private String filePermissionMessage() {
        String sasDir = Utils.joinPath(Globals.g_cmtSASHome, "SASFoundation", Globals.g_majorReleaseVersion);
        String registryDir = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "deploymntreg");
        String installMiscDir = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc");
        StringBuilder message = new StringBuilder();
        if (!Utils.canWriteToPath(sasDir)) {
            message.append(sasDir + "\n");
        }
        if (!Utils.canWriteToPath(registryDir)) {
            message.append(registryDir + "\n");
        }
        if (!Utils.canWriteToPath(installMiscDir)) {
            message.append(installMiscDir + "\n");
        }
        return message.toString();
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (wizardFramework.getFrame() != null) {
                wizardFramework.getFrame().validate();
                this.m_splitPane.setDividerLocation(0.7);
            }
            this.loadResponseData();
            if (this.m_selectedTask != null) {
                this.refreshOptionInfo(this.m_selectedTask);
                if (this.m_tree != null) {
                    int selectedRow = -1;
                    for (int i = 0; i < this.m_tree.getRowCount() && selectedRow == -1; ++i) {
                        TreeTask task;
                        Object node = ((DefaultMutableTreeNode)this.m_tree.getPathForRow(i).getLastPathComponent()).getUserObject();
                        if (node == null || !(node instanceof TreeTask) || !(task = (TreeTask)node).getName().equalsIgnoreCase(this.m_selectedTask.getName())) continue;
                        selectedRow = i;
                    }
                    if (selectedRow > -1) {
                        this.m_tree.setSelectionRow(selectedRow);
                    }
                }
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        String availOptions = "";
        String selectedOption = "";
        String cbResponseName = null;
        String cbValue = null;
        if (this.m_treeRoot != null && this.m_sdmTasks != null) {
            Object node = null;
            Object subNode = null;
            TreeTask task = null;
            TreeGroup group = null;
            for (int i = 0; i < this.m_treeRoot.size(); ++i) {
                node = this.m_treeRoot.get(i);
                if (node == null) continue;
                if (node instanceof TreeTask) {
                    SDMTaskData.SDMTask taskData;
                    task = node;
                    if (availOptions.length() > 0) {
                        availOptions = availOptions + "/";
                    }
                    availOptions = availOptions + task.getName();
                    if (!task.isSelected() || (taskData = this.m_sdmTasks.get(selectedOption = task.getName())) == null || (cbResponseName = taskData.getCheckboxResponseName()) == null || cbResponseName.length() <= 0) continue;
                    if (task.getCheckBox()) {
                        cbValue = "yes";
                        continue;
                    }
                    cbValue = "no";
                    continue;
                }
                if (!(node instanceof TreeGroup)) continue;
                group = node;
                for (int j = 0; j < group.size(); ++j) {
                    SDMTaskData.SDMTask taskData;
                    subNode = group.get(j);
                    if (subNode == null || !(subNode instanceof TreeTask)) continue;
                    task = subNode;
                    if (availOptions.length() > 0) {
                        availOptions = availOptions + "/";
                    }
                    availOptions = availOptions + task.getName();
                    if (!task.isSelected() || (taskData = this.m_sdmTasks.get(selectedOption = task.getName())) == null || (cbResponseName = taskData.getCheckboxResponseName()) == null || cbResponseName.length() <= 0) continue;
                    cbValue = task.getCheckBox() ? "yes" : "no";
                }
            }
        }
        data.add("#MANAGE_TASK=" + availOptions);
        data.add(" MANAGE_TASK=" + selectedOption);
        if (cbResponseName != null && cbResponseName.length() > 0) {
            data.add("#" + cbResponseName + "=" + "yes" + "/" + "no");
            data.add(" " + cbResponseName + "=" + cbValue);
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int j;
        int i;
        TreeGroup group;
        TreeTask task;
        Object subNode;
        Object node;
        int index;
        int selection = 0;
        ArrayList<String> options = new ArrayList<String>();
        if (this.m_treeRoot != null && this.m_sdmTasks != null) {
            index = -1;
            node = null;
            subNode = null;
            task = null;
            group = null;
            for (i = 0; i < this.m_treeRoot.size(); ++i) {
                node = this.m_treeRoot.get(i);
                if (node == null) continue;
                if (node instanceof TreeTask) {
                    task = node;
                    ++index;
                    options.add(task.toString());
                    if (!task.isSelected()) continue;
                    selection = index;
                    continue;
                }
                if (!(node instanceof TreeGroup)) continue;
                group = node;
                ++index;
                options.add("@group@" + group.toString());
                for (j = 0; j < group.size(); ++j) {
                    subNode = group.get(j);
                    if (subNode == null || !(subNode instanceof TreeTask)) continue;
                    task = subNode;
                    ++index;
                    options.add(task.toString());
                    if (!task.isSelected()) continue;
                    selection = index;
                }
            }
        }
        if ((selection = ConsoleMode.promptSingleChoice(options.toArray(new String[0]), null, null, selection)) > -1) {
            if (this.m_treeRoot != null && this.m_sdmTasks != null) {
                index = -1;
                node = null;
                subNode = null;
                task = null;
                group = null;
                for (i = 0; i < this.m_treeRoot.size(); ++i) {
                    node = this.m_treeRoot.get(i);
                    if (node == null) continue;
                    if (node instanceof TreeTask) {
                        task = node;
                        if (++index != selection) continue;
                        if (this.m_selectedTask != null) {
                            this.m_selectedTask.setSelected(false);
                        }
                        task.setSelected(true);
                        this.m_selectedTask = task;
                        continue;
                    }
                    if (!(node instanceof TreeGroup)) continue;
                    group = node;
                    ++index;
                    for (j = 0; j < group.size(); ++j) {
                        subNode = group.get(j);
                        if (subNode == null || !(subNode instanceof TreeTask)) continue;
                        task = subNode;
                        if (++index != selection) continue;
                        if (this.m_selectedTask != null) {
                            this.m_selectedTask.setSelected(false);
                        }
                        task.setSelected(true);
                        this.m_selectedTask = task;
                    }
                }
                if (this.m_selectedTask != null) {
                    this.refreshOptionInfo(this.m_selectedTask);
                }
            }
            if (this.m_checkBox.isVisible()) {
                selection = ConsoleMode.promptBoolean(this.m_checkBox);
            }
        }
        return selection;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("MANAGE_TASK", null);
        if (response != null && this.m_treeRoot != null && this.m_sdmTasks != null) {
            Object node = null;
            Object subNode = null;
            TreeTask task = null;
            TreeGroup group = null;
            for (int i = 0; i < this.m_treeRoot.size() && !valid; ++i) {
                node = this.m_treeRoot.get(i);
                if (node == null) continue;
                if (node instanceof TreeTask) {
                    String cbResponseName;
                    task = node;
                    if (!response.equalsIgnoreCase(task.getName())) continue;
                    valid = true;
                    if (this.m_selectedTask != null) {
                        this.m_selectedTask.setSelected(false);
                    }
                    task.setSelected(true);
                    this.m_selectedTask = task;
                    SDMTaskData.SDMTask taskData = this.m_sdmTasks.get(task.getName());
                    if (taskData == null || (cbResponseName = taskData.getCheckboxResponseName()) == null || cbResponseName.length() <= 0) continue;
                    String cbResponse = Wizard.getResponse(cbResponseName, null);
                    if (cbResponse != null) {
                        if (cbResponse.equalsIgnoreCase("yes")) {
                            task.setCheckBox(true);
                            continue;
                        }
                        if (cbResponse.equalsIgnoreCase("no")) {
                            task.setCheckBox(false);
                            continue;
                        }
                        valid = false;
                        Wizard.logResponseInvalid(this.getHeader(), cbResponseName, cbResponse, null);
                        continue;
                    }
                    valid = false;
                    Wizard.logResponseMissing(this.getHeader(), cbResponseName);
                    continue;
                }
                if (!(node instanceof TreeGroup)) continue;
                group = node;
                for (int j = 0; j < group.size(); ++j) {
                    String cbResponseName;
                    subNode = group.get(j);
                    if (subNode == null || !(subNode instanceof TreeTask) || !response.equalsIgnoreCase((task = (TreeTask)subNode).getName())) continue;
                    valid = true;
                    if (this.m_selectedTask != null) {
                        this.m_selectedTask.setSelected(false);
                    }
                    task.setSelected(true);
                    this.m_selectedTask = task;
                    SDMTaskData.SDMTask taskData = this.m_sdmTasks.get(task.getName());
                    if (taskData == null || (cbResponseName = taskData.getCheckboxResponseName()) == null || cbResponseName.length() <= 0) continue;
                    String cbResponse = Wizard.getResponse(cbResponseName, null);
                    if (cbResponse != null) {
                        if (cbResponse.equalsIgnoreCase("yes")) {
                            task.setCheckBox(true);
                            continue;
                        }
                        if (cbResponse.equalsIgnoreCase("no")) {
                            task.setCheckBox(false);
                            continue;
                        }
                        valid = false;
                        Wizard.logResponseInvalid(this.getHeader(), cbResponseName, cbResponse, null);
                        continue;
                    }
                    valid = false;
                    Wizard.logResponseMissing(this.getHeader(), cbResponseName);
                }
            }
        } else if (response == null && Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "MANAGE_TASK");
        }
        return valid;
    }

    private void initialize() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        this.m_infoText = new JTextArea(this.bundle.getString("PanelSDMStart.Info.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        this.m_firstSelected = false;
        this.m_treeRoot = this.getTreeNodes(this.m_sdmRootGroup);
        this.m_tree = new JTree(this.m_treeRoot);
        this.m_tree.setEditable(false);
        this.m_tree.putClientProperty("JTree.lineStyle", "None");
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(new NodeRenderer());
        this.m_tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.m_tree);
        JScrollPane textView = new JScrollPane(this.m_text);
        this.initializeOptionInfo();
        this.m_splitPane.setTopComponent(treeView);
        this.m_splitPane.setBottomComponent(textView);
        treeView.setMinimumSize(new Dimension(80, 60));
        textView.setMinimumSize(new Dimension(80, 60));
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_splitPane, c);
        for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
            this.m_tree.expandRow(i);
        }
    }

    private void initializeOptionInfo() {
        GridBagConstraints c = new GridBagConstraints();
        this.m_labelText.setEditable(false);
        this.m_labelText.setFocusable(false);
        this.m_labelText.setLineWrap(true);
        this.m_labelText.setWrapStyleWord(true);
        this.m_labelText.setOpaque(false);
        this.m_labelText.setFont(this.m_labelText.getFont().deriveFont(1));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 5);
        this.m_text.add((Component)this.m_labelText, c);
        this.m_taskText.setEditable(false);
        this.m_taskText.setFocusable(false);
        this.m_taskText.setLineWrap(true);
        this.m_taskText.setWrapStyleWord(true);
        this.m_taskText.setOpaque(false);
        c.gridy = 1;
        c.insets = new Insets(5, 15, 0, 5);
        this.m_text.add((Component)this.m_taskText, c);
        this.m_checkBox.setVisible(false);
        c.gridy = 2;
        c.insets = new Insets(5, 15, 0, 5);
        this.m_text.add((Component)this.m_checkBox, c);
        JTextArea filler = new JTextArea();
        filler.setEditable(false);
        filler.setFocusable(false);
        filler.setLineWrap(true);
        filler.setWrapStyleWord(true);
        filler.setOpaque(false);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_text.add((Component)filler, c);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            TreeTask task;
            if (this.m_selectedTask != null) {
                this.m_selectedTask.setSelected(false);
                if (this.m_checkBox.isVisible()) {
                    this.m_selectedTask.setCheckBox(this.m_checkBox.isSelected());
                }
            }
            if ((task = (TreeTask)node.getUserObject()) != null) {
                this.m_selectedTask = task;
                this.m_selectedTask.setSelected(true);
                this.refreshOptionInfo(task);
            }
            ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(node);
        }
        this.m_tree.repaint();
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        File helpFile = new File(Globals.g_tempLocation, "PanelSDMStart.html");
        try {
            PrintStream out = new PrintStream((OutputStream)new FileOutputStream(helpFile), false, "UTF-8");
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
            out.println("<HTML>");
            out.println("<head>");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</head>");
            out.println("<BODY>");
            out.println("<H1>" + this.getHeader() + "</H1>");
            out.println("<p>" + this.getHeaderDesc() + "</p>");
            out.println("<dl>");
            if (this.m_tree != null) {
                String taskName = null;
                String taskCBName = null;
                for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
                    Object node = ((DefaultMutableTreeNode)this.m_tree.getPathForRow(i).getLastPathComponent()).getUserObject();
                    if (node == null || !(node instanceof TreeTask)) continue;
                    TreeTask task = (TreeTask)node;
                    taskName = task.getName();
                    out.println("<dt><b>" + this.bundle.getString("PanelSDMStart." + taskName + ".label.txt") + "</b></dt>");
                    out.println("<dd>" + this.bundle.getString("PanelSDMStart." + taskName + ".help.txt") + "</dd>");
                    SDMTaskData.SDMTask taskData = this.m_sdmTasks.get(taskName);
                    taskCBName = taskData.getCheckbox();
                    if (taskCBName == null || taskCBName.length() <= 0) continue;
                    out.println("<dd>" + this.bundle.getString("PanelSDMStart." + taskName + "." + taskCBName + ".help.txt") + "</dd>");
                }
            }
            out.println("</dl>");
            out.println("<p>" + this.bundle.getString("PanelSDMStart.Footer.txt") + "</p>");
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
            helpTopic = helpFile.toString();
        }
        catch (Exception e) {
            Logging.log.warning("Error creating help file: " + helpFile.toString());
            Logging.logStackTrace(e);
        }
        return helpTopic;
    }

    private void initTasks() {
        File taskFile = null;
        if (Globals.g_sdmTaskFile != null) {
            taskFile = new File(Globals.g_sdmTaskFile);
        } else {
            String taskFileDir = Globals.g_startupLocation + File.separator + "product_data" + File.separator + Globals.g_deploymentData.getNewestSpsSku("deploywiz", null, true).getSpsSku() + File.separator + "install";
            taskFile = new File(taskFileDir, "SDMTasks.xml");
        }
        if (taskFile.isFile()) {
            Logging.log.fine("Task data file: " + taskFile.getAbsolutePath());
            try {
                SDMTaskData taskData = new SDMTaskData(taskFile);
                this.m_sdmTasks = taskData.getSDMTasks();
                this.m_sdmRootGroup = taskData.getSDMRootGroup();
            }
            catch (Exception e) {
                Logging.log.severe("Error loading task data file.");
                Logging.logStackTrace(e);
            }
        } else {
            Logging.log.severe("Error loading task data file: " + taskFile.toString());
        }
    }

    private TreeGroup getTreeNodes(SDMTaskData.SDMGroup group) {
        Vector<SDMTaskData.SDMGroup> subGroups;
        TreeGroup treeGroup = new TreeGroup(group.getName());
        Vector<String> tasks = group.getTasks();
        if (tasks != null) {
            boolean hasConfigDirs = false;
            RegistryAccess regAccess = null;
            try {
                File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                regAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
            }
            catch (Exception e) {
                regAccess = null;
                Logging.logStackTrace(e);
            }
            if (regAccess != null && regAccess.open()) {
                Globals.g_order = regAccess.getLastOrder();
                if (Globals.g_enableConfigTasks) {
                    hasConfigDirs = true;
                } else {
                    String[] configDirs = regAccess.getConfigLocs();
                    if (configDirs != null && configDirs.length > 0) {
                        for (int i = 0; !hasConfigDirs && i < configDirs.length; ++i) {
                            for (int j = 0; !hasConfigDirs && j < Globals.g_configLevels.length; ++j) {
                                File statusFile;
                                File fullDir = new File(configDirs[i], Globals.g_configLevels[j]);
                                if (!fullDir.isDirectory() || !(statusFile = new File(Utils.joinPath(fullDir.toString(), "ConfigData"), "status.xml")).isFile()) continue;
                                hasConfigDirs = true;
                            }
                        }
                    }
                }
            } else {
                regAccess = null;
            }
            Globals.g_enableConfigTasks = hasConfigDirs;
            String taskName = null;
            SDMTaskData.SDMTask taskData = null;
            TreeTask task = null;
            String checkboxID = null;
            String[] osTypes = null;
            boolean valid = true;
            for (int i = 0; i < tasks.size(); ++i) {
                String reqInstallList;
                taskName = tasks.get(i);
                taskData = this.m_sdmTasks.get(taskName);
                valid = taskData.isEnabled();
                if (valid && taskData.getMetaserver()) {
                    valid = hasConfigDirs;
                }
                if (valid && (reqInstallList = taskData.getReqInstall()) != null) {
                    StringTokenizer st = new StringTokenizer(reqInstallList.trim());
                    while (valid && st.hasMoreTokens()) {
                        String prodcode = st.nextToken();
                        if (prodcode == null || regAccess == null) continue;
                        boolean foundReq = false;
                        String[] hosts = regAccess.getInstallHosts();
                        for (int j = 0; j < hosts.length; ++j) {
                            String[] versions = regAccess.getInstallVersions(prodcode, hosts[j]);
                            if (versions == null || versions.length <= 0) continue;
                            foundReq = true;
                            break;
                        }
                        valid = foundReq;
                    }
                }
                if (valid && (osTypes = taskData.getOSType()) != null && osTypes.length > 0) {
                    valid = false;
                    for (int j = 0; j < osTypes.length && !valid; ++j) {
                        if (osTypes[j].equalsIgnoreCase("win")) {
                            if (Utils.getOS() != 1) continue;
                            valid = true;
                            continue;
                        }
                        if (osTypes[j].equalsIgnoreCase("unx")) {
                            if (Utils.getOS() == 1 || Utils.getOS() == 8 || Utils.getOS() == 10) continue;
                            valid = true;
                            continue;
                        }
                        if (!osTypes[j].equalsIgnoreCase("zos") || Utils.getOS() != 8 && Utils.getOS() != 10) continue;
                        valid = true;
                    }
                }
                if (valid && taskData.getName().equalsIgnoreCase("filetypes")) {
                    File extReg;
                    if (Globals.g_fileTypeData == null) {
                        Globals.g_fileTypeData = new FileTypeManagementData();
                    }
                    if ((extReg = new File(Globals.g_cmtSASHome, "InstallMisc\\extensionRegistry.xml")).exists()) {
                        try {
                            Globals.g_extensionRegistry = new ExtensionRegistry(extReg);
                            boolean bl = valid = Globals.g_fileTypeData.extensionProductsInstalled(regAccess) > 0;
                            if (valid && Globals.g_fileTypeData.getInstalledSharedExtensions(regAccess).size() < 2) {
                                Globals.g_fileTypeData.setManageByFiletype(true);
                            }
                        }
                        catch (ExtensionException e) {
                            Globals.g_extensionRegistry = null;
                            Logging.log.warning("An error occurred while loading the extension registry " + extReg.getAbsolutePath());
                            valid = false;
                        }
                    } else {
                        valid = false;
                        Logging.log.info("Not using Manage SAS File Types. " + extReg.getAbsolutePath() + " not found.");
                    }
                }
                if (!valid) continue;
                task = new TreeTask(taskName, taskData.getID());
                checkboxID = taskData.getCheckbox();
                if (checkboxID != null && checkboxID.length() > 0) {
                    task.setCheckBox(taskData.getCheckboxDefault());
                }
                if (!this.m_firstSelected) {
                    this.m_firstSelected = true;
                    task.setSelected(true);
                    this.m_selectedTask = task;
                }
                treeGroup.addTreeTask(task);
            }
            if (regAccess != null) {
                regAccess.close();
            }
        }
        if ((subGroups = group.getSubGroups()) != null) {
            TreeGroup subGroup = null;
            for (int i = 0; i < subGroups.size(); ++i) {
                subGroup = this.getTreeNodes(subGroups.get(i));
                if (subGroup.getTaskCount() <= 0) continue;
                treeGroup.addTreeGroup(this.getTreeNodes(subGroups.get(i)));
            }
        }
        return treeGroup;
    }

    private void refreshOptionInfo(TreeTask treeTask) {
        String taskName = treeTask.getName();
        SDMTaskData.SDMTask task = this.m_sdmTasks.get(taskName);
        this.m_labelText.setText(this.bundle.getString("PanelSDMStart." + taskName + ".label.txt"));
        this.m_taskText.setText(this.bundle.getString("PanelSDMStart." + taskName + ".info.txt"));
        String checkboxID = task.getCheckbox();
        if (checkboxID != null && checkboxID.length() > 0) {
            boolean selected = task.getCheckboxDefault();
            String mtxt = this.bundle.getString("PanelSDMStart." + taskName + "." + checkboxID + ".label.txt");
            this.m_checkBox.setText(Util.getLabelWithoutMnemonic(mtxt));
            this.m_checkBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_checkBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_checkBox.setSelected(treeTask.getCheckBox());
            this.m_checkBox.setVisible(true);
        } else {
            this.m_checkBox.setVisible(false);
        }
        this.m_text.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDynamicDialogs(String type, String taskName) {
        if (type != null && type.equalsIgnoreCase("install") || Globals.g_cmtTask == 28 || Globals.g_cmtTask == 11 || Globals.g_cmtTask == 6) {
            Globals.g_installData.load(Globals.g_cmtSASHome);
            Globals.g_installDefaults = new InstallDefaults();
            Globals.g_installData.setProperty("os.localhost.fqdn.host.name", ConfigureData.getDefaultHost());
            Globals.g_installData.setProperty("os.localhost.host.name", ConfigureData.getHostName());
            Globals.g_installData.setProperty("os.localhost.machine.type", Utils.getOS_Suffix());
            Globals.g_installData.setProperty("os.localhost.user.home.dir", System.getProperty("user.home"));
            Globals.g_installData.setProperty("sas.home.dir", Globals.g_cmtSASHome);
            Globals.g_installData.setProperty("wizard.type", "sdm");
            Globals.g_installData.setProperty("wizard.manager.task", taskName);
            String cfgwizardInstallDir = Globals.g_startupLocation + File.separator + "products" + File.separator + Globals.g_deploymentData.getNewestSpsSku("cfgwizard", null, false).getSpsSku();
            Globals.g_installData.setProperty("cfgwizard.install.dir", cfgwizardInstallDir);
            StringTokenizer DEFAULT_PRODDIR_TOKENS = new StringTokenizer("deployagent deployagtclt");
            try (RegistryAccess registryAccess = RegistryAccess.getRegistryAccess();){
                if (registryAccess != null && registryAccess.open()) {
                    while (DEFAULT_PRODDIR_TOKENS.hasMoreTokens()) {
                        String installDir;
                        String prodcode = DEFAULT_PRODDIR_TOKENS.nextToken();
                        ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, prodcode, true);
                        if (prodData == null || (installDir = registryAccess.getInstallLoc(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform())) == null) continue;
                        Globals.g_installData.setProperty(prodcode + ".install.dir", installDir);
                    }
                }
            }
            if (Utils.getOS() == 1) {
                String winUtilitiesDir = Globals.g_startupLocation + File.separator + "products" + File.separator + Globals.g_deploymentData.getNewestSpsSku("cfgwizard", null, false).getSpsSku() + File.separator + "Utilities" + File.separator + Utils.getOS_Suffix();
                Globals.g_installData.setProperty("windows.utilities.dir", winUtilitiesDir);
            }
            if (Utils.getOS_Suffix() == "mvs") {
                if (Globals.g_z64) {
                    Globals.g_installData.setProperty("zos.bit.count", "64");
                } else {
                    Globals.g_installData.setProperty("zos.bit.count", "31");
                }
            }
            DynamicDialogs.createDialogs(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJreHome() {
        String installDir;
        block13: {
            Object prodData = null;
            installDir = null;
            try (RegistryAccess registryAccess = null;){
                if (Globals.g_cmtSASHome == null) break block13;
                File sasswFile = new File(Globals.g_cmtSASHome, "sassw.config");
                if (sasswFile.isFile()) {
                    PropsParser sasswINIFile = new PropsParser(true);
                    try {
                        sasswINIFile.load(sasswFile, null);
                        installDir = sasswINIFile.getINIValue("properties", "JREHOME", null);
                        Logging.log.fine("javaexe=" + installDir);
                        File javafile = new File(sasswINIFile.getINIValue("properties", "JREHOME", null));
                        if (javafile.isFile()) {
                            javafile = javafile.getParentFile().getParentFile();
                        }
                        installDir = javafile.isDirectory() ? javafile.getPath() : null;
                        Logging.log.fine("JREHOME=" + installDir + " in " + sasswFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        Logging.log.warning("JREHOME does not exist in " + sasswFile.getName());
                        Logging.logStackTrace(e);
                    }
                }
                if (installDir == null) {
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    String host = Utils.getOS_Suffix();
                    if (registryAccess != null && registryAccess.open()) {
                        String[] versions = registryAccess.getInstallVersions("javaruntime", host);
                        for (int i = 0; i < versions.length && installDir == null; ++i) {
                            installDir = registryAccess.getInstallLoc("javaruntime", versions[i], host);
                            Logging.log.info("JREHOME=" + installDir + " in " + deployRegJar.getName());
                        }
                    }
                }
            }
        }
        return installDir;
    }

    private boolean isValidUserID() {
        boolean valid = true;
        String user = "";
        String lastUser = "";
        if (Globals.g_cmtTask == 41 && Utils.getOS() == 1) {
            return true;
        }
        if (!(Globals.g_recordMode && Globals.g_recordOnly || Globals.g_cmtSASHome == null || Globals.g_cmtSASHome.length() <= 0)) {
            user = Utils.getOS() == 1 ? Utils.getUserDomain() + "\\" + System.getProperty("user.name") : System.getProperty("user.name");
            if (Utils.getOS() == 1) {
                if (!Globals.g_skipAdminCheck) {
                    valid = Utils.isAdmin(user);
                }
            } else {
                block17: {
                    RegistryAccess registryAccess = null;
                    try {
                        RegistryData.setRegistry(Globals.g_cmtSASHome);
                        registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        if (registryAccess != null && registryAccess.open()) {
                            lastUser = registryAccess.getInstallUser();
                            registryAccess.close();
                        } else {
                            Logging.log.warning("Unable to open the SAS registry.  The registry is either corrupted, or your id is not authorized to access it.");
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Exception in accessing the registry: " + e);
                        if (registryAccess == null) break block17;
                        registryAccess.close();
                    }
                }
                if (lastUser == "") {
                    valid = false;
                }
                if (valid && user != "" && lastUser != "" && !user.equals(lastUser)) {
                    Logging.log.warning("The current user (" + user + ") is not the same user that last installed to this SAS Home location: " + lastUser);
                    if (!Globals.g_skipAdminCheck) {
                        valid = false;
                    }
                }
            }
            if (!valid) {
                String msg = "";
                String logMsg = "";
                int os = Utils.getOS();
                if (os == 1) {
                    msg = this.bundle.messageString("PanelSDMStart.SASUserMsg.Win.txt", user, lastUser);
                    logMsg = "This user account " + user + " does not have sufficient rights to perform SAS Software Deployment Manager tasks.  The user must be an administrator.";
                } else {
                    msg = lastUser == "" ? this.bundle.messageString("PanelSDMStart.SASUserMsg.Unix2.txt", user) : this.bundle.messageString("PanelSDMStart.SASUserMsg.Unix.txt", user, lastUser);
                    logMsg = "The current user (" + user + ") is not the same user that last installed to the SAS Home location specified: " + lastUser;
                }
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "SAS_HOME", Globals.g_cmtSASHome, logMsg);
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), msg, this.bundle.getString("Common.Error.txt"), 0);
                }
            }
        }
        return valid;
    }

    class TreeTask {
        private String m_name = null;
        private int m_id = 0;
        private String m_text = null;
        private boolean m_selected = false;
        private boolean m_checkBox = false;

        public TreeTask(String name, int id) {
            this.m_name = name;
            this.m_id = id;
            this.m_text = PanelSDMStart.this.bundle.getString("PanelSDMStart." + this.m_name + ".label.txt");
        }

        public TreeTask(String name, int id, boolean selected) {
            this.m_name = name;
            this.m_id = id;
            this.m_text = PanelSDMStart.this.bundle.getString("PanelSDMStart." + this.m_name + ".label.txt");
            this.m_selected = selected;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
            this.m_text = PanelSDMStart.this.bundle.getString("PanelSDMStart." + this.m_name + ".label.txt");
        }

        public int getID() {
            return this.m_id;
        }

        public String getText() {
            return this.m_text;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public boolean getCheckBox() {
            return this.m_checkBox;
        }

        public void setCheckBox(boolean checked) {
            this.m_checkBox = checked;
        }

        public String toString() {
            return this.m_text;
        }
    }

    class TreeGroup
    extends Vector {
        private int m_taskCount = 0;
        private int m_groupCount = 0;
        private String m_name = null;
        private String m_text = null;

        public TreeGroup(String name) {
            this.m_name = name;
            this.m_text = PanelSDMStart.this.bundle.getString("PanelSDMStart." + this.m_name + ".label.txt");
        }

        public TreeGroup(String name, TreeTask[] elements) {
            this.m_name = name;
            this.m_text = PanelSDMStart.this.bundle.getString("PanelSDMStart." + this.m_name + ".label.txt");
            for (int i = 0; i < elements.length; ++i) {
                this.add(elements[i]);
            }
            this.m_taskCount = elements.length;
        }

        public void addTreeTask(TreeTask task) {
            this.add(task);
            ++this.m_taskCount;
        }

        public void addTreeGroup(TreeGroup group) {
            this.add(group);
            ++this.m_groupCount;
        }

        public int getTaskCount() {
            return this.m_taskCount;
        }

        public int getGroupCount() {
            return this.m_groupCount;
        }

        public String getName() {
            return this.m_name;
        }

        @Override
        public String toString() {
            return this.m_text;
        }
    }

    class NodeRenderer
    extends JTree
    implements TreeCellRenderer {
        private JRadioButton m_radioCell = new JRadioButton();
        private DefaultTreeCellRenderer m_branchCell = new DefaultTreeCellRenderer();
        private Color m_textForeground = UIManager.getColor("Tree.textForeground");
        private Color m_textBackground = UIManager.getColor("Tree.textBackground");

        public NodeRenderer() {
            this.m_radioCell.setForeground(this.m_textForeground);
            this.m_radioCell.setBackground(this.m_textBackground);
            this.m_branchCell.setForeground(this.m_textForeground);
            this.m_branchCell.setBackground(this.m_textBackground);
            this.m_branchCell.setBackgroundSelectionColor(this.m_textBackground);
            this.m_branchCell.setBorderSelectionColor(this.m_textBackground);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = null;
            if (leaf) {
                Object userObject;
                if (value != null && value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof TreeTask) {
                    TreeTask task = (TreeTask)userObject;
                    this.m_radioCell.setText(task.getText());
                    this.m_radioCell.setSelected(task.isSelected());
                    if (task.isSelected()) {
                        this.m_radioCell.setFont(UIManager.getFont("Tree.font").deriveFont(1));
                    } else {
                        this.m_radioCell.setFont(UIManager.getFont("Tree.font"));
                    }
                }
                component = this.m_radioCell;
            } else {
                component = this.m_branchCell.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                this.m_branchCell.setForeground(this.m_textForeground);
            }
            return component;
        }
    }
}

