/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelSAW
implements WizardPanelIface {
    private final String RESPONSE_STANDARD = "standard";
    private final String RESPONSE_CLIENT = "client";
    private final String RESPONSE_PERSONAL = "personal";
    private SSNResource bundle = new SSNResource(PanelSAW.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_standardOption = null;
    private JTextArea m_standardText = null;
    private JRadioButton m_clientOption = null;
    private JTextArea m_clientText = null;
    private JRadioButton m_personalOption = null;
    private JTextArea m_personalText = null;
    private boolean m_panelLoaded = false;
    private boolean m_displayPanel = false;

    public PanelSAW() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSAW.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSAW.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_ssdType = this.m_clientOption.isSelected() ? 1 : (this.m_personalOption.isSelected() ? 2 : 0);
        if (!Globals.g_quietMode) {
            Globals.g_wizardData.setPreference("DepotOption", Globals.g_ssdType);
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        this.m_displayPanel = false;
        if (Globals.g_skipPlanning || !Globals.g_deploymentData.getOrder(Globals.g_order).isPlanning()) {
            String osSuffix = Utils.getOS_Suffix();
            if (osSuffix.equals("win")) {
                this.m_displayPanel = Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", false) != null;
            } else if (osSuffix.equals("wx6")) {
                this.m_displayPanel = Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", false) != null || Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", "win", false) != null;
            }
        }
        return this.m_displayPanel;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = !this.m_displayPanel || this.m_standardOption.isSelected() ? "selectfullorsubset" : "selectmode";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        Globals.g_sasinstallPlat = null;
        if (Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "adminwizard", false) == null) {
            Globals.g_sasinstallPlat = "win";
        }
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                int depotOption = Globals.g_wizardData.getPreference("DepotOption", 0);
                if (depotOption == 1) {
                    this.m_clientOption.setSelected(true);
                } else if (depotOption == 2) {
                    this.m_personalOption.setSelected(true);
                } else {
                    this.m_standardOption.setSelected(true);
                }
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#DEPOT_OPTION=standard/client/personal", " DEPOT_OPTION=standard"};
        if (this.m_panelLoaded) {
            if (this.m_clientOption.isSelected()) {
                data[1] = " DEPOT_OPTION=client";
            } else if (this.m_personalOption.isSelected()) {
                data[1] = " DEPOT_OPTION=personal";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_standardOption, this.m_clientOption, this.m_personalOption};
        JTextArea[] infos = new JTextArea[]{this.m_standardText, this.m_clientText, this.m_personalText};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("DEPOT_OPTION", null);
        if (response != null) {
            if (response.equalsIgnoreCase("standard")) {
                valid = true;
                this.m_standardOption.setSelected(true);
            } else if (response.equalsIgnoreCase("client")) {
                valid = true;
                this.m_clientOption.setSelected(true);
            } else if (response.equalsIgnoreCase("personal")) {
                valid = true;
                this.m_personalOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "DEPOT_OPTION", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "DEPOT_OPTION");
        }
        return valid;
    }

    private void initialize() {
        String mtxt = this.bundle.getString("PanelSAW.StandardOption.txt");
        this.m_standardOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_standardOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_standardOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_standardOption.getFont();
        this.m_standardOption.setFont(optionFont.deriveFont(1));
        this.m_standardText = new JTextArea(this.bundle.getString("PanelSAW.StandardText.txt"));
        this.m_standardText.setEditable(false);
        this.m_standardText.setFocusable(false);
        this.m_standardText.setLineWrap(true);
        this.m_standardText.setWrapStyleWord(true);
        this.m_standardText.setOpaque(false);
        mtxt = this.bundle.getString("PanelSAW.ClientOption.txt");
        this.m_clientOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clientOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clientOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_clientOption.getFont();
        this.m_clientOption.setFont(optionFont.deriveFont(1));
        this.m_clientText = new JTextArea(this.bundle.getString("PanelSAW.ClientText.txt"));
        this.m_clientText.setEditable(false);
        this.m_clientText.setFocusable(false);
        this.m_clientText.setLineWrap(true);
        this.m_clientText.setWrapStyleWord(true);
        this.m_clientText.setOpaque(false);
        mtxt = this.bundle.getString("PanelSAW.PersonalOption.txt");
        this.m_personalOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_personalOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_personalOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_personalOption.getFont();
        this.m_personalOption.setFont(optionFont.deriveFont(1));
        this.m_personalText = new JTextArea(this.bundle.getString("PanelSAW.PersonalText.txt"));
        this.m_personalText.setEditable(false);
        this.m_personalText.setFocusable(false);
        this.m_personalText.setLineWrap(true);
        this.m_personalText.setWrapStyleWord(true);
        this.m_personalText.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_standardOption);
        group.add(this.m_clientOption);
        group.add(this.m_personalOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_standardOption, c);
        c.gridy = 1;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_standardText, c);
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_clientOption, c);
        c.gridy = 3;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_clientText, c);
        c.gridy = 4;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_personalOption, c);
        c.gridy = 5;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_personalText, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

