/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MigrationMatrixReport;
import com.sas.ssn.MigrationSchema;
import com.sas.ssn.ProductData;
import com.sas.ssn.SASManifest;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.Manifest;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelMigrate
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelMigrate.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JCheckBox m_migrateCheckBox = null;
    private JLabel m_smuPackageLabel = null;
    private KitTextField m_smuPackage = null;
    private KitBrowseButton m_browseButton = null;
    private boolean m_panelLoaded = false;
    private String m_previousSchema = "";
    private String m_sdmtask = "";

    public PanelMigrate(String sdmTask) {
        this.m_sdmtask = sdmTask;
        this.initialize();
        this.layoutWidgets();
    }

    public PanelMigrate() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelMigrate" + this.m_sdmtask + ".Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelMigrate" + this.m_sdmtask + ".HeaderDesc.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateData() {
        boolean valid = true;
        String smuPackage = "";
        String smuGUID = "";
        String smuSASVersion = "";
        Object smuTierDir = null;
        ArrayList<String> planConfigs = null;
        if (this.m_migrateCheckBox.isSelected()) {
            ConfigStatus.StatusEntry[] statusEntries;
            smuPackage = Utils.trimTrailingSlashes(this.m_smuPackage.getText());
            this.m_smuPackage.setText(smuPackage);
            String errMsg = null;
            if (smuPackage.length() == 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "MIGRATION_PACKAGE");
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelMigrate.SMUPackageFieldName.txt"));
                }
            }
            if (valid && !this.getSMUMachines(smuPackage)) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "MIGRATION_PACKAGE", smuPackage, null);
                } else {
                    errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelMigrate.SMUPackageFieldName.txt"));
                }
            }
            if (valid) {
                String invalidMachines = "";
                boolean isInvalid = false;
                String TRUE = "true";
                for (int i = 0; i < Globals.g_smuMachines.length; ++i) {
                    String machine = Globals.g_smuMachines[i];
                    File smuPropFile = new File(smuPackage, machine + File.separator + "smu.properties");
                    if (!smuPropFile.exists()) continue;
                    Properties smuProps = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(smuPropFile);
                        smuProps.load(fis);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String invalid = smuProps.getProperty("SMU.package.is_invalid");
                    if (!TRUE.equalsIgnoreCase(invalid)) continue;
                    isInvalid = true;
                    invalidMachines = invalidMachines + "\t" + machine + "\n";
                }
                if (isInvalid) {
                    valid = false;
                    Logging.log.severe("Migration package: the following tiers are the smu package are invalid\n" + invalidMachines);
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "MIGRATION_PACKAGE", smuPackage, null);
                    } else {
                        errMsg = this.bundle.messageString("PanelMigrate.InvalidSMUPackageTiers.txt", invalidMachines);
                    }
                }
            }
            if (valid) {
                ArrayList machines = null;
                machines = Globals.g_migrationSchema.getOrigMachines(false);
                machines.addAll(Globals.g_migrationSchema.getOrigMachines(true));
                MigrationMatrixReport matrix = new MigrationMatrixReport(smuPackage, machines.toArray(new String[0]));
                ArrayList<MigrationMatrixReport.MatrixReportProduct> incompatibilities = matrix.checkIncompatibilities(Globals.g_deploymentData.getAllProducts(Globals.g_order, true));
                if (!incompatibilities.isEmpty()) {
                    String products = "";
                    for (int i = 0; i < incompatibilities.size(); ++i) {
                        MigrationMatrixReport.MatrixReportProduct data = incompatibilities.get(i);
                        products = products + "\t" + data.getName() + "\n";
                    }
                    if (Globals.g_forceMigration) {
                        Logging.log.warning("User forced migration: Migration package selected has the following incompatibilities, " + products);
                    } else {
                        valid = false;
                        Logging.log.severe("Migration package: matrix incompatibilities found for\n" + products);
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "MIGRATION_PACKAGE", smuPackage, null);
                        } else {
                            errMsg = this.bundle.messageString("PanelMigrate.MigrationMatrixIncompatibilities.txt", products);
                        }
                    }
                }
            }
            if (valid) {
                boolean bskipVerChk = false;
                File manifestPropertiesFile = null;
                Properties manifestProperties = new Properties();
                manifestPropertiesFile = new File(smuPackage, "manifest.properties");
                try {
                    if (manifestPropertiesFile.isFile()) {
                        FileInputStream fis = new FileInputStream(manifestPropertiesFile);
                        manifestProperties.load(fis);
                        fis.close();
                    } else {
                        Logging.log.warning("Migration package: Manifest.properties file does not exist: " + manifestPropertiesFile.toString());
                        errMsg = this.bundle.getString("PanelMigrate.SMUPackageVersionMismatch.txt");
                        valid = false;
                    }
                }
                catch (Exception e) {
                    Logging.log.warning("Migration package: Error loading manifest.properties file: " + manifestPropertiesFile.toString());
                    errMsg = this.bundle.getString("PanelMigrate.SMUPackageVersionMismatch.txt");
                    valid = false;
                }
                if (valid) {
                    FileInputStream fis;
                    smuSASVersion = manifestProperties.getProperty("SMU.SAS.version", "");
                    String smuVersion = null;
                    String smuUtil = "smu";
                    String smuMajorVersion = "1";
                    if (smuSASVersion.equals("9.2")) {
                        smuUtil = "smu92";
                        smuMajorVersion = "2";
                    } else if (smuSASVersion.equals("9.3")) {
                        smuUtil = "smu93";
                        smuMajorVersion = "3";
                    } else if (smuSASVersion.equals("9.4")) {
                        smuUtil = "smu94";
                        smuMajorVersion = "4";
                    }
                    if (smuMajorVersion == "1") {
                        File templateFile = null;
                        Properties templateProperties = new Properties();
                        templateFile = new File(Utils.joinPath(Globals.g_startupLocation, "utilities", "smu"), "smu.properties.template");
                        try {
                            if (templateFile.isFile()) {
                                fis = new FileInputStream(templateFile);
                                templateProperties.load(fis);
                                fis.close();
                            } else {
                                Logging.log.warning("Migration package: Version check skipped: Smu.properties.template file does not exist: " + templateFile.toString());
                                bskipVerChk = true;
                            }
                        }
                        catch (Exception e) {
                            Logging.log.warning("Migration package: Version check skipped: Error loading smu.properties.template file: " + templateFile.toString());
                            bskipVerChk = true;
                        }
                        smuVersion = templateProperties.getProperty("SMU.version", "");
                    } else {
                        File smuFile = new File(Utils.joinPath(Globals.g_startupLocation, "utilities", smuUtil), "MANIFEST.MF");
                        if (!smuFile.exists()) {
                            Logging.log.warning("Migration package: Version check skipped: Error loading manifest: " + smuFile.getAbsolutePath());
                            bskipVerChk = true;
                        }
                        if (valid && !bskipVerChk) {
                            SASManifest manifest = null;
                            fis = null;
                            try {
                                fis = new FileInputStream(smuFile);
                                Manifest man = new Manifest(fis);
                                manifest = new SASManifest(man);
                                smuVersion = smuMajorVersion + "." + manifest.getMicroVersion();
                            }
                            catch (Exception e) {
                                Logging.log.warning("Migration package: Version check skipped: Error loading manifest: " + smuFile.getAbsolutePath());
                                bskipVerChk = true;
                            }
                            finally {
                                try {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                }
                                catch (IOException e) {
                                    Logging.logStackTrace(e);
                                }
                            }
                        }
                    }
                    if (valid && !bskipVerChk) {
                        boolean versionMatch = true;
                        if (smuVersion != null) {
                            if (manifestProperties.getProperty("SMU.version", "0").equals(smuVersion)) {
                                Logging.log.fine("Migration package selected, " + smuPackage + " version " + manifestProperties.getProperty("SMU.version", "missing") + ", meets the SAS Migration Utility version requirement, " + smuVersion);
                            } else {
                                versionMatch = false;
                            }
                        }
                        if (!versionMatch) {
                            if (!Globals.g_forceMigration) {
                                valid = false;
                                Logging.log.warning("Migration package selected, " + smuPackage + " version " + manifestProperties.getProperty("SMU.version", "missing") + ", does not meet the SAS Migration Utility version requirement, " + smuVersion);
                                if (Globals.g_quietMode) {
                                    Wizard.logResponseInvalid(this.getHeader(), "MIGRATION_PACKAGE", smuPackage, null);
                                } else {
                                    errMsg = this.bundle.getString("PanelMigrate.SMUPackageVersionMismatch.txt");
                                }
                            } else {
                                Logging.log.warning("User forced migration: Migration package selected, " + smuPackage + " version " + manifestProperties.getProperty("SMU.version") + ", does not meet the SAS Migration Utility version requirement, " + smuVersion);
                            }
                        }
                    }
                    if (valid) {
                        smuGUID = manifestProperties.getProperty("SMU.GUID", "");
                    }
                }
            }
            if (valid && Globals.g_reconfigure && Globals.g_configStatus != null && Globals.g_planConfigs != null && (statusEntries = Globals.g_configStatus.getStatusEntries()) != null) {
                planConfigs = new ArrayList<String>();
                String droppedConfigs = "";
                for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                    boolean inStatus = false;
                    for (int j = 0; j < statusEntries.length && !inStatus; ++j) {
                        if (!Globals.g_planConfigs[i].equalsIgnoreCase(statusEntries[j].getCode())) continue;
                        inStatus = true;
                    }
                    if (inStatus && !Globals.g_resumeChain) {
                        ProductData prodData;
                        if (Globals.g_planConfigs[i].equalsIgnoreCase("cfgwizard") || Globals.g_planConfigs[i].equalsIgnoreCase("vfabrictcsvr") || Globals.g_planConfigs[i].equalsIgnoreCase("tcsclusterc") || Globals.g_planConfigs[i].equalsIgnoreCase("jboss") || Globals.g_planConfigs[i].equalsIgnoreCase("weblogic") || Globals.g_planConfigs[i].equalsIgnoreCase("websphereba") || Globals.g_planConfigs[i].equalsIgnoreCase("webspherend")) {
                            planConfigs.add(Globals.g_planConfigs[i]);
                            if (Globals.g_skipGendefaultList == null) {
                                Globals.g_skipGendefaultList = new ArrayList();
                            }
                            Globals.g_skipGendefaultList.add(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH));
                            continue;
                        }
                        if (Globals.g_noMigrateFilter || Globals.g_planConfigs[i].equalsIgnoreCase("levconfig") || (prodData = Globals.g_deploymentData.getProduct(Globals.g_order, Globals.g_planConfigs[i], true)) == null) continue;
                        if (droppedConfigs.length() > 0) {
                            droppedConfigs = droppedConfigs + "\n" + prodData.getProdName();
                            continue;
                        }
                        droppedConfigs = prodData.getProdName();
                        continue;
                    }
                    planConfigs.add(Globals.g_planConfigs[i]);
                }
                if (planConfigs.size() < 2) {
                    errMsg = this.bundle.getString("PanelMigrate.MigrateNoProducts.txt");
                    valid = false;
                } else if (droppedConfigs.length() > 0 && !Globals.g_quietMode && CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelMigrate.MigrateAgainWarning.txt", droppedConfigs), Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
                    valid = false;
                }
            }
            if (valid) {
                Globals.g_configData.setProperty("config.migration.smu.file", smuPackage);
                if (planConfigs != null && planConfigs.size() > 0) {
                    Globals.g_planConfigs = planConfigs.toArray(new String[0]);
                }
                Globals.g_migrate = true;
                Globals.g_configData.setProperty("config.migration.is_selected", "True");
                Logging.log.info("SAS Migration Utility Package: " + smuPackage);
                Globals.g_configData.setProperty("config.smu.version", smuGUID);
                Globals.g_configData.setProperty("config.migration.sas.version", smuSASVersion);
                if (Globals.g_smuMachines != null && Globals.g_smuMachines.length == 1) {
                    Globals.g_smuMachine = Globals.g_smuMachines[0];
                    Globals.g_configData.setProperty("config.migration.package.tier.dir", Utils.joinPath(smuPackage, Globals.g_smuMachines[0]));
                    valid = Utils.validateSMUTierExecution(Globals.g_configData.getProperty("config.migration.package.tier.dir", null));
                    if (!valid) {
                        errMsg = this.bundle.messageString("PanelMigrate.SMUTierIsAnalyzeOnly.txt", Globals.g_smuMachine);
                    }
                    Logging.log.info(Globals.g_smuMachine + " was automatically selected from the SAS Migration Utility Package.");
                    if (valid && Globals.g_migrationSchema.hasNewTiers()) {
                        Globals.g_migrationSchema.deleteNewTiers();
                    }
                    Globals.g_migrationSchema.addNewTier(Globals.g_smuMachine);
                    if (!Globals.g_migrationSchema.originalTierHasPorts(Globals.g_smuMachine)) {
                        DynamicDialogs.loadConfigDialogs();
                    }
                }
            }
            if (!valid && !Globals.g_quietMode) {
                if (errMsg != null) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                }
                this.m_smuPackage.requestFocus();
            }
        } else {
            Globals.g_smuMachine = null;
            Globals.g_smuMachines = null;
            Globals.g_migrationSchema = null;
            Globals.g_migrate = false;
            Globals.g_configData.setProperty("config.migration.is_selected", "False");
            Globals.g_configData.setProperty("config.migration.package.tier.dir", "");
            if (Globals.g_mode != 2) {
                DynamicDialogs.loadConfigDialogs();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_singleAccount) {
            display = false;
            Globals.g_migrate = false;
            Globals.g_configData.setProperty("config.migration.smu.file", "");
            Globals.g_configData.setProperty("config.migration.is_selected", "False");
            Globals.g_configData.setProperty("config.migration.package.tier.dir", "");
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 2 && Globals.g_cmtTask == 37 ? "selectloadcontentinstances" : (Globals.g_smuMachines != null && Globals.g_smuMachines.length > 1 ? "selecthost" : (Globals.g_smuMachine != null && Globals.g_migrationSchema.originalTierHasPorts(Globals.g_smuMachine) ? "portremap" : (Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0 ? Globals.g_dynamicConfigDialogs[0] : "execute")));
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#PERFORM_MIGRATION=yes/no", " PERFORM_MIGRATION=no", "#MIGRATION_PACKAGE=<full path>", " MIGRATION_PACKAGE="};
        if (this.m_panelLoaded && this.m_migrateCheckBox.isSelected()) {
            data[1] = " PERFORM_MIGRATION=yes";
            data[3] = " MIGRATION_PACKAGE=" + this.m_smuPackage.getText();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_skipGendefaultList = null;
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptBoolean(this.m_migrateCheckBox);
        this.enableControls();
        if (returnCode > -1 && this.m_migrateCheckBox.isSelected()) {
            returnCode = ConsoleMode.promptText(this.m_smuPackageLabel.getText(), this.m_smuPackage);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String responseMigrate = Wizard.getResponse("PERFORM_MIGRATION", null);
        if (responseMigrate != null) {
            if (responseMigrate.equalsIgnoreCase("yes")) {
                this.m_migrateCheckBox.setSelected(true);
                String responseSMUPackage = Wizard.getResponse("MIGRATION_PACKAGE", null);
                if (responseSMUPackage != null) {
                    this.m_smuPackage.setText(responseSMUPackage);
                } else if (Globals.g_quietMode) {
                    valid = false;
                    Wizard.logResponseMissing(this.getHeader(), "MIGRATION_PACKAGE");
                }
            } else if (responseMigrate.equalsIgnoreCase("no")) {
                this.m_migrateCheckBox.setSelected(false);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "PERFORM_MIGRATION", responseMigrate, null);
            }
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PERFORM_MIGRATION");
        }
        return valid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_migrateCheckBox) {
            this.enableControls();
        }
    }

    private void enableControls() {
        boolean enabled = this.m_migrateCheckBox.isSelected();
        this.m_smuPackageLabel.setEnabled(enabled);
        this.m_smuPackage.setEnabled(enabled);
        this.m_browseButton.setEnabled(enabled);
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.messageString("PanelMigrate" + this.m_sdmtask + ".Instructions.txt", Globals.g_majorReleaseVersion));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelMigrate" + this.m_sdmtask + ".MigrateCheckBox.txt");
        this.m_migrateCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_migrateCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_migrateCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_migrateCheckBox.addActionListener(this);
        this.m_smuPackage = new KitTextField();
        this.m_smuPackage.setEnabled(false);
        mtxt = this.bundle.getString("PanelMigrate.SMUPackageLabel.txt");
        this.m_smuPackageLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_smuPackageLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_smuPackageLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_smuPackageLabel.setLabelFor(this.m_smuPackage);
        this.m_smuPackageLabel.setEnabled(false);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_smuPackage);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        this.m_browseButton.setEnabled(false);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_migrateCheckBox, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_smuPackageLabel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_smuPackage, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    private boolean getSMUMachines(String smuPackage) {
        File schemaFile;
        File schemaDir;
        File manifest;
        boolean valid = false;
        boolean mdServer = false;
        ArrayList machines = null;
        File smuFile = new File(smuPackage);
        if (Globals.g_planConfigs != null) {
            for (int i = 0; i < Globals.g_planConfigs.length && !mdServer; ++i) {
                if (!Globals.g_planConfigs[i].equalsIgnoreCase("metadatasrv")) continue;
                mdServer = true;
            }
        }
        if (smuFile.isDirectory() && (manifest = new File(smuFile, "manifest.properties")).isFile() && (schemaDir = new File(smuFile, "migration-schemas")).isDirectory() && (schemaFile = new File(schemaDir, "template.xml")).isFile()) {
            try {
                if (schemaFile.getAbsolutePath().equals(this.m_previousSchema) && Globals.g_migrationSchema != null) {
                    valid = true;
                    return valid;
                }
                Globals.g_migrationSchema = null;
                Globals.g_migrationSchemaFile = schemaFile;
                Globals.g_migrationSchema = new MigrationSchema(Globals.g_migrationSchemaFile);
                machines = Globals.g_migrationSchema.getOrigMachines(mdServer);
                if (!mdServer && Globals.g_machine.getDeploymentStepLabels().size() > 1) {
                    machines.addAll(Globals.g_migrationSchema.getOrigMachines(!mdServer));
                }
                if (machines.size() > 0) {
                    valid = true;
                }
                this.m_previousSchema = schemaFile.getAbsolutePath();
            }
            catch (Exception e) {
                Logging.log.severe(e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        Globals.g_smuMachines = valid ? machines.toArray(new String[0]) : null;
        return valid;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

