/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PanelManageFileTypesSummary
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelManageFileTypesSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_warningText = null;
    private JTextArea m_infoText = null;
    private JLabel m_warningImage = null;
    private JTable m_extList = null;
    private JScrollPane m_listScrollPane = null;
    private ListTableModel m_listTableModel = null;
    private ArrayList<ExtensionData> m_listData = new ArrayList();
    private HashMap<String, TreeSet<String>> m_progIDs = new HashMap();
    private boolean m_panelLoaded = false;

    public PanelManageFileTypesSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelManageFileTypesSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelManageFileTypesSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean result;
        if (!Globals.g_recordMode && !(result = Globals.g_fileTypeData.applyFileTypeAssociations())) {
            Logging.log.warning("Errors occured in applyFileTypeAssociations()");
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "managefiletypesfinish";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if (Globals.g_wizard != null) {
            Globals.g_wizard.getNextButton().setText(this.bundle.getString("PanelManageFileTypesSummary.NextButton.txt"));
        }
        this.loadExtData();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.validateData();
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.m_warningText.getText());
        ConsoleMode.println();
        ConsoleMode.println(this.m_infoText.getText());
        ArrayList<String> tableText = new ArrayList<String>();
        tableText.add(this.bundle.getString("PanelManageFileTypesSummary.ExtensionField.txt") + "~" + this.bundle.getString("PanelManageFileTypesSummary.OldProductField.txt") + "~" + this.bundle.getString("PanelManageFileTypesSummary.NewProductField.txt"));
        ExtensionData data = null;
        for (int i = 0; i < this.m_listData.size(); ++i) {
            data = this.m_listData.get(i);
            tableText.add(data.getProduct() + "~" + data.getNewProduct());
        }
        ConsoleMode.printTable(tableText.toArray(new String[0]));
        return ConsoleMode.promptPause();
    }

    private boolean loadResponseData() {
        return true;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_warningText = new JTextArea(this.bundle.getString("PanelManageFileTypesSummary.WarningText.txt"));
        this.m_warningText.setEditable(false);
        this.m_warningText.setFocusable(false);
        this.m_warningText.setLineWrap(true);
        this.m_warningText.setWrapStyleWord(true);
        this.m_warningText.setOpaque(false);
        this.m_infoText = new JTextArea(this.bundle.getString("PanelManageFileTypesSummary.InfoText.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_listTableModel = new ListTableModel();
        this.m_extList = new JTable(this.m_listTableModel);
        this.m_extList.setRowSelectionAllowed(true);
        this.m_extList.setColumnSelectionAllowed(false);
        this.m_extList.setSelectionMode(0);
        this.m_extList.getTableHeader().setResizingAllowed(true);
        this.m_extList.getTableHeader().setReorderingAllowed(false);
        this.m_extList.getColumnModel().getColumn(0).setCellRenderer(new ExtensionsCellRenderer());
        this.m_extList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_extList.getColumnModel().getColumn(2).setCellRenderer(new StringCellRenderer());
        this.m_extList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelManageFileTypesSummary.this.m_extList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_extList);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_warningText, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void loadExtData() {
        this.m_listData.clear();
        this.m_progIDs.clear();
        TreeSet<String> extList = Globals.g_fileTypeData.getUserModifiedFileTypes();
        String progId = null;
        for (String ext : extList) {
            progId = Globals.g_fileTypeData.getProgID(ext);
            if (this.m_progIDs.containsKey(progId)) {
                this.m_progIDs.get(progId).add(ext);
                continue;
            }
            TreeSet<String> extset = new TreeSet<String>();
            extset.add(ext);
            this.m_progIDs.put(progId, extset);
            this.m_listData.add(new ExtensionData(ext, Globals.g_fileTypeData.getCurrentProductForFileType(ext), Globals.g_fileTypeData.getUserSelectedProductForFileType(ext).getDisplayName(), progId));
        }
    }

    class ExtensionData {
        private String m_ext = null;
        private String m_defaultProduct = null;
        private String m_newDefaultProduct = null;
        private String m_progId = null;

        public ExtensionData(String extension, String defProd, String newDefProd, String progID) {
            this.m_ext = extension;
            this.m_defaultProduct = defProd;
            this.m_newDefaultProduct = newDefProd;
            this.m_progId = progID;
        }

        public String getExtension() {
            return this.m_ext;
        }

        public String getProduct() {
            return this.m_defaultProduct;
        }

        public String getNewProduct() {
            return this.m_newDefaultProduct;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class ExtensionsCellRenderer
    extends DefaultTableCellRenderer {
        private ExtensionsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                String extensionList = value.toString();
                String progid = Globals.g_fileTypeData.getProgID(value.toString());
                for (String ext : (TreeSet)PanelManageFileTypesSummary.this.m_progIDs.get(progid)) {
                    if (ext.equals(value.toString())) continue;
                    extensionList = extensionList.concat(", " + ext);
                }
                this.setText(extensionList);
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class ListTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_EXTENSION = 0;
        public static final int TABLE_COLUMN_OLD = 1;
        public static final int TABLE_COLUMN_NEW = 2;
        private String[] m_columnNames;

        public ListTableModel() {
            this.m_columnNames = new String[]{PanelManageFileTypesSummary.this.bundle.getString("PanelManageFileTypesSummary.ExtensionField.txt"), PanelManageFileTypesSummary.this.bundle.getString("PanelManageFileTypesSummary.OldProductField.txt"), PanelManageFileTypesSummary.this.bundle.getString("PanelManageFileTypesSummary.NewProductField.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelManageFileTypesSummary.this.m_listData != null) {
                count = PanelManageFileTypesSummary.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = null;
            ExtensionData data = (ExtensionData)PanelManageFileTypesSummary.this.m_listData.get(rowIndex);
            if (data != null) {
                if (columnIndex == 1) {
                    value = data.getProduct();
                } else if (columnIndex == 2) {
                    value = data.getNewProduct();
                } else if (columnIndex == 0) {
                    value = data.getExtension();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }
}

