/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PanelManageFileTypesFinish
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelManageFileTypesFinish.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JLabel m_warningImage = null;
    private JTable m_extList = null;
    private JScrollPane m_listScrollPane = null;
    private ListTableModel m_listTableModel = null;
    private ArrayList<ResultsData> m_listData = new ArrayList();
    private HashMap<String, TreeSet<String>> m_progIDs = new HashMap();
    private boolean m_panelLoaded = false;

    public PanelManageFileTypesFinish() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelManageFileTypesFinish.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelManageFileTypesFinish.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return null;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if (!Globals.g_quietMode && Globals.g_wizard != null) {
            Globals.g_wizard.getBackButton().setEnabled(false);
            Globals.g_wizard.getCancelButton().setEnabled(false);
        }
        if (!Globals.g_recordMode) {
            this.loadExtData();
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        return 0;
    }

    public boolean loadResponseData() {
        return true;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_infoText = new JTextArea(this.bundle.getString("PanelManageFileTypesFinish.InfoText.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_listTableModel = new ListTableModel();
        this.m_extList = new JTable(this.m_listTableModel);
        this.m_extList.setRowSelectionAllowed(true);
        this.m_extList.setColumnSelectionAllowed(false);
        this.m_extList.setSelectionMode(0);
        this.m_extList.getTableHeader().setResizingAllowed(true);
        this.m_extList.getTableHeader().setReorderingAllowed(false);
        this.m_extList.getColumnModel().getColumn(0).setCellRenderer(new ExtensionsCellRenderer());
        this.m_extList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_extList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelManageFileTypesFinish.this.m_extList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_extList);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    private void loadExtData() {
        this.m_listData.clear();
        this.m_progIDs.clear();
        TreeSet<String> extList = Globals.g_fileTypeData.getUserModifiedFileTypes();
        String progId = null;
        for (String ext : extList) {
            progId = Globals.g_fileTypeData.getProgID(ext);
            if (this.m_progIDs.containsKey(progId)) {
                this.m_progIDs.get(progId).add(ext);
                continue;
            }
            TreeSet<String> extset = new TreeSet<String>();
            extset.add(ext);
            this.m_progIDs.put(progId, extset);
            this.m_listData.add(new ResultsData(ext, Globals.g_fileTypeData.getUserSelectedProductForFileType(ext).getDisplayName(), Globals.g_fileTypeData.getExtRegResults(ext), progId));
        }
    }

    class ResultsData {
        private String m_ext = null;
        private String m_newDefaultProduct = null;
        private boolean m_result = false;
        private String m_progId = null;

        public ResultsData(String extension, String newDefProd, boolean result, String progID) {
            this.m_ext = extension;
            this.m_newDefaultProduct = newDefProd;
            this.m_result = result;
            this.m_progId = progID;
        }

        public String getExtension() {
            return this.m_ext;
        }

        public String getNewProduct() {
            return this.m_newDefaultProduct;
        }

        public boolean getResult() {
            return this.m_result;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class ExtensionsCellRenderer
    extends DefaultTableCellRenderer {
        private ExtensionsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                String extensionList = value.toString();
                String progid = Globals.g_fileTypeData.getProgID(value.toString());
                for (String ext : (TreeSet)PanelManageFileTypesFinish.this.m_progIDs.get(progid)) {
                    if (ext.equals(value.toString())) continue;
                    extensionList = extensionList.concat(", " + ext);
                }
                this.setText(extensionList);
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class ListTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_EXTENSION = 0;
        public static final int TABLE_COLUMN_PROGRAM = 1;
        public static final int TABLE_COLUMN_RESULT = 2;
        private String[] m_columnNames;

        public ListTableModel() {
            this.m_columnNames = new String[]{PanelManageFileTypesFinish.this.bundle.getString("PanelManageFileTypesFinish.ExtensionField.txt"), PanelManageFileTypesFinish.this.bundle.getString("PanelManageFileTypesFinish.NewProductField.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelManageFileTypesFinish.this.m_listData != null) {
                count = PanelManageFileTypesFinish.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            ResultsData data = (ResultsData)PanelManageFileTypesFinish.this.m_listData.get(rowIndex);
            if (data != null) {
                if (columnIndex == 0) {
                    value = data.getExtension();
                } else if (columnIndex == 2) {
                    value = data.getResult();
                } else if (columnIndex == 1) {
                    value = data.getResult() ? data.getNewProduct() : PanelManageFileTypesFinish.this.bundle.getString("PanelManageFileTypesFinish.ErrorResult.txt");
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }
}

