/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.BatchFile;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.JREData;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelTPSummary;
import com.sas.ssn.PanelThirdParty;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.ProductDataList;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PanelMachine
implements WizardPanelIface,
ActionListener,
FocusListener {
    private final int REQUIREDPRODUCT_INT = 0;
    private final int REQUIREDPRODUCT_SELECTED = 1;
    private final int REQUIREDPRODUCT_UNSELECTED = 2;
    private int graphAppletSelection = 0;
    private int msofficeintSelection = 0;
    private int webedtrSelection = 0;
    private final int SUBSET_SERVER = 0;
    private final int SUBSET_CLIENT = 1;
    private final String SUBSET_SERVER_NAME = "server";
    private final String SUBSET_CLIENT_NAME = "client";
    private static final String RESPONSE_STEP_PREFIX = "step ";
    private SSNResource bundle = new SSNResource(PanelMachine.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_machineLabel = null;
    private JComboBox m_machineComboBox = null;
    private JLabel m_subsetsLabel = null;
    private JComboBox m_subsetsComboBox = null;
    private JLabel m_warningImage = null;
    private JTextArea m_warningMessage = null;
    private JLabel m_findLabel = null;
    private KitTextField m_findText = null;
    private JButton m_findButton = null;
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private ProductData[] m_productData = null;
    private ActionListener m_installColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private boolean m_configOnly = false;
    private boolean m_previousConfigOnly = false;
    private boolean m_previousConfigState = false;
    private boolean m_findVisible = false;
    private boolean m_machineVisible = false;
    private boolean m_subsetsVisible = false;
    private String m_previousHeaderType = "";
    private String m_previousPlan = "";
    private String m_previousOrder = "";
    private String m_responseMachine = null;
    private String m_selectedTitle = null;
    private HashMap m_responseProducts = null;
    private HashMap m_serverSubset = new HashMap();
    private HashMap m_clientSubset = new HashMap();

    public PanelMachine() {
        this.m_componentTableModel = new ComponentTableModel();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    private String getHeaderType() {
        String headerType = "Header";
        if (!(!Globals.g_configure || Globals.g_plan == null || Globals.g_quietMode && Globals.g_recordMode)) {
            if (Globals.g_plan.hasDeploymentSteps()) {
                headerType = Globals.g_install ? "InstallDeploymentStepsHeader" : "ConfigDeploymentStepsHeader";
            } else if (!Globals.g_install) {
                headerType = "ConfigHeader";
            }
        }
        return headerType;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelMachine." + this.getHeaderType() + ".txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelMachine." + this.getHeaderType() + "Desc.txt");
    }

    private int selectRequiredProduct(String requiredProduct, String requiredByProduct, String selectedProperty) {
        HashMap components = this.m_componentTableModel.getComponents();
        ComponentData reqCompData = null;
        int productSelection = 0;
        reqCompData = (ComponentData)components.get(requiredProduct);
        if (reqCompData != null && reqCompData.doInstall()) {
            productSelection = 1;
            Globals.g_installData.setProperty(selectedProperty, "TRUE");
        } else {
            productSelection = 2;
            Globals.g_installData.setProperty(selectedProperty, "FALSE");
        }
        ComponentData reqByCompData = (ComponentData)components.get(requiredByProduct);
        if (reqByCompData != null && reqByCompData.doInstall()) {
            reqCompData = (ComponentData)components.get(requiredProduct);
            if (reqCompData != null && Globals.g_plan == null) {
                if (!reqCompData.doInstall()) {
                    productSelection = 2;
                    reqCompData.setInstall(true);
                    Globals.g_installData.setProperty(selectedProperty, "FALSE");
                } else {
                    productSelection = 1;
                    Globals.g_installData.setProperty(selectedProperty, "TRUE");
                }
                Logging.log.info("Selected " + requiredProduct + " to install as it is required by " + requiredByProduct + ". Note this selection is performed before requirements processing.");
            } else {
                reqCompData = null;
            }
        }
        return productSelection;
    }

    @Override
    public boolean validateData() {
        Globals.g_installingSubset = false;
        if (Globals.g_plannedInstall && (this.m_machineComboBox.getSelectedIndex() == -1 || ((String)this.m_machineComboBox.getSelectedItem()).equals(this.bundle.getString("PanelMachine.SelectOneMachine.txt")))) {
            if (Globals.g_quietMode) {
                if (this.m_responseMachine != null) {
                    Wizard.logResponseInvalid(this.getHeader(), "MACHINE_SELECTION", this.m_responseMachine, null);
                } else {
                    Wizard.logResponseMissing(this.getHeader(), "MACHINE_SELECTION");
                }
            } else {
                String messageName = "PanelMachine.ErrorMsg.txt";
                if (this.isDeploymentStepPresentation()) {
                    messageName = "PanelMachine.ErrorDeploymentStepsMsg.txt";
                }
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString(messageName), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_machineComboBox.requestFocus();
            }
            return false;
        }
        if (this.m_configOnly) {
            Globals.g_selectedInstalls = new ProductData[0];
        } else {
            ArrayList componentIds = this.m_componentTableModel.getComponentIds();
            HashMap components = this.m_componentTableModel.getComponents();
            ArrayList<ProductData> installComponents = new ArrayList<ProductData>();
            this.graphAppletSelection = this.selectRequiredProduct("graphapplet", "cgitools", "graphapplet.is.selected");
            this.msofficeintSelection = this.selectRequiredProduct("msofficeint", "dminerpm", "msofficeint.is.selected");
            this.webedtrSelection = this.selectRequiredProduct("sasinstall", "webedtr", "sasinstall.is.selected");
            Globals.g_msofficeintPlat = null;
            Globals.g_msoffintvaPlat = null;
            for (int i = 0; i < componentIds.size(); ++i) {
                String id = (String)componentIds.get(i);
                ComponentData data = (ComponentData)components.get(id);
                if (data.doInstall()) {
                    ProductData prodData;
                    if (id.equalsIgnoreCase("msofficeint") && Utils.getOS_Suffix().equalsIgnoreCase("wx6")) {
                        Globals.g_officeBitness = Utils.getOfficeBitness();
                        if (Globals.g_officeBitness == 32) {
                            prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", false);
                            if (prodData != null) {
                                Globals.g_msofficeintPlat = "win";
                                installComponents.add(prodData);
                            } else {
                                installComponents.add(data.getProductData());
                            }
                        } else {
                            installComponents.add(data.getProductData());
                        }
                    } else if (id.equalsIgnoreCase("msoffintva") && Utils.getOS_Suffix().equalsIgnoreCase("wx6")) {
                        Globals.g_officeBitness = Utils.getOfficeBitness();
                        if (Globals.g_officeBitness == 32) {
                            prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", "win", false);
                            if (prodData != null) {
                                Globals.g_msoffintvaPlat = "win";
                                installComponents.add(prodData);
                            } else {
                                installComponents.add(data.getProductData());
                            }
                        } else {
                            installComponents.add(data.getProductData());
                        }
                    } else {
                        installComponents.add(data.getProductData());
                    }
                    if (Globals.g_skipLockCheck || Utils.getOS() != 1 || Globals.g_recordMode && Globals.g_recordOnly || !id.equals("sasinstall") || Globals.g_srwOnly || !Utils.isRunning(this.m_productData[i].getProdCode(), this.m_productData[i].getProdVersion(), this.m_productData[i].getPlatform(), "sashost.dll") && !Utils.isRunning(this.m_productData[i].getProdCode(), this.m_productData[i].getProdVersion(), this.m_productData[i].getPlatform(), "dbcs\\sashost.dll") && !Utils.isRunning(this.m_productData[i].getProdCode(), this.m_productData[i].getProdVersion(), this.m_productData[i].getPlatform(), "sas.exe")) continue;
                    if (Globals.g_quietMode) {
                        Logging.log.severe("The following products are currently running: " + data.getName() + Globals.g_eol + "      You must exit these products before reinstalling them.");
                        continue;
                    }
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelMachine.LockCheckWarning.txt", data.getName()), this.bundle.getString("Common.Warning.txt"), 2);
                    return false;
                }
                Globals.g_installingSubset = true;
            }
            if (installComponents.size() <= 0) {
                if (Globals.g_quietMode) {
                    Logging.log.severe("None of the products selected in the response file are valid for this computer.\n   Panel: " + this.getHeader() + "\n   Field: " + "PRODUCT_SELECTION" + "#");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelMachine.NoInstallError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_componentTable.requestFocus();
                }
                return false;
            }
            Globals.g_selectedInstalls = installComponents.toArray(new ProductData[0]);
            Globals.g_baseSelected = false;
            int statstudio_index = -1;
            int webedtr_index = -1;
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                String id = Globals.g_selectedInstalls[i].getProdCode();
                if (id.equals("sasinstall")) {
                    Globals.g_baseSelected = true;
                    continue;
                }
                if (id.equals("statstudio")) {
                    statstudio_index = i;
                    continue;
                }
                if (!id.equals("webedtr")) continue;
                webedtr_index = i;
            }
            if (!Globals.g_baseSelected) {
                ProductData productData;
                Globals.g_sasinstallPlat = null;
                if (statstudio_index >= 0 && (productData = Globals.g_deploymentData.getProduct(Globals.g_order, "statstudio", false)) != null) {
                    Globals.g_selectedInstalls[statstudio_index] = productData;
                }
                JREData.setJREData(Utils.getOS_Suffix(), JREData.isPrivateJreNeeded());
            } else if (Globals.g_sasinstallPlat != null) {
                ProductData productData;
                JREData.setJREData(Globals.g_sasinstallPlat, JREData.isPrivateJreNeeded());
                if (statstudio_index >= 0 && (productData = Globals.g_deploymentData.getProduct(Globals.g_order, "statstudio", Globals.g_sasinstallPlat, false)) != null && statstudio_index >= 0) {
                    Globals.g_selectedInstalls[statstudio_index] = productData;
                }
                if (webedtr_index >= 0 && (productData = Globals.g_deploymentData.getProduct(Globals.g_order, "webedtr", Globals.g_sasinstallPlat, false)) != null && webedtr_index >= 0) {
                    Globals.g_selectedInstalls[webedtr_index] = productData;
                }
            } else {
                JREData.setJREData(Utils.getOS_Suffix(), JREData.isPrivateJreNeeded());
            }
            ProductDataList.selectBitnessModePCFS();
        }
        if (Globals.g_plan != null) {
            if (this.m_selectedTitle == null) {
                Globals.g_machine = null;
                Globals.g_stepNumber = null;
            } else {
                Globals.g_machine = Globals.g_plan.getMachineFromTitle(this.m_selectedTitle);
                Globals.g_stepNumber = Globals.g_plan.getStepNumberFromTitle(this.m_selectedTitle);
            }
            Globals.g_wizardData.setPreference("MachineName", Globals.g_machine.getName());
            if (this.m_configOnly) {
                if (Globals.g_promptedInstalls != null) {
                    for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                        Globals.g_wizard.removePanel(Globals.g_promptedInstalls[i]);
                    }
                    Globals.g_promptedInstalls = null;
                }
            } else {
                ArrayList<String> promptedList = new ArrayList<String>();
                Globals.g_promptedData = Globals.g_deploymentData.getThirdParty(Globals.g_order, Globals.g_machine.getDeployedComponentIds(), false);
                for (int i = 0; i < Globals.g_promptedData.length; ++i) {
                    if (Globals.g_promptedData[i] == null) continue;
                    String prodCode = Globals.g_promptedData[i].getProdCode();
                    String prodVersion = Globals.g_promptedData[i].getProdVersion();
                    String prodName = Globals.g_promptedData[i].getProdName();
                    String panelID = "promptfor".concat(prodCode);
                    Globals.g_wizard.addPanel(panelID, new PanelThirdParty(i, prodCode, prodVersion, prodName));
                    promptedList.add(panelID);
                }
                Globals.g_promptedInstalls = promptedList.toArray(new String[0]);
                PanelTPSummary tpSummary = (PanelTPSummary)Globals.g_wizard.getPanel("tpsummary");
                if (tpSummary != null) {
                    tpSummary.updatePromptedInfo();
                }
            }
        } else if (Globals.g_promptedInstalls != null) {
            for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                Globals.g_wizard.removePanel(Globals.g_promptedInstalls[i]);
            }
            Globals.g_promptedInstalls = null;
        }
        if (!this.isSasinstallSelected() || Globals.g_plannedInstall) {
            BatchFile bf = BatchFile.getInstance();
            if (Globals.g_createBatch) {
                try {
                    bf.createBatchFile();
                }
                catch (IOException ioe) {
                    Logging.log.severe("No system requisite batch file could be created: " + ioe.getMessage());
                }
                catch (SecurityException se) {
                    Logging.log.severe("System requisite batch file could not be deleted: " + se.getMessage());
                }
            } else if (Globals.g_srwOnly) {
                bf.close();
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_zos) {
            if (!Globals.g_configure) {
                Globals.g_planConfigs = new String[0];
                Globals.g_selectedInstalls = new ProductData[0];
                display = false;
            }
        } else if (Globals.g_configure && !Globals.g_install && Globals.g_plan != null && Globals.g_plan.getMachineSelTitles().size() == 1) {
            this.m_selectedTitle = Globals.g_plan.getMachineSelTitles().firstElement();
            Globals.g_machine = Globals.g_plan.getMachineFromTitle(this.m_selectedTitle);
            Globals.g_stepNumber = Globals.g_plan.getStepNumberFromTitle(this.m_selectedTitle);
            Globals.g_planConfigs = Globals.g_machine.getConfiguredComponentIds();
            Globals.g_selectedInstalls = new ProductData[0];
            display = false;
        }
        if (Utils.isDeploywizWebOrder()) {
            display = false;
        }
        if (!display) {
            Globals.g_installingSubset = false;
        }
        if (display && Globals.g_defaultProductSet) {
            this.populate();
            display = !this.validateData();
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "selectmode";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean responseDataLoaded = false;
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_responseMachine = null;
            } else {
                responseDataLoaded = true;
            }
            this.m_panelLoaded = true;
        }
        this.m_configOnly = Globals.g_configure && !Globals.g_install;
        if (Globals.g_plan == null && this.m_previousPlan != null && this.m_previousPlan.length() > 0 || Globals.g_plan != null && !this.m_previousPlan.equals(Globals.g_plan.getFile()) || !this.m_previousOrder.equalsIgnoreCase(Globals.g_order) || !this.m_previousHeaderType.equals(this.getHeaderType()) || this.m_previousConfigOnly != this.m_configOnly) {
            int rowHeight;
            if (Globals.g_plannedInstall) {
                this.m_findVisible = false;
                this.m_machineVisible = true;
                this.m_subsetsVisible = false;
            } else if (Globals.g_sugiSam) {
                this.m_findVisible = false;
                this.m_machineVisible = false;
                this.m_subsetsVisible = true;
            } else {
                this.m_findVisible = true;
                this.m_machineVisible = false;
                this.m_subsetsVisible = false;
            }
            this.m_subsetsLabel.setVisible(this.m_subsetsVisible);
            this.m_subsetsComboBox.setVisible(this.m_subsetsVisible);
            this.m_findLabel.setVisible(this.m_findVisible);
            this.m_findText.setVisible(this.m_findVisible);
            this.m_findButton.setVisible(this.m_findVisible);
            this.m_machineLabel.setVisible(this.m_machineVisible);
            this.m_machineComboBox.setVisible(this.m_machineVisible);
            if (Globals.g_install && (Globals.g_plannedInstall || Globals.g_sugiSam)) {
                this.m_buttonPanel.setVisible(true);
            } else {
                this.m_buttonPanel.setVisible(false);
            }
            this.populate();
            if (this.m_subsetsVisible && !responseDataLoaded) {
                this.m_componentTableModel.selectSubset();
            }
            if ((rowHeight = Utils.getPreferredRowHeight(this.m_componentTable)) > 0) {
                this.m_componentTable.setRowHeight(rowHeight);
            }
            if (Globals.g_plan != null) {
                this.m_previousPlan = Globals.g_plan.getFile();
            }
            this.m_previousOrder = Globals.g_order;
            this.m_previousConfigOnly = this.m_configOnly;
            this.m_previousConfigState = Globals.g_configure;
            this.m_previousHeaderType = this.getHeaderType();
        } else if (this.m_previousConfigState != Globals.g_configure) {
            Globals.g_planConfigs = Globals.g_configure && Globals.g_machine != null ? Globals.g_machine.getConfiguredComponentIds() : new String[0];
            this.m_previousConfigState = Globals.g_configure;
        }
        this.handleRequiredProductSelection("graphapplet", this.graphAppletSelection);
        this.handleRequiredProductSelection("msofficeint", this.msofficeintSelection);
        this.handleRequiredProductSelection("webedtr", this.webedtrSelection);
    }

    private void handleRequiredProductSelection(String productCode, int selection) {
        ComponentData compData;
        if (selection == 2 && (compData = (ComponentData)this.m_componentTableModel.getComponents().get(productCode)) != null) {
            compData.setInstall(false);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        if (this.m_machineComboBox.isEnabled() && this.m_machineComboBox.isVisible()) {
            return this.m_machineComboBox;
        }
        if (this.m_findText.isEnabled() && this.m_findText.isVisible()) {
            return this.m_findText;
        }
        if (this.m_subsetsComboBox.isEnabled() && this.m_subsetsComboBox.isVisible()) {
            return this.m_subsetsComboBox;
        }
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.m_configOnly = Globals.g_configure && !Globals.g_install;
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Globals.g_quietMode && Globals.g_recordMode) {
            data.add(" PRODUCT_SELECTION1=");
        } else {
            if (Globals.g_plannedInstall) {
                data.add("#MACHINE_SELECTION=<machine name>");
                data.add("# or");
                data.add("#MACHINE_SELECTION=step <#>");
                String dataLinePrefix = " MACHINE_SELECTION=";
                if (this.m_panelLoaded) {
                    String selectionTitle = (String)this.m_machineComboBox.getSelectedItem();
                    if (this.isDeploymentStepPresentation()) {
                        data.add(dataLinePrefix + RESPONSE_STEP_PREFIX + Globals.g_plan.getStepNumberFromTitle(selectionTitle));
                    } else {
                        Plan.Machine machine = Globals.g_plan.getMachineFromTitle(selectionTitle);
                        String machName = machine.getName();
                        data.add(dataLinePrefix + machName);
                    }
                } else {
                    data.add(dataLinePrefix);
                }
            }
            if (this.m_panelLoaded && !this.m_configOnly) {
                ArrayList componentIds = this.m_componentTableModel.getComponentIds();
                HashMap components = this.m_componentTableModel.getComponents();
                int index = 1;
                for (int i = 0; i < componentIds.size(); ++i) {
                    String id = (String)componentIds.get(i);
                    ComponentData cData = (ComponentData)components.get(id);
                    if (!cData.doInstall()) continue;
                    data.add(" PRODUCT_SELECTION" + Integer.toString(index++) + "=" + cData.getIdentifier());
                }
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_selectedInstalls = new ProductData[0];
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        if (this.m_machineComboBox.isVisible() && this.m_machineComboBox.isEnabled()) {
            returnCode = ConsoleMode.promptComboBox(this.m_machineComboBox);
        } else if (this.m_subsetsComboBox.isVisible() && this.m_subsetsComboBox.isEnabled()) {
            returnCode = ConsoleMode.promptComboBox(this.m_subsetsComboBox);
        }
        if (returnCode > -1 && !this.m_configOnly) {
            if (this.m_warningMessage.isVisible()) {
                ConsoleMode.printInfoText(this.m_warningMessage.getText());
            }
            ArrayList componentIds = this.m_componentTableModel.getComponentIds();
            HashMap components = this.m_componentTableModel.getComponents();
            ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[componentIds.size()];
            String id = null;
            ComponentData data = null;
            for (int i = 0; i < options.length; ++i) {
                id = (String)componentIds.get(i);
                data = (ComponentData)components.get(id);
                options[i] = new ConsoleMode.SelectionItem(data.getName(), data.doInstall());
            }
            String header = this.bundle.getString("PanelMachine.ComponentTable.NameColumn.Title.txt");
            returnCode = ConsoleMode.promptMultiChoice(options, header);
            if (returnCode > -1) {
                for (int i = 0; i < options.length; ++i) {
                    id = (String)componentIds.get(i);
                    data = (ComponentData)components.get(id);
                    data.setInstall(options[i].getSelected());
                }
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (Globals.g_plannedInstall) {
            this.m_responseMachine = Wizard.getResponse("MACHINE_SELECTION", null);
            if (this.m_responseMachine == null) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "MACHINE_SELECTION");
                }
            }
        }
        if (valid) {
            this.m_responseProducts = null;
            boolean found = true;
            int productCount = 1;
            String responseProduct = null;
            while (found) {
                responseProduct = Wizard.getResponse("PRODUCT_SELECTION" + Integer.toString(productCount), null);
                if (responseProduct != null) {
                    if (productCount == 1) {
                        this.m_responseProducts = new HashMap();
                    }
                    this.m_responseProducts.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
                } else {
                    if (Globals.g_install && productCount == 1) {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseMissing(this.getHeader(), "PRODUCT_SELECTION" + Integer.toString(productCount));
                        }
                    }
                    found = false;
                }
                ++productCount;
            }
        }
        return valid;
    }

    private boolean isDeploymentStepPresentation() {
        return this.getHeaderType().contains("DeploymentSteps");
    }

    private void setComboBoxLabelAndTooltip() {
        String machOrStep = "Machine";
        if (this.isDeploymentStepPresentation()) {
            machOrStep = "DeploymentStep";
        }
        String mtxt = this.bundle.getString("PanelMachine." + machOrStep + ".Tooltip.txt");
        this.m_machineComboBox.setToolTipText(mtxt);
        mtxt = this.bundle.getString("PanelMachine." + machOrStep + ".Label.txt");
        this.m_machineLabel.setText(Util.getLabelWithoutMnemonic(mtxt));
        this.m_machineLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_machineLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_machineLabel.setLabelFor(this.m_machineComboBox);
    }

    private void initialize() {
        InetAddress address = null;
        String hostname = "";
        try {
            address = InetAddress.getLocalHost();
            hostname = Utils.getShortHostName(address);
        }
        catch (Exception e) {
            Logging.log.info("No IP address for the host could be found: " + hostname);
        }
        this.m_machineComboBox = new JComboBox();
        this.m_machineLabel = new JLabel();
        this.setComboBoxLabelAndTooltip();
        this.m_subsetsComboBox = new JComboBox();
        this.m_subsetsComboBox.addItem(this.bundle.getString("PanelMachine.SubsetServerItem.txt"));
        this.m_subsetsComboBox.addItem(this.bundle.getString("PanelMachine.SubsetClientItem.txt"));
        String mtxt = this.bundle.getString("PanelMachine.Subsets.Label.txt");
        this.m_subsetsLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_subsetsLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_subsetsLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_subsetsLabel.setLabelFor(this.m_subsetsComboBox);
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningMessage = new JTextArea(this.bundle.getString("PanelMachine.WarningMessage.txt"));
        this.m_warningMessage.setEditable(false);
        this.m_warningMessage.setFocusable(false);
        this.m_warningMessage.setLineWrap(true);
        this.m_warningMessage.setWrapStyleWord(true);
        this.m_warningMessage.setOpaque(false);
        this.m_findText = new KitTextField();
        this.m_findText.getDocument().addDocumentListener(new TextChangeListener());
        mtxt = this.bundle.getString("PanelMachine.Search.Label.txt");
        this.m_findLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findLabel.setLabelFor(this.m_findText);
        mtxt = this.bundle.getString("PanelMachine.FindNext.Button.txt");
        this.m_findButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_componentTable = new ToolTipTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelMachine.this.m_componentTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installColumnActionListener = new InstallColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_machineComboBox.addActionListener(this);
        this.m_subsetsComboBox.addActionListener(this);
        this.m_findButton.addActionListener(this);
        this.m_findText.addFocusListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_machineLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_machineComboBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_warningMessage, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_findLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_findText, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_findButton, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_subsetsLabel, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_subsetsComboBox, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        if (this.m_configOnly) {
            this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ConfigOnlyCellRenderer());
        } else {
            this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
            this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
        }
        this.m_componentTable.getColumnModel().getColumn(1).setCellRenderer(new InfoCellRenderer());
        this.m_componentTable.getTableHeader().setResizingAllowed(false);
        this.m_componentTable.getTableHeader().setReorderingAllowed(false);
        this.m_componentTable.getColumnModel().getColumn(1).setMaxWidth(this.m_componentTable.getColumnModel().getColumn(1).getPreferredWidth());
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        helpTopic = Globals.g_plannedInstall || Globals.g_sugiSam ? (Globals.g_configure && Globals.g_install ? "PanelMachineInstallConfig" : (this.m_configOnly ? "PanelMachineConfig" : "PanelMachine")) : "PanelMachineAdditional";
        return helpTopic;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_machineComboBox) {
            this.m_selectedTitle = (String)this.m_machineComboBox.getSelectedItem();
            this.loadTableModel();
        } else if (obj == this.m_subsetsComboBox) {
            this.m_componentTableModel.selectSubset();
        } else if (obj == this.m_findButton) {
            this.findProductText();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_findText && Globals.g_wizard.getFrame() != null) {
            if (this.m_findText.getText().length() > 0) {
                Globals.g_wizard.getFrame().getRootPane().setDefaultButton(this.m_findButton);
            } else {
                Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_findText && Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
        }
    }

    private void findProductText() {
        int rowFound = -1;
        String findText = this.m_findText.getText().trim().toLowerCase();
        if (findText.length() > 0) {
            ComponentData data;
            String id;
            int i;
            ArrayList componentIds = this.m_componentTableModel.getComponentIds();
            HashMap components = this.m_componentTableModel.getComponents();
            for (i = this.m_componentTable.getSelectedRow() + 1; rowFound == -1 && i < this.m_componentTable.getRowCount(); ++i) {
                id = (String)componentIds.get(i);
                data = (ComponentData)components.get(id);
                if (data.getExtendedProdName().toLowerCase().indexOf(findText) <= -1) continue;
                rowFound = i;
            }
            if (rowFound == -1) {
                for (i = 0; rowFound == -1 && i <= this.m_componentTable.getSelectedRow(); ++i) {
                    id = (String)componentIds.get(i);
                    data = (ComponentData)components.get(id);
                    if (data.getExtendedProdName().toLowerCase().indexOf(findText) <= -1) continue;
                    rowFound = i;
                }
            }
            if (rowFound > -1) {
                this.m_componentTable.setRowSelectionInterval(rowFound, rowFound);
                this.m_componentTable.setColumnSelectionInterval(0, 0);
                this.m_componentTable.scrollRectToVisible(this.m_componentTable.getCellRect(rowFound, 0, true));
            } else {
                String title = Globals.g_wizard.getWizardTitle();
                String message = this.bundle.messageString("PanelMachine.NotFoundMsg.txt", this.m_findText.getText());
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, title, 1);
            }
        }
    }

    private void populate() {
        this.setComboBoxLabelAndTooltip();
        Vector<String> selectionTitles = null;
        if (Globals.g_plan != null) {
            selectionTitles = Globals.g_plan.getMachineSelTitles();
        }
        if (selectionTitles == null) {
            this.m_selectedTitle = null;
            this.loadTableModel();
        } else if (Globals.g_plannedInstall) {
            int index = -1;
            this.m_machineComboBox.removeAllItems();
            if (!Globals.g_consoleMode) {
                this.m_machineComboBox.addItem(this.bundle.getString("PanelMachine.SelectOneMachine.txt"));
            }
            String hostname = null;
            String hostnameC = null;
            if (this.m_responseMachine != null) {
                hostname = this.m_responseMachine;
                if (hostname.startsWith(RESPONSE_STEP_PREFIX)) {
                    String stepAsString = hostname.substring(RESPONSE_STEP_PREFIX.length());
                    Integer stepAsInt = null;
                    try {
                        stepAsInt = Integer.valueOf(stepAsString);
                        index = stepAsInt - 1;
                    }
                    catch (Exception e) {
                        Logging.log.info("Invalid step definition for machine in response file: " + hostname);
                    }
                }
            } else {
                try {
                    InetAddress address = InetAddress.getLocalHost();
                    hostname = Utils.getShortHostName(address);
                    hostnameC = Utils.getFullHostName(address);
                }
                catch (Exception e) {
                    Logging.log.info("IP address for the host could not be found: " + hostname);
                }
            }
            if (selectionTitles.size() == 1) {
                this.m_machineComboBox.setEnabled(false);
                index = 0;
            } else {
                this.m_machineComboBox.setEnabled(true);
            }
            Iterator<String> titlIt = selectionTitles.iterator();
            int tryIndex = -1;
            while (titlIt.hasNext()) {
                String stepTitle = titlIt.next();
                this.m_machineComboBox.addItem(stepTitle);
                if (index != -1) continue;
                ++tryIndex;
                Plan.Machine machine = Globals.g_plan.getMachineFromTitle(stepTitle);
                String machineName = machine.getProperty("Full Name");
                if (machineName != null && machineName.length() > 0 && (machineName.equalsIgnoreCase(hostname) || machineName.equalsIgnoreCase(hostnameC) || machineName.equalsIgnoreCase("localhost"))) {
                    index = tryIndex;
                }
                if (index != -1 || (machineName = machine.getName()) == null || machineName.length() <= 0 || !machineName.equalsIgnoreCase(hostname) && !machineName.equalsIgnoreCase(hostnameC) && !machineName.equalsIgnoreCase("localhost")) continue;
                index = tryIndex;
            }
            if (index != -1) {
                if (Globals.g_consoleMode) {
                    this.m_machineComboBox.setSelectedIndex(index);
                } else {
                    this.m_machineComboBox.setSelectedIndex(index + 1);
                }
                this.m_selectedTitle = (String)this.m_machineComboBox.getSelectedItem();
            } else {
                this.m_componentTableModel.clear();
                this.m_componentTableModel.fireTableStructureChanged();
                this.installRenderers();
                this.m_selectAllButton.setEnabled(false);
                this.m_clearAllButton.setEnabled(false);
                this.m_selectedTitle = null;
            }
        } else if (selectionTitles.size() == 1) {
            this.m_selectedTitle = selectionTitles.firstElement();
            this.loadTableModel();
        }
    }

    private void loadTableModel() {
        if (this.m_selectedTitle != null) {
            if (this.m_selectedTitle.equalsIgnoreCase(this.bundle.getString("PanelMachine.SelectOneMachine.txt"))) {
                this.m_componentTableModel.clear();
                this.m_selectAllButton.setEnabled(false);
                this.m_clearAllButton.setEnabled(false);
                this.m_warningImage.setVisible(false);
                this.m_warningMessage.setVisible(false);
            } else {
                Plan.Machine machine = Globals.g_plan.getMachineFromTitle(this.m_selectedTitle);
                if (machine != null) {
                    if (machine.isDeployedSupported()) {
                        this.m_warningImage.setVisible(false);
                        this.m_warningMessage.setVisible(false);
                    } else {
                        this.m_warningImage.setVisible(this.m_machineVisible);
                        this.m_warningMessage.setVisible(this.m_machineVisible);
                    }
                    this.m_componentTableModel.load(machine);
                } else {
                    this.m_warningImage.setVisible(false);
                    this.m_warningMessage.setVisible(false);
                }
            }
        } else {
            this.m_warningImage.setVisible(false);
            this.m_warningMessage.setVisible(false);
            this.m_componentTableModel.load(null);
        }
    }

    private String getInfoLink(int row) {
        String link = null;
        if (row >= 0 && row < this.m_productData.length) {
            String prodCode = this.m_productData[row].getProdCode();
            SpsSkuData prodSku = Globals.g_deploymentData.getSpsSku(this.m_productData[row].getSpsSku());
            link = prodSku.loadProdDescription();
        }
        return link;
    }

    private ProductData[] getZOSProducts(String[] prodCodes) {
        ProductData[] products = null;
        boolean sasFound = false;
        for (int i = 0; !sasFound && i < prodCodes.length; ++i) {
            if (!prodCodes[i].equalsIgnoreCase("sasinstall") && !prodCodes[i].equalsIgnoreCase("zosinstwiz")) continue;
            sasFound = true;
            ProductData zOSInstWiz = Globals.g_deploymentData.getProduct(Globals.g_order, "zosinstwiz", false);
            products = zOSInstWiz != null ? new ProductData[]{zOSInstWiz} : new ProductData[]{};
        }
        if (!sasFound) {
            products = new ProductData[]{};
        }
        return products;
    }

    private boolean isSasinstallSelected() {
        boolean selected = false;
        if (Globals.g_selectedInstalls == null) {
            selected = true;
        } else {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                if (!"sasinstall".equalsIgnoreCase(Globals.g_selectedInstalls[i].getProdCode())) continue;
                selected = true;
            }
        }
        return selected;
    }

    private boolean isAddonMode(ComponentData data) {
        return Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired() && !data.getProductData().isInstalled() && Globals.g_sasHomeStatus.isWebinfdsvrRemovedFromUpdateChain();
    }

    static /* synthetic */ ProductData[] access$802(PanelMachine x0, ProductData[] x1) {
        x0.m_productData = x1;
        return x1;
    }

    public class ToolTipTable
    extends JTable {
        public ToolTipTable(TableModel model) {
            super(model);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return PanelMachine.this.m_componentTableModel.getToolTipText(e);
        }
    }

    class InstallColumnActionListener
    implements ActionListener {
        InstallColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelMachine.this.m_selectAllButton) {
                PanelMachine.this.m_componentTableModel.selectAllInstall(true);
            } else if (e.getSource() == PanelMachine.this.m_clearAllButton) {
                PanelMachine.this.m_componentTableModel.selectAllInstall(false);
            }
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1039755031254835968L;
        private JCheckBox m_checkBox;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelMachine.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelMachine.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(data.getExtendedProdName());
                    this.m_checkBox.setSelected(data.doInstall());
                }
            }
            return this.m_checkBox;
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2422980246659985705L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelMachine.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelMachine.this.m_componentTableModel.getComponents().get(id);
                    this.setText(data.getExtendedProdName());
                    this.setSelected(data.doInstall());
                }
            }
            return this;
        }
    }

    private class ConfigOnlyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4377226759659722019L;

        private ConfigOnlyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof String) {
                    this.setText((String)value);
                }
            }
            return this;
        }
    }

    private class InfoCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6398437269054933481L;

        public InfoCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            String link = null;
            if (row >= 0 && row < PanelMachine.this.m_productData.length) {
                String prodCode = PanelMachine.this.m_productData[row].getProdCode();
                SpsSkuData prodSku = Globals.g_deploymentData.getSpsSku(PanelMachine.this.m_productData[row].getSpsSku());
                link = prodSku.loadProdDescription();
                if (link == null || link.length() == 0) {
                    this.setIcon(null);
                    Logging.log.info(prodCode + " in " + PanelMachine.this.m_productData[row].getProdVersion() + " does not have description");
                } else {
                    this.setIcon(PanelMachine.this.bundle.getImageIcon("Common.info.image"));
                }
            }
            return this;
        }
    }

    class ComponentData {
        protected ProductData m_productData;
        protected boolean m_installable = false;
        protected boolean m_install = false;
        protected String m_prodNameExtended = null;

        public ComponentData(ProductData productData) {
            this.m_productData = productData;
        }

        public ProductData getProductData() {
            return this.m_productData;
        }

        public String getIdentifier() {
            return this.m_productData.getProdCode();
        }

        public String getName() {
            return this.m_productData.getProdName();
        }

        public boolean isInstallable() {
            return this.m_installable;
        }

        public void setInstallable(boolean installable) {
            this.m_installable = installable;
        }

        public boolean doInstall() {
            return this.m_install;
        }

        public void setInstall(boolean install) {
            this.m_install = install;
        }

        public String getExtendedProdName() {
            if (this.m_prodNameExtended != null && this.m_prodNameExtended.length() > 0) {
                return this.m_prodNameExtended;
            }
            return this.m_productData.getProdName();
        }

        public void setExtendedProdName(String prodNameExtended) {
            this.m_prodNameExtended = prodNameExtended;
        }
    }

    class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8283934554498211136L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        public static final int COMPONENT_INFO_COLUMN = 1;
        protected String[] m_columnNames;
        protected HashMap m_components = new HashMap();
        protected ArrayList m_componentIds = new ArrayList();

        public ComponentTableModel() {
            this.m_columnNames = new String[]{PanelMachine.this.bundle.getString("PanelMachine.ComponentTable.NameColumn.Title.txt"), PanelMachine.this.bundle.getString("PanelMachine.ComponentTable.InfoColumn.Title.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            if (index == 0) {
                if (PanelMachine.this.m_configOnly) {
                    return String.class;
                }
                return Boolean.class;
            }
            if (index == 1) {
                return String.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                if (colIndex == 0) {
                    if (PanelMachine.this.m_configOnly) {
                        return component.getName();
                    }
                    return component.doInstall();
                }
                if (colIndex == 1) {
                    return null;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            boolean editable = false;
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                if (!PanelMachine.this.m_configOnly && colIndex == 0) {
                    editable = component.isInstallable();
                }
            }
            return editable;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0 && !PanelMachine.this.m_configOnly) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                component.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load(Plan.Machine machine) {
            int i;
            this.m_components.clear();
            this.m_componentIds.clear();
            PanelMachine.this.m_serverSubset.clear();
            PanelMachine.this.m_clientSubset.clear();
            String sasinstallName = null;
            if (machine != null) {
                String[] deployedProducts = machine.getDeployedComponentIds();
                Globals.g_sasinstallPlat = null;
                Globals.g_jmpPlat = null;
                Globals.g_pcfilesrvPlat = null;
                Globals.g_eguidePlat = null;
                Globals.g_msofficeintPlat = null;
                if (Globals.g_zos) {
                    PanelMachine.access$802(PanelMachine.this, PanelMachine.this.getZOSProducts(deployedProducts));
                } else {
                    boolean sasFound = false;
                    boolean jmpFound = false;
                    boolean pcfilesrvFound = false;
                    boolean eguideFound = false;
                    boolean msofficeintFound = false;
                    for (i = 0; !(sasFound && jmpFound && pcfilesrvFound && msofficeintFound && eguideFound || i >= deployedProducts.length); ++i) {
                        if (deployedProducts[i].equalsIgnoreCase("sasinstall")) {
                            sasFound = true;
                            if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false) != null) continue;
                            if (Utils.getOS_Suffix().equals("wx6")) {
                                if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false) == null) continue;
                                Globals.g_sasinstallPlat = "win";
                                continue;
                            }
                            if (Utils.getOS_Suffix().equals("lax")) {
                                if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false) == null) continue;
                                Globals.g_sasinstallPlat = "lnx";
                                continue;
                            }
                            if (!Utils.getOS_Suffix().equals("mvs") || Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "mvs", false) == null) continue;
                            Globals.g_sasinstallPlat = "mvs";
                            continue;
                        }
                        if (deployedProducts[i].equalsIgnoreCase("jmp")) {
                            jmpFound = true;
                            if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", false) != null) continue;
                            if (Utils.getOS_Suffix().equals("wx6")) {
                                if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "win", false) == null) continue;
                                Globals.g_jmpPlat = "win";
                                continue;
                            }
                            if (!Utils.getOS_Suffix().equals("lax") || Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "lnx", false) == null) continue;
                            Globals.g_jmpPlat = "lnx";
                            continue;
                        }
                        if (deployedProducts[i].equalsIgnoreCase("pcfilesrv")) {
                            pcfilesrvFound = true;
                            if (Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", false) != null || !Utils.getOS_Suffix().equals("wx6") || Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", "win", false) == null) continue;
                            Globals.g_pcfilesrvPlat = "win";
                            continue;
                        }
                        if (deployedProducts[i].equalsIgnoreCase("eguide")) {
                            eguideFound = true;
                            if (Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", false) != null || !Utils.getOS_Suffix().equals("wx6") || Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", false) == null) continue;
                            Globals.g_eguidePlat = "win";
                            continue;
                        }
                        if (!deployedProducts[i].equalsIgnoreCase("msofficeint")) continue;
                        msofficeintFound = true;
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", false) != null || !Utils.getOS_Suffix().equals("wx6") || Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", false) == null) continue;
                        Globals.g_msofficeintPlat = "win";
                    }
                    PanelMachine.access$802(PanelMachine.this, Globals.g_deploymentData.getProducts(Globals.g_order, deployedProducts, false));
                }
            } else {
                ProductData[] fullProductList = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false);
                ArrayList<String> newProductList = new ArrayList<String>();
                boolean inDB = false;
                for (int i2 = 0; i2 < fullProductList.length; ++i2) {
                    inDB = Globals.g_deploymentData.getSpsSku(fullProductList[i2].getSpsSku()).getIndb();
                    String language = Globals.g_deploymentData.getSpsSku(fullProductList[i2].getSpsSku()).getLanguage();
                    if (!"xx".equals(language) && !"en".equals(language) && !"ne".equals(language)) continue;
                    if (!(fullProductList[i2].getProdCode().equalsIgnoreCase("zosinstwiz") || !fullProductList[i2].getProdCode().equalsIgnoreCase("sasinstall") && fullProductList[i2].isFoundation())) {
                        if (Globals.g_standaloneInstalls) {
                            if (fullProductList[i2].getSelectableType() == 3) {
                                newProductList.add(fullProductList[i2].getProdCode());
                            }
                        } else if (!(fullProductList[i2].getSelectableType() != 1 && fullProductList[i2].getSelectableType() != 3 || inDB)) {
                            newProductList.add(fullProductList[i2].getProdCode());
                        }
                    }
                    if (!fullProductList[i2].getProdCode().equalsIgnoreCase("sasinstall")) continue;
                    sasinstallName = fullProductList[i2].getProdName();
                }
                if (!Globals.g_z64) {
                    Globals.g_sasinstallPlat = null;
                }
                Globals.g_jmpPlat = null;
                Globals.g_pcfilesrvPlat = null;
                Globals.g_eguidePlat = null;
                Globals.g_msofficeintPlat = null;
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false) == null) {
                    if (Utils.getOS_Suffix().equals("wx6")) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "win";
                        } else if (Globals.g_deploymentData.getProduct(Globals.g_order, "base", "win", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "win";
                        }
                    } else if (Utils.getOS_Suffix().equals("lax")) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "lnx";
                        } else if (Globals.g_deploymentData.getProduct(Globals.g_order, "base", "lnx", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "lnx";
                        }
                    } else if (Utils.getOS_Suffix().equals("mvs") && Globals.g_z64) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "z64", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "z64";
                        } else if (Globals.g_deploymentData.getProduct(Globals.g_order, "base", "z64", false) != null) {
                            newProductList.add("sasinstall");
                            Globals.g_sasinstallPlat = "z64";
                        }
                    }
                }
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", false) == null) {
                    if (Utils.getOS_Suffix().equals("wx6")) {
                        if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "win", false) != null) {
                            newProductList.add("jmp");
                            Globals.g_jmpPlat = "win";
                        }
                    } else if (Utils.getOS_Suffix().equals("lax") && Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "lnx", false) != null) {
                        newProductList.add("jmp");
                        Globals.g_jmpPlat = "lnx";
                    }
                }
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", "win", false) != null) {
                    newProductList.add("pcfilesrv");
                    Globals.g_pcfilesrvPlat = "win";
                }
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", false) != null) {
                    newProductList.add("eguide");
                    Globals.g_eguidePlat = "win";
                }
                if (Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", false) != null) {
                    newProductList.add("msofficeint");
                    Globals.g_msofficeintPlat = "win";
                }
                PanelMachine.access$802(PanelMachine.this, Globals.g_deploymentData.getProducts(Globals.g_order, newProductList.toArray(new String[0]), false));
                int swapPos = 0;
                ProductData swapData = null;
                for (i = 0; i < PanelMachine.this.m_productData.length; ++i) {
                    swapPos = i;
                    for (int j = i; j < PanelMachine.this.m_productData.length; ++j) {
                        if (PanelMachine.this.m_productData[j].getProdName().toLowerCase(Locale.ENGLISH).compareTo(PanelMachine.this.m_productData[swapPos].getProdName().toLowerCase(Locale.ENGLISH)) >= 0) continue;
                        swapPos = j;
                    }
                    swapData = PanelMachine.this.m_productData[i];
                    ((PanelMachine)PanelMachine.this).m_productData[i] = PanelMachine.this.m_productData[swapPos];
                    ((PanelMachine)PanelMachine.this).m_productData[swapPos] = swapData;
                }
            }
            if (!(Utils.isDeploywizWebOrder() || PanelMachine.this.m_productData != null && PanelMachine.this.m_productData.length != 0)) {
                if (!Globals.g_quietMode) {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), PanelMachine.this.bundle.getString("PanelMachine.NoProductDataMsg.txt"), PanelMachine.this.bundle.getString("Common.Warning.txt"), 2);
                }
                return;
            }
            Globals.g_selectedInstalls = new ProductData[PanelMachine.this.m_productData.length];
            boolean advanced = false;
            boolean standalone = false;
            boolean reqWebServer = false;
            String prodCode = null;
            String prodName = null;
            String[] subsets = null;
            for (i = 0; i < PanelMachine.this.m_productData.length; ++i) {
                prodCode = PanelMachine.this.m_productData[i].getProdCode();
                prodName = PanelMachine.this.m_productData[i].getProdName();
                if (Globals.g_debug) {
                    prodName = prodName + " (" + prodCode + ")";
                }
                if (Globals.g_sugiSam) {
                    subsets = Globals.g_deploymentData.getSpsSku(PanelMachine.this.m_productData[i].getSpsSku()).getSelectGroups();
                    if (subsets != null && subsets.length > 0) {
                        String selectGroup = null;
                        for (int j = 0; j < subsets.length; ++j) {
                            selectGroup = subsets[j];
                            if (selectGroup.equalsIgnoreCase("server")) {
                                PanelMachine.this.m_serverSubset.put(prodCode, null);
                                continue;
                            }
                            if (selectGroup.equalsIgnoreCase("client")) {
                                PanelMachine.this.m_clientSubset.put(prodCode, null);
                                continue;
                            }
                            Logging.log.warning("Unknown select group in select.xml for " + prodCode + ":" + selectGroup);
                        }
                    }
                    advanced = Globals.g_deploymentData.getSpsSku(PanelMachine.this.m_productData[i].getSpsSku()).advancedInstall();
                    standalone = PanelMachine.this.m_productData[i].getSelectableType() == 3;
                    reqWebServer = Globals.g_deploymentData.getSpsSku(PanelMachine.this.m_productData[i].getSpsSku()).requiresWebServer();
                    if (advanced) {
                        prodName = prodName + " " + PanelMachine.this.bundle.getString("PanelMachine.AdvancedTag.txt");
                    }
                    if (standalone && sasinstallName != null) {
                        prodName = prodName + " " + PanelMachine.this.bundle.getString("PanelMachine.InstalledWithTag.txt");
                    }
                    if (reqWebServer) {
                        prodName = prodName + " " + PanelMachine.this.bundle.getString("PanelMachine.RequiresWebServerTag.txt");
                    }
                }
                Globals.g_selectedInstalls[i] = PanelMachine.this.m_productData[i];
                ComponentData data = new ComponentData(PanelMachine.this.m_productData[i]);
                data.setExtendedProdName(prodName);
                this.m_componentIds.add(prodCode);
                data.setInstallable(true);
                if (PanelMachine.this.m_responseProducts != null) {
                    if (PanelMachine.this.m_responseProducts.containsKey(prodCode.toLowerCase(Locale.ENGLISH))) {
                        data.setInstall(true);
                    } else {
                        data.setInstall(false);
                    }
                } else if (Globals.g_sugiSam) {
                    data.setInstall(!advanced);
                } else if (Globals.g_plannedInstall) {
                    data.setInstall(true);
                } else {
                    data.setInstall(false);
                }
                if (prodCode.equals("webinfdsvr") && PanelMachine.this.isAddonMode(data) && !Globals.g_quietMode) {
                    data.setInstall(false);
                }
                this.m_components.put(prodCode, data);
            }
            Globals.g_planConfigs = Globals.g_configure && machine != null ? machine.getConfiguredComponentIds() : new String[0];
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelMachine.this.installRenderers();
            PanelMachine.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelMachine.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
        }

        public void selectAllInstall(boolean value) {
            String id = null;
            ComponentData data = null;
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                id = (String)this.m_componentIds.get(i);
                data = (ComponentData)this.m_components.get(id);
                if (data == null || !data.isInstallable()) continue;
                data.setInstall(value);
            }
            this.fireTableDataChanged();
        }

        public void selectSubset() {
            boolean clientSubset;
            boolean serverSubset = PanelMachine.this.m_subsetsComboBox.getSelectedIndex() == 0;
            boolean bl = clientSubset = PanelMachine.this.m_subsetsComboBox.getSelectedIndex() == 1;
            if (Globals.g_deploymentData.getOrder(Globals.g_order).isWeb()) {
                this.selectAllInstall(true);
            } else {
                this.selectAllInstall(false);
                String id = null;
                ComponentData data = null;
                for (int i = 0; i < this.m_componentIds.size(); ++i) {
                    id = (String)this.m_componentIds.get(i);
                    data = (ComponentData)this.m_components.get(id);
                    if (data == null || !data.isInstallable()) continue;
                    if (serverSubset) {
                        if (!PanelMachine.this.m_serverSubset.containsKey(id)) continue;
                        data.setInstall(true);
                        continue;
                    }
                    if (!clientSubset || !PanelMachine.this.m_clientSubset.containsKey(id)) continue;
                    data.setInstall(true);
                }
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this.m_components.clear();
            this.m_componentIds.clear();
            this.fireTableDataChanged();
        }

        public ArrayList getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap getComponents() {
            return this.m_components;
        }

        public String getToolTipText(MouseEvent e) {
            String toolTip = null;
            int row = PanelMachine.this.m_componentTable.rowAtPoint(e.getPoint());
            int col = PanelMachine.this.m_componentTable.columnAtPoint(e.getPoint());
            if (col == 1) {
                toolTip = PanelMachine.this.getInfoLink(row);
            }
            return toolTip;
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        private void setDefaultButton() {
            if (Globals.g_wizard.getFrame() != null) {
                if (PanelMachine.this.m_findText.getText().length() > 0) {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(PanelMachine.this.m_findButton);
                } else {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
                }
            }
        }
    }
}

