/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelLocaleSetupManagerFinish
implements WizardPanelIface,
ActionListener {
    public static final int IDTYPE_INSTALL = 0;
    public static final int IDTYPE_SSD = 1;
    private SSNResource bundle = new SSNResource(PanelLocaleSetupManagerFinish.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JCheckBox m_runSDW = null;
    private PageFormat m_pageFormat = null;
    private static List<String> productList = new ArrayList<String>();
    private static String newLocale = "";
    private static String mvaLanguage = null;

    public PanelLocaleSetupManagerFinish() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelLocaleSetupManagerFinish.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_recordMode) {
            return this.bundle.getString("PanelLocaleSetupManagerFinish.HeaderDescRecordOnly.txt");
        }
        return this.bundle.getString("PanelLocaleSetupManagerFinish.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        String tempProdId = null;
        for (int i = PanelLocaleSetupManagerFinish.getProductList().size() - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (PanelLocaleSetupManagerFinish.getProductList().get(j).compareTo(PanelLocaleSetupManagerFinish.getProductList().get(j + 1)) <= 0) continue;
                tempProdId = PanelLocaleSetupManagerFinish.getProductList().get(j);
                PanelLocaleSetupManagerFinish.getProductList().set(j, PanelLocaleSetupManagerFinish.getProductList().get(j + 1));
                PanelLocaleSetupManagerFinish.getProductList().set(j + 1, tempProdId);
            }
        }
        if (!Globals.g_consoleMode) {
            this.updateTextArea();
            JButton m_nextButton = wizardFramework.getNextButton();
            if (m_nextButton.getPreferredSize().getWidth() < m_nextButton.getMinimumSize().getWidth()) {
                m_nextButton.setPreferredSize(null);
            }
        }
        Logging.log.info("The region setting for SAS software has been changed from to " + newLocale);
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = true;
        if (Globals.g_partialPrompt) {
            valid = false;
        }
        if (Globals.g_skipStatusPanels) {
            valid = true;
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.println(this.bundle.messageString("PanelLocaleSetupManagerFinish.NewRegionalSetting.txt", newLocale));
        ConsoleMode.println("");
        if (mvaLanguage != null) {
            String mvaLanguageName = this.bundle.getString("Common.LangCode" + mvaLanguage.toUpperCase() + ".txt");
            ConsoleMode.println(this.bundle.messageString("PanelLocaleSetupManagerFinish.DefaultLanguage.txt", mvaLanguageName));
            ConsoleMode.println("");
        }
        ConsoleMode.println(this.bundle.getString("PanelLocaleSetupManagerFinish.FollowingProducts.txt"));
        for (String product : PanelLocaleSetupManagerFinish.getProductList()) {
            ConsoleMode.println(product);
        }
        return ConsoleMode.promptPause(false, true);
    }

    private void initialize() {
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelLocaleSetupManagerFinish.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public static List<String> getProductList() {
        return productList;
    }

    public static void setNewLocale(String locale) {
        newLocale = locale;
    }

    public static void setDefaultMVALanguage(String language) {
        mvaLanguage = language;
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        if (this.m_instructions != null) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 10, 0);
            this.m_panel.add((Component)this.m_instructions, c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        if (this.m_runSDW != null) {
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 12;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_runSDW, c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void updateTextArea() {
        String listText = "<html>";
        listText = listText + "<table valign=top cellspacing=1 cellpadding=0>";
        listText = listText + "<tr>";
        listText = listText + "<td nowrap>" + this.bundle.messageString("PanelLocaleSetupManagerFinish.NewRegionalSetting.txt", newLocale) + "</td>";
        listText = listText + "</tr>";
        listText = listText + "<tr>";
        listText = listText + "<td nowrap>&nbsp;</td>";
        listText = listText + "</tr>";
        if (mvaLanguage != null) {
            String mvaLanguageName = this.bundle.getString("Common.LangCode" + mvaLanguage.toUpperCase() + ".txt");
            listText = listText + "<tr>";
            listText = listText + "<td nowrap>" + this.bundle.messageString("PanelLocaleSetupManagerFinish.DefaultLanguage.txt", mvaLanguageName) + "</td>";
            listText = listText + "</tr>";
            listText = listText + "<tr>";
            listText = listText + "<td nowrap>&nbsp;</td>";
            listText = listText + "</tr>";
        }
        listText = listText + "<tr>";
        listText = listText + "<td nowrap>" + this.bundle.getString("PanelLocaleSetupManagerFinish.FollowingProducts.txt") + "</td>";
        listText = listText + "</tr>";
        for (String product : PanelLocaleSetupManagerFinish.getProductList()) {
            listText = listText + "<tr>";
            listText = listText + "<td nowrap>" + product + "</td>";
            listText = listText + "</tr>";
        }
        listText = listText + "</table>";
        listText = listText + "</html>";
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText.setText(listText);
        this.m_summaryText.setCaretPosition(0);
        this.m_summaryText.revalidate();
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelLocaleSetupManagerFinish.this.m_summaryText, PanelLocaleSetupManagerFinish.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelLocaleSetupManagerFinish.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelLocaleSetupManagerFinish.this.m_summaryText, PanelLocaleSetupManagerFinish.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelLocaleSetupManagerFinish.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

