/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Kit;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelLocaleSetupManagerFinish;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASLocale;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.lsm.JavaProductsWithLauncherFiles;
import com.sas.ssn.lsm.LocaleSetupManager;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.DeploymentXMLReader;
import com.sas.tools.installs.schema.ittasks.LocaleType;
import com.sas.tools.installs.schema.ittasks.LocalesForHostType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelLocaleSetupManager
implements WizardPanelIface {
    private static SASLocale m_fallbackSASLocaleForMVS = null;
    private static SASLocale m_fallbackSASLocaleForWIN = null;
    private static SASLocale m_fallbackSASLocaleForUNX = null;
    private final SSNResource bundle = new SSNResource(PanelLocaleSetupManager.class);
    private final JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_locale_info = null;
    private JTextArea m_product_info = null;
    private JComboBox m_locale = null;
    private JLabel m_localeLabel = null;
    private boolean m_panelLoaded = false;
    private JScrollPane m_listScrollPane = null;
    private JTable m_prodList = null;
    private ProductTableModel m_prodListModel = null;
    private ActionListener m_prodActionListener = null;
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private String m_platformFamily = null;
    private String m_loadedForOrder = null;
    private String selectedProdcutsResponse = "";
    private static final int PROMPT_YES = 0;
    private static final int PROMPT_NO = 1;
    private RegistryAccess registryAccess = null;
    private ArrayList<String> m_productIds = new ArrayList();
    private HashMap<String, ProductLocaleSelectionData> m_products = new HashMap();
    LocaleSetupManager localeSetupManager = null;

    public PanelLocaleSetupManager() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelLocaleSetupManager.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_recordMode) {
            return this.bundle.getString("PanelLocaleSetupManager.HeaderDescRecordOnly.txt");
        }
        return this.bundle.getString("PanelLocaleSetupManager.HeaderDesc.txt");
    }

    private String getPriorSASEncoding() {
        String priorSASEncoding = "";
        try {
            RegistryData.setRegistry(Globals.g_cmtSASHome);
            this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (this.registryAccess.open()) {
                priorSASEncoding = this.registryAccess.getSashomeEncodingName();
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.info("Deployment registry jar not found: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        catch (Exception e) {
            Logging.log.info("Failed to load deployment registry jar: " + RegistryData.getDeployRegJar());
            Logging.logStackTrace(e);
        }
        finally {
            if (this.registryAccess != null) {
                this.registryAccess.close();
            }
        }
        return priorSASEncoding;
    }

    private boolean notifyUserOfChangedEncoding(String sasEncoding) {
        String priorSASEncoding = this.getPriorSASEncoding();
        if (!priorSASEncoding.equalsIgnoreCase("utf-8") && !priorSASEncoding.equalsIgnoreCase(sasEncoding)) {
            if (Globals.g_quietMode) {
                Logging.log.info("The encoding of SAS software will be changed from " + priorSASEncoding + " to " + sasEncoding);
                return true;
            }
            boolean promptVal = true;
            int defaultButton = 1;
            String msgTxt = this.bundle.messageString("PanelLocaleSetupManager.QuestionBox.EncodingToChange.txt", priorSASEncoding, sasEncoding);
            Object[] options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt"))};
            if (Globals.g_consoleMode) {
                ConsoleMode.printInfoText(msgTxt);
                int returnCode = ConsoleMode.promptSingleChoice((String[])options, null, null, defaultButton, true);
                if (returnCode == 0) {
                    promptVal = false;
                } else if (returnCode == 1) {
                    promptVal = true;
                }
            } else {
                JEditorPane msgArea = new JEditorPane();
                msgArea.setOpaque(false);
                msgArea.setEditable(false);
                msgArea.setContentType("text/html");
                String msgPrefix = "<html><font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
                String msgPostfix = "</font></html>";
                msgArea.setText(msgPrefix + msgTxt + msgPostfix);
                msgArea.setCaretPosition(0);
                String title = this.bundle.getString("PanelLocaleSetupManager.QuestionBox.Title.txt");
                switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 0, 2, null, options, options[defaultButton])) {
                    case 0: {
                        promptVal = false;
                        break;
                    }
                    default: {
                        promptVal = true;
                    }
                }
            }
            if (!promptVal) {
                Logging.log.info("The encoding of SAS software will be changed from " + priorSASEncoding + " to " + sasEncoding);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validateData() {
        boolean baseIsSelected = false;
        SASLocale selectedLocale = this.m_locale.getSelectedIndex() > -1 ? (SASLocale)this.m_locale.getSelectedItem() : this.getFallbackSASLocale();
        if (this.noProductsForLocaleSetup()) {
            return false;
        }
        String mvaPosixName = selectedLocale.getMVAPosixName();
        String sasEncoding = selectedLocale.getSASEncoding();
        PanelLocaleSetupManagerFinish.getProductList().clear();
        this.selectedProdcutsResponse = "";
        PanelLocaleSetupManagerFinish.setNewLocale(this.bundle.getString("Common.LocaleDisplayName." + mvaPosixName + ".txt"));
        if (mvaPosixName == null) {
            Logging.log.warning("MVA posix locale name not available for the selected locale");
        } else {
            String[] languageAndCountry = selectedLocale.getMVAPosixName().split("_");
            if (languageAndCountry.length == 2) {
                ArrayList<String> productKeys = new ArrayList<String>();
                for (String productKey : this.m_productIds) {
                    ProductLocaleSelectionData selectionData = this.m_products.get(productKey);
                    if (!selectionData.getInstall()) continue;
                    if (this.selectedProdcutsResponse.length() > 0) {
                        this.selectedProdcutsResponse = this.selectedProdcutsResponse + ",";
                    }
                    this.selectedProdcutsResponse = this.selectedProdcutsResponse + productKey;
                    if (productKey.equals("base")) {
                        baseIsSelected = true;
                    } else {
                        productKeys.add(productKey);
                    }
                    ProductData productData = selectionData.getProductData();
                    String displayName = productData.getProdName();
                    String version = productData.getProdCustVersion();
                    PanelLocaleSetupManagerFinish.getProductList().add(displayName + " " + version);
                }
                if (baseIsSelected && !this.notifyUserOfChangedEncoding(sasEncoding)) {
                    return false;
                }
                if (Globals.g_recordMode) {
                    Logging.log.info("User is in record mode, therefore no changes will be made to the regional settings for the installed products.");
                } else {
                    if (!this.localeSetupManager.setLocaleForSelectedJavaProducts(mvaPosixName, productKeys)) {
                        Logging.log.severe("Unable to set locale settings for certain java products.");
                    }
                    PanelLocaleSetupManagerFinish.setDefaultMVALanguage(null);
                    if (baseIsSelected) {
                        if (!this.localeSetupManager.setLocaleForBase(mvaPosixName)) {
                            Logging.log.severe("Unable to set locale settings for SAS Foundation.");
                        }
                        if (this.localeSetupManager.updateDeploymentRegistry(mvaPosixName)) {
                            Logging.log.severe("Unable to set locale settings in the SAS deployment registry.");
                        }
                    }
                }
            } else {
                Logging.log.severe("MVA posix locale name missing a language or country code: " + mvaPosixName + ", locale settings will not be modified.");
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = "localesetupmanagerfinish";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.ensurePanelDataIsLoaded();
        if (!this.m_panelLoaded) {
            this.localeSetupManager = new LocaleSetupManager(Globals.g_cmtSASHome);
            this.loadProdInfo();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_locale;
    }

    @Override
    public boolean silentEvent() {
        this.ensurePanelDataIsLoaded();
        this.localeSetupManager = new LocaleSetupManager(Globals.g_cmtSASHome);
        this.loadProdInfo();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#REGION_SETTING=<locale setting code>", " REGION_SETTING=", "#PRODUCT_SELECTION_FOR_LOCALE=<products to apply the local setting to>", " PRODUCT_SELECTION_FOR_LOCALE="};
        if (this.m_panelLoaded) {
            data[1] = " REGION_SETTING=" + ((SASLocale)this.m_locale.getSelectedItem()).getMVAPosixName();
            data[3] = " PRODUCT_SELECTION_FOR_LOCALE=" + this.selectedProdcutsResponse;
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int i;
        int returnCode = ConsoleMode.promptComboBox(this.m_locale);
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_productIds.size()];
        String id = null;
        ProductLocaleSelectionData data = null;
        for (i = 0; i < options.length; ++i) {
            id = this.m_productIds.get(i);
            data = this.m_products.get(id);
            String displayName = this.m_products.get(id).getProductData().getProdName() + " " + this.m_products.get(id).getProductData().getProdCustVersion();
            options[i] = new ConsoleMode.SelectionItem(displayName, data.getInstall(), !data.getSelectable());
        }
        returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (i = 0; i < options.length; ++i) {
                id = this.m_productIds.get(i);
                data = this.m_products.get(id);
                data.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        String productSelectionResponse;
        boolean valid = false;
        String responseRegion = Wizard.getResponse("REGION_SETTING", null);
        if (responseRegion != null) {
            for (int i = 0; i < this.m_locale.getItemCount() && !valid; ++i) {
                SASLocale sasLocale = (SASLocale)this.m_locale.getItemAt(i);
                if (!responseRegion.equals(sasLocale.getMVAPosixName())) continue;
                this.m_locale.setSelectedItem(sasLocale);
                valid = true;
            }
            if (!valid) {
                Wizard.logResponseInvalid(this.getHeader(), "REGION_SETTING", responseRegion, null);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "REGION_SETTING");
            }
        }
        if ((productSelectionResponse = Wizard.getResponse("PRODUCT_SELECTION_FOR_LOCALE", null)) != null) {
            Vector<String> productKeys = new Vector<String>(Arrays.asList(productSelectionResponse.split(",")));
            String productKey = "";
            for (int i = 0; i < this.m_productIds.size(); ++i) {
                productKey = this.m_productIds.get(i);
                if (productKeys.contains(productKey)) {
                    this.m_products.get(productKey).setInstall(true);
                    continue;
                }
                this.m_products.get(productKey).setInstall(false);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "PRODUCT_SELECTION_FOR_LOCALE");
            }
        }
        return valid;
    }

    private void loadProdInfo() {
        this.m_prodListModel.load();
        int rowHeight = Utils.getPreferredRowHeight(this.m_prodList);
        if (rowHeight > 0) {
            this.m_prodList.setRowHeight(rowHeight);
        }
    }

    private void initialize() {
        this.m_locale_info = new JTextArea(this.bundle.getString("PanelLocaleSetupManager.LocaleInfo.txt"));
        this.m_locale_info.setEditable(false);
        this.m_locale_info.setFocusable(false);
        this.m_locale_info.setLineWrap(true);
        this.m_locale_info.setWrapStyleWord(true);
        this.m_locale_info.setOpaque(false);
        this.m_product_info = new JTextArea(this.bundle.getString("PanelLocaleSetupManager.SelectProducts.txt"));
        this.m_product_info.setEditable(false);
        this.m_product_info.setFocusable(false);
        this.m_product_info.setLineWrap(true);
        this.m_product_info.setWrapStyleWord(true);
        this.m_product_info.setOpaque(false);
        this.m_locale = new JComboBox();
        this.m_locale.setEnabled(true);
        this.m_locale.setMaximumRowCount(22);
        this.m_locale.setToolTipText(this.bundle.getString("PanelLocaleSetupManager.Tooltip.txt"));
        String mtxt = this.bundle.getString("PanelLocaleSetupManager.LocaleLabel.txt");
        this.m_localeLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_localeLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_localeLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_localeLabel.setLabelFor(this.m_locale);
        this.m_prodListModel = new ProductTableModel();
        this.m_prodList = new JTable(this.m_prodListModel);
        this.m_prodList.setCellSelectionEnabled(true);
        this.m_prodList.setSelectionMode(0);
        this.m_prodList.setTableHeader(null);
        this.m_prodList.setShowGrid(false);
        this.m_prodList.setOpaque(true);
        this.m_prodList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelLocaleSetupManager.this.m_prodList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_prodList);
        this.m_listScrollPane.getViewport().setBackground(this.m_prodList.getBackground());
        mtxt = this.bundle.getString("Common.SelectAll.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_selectAllButton = new JButton(txt);
        this.m_selectAllButton.setMnemonic(mkey);
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_clearAllButton = new JButton(txt);
        this.m_clearAllButton.setMnemonic(mkey);
        this.m_prodActionListener = new SelectClearActionListener();
        this.m_selectAllButton.addActionListener(this.m_prodActionListener);
        this.m_clearAllButton.addActionListener(this.m_prodActionListener);
        this.installRenderers();
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_locale_info, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 20, 5, 0);
        this.m_panel.add((Component)this.m_localeLabel, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 5, 5);
        this.m_panel.add((Component)this.m_locale, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 3;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_product_info, c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 4;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void ensurePanelDataIsLoaded() {
        this.m_platformFamily = Utils.getOS() == 8 ? "mvs" : (Utils.getOS() == 1 ? "win" : "unx");
        if (!Globals.g_order.equals(this.m_loadedForOrder)) {
            this.loadComboData();
            this.m_loadedForOrder = Globals.g_order;
        }
    }

    private void loadComboData() {
        String prevSelPosixName;
        SASLocale prevSelLocale = (SASLocale)this.m_locale.getSelectedItem();
        this.m_locale.removeAllItems();
        TreeSet<SASLocale> sasLocales = new TreeSet<SASLocale>(this.loadLocaleData().values());
        boolean matchingDefaultSet = false;
        Locale localeDefault = Locale.getDefault();
        String fallbackMVAPosixName = this.getFallbackSASLocale().getMVAPosixName();
        for (SASLocale sasLocale : sasLocales) {
            this.m_locale.addItem(sasLocale);
            if (matchingDefaultSet) continue;
            if ("mvs".equals(this.m_platformFamily)) {
                if (!sasLocale.isDefaultSelection()) continue;
                this.m_locale.setSelectedItem(sasLocale);
                matchingDefaultSet = true;
                continue;
            }
            if (sasLocale.isMatchForJavaLocale(localeDefault)) {
                this.m_locale.setSelectedItem(sasLocale);
                matchingDefaultSet = true;
                continue;
            }
            if (!fallbackMVAPosixName.equals(sasLocale.getMVAPosixName())) continue;
            this.m_locale.setSelectedItem(sasLocale);
        }
        if (prevSelLocale != null && (prevSelPosixName = prevSelLocale.getMVAPosixName()) != null) {
            boolean keepLooking = true;
            for (int i = 0; i < this.m_locale.getItemCount() && keepLooking; ++i) {
                SASLocale sasLocale = (SASLocale)this.m_locale.getItemAt(i);
                if (!prevSelPosixName.equals(sasLocale.getMVAPosixName())) continue;
                this.m_locale.setSelectedItem(sasLocale);
                keepLooking = false;
            }
        }
        if (this.m_locale.getSelectedIndex() < 0 && this.m_locale.getItemCount() > 0) {
            this.m_locale.setSelectedIndex(0);
        }
    }

    private Hashtable<String, SASLocale> loadLocaleData() {
        Hashtable<String, SASLocale> sasLocaleMap = new Hashtable<String, SASLocale>();
        DeploymentXMLReader m_reader = Kit.getDeploymentXMLReader();
        try {
            if (m_reader != null) {
                String[] processPlatforms;
                String encodingTwoByte = null;
                if ("mvs".equals(this.m_platformFamily)) {
                    encodingTwoByte = Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding();
                }
                for (String processPlatform : processPlatforms = new String[]{this.m_platformFamily, Utils.getOS_Suffix()}) {
                    List<LocaleType> localeTypes;
                    LocalesForHostType localesForHostType = m_reader.getLocalesForHost(processPlatform, encodingTwoByte);
                    if (localesForHostType == null || (localeTypes = localesForHostType.getLocale()) == null) continue;
                    for (LocaleType localeType : localeTypes) {
                        SASLocale sasLocale = new SASLocale(localeType, encodingTwoByte);
                        sasLocaleMap.put(sasLocale.getMVAPosixName(), sasLocale);
                    }
                }
            } else {
                Logging.log.warning("Locale Processing was unable to find the deployment.xml that contains locale/languae data");
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        if (sasLocaleMap.isEmpty()) {
            SASLocale fallbackLocale = this.getFallbackSASLocale();
            sasLocaleMap.put(fallbackLocale.getMVAPosixName(), fallbackLocale);
        }
        return sasLocaleMap;
    }

    private SASLocale getFallbackSASLocale() {
        SASLocale fallbackLocale;
        if ("mvs".equals(this.m_platformFamily)) {
            if (m_fallbackSASLocaleForMVS == null) {
                m_fallbackSASLocaleForMVS = new SASLocale("en_US", "open_ed-1047", "Cp1047", "ibm-1047", "SBCS", "w0");
                m_fallbackSASLocaleForMVS.setDefaultSelection(true);
            }
            fallbackLocale = m_fallbackSASLocaleForMVS;
        } else if ("win".equals(this.m_platformFamily)) {
            if (m_fallbackSASLocaleForWIN == null) {
                m_fallbackSASLocaleForWIN = new SASLocale("en_US", "wlatin1", "Cp1252");
            }
            fallbackLocale = m_fallbackSASLocaleForWIN;
        } else {
            if (m_fallbackSASLocaleForUNX == null) {
                m_fallbackSASLocaleForUNX = new SASLocale("en_US", "latin1", "ISO8859-1");
            }
            fallbackLocale = m_fallbackSASLocaleForUNX;
        }
        return fallbackLocale;
    }

    private void installRenderers() {
        this.m_prodList.getColumnModel().getColumn(0).setCellRenderer(new ProductCellRenderer());
        this.m_prodList.getColumnModel().getColumn(0).setCellEditor(new ProductCellEditor(new JCheckBox()));
    }

    private void constructProductData(String productCode) {
    }

    public boolean noProductsForLocaleSetup() {
        if (this.m_productIds.size() == 0) {
            if (Globals.g_quietMode) {
                Logging.log.severe("No products are available for Locale Setup on this machine.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelLocaleSetupManager.NoProductLocaleSetupMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_prodList.requestFocus();
            }
            return true;
        }
        return false;
    }

    class ProductTableModel
    extends AbstractTableModel {
        public static final int PRODUCT_COLUMN = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return PanelLocaleSetupManager.this.m_products.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String id = (String)PanelLocaleSetupManager.this.m_productIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                ProductLocaleSelectionData prodData = (ProductLocaleSelectionData)PanelLocaleSetupManager.this.m_products.get(id);
                selected = prodData.getInstall();
            }
            return selected;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String id = (String)PanelLocaleSetupManager.this.m_productIds.get(rowIndex);
            if (id != null && value instanceof Boolean) {
                ProductLocaleSelectionData prodData = (ProductLocaleSelectionData)PanelLocaleSetupManager.this.m_products.get(id);
                prodData.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public void load() {
            PanelLocaleSetupManager.this.m_products.clear();
            PanelLocaleSetupManager.this.m_productIds.clear();
            JavaProductsWithLauncherFiles javaProducts = PanelLocaleSetupManager.this.localeSetupManager.getJavaProducts();
            ArrayList<String> keys = new ArrayList<String>(javaProducts.getProductKeys());
            for (String key : keys) {
                ProductLocaleSelectionData productLocaleSelectionData = new ProductLocaleSelectionData(javaProducts.getProductData(key), true);
                PanelLocaleSetupManager.this.m_products.put(key, productLocaleSelectionData);
                PanelLocaleSetupManager.this.m_productIds.add(key);
            }
            if (PanelLocaleSetupManager.this.localeSetupManager.isBaseSASInstalled()) {
                ProductData baseProductData = new ProductData("base", "", "", "", PanelLocaleSetupManager.this.localeSetupManager.getBaseSASVersion(), "0", "", "", "SAS Foundation", 0, 0, 0, false, "", "", "", "", "", false, false, false, false, false, "", "", 0L);
                ProductLocaleSelectionData baseProductLocaleSelectionData = new ProductLocaleSelectionData(baseProductData, true);
                PanelLocaleSetupManager.this.m_products.put("base", baseProductLocaleSelectionData);
                PanelLocaleSetupManager.this.m_productIds.add("base");
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelLocaleSetupManager.this.installRenderers();
            PanelLocaleSetupManager.this.m_selectAllButton.setEnabled(PanelLocaleSetupManager.this.m_products.size() > 0);
            PanelLocaleSetupManager.this.m_clearAllButton.setEnabled(PanelLocaleSetupManager.this.m_products.size() > 0);
            if (PanelLocaleSetupManager.this.noProductsForLocaleSetup()) {
                return;
            }
        }

        public void selectAll(boolean value) {
            String id = null;
            ProductLocaleSelectionData prodData = null;
            for (int i = 0; i < PanelLocaleSetupManager.this.m_productIds.size(); ++i) {
                id = (String)PanelLocaleSetupManager.this.m_productIds.get(i);
                prodData = (ProductLocaleSelectionData)PanelLocaleSetupManager.this.m_products.get(id);
                if (prodData == null || !prodData.getSelectable()) continue;
                prodData.setInstall(value);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelLocaleSetupManager.this.installRenderers();
        }

        public void clear() {
            PanelLocaleSetupManager.this.m_products.clear();
            PanelLocaleSetupManager.this.m_productIds.clear();
            this.fireTableDataChanged();
        }
    }

    class ProductLocaleSelectionData {
        private final ProductData baseProduct;
        private boolean m_install = false;
        private boolean m_selectable = false;

        public ProductLocaleSelectionData(ProductData prodData, boolean selectable) {
            this.baseProduct = prodData;
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }

        public boolean getInstall() {
            return this.m_install;
        }

        public boolean getSelectable() {
            return this.m_selectable;
        }

        public ProductData getProductData() {
            return this.baseProduct;
        }

        public String getName() {
            return this.baseProduct.getProdName();
        }

        public void setInstall(boolean install) {
            if (this.m_selectable) {
                this.m_install = install;
            }
        }

        public void setSelectable(boolean selectable) {
            this.m_selectable = selectable;
            if (!this.m_selectable) {
                this.m_install = true;
            }
        }
    }

    private class ProductCellEditor
    extends DefaultCellEditor {
        private JCheckBox m_checkBox;

        public ProductCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelLocaleSetupManager.this.m_productIds.get(row);
                    ProductLocaleSelectionData prodData = (ProductLocaleSelectionData)PanelLocaleSetupManager.this.m_products.get(id);
                    this.m_checkBox.setText(prodData.getName());
                    this.m_checkBox.setSelected(prodData.getInstall());
                    this.m_checkBox.setEnabled(prodData.getSelectable());
                }
            }
            return this.m_checkBox;
        }
    }

    private class ProductCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelLocaleSetupManager.this.m_productIds.get(row);
                    ProductLocaleSelectionData prodData = (ProductLocaleSelectionData)PanelLocaleSetupManager.this.m_products.get(id);
                    this.setText(prodData.getName());
                    this.setSelected(prodData.getInstall());
                    this.setEnabled(prodData.getSelectable());
                }
            }
            return this;
        }
    }

    class SelectClearActionListener
    implements ActionListener {
        SelectClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelLocaleSetupManager.this.m_selectAllButton) {
                PanelLocaleSetupManager.this.m_prodListModel.selectAll(true);
            } else if (e.getSource() == PanelLocaleSetupManager.this.m_clearAllButton) {
                PanelLocaleSetupManager.this.m_prodListModel.selectAll(false);
            }
        }
    }
}

