/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelInstallType
implements WizardPanelIface,
ActionListener {
    private final String RESPONSE_PLANNED = "planned";
    private final String RESPONSE_NONPLANNED = "nonplanned";
    private final String RESPONSE_ADDITIONAL = "additional";
    private SSNResource bundle = new SSNResource(PanelInstallType.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_plannedOption = null;
    private JTextArea m_plannedInfo = null;
    private JCheckBox m_installCheckBox = null;
    private JCheckBox m_configureCheckBox = null;
    private JRadioButton m_nonPlanningOption = null;
    private JTextArea m_nonPlanningInfo = null;
    private JRadioButton m_additionalOption = null;
    private JTextArea m_additionalInfo = null;
    private boolean m_panelLoaded = false;
    private String m_indexPlanDir = "";
    private String m_prevIndexOrder = "";
    private String m_prevNPOrder = "";
    private String m_prevOrder = "";
    private static HashMap m_nonPlanningList = new HashMap();

    public PanelInstallType() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelInstallType.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelInstallType.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (this.m_plannedOption.isSelected()) {
            if (!this.m_installCheckBox.isSelected() && !this.m_configureCheckBox.isSelected()) {
                if (Globals.g_quietMode) {
                    Logging.log.severe("Response data required for one of the following 2 fields:\n   Panel: " + this.getHeader() + "\n   Field: " + "PLANNED_INSTALL" + "\n   Field: " + "PLANNED_CONFIGURE");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelInstallType.RequiredStepMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_installCheckBox.requestFocus();
                }
                valid = false;
            }
        } else if (this.m_additionalOption.isSelected()) {
            valid = this.createIndexData();
        }
        if (valid) {
            if (this.m_plannedOption.isSelected()) {
                Globals.g_sugiSam = false;
                Globals.g_plannedInstall = true;
                Globals.g_install = this.m_installCheckBox.isSelected();
                Globals.g_configure = this.m_configureCheckBox.isSelected();
            } else {
                Globals.g_sugiSam = this.m_nonPlanningOption.isSelected();
                Globals.g_plannedInstall = false;
                Globals.g_install = true;
                Globals.g_configure = false;
            }
            if (!Globals.g_quietMode) {
                Globals.g_wizardData.setPreference("PlannedInstall", this.m_plannedOption.isSelected());
                Globals.g_wizardData.setPreference("Install", this.m_installCheckBox.isSelected());
                Globals.g_wizardData.setPreference("Configure", this.m_configureCheckBox.isSelected());
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_plannedInstall ? "selectplan" : "machine";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean allowPlanning;
        OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
        boolean bl = allowPlanning = (Globals.g_sourceSSD || orderData.getVolsers(orderData.getMediaType()).length == 1) && !Globals.g_z64;
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_plannedOption.setEnabled(allowPlanning);
                if (!this.m_plannedOption.isEnabled() || this.isNonPlanningOrder()) {
                    this.m_nonPlanningOption.setSelected(true);
                } else {
                    this.m_plannedOption.setSelected(true);
                }
                if (Globals.g_srwOnly) {
                    this.m_installCheckBox.setSelected(true);
                    this.m_configureCheckBox.setSelected(false);
                } else if (Globals.g_z64 && !allowPlanning) {
                    this.m_installCheckBox.setSelected(false);
                    this.m_configureCheckBox.setSelected(false);
                } else {
                    this.m_installCheckBox.setSelected(Globals.g_wizardData.getPreference("Install", true));
                    this.m_configureCheckBox.setSelected(Globals.g_wizardData.getPreference("Configure", true));
                }
            }
            this.m_panelLoaded = true;
        } else if (!this.m_prevOrder.equalsIgnoreCase(Globals.g_order)) {
            this.m_plannedOption.setEnabled(allowPlanning);
            if (!this.m_plannedOption.isEnabled() || this.isNonPlanningOrder()) {
                this.m_nonPlanningOption.setSelected(true);
            } else {
                this.m_plannedOption.setSelected(true);
            }
            this.m_prevOrder = Globals.g_order;
        }
        this.setRadioState();
        this.m_additionalOption.setEnabled(!Globals.g_zos);
        this.m_additionalInfo.setEnabled(!Globals.g_zos);
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_plannedOption.isSelected() ? this.m_plannedOption : (this.m_nonPlanningOption.isSelected() ? this.m_nonPlanningOption : this.m_additionalOption);
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#DEPLOYMENT_TYPE=planned/nonplanned/additional", " DEPLOYMENT_TYPE=planned", "#PLANNED_INSTALL=yes/no", " PLANNED_INSTALL=yes", "#PLANNED_CONFIGURE=yes/no", " PLANNED_CONFIGURE=yes"};
        if (this.m_panelLoaded) {
            if (this.m_nonPlanningOption.isSelected()) {
                data[1] = " DEPLOYMENT_TYPE=nonplanned";
            } else if (this.m_additionalOption.isSelected()) {
                data[1] = " DEPLOYMENT_TYPE=additional";
            }
            if (!this.m_installCheckBox.isSelected()) {
                data[3] = " PLANNED_INSTALL=no";
            }
            if (!this.m_configureCheckBox.isSelected()) {
                data[5] = " PLANNED_CONFIGURE=no";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_plannedOption, this.m_nonPlanningOption, this.m_additionalOption};
        JTextArea[] infos = new JTextArea[]{this.m_plannedInfo, this.m_nonPlanningInfo, this.m_additionalInfo};
        int returnCode = ConsoleMode.promptRadioButtons(options, infos);
        if (returnCode > -1) {
            this.setRadioState();
            if (this.m_plannedOption.isSelected() && (returnCode = ConsoleMode.promptBoolean(this.m_installCheckBox)) > -1) {
                returnCode = ConsoleMode.promptBoolean(this.m_configureCheckBox);
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String responseOption = Wizard.getResponse("DEPLOYMENT_TYPE", null);
        if (responseOption != null) {
            if (responseOption.equalsIgnoreCase("planned")) {
                valid = true;
                this.m_plannedOption.setSelected(true);
            } else if (responseOption.equalsIgnoreCase("nonplanned")) {
                valid = true;
                this.m_nonPlanningOption.setSelected(true);
            } else if (responseOption.equalsIgnoreCase("additional")) {
                valid = true;
                this.m_additionalOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "DEPLOYMENT_TYPE", responseOption, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "DEPLOYMENT_TYPE");
        }
        String responseInstall = Wizard.getResponse("PLANNED_INSTALL", null);
        if (responseInstall != null) {
            if (responseInstall.equalsIgnoreCase("yes")) {
                this.m_installCheckBox.setSelected(true);
            } else if (responseInstall.equalsIgnoreCase("no")) {
                this.m_installCheckBox.setSelected(false);
            } else if (Globals.g_quietMode && this.m_plannedOption.isSelected()) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "PLANNED_INSTALL", responseInstall, null);
            }
        } else if (Globals.g_quietMode && this.m_plannedOption.isSelected()) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PLANNED_INSTALL");
        }
        String responseConfigure = Wizard.getResponse("PLANNED_CONFIGURE", null);
        if (responseConfigure != null) {
            if (responseConfigure.equalsIgnoreCase("yes")) {
                this.m_configureCheckBox.setSelected(true);
            } else if (responseConfigure.equalsIgnoreCase("no")) {
                this.m_configureCheckBox.setSelected(false);
            } else if (Globals.g_quietMode && this.m_plannedOption.isSelected()) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "PLANNED_CONFIGURE", responseConfigure, null);
            }
        } else if (Globals.g_quietMode && this.m_plannedOption.isSelected()) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "PLANNED_CONFIGURE");
        }
        return valid;
    }

    private void initialize() {
        String mtxt = this.bundle.getString("PanelInstallType.PlannedLabel.txt");
        this.m_plannedOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_plannedOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_plannedOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_plannedOption.getFont();
        this.m_plannedOption.setFont(optionFont.deriveFont(1));
        this.m_plannedInfo = new JTextArea(this.bundle.getString("PanelInstallType.PlannedInfo.txt"));
        this.m_plannedInfo.setEditable(false);
        this.m_plannedInfo.setFocusable(false);
        this.m_plannedInfo.setLineWrap(true);
        this.m_plannedInfo.setWrapStyleWord(true);
        this.m_plannedInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelInstallType.InstallLabel.txt");
        this.m_installCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_installCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_installCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_installCheckBox.getFont();
        this.m_installCheckBox.setFont(optionFont.deriveFont(1));
        mtxt = this.bundle.getString("PanelInstallType.ConfigureLabel.txt");
        this.m_configureCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configureCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configureCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_configureCheckBox.getFont();
        this.m_configureCheckBox.setFont(optionFont.deriveFont(1));
        mtxt = this.bundle.getString("PanelInstallType.AdditionalLabel.txt");
        this.m_additionalOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_additionalOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_additionalOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_additionalOption.getFont();
        this.m_additionalOption.setFont(optionFont.deriveFont(1));
        this.m_additionalInfo = new JTextArea(this.bundle.getString("PanelInstallType.AdditionalInfo.txt"));
        this.m_additionalInfo.setEditable(false);
        this.m_additionalInfo.setFocusable(false);
        this.m_additionalInfo.setLineWrap(true);
        this.m_additionalInfo.setWrapStyleWord(true);
        this.m_additionalInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelInstallType.NonPlanningLabel.txt");
        this.m_nonPlanningOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_nonPlanningOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_nonPlanningOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_nonPlanningOption.getFont();
        this.m_nonPlanningOption.setFont(optionFont.deriveFont(1));
        this.m_nonPlanningInfo = new JTextArea(this.bundle.getString("PanelInstallType.NonPlanningInfo.txt"));
        this.m_nonPlanningInfo.setEditable(false);
        this.m_nonPlanningInfo.setFocusable(false);
        this.m_nonPlanningInfo.setLineWrap(true);
        this.m_nonPlanningInfo.setWrapStyleWord(true);
        this.m_nonPlanningInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_plannedOption);
        group.add(this.m_nonPlanningOption);
        group.add(this.m_additionalOption);
        this.m_plannedOption.addActionListener(this);
        this.m_nonPlanningOption.addActionListener(this);
        this.m_additionalOption.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 3, 0);
        this.m_panel.add((Component)this.m_plannedOption, c);
        c.gridy = 1;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_plannedInfo, c);
        c.gridy = 2;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_installCheckBox, c);
        c.gridy = 3;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_configureCheckBox, c);
        c.gridy = 4;
        c.insets = new Insets(3, 0, 3, 0);
        this.m_panel.add((Component)this.m_nonPlanningOption, c);
        c.gridy = 5;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_nonPlanningInfo, c);
        c.gridy = 6;
        c.insets = new Insets(3, 0, 3, 0);
        this.m_panel.add((Component)this.m_additionalOption, c);
        c.gridy = 7;
        c.insets = new Insets(2, 20, 0, 0);
        this.m_panel.add((Component)this.m_additionalInfo, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_plannedOption || obj == this.m_nonPlanningOption || obj == this.m_additionalOption) {
            this.setRadioState();
        }
    }

    private void setRadioState() {
        this.m_installCheckBox.setEnabled(this.m_plannedOption.isSelected());
        if (Globals.g_srwOnly) {
            this.m_configureCheckBox.setEnabled(false);
        } else {
            this.m_configureCheckBox.setEnabled(this.m_plannedOption.isSelected());
        }
    }

    private boolean createIndexData() {
        boolean valid = true;
        if (!this.m_prevIndexOrder.equalsIgnoreCase(Globals.g_order)) {
            this.m_indexPlanDir = Utils.joinPath(Utils.joinPath(Globals.g_tempLocation, "sampleplans"), "index", "en");
            Vector<ProductData> prodDataVector = new Vector<ProductData>(Arrays.asList(Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false)));
            if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false) == null) {
                if (Utils.getOS_Suffix().equals("wx6")) {
                    if (Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false) != null) {
                        prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", false));
                    }
                } else if (Utils.getOS_Suffix().equals("lax") && Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false) != null) {
                    prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", false));
                }
            }
            if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", false) == null) {
                if (Utils.getOS_Suffix().equals("wx6")) {
                    if (Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "win", false) != null) {
                        prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "win", false));
                    }
                } else if (Utils.getOS_Suffix().equals("lax") && Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "lnx", false) != null) {
                    prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "lnx", false));
                }
            }
            if (Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", "win", false) != null) {
                prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", "win", false));
            }
            if (Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", false) != null) {
                prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", false));
            }
            if (Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", false) == null && Utils.getOS_Suffix().equals("wx6") && Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", false) != null) {
                prodDataVector.add(Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", false));
            }
            ProductData[] prodData = prodDataVector.toArray(new ProductData[0]);
            int swapPos = 0;
            ProductData swapData = null;
            for (int i = 0; i < prodData.length; ++i) {
                swapPos = i;
                for (int j = i; j < prodData.length; ++j) {
                    if (prodData[j].getProdName().toLowerCase(Locale.ENGLISH).compareTo(prodData[swapPos].getProdName().toLowerCase(Locale.ENGLISH)) >= 0) continue;
                    swapPos = j;
                }
                swapData = prodData[i];
                prodData[i] = prodData[swapPos];
                prodData[swapPos] = swapData;
            }
            if (Plan.createPlan(this.m_indexPlanDir, prodData, null)) {
                this.m_prevIndexOrder = Globals.g_order;
            } else {
                valid = false;
                Logging.log.info("Could not create temporary plan for Custom view.");
            }
        }
        if (valid) {
            try {
                Globals.g_plan = new Plan(this.m_indexPlanDir);
            }
            catch (Exception e) {
                valid = false;
                Logging.log.info(e.getMessage());
            }
        }
        return valid;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNonPlanningOrder() {
        boolean nonPlanning = true;
        if (!this.m_prevNPOrder.equalsIgnoreCase(Globals.g_order)) {
            m_nonPlanningList.clear();
            String dataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, false);
            File nonplanFile = new File(dataDir, "nonplan.txt");
            FileInputStream stream = null;
            if (nonplanFile.isFile()) {
                try {
                    stream = new FileInputStream(nonplanFile);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
                    String line = in.readLine();
                    while (line != null) {
                        if ((line = line.trim()).length() > 0) {
                            m_nonPlanningList.put(line, null);
                        }
                        line = in.readLine();
                    }
                    in.close();
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                }
            } else {
                Logging.log.severe("The nonplan.txt file is missing from: " + dataDir);
            }
            this.m_prevNPOrder = Globals.g_order;
        }
        if (m_nonPlanningList.size() > 0) {
            ProductData jmp4visdscData;
            ProductData[] allProducts = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false);
            for (int i = 0; i < allProducts.length && nonPlanning; ++i) {
                if (!allProducts[i].isConfigEnabled() || m_nonPlanningList.containsKey(allProducts[i].getProdCode())) continue;
                nonPlanning = false;
            }
            if (nonPlanning && (jmp4visdscData = Globals.g_deploymentData.getProduct(Globals.g_order, "jmp4visdsc", "wx6", false)) != null) {
                nonPlanning = false;
            }
        } else {
            nonPlanning = false;
        }
        return nonPlanning;
    }
}

