/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelHostName
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelHostName.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JTextArea m_shortInfoText = null;
    private JLabel m_fqdnHostNameLabel = null;
    private KitTextField m_fqdnHostName = null;
    private JLabel m_fqdnPadding = new JLabel();
    private JLabel m_hostNameLabel = null;
    private KitTextField m_hostName = null;
    private JLabel m_hostPadding = new JLabel();
    private boolean m_panelLoaded = false;

    public PanelHostName() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelHostName.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelHostName.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String fqdnHostName = this.m_fqdnHostName.getText().trim().toLowerCase();
        String hostName = this.m_hostName.getText().trim().toLowerCase();
        this.m_fqdnHostName.setText(fqdnHostName);
        this.m_hostName.setText(hostName);
        if (fqdnHostName.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "os.localhost.fqdn.host.name");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelHostName.FQDNFieldName.txt"));
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_fqdnHostName.requestFocus();
            }
        }
        if (valid && !Utils.isValidHostNameChars(fqdnHostName)) {
            valid = false;
            errMsg = this.bundle.messageString("PanelHostName.InvalidChar.txt");
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            this.m_fqdnHostName.requestFocus();
        }
        if (valid && hostName.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "os.localhost.host.name");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelHostName.ShortFieldName.txt"));
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_hostName.requestFocus();
            }
        }
        if (valid && !Utils.isValidHostNameChars(hostName)) {
            valid = false;
            errMsg = this.bundle.messageString("PanelHostName.InvalidChar.txt");
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            this.m_hostName.requestFocus();
        }
        if (valid) {
            Globals.g_fqHostName = fqdnHostName;
            Globals.g_hostName = hostName;
            Globals.g_configData.setProperty("os.localhost.fqdn.host.name", fqdnHostName);
            Globals.g_configData.setProperty("os.localhost.host.name", hostName);
            if (Globals.g_singleAccount || Globals.g_mode == 2) {
                DynamicDialogs.loadConfigDialogs();
            }
            if (Globals.g_mode == 2) {
                Globals.g_configData.setProperty("iomsrv.metadatasrv.host", Globals.g_cmtConnectHost);
                Globals.g_configData.setProperty("iomsrv.metadatasrv.port", Globals.g_cmtConnectPort);
                Globals.g_configData.setProperty("oma.person.admin.login.userid", Globals.g_cmtConnectUser);
                Globals.g_configData.setProperty("oma.person.admin.login.passwd", Globals.g_cmtConnectPassword);
                Globals.g_configData.setProperty("oma.repository.foundation.name", Globals.g_cmtConnectRepos);
                Globals.g_configDefaults.setDefault("iomsrv.metadatasrv.host", Globals.g_cmtConnectHost);
                Globals.g_configDefaults.setDefault("iomsrv.metadatasrv.port", Globals.g_cmtConnectPort);
                Globals.g_configDefaults.setDefault("oma.person.admin.login.userid", Globals.g_cmtConnectUser);
                Globals.g_configDefaults.setDefault("oma.person.admin.login.passwd", Globals.g_cmtConnectPassword);
                Globals.g_configDefaults.setDefault("oma.repository.foundation.name", Globals.g_cmtConnectRepos);
                Globals.g_configData.setProperty("metadata.connection.host", Globals.g_cmtConnectHost);
                Globals.g_configData.setProperty("metadata.connection.port", Globals.g_cmtConnectPort);
                Globals.g_configData.setProperty("metadata.connection.userid", Globals.g_cmtConnectUser);
                Globals.g_configData.setProperty("metadata.connection.passwd", Globals.g_cmtConnectPassword);
                Globals.g_configData.setProperty("metadata.connection.repository.name", Globals.g_cmtConnectRepos);
                Globals.g_configDefaults.setDefault("metadata.connection.host", Globals.g_cmtConnectHost);
                Globals.g_configDefaults.setDefault("metadata.connection.port", Globals.g_cmtConnectPort);
                Globals.g_configDefaults.setDefault("metadata.connection.userid", Globals.g_cmtConnectUser);
                Globals.g_configDefaults.setDefault("metadata.connection.passwd", Globals.g_cmtConnectPassword);
                Globals.g_configDefaults.setDefault("metadata.connection.repository.name", Globals.g_cmtConnectRepos);
                Globals.g_configData.setSDWProperty("config.migration.is_selected", "False");
            }
        }
        return valid;
    }

    private String getHostFQDN() {
        if (Globals.g_fqHostNameOverride != null && Globals.g_fqHostNameOverride != "") {
            return Globals.g_fqHostNameOverride;
        }
        return ConfigureData.getDefaultHost();
    }

    private String getHostShortName() {
        if (Globals.g_fqHostNameOverride != null && Globals.g_fqHostNameOverride != "") {
            String fqdn = Globals.g_fqHostNameOverride;
            return fqdn.substring(0, fqdn.indexOf(46));
        }
        return ConfigureData.getHostName();
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_configPromptLevel == 0 && !Globals.g_singleAccount) {
            display = false;
            Globals.g_fqHostName = this.getHostFQDN();
            Globals.g_hostName = this.getHostShortName();
            Globals.g_configData.setProperty("os.localhost.fqdn.host.name", Globals.g_fqHostName);
            Globals.g_configData.setProperty("os.localhost.host.name", Globals.g_hostName);
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 2 ? (Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0 ? Globals.g_dynamicConfigDialogs[0] : "execute") : "migrate";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_fqdnHostName.getText().length() == 0) {
                this.m_fqdnHostName.setText(this.getHostFQDN());
            }
            if (this.m_hostName.getText().length() == 0) {
                this.m_hostName.setText(this.getHostShortName());
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#os.localhost.fqdn.host.name=<text value - leave blank or remove to default on the machine where the SAS Deployment Wizard is running>", " os.localhost.fqdn.host.name=", "#os.localhost.host.name=<text value - leave blank or remove to default on the machine where the SAS Deployment Wizard is running>", " os.localhost.host.name="};
        if (this.m_panelLoaded) {
            data[1] = " os.localhost.fqdn.host.name=" + this.m_fqdnHostName.getText();
            data[3] = " os.localhost.host.name=" + this.m_hostName.getText();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_fqdnHostNameLabel.getText(), this.m_fqdnHostName);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_hostNameLabel.getText(), this.m_hostName);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        String response = Wizard.getResponse("os.localhost.fqdn.host.name", null);
        if (response != null && response.length() > 0) {
            this.m_fqdnHostName.setText(response);
        } else {
            this.m_fqdnHostName.setText(this.getHostFQDN());
        }
        response = Wizard.getResponse("os.localhost.host.name", null);
        if (response != null && response.length() > 0) {
            this.m_hostName.setText(response);
        } else {
            this.m_hostName.setText(this.getHostShortName());
        }
        return true;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelHostName.Info.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_shortInfoText = new JTextArea(this.bundle.getString("PanelHostName.ShortInfo.txt"));
        this.m_shortInfoText.setEditable(false);
        this.m_shortInfoText.setFocusable(false);
        this.m_shortInfoText.setLineWrap(true);
        this.m_shortInfoText.setWrapStyleWord(true);
        this.m_shortInfoText.setOpaque(false);
        this.m_fqdnHostName = new KitTextField();
        String mtxt = this.bundle.getString("PanelHostName.FQDNHostName.txt");
        String labelTxt = null;
        labelTxt = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + "os.localhost.fqdn.host.name" + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
        this.m_fqdnHostNameLabel = new JLabel(labelTxt);
        this.m_fqdnHostNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_fqdnHostNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_fqdnHostNameLabel.setLabelFor(this.m_fqdnHostName);
        this.m_hostName = new KitTextField();
        mtxt = this.bundle.getString("PanelHostName.ShortHostName.txt");
        labelTxt = Globals.g_debug ? Util.getLabelWithoutMnemonic(mtxt) + " (" + "os.localhost.host.name" + "):" : Util.getLabelWithoutMnemonic(mtxt) + ":";
        this.m_hostNameLabel = new JLabel(labelTxt);
        this.m_hostNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_hostNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_hostNameLabel.setLabelFor(this.m_hostName);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_fqdnHostNameLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_fqdnHostName, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_fqdnPadding, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_shortInfoText, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_hostNameLabel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_hostName, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_hostPadding, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

