/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.PanelAutoload;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelHadoopMetadata
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelAutoload.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_hadoopmetadataPropFileLabel = null;
    private KitTextField m_hadoopmetadataPropFileField = null;
    private KitBrowseButton m_browseButton = null;
    private boolean m_panelLoaded = false;
    private String sHadoopConfigFile = this.getHadoopConfigFile(Globals.g_cmtSASHome);

    public PanelHadoopMetadata() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelHadoopMetadata.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelHadoopMetadata.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String location = this.m_hadoopmetadataPropFileField.getText();
        if (location == null || location.length() <= 0) {
            valid = false;
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelHadoopMetadata.PropFileField.txt"));
        } else if (!new File(location).isFile()) {
            valid = false;
            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelHadoopMetadata.PropFileField.txt"));
        }
        if (valid) {
            Globals.g_configData.setProperty("hadoopc.config.prop.file", location);
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "HADOOPC_CFG_PROP_FILE");
        } else {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "execute";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_hadoopmetadataPropFileField;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#HADOOPC_CFG_PROP_FILE=<string value>", " HADOOPC_CFG_PROP_FILE="};
        if (this.m_panelLoaded) {
            data[1] = " HADOOPC_CFG_PROP_FILE=" + this.m_hadoopmetadataPropFileField.getText().trim();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_hadoopmetadataPropFileLabel.getText(), this.m_hadoopmetadataPropFileField);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("HADOOPC_CFG_PROP_FILE", null);
        if (response != null) {
            this.m_hadoopmetadataPropFileField.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "HADOOPC_CFG_PROP_FILE");
        }
        return valid;
    }

    private void initialize() {
        this.m_hadoopmetadataPropFileField = new KitTextField();
        String mtxt = this.bundle.getString("PanelHadoopMetadata.PropFileLabel.txt");
        this.m_hadoopmetadataPropFileLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_hadoopmetadataPropFileLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_hadoopmetadataPropFileLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_hadoopmetadataPropFileLabel.setLabelFor(this.m_hadoopmetadataPropFileField);
        this.m_hadoopmetadataPropFileField.setText(this.sHadoopConfigFile);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_hadoopmetadataPropFileField);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(0);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_hadoopmetadataPropFileLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_hadoopmetadataPropFileField, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    public String getHadoopConfigFile(String sasHome) {
        File sasHomeFile = new File(sasHome);
        String sBasePath = sasHomeFile.getParent();
        return Utils.joinPath(sBasePath, "hadoop", "sas_hadoop_config.properties");
    }
}

