/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.BatchFile;
import com.sas.ssn.Chaining;
import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.utils.DocPartUtils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelFinish
implements WizardPanelIface,
HyperlinkListener,
ActionListener {
    public static final int IDTYPE_INSTALL = 0;
    public static final int IDTYPE_SSD = 1;
    private SSNResource bundle = new SSNResource(PanelFinish.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JCheckBox m_runSDW = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;
    private boolean m_panelLoaded = false;
    private boolean m_rootLogged = false;
    private int m_idType = 0;
    private String m_fileToShow = null;
    private String m_consoleText = null;

    public PanelFinish(int idType) {
        this.m_idType = idType;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = this.m_idType == 0 ? this.bundle.getString("PanelFinish.Header.txt") : (Globals.g_mode == 1 ? this.bundle.getString("PanelFinish.ESDHeader.txt") : this.bundle.getString("PanelFinish.SSDHeader.txt"));
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String header = null;
        if (this.m_idType == 0) {
            if (Globals.g_resumeChain) {
                if (Globals.g_mode == 2 && !Globals.g_incompleteConfiguration) {
                    header = this.bundle.getString("PanelFinish.SDMHeaderReentryDesc.txt") + this.bundle.getString("PanelFinish.HeaderDesc.txt");
                } else if (Globals.g_mode == 0 && Globals.g_incompleteConfiguration) {
                    header = this.bundle.getString("PanelFinish.SDWHeaderReentryDesc.txt") + this.bundle.getString("PanelFinish.HeaderDesc.txt");
                }
            } else {
                header = this.bundle.getString("PanelFinish.HeaderDesc.txt");
            }
        } else {
            header = Globals.g_mode == 1 ? this.bundle.getString("PanelFinish.ESDHeaderDesc.txt") : this.bundle.getString("PanelFinish.SSDHeaderDesc.txt");
        }
        return header;
    }

    @Override
    public boolean validateData() {
        block6: {
            if (this.m_runSDW != null && this.m_runSDW.isSelected()) {
                String[] cmd = new String[]{Utils.getOS() == 1 ? Utils.joinPath(Globals.g_ssdDestDir, "setup.exe") : Utils.joinPath(Globals.g_ssdDestDir, "setup.sh")};
                try {
                    Process p = null;
                    p = Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e) {
                    if (Globals.g_quietMode) break block6;
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelFinish.ErrorStartingSDWMsg.txt"), Globals.g_wizard.getWizardTitle(), 0);
                }
            }
        }
        if (this.m_fileToShow != null) {
            try {
                KitAction.launchWebBrowser(new URL(Utils.pathToURL(this.m_fileToShow)));
            }
            catch (Exception e) {
                Logging.log.info("Unable to display configuration file: " + this.m_fileToShow);
            }
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        JButton m_nextButton;
        if (!this.m_panelLoaded) {
            this.updateTextArea();
            this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
            this.m_panelLoaded = true;
        }
        if (null != Globals.g_panelProgress && Globals.g_panelProgress.getHotfixDownloadStopped()) {
            wizardFramework.getBackButton().setEnabled(false);
            wizardFramework.getCancelButton().setEnabled(false);
        }
        if ((m_nextButton = wizardFramework.getNextButton()).getPreferredSize().getWidth() < m_nextButton.getMinimumSize().getWidth()) {
            m_nextButton.setPreferredSize(null);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        String script;
        boolean valid = true;
        if (Globals.g_partialPrompt) {
            valid = false;
        }
        if (Globals.g_skipStatusPanels) {
            valid = true;
        }
        if (valid && (script = this.getSetuidScript()) != null) {
            Logging.log.warning("This deployment is not complete until certain files within your SAS installation\n         have setuid permissions and are owned by root.  In order to set the setuid\n         permissions, run this script as root:\n         " + script);
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        if (this.m_consoleText != null) {
            ConsoleMode.printInfoText(this.m_consoleText);
        }
        return ConsoleMode.promptPause(false, true);
    }

    private void initialize() {
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_summaryText.addHyperlinkListener(this);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelFinish.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_printButton.addActionListener(this);
        if (this.m_idType == 1) {
            this.m_instructions = new JTextArea(this.bundle.getString("PanelFinish.Instructions.txt"));
            this.m_instructions.setEditable(false);
            this.m_instructions.setFocusable(false);
            this.m_instructions.setLineWrap(true);
            this.m_instructions.setWrapStyleWord(true);
            this.m_instructions.setOpaque(false);
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        if (this.m_instructions != null) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 10, 0);
            this.m_panel.add((Component)this.m_instructions, c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
        if (this.m_runSDW != null) {
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 12;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_runSDW, c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
            if (this.m_fileToShow != null) {
                try {
                    URL fileToShow = new URL(Utils.pathToURL(this.m_fileToShow));
                    if (event.getURL().sameFile(fileToShow)) {
                        this.m_fileToShow = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String getDeploymentRegistryViewLink() {
        String link = null;
        String reportName = "DeploymentRegistry";
        String jreLoc = Utils.getJavaCommand();
        Logging.log.fine("jreLoc=" + jreLoc);
        String depRegViewJar = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "deploymntreg", "sas.tools.viewregistry.jar");
        if (!new File(depRegViewJar).exists()) {
            Logging.log.warning("Deployment registry view jar not found : " + depRegViewJar);
            return link;
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(jreLoc, "-jar", depRegViewJar));
        ProcessBuilder pb = new ProcessBuilder(command);
        Logging.log.info("Creating deployoment registry view report with the command: " + ((Object)command).toString());
        try {
            Process conf = pb.start();
            conf.waitFor();
            if (conf.exitValue() != 0) {
                Logging.log.info("Creating deployment registry veiw report failed with the following return code: " + conf.exitValue());
            }
        }
        catch (Exception e) {
            Logging.log.warning("The following exception occurred while creating the deployment registry view report");
            Logging.log.warning(Logging.getFormattedLogMsg(e));
        }
        File reportSrcDir = new File(Globals.g_setupLocation);
        File reportSrc = new File(reportSrcDir.getParent(), "DeploymentRegistry.html");
        String logsDir = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc/InstallLogs");
        File htmlReportDest = new File(logsDir, "DeploymentRegistry.html");
        File txtReportDest = new File(logsDir, "DeploymentRegistry.txt");
        if (reportSrc.exists()) {
            if (Utils.copyFile(reportSrc, htmlReportDest) == 0) {
                Logging.log.info("SAS Installed Software report (html): " + htmlReportDest.getAbsolutePath());
            } else {
                Logging.log.warning("Not able to copy deployment registry view html report.");
            }
        }
        if ((reportSrc = new File(Globals.g_setupLocation, "DeploymentRegistry.txt")).exists()) {
            if (Utils.copyFile(reportSrc, txtReportDest) == 0) {
                Logging.log.info("SAS Installed Software report (txt): " + htmlReportDest.getAbsolutePath());
            } else {
                Logging.log.warning("Not able to copy deployment registry view txt report.");
            }
        }
        link = Utils.pathToURL(htmlReportDest.getAbsolutePath());
        return link;
    }

    private void updateTextArea() {
        String listText = "<html>";
        if (this.m_idType == 0) {
            String link = null;
            if (Globals.g_DocUpdate && Globals.g_sasHomeStatus != null) {
                if (!Globals.g_sasHomeStatus.updatesRequired() || Globals.g_sasHomeStatus.getRequiredInstallSteps().length == 0) {
                    String msg = this.bundle.messageString("PanelFinish.NoDocUpdate.txt", Globals.g_wizardData.getPreference("SASHome", ""));
                    listText = listText + "<b>" + msg + "</b><br><br>";
                    Logging.log.info("Running with -docupdate : " + msg);
                }
            } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
                String m_summaryFile = Utils.joinPath(Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc", "InstallLogs"), "DeploymentSummary.html");
                if (new File(m_summaryFile).isFile()) {
                    this.m_fileToShow = m_summaryFile;
                } else {
                    Logging.log.fine("m_summaryFile file does not exist: " + m_summaryFile);
                }
            } else if (!(!Globals.g_configure || Globals.g_recordMode && Globals.g_recordOnly)) {
                boolean fileFound = false;
                if (Globals.g_mode == 2 && Globals.g_cmtTask != 26) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
                    if (Globals.g_cmtTask == 2) {
                        File unconfigFile;
                        String m_unconfigFile = Globals.g_configData.getProperty("config.dir.name", "") + "-" + Globals.g_configData.getProperty("config.level.name", "") + "_" + Globals.g_configData.getProperty("config.unconfigure.file.name", "");
                        m_unconfigFile = Utils.joinPath(Utils.trimTrailingSlashes(System.getProperty("java.io.tmpdir")), m_unconfigFile);
                        if (m_unconfigFile != null && (unconfigFile = new File(m_unconfigFile)).isFile()) {
                            Date my_time = new Date();
                            int last_Index = m_unconfigFile.lastIndexOf(".");
                            m_unconfigFile = m_unconfigFile.substring(0, last_Index) + "_" + formatter.format(my_time) + m_unconfigFile.substring(last_Index);
                            File newFile = new File(m_unconfigFile);
                            unconfigFile.renameTo(newFile);
                        }
                        if (m_unconfigFile != null) {
                            if (new File(m_unconfigFile).isFile()) {
                                this.m_fileToShow = m_unconfigFile;
                                link = Utils.pathToURL(this.m_fileToShow);
                                listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigInstructionsHeader.txt") + "</b><br>";
                                listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", "<a href=\"" + link + "\">" + this.m_fileToShow + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", this.m_fileToShow) + "<br><br>";
                            }
                        } else {
                            Logging.log.info("Unconfiguration instructions file not found: " + this.m_fileToShow);
                        }
                    } else if (Globals.g_cmtTask == 0) {
                        File passwordFile;
                        String m_updatePasswordFile = Globals.g_configData.getProperty("config.lev.updatepasswords.file", "");
                        if (m_updatePasswordFile != null && (passwordFile = new File(m_updatePasswordFile)).isFile()) {
                            Date my_time = new Date();
                            int last_Index = m_updatePasswordFile.lastIndexOf(".");
                            m_updatePasswordFile = m_updatePasswordFile.substring(0, last_Index) + "_" + formatter.format(my_time) + m_updatePasswordFile.substring(last_Index);
                            File newFile = new File(m_updatePasswordFile);
                            passwordFile.renameTo(newFile);
                        }
                        if (m_updatePasswordFile != null) {
                            if (new File(m_updatePasswordFile).isFile()) {
                                this.m_fileToShow = m_updatePasswordFile;
                                link = Utils.pathToURL(this.m_fileToShow);
                                listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigInstructionsHeader.txt") + "</b><br>";
                                listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", "<a href=\"" + link + "\">" + this.m_fileToShow + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", this.m_fileToShow) + "<br><br>";
                            }
                        } else {
                            Logging.log.info("Update Passwords instructions file not found: " + this.m_fileToShow);
                        }
                    } else if (Globals.g_cmtTask == 4) {
                        File changeHostFile;
                        String m_changeHostFile = Globals.g_configData.getProperty("config.lev.changehost.file", "");
                        if (m_changeHostFile != null && (changeHostFile = new File(m_changeHostFile)).isFile()) {
                            Date my_time = new Date();
                            int last_Index = m_changeHostFile.lastIndexOf(".");
                            m_changeHostFile = m_changeHostFile.substring(0, last_Index) + "_" + formatter.format(my_time) + m_changeHostFile.substring(last_Index);
                            File newFile = new File(m_changeHostFile);
                            changeHostFile.renameTo(newFile);
                        }
                        if (m_changeHostFile != null) {
                            if (new File(m_changeHostFile).isFile()) {
                                this.m_fileToShow = m_changeHostFile;
                                link = Utils.pathToURL(this.m_fileToShow);
                                listText = listText + "<b>" + this.bundle.getString("PanelFinish.ChangeHostHeader.txt") + "</b><br>";
                                listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.ChangeHostMessage.txt", "<a href=\"" + link + "\">" + this.m_fileToShow + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.ChangeHostMessage.txt", this.m_fileToShow) + "<br><br>";
                            }
                        } else {
                            Logging.log.info("Update Host Name References instructions file not found: " + this.m_fileToShow);
                        }
                    } else if (Globals.g_cmtTask == 52) {
                        File autoloadFile;
                        String m_autoloadFile = Globals.g_configData.getProperty("config.lev.autoload.file", null);
                        if (m_autoloadFile != null && (autoloadFile = new File(m_autoloadFile)).isFile()) {
                            Date my_time = new Date();
                            int last_Index = m_autoloadFile.lastIndexOf(".");
                            m_autoloadFile = m_autoloadFile.substring(0, last_Index) + "_" + formatter.format(my_time) + m_autoloadFile.substring(last_Index);
                            File newFile = new File(m_autoloadFile);
                            autoloadFile.renameTo(newFile);
                        }
                        if (m_autoloadFile != null) {
                            if (new File(m_autoloadFile).isFile()) {
                                this.m_fileToShow = m_autoloadFile;
                                link = Utils.pathToURL(this.m_fileToShow);
                                listText = listText + "<b>" + this.bundle.getString("PanelFinish.AutoloadHeader.txt") + "</b><br>";
                                listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.AutoloadMessage.txt", "<a href=\"" + link + "\">" + this.m_fileToShow + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.AutoloadMessage.txt", this.m_fileToShow) + "<br><br>";
                            }
                        } else {
                            Logging.log.info("Configure Autoload Directory for SAS Visual Analytics instructions file not found: " + this.m_fileToShow);
                        }
                    } else if (Globals.g_cmtTask == 5) {
                        String configMaintFile;
                        String errorLog = Globals.g_configData.getProperty("config.lev.errorlog.file", null);
                        if (errorLog != null && new File(errorLog).isFile()) {
                            if (!Globals.g_applyConfigMaint) {
                                this.m_fileToShow = errorLog;
                            }
                            link = Utils.pathToURL(errorLog);
                            listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigErrorsHeader.txt") + "</b><br>";
                            listText = listText + this.bundle.messageString("PanelFinish.ConfigErrorsMessage.txt", "<a href=\"" + link + "\">" + errorLog + "</a>") + "<br><br>";
                        }
                        if ((configMaintFile = Globals.g_configData.getProperty("config.lev.maintconfiginstructions.file", null)) != null && new File(configMaintFile).isFile() && link == null) {
                            if (!Globals.g_applyConfigMaint) {
                                this.m_fileToShow = configMaintFile;
                            }
                            link = Utils.pathToURL(configMaintFile);
                            listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigInstructionsHeader.txt") + "</b><br>";
                            listText = listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", "<a href=\"" + link + "\">" + configMaintFile + "</a>") + "<br><br>";
                        }
                    } else if (DocPartUtils.getCurrentInstructionsFile() != null) {
                        File instructionsFile;
                        String instructionsFilePath;
                        String errorLog = Globals.g_configData.getProperty("config.lev.errorlog.file", null);
                        if (errorLog != null && new File(errorLog).isFile()) {
                            this.m_fileToShow = errorLog;
                            link = Utils.pathToURL(errorLog);
                            listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigErrorsHeader.txt") + "</b><br>";
                            listText = listText + this.bundle.messageString("PanelFinish.ConfigErrorsMessage.txt", "<a href=\"" + link + "\">" + errorLog + "</a>") + "<br><br>";
                        }
                        if ((instructionsFilePath = DocPartUtils.getCurrentInstructionsFile()) != null && (instructionsFile = new File(instructionsFilePath)).isFile() && link == null) {
                            this.m_fileToShow = instructionsFilePath;
                            link = Utils.pathToURL(instructionsFilePath);
                            listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigInstructionsHeader.txt") + "</b><br>";
                            listText = listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", "<a href=\"" + link + "\">" + instructionsFilePath + "</a>") + "<br><br>";
                        }
                    }
                } else {
                    String instructions;
                    String errorLog = Globals.g_configData.getProperty("config.lev.errorlog.file", null);
                    if (errorLog != null && new File(errorLog).isFile()) {
                        fileFound = true;
                        this.m_fileToShow = errorLog;
                        link = Utils.pathToURL(errorLog);
                        listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigErrorsHeader.txt") + "</b><br>";
                        listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.ConfigErrorsMessage.txt", "<a href=\"" + link + "\">" + errorLog + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.ConfigErrorsMessage.txt", errorLog) + "<br><br>";
                    }
                    if (!fileFound && (instructions = Globals.g_configData.getProperty("config.lev.instructions.file", null)) != null) {
                        if (new File(instructions).isFile()) {
                            this.m_fileToShow = instructions;
                            link = Utils.pathToURL(instructions);
                            listText = listText + "<b>" + this.bundle.getString("PanelFinish.ConfigInstructionsHeader.txt") + "</b><br>";
                            listText = Utils.getOS() != 8 ? listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", "<a href=\"" + link + "\">" + instructions + "</a>") + "<br><br>" : listText + this.bundle.messageString("PanelFinish.ConfigInstructionsMessage.txt", instructions) + "<br><br>";
                        } else {
                            Logging.log.info("Configuration instructions file not found: " + instructions);
                        }
                    }
                }
            }
            if (Globals.g_configUpdateText != null) {
                listText = listText + Globals.g_configUpdateText;
            }
            String script = this.getSetuidScript();
            link = this.bundle.getString("PanelFinish.CustomerSupportLink.txt");
            if (script != null) {
                listText = listText + this.bundle.messageString("PanelFinish.CustomerSupportHeaderRootNote.txt", script) + "</b><br>";
                if (!this.m_rootLogged) {
                    Logging.log.warning("This deployment is not complete until certain files within your SAS installation\n         have setuid permissions and are owned by root.  In order to set the setuid\n         permissions, run this script as root:\n         " + script);
                    this.m_rootLogged = true;
                }
            } else {
                listText = listText + "<b>" + this.bundle.getString("PanelFinish.CustomerSupportHeader.txt") + "</b><br>";
            }
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            link = Chaining.getDeploymentRegistryViewLink();
            if (link != null) {
                listText = listText + "<b>" + this.bundle.getString("PanelFinish.ViewRegistryReport.txt") + "</b><br>";
                listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            }
            if (Globals.g_createBatch) {
                if (new File(Globals.g_batchFile).isFile()) {
                    BatchFile bf = BatchFile.getInstance();
                    link = Utils.pathToURL(Utils.getBatchFilePath(false));
                    listText = listText + "<b>" + this.bundle.getString("PanelFinish.BatchFileHeader.txt") + "</b><br>";
                    listText = listText + this.bundle.messageString("PanelFinish.BatchFileLink.txt", bf.getBatchFileName(), "<a href=\"" + link + "\">" + Utils.getBatchFilePath(false) + "</a><br><br>");
                } else {
                    Logging.log.fine("batch file does not exist: " + Globals.g_batchFile);
                }
            }
            link = this.bundle.getString("PanelFinish.InstallCenterLink.txt");
            listText = listText + "<b>" + this.bundle.getString("PanelFinish.InstallCenterHeader.txt") + "</b><br>";
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            link = this.bundle.getString("PanelFinish.TechSupportLink.txt");
            listText = listText + "<b>" + this.bundle.getString("PanelFinish.TechSupportHeader.txt") + "</b><br>";
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            link = this.bundle.getString("PanelFinish.DownloadsLink.txt");
            listText = listText + "<b>" + this.bundle.getString("PanelFinish.DownloadsHeader.txt") + "</b><br>";
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            link = this.bundle.getString("PanelFinish.TrainingLink.txt");
            listText = listText + "<b>" + this.bundle.getString("PanelFinish.TrainingHeader.txt") + "</b><br>";
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
            link = this.bundle.getString("PanelFinish.AdminServicesLink.txt");
            listText = listText + "<b>" + this.bundle.getString("PanelFinish.AdminServicesHeader.txt") + "</b><br>";
            listText = listText + "<a href=\"" + link + "\">" + link + "</a><br><br>";
        } else if (Globals.g_eAcademy) {
            String quickStartGuide = Utils.joinPath(Globals.g_ssdDestDir, "doc" + File.separator + "0009" + File.separator + "sasegquickstart.pdf");
            String quickStartLink = "<a href=\"" + Utils.pathToURL(quickStartGuide) + "\">" + quickStartGuide + "</a>";
            String setupExe = Utils.joinPath(Globals.g_ssdDestDir, "setup.exe");
            listText = listText + this.bundle.messageString("PanelFinish.EAcademy1.txt", Globals.g_order, Utils.escapeHTMLString(Globals.g_orderDesc)) + "<br><br>" + this.bundle.messageString("PanelFinish.EAcademy2.txt", quickStartLink) + "<br><br>" + this.bundle.messageString("PanelFinish.EAcademy3.txt", setupExe);
        } else {
            File finishFile = new File(Utils.joinPath(Globals.g_deploymentData.getOrderDir(Globals.g_ssdDestDir), Globals.g_order, "finish.html"));
            if (finishFile.isFile()) {
                GregorianCalendar calendar = new GregorianCalendar();
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy", Locale.getDefault());
                String date = dateFormat.format(calendar.getTime());
                dateFormat = new SimpleDateFormat("h:mm:ss a", Locale.getDefault());
                String time = dateFormat.format(calendar.getTime());
                String line = null;
                try {
                    BufferedReader in = new BufferedReader(new FileReader(finishFile));
                    line = in.readLine();
                    while (line != null) {
                        if (line.indexOf("[$VAL_TIME]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_TIME]", time);
                        }
                        if (line.indexOf("[$VAL_DATE]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_DATE]", date);
                        }
                        if (line.indexOf("[$VAL_ORDER]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_ORDER]", Globals.g_order);
                        }
                        if (line.indexOf("[$VAL_DESCRIPTION]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_DESCRIPTION]", Utils.escapeHTMLString(Globals.g_orderDesc));
                        }
                        if (line.indexOf("[$VAL_SSDPATH]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_SSDPATH]", Globals.g_ssdDestDir);
                        }
                        if (line.indexOf("[$VAL_PATHDELIM]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_PATHDELIM]", File.separator);
                        }
                        if (line.indexOf("[$VAL_MACHINENAME]") > -1) {
                            line = Utils.stringReplaceAll(line, "[$VAL_MACHINENAME]", ConfigureData.getHostName());
                        }
                        listText = listText + line;
                        line = in.readLine();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            } else {
                String quickStartGuide = Utils.joinPath(Globals.g_ssdDestDir, "depotsummary.html");
                String quickStartLink = "<a href=\"" + Utils.pathToURL(quickStartGuide) + "\">" + quickStartGuide + "</a>";
                listText = listText + this.bundle.messageString("PanelFinish.SSDSummary1.txt", Globals.g_order, Utils.escapeHTMLString(Globals.g_orderDesc), this.bundle.getString("Common.Title.txt")) + "<br><br>" + this.bundle.messageString("PanelFinish.SSDSummary2.txt", quickStartLink) + "<br><br>" + this.bundle.messageString("PanelFinish.SSDSummary3.txt", this.bundle.getString("Common.Title.txt")) + "<br><br>" + this.bundle.messageString("PanelFinish.SSDSummary4.txt", Globals.g_ssdDestDir) + "<br><br><table valign=top cellspacing=0 cellpadding=1><tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>" + this.bundle.getString("PanelFinish.SSDWin.txt") + "</td><td><b>" + this.bundle.getString("PanelFinish.SSDWinCmd.txt") + "</b></td></tr><tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>" + this.bundle.getString("PanelFinish.SSDUnix.txt") + "</td><td><b>" + this.bundle.getString("PanelFinish.SSDUnixCmd.txt") + "</b></td></tr><tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>" + this.bundle.getString("PanelFinish.SSDzOS.txt") + "</td><td><b>" + this.bundle.getString("PanelFinish.SSDzOSCmd.txt") + "</b></td></tr></table>";
                if (Globals.g_mode == 1) {
                    listText = listText + "<br>" + this.bundle.messageString("PanelFinish.ESDMessage1.txt");
                }
            }
        }
        listText = listText + "</html>";
        if (Globals.g_consoleMode) {
            this.m_consoleText = listText;
        } else {
            this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_summaryText.setText(listText);
            this.m_summaryText.setCaretPosition(0);
            this.m_summaryText.revalidate();
        }
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    private String getSetuidScript() {
        String script;
        block17: {
            script = null;
            if (Globals.g_mode != 2 && Globals.g_install && !Globals.g_configure && Globals.g_fullInstalls != null && Globals.g_fullInstalls.length > 0 && Utils.getOS() != 1 && Utils.getOS() != 8) {
                boolean sasInstalled = false;
                for (int i = 0; i < Globals.g_fullInstalls.length && !sasInstalled; ++i) {
                    if (!Globals.g_fullInstalls[i].getProdCode().equalsIgnoreCase("sasinstall")) continue;
                    sasInstalled = true;
                }
                if (sasInstalled) {
                    String sasInstallLoc = null;
                    ProductData sasProdData = null;
                    RegistryAccess registryAccess = null;
                    sasProdData = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "base", Globals.g_sasinstallPlat, false) : Globals.g_deploymentData.getProduct(Globals.g_order, "base", false);
                    try {
                        registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    }
                    catch (Exception e) {
                        registryAccess = null;
                        Logging.logStackTrace(e);
                    }
                    if (sasProdData != null && registryAccess != null && registryAccess.open()) {
                        if (Globals.g_sasinstallPlat != null) {
                            sasInstallLoc = registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), Globals.g_sasinstallPlat);
                            if (sasInstallLoc == null) {
                                sasInstallLoc = registryAccess.getInstallLoc("base", "default", Globals.g_sasinstallPlat);
                            }
                        } else {
                            sasInstallLoc = registryAccess.getInstallLoc("base", sasProdData.getProdVersion());
                            if (sasInstallLoc == null) {
                                sasInstallLoc = registryAccess.getInstallLoc("base", "default");
                            }
                        }
                        registryAccess.close();
                    }
                    if (sasInstallLoc != null) {
                        Logging.log.info("Checking SAS file permissions: " + sasInstallLoc);
                        File scriptFile = new File(Utils.joinPath(sasInstallLoc, "utilities", "bin"), "elsconf");
                        if (scriptFile.exists()) {
                            String[] command = new String[]{"/bin/sh", "-c", "./" + scriptFile.getName()};
                            try {
                                Process p = Runtime.getRuntime().exec(command, null, scriptFile.getParentFile());
                                p.waitFor();
                                int retVal = p.exitValue();
                                if (retVal != 0) {
                                    File setuidFile = new File(Utils.joinPath(sasInstallLoc, "utilities", "bin"), "setuid.sh");
                                    if (setuidFile.isFile()) {
                                        script = setuidFile.toString();
                                    }
                                    break block17;
                                }
                                Logging.log.info("Critical SAS files have setuid permissions.");
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                        }
                    } else {
                        Logging.log.warning("Critical SAS Files were not found to check setuid permissions.");
                    }
                }
            }
        }
        return script;
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelFinish.this.m_summaryText, PanelFinish.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelFinish.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelFinish.this.m_summaryText, PanelFinish.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelFinish.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

