/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.BatchFile;
import com.sas.ssn.Chaining;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DlgAutoLogon;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixPackages;
import com.sas.ssn.HyperlinkField;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.JREData;
import com.sas.ssn.KitAction;
import com.sas.ssn.KitOEMDialog;
import com.sas.ssn.LicenseServer;
import com.sas.ssn.ListItemWithGraphic;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.PropsParser;
import com.sas.ssn.Reboot;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SecurityUpdates;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.ExecutionProgressInterface;
import com.sas.tools.installs.it.ExecutionThread;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.listener.RebootListener;
import com.sas.tools.installs.it.listener.RollbackProgressListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.ExtractTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelExecute
implements WizardPanelIface,
HyperlinkListener,
InstallationProgressListener,
RollbackProgressListener,
ExecutionProgressInterface,
RebootListener,
InstallationSetupListener {
    private final int MAX_MSG_LENGTH = 100;
    private SSNResource bundle = new SSNResource(PanelExecute.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JScrollPane m_installList = null;
    private JList m_list = null;
    private JLabel m_installStatus = null;
    private JLabel m_successLegend = null;
    private JLabel m_warningLegend = null;
    private JLabel m_failureLegend = null;
    private JLabel m_installedLegend = null;
    private JPanel m_legendPanel = null;
    private JLabel m_processing = null;
    private JTextArea m_applicableText = null;
    private JEditorPane m_warningText = null;
    private HyperlinkField m_alertNotes = null;
    private Timer m_timer = null;
    private ActionListener m_timerAction = null;
    private ImageIcon m_time1 = this.bundle.getImageIcon("Common.time1.image");
    private ImageIcon m_time2 = this.bundle.getImageIcon("Common.time2.image");
    private ImageIcon m_time3 = this.bundle.getImageIcon("Common.time3.image");
    private ImageIcon m_time4 = this.bundle.getImageIcon("Common.time4.image");
    private ImageIcon m_time5 = this.bundle.getImageIcon("Common.time5.image");
    private Chaining m_installChain = null;
    private ArrayList m_stageTargets = null;
    private ArrayList m_stageNames = null;
    private ArrayList m_stageData = null;
    private RegistryAccess m_registryAccess = null;
    private boolean m_finished = false;
    private boolean m_installing = false;
    private boolean m_ignoreErrors = false;
    private boolean m_modalActive = false;
    private boolean m_reboot = false;
    private boolean m_applicable = true;
    private boolean m_warning = false;
    private int m_imageCount = 1;
    private int m_displayIndex = 0;
    private String[] m_responsedata = null;
    private String m_consoleStatusTxt = "";
    private boolean m_showJobs = false;
    private boolean m_runningJobs = false;
    private Object obj = new Object();
    private BatchFile bf = BatchFile.getInstance();
    protected static final int Megabyte = 0x100000;
    private JLabel currentTaskLabel;
    private JLabel overallProgressLabel;
    private JProgressBar progressBar;
    private JProgressBar overallProgressBar;
    protected long _totalBytesMoved = 0L;
    protected long _overallBytesMoved = 0L;
    protected long _overallBytes = 0L;
    protected int _ellipsisCount = 0;
    private HotFixPackages hotFixPackages = new HotFixPackages();
    private final int BUTTONS_ALL = 0;
    private final int BUTTONS_NOYESRETRY = 1;
    private final int BUTTONS_STOPRETRY = 2;
    protected ActionListener statusTimerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            PanelExecute.this.updateBusyIndicator(true);
        }
    };
    protected Timer statusTimer = new Timer(500, this.statusTimerAction);
    protected boolean _executionInProgress = false;
    protected HashMap<String, Long> _checkedSizes;
    protected boolean _itInstallsExist = false;
    protected ArrayList<ProductData> _installProducts;
    protected String _busyPrefix = "";
    protected String _ellipsis = "";

    public PanelExecute() {
        this.initialize();
        this.layoutWidgets();
        NotificationHandler.defaultHandler().addProgressListener(this);
        NotificationHandler.defaultHandler().addRollbackProgressListener(this);
        NotificationHandler.defaultHandler().addRebootListener(this);
        NotificationHandler.defaultHandler().addSetupListener(this);
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = this.m_installChain != null && this.m_installChain.finished() ? (Globals.g_mode == 2 && Globals.g_cmtTask != 11 ? this.bundle.getString("PanelExecute.SummaryHeaderCMT.txt") : this.bundle.getString("PanelExecute.SummaryHeader.txt")) : (Globals.g_mode == 2 && Globals.g_cmtTask != 11 ? this.bundle.getString("PanelExecute.HeaderCMT.txt") : this.bundle.getString("PanelExecute.Header.txt"));
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = Globals.g_recordMode && Globals.g_recordOnly ? (Globals.g_cmtTask == 11 ? this.bundle.getString("PanelExecute.HeaderDescHotFixRecordOnly.txt") : this.bundle.getString("PanelExecute.HeaderDescRecordOnly.txt")) : (this.m_installChain != null && this.m_installChain.finished() ? this.bundle.getString("PanelExecute.SummaryHeaderDesc.txt") : (Globals.g_mode == 2 ? (Globals.g_cmtTask == 11 ? this.bundle.getString("PanelExecute.HeaderDescHotFix.txt") : (Globals.g_cmtTask == 41 ? this.bundle.getString("PanelExecute.HeaderDescRenew.txt") : this.bundle.getString("PanelExecute.HeaderDescCMT.txt"))) : this.bundle.getString("PanelExecute.HeaderDesc.txt")));
        return headerDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateData() {
        boolean retVal = false;
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            retVal = true;
            if (Globals.g_installDebugFile != null) {
                PropertyRules.printConstants(Globals.g_installDebugFile);
                Globals.g_installDebugFile.close();
            }
            if (Globals.g_configDebugFile != null) {
                PropertyRules.printConstants(Globals.g_configDebugFile);
                Globals.g_configDebugFile.close();
            }
        } else if (!this.m_finished) {
            if (!Globals.g_srwOnly) {
                this.saveData();
            }
            this.m_finished = true;
            this.m_installing = true;
            if (!Globals.g_apprentice) {
                Globals.g_wizard.clearWizardChain(true);
            }
            String mtxt = this.bundle.getString("PanelExecute.StopButton.txt");
            Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Globals.g_wizard.getHelpButton().setEnabled(false);
            Globals.g_wizard.getBackButton().setEnabled(false);
            Globals.g_wizard.getCancelButton().setEnabled(false);
            this.m_alertNotes.setVisible(false);
            if (this.m_installStatus.getBackground().equals(Color.BLACK)) {
                this.m_installStatus.setIcon(this.bundle.getImageIcon("Common.running_white.image"));
            } else {
                this.m_installStatus.setIcon(this.bundle.getImageIcon("Common.running.image"));
            }
            this.m_panel.validate();
            this.executeInstalls();
        } else if (this.m_installing) {
            Controller controller;
            this.m_modalActive = true;
            Controller controller2 = Controller.defaultController();
            if (controller2 != null && this.isExecutionInProgress()) {
                Logging.log.info("flagging install to pause at next convenient point until user confirms");
                controller2.setInterrupt(true);
            }
            if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelExecute.StopInstallMsg.txt", this.bundle.getString("Common.Title.txt")), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 0) {
                retVal = true;
                if (Globals.g_configDefaults != null) {
                    String stageName = Globals.g_configDefaults.getDefault("cfgwizard.updateConfigure.target.name", "");
                    if (this.m_installChain.getCurrentStageName().equals(stageName)) {
                        Globals.g_wizard.setReturnCode(-9998);
                    } else {
                        Globals.g_wizard.setReturnCode(-9999);
                    }
                } else {
                    Globals.g_wizard.setReturnCode(-9999);
                }
            }
            this.m_modalActive = false;
            if (retVal && controller2 != null) {
                controller = controller2;
                synchronized (controller) {
                    controller2.setInstallCancelled(true);
                    Logging.log.info("Cancelling install");
                    controller2.setInterrupt(false);
                    controller2.notify();
                }
                if (Controller.getExecutionThread() != null) {
                    Controller.getExecutionThread().setInterface(this);
                    Globals.g_wizard.getNextButton().setEnabled(false);
                    retVal = false;
                }
            } else {
                controller2 = Controller.defaultController();
                if (controller2 != null) {
                    controller = controller2;
                    synchronized (controller) {
                        controller2.setInstallCancelled(false);
                        Logging.log.info("Resuming install");
                        controller2.setInterrupt(false);
                        controller2.notify();
                    }
                }
            }
        } else {
            retVal = true;
        }
        if (Globals.g_consoleMode) {
            if (this.m_installChain != null) {
                try {
                    this.m_installChain.join();
                }
                catch (InterruptedException e) {
                    Logging.logStackTrace(e);
                }
            }
            ConsoleMode.println();
            if (this.getHeader().length() > 0) {
                ConsoleMode.println(this.getHeader());
                ConsoleMode.println();
            }
            if (this.printConsoleSummary() == -2) {
                ConsoleMode.println(this.bundle.getString("Wizard.DeploymentAborted.txt"));
                Globals.g_wizard.exitWizard(Globals.g_wizard.getReturnCode());
            }
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = "finish";
        if (Globals.g_cmtTask == 40) {
            panelID = null;
        }
        if (this.m_installChain != null && this.m_installChain.finished()) {
            if (Globals.g_mode != 2) {
                if (this.m_installChain.oneInstalled() || Globals.g_forceLogPrompt) {
                    List<String> jobNames;
                    panelID = Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? "configmaint" : "finish";
                    if (Utils.getOS() == 8 && (jobNames = InstallToolConnector.getMvsFinalJobNames()) != null && !jobNames.isEmpty()) {
                        panelID = "zospostinstallsummary";
                    }
                } else if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
                    panelID = "configmaint";
                }
            } else if (Globals.g_cmtTask == 2 || Globals.g_cmtTask == 0 || Globals.g_cmtTask == 4 || Globals.g_cmtTask == 52 || Globals.g_cmtTask == 49 || Globals.g_cmtTask == 27 || Globals.g_cmtTask == 5 || Globals.g_cmtTask == 34 || Globals.g_cmtTask == 26) {
                panelID = "finish";
            } else if (Globals.g_cmtTask == 11 && Globals.g_cmtRunInstall) {
                panelID = "hotfixpostinstallsummary";
            }
        } else if (Globals.g_cmtTask == 11) {
            if (Globals.g_cmtRunInstall) {
                panelID = "hotfixpostinstallsummary";
            }
        } else if (Globals.g_recordMode && Globals.g_recordOnly) {
            panelID = Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? "configmaint" : "finish";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (this.m_installChain == null || !this.m_installChain.finished()) {
            if ((Globals.g_resumeChain || Globals.g_partialPrompt) && !Globals.g_consoleMode) {
                this.getStageData();
                this.validateData();
            } else {
                if (!Globals.g_recordMode || !Globals.g_recordOnly) {
                    String mtxt = this.bundle.getString("PanelExecute.StartButton.txt");
                    wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                    wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                    wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                }
                this.updateSummary();
                this.m_alertNotes.setText(this.bundle.getString("PanelExecute.AlertNotes.txt"), this.getAlertNotesLink());
                this.m_alertNotes.setCaretPosition(0);
                this.m_alertNotes.revalidate();
                this.m_alertNotes.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            }
        }
        this.createLegend();
        this.currentTaskLabel.setText("");
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        this.overallProgressBar.setValue(0);
        this.overallProgressBar.setVisible(this._itInstallsExist);
        this.overallProgressLabel.setVisible(this._itInstallsExist);
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        if (Globals.g_mode == 2) {
            return null;
        }
        return this.bundle.messageString("PanelExecute.Cancel.txt");
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = true;
        if (Globals.g_partialPrompt) {
            valid = false;
        } else if (this.m_installChain == null || !this.m_installChain.finished()) {
            this.getStageData();
            if (!Globals.g_srwOnly) {
                this.saveData();
            }
            this.m_finished = true;
            this.m_installing = true;
            if (this.m_stageData != null) {
                this.m_installChain = new Chaining(this.m_stageData, this.m_stageTargets, this.m_stageNames, this);
                this.m_installChain.run();
                valid = this.m_installChain.finished();
            }
        }
        if (Globals.g_createBatch) {
            this.bf.close();
            if (this.bf.isEmpty()) {
                Logging.log.warning(this.bundle.getString("PanelExecute.BatchFileEmpty.txt"));
            }
        }
        return valid;
    }

    public void refreshInstallToolProps() {
        Controller controller = Controller.defaultController();
        if (controller != null && controller.getSASController() != null) {
            controller.getSASController().initializeCommonProperties();
        }
    }

    @Override
    public String[] responseData() {
        return this.m_responsedata;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        if (Globals.g_apprentice) {
            this.m_installChain = null;
            this.m_finished = false;
            this.m_installing = false;
            Globals.g_wizard.setWizardActive(true);
            this.m_installStatus.setText("");
            this.m_installStatus.setIcon(null);
            this.m_installStatus.setVisible(true);
        }
    }

    @Override
    public int consoleEvent() {
        if (this.m_finished) {
            return 0;
        }
        ConsoleMode.println();
        String numOffset = null;
        ProductData prodData = null;
        for (int stage = 0; stage < this.m_stageData.size(); ++stage) {
            ConsoleMode.println(this.bundle.messageString("PanelExecute.Stage.txt", Integer.toString(stage + 1), (String)this.m_stageNames.get(stage)));
            ArrayList stageData = (ArrayList)this.m_stageData.get(stage);
            for (int step = 0; step < stageData.size(); ++step) {
                prodData = (ProductData)stageData.get(step);
                numOffset = "";
                if (stageData.size() > 99) {
                    if (step + 1 < 10) {
                        numOffset = "  ";
                    } else if (step + 1 < 100) {
                        numOffset = " ";
                    }
                } else if (stageData.size() > 9 && step + 1 < 10) {
                    numOffset = " ";
                }
                ConsoleMode.println("   " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
            }
            if (stage >= this.m_stageData.size() - 1) continue;
            ConsoleMode.println();
        }
        return ConsoleMode.promptPause();
    }

    private void executeInstalls() {
        if (Globals.g_mode == 2) {
            if (Globals.g_cmtTask == 11) {
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelExecute.InstallHeader.txt"));
            } else if (Globals.g_cmtTask == 28) {
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelExecute.UninstallHeader.txt"));
            } else {
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelExecute.InstallHeaderCMT.txt"));
            }
        } else {
            Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelExecute.InstallHeader.txt"));
        }
        Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelExecute.InstallHeaderDesc.txt"));
        this.m_list.setModel(this.createListModel());
        this.m_installList.getViewport().setView(this.m_list);
        if (this.m_stageData != null) {
            this.m_installChain = new Chaining(this.m_stageData, this.m_stageTargets, this.m_stageNames, this);
            this.m_installChain.start();
        }
        this.progressBar.setVisible(true);
        this.setExecutionInProgress(true);
    }

    public void updateStatus() {
        if (!this.m_installChain.finished()) {
            Object[] args;
            String messageText;
            String target;
            String statusTxt = null;
            if (Globals.g_mode == 2 && Globals.g_cmtTask != 11 && Globals.g_cmtInstallTargets != null) {
                target = this.m_installChain.getCurrentTarget();
                messageText = null;
                if (target != null) {
                    messageText = Globals.g_installDefaults.getDefault("deploywiz." + target + ".target.verb", null);
                }
                if (messageText != null) {
                    if (PropertyRules.containsProperty(messageText)) {
                        messageText = PropertyRules.resolveProperties(messageText, 1);
                    }
                    args = new Object[]{this.m_installChain.getCurrentInstallData().getProdNameExtended()};
                    statusTxt = MessageFormat.format(messageText, args);
                } else {
                    statusTxt = this.bundle.messageString("PanelExecute.ConfigureStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended());
                }
            } else if (this.m_installChain.getCurrentInstallData().getType() == 0 || this.m_installChain.getCurrentInstallData().getType() == 1 || this.m_installChain.getCurrentInstallData().getType() == 4) {
                if (this.m_installChain.getCurrentInstallData().getProdCode().equals("installtool") && Utils.getOS_Suffix() == "mvs" && !Globals.g_consoleMode) {
                    this.m_showJobs = false;
                    if (Globals.g_cmtTask == 11) {
                        if (Utils.areAnyMVSMVAHotFixes()) {
                            this.m_showJobs = true;
                        }
                    } else {
                        this.m_showJobs = true;
                    }
                    if (this.m_showJobs && Globals.g_zosJobSubmit && !this.m_runningJobs) {
                        statusTxt = this.bundle.getString("PanelExecute.SubmittingBatchJobs.txt");
                        this.m_runningJobs = true;
                    }
                } else {
                    statusTxt = Globals.g_cmtTask == 41 ? this.bundle.messageString("PanelExecute.RenewalStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended()) : (Globals.g_cmtTask == 40 ? this.bundle.messageString("PanelExecute.RepairStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended()) : this.bundle.messageString("PanelExecute.InstallStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended()));
                }
            } else if (this.m_installChain.getCurrentInstallData().getType() == 3) {
                statusTxt = this.bundle.messageString("PanelExecute.UninstallStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended());
            } else {
                target = this.m_installChain.getCurrentTarget();
                messageText = null;
                if (target != null) {
                    messageText = Globals.g_configDefaults.getDefault("cfgwizard." + target + ".target.verb", null);
                }
                if (messageText != null) {
                    if (PropertyRules.containsProperty(messageText)) {
                        messageText = PropertyRules.resolveProperties(messageText, 0);
                    }
                    args = new Object[]{this.m_installChain.getCurrentInstallData().getProdNameExtended()};
                    statusTxt = MessageFormat.format(messageText, args);
                } else {
                    statusTxt = this.bundle.messageString("PanelExecute.ConfigureStatus.txt", this.m_installChain.getCurrentInstallData().getProdNameExtended());
                }
            }
            this.m_installStatus.setText(statusTxt);
        }
        if ((Globals.g_consoleMode || Globals.g_quietStatus) && !this.m_consoleStatusTxt.equals(this.m_installStatus.getText())) {
            if (Globals.g_consoleMode) {
                ConsoleMode.busyMsgStop();
            } else if (Globals.g_quietStatus && Globals.g_quietStatusArea != null) {
                Globals.g_quietStatusArea.busyMsgStop();
            }
            String statusMsg = null;
            statusMsg = this.m_installChain.getStageCount() > 1 ? this.bundle.messageString("PanelExecute.ConsoleStatusMultiStages.txt", this.m_installChain.getCurrentStep(), this.m_installChain.getStepCount(), this.m_installChain.getCurrentStage(), this.m_installChain.getStageCount(), this.m_installStatus.getText()) : this.bundle.messageString("PanelExecute.ConsoleStatus.txt", this.m_installChain.getCurrentStep(), this.m_installChain.getStepCount(), this.m_installStatus.getText());
            if (Globals.g_consoleMode) {
                ConsoleMode.busyMsgStart(statusMsg);
            } else if (Globals.g_quietStatus && Globals.g_quietStatusArea != null) {
                Globals.g_quietStatusArea.busyMsgStart(statusMsg);
            }
            this.m_consoleStatusTxt = this.m_installStatus.getText();
        }
        if (!Globals.g_quietMode) {
            this.m_list.setModel(this.createListModel());
            this.m_installList.getViewport().setView(this.m_list);
            this.m_list.repaint();
            this.m_list.ensureIndexIsVisible(this.m_displayIndex);
            ProductData pd = this.m_installChain.getCurrentInstallData();
            boolean showProgressBar = false;
            File installXML = null;
            String installRef = null;
            if (Globals.g_mode != 2 && pd != null && pd.getInstallRef(false) != null) {
                installXML = new File(Globals.g_startupLocation, pd.getInstallRef(false));
                installRef = pd.getInstallRef(pd.isInteractive());
                if (!(installRef == null || !installRef.toLowerCase().endsWith("install.xml") || "mvs".equalsIgnoreCase(pd.getPlatform()) && pd.isFoundation() || this.getCheckedSizes() == null || this.getCheckedSizes().get(installXML.getAbsolutePath()) == null || pd.getType() == 0)) {
                    showProgressBar = true;
                }
            }
            if (pd.getProdCode().equalsIgnoreCase("eguide") || pd.getProdCode().equalsIgnoreCase("msofficeint")) {
                showProgressBar = false;
            }
            if (showProgressBar) {
                this.m_processing.setVisible(false);
                this.progressBar.setMaximum((int)(this.getCheckedSizes().get(installXML.getAbsolutePath()) / 0x100000L));
                this.progressBar.setVisible(true);
                this.currentTaskLabel.setVisible(true);
                this.progressBar.setValue(0);
                this.progressBar.repaint();
                this._totalBytesMoved = 0L;
            } else {
                this.m_processing.setVisible(true);
                this.progressBar.setVisible(false);
                this.currentTaskLabel.setVisible(false);
            }
        }
    }

    public String getCorrectCD(ProductData currentInstallData) {
        while (this.m_modalActive) {
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        String path = null;
        path = Globals.g_wizard != null ? Globals.g_kit.diskSearch(Globals.g_wizard.getFrame(), currentInstallData) : Globals.g_kit.diskSearch(null, currentInstallData);
        return path;
    }

    public boolean showOEMDialog(String productCode, String htmlFile) {
        KitOEMDialog oemDlg = new KitOEMDialog(productCode, htmlFile);
        oemDlg.show();
        return oemDlg.isInstalled();
    }

    private int printConsoleSummary() {
        ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleSummary.txt"));
        String numOffset = null;
        ProductData prodData = null;
        for (int stage = 0; stage < this.m_stageData.size(); ++stage) {
            ConsoleMode.println(this.bundle.messageString("PanelExecute.Stage.txt", Integer.toString(stage + 1), (String)this.m_stageNames.get(stage)));
            ArrayList stageData = (ArrayList)this.m_stageData.get(stage);
            for (int step = 0; step < stageData.size(); ++step) {
                prodData = (ProductData)stageData.get(step);
                numOffset = "";
                if (stageData.size() > 99) {
                    if (step + 1 < 10) {
                        numOffset = "  ";
                    } else if (step + 1 < 100) {
                        numOffset = " ";
                    }
                } else if (stageData.size() > 9 && step + 1 < 10) {
                    numOffset = " ";
                }
                if (Globals.g_chainData.getInstallStatus(stage, step) == 1) {
                    ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleSuccessChar.txt") + "  " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
                    continue;
                }
                if (Globals.g_chainData.getInstallStatus(stage, step) == 4) {
                    ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleWarningChar.txt") + "  " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
                    continue;
                }
                if (Globals.g_chainData.getInstallStatus(stage, step) == 2) {
                    ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleFailureChar.txt") + "  " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
                    continue;
                }
                if (Globals.g_chainData.getInstallStatus(stage, step) == 5) {
                    ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleInstalledChar.txt") + "  " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
                    continue;
                }
                ConsoleMode.println("   " + Integer.toString(step + 1) + numOffset + " - " + prodData.getProdNameExtended());
            }
            if (stage >= this.m_stageData.size() - 1) continue;
            ConsoleMode.println();
        }
        ConsoleMode.println();
        ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleSuccessChar.txt") + " = " + this.bundle.getString("PanelExecute.SuccessLegend.txt"));
        ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleWarningChar.txt") + " = " + this.bundle.getString("PanelExecute.WarningLegend.txt"));
        ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleFailureChar.txt") + " = " + this.bundle.getString("PanelExecute.FailureLegend.txt"));
        ConsoleMode.println(this.bundle.getString("PanelExecute.ConsoleInstalledChar.txt") + " = " + this.bundle.getString("PanelExecute.InstalledLegend.txt"));
        return ConsoleMode.promptPause();
    }

    public void morphToSummary() {
        Globals.g_wizard.setWizardActive(false);
        Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelExecute.SummaryHeader.txt"));
        if (Globals.g_cmtTask == 40) {
            Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelExecute.SummaryHeaderDescRepair.txt"));
        } else {
            Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelExecute.SummaryHeaderDesc.txt"));
        }
        if (Globals.g_consoleMode) {
            ConsoleMode.busyMsgStop();
            ConsoleMode.println();
        } else {
            Globals.g_wizard.enableButtons();
        }
        this.m_installStatus.setVisible(false);
        this.m_processing.setVisible(false);
        this.m_installing = false;
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().validate();
        }
        if (Globals.g_mode == 2 && Globals.g_cmtTask == 5) {
            boolean returnCode = false;
            if (this.m_installChain.oneFailed()) {
                if (Globals.g_configDefaults != null) {
                    String stageName = Globals.g_configDefaults.getDefault("cfgwizard.updateConfigure.target.name", "");
                    if (this.m_installChain.getCurrentStageName().equals(stageName)) {
                        Globals.g_wizard.setReturnCode(-9998);
                    } else {
                        Globals.g_wizard.setReturnCode(-1);
                    }
                } else {
                    Globals.g_wizard.setReturnCode(-1);
                }
            }
        }
        if (Globals.g_srwOnly && !this.m_applicable) {
            this.m_applicableText.setVisible(true);
            this.m_applicableText.revalidate();
        }
        if (Globals.g_cmtTask == 41 && this.m_warning) {
            if (Globals.g_sasinstallPlat == null) {
                this.m_warningText.setText(this.bundle.messageString("PanelExecute.TKLASRwarning1.txt"));
            } else {
                this.m_warningText.setText(this.bundle.messageString("PanelExecute.TKLASRwarning2.txt"));
            }
            this.m_warningText.setVisible(true);
            this.m_warningText.addHyperlinkListener(this);
            this.m_warningText.revalidate();
        }
        this.bf.close();
        if (this.bf.isEmpty() && Globals.g_createBatch) {
            Logging.log.warning(this.bundle.getString("PanelExecute.BatchFileEmpty.txt"));
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelExecute.BatchFileEmpty.txt", this.bundle.getString("Common.Title.txt")), Globals.g_wizard.getWizardTitle(), 1);
        }
    }

    public int promptForPermissions(String script) {
        int promptVal = this.m_installChain.PROMPT_CONTINUE;
        String msg = null;
        msg = script != null ? this.bundle.messageString("PanelExecute.SASPermissionsMsg.txt", script, Globals.g_wizard.getWizardTitle()) : this.bundle.messageString("PanelExecute.SASPermissionsMsgNoScript.txt", Globals.g_wizard.getWizardTitle());
        if (Globals.g_consoleMode) {
            ConsoleMode.println();
            ConsoleMode.printInfoText(msg);
            String[] options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Continue.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Exit.txt"))};
            int returnCode = ConsoleMode.promptSingleChoice(options, null, null, 0, true);
            if (returnCode == 0) {
                promptVal = this.m_installChain.PROMPT_RETRY;
            } else if (returnCode == 1) {
                promptVal = this.m_installChain.PROMPT_CONTINUE;
                Logging.log.warning("User chose to perform configuration without having setuid permissions on critical SAS files.");
            } else {
                promptVal = this.m_installChain.PROMPT_STOP;
            }
        } else {
            Object[] options = new Object[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Continue.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Exit.txt"))};
            JEditorPane msgArea = new JEditorPane();
            msgArea.setOpaque(false);
            msgArea.setEditable(false);
            msgArea.setContentType("text/html");
            String msgPrefix = "<html><font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
            String msgPostfix = "</font></html>";
            msgArea.setText(msgPrefix + msg + msgPostfix);
            msgArea.setCaretPosition(0);
            switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, this.bundle.getString("PanelExecute.SASPermissionsTitle.txt"), 1, 3, null, options, options[0])) {
                case 0: {
                    promptVal = this.m_installChain.PROMPT_RETRY;
                    break;
                }
                case 1: {
                    promptVal = this.m_installChain.PROMPT_CONTINUE;
                    Logging.log.warning("User chose to perform configuration without having setuid permissions on critical SAS files.");
                    break;
                }
                default: {
                    promptVal = this.m_installChain.PROMPT_STOP;
                }
            }
        }
        return promptVal;
    }

    public void promptWithWarning() {
        ProductData prodData = this.m_installChain.getCurrentInstallData();
        String prodCode = prodData.getProdCode();
        if (prodData.getType() == 1 && prodCode.equalsIgnoreCase("zosinstwiz")) {
            String warning = null;
            File logFile = new File(Globals.g_installData.getProperty("zos.intermediate.files", ""), "zosinstwiz.log");
            if (logFile.isFile()) {
                PropsParser logData = new PropsParser(false);
                try {
                    logData.load(logFile, null);
                    warning = logData.getProperty("status_dlgmsg", null);
                }
                catch (Exception e) {
                    Logging.log.info("Error loading log file: " + logFile.getAbsolutePath());
                }
            } else {
                Logging.log.info("Log file not found: " + logFile.getAbsolutePath());
            }
            if (warning != null) {
                Logging.log.warning("Install Warning\n         Product: " + prodData.getProdName() + "\n         Warning: " + warning);
                if (Globals.g_consoleMode) {
                    ConsoleMode.errorMsg(Utils.removeHTMLTags(warning));
                } else if (!Globals.g_quietMode) {
                    String msgPrefix = "<html><font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
                    String msgPostfix = "</font></html>";
                    String msgTitle = this.bundle.getString("PanelExecute.InstallTitleWarning.txt");
                    if (Globals.g_cmtTask == 28) {
                        msgTitle = this.bundle.getString("PanelExecute.UninstallTitleWarning.txt");
                    }
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), msgPrefix + warning + msgPostfix, msgTitle, 2);
                }
            }
        }
    }

    public int promptToContinue(boolean lastInstall, int retVal, String antLog) {
        int promptVal = this.m_installChain.PROMPT_CONTINUE;
        int buttonLayout = this.getButtonLayout();
        ProductData prodData = this.m_installChain.getCurrentInstallData();
        String prodCode = prodData.getProdCode();
        String installStatus = null;
        String installStatusDlgMsg = null;
        String installStatusLogMsg = null;
        String installMessage = null;
        String installLogFile = null;
        if (prodData.getType() == 1 && Globals.g_mode != 2 && !prodCode.equalsIgnoreCase("javaruntime")) {
            if (prodCode.equalsIgnoreCase("zosinstwiz")) {
                File logFile = new File(Globals.g_installData.getProperty("zos.intermediate.files", ""), "zosinstwiz.log");
                if (logFile.isFile()) {
                    PropsParser logData = new PropsParser(false);
                    try {
                        logData.load(logFile, null);
                        installStatus = logData.getProperty("status", null);
                        installStatusDlgMsg = logData.getProperty("status_dlgmsg", null);
                        installLogFile = logData.getProperty("logfile", null);
                    }
                    catch (Exception e) {
                        Logging.log.info("Error loading log file: " + logFile.getAbsolutePath());
                    }
                } else {
                    Logging.log.info("Log file not found: " + logFile.getAbsolutePath());
                }
            } else {
                if (this.m_registryAccess == null) {
                    try {
                        this.m_registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    }
                    catch (Exception e) {
                        this.m_registryAccess = null;
                    }
                }
                if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                    String platform;
                    String version = prodData.getProdVersion();
                    if ("javaruntime".equalsIgnoreCase(prodData.getProdCode())) {
                        version = Globals.g_majorReleaseVersion;
                    }
                    if ((platform = prodData.getPlatform()) != null) {
                        installStatus = this.m_registryAccess.getInstallStatus(prodCode, version, platform);
                        installStatusDlgMsg = this.m_registryAccess.getInstallStatusDlgMsg(prodCode, version, platform);
                        installStatusLogMsg = this.m_registryAccess.getInstallStatusLogMsg(prodCode, version, platform);
                        installLogFile = this.m_registryAccess.getInstallLogFile(prodCode, version, platform);
                    } else {
                        installStatus = this.m_registryAccess.getInstallStatus(prodCode, version);
                        installStatusDlgMsg = this.m_registryAccess.getInstallStatusDlgMsg(prodCode, version);
                        installStatusLogMsg = this.m_registryAccess.getInstallStatusLogMsg(prodCode, version);
                        installLogFile = this.m_registryAccess.getInstallLogFile(prodCode, version);
                    }
                    this.m_registryAccess.close();
                }
            }
            if (new File(antLog).isFile()) {
                installLogFile = antLog;
            }
            if (installStatus != null) {
                if (installStatus.equals(Integer.toString(-990))) {
                    installMessage = installStatusDlgMsg;
                } else {
                    String key = null;
                    Enumeration e = this.bundle.getKeys();
                    while (e.hasMoreElements() && installMessage == null) {
                        key = (String)e.nextElement();
                        if (!key.equalsIgnoreCase("Install.Error." + installStatus)) continue;
                        installMessage = this.bundle.getString(key);
                    }
                }
            }
            if (installStatus != null) {
                String logMsg = "Install Status: " + installStatus;
                if (installStatusLogMsg != null && installStatusLogMsg.length() > 0) {
                    logMsg = logMsg + Globals.g_eol + "        Install Message: " + installStatusLogMsg;
                }
                if (installLogFile != null && installLogFile.length() > 0) {
                    logMsg = logMsg + Globals.g_eol + "        Install Log File: " + installLogFile;
                }
                Logging.log.severe(logMsg);
            }
        }
        if (!this.m_ignoreErrors) {
            while (this.m_modalActive) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception logMsg) {}
            }
            JEditorPane msgArea = new JEditorPane();
            msgArea.setOpaque(false);
            msgArea.setEditable(false);
            msgArea.setContentType("text/html");
            msgArea.addHyperlinkListener(this);
            String msgPrefix = "<html><font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
            String msgPostfix = "</font></html>";
            if (lastInstall) {
                String title = null;
                String msgTxt = null;
                if (prodData.getType() == 5) {
                    title = this.bundle.getString("PanelExecute.ConfigTitle.txt");
                    msgTxt = this.getConfigErrorMsg(prodData, antLog, lastInstall, buttonLayout);
                } else if (Globals.g_mode == 2 && Globals.g_cmtInstallTargets != null) {
                    String logText = null;
                    logText = new File(antLog).isFile() ? this.getHTMLLinkText(antLog) : this.bundle.getString("Common.NotAvailable.txt");
                    if (Globals.g_cmtTask == 11) {
                        title = this.bundle.getString("PanelExecute.InstallTitle.txt");
                        msgTxt = this.getInstallErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                    } else {
                        title = this.bundle.getString("PanelExecute.ConfigTitle.txt");
                        if (lastInstall) {
                            if (Globals.g_cmtTask == 43) {
                                title = this.bundle.getString("PanelExecute.hadoop_client.label.txt");
                                if (prodData.getProdCode().equals("hadoopcjars")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else if (Globals.g_cmtTask == 46) {
                                title = this.bundle.getString("PanelExecute.hadoop_sasgrid.label.txt");
                                if (prodData.getProdCode().equals("gridctlsvrh")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else if (Globals.g_cmtTask == 47) {
                                title = this.bundle.getString("PanelExecute.hadoop_tkindbsrv.label.txt");
                                if (prodData.getProdCode().equals("hadoop")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else if (Globals.g_cmtTask == 50) {
                                title = this.bundle.getString("PanelExecute.hadoop_epvalidation.label.txt");
                                if (prodData.getProdCode().equals("hadoop")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else if (Globals.g_cmtTask == 51) {
                                title = this.bundle.getString("PanelExecute.hadoop_dmsprkhadp.label.txt");
                                if (prodData.getProdCode().equals("hadoopcjars")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else if (Globals.g_cmtTask == 53) {
                                title = this.bundle.getString("PanelExecute.hadoop_sasqkb.label.txt");
                                if (prodData.getProdCode().equals("hadoopcjars")) {
                                    installLogFile = Controller.defaultController().getITLog();
                                }
                                msgTxt = this.getHadoopConfigErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                            } else {
                                msgTxt = this.bundle.messageString("PanelExecute.ConfigPromptGenericLast.txt", prodData.getProdName(), logText);
                            }
                        } else {
                            msgTxt = this.bundle.messageString("PanelExecute.ConfigPromptGeneric.txt", prodData.getProdName(), logText);
                            msgTxt = Globals.g_allowContinue ? msgTxt + this.bundle.messageString("PanelExecute.ConfigPromptAllowContinue.txt") : msgTxt + this.bundle.messageString("PanelExecute.ConfigPromptStopRetry.txt");
                        }
                    }
                } else if (prodData.getType() == 2) {
                    title = this.bundle.getString("PanelExecute.ConfigTitle.txt");
                    msgTxt = this.getConfigErrorMsg(prodData, antLog, lastInstall, buttonLayout);
                } else if (Globals.g_cmtTask == 41) {
                    title = this.bundle.getString("PanelExecute.RenewTitle.txt");
                    installLogFile = prodData.getProdCode().equals("base_renewal") ? Controller.defaultController().getSetinitLog() : Controller.defaultController().getITLog();
                    msgTxt = this.getRenewErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                } else {
                    title = this.bundle.getString("PanelExecute.InstallTitle.txt");
                    if (Globals.g_cmtTask == 28) {
                        title = this.bundle.getString("PanelExecute.UninstallTitle.txt");
                    }
                    msgTxt = this.getInstallErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                }
                Object[] options = null;
                int defaultButton = 0;
                if (prodData.getProdCode() == "installtool") {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.OK.txt"))};
                    defaultButton = 0;
                } else {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"))};
                    defaultButton = 1;
                }
                if (Globals.g_consoleMode) {
                    ConsoleMode.printInfoText(msgTxt);
                    int returnCode = ConsoleMode.promptSingleChoice((String[])options, null, null, defaultButton, true);
                    if (returnCode == 0) {
                        promptVal = this.m_installChain.PROMPT_CONTINUE;
                    } else if (returnCode == 1) {
                        promptVal = this.m_installChain.PROMPT_RETRY;
                    }
                } else {
                    msgArea.setText(msgPrefix + msgTxt + msgPostfix);
                    msgArea.setCaretPosition(0);
                    switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 0, 0, null, options, options[defaultButton])) {
                        case 0: {
                            promptVal = this.m_installChain.PROMPT_CONTINUE;
                            break;
                        }
                        default: {
                            promptVal = prodData.getProdCode() == "installtool" ? this.m_installChain.PROMPT_CONTINUE : this.m_installChain.PROMPT_RETRY;
                        }
                    }
                }
            } else {
                String title = null;
                String msgTxt = null;
                if (prodData.getType() == 2 || prodData.getType() == 5) {
                    title = this.bundle.getString("PanelExecute.ConfigTitle.txt");
                    msgTxt = this.getConfigErrorMsg(prodData, antLog, lastInstall, buttonLayout);
                } else if (Globals.g_cmtTask == 41) {
                    title = this.bundle.getString("PanelExecute.RenewTitle.txt");
                    installLogFile = prodData.getProdCode().equals("base_renewal") ? Controller.defaultController().getSetinitLog() : Controller.defaultController().getITLog();
                    msgTxt = this.getRenewErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                } else {
                    title = this.bundle.getString("PanelExecute.InstallTitle.txt");
                    if (Globals.g_cmtTask == 28) {
                        title = this.bundle.getString("PanelExecute.UninstallTitle.txt");
                    }
                    msgTxt = this.getInstallErrorMsg(prodData, installStatus, installMessage, installLogFile, lastInstall);
                }
                Object[] options = null;
                int defaultButton = 0;
                if (prodData.getProdCode() == "installtool") {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.YesToAllButton.txt"))};
                    defaultButton = 0;
                } else if (prodData.getProdCode().equals("privatejre")) {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt"))};
                    defaultButton = 0;
                } else if (buttonLayout == 0) {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.YesToAllButton.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"))};
                    defaultButton = 3;
                } else if (buttonLayout == 1) {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"))};
                    defaultButton = 2;
                } else {
                    options = new String[]{Util.getLabelWithoutMnemonic(this.bundle.getString("PanelExecute.StopButton.txt")), Util.getLabelWithoutMnemonic(this.bundle.getString("Common.RetryButton.txt"))};
                    defaultButton = 1;
                }
                if (Globals.g_consoleMode) {
                    ConsoleMode.printInfoText(msgTxt);
                    int returnCode = ConsoleMode.promptSingleChoice((String[])options, null, null, defaultButton, true);
                    if (returnCode == 0) {
                        promptVal = this.m_installChain.PROMPT_STOP;
                    } else if (returnCode == 1) {
                        promptVal = buttonLayout == 0 || buttonLayout == 1 ? this.m_installChain.PROMPT_CONTINUE : this.m_installChain.PROMPT_RETRY;
                    } else if (returnCode == 2) {
                        if (buttonLayout == 1) {
                            promptVal = this.m_installChain.PROMPT_RETRY;
                        } else {
                            promptVal = this.m_installChain.PROMPT_CONTINUE;
                            this.m_ignoreErrors = true;
                        }
                    } else if (returnCode == 3) {
                        promptVal = this.m_installChain.PROMPT_RETRY;
                    }
                } else {
                    msgArea.setText(msgPrefix + msgTxt + msgPostfix);
                    msgArea.setCaretPosition(0);
                    switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 1, 0, null, options, options[defaultButton])) {
                        case 0: {
                            promptVal = this.m_installChain.PROMPT_STOP;
                            break;
                        }
                        case 1: {
                            promptVal = buttonLayout == 0 || buttonLayout == 1 ? this.m_installChain.PROMPT_CONTINUE : this.m_installChain.PROMPT_RETRY;
                            break;
                        }
                        case 2: {
                            if (buttonLayout == 1) {
                                promptVal = this.m_installChain.PROMPT_RETRY;
                                break;
                            }
                            promptVal = this.m_installChain.PROMPT_CONTINUE;
                            this.m_ignoreErrors = true;
                            break;
                        }
                        default: {
                            promptVal = prodData.getProdCode() == "installtool" ? this.m_installChain.PROMPT_STOP : this.m_installChain.PROMPT_RETRY;
                        }
                    }
                }
            }
        }
        return promptVal;
    }

    private String getInstallErrorMsg(ProductData prodData, String installStatus, String installMessage, String installLogFile, boolean lastItem) {
        String msg = null;
        String prefix = "PanelExecute.InstallPrompt";
        if (Globals.g_cmtTask == 28) {
            prefix = "PanelExecute.UninstallPrompt";
        }
        if (installStatus != null && installStatus.equals(Integer.toString(-1000))) {
            msg = lastItem ? this.bundle.messageString(prefix + "InitializeFailedLast.txt", prodData.getProdName()) : this.bundle.messageString(prefix + "InitializeFailed.txt", prodData.getProdName());
        } else {
            boolean logFileFound = false;
            if (installLogFile != null) {
                File logFile = new File(installLogFile);
                logFileFound = logFile.isFile();
            }
            if (lastItem) {
                if (prodData.getProdCode() == "installtool") {
                    prefix = prefix + ".installtool.";
                }
                msg = installMessage != null ? (logFileFound ? this.bundle.messageString(prefix + "LastPlusLog.txt", prodData.getProdName(), installMessage, this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "Last.txt", prodData.getProdName(), installMessage)) : (logFileFound ? this.bundle.messageString(prefix + "GenericLastPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "GenericLast.txt", prodData.getProdName()));
            } else {
                msg = installMessage != null ? (logFileFound ? this.bundle.messageString(prefix + "PlusLog.txt", prodData.getProdName(), installMessage, this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + ".txt", prodData.getProdName(), installMessage)) : (prodData.getProdCode().equalsIgnoreCase("sysreqwizard") || prodData.getProdCode().equalsIgnoreCase("javaruntime") ? (logFileFound ? this.bundle.messageString(prefix + "CriticalPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "Critical.txt", prodData.getProdName())) : (logFileFound ? this.bundle.messageString(prefix + "GenericPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "Generic.txt", prodData.getProdName())));
            }
        }
        return msg;
    }

    private String getHadoopConfigErrorMsg(ProductData prodData, String installStatus, String installMessage, String installLogFile, boolean lastItem) {
        String msg = null;
        String prefix = "PanelExecute.HadoopConfigPrompt";
        boolean logFileFound = false;
        if (installLogFile != null) {
            File logFile = new File(installLogFile);
            logFileFound = logFile.isFile();
        }
        msg = lastItem ? (logFileFound ? this.bundle.messageString(prefix + "GenericLastPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "GenericLast.txt", prodData.getProdName())) : (logFileFound ? this.bundle.messageString(prefix + "GenericPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "Generic.txt", prodData.getProdName()));
        return msg;
    }

    private String getRenewErrorMsg(ProductData prodData, String installStatus, String installMessage, String installLogFile, boolean lastItem) {
        String prefix = "PanelExecute.RenewPrompt";
        String msg = null;
        boolean logFileFound = false;
        if (installLogFile != null) {
            File logFile = new File(installLogFile);
            logFileFound = logFile.isFile();
        }
        msg = lastItem ? (logFileFound ? this.bundle.messageString(prefix + "GenericLastPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "GenericLast.txt", prodData.getProdName())) : (logFileFound ? this.bundle.messageString(prefix + "GenericPlusLog.txt", prodData.getProdName(), this.getHTMLLinkText(installLogFile)) : this.bundle.messageString(prefix + "Generic.txt", prodData.getProdName()));
        return msg;
    }

    private String getConfigErrorMsg(ProductData prodData, String antLog, boolean lastItem, int buttonLayout) {
        String msg;
        block32: {
            msg = "";
            String script = Globals.g_configData.getProperty(prodData.getProdCode().toLowerCase(Locale.ENGLISH) + ".config.script.file", null);
            String postmsg = null;
            postmsg = buttonLayout == 0 ? this.bundle.messageString("PanelExecute.ConfigPromptAllowContinue.txt") : (buttonLayout == 1 ? this.bundle.messageString("PanelExecute.ConfigPromptNoYesRetry.txt") : this.bundle.messageString("PanelExecute.ConfigPromptStopRetry.txt"));
            if (script != null) {
                File scriptFile = new File(script);
                Pattern pattern = Pattern.compile("^@(\\w+)\\.install\\.dir@");
                Matcher matcher = pattern.matcher(script);
                if (matcher.find()) {
                    String missingProdCode = matcher.group(1);
                    ProductData missingProdData = null;
                    missingProdData = missingProdCode.equals("sasinstall") && Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_sasinstallPlat, true) : (missingProdCode.equals("jmp") && Globals.g_jmpPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_jmpPlat, true) : (missingProdCode.equals("pcfilesrv") && Globals.g_pcfilesrvPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_pcfilesrvPlat, true) : (missingProdCode.equals("eguide") && Globals.g_eguidePlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_eguidePlat, true) : (missingProdCode.equals("msofficeint") && Globals.g_msofficeintPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_msofficeintPlat, true) : (missingProdCode.equals("msoffintva") && Globals.g_msoffintvaPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, Globals.g_msoffintvaPlat, true) : Globals.g_deploymentData.getProduct(Globals.g_order, missingProdCode, true))))));
                    if (missingProdData == null) {
                        msg = lastItem ? this.bundle.messageString("PanelExecute.ConfigPromptLastNoScriptProp.txt", prodData.getProdName()) : this.bundle.messageString("PanelExecute.ConfigPromptNoScriptProp.txt", prodData.getProdName());
                        msg = msg + postmsg;
                    } else if (lastItem) {
                        msg = this.bundle.messageString("PanelExecute.ConfigPromptLastNotInstalled.txt", prodData.getProdName(), missingProdData.getProdName(), missingProdData.getProdVersion());
                    } else {
                        msg = this.bundle.messageString("PanelExecute.ConfigPromptNotInstalled.txt", prodData.getProdName(), missingProdData.getProdName(), missingProdData.getProdVersion());
                        msg = msg + postmsg;
                    }
                } else if (scriptFile.isFile()) {
                    File statusFile = new File(Globals.g_configData.getProperty("config.lev.logs.configure.dir", ""), prodData.getProdCode().toLowerCase(Locale.ENGLISH) + "_config_status.properties");
                    if (statusFile.isFile()) {
                        Properties statusProps = new Properties();
                        try {
                            FileInputStream fis = new FileInputStream(statusFile);
                            statusProps.load(fis);
                            fis.close();
                            String errorMsg = statusProps.getProperty("error.msg", "");
                            if (errorMsg.length() > 0) {
                                errorMsg = Utils.stringReplaceAll(errorMsg, "\n", "<br>");
                                Logging.log.warning("Configuration error: " + errorMsg);
                                int eolPos = errorMsg.indexOf("<br>");
                                int lineCount = 0;
                                int ignoreChars = 0;
                                String line = null;
                                String newErrorMsg = "";
                                while (eolPos > -1 && lineCount < 10) {
                                    line = errorMsg.substring(0, eolPos);
                                    ignoreChars = this.getHREFLength(line);
                                    while (line.length() > 100 + ignoreChars) {
                                        int breakPos = line.indexOf(" ", 100 + ignoreChars - 20);
                                        if (breakPos == -1 || breakPos > 100 + ignoreChars + 20) {
                                            breakPos = 100 + ignoreChars;
                                            newErrorMsg = newErrorMsg + line.substring(0, breakPos) + "<br>";
                                            line = line.substring(breakPos);
                                        } else {
                                            newErrorMsg = newErrorMsg + line.substring(0, breakPos) + "<br>";
                                            line = line.substring(breakPos + 1);
                                        }
                                        ++lineCount;
                                    }
                                    newErrorMsg = newErrorMsg + line;
                                    ++lineCount;
                                    if (errorMsg.length() > eolPos + 4) {
                                        errorMsg = errorMsg.substring(eolPos + 4);
                                        eolPos = errorMsg.indexOf("<br>");
                                    } else {
                                        eolPos = -1;
                                    }
                                    if (eolPos <= -1 || lineCount >= 10) continue;
                                    newErrorMsg = newErrorMsg + "<br>";
                                }
                                if (lineCount > 0 && eolPos > -1) {
                                    newErrorMsg = newErrorMsg + "<br>[...]";
                                }
                                if (newErrorMsg.length() > 0) {
                                    errorMsg = newErrorMsg;
                                }
                                if (lastItem) {
                                    msg = this.bundle.messageString("PanelExecute.ConfigPromptLast.txt", prodData.getProdName(), errorMsg, scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                                } else {
                                    msg = this.bundle.messageString("PanelExecute.ConfigPrompt.txt", prodData.getProdName(), errorMsg, scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                                    msg = msg + postmsg;
                                }
                                break block32;
                            }
                            Logging.log.warning("Status file is missing error.msg: " + statusFile.getAbsolutePath());
                            if (lastItem) {
                                msg = this.bundle.messageString("PanelExecute.ConfigPromptLastNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                                break block32;
                            }
                            msg = this.bundle.messageString("PanelExecute.ConfigPromptNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                            msg = msg + postmsg;
                        }
                        catch (Exception e) {
                            Logging.log.warning("Error loading configure status file: " + statusFile.getAbsolutePath());
                            if (lastItem) {
                                msg = this.bundle.messageString("PanelExecute.ConfigPromptLastNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                                break block32;
                            }
                            msg = this.bundle.messageString("PanelExecute.ConfigPromptNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                        }
                    } else {
                        Logging.log.warning("Configure status file not available: " + statusFile.getAbsolutePath());
                        if (lastItem) {
                            msg = this.bundle.messageString("PanelExecute.ConfigPromptLastNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                        } else {
                            msg = this.bundle.messageString("PanelExecute.ConfigPromptNoErrorMsg.txt", prodData.getProdName(), scriptFile.getAbsolutePath(), this.getHTMLLinkText(antLog));
                            msg = msg + postmsg;
                        }
                    }
                } else {
                    Logging.log.severe("Configure script not available: " + scriptFile.getAbsolutePath());
                    if (lastItem) {
                        msg = this.bundle.messageString("PanelExecute.ConfigPromptLastNoScript.txt", prodData.getProdName(), scriptFile.getAbsolutePath());
                    } else {
                        msg = this.bundle.messageString("PanelExecute.ConfigPromptNoScript.txt", prodData.getProdName(), scriptFile.getAbsolutePath());
                        msg = msg + postmsg;
                    }
                }
            } else {
                Logging.log.severe("Configure script property not available: " + prodData.getProdCode().toLowerCase(Locale.ENGLISH) + ".config.script.file");
                msg = lastItem ? this.bundle.messageString("PanelExecute.ConfigPromptLastNoScriptProp.txt", prodData.getProdName()) : this.bundle.messageString("PanelExecute.ConfigPromptNoScriptProp.txt", prodData.getProdName());
                msg = msg + postmsg;
            }
        }
        if (prodData.getProdCode().equalsIgnoreCase("cfgwizard") && Globals.g_mode != 2) {
            msg = msg + this.bundle.getString("PanelExecute.ConfigPromptExtraNote.txt");
        }
        return msg;
    }

    private int getButtonLayout() {
        int buttonLayout = 2;
        boolean installstage = false;
        boolean midtierstage = false;
        if (this.m_installChain.getCurrentTarget() == null) {
            installstage = true;
        } else if ("startMidtierServers".equalsIgnoreCase(this.m_installChain.getCurrentTarget())) {
            midtierstage = true;
        }
        if (Globals.g_allowContinue) {
            buttonLayout = 0;
        } else if (installstage) {
            buttonLayout = 0;
        } else if (midtierstage) {
            buttonLayout = 1;
        }
        return buttonLayout;
    }

    private int getHREFLength(String line) {
        int hrefStart = line.indexOf("<a href=");
        int hrefEnd = 0;
        int count = 0;
        while (hrefStart > -1) {
            hrefEnd = line.indexOf(">", hrefStart);
            if (hrefEnd > hrefStart) {
                count = count + (hrefEnd - hrefStart) + 5;
            }
            hrefStart = line.indexOf("<a href=", hrefEnd);
        }
        return count;
    }

    private String getHTMLLinkText(String file) {
        String linkText = "<a href=\"" + Utils.pathToURL(file) + "\">" + file + "</a>";
        return linkText;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    private void initialize() {
        this.m_installList = new JScrollPane(20, 30);
        this.m_installStatus = new JLabel();
        this.m_successLegend = new JLabel();
        this.m_warningLegend = new JLabel();
        this.m_failureLegend = new JLabel();
        this.m_installedLegend = new JLabel();
        this.m_legendPanel = new JPanel();
        this.m_processing = new JLabel();
        this.m_applicableText = new JTextArea();
        this.m_warningText = new JEditorPane();
        Font labelFont = this.m_installStatus.getFont();
        this.m_installStatus.setFont(labelFont.deriveFont(1));
        this.m_list = new JList();
        this.m_list.setOpaque(false);
        this.m_list.setCellRenderer(new ListItemWithGraphic());
        this.m_installList.getViewport().setView(this.m_list);
        this.m_legendPanel.setBorder(new BevelBorder(1));
        this.m_alertNotes = new HyperlinkField();
        this.m_alertNotes.setOpaque(false);
        this.m_alertNotes.setEditable(false);
        this.m_alertNotes.setContentType("text/html");
        this.m_alertNotes.setVisible(false);
        this.m_applicableText = new JTextArea(this.bundle.getString("PanelExecute.NonApplicableDesc.txt"));
        this.m_applicableText.setEditable(false);
        this.m_applicableText.setFocusable(false);
        this.m_applicableText.setLineWrap(false);
        this.m_applicableText.setOpaque(false);
        this.m_applicableText.setVisible(false);
        this.m_warningText = new JEditorPane();
        this.m_warningText.setContentType("text/html");
        this.m_warningText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_warningText.setEditable(false);
        this.m_warningText.setFocusable(false);
        this.m_warningText.setOpaque(false);
        this.m_warningText.setVisible(false);
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelExecute.this.timerEvent();
            }
        };
        this.m_timer = new Timer(250, this.m_timerAction);
        this.currentTaskLabel = new JLabel();
        Font f = this.currentTaskLabel.getFont();
        this.currentTaskLabel.setFont(f.deriveFont(f.getStyle() ^ 1));
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.overallProgressBar = new JProgressBar(0, 1);
        this.overallProgressBar.setValue(0);
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setVisible(false);
    }

    public void setTotalSize(long totalSize) {
        this.setOverallBytes(totalSize);
        this.overallProgressBar.setMaximum((int)(totalSize / 0x100000L));
    }

    private void createLegend() {
        GridBagConstraints c = new GridBagConstraints();
        this.m_legendPanel.removeAll();
        if (!Globals.g_createBatch) {
            this.m_successLegend.setText(this.bundle.getString("PanelExecute.SuccessLegend.txt"));
        } else {
            this.m_successLegend.setText(this.bundle.getString("PanelExecute.SuccessBatchLegend.txt"));
        }
        this.m_successLegend.setIcon(this.bundle.getImageIcon("Common.success.image"));
        if (!Globals.g_srwOnly) {
            this.m_warningLegend.setText(this.bundle.getString("PanelExecute.WarningLegend.txt"));
        } else {
            this.m_warningLegend.setText(this.bundle.getString("PanelExecute.NotApplicableLegend.txt"));
        }
        this.m_warningLegend.setIcon(this.bundle.getImageIcon("Common.warning.image"));
        if (!Globals.g_createBatch) {
            this.m_failureLegend.setText(this.bundle.getString("PanelExecute.FailureLegend.txt"));
        } else {
            this.m_failureLegend.setText(this.bundle.getString("PanelExecute.FailureBatchLegend.txt"));
        }
        this.m_failureLegend.setIcon(this.bundle.getImageIcon("Common.failure.image"));
        this.m_installedLegend.setText(this.bundle.getString("PanelExecute.InstalledLegend.txt"));
        this.m_installedLegend.setIcon(this.bundle.getImageIcon("Common.info.image"));
        this.m_legendPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(6, 5, 2, 7);
        this.m_legendPanel.add((Component)this.m_successLegend, c);
        c.gridy = 1;
        c.insets = new Insets(1, 5, 2, 7);
        this.m_legendPanel.add((Component)this.m_warningLegend, c);
        if (!Globals.g_createBatch) {
            c.gridy = 2;
            c.insets = new Insets(1, 5, 2, 7);
            this.m_legendPanel.add((Component)this.m_failureLegend, c);
        } else {
            c.gridy = 2;
            c.insets = new Insets(1, 5, 6, 7);
            this.m_legendPanel.add((Component)this.m_failureLegend, c);
        }
        if (Globals.g_srwOnly && !Globals.g_createBatch) {
            c.gridy = 3;
            c.insets = new Insets(1, 5, 6, 7);
            this.m_legendPanel.add((Component)this.m_installedLegend, c);
        }
    }

    private void timerEvent() {
        ++this.m_imageCount;
        if (this.m_imageCount > 8) {
            this.m_imageCount = 1;
        }
        switch (this.m_imageCount) {
            case 1: {
                this.m_processing.setIcon(this.m_time1);
                break;
            }
            case 2: {
                this.m_processing.setIcon(this.m_time2);
                break;
            }
            case 3: {
                this.m_processing.setIcon(this.m_time3);
                break;
            }
            case 4: {
                this.m_processing.setIcon(this.m_time4);
                break;
            }
            case 5: {
                this.m_processing.setIcon(this.m_time5);
                break;
            }
            case 6: {
                this.m_processing.setIcon(this.m_time4);
                break;
            }
            case 7: {
                this.m_processing.setIcon(this.m_time3);
                break;
            }
            default: {
                this.m_processing.setIcon(this.m_time2);
            }
        }
    }

    public void startTimer() {
        this.m_processing.setVisible(true);
        this.m_processing.setIcon(this.m_time1);
        this.m_timer.start();
    }

    public void stopTimer() {
        this.m_timer.stop();
        this.m_processing.setVisible(false);
        this.m_imageCount = 1;
    }

    private void updateSummary() {
        this.getStageData();
        this.m_list.setModel(this.createListModel());
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_installList, c);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 0);
        this.m_panel.add((Component)this.m_installStatus, c);
        c = new GridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.3;
        c.insets = new Insets(5, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.overallProgressLabel = new JLabel(this.bundle.messageString("PanelExecute.OverallProgress"));
        Font f = this.overallProgressLabel.getFont();
        this.overallProgressLabel.setFont(f.deriveFont(f.getStyle() ^ 1));
        this.m_panel.add((Component)this.overallProgressLabel, c);
        c = new GridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.7;
        c.insets = new Insets(5, 0, 0, 5);
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        this.currentTaskLabel.setVerticalAlignment(1);
        Dimension d = this.currentTaskLabel.getPreferredSize();
        this.currentTaskLabel.setPreferredSize(new Dimension(d.width + 70, d.height));
        this.m_panel.add((Component)this.currentTaskLabel, c);
        c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 2;
        c.gridheight = 3;
        c.gridwidth = 1;
        c.anchor = 12;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_legendPanel, c);
        c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 5);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        this.m_panel.add((Component)this.m_alertNotes, c);
        this.m_panel.add((Component)this.progressBar, c);
        this.m_panel.add((Component)this.m_processing, c);
        c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 5);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        this.m_panel.add((Component)this.m_applicableText, c);
        c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 5);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        this.m_panel.add((Component)this.m_warningText, c);
        c = new GridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 18;
        this.m_panel.add((Component)this.overallProgressBar, c);
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = null;
        if (this.m_installChain == null || !this.m_installChain.finished()) {
            helpTopic = Globals.g_mode == 2 ? "PanelExecuteSDM" : (Globals.g_configure && Globals.g_planConfigs != null && Globals.g_planConfigs.length > 0 ? "PanelExecutePlanning" : "PanelExecute");
        }
        return helpTopic;
    }

    private void saveData() {
        OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
        if (orderData != null && !orderData.isWeb()) {
            MetadataAccess.closeConnection();
        }
        if (Globals.g_wizard != null && !Globals.g_apprentice) {
            Globals.g_wizard.saveWizardResponses();
        }
        if (Globals.g_wizard != null && Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
            Globals.g_wizard.deleteChainRFile();
        }
        Globals.g_wizardData.save();
        if (Globals.g_sid != null) {
            Globals.g_sid.writeFormattedSIDFile(Globals.g_tempLocation);
        }
        String regXMLFileName = "registry.xml";
        String sasHomeDir = null;
        sasHomeDir = Globals.g_cmtSASHome != null ? Globals.g_cmtSASHome : Globals.g_wizardData.getPreference("SASHome", "");
        File regXMLFile = new File(Utils.joinPath(sasHomeDir, "deploymntreg", regXMLFileName));
        if (regXMLFile.exists()) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm");
            Date my_time = new Date();
            String backupXMLFileName = "registry_" + formatter.format(my_time) + ".bak";
            File backupXMLFile = new File(Utils.joinPath(sasHomeDir, "deploymntreg", backupXMLFileName));
            Utils.copyFile(regXMLFile, backupXMLFile);
        }
        if (!Globals.g_zos && Globals.g_mode != 2) {
            Globals.g_vjrHome = Utils.getVJRHome(Globals.g_wizardData.getPreference("SASHome", ""));
            RegistryData.saveRegistryData();
        } else if (Globals.g_mode == 2 && Globals.g_cmtNewConfigDir) {
            RegistryData.registerConfigDir();
        }
        LicenseServer licenseServer = null;
        if (Globals.g_install) {
            licenseServer = new LicenseServer(Globals.g_wizardData.getPreference("SASHome", ""));
        } else if (Globals.g_mode == 2 && (Globals.g_cmtTask == 3 || Globals.g_cmtTask == 41)) {
            licenseServer = new LicenseServer(Globals.g_cmtSASHome);
        }
        if (licenseServer != null) {
            if (Globals.g_sid != null) {
                licenseServer.add(Globals.g_sid);
            }
            if (Globals.g_jmpSID != null) {
                licenseServer.add(Globals.g_jmpSID);
            }
            if (Globals.g_spdsSID != null) {
                licenseServer.add(Globals.g_spdsSID);
            }
            if (Globals.g_simstudioSID != null) {
                licenseServer.add(Globals.g_simstudioSID);
            }
            if (Globals.g_mominstallSID != null) {
                licenseServer.add(Globals.g_mominstallSID);
            }
            if (!licenseServer.store()) {
                Logging.log.severe("Error storing license files");
            }
        }
        if (Globals.g_install) {
            if (!Globals.g_zos) {
                this.saveCommonRegistryData();
                if (Globals.g_sasDefaultLocale != null) {
                    Globals.g_sasDefaultLocale.saveSASLocaleInDeploymentReg();
                }
                this.createLogsDir();
                this.createHotFixDir();
                this.createInstallConfigFile();
                this.refreshInstallToolProps();
                this.createWrapperConfFile();
            }
            if (Globals.g_installDefaults != null) {
                String name = null;
                String value = null;
                Enumeration e = Globals.g_installDefaults.getNames();
                while (e.hasMoreElements()) {
                    name = (String)e.nextElement();
                    if (Globals.g_installKnownProps.containsKey(name) || (value = Globals.g_installDefaults.getDefault(name, null)) == null) continue;
                    Globals.g_installData.setProperty(name, value);
                }
            }
            if (Globals.g_serverURL != null) {
                Globals.g_installData.setProperty("client.environment.url", Globals.g_serverURL);
            }
            Globals.g_installData.saveWithoutPasswords(Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "install.properties"));
            if (Globals.g_zos) {
                Globals.g_installData.saveWithoutPasswords(Utils.joinPath(Utils.getSDWDataPath(true), "install.properties"));
            }
        }
        if (Globals.g_installDebugFile != null) {
            PropertyRules.printConstants(Globals.g_installDebugFile);
            Globals.g_installDebugFile.close();
        }
        if (Globals.g_configDebugFile != null) {
            PropertyRules.printConstants(Globals.g_configDebugFile);
            Globals.g_configDebugFile.close();
        }
        if (Globals.g_mode != 2 || Globals.g_cmtTask == 26) {
            if (Globals.g_plannedInstall && Globals.g_plan != null && Globals.g_machine != null) {
                Logging.log.info("Deployment Summary" + Globals.g_eol + "      Image Directory:         " + Globals.g_startupLocation + Globals.g_eol + "      Order Number:            " + Globals.g_order + Globals.g_eol + "      Plan File:               " + Globals.g_plan.getFile() + Globals.g_eol + "      Machine Name:            " + Globals.g_machine.getName() + Globals.g_eol + "      Configuration Directory: " + Globals.g_configData.getProperty("config.lev.dir", "Install Only"));
            } else {
                Logging.log.info("Deployment Summary" + Globals.g_eol + "      Image Directory: " + Globals.g_startupLocation + Globals.g_eol + "      Order Number:    " + Globals.g_order);
            }
        }
    }

    private void saveCommonRegistryData() {
        if (this.m_registryAccess == null) {
            try {
                this.m_registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            }
            catch (Exception e) {
                this.m_registryAccess = null;
            }
        }
        if (this.m_registryAccess != null && this.m_registryAccess.open()) {
            this.m_registryAccess.addMajorRelease(Globals.g_majorReleaseVersion);
            String user = null;
            user = Utils.getOS() == 1 ? Utils.getUserDomain() + "\\" + System.getProperty("user.name") : System.getProperty("user.name");
            this.m_registryAccess.setInstallUser(user);
            this.m_registryAccess.close();
        }
    }

    private void createLogsDir() {
        File logsDir = new File(Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc", "InstallLogs"));
        if (!logsDir.exists() && !logsDir.mkdirs()) {
            Logging.log.warning("Error creating the install logs directory: " + logsDir.getAbsolutePath());
        }
    }

    private void createHotFixDir() {
        String hotFixSubDir = Utils.joinPath("InstallMisc", "HotFixes", "New");
        File hotFixDir = new File(Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), hotFixSubDir));
        if (!hotFixDir.exists() && !hotFixDir.mkdirs()) {
            Logging.log.warning("Error creating the install logs directory: " + hotFixDir.getAbsolutePath());
        }
    }

    private void createInstallConfigFile() {
        String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
        File configFile = new File(sasHome, "sassw.config");
        PropsParser configINIFile = new PropsParser(true);
        String section = "properties";
        boolean changed = false;
        try {
            String environmentsURL;
            String javaexe;
            String path;
            if (configFile.isFile()) {
                configINIFile.load(configFile, null);
            }
            if (configINIFile.getINIValue(section, "SASHOME", null) == null) {
                changed = true;
                configINIFile.setINIValue(section, "SASHOME", sasHome);
            }
            if (configINIFile.getINIValue(section, "VJRHOME", null) == null) {
                changed = true;
                configINIFile.setINIValue(section, "VJRHOME", Globals.g_vjrHome);
            }
            if ((path = configINIFile.getINIValue(section, "PRIVATEJREHOME", null)) == null) {
                changed = true;
                javaexe = JREData.getPrivateJavaCommand();
                if (javaexe != null && !javaexe.isEmpty() && Utils.getOS_Suffix() != "mvs") {
                    configINIFile.setINIValue(section, "PRIVATEJREHOME", javaexe);
                }
            } else if (Utils.getOS_Suffix() == "wx6" && (javaexe = JREData.getPrivateJavaCommand()) != null && !javaexe.isEmpty() && !path.equalsIgnoreCase(javaexe)) {
                configINIFile.setINIValue(section, "PRIVATEJREHOME", javaexe);
                changed = true;
            }
            if (Globals.g_jreHome != null) {
                path = configINIFile.getINIValue(section, "JREHOME", null);
                if (JREData.g_jrePrompted || path == null) {
                    changed = true;
                    configINIFile.setINIValue(section, "JREHOME", Utils.getJavaCommand());
                } else if (Utils.getOS_Suffix() == "wx6" && (javaexe = JREData.getPrivateJavaCommand()) != null && !javaexe.isEmpty() && !path.equalsIgnoreCase(javaexe)) {
                    configINIFile.setINIValue(section, "JREHOME", javaexe);
                    changed = true;
                }
            }
            if (Utils.getOS() == 8 && (JREData.g_jrePrompted || configINIFile.getINIValue(section, "DPLMTJREHOME", null) == null)) {
                if (Globals.g_jreHome != null) {
                    changed = true;
                    configINIFile.setINIValue(section, "DPLMTJREHOME", Utils.getJavaCommand());
                } else if (Globals.g_deploymentJREHome != null) {
                    changed = true;
                    configINIFile.setINIValue(section, "DPLMTJREHOME", Utils.buildJavaCommand(Globals.g_deploymentJREHome));
                }
            }
            if (configINIFile.getINIValue(section, "DPLMTREGLOC", null) == null) {
                changed = true;
                File deployRegJar = new File(RegistryData.getDeployRegJar());
                configINIFile.setINIValue(section, "DPLMTREGLOC", deployRegJar.getParent());
            }
            if (Globals.g_showRemoteWebApps && configINIFile.getINIValue(section, "REMOTE_WEB_APPS", null) == null) {
                changed = true;
                if (Globals.g_remoteWebApps) {
                    configINIFile.setINIValue(section, "REMOTE_WEB_APPS", "true");
                } else {
                    configINIFile.setINIValue(section, "REMOTE_WEB_APPS", "false");
                }
            }
            if ((environmentsURL = Globals.g_installData.getProperty("sas.environments.url", null)) != null && !environmentsURL.equals(configINIFile.getINIValue(section, "SASENVIRONMENTSURL", null))) {
                changed = true;
                configINIFile.setINIValue(section, "SASENVIRONMENTSURL", environmentsURL);
            }
            if (changed) {
                configINIFile.save(configFile.toString(), true);
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error creating the master install config file: " + configFile.getAbsolutePath());
        }
    }

    private void createWrapperConfFile() {
        String wrapperConfFile = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "wrapper.conf");
        try {
            PrintWriter confFile = new PrintWriter(new BufferedWriter(new FileWriter(wrapperConfFile)));
            confFile.println("# Java Application");
            confFile.println("wrapper.java.command=" + Utils.getJavaCommand());
            confFile.println();
            confFile.println("# Java Classpath (include wrapper.jar)  Add class path elements as");
            confFile.println("# needed starting from 1");
            confFile.println("wrapper.java.classpath.1=" + Globals.g_vjrHome + File.separator + "eclipse" + File.separator + "plugins" + File.separator + "JavaServiceWrapper_3.2.3" + File.separator + "wrapper.jar");
            confFile.println("wrapper.java.classpath.2=" + Globals.g_vjrHome + File.separator + "eclipse" + File.separator + "plugins" + File.separator + "sas.launcher.jar");
            confFile.println();
            confFile.println("# Java Additional Parameters");
            confFile.println("wrapper.java.additional.1=-Djava.system.class.loader=com.sas.app.AppClassLoader");
            if (Utils.getOS() == 1) {
                confFile.println("wrapper.java.additional.2=-Dsas.app.repository.path=\"" + Globals.g_vjrHome + File.separator + "eclipse\"");
            } else {
                confFile.println("wrapper.java.additional.2=-Dsas.app.repository.path=" + Globals.g_vjrHome + File.separator + "eclipse");
            }
            confFile.close();
        }
        catch (Exception e) {
            Logging.log.info("Error creating Java services configuration file: " + wrapperConfFile);
            Logging.logStackTrace(e);
        }
    }

    private DefaultListModel createListModel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        this.m_displayIndex = 0;
        ProductData prodData = null;
        String listText = null;
        for (int stage = 0; stage < this.m_stageData.size(); ++stage) {
            listModel.addElement(" " + this.bundle.messageString("PanelExecute.Stage.txt", Integer.toString(stage + 1), (String)this.m_stageNames.get(stage)) + "|-1");
            ArrayList stageData = (ArrayList)this.m_stageData.get(stage);
            for (int step = 0; step < stageData.size(); ++step) {
                prodData = (ProductData)stageData.get(step);
                String displayNameExtended = prodData.getProdNameExtended();
                listText = Integer.toString(step + 1) + ".  " + displayNameExtended + "|" + Globals.g_chainData.getInstallStatus(stage, step);
                listModel.addElement(listText);
                if (Globals.g_chainData.getInstallStatus(stage, step) != 3) continue;
                this.m_displayIndex = listModel.getSize() - 1;
            }
            if (stage >= this.m_stageData.size() - 1) continue;
            listModel.addElement(" ");
        }
        if (this.m_displayIndex == 0 && this.m_installChain != null && this.m_installChain.finished()) {
            this.m_displayIndex = listModel.getSize() - 1;
        }
        return listModel;
    }

    private String getAlertNotesLink() {
        return "https://support.sas.com/ctx/alertnotes/alertnotes.jsp?order=" + Globals.g_order;
    }

    private long getNewestSequence(ProductData prodData) {
        ProductData[] mainProdData;
        long sequence = 0L;
        ProductData newestProdData = Globals.g_deploymentData.getMaintenance(Globals.g_order, prodData.getProdCode(), Utils.getOS_Suffix(), "xx", true);
        if (newestProdData == null && (mainProdData = Globals.g_deploymentData.getConfigured(Globals.g_order, new String[]{prodData.getProdCode()}, true)) != null && mainProdData.length == 1) {
            newestProdData = mainProdData[0];
        }
        sequence = newestProdData != null ? newestProdData.getSequenceNum() : prodData.getSequenceNum();
        return sequence;
    }

    private void loadStageDataForConfigInstances(String configTargetsList, ProductData[] instances) {
        if (configTargetsList != null && configTargetsList.trim().length() > 0 && instances != null && instances.length > 0) {
            StringTokenizer configTargets = new StringTokenizer(configTargetsList);
            String target = null;
            String stageName = null;
            String targetProp = null;
            boolean isCalled = false;
            while (configTargets.hasMoreTokens()) {
                target = configTargets.nextToken();
                ArrayList<ProductData> configProducts = null;
                for (int i = 0; i < instances.length; ++i) {
                    String deprecatedProductList = Globals.g_configDefaults.getDefault("cfgwizard.deprecated.12byte.list", "");
                    Logging.log.finer("The following will be excluded from SDM stages because they have been marked as deprecated by the cfgwizard.deprecated.12byte.list property: " + deprecatedProductList);
                    StringTokenizer deprecatedProductTokenizer = new StringTokenizer(deprecatedProductList);
                    ArrayList<String> deprecatedProductArrayList = new ArrayList<String>();
                    while (deprecatedProductTokenizer.hasMoreTokens()) {
                        String deprecatedProduct = deprecatedProductTokenizer.nextToken();
                        Logging.log.finer("Adding product " + deprecatedProduct + " to list of deprecated products");
                        deprecatedProductArrayList.add(deprecatedProduct.toLowerCase());
                    }
                    if (deprecatedProductArrayList.contains(instances[i].getProdCode().toLowerCase()) && Globals.g_cmtTask != 2) {
                        targetProp = "FALSE";
                        Logging.log.info("Configured product " + instances[i].getProdCode() + " appears in cfgwizard.deprecated.12byte.list and has been omitted from target " + target + " in this SDM stage.");
                    } else {
                        targetProp = Globals.g_configDefaults.getDefault(instances[i].getProdCode() + "." + target + ".target.is_called", "FALSE");
                    }
                    if (PropertyRules.containsProperty(targetProp)) {
                        targetProp = PropertyRules.resolveProperties(targetProp, 0);
                    }
                    isCalled = targetProp.equalsIgnoreCase("TRUE");
                    if (target.equals("hotFixConfigure") && instances[i].getType() == 5 && instances[i].getInstanceData().getNewerHotFix() != null) {
                        isCalled = true;
                    }
                    if (!isCalled) continue;
                    if (configProducts == null) {
                        configProducts = new ArrayList<ProductData>();
                    }
                    configProducts.add(instances[i]);
                }
                if (configProducts == null) continue;
                this.m_stageTargets.add(target);
                stageName = Globals.g_configDefaults.getDefault("cfgwizard." + target + ".target.name", "");
                if (PropertyRules.containsProperty(stageName)) {
                    stageName = PropertyRules.resolveProperties(stageName, 0);
                }
                this.m_stageNames.add(stageName);
                this.m_stageData.add(configProducts);
            }
        }
    }

    private void getStageData() {
        this.m_stageTargets = new ArrayList();
        this.m_stageNames = new ArrayList();
        this.m_stageData = new ArrayList();
        if (Globals.g_mode == 2 && Globals.g_cmtTask == 28) {
            this.m_stageTargets.add(null);
            this.m_stageNames.add(this.bundle.getString("PanelExecute.Uninstall.txt"));
            this.m_stageData.add(Globals.g_selectedProductsToUninstall);
        } else if (Globals.g_mode == 2 && Globals.g_cmtTask == 11) {
            if (Globals.g_cmtRunInstall) {
                this.m_stageTargets.add(null);
                this.m_stageNames.add(this.bundle.getString("PanelExecute.HotFixInstallation.txt"));
                this.m_stageData.add(Globals.g_selectedHotFixesToInstall);
            }
            if (Globals.g_cmtRunConfigure) {
                if (Globals.g_selectedHotFixesToConfig != null && Globals.g_selectedHotFixesToConfig.length > 0) {
                    this.loadStageDataForConfigInstances(Globals.g_configDefaults.getDefault("cfgwizard.hotFixConfigure.target.list", ""), Globals.g_selectedHotFixesToConfig);
                }
                if (Globals.g_selectedHotFixesWithWebApps != null && Globals.g_selectedHotFixesWithWebApps.length > 0) {
                    this.loadStageDataForConfigInstances(Globals.g_configDefaults.getDefault("cfgwizard.buildWebapps.target.list", ""), Globals.g_selectedHotFixesWithWebApps);
                }
                if (Globals.g_selectedHotFixesWithWebAppsToDeploy != null && Globals.g_selectedHotFixesWithWebAppsToDeploy.length > 0) {
                    this.loadStageDataForConfigInstances(Globals.g_configDefaults.getDefault("cfgwizard.deployWebapps.target.list", ""), Globals.g_selectedHotFixesWithWebAppsToDeploy);
                }
            }
        } else if (Globals.g_mode == 2 && Globals.g_cmtInstallTargets != null && Globals.g_cmtInstalls != null) {
            String target = null;
            String stageName = null;
            for (int i = 0; i < Globals.g_cmtInstallTargets.length; ++i) {
                target = Globals.g_cmtInstallTargets[i];
                this.m_stageTargets.add(target);
                stageName = Globals.g_installDefaults.getDefault("deploywiz." + target + ".target.name", "");
                if (PropertyRules.containsProperty(stageName)) {
                    stageName = PropertyRules.resolveProperties(stageName, 1);
                }
                this.m_stageNames.add(stageName);
                this.m_stageData.add(Globals.g_cmtInstalls);
            }
        } else if (Globals.g_processInstances && Globals.g_instances != null && Globals.g_cmtTask != 41) {
            int found = 0;
            Object swap = null;
            for (int i = 0; i < Globals.g_instances.length; ++i) {
                found = i;
                for (int j = i + 1; j < Globals.g_instances.length; ++j) {
                    if (Globals.g_cmtTask == 2 || Globals.g_cmtTask == 0) {
                        if (Globals.g_instances[j].getSequenceNum() <= Globals.g_instances[found].getSequenceNum()) continue;
                        found = j;
                        continue;
                    }
                    if (Globals.g_cmtTask == 5) {
                        if (this.getNewestSequence(Globals.g_instances[j]) >= this.getNewestSequence(Globals.g_instances[found])) continue;
                        found = j;
                        continue;
                    }
                    if (Globals.g_instances[j].getSequenceNum() >= Globals.g_instances[found].getSequenceNum()) continue;
                    found = j;
                }
                if (found == i) continue;
                swap = Globals.g_instances[i];
                Globals.g_instances[i] = Globals.g_instances[found];
                Globals.g_instances[found] = swap;
            }
            String configTargetsList = null;
            if (Globals.g_cmtTask == 0) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.updatePasswords.target.list", "");
            } else if (Globals.g_cmtTask == 2) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.unconfigure.target.list", "");
            } else if (Globals.g_cmtTask == 1) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.buildWebapps.target.list", "");
            } else if (Globals.g_cmtTask == 34) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.deployWebapps.target.list", "");
            } else if (Globals.g_cmtTask == 3) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.updatesid.target.list", "");
            } else if (Globals.g_cmtTask == 4) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.changeHost.target.list", "");
            } else if (Globals.g_cmtTask == 52) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.autoload.target.list", "");
            } else if (Globals.g_cmtTask == 49) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.updateHadoopMetadata.target.list", "");
            } else if (Globals.g_cmtTask == 5) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.applyMaint.target.list", "");
            } else if (Globals.g_cmtTask == 27) {
                configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.changePassPhrase.target.list", "");
            } else if (Globals.g_cmtTaskTargetList != null) {
                configTargetsList = Globals.g_cmtTaskTargetList;
            }
            this.loadStageDataForConfigInstances(configTargetsList, Globals.g_instances);
        } else {
            ArrayList<Object> installProducts = null;
            if (Globals.g_mode == 2) {
                installProducts = new ArrayList();
                if (Globals.g_cmtTask == 41) {
                    Controller.setInstallProperties(InstallToolConnector.getProperties());
                    for (ProductData productData : Globals.g_renewalProducts) {
                        installProducts.add(productData);
                    }
                } else if (Globals.g_cmtTask == 40) {
                    Controller.setInstallProperties(InstallToolConnector.getProperties());
                    for (ProductData productData : Globals.g_repairTasks) {
                        installProducts.add(productData);
                    }
                }
            } else {
                installProducts = Globals.g_srwOnly ? new ArrayList<ProductData>(Arrays.asList(Globals.g_selectedSRWs)) : new ArrayList<ProductData>(this.getInstallProducts());
            }
            ArrayList<ProductData> sysReqProducts = new ArrayList<ProductData>();
            if (!installProducts.isEmpty()) {
                int i = 0;
                while (i < installProducts.size()) {
                    ProductData myProd = (ProductData)installProducts.get(i);
                    if (myProd.getType() == 0) {
                        if (!myProd.isApplicable()) {
                            this.m_applicable = false;
                        }
                        sysReqProducts.add(myProd);
                        installProducts.remove(i);
                        continue;
                    }
                    ++i;
                }
                final ProductData dotnet46 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet46", false);
                final ProductData dotnet461 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet461", false);
                final ProductData dotnet471 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet471", false);
                final ProductData dotnet48 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet48", false);
                String servicePack = System.getProperty("sun.os.patch.level");
                String osVersion = System.getProperty("os.name");
                ArrayList<ProductData> dotnets = new ArrayList<ProductData>(){
                    {
                        this.add(dotnet48);
                        this.add(dotnet471);
                        this.add(dotnet461);
                        this.add(dotnet46);
                    }
                };
                if (osVersion.equals("Windows Server 2008") && servicePack.equals("Service Pack 2")) {
                    Logging.log.info(".NET 4.8, .NET 4.7.1, and .NET 4.6.1 are not supported on a Windows Server 2008 Service Pack 2 system, so installing .NET 4.6 instead.");
                    sysReqProducts.remove(dotnet48);
                    sysReqProducts.remove(dotnet471);
                    sysReqProducts.remove(dotnet461);
                } else {
                    for (int k = 0; k < dotnets.size() - 1; ++k) {
                        if (dotnets.get(k) == null || !sysReqProducts.contains(dotnets.get(k))) continue;
                        for (int j = k + 1; j < dotnets.size(); ++j) {
                            if (dotnets.get(j) == null || !sysReqProducts.contains(dotnets.get(j))) continue;
                            Logging.log.info(((ProductData)dotnets.get(k)).getProdName() + " and " + ((ProductData)dotnets.get(j)).getProdName() + " are both in the install chain and cannot both be installed on the same system, so removing " + ((ProductData)dotnets.get(j)).getProdName() + " from install chain.");
                            sysReqProducts.remove(dotnets.get(j));
                        }
                    }
                }
                final ProductData vcredist2015 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2015", false);
                final ProductData vcredist2017 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2017", false);
                final ProductData vcredist2019 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2019", false);
                ArrayList<ProductData> vcredists = new ArrayList<ProductData>(){
                    {
                        this.add(vcredist2019);
                        this.add(vcredist2017);
                        this.add(vcredist2015);
                    }
                };
                for (int k = 0; k < vcredists.size() - 1; ++k) {
                    if (vcredists.get(k) == null || !sysReqProducts.contains(vcredists.get(k))) continue;
                    for (int j = k + 1; j < vcredists.size(); ++j) {
                        if (vcredists.get(j) == null || !sysReqProducts.contains(vcredists.get(j))) continue;
                        Logging.log.info(((ProductData)vcredists.get(k)).getProdName() + " and " + ((ProductData)vcredists.get(j)).getProdName() + " are both in the install chain and cannot both be installed on the same system, so removing " + ((ProductData)vcredists.get(j)).getProdName() + " from install chain.");
                        sysReqProducts.remove(vcredists.get(j));
                    }
                }
                if (!sysReqProducts.isEmpty()) {
                    Collections.sort(sysReqProducts, new Comparator<ProductData>(){

                        @Override
                        public int compare(ProductData pd1, ProductData pd2) {
                            Pattern pattern = Pattern.compile("(\\d+(\\.\\d+)?|\\D+)");
                            Matcher matcher1 = pattern.matcher(pd1.getProdName());
                            Matcher matcher2 = pattern.matcher(pd2.getProdName());
                            int result = 0;
                            while (result == 0) {
                                boolean found1 = matcher1.find();
                                boolean found2 = matcher2.find();
                                if (!found1 && !found2) {
                                    return pd1.getProdName().compareTo(pd2.getProdName());
                                }
                                if (!found1) {
                                    result = -1;
                                    continue;
                                }
                                if (!found2) {
                                    result = 1;
                                    continue;
                                }
                                String segment1 = matcher1.group();
                                String segment2 = matcher2.group();
                                if (Character.isDigit(segment1.toCharArray()[0])) {
                                    result = new Double(segment1).compareTo(new Double(segment2));
                                    continue;
                                }
                                result = segment1.compareToIgnoreCase(segment2);
                            }
                            return result;
                        }
                    });
                    this.m_stageTargets.add(null);
                    this.m_stageNames.add(this.bundle.getString("PanelExecute.SystemRequirements.txt"));
                    this.m_stageData.add(sysReqProducts);
                }
                if (!Globals.g_srwOnly) {
                    this.m_stageTargets.add(null);
                    if (Globals.g_cmtTask == 41) {
                        this.m_stageNames.add(this.bundle.getString("PanelExecute.Renewal.txt"));
                    } else if (Globals.g_cmtTask == 40) {
                        this.m_stageNames.add(this.bundle.getString("PanelExecute.Repair.txt"));
                    } else {
                        this.m_stageNames.add(this.bundle.getString("PanelExecute.Installation.txt"));
                    }
                    this.m_stageData.add(installProducts);
                }
            }
            if (Globals.g_configure && Globals.g_planConfigs != null && Globals.g_planConfigs.length > 0) {
                String configTargetsList = null;
                configTargetsList = Globals.g_configData.getProperty("config.migration.is_selected", "False").equalsIgnoreCase("True") ? Globals.g_configDefaults.getDefault("cfgwizard.migration.target.list", "") : Globals.g_configDefaults.getDefault("cfgwizard.initialConfig.target.list", "");
                StringTokenizer configTargets = new StringTokenizer(configTargetsList);
                ProductData[] configData = Globals.g_deploymentData.getConfigured(Globals.g_order, Globals.g_planConfigs, true);
                String target = null;
                String targetProp = null;
                String stageName = null;
                boolean isCalled = false;
                while (configTargets.hasMoreTokens()) {
                    target = configTargets.nextToken();
                    ArrayList<ProductData> configProducts = null;
                    for (int i = 0; i < configData.length; ++i) {
                        targetProp = Globals.g_configDefaults.getDefault(configData[i].getProdCode() + "." + target + ".target.is_called", "FALSE");
                        if (PropertyRules.containsProperty(targetProp)) {
                            targetProp = PropertyRules.resolveProperties(targetProp, 0);
                        }
                        if (!(isCalled = targetProp.equalsIgnoreCase("TRUE"))) continue;
                        if (configProducts == null) {
                            configProducts = new ArrayList<ProductData>();
                        }
                        configProducts.add(configData[i]);
                    }
                    if (configProducts == null) continue;
                    this.m_stageTargets.add(target);
                    stageName = Globals.g_configDefaults.getDefault("cfgwizard." + target + ".target.name", "");
                    if (PropertyRules.containsProperty(stageName)) {
                        stageName = PropertyRules.resolveProperties(stageName, 0);
                    }
                    this.m_stageNames.add(stageName);
                    this.m_stageData.add(configProducts);
                }
            }
        }
        if (!Globals.g_resumeChain) {
            Globals.g_chainData.clear();
            Globals.g_chainData.setStageCount(this.m_stageData.size());
            ProductData prodData = null;
            for (int stage = 0; stage < this.m_stageData.size(); ++stage) {
                ArrayList stageData = (ArrayList)this.m_stageData.get(stage);
                Globals.g_chainData.setStageStepCount(stage, stageData.size());
                for (int step = 0; step < stageData.size(); ++step) {
                    String installRef;
                    prodData = (ProductData)stageData.get(step);
                    Globals.g_chainData.setProductSpsSku(stage, step, prodData.getSpsSku());
                    Globals.g_chainData.setInstallStatus(stage, step, 0);
                    if (Globals.g_mode == 2 || prodData.getInstallRef(prodData.isInteractive()) == null || (installRef = prodData.getInstallRef(prodData.isInteractive())) == null || !installRef.toLowerCase().endsWith("install.xml") || Globals.g_srwOnly) continue;
                    this._itInstallsExist = true;
                }
            }
        }
    }

    public void setInstallProducts(ArrayList<ProductData> newValue) {
        this._installProducts = newValue;
    }

    public ArrayList<ProductData> getInstallProducts() {
        return this.getInstallProducts(false);
    }

    public ArrayList<ProductData> getInstallProducts(boolean recalculate) {
        ProductData cmtData;
        if (this._installProducts != null && !recalculate) {
            return this._installProducts;
        }
        this.setInstallProducts(new ArrayList<ProductData>());
        ProductData[] installData = new ProductData[]{};
        if (Globals.g_install) {
            if (Globals.g_sasHomeStatus.updatesRequired()) {
                int i;
                ProductData[] maintenance = Globals.g_sasHomeStatus.getRequisiteInstallSteps();
                for (i = 0; i < maintenance.length; ++i) {
                    this.getInstallProducts().add(maintenance[i]);
                }
                maintenance = Globals.g_sasHomeStatus.getRequiredMaintenanceInstallSteps();
                for (i = 0; i < maintenance.length; ++i) {
                    this.getInstallProducts().add(maintenance[i]);
                }
                maintenance = Globals.g_sasHomeStatus.getRequiredInstallSteps();
                for (i = 0; i < maintenance.length; ++i) {
                    this.getInstallProducts().add(maintenance[i]);
                }
            } else if (Globals.g_selectedInstalls != null && Globals.g_selectedInstalls.length > 0) {
                this.addRequiredProducts();
                installData = Globals.g_fullInstalls;
            }
        }
        if (Globals.g_install) {
            if (installData != null) {
                ProductData mitData;
                int i;
                boolean installingSAS = false;
                boolean installStandalone = true;
                for (i = 0; !installingSAS && i < installData.length; ++i) {
                    if (!installData[i].getProdCode().equalsIgnoreCase("sasinstall")) continue;
                    installingSAS = true;
                    if (!"9.2".equals(installData[i].getProdSASRelease()) && !"9.2".equals(installData[i].getProdVersion())) continue;
                    installStandalone = false;
                }
                for (i = 0; i < installData.length; ++i) {
                    if (!installStandalone && installData[i].getSelectableType() == 3) continue;
                    PanelExecute.addBaseline(this.getInstallProducts(), installData[i]);
                    PanelExecute.addMaintenance(this.getInstallProducts(), installData[i]);
                }
                this.addInstqualtool();
                ArrayList<ProductData> sortedProducts = this.sortProducts(this.getInstallProducts());
                this.setInstallProducts(sortedProducts);
                if (!Globals.g_zos) {
                    ProductData cmtData2;
                    if (!Globals.g_skipDMUpdate && (cmtData2 = Globals.g_deploymentData.getProduct(Globals.g_order, "cfgwizard", false)) != null) {
                        this.getInstallProducts().add(0, cmtData2);
                        Globals.g_sdmSelected = true;
                    }
                    ProductData jData = null;
                    if (Utils.getOS() != 8 && Utils.getOS() != 10 && (JREData.isPrivateJreNeeded() || !Globals.g_forceJREPrompt)) {
                        if (JREData.isJREInstalled()) {
                            if (JREData.isJRENewer()) {
                                JREData.setPrivarejreNeeded(true);
                                jData = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", JREData.getPlatform(), false);
                            }
                        } else {
                            if (Globals.g_sasinstallPlat != null) {
                                JREData.setJREData(Globals.g_sasinstallPlat, JREData.isPrivateJreNeeded());
                            }
                            if ((jData = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", JREData.getPlatform(), false)) != null && JREData.isJRENewer()) {
                                JREData.setPrivarejreNeeded(true);
                            } else {
                                jData = null;
                                JREData.setPrivarejreNeeded(false);
                            }
                        }
                    }
                    if (jData != null) {
                        this.getInstallProducts().add(0, jData);
                    } else if (Globals.g_resumeChain && (Globals.g_chainData.getProductSpsSku(0, 0).contains("privatejre") || Globals.g_chainData.getProductSpsSku(1, 0).contains("privatejre"))) {
                        this.getInstallProducts().add(0, Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", false));
                    }
                }
                List<HotFix> hotFixesToInstall = new ArrayList<HotFix>();
                if (this.hotFixPackages.loadIndex(Globals.g_order)) {
                    if (Globals.g_hotFixUpdate) {
                        Logging.log.info("User selected to force the installation of hot fixes for newly added products and/or maintenance to an existing sashome.");
                    }
                    if (this.hotFixPackages.loadPackages(Globals.g_order, Globals.g_sasHomeStatus.isEmptySASHome() || Globals.g_hotFixUpdate, Utils.GetSDWVersion())) {
                        if (this.hotFixPackages.availableHotFixes()) {
                            hotFixesToInstall = this.hotFixPackages.getHotFixesToInstall(this.getInstallProducts(), true);
                            if (this.hotFixPackages.atLeastOneHotFixNotApplicable()) {
                                this.hotFixPackages.logHotFixesNotApplicable();
                            }
                            if (this.hotFixPackages.atLeastOneHotFixAlreadyInstalled()) {
                                this.hotFixPackages.logAlreadyInstalledHotFixes();
                            }
                        } else {
                            Logging.log.info("There are no hot fixes available for the order " + Globals.g_order + " in this SAS Software Depot.");
                        }
                    } else if (!this.installHotFixes()) {
                        Logging.log.info("One or more required hot fix packages could not be loaded. However, the customer used the -nohotfix option. Deployment continuing.");
                    } else {
                        Logging.log.severe("One or more required hot fix packages could not be loaded. See warnings in log entries above. The Deployment Wizard cannot continue.");
                        if (!Globals.g_quietMode) {
                            String sdwLog = Utils.joinPath(Utils.getSDWDataPath(false), "SDW_" + Logging.getTimeStamp() + ".log");
                            CustMsgBox.showErrorMessage(this.bundle.messageString("PanelExecute.HotfixPackageError.txt", sdwLog));
                            Globals.g_kit.exitKit(-1);
                        }
                    }
                }
                String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
                SecurityUpdates securityUpdates = new SecurityUpdates(sasHome);
                try {
                    boolean result = securityUpdates.updateSecurityUpdatesInHotFixInstallChain(hotFixesToInstall);
                    if (result) {
                        Logging.log.info("Newer security updates were found in SASHome and the hot fix install chain was updated.");
                    }
                }
                catch (Exception e) {
                    Logging.log.warning("There was a problem determing if newer security updates were present in SASHome.");
                    Logging.log.warning(e.toString());
                }
                if (hotFixesToInstall.size() > 0) {
                    this.hotFixPackages.logHotFixesToInstall();
                    if (this.installHotFixes()) {
                        this.setInstallProducts(HotFixPackages.insertHotFixPackages(this.getInstallProducts(), hotFixesToInstall));
                    }
                    if (Globals.g_mode != 2 && Globals.g_install) {
                        Globals.g_hotFixesInChainWithCustomDoc = new ArrayList();
                        Globals.g_hotFixesInChainForSecurity = new ArrayList();
                        for (HotFix hotFix : hotFixesToInstall) {
                            if (this.installHotFixes() && hotFix.isiDoc()) {
                                Globals.g_hotFixesInChainWithCustomDoc.add(hotFix);
                            }
                            if (!hotFix.isSecurityFix() && !hotFix.getHotFixName().equalsIgnoreCase("W83001")) continue;
                            Globals.g_hotFixesInChainForSecurity.add(hotFix);
                        }
                    }
                } else {
                    Logging.log.info("There are no hot fixes applicable to install for the selected products.");
                }
                if ((mitData = Globals.g_deploymentData.getProduct(Globals.g_order, "installtool", false)) == null && Utils.getOS() == 8 && (installingSAS && !Globals.g_installData.getProperty("zos.install.action", "").startsWith("D") || Globals.g_sasHomeStatus.isSASUpgrade())) {
                    mitData = Globals.g_deploymentData.getProduct(Globals.g_order, "mit", false);
                }
                if (mitData != null) {
                    mitData.setProdName(this.bundle.getString("PanelExecute.PostProcess.txt"));
                    this.getInstallProducts().add(mitData);
                }
            }
        } else if (!Globals.g_zos && Globals.g_plannedInstall && !Globals.g_skipDMUpdate && (cmtData = Globals.g_deploymentData.getProduct(Globals.g_order, "cfgwizard", false)) != null) {
            this.getInstallProducts().add(0, cmtData);
            Globals.g_sdmSelected = true;
        }
        if (Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired()) {
            this.checkAMOBitness();
            this.checkEguideBitness();
            this.checkZosMapSelection();
        }
        if (Globals.g_logLevel == 1) {
            this.logSortedInstallChain(this.getInstallProducts());
        }
        return this.getInstallProducts();
    }

    private void addInstqualtool() {
        if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
            ProductData instqualtool;
            boolean addInstqualtool = true;
            for (ProductData productData : this.getInstallProducts()) {
                String productCode = productData.getProdCode();
                if (!"instqualtool".equalsIgnoreCase(productCode)) continue;
                addInstqualtool = false;
            }
            if (addInstqualtool && (instqualtool = Globals.g_deploymentData.getProduct(Globals.g_order, "instqualtool", false)) != null) {
                this.getInstallProducts().add(instqualtool);
            }
        }
    }

    private boolean installHotFixes() {
        return !Globals.g_noHotFix;
    }

    private void checkAMOBitness() {
        if (Utils.getOS_Suffix().equals("wx6")) {
            int i = 0;
            boolean logged = false;
            boolean incrementIndex = true;
            String platForAMO = null;
            while (i < this.getInstallProducts().size()) {
                incrementIndex = true;
                ProductData prodData = this.getInstallProducts().get(i);
                if (prodData.getProdCode().equalsIgnoreCase("msofficeint")) {
                    if (platForAMO == null) {
                        platForAMO = Globals.g_msofficeintPlat != null ? Globals.g_msofficeintPlat : "wx6";
                        Logging.log.info("Add-In for Micrsoft Office platform to install: " + platForAMO);
                    }
                    if (!prodData.getPlatform().equalsIgnoreCase(platForAMO)) {
                        if (!logged) {
                            Logging.log.info("Only one bitness of Add-In for Microsoft Office can be installed.  The following packages will be removed from the install chain.");
                            logged = true;
                        }
                        Logging.log.info("Removing from the install chain: " + prodData.getSpsSku());
                        this.getInstallProducts().remove(i);
                        incrementIndex = false;
                    }
                }
                if (!incrementIndex) continue;
                ++i;
            }
        }
    }

    private void checkEguideBitness() {
        if (Utils.getOS_Suffix().equals("wx6")) {
            int i = 0;
            boolean logged = false;
            boolean incrementIndex = true;
            while (i < this.getInstallProducts().size()) {
                incrementIndex = true;
                ProductData prodData = this.getInstallProducts().get(i);
                if (prodData.getProdCode().equalsIgnoreCase("eguide")) {
                    String platForEguide = "";
                    platForEguide = Globals.g_eguidePlat != null ? Globals.g_eguidePlat : "wx6";
                    Logging.log.info("Enterprise Guide platform to install: " + platForEguide);
                    if (!prodData.getPlatform().equalsIgnoreCase(platForEguide)) {
                        if (!logged) {
                            Logging.log.info("Only one bitness of Enterprise Guide can be installed with a single invocation of the SAS Deployment Wizard. The following packages will be removed from the install chain.");
                            logged = true;
                        }
                        Logging.log.info("Removing from the install chain: " + prodData.getSpsSku());
                        this.getInstallProducts().remove(i);
                        incrementIndex = false;
                    }
                }
                if (!incrementIndex) continue;
                ++i;
            }
        }
    }

    private void checkZosMapSelection() {
        if (Utils.getOS_Suffix() != "mvs" && Utils.getOS_Suffix() != "z64") {
            return;
        }
        String prefix = "zos";
        if (Globals.g_z64) {
            prefix = "z64";
        }
        int i = 0;
        while (i < this.getInstallProducts().size()) {
            ProductData prodData = this.getInstallProducts().get(i);
            if (prodData.getProdCode().equalsIgnoreCase("mapsgeo") && Globals.g_installData.getProperty(this.zosKey("%s.install.maps.cities", prefix), "TRUE").equalsIgnoreCase("false")) {
                this.getInstallProducts().remove(i);
                continue;
            }
            if (prodData.getProdCode().equalsIgnoreCase("mapsgfk") && Globals.g_installData.getProperty(this.zosKey("%s.install.maps.world", prefix), "TRUE").equalsIgnoreCase("false")) {
                this.getInstallProducts().remove(i);
                continue;
            }
            if (prodData.getProdCode().equalsIgnoreCase("mapssas") && Globals.g_installData.getProperty(this.zosKey("%s.install.maps.old", prefix), "TRUE").equalsIgnoreCase("false")) {
                this.getInstallProducts().remove(i);
                continue;
            }
            ++i;
        }
    }

    private String zosKey(String keyTemplate, String prefix) {
        return String.format(keyTemplate, prefix);
    }

    private ArrayList<ProductData> sortProducts(ArrayList<ProductData> productList) {
        ArrayList<ProductData> sortedList = new ArrayList<ProductData>(productList.size());
        int productIndex = 0;
        for (ProductData productData : productList) {
            boolean foundProduct = false;
            boolean foundPlatform = false;
            int requiredSlot = -1;
            int sequenceSlot = -1;
            int productMaint = Integer.parseInt(productData.getProdMaint());
            SpsSkuData spsSkuData = productData.getType() == 4 ? ((HotFix)productData).getSpsSkuData() : Globals.g_deploymentData.getSpsSku(productData.getSpsSku());
            ProductData lastSortedData = null;
            int sortedIndex = 0;
            for (ProductData sortedData : sortedList) {
                SpsSkuData spsSortedSkuData = sortedData.getType() == 4 ? ((HotFix)sortedData).getSpsSkuData() : Globals.g_deploymentData.getSpsSku(sortedData.getSpsSku());
                if (sortedIndex >= productIndex) {
                    requiredSlot = sortedIndex;
                    break;
                }
                if (!foundProduct && productData.getProdCode().equals(sortedData.getProdCode())) {
                    sequenceSlot = -1;
                    foundProduct = true;
                }
                if (foundProduct) {
                    if (!productData.getProdCode().equals(sortedData.getProdCode())) {
                        if (sequenceSlot >= 0) {
                            requiredSlot = sequenceSlot;
                            break;
                        }
                        requiredSlot = sortedIndex;
                        break;
                    }
                    if (!foundPlatform && productData.getPlatform().equals(sortedData.getPlatform())) {
                        foundPlatform = true;
                    }
                    if (foundPlatform) {
                        if (!productData.getPlatform().equals(sortedData.getPlatform())) {
                            requiredSlot = sortedIndex;
                            break;
                        }
                        int sortedMaint = Integer.parseInt(sortedData.getProdMaint());
                        if (productMaint < sortedMaint) {
                            requiredSlot = sortedIndex;
                            break;
                        }
                        if (productMaint == sortedMaint) {
                            if (spsSkuData.getLanguage().equals(spsSortedSkuData.getLanguage())) {
                                if (productData.getType() != 4) {
                                    requiredSlot = sortedIndex;
                                    break;
                                }
                            } else {
                                if (spsSkuData.isStandardLanguage()) {
                                    requiredSlot = sortedIndex;
                                    break;
                                }
                                if (!spsSortedSkuData.isStandardLanguage() && productData.getSequenceNum() < sortedData.getSequenceNum()) {
                                    requiredSlot = sortedIndex;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!(sequenceSlot >= 0 || lastSortedData != null && sortedData.getProdCode().equals(lastSortedData.getProdCode()) && (!foundProduct || sortedData.getPlatform().equals(lastSortedData.getPlatform())) || foundPlatform && spsSortedSkuData.isStandardLanguage() || productData.getSequenceNum() >= sortedData.getSequenceNum())) {
                    sequenceSlot = sortedIndex;
                }
                lastSortedData = sortedData;
                ++sortedIndex;
            }
            if (requiredSlot >= 0) {
                sortedList.add(requiredSlot, productData);
            } else if (sequenceSlot >= 0) {
                sortedList.add(sequenceSlot, productData);
            } else {
                sortedList.add(sortedIndex, productData);
            }
            ++productIndex;
        }
        return sortedList;
    }

    private void logSortedInstallChain(ArrayList<ProductData> sortedInstallChain) {
        StringBuffer productEntries = new StringBuffer();
        productEntries.append("Below is the sorted install chain:");
        productEntries.append(Globals.g_eol);
        productEntries.append("altsku");
        productEntries.append(", ");
        productEntries.append("product code");
        productEntries.append(", ");
        productEntries.append("platform");
        productEntries.append(", ");
        productEntries.append("maintenance level");
        productEntries.append(", ");
        productEntries.append("language");
        productEntries.append(", ");
        productEntries.append("install type");
        productEntries.append(", ");
        productEntries.append("sequence number");
        productEntries.append(Globals.g_eol);
        for (ProductData productData : sortedInstallChain) {
            SpsSkuData spsSkuData = productData.getType() == 4 ? ((HotFix)productData).getSpsSkuData() : Globals.g_deploymentData.getSpsSku(productData.getSpsSku());
            productEntries.append(productData.getSpsSku());
            productEntries.append(", ");
            productEntries.append(productData.getProdCode());
            productEntries.append(", ");
            productEntries.append(productData.getPlatform());
            productEntries.append(", ");
            productEntries.append(productData.getProdMaint());
            productEntries.append(", ");
            productEntries.append(spsSkuData.getLanguage());
            productEntries.append(", ");
            String type = "";
            switch (productData.getType()) {
                case 0: {
                    type = "sysreq";
                    break;
                }
                case 1: {
                    type = "deploy";
                    break;
                }
                case 2: {
                    type = "config";
                    break;
                }
                case 3: {
                    type = "uninstall";
                    break;
                }
                case 4: {
                    type = "hotfix";
                    break;
                }
                default: {
                    type = "unknown";
                }
            }
            productEntries.append(type);
            productEntries.append(", ");
            productEntries.append(productData.getSequenceNum());
            productEntries.append(Globals.g_eol);
        }
        Logging.log.info(productEntries.toString());
    }

    private void addRequiredProducts() {
        ProductData requiredProductData;
        SpsSkuData requiredSpsSkuData;
        String[] requiredAltSkus;
        Hashtable<String, ProductData> selectedInstallsHash = new Hashtable<String, ProductData>();
        HashSet<String> selectedMVAProductsHash = new HashSet<String>();
        HashSet<String> selectedMVAAltSkusHash = new HashSet<String>();
        boolean installingSAS = false;
        boolean emptyMVAList = false;
        String basePlatform = null;
        if (Globals.g_selectedInstalls != null) {
            for (int i = 0; i < Globals.g_selectedInstalls.length; ++i) {
                ProductData productData = Globals.g_selectedInstalls[i];
                selectedInstallsHash.put(productData.getProdCode() + ":" + productData.getPlatform(), productData);
                if (!"sasinstall".equals(productData.getProdCode())) continue;
                installingSAS = true;
            }
        }
        if (installingSAS) {
            basePlatform = Globals.g_sasinstallPlat == null ? Utils.getOS_Suffix() : Globals.g_sasinstallPlat;
        }
        if (Globals.g_selectedMVAAltSkus == null) {
            String[] mvaAltSkus;
            emptyMVAList = true;
            if (installingSAS && (mvaAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(basePlatform)) != null) {
                selectedMVAAltSkusHash.addAll(Arrays.asList(mvaAltSkus));
            }
        } else {
            selectedMVAProductsHash.addAll(Globals.g_selectedMVAProducts);
            selectedMVAAltSkusHash.addAll(Arrays.asList(Globals.g_selectedMVAAltSkus));
        }
        String[] selectedMVAProductAltSkus = selectedMVAAltSkusHash.toArray(new String[0]);
        for (int i = 0; i < selectedMVAProductAltSkus.length; ++i) {
            SpsSkuData selectedSpsSkuData = Globals.g_deploymentData.getSpsSku(selectedMVAProductAltSkus[i]);
            String platform = Utils.getOS_Suffix();
            if (Globals.g_sasinstallPlat != null) {
                platform = Globals.g_sasinstallPlat;
            }
            requiredAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("triggers_install", selectedSpsSkuData.getSpsSku(), platform);
            for (int j = 0; j < requiredAltSkus.length; ++j) {
                requiredSpsSkuData = Globals.g_deploymentData.getSpsSku(requiredAltSkus[j]);
                String installPlatform = basePlatform != null && requiredSpsSkuData.isTargetByBaseHost() ? requiredSpsSkuData.platformToDeploy(basePlatform) : requiredSpsSkuData.platformToDeploy(Utils.getOS_Suffix());
                if (installPlatform == null) continue;
                if (!"javaruntime".equalsIgnoreCase(requiredSpsSkuData.getProdCode()) && !"privatejre".equalsIgnoreCase(requiredSpsSkuData.getProdCode())) {
                    if (requiredSpsSkuData.getSku(installPlatform) != null && requiredSpsSkuData.getSku(installPlatform).isInstallable() && "true".equalsIgnoreCase(requiredSpsSkuData.getSku(installPlatform).getMiscValue("is_foundation"))) {
                        selectedMVAProductsHash.add(requiredSpsSkuData.getProdCode());
                        selectedMVAAltSkusHash.add(requiredSpsSkuData.getSpsSku());
                        continue;
                    }
                    if (requiredSpsSkuData.getSku(installPlatform) == null || !requiredSpsSkuData.getSku(installPlatform).isInstallable()) continue;
                    requiredProductData = requiredSpsSkuData.getIndb() ? Globals.g_deploymentData.getIndbProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, requiredSpsSkuData.getPlatform(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, false);
                    if (requiredProductData == null) {
                        Logging.log.fine("(1) While chasing the dependencies for product " + selectedSpsSkuData.getSpsSku() + ", the following required product is missing from the order: " + requiredSpsSkuData.getSpsSku());
                        continue;
                    }
                    if (selectedInstallsHash.containsKey(requiredSpsSkuData.getProdCode() + ":" + requiredProductData.getPlatform())) continue;
                    String key = requiredProductData.getProdCode() + ":" + requiredProductData.getPlatform();
                    selectedInstallsHash.put(key, requiredProductData);
                    continue;
                }
                if (!"privatejre".equalsIgnoreCase(requiredSpsSkuData.getProdCode())) continue;
                JREData.setPrivarejreNeeded(true);
                Logging.log.fine("MVA: adding privatejre");
            }
        }
        ProductData[] selectedVerticalProducts = Globals.g_selectedInstalls;
        boolean isWebinfdsvrSelected = false;
        for (int i = 0; i < selectedVerticalProducts.length; ++i) {
            if ("webinfdsvr".equalsIgnoreCase(selectedVerticalProducts[i].getProdCode())) {
                isWebinfdsvrSelected = true;
            }
            if ("sasinstall".equalsIgnoreCase(selectedVerticalProducts[i].getProdCode())) continue;
            requiredAltSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("triggers_install", selectedVerticalProducts[i].getSpsSku(), selectedVerticalProducts[i].getPlatform());
            for (int j = 0; j < requiredAltSkus.length; ++j) {
                String installPlatform;
                requiredSpsSkuData = Globals.g_deploymentData.getSpsSku(requiredAltSkus[j]);
                if (requiredSpsSkuData.getProdCode().equalsIgnoreCase("certframe") && Globals.g_deploymentData.getOrder(Globals.g_order).isWeb() && Globals.g_sasHomeStatus != null || (installPlatform = basePlatform != null && requiredSpsSkuData.isTargetByBaseHost() ? requiredSpsSkuData.platformToDeploy(basePlatform) : requiredSpsSkuData.platformToDeploy(Utils.getOS_Suffix())) == null) continue;
                if (!"javaruntime".equalsIgnoreCase(requiredSpsSkuData.getProdCode()) && !"privatejre".equalsIgnoreCase(requiredSpsSkuData.getProdCode())) {
                    String key;
                    if (Globals.g_sasinstallPlat == null) {
                        if (requiredSpsSkuData.getSku(installPlatform) == null || !requiredSpsSkuData.getSku(installPlatform).isInstallable()) continue;
                        if ("true".equalsIgnoreCase(requiredSpsSkuData.getSku(installPlatform).getMiscValue("is_foundation"))) {
                            selectedMVAProductsHash.add(requiredSpsSkuData.getProdCode());
                            selectedMVAAltSkusHash.add(requiredSpsSkuData.getSpsSku());
                            continue;
                        }
                        if (Utils.getOS_Suffix().equals("lax") && (requiredSpsSkuData.getSku("lax") == null || !requiredSpsSkuData.getSku("lax").isInstallable())) continue;
                        requiredProductData = requiredSpsSkuData.getIndb() ? Globals.g_deploymentData.getIndbProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, requiredSpsSkuData.getPlatform(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, false);
                        if (requiredProductData == null) {
                            Logging.log.fine("(2) While chasing the dependencies for product " + selectedVerticalProducts[i].getSpsSku() + ", the following required product is missing from the order: " + requiredSpsSkuData.getSpsSku());
                            continue;
                        }
                        if (selectedInstallsHash.containsKey(requiredSpsSkuData.getProdCode() + ":" + requiredProductData.getPlatform())) continue;
                        key = requiredProductData.getProdCode() + ":" + requiredProductData.getPlatform();
                        selectedInstallsHash.put(key, requiredProductData);
                        continue;
                    }
                    if (requiredSpsSkuData.getSku(Globals.g_sasinstallPlat) != null && requiredSpsSkuData.getSku(Globals.g_sasinstallPlat).isInstallable()) {
                        if ("true".equalsIgnoreCase(requiredSpsSkuData.getSku(Globals.g_sasinstallPlat).getMiscValue("is_foundation"))) {
                            selectedMVAProductsHash.add(requiredSpsSkuData.getProdCode());
                            selectedMVAAltSkusHash.add(requiredSpsSkuData.getSpsSku());
                            continue;
                        }
                        if (requiredSpsSkuData.getSku(installPlatform) == null || !requiredSpsSkuData.getSku(installPlatform).isInstallable() || Utils.getOS_Suffix().equals("lax") && (requiredSpsSkuData.getSku("lax") == null || !requiredSpsSkuData.getSku("lax").isInstallable())) continue;
                        requiredProductData = requiredSpsSkuData.getIndb() ? Globals.g_deploymentData.getIndbProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, requiredSpsSkuData.getPlatform(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, false);
                        if (requiredProductData == null) {
                            Logging.log.fine("(3) While chasing the dependencies for product " + selectedVerticalProducts[i].getSpsSku() + ", the following required product is missing from the order: " + requiredSpsSkuData.getSpsSku());
                        }
                        if (selectedInstallsHash.containsKey(requiredSpsSkuData.getProdCode() + ":" + requiredProductData.getPlatform())) continue;
                        key = requiredProductData.getProdCode() + ":" + requiredProductData.getPlatform();
                        selectedInstallsHash.put(key, requiredProductData);
                        continue;
                    }
                    if (requiredSpsSkuData.getSku(installPlatform) == null || !requiredSpsSkuData.getSku(installPlatform).isInstallable()) continue;
                    if ("true".equalsIgnoreCase(requiredSpsSkuData.getSku(installPlatform).getMiscValue("is_foundation"))) {
                        selectedMVAProductsHash.add(requiredSpsSkuData.getProdCode());
                        selectedMVAAltSkusHash.add(requiredSpsSkuData.getSpsSku());
                        continue;
                    }
                    if (Utils.getOS_Suffix().equals("lax") && (requiredSpsSkuData.getSku("lax") == null || !requiredSpsSkuData.getSku("lax").isInstallable())) continue;
                    requiredProductData = requiredSpsSkuData.getIndb() ? Globals.g_deploymentData.getIndbProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, requiredSpsSkuData.getPlatform(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, requiredSpsSkuData.getProdCode(), installPlatform, false);
                    if (requiredProductData == null) {
                        Logging.log.fine("(4) While chasing the dependencies for product " + selectedVerticalProducts[i].getSpsSku() + ", the following required product is missing from the order: " + requiredSpsSkuData.getSpsSku());
                    }
                    if (selectedInstallsHash.containsKey(requiredSpsSkuData.getProdCode() + ":" + requiredProductData.getPlatform())) continue;
                    key = requiredProductData.getProdCode() + ":" + requiredProductData.getPlatform();
                    selectedInstallsHash.put(key, requiredProductData);
                    continue;
                }
                if (!"privatejre".equalsIgnoreCase(requiredSpsSkuData.getProdCode())) continue;
                JREData.setPrivarejreNeeded(true);
                Logging.log.info("Vertical: adding privatejre");
            }
        }
        String webinfdsvrKey = null;
        for (String key : selectedInstallsHash.keySet()) {
            String productCode = ((ProductData)selectedInstallsHash.get(key)).getProdCode();
            if (productCode == null || !productCode.equalsIgnoreCase("webinfdsvr")) continue;
            webinfdsvrKey = key;
        }
        if (webinfdsvrKey != null) {
            String productName = ((ProductData)selectedInstallsHash.get(webinfdsvrKey)).getProdName();
            if (Globals.g_sasHomeStatus.isWebinfdsvrRemovedFromUpdateChain()) {
                String msg;
                if (!isWebinfdsvrSelected) {
                    selectedInstallsHash.remove(webinfdsvrKey);
                    msg = String.format("%s is already installed and will not be installed again during an update or when adding products unless it is specifically selected. This will avoid inadvertently upgrading the PostgreSQL server without performing the steps necessary to upgrade the associated data servers. ", productName);
                    Logging.log.info(msg);
                } else {
                    msg = String.format("%s was manually selected and will be installed.", productName);
                    Logging.log.info(msg);
                }
            }
        }
        Globals.g_fullInstalls = selectedInstallsHash.values().toArray(new ProductData[0]);
        if (!emptyMVAList) {
            Globals.g_fullMVAProducts.clear();
            Globals.g_fullMVAProducts.addAll(selectedMVAProductsHash);
            Globals.g_fullMVAAltSkus = selectedMVAAltSkusHash.toArray(new String[0]);
        }
    }

    private static void addBaseline(ArrayList<ProductData> installProducts, ProductData installData) {
        String platform = installData.getPlatform();
        SpsSkuData installDataSku = Globals.g_deploymentData.getSpsSku(installData.getSpsSku());
        HashSet<String> languages = new HashSet<String>();
        languages.add("xx");
        languages.add("en");
        StringTokenizer st = new StringTokenizer(Globals.g_selectedLanguages, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            languages.add(st.nextToken());
            ++i;
        }
        if (!installData.getProdCode().equalsIgnoreCase("sasinstall")) {
            if (installDataSku.getIndb()) {
                installProducts.add(installData);
            } else {
                ProductData[] productArray = Globals.g_deploymentData.getProductArray(Globals.g_order, installData.getProdCode(), platform, false);
                for (int i2 = 0; i2 < productArray.length; ++i2) {
                    if (productArray[i2].getChainingRef(false).length() <= 0) continue;
                    SpsSkuData spsSku = Globals.g_deploymentData.getSpsSku(productArray[i2].getSpsSku());
                    if (!"mvs".equals(platform) && !"z64".equals(platform) && !languages.contains(spsSku.getLanguage()) || spsSku.getIndb()) continue;
                    installProducts.add(productArray[i2]);
                }
            }
        } else {
            String[] mvaAltSkus = Globals.g_fullMVAAltSkus;
            if (mvaAltSkus == null) {
                Vector<String> allMVAAltSkus = new Vector<String>();
                Vector<String> stdMVAAltSkus = new Vector<String>();
                allMVAAltSkus.addAll(Arrays.asList(Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(platform)));
                for (String spsSku : allMVAAltSkus) {
                    if (!Globals.g_deploymentData.getSpsSku(spsSku).isStandardLanguage()) continue;
                    stdMVAAltSkus.add(spsSku);
                }
                mvaAltSkus = stdMVAAltSkus.toArray(new String[0]);
            }
            HashSet<String> skuSet = new HashSet<String>();
            for (int i3 = 0; i3 < mvaAltSkus.length; ++i3) {
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(mvaAltSkus[i3]);
                ProductData[] productArray = Globals.g_deploymentData.getProductArray(Globals.g_order, spsSkuData.getProdCode(), platform, false);
                for (int j = 0; j < productArray.length; ++j) {
                    if (productArray[j].getChainingRef(false).length() <= 0) continue;
                    String spsSku = productArray[j].getSpsSku();
                    spsSkuData = Globals.g_deploymentData.getSpsSku(spsSku);
                    if (!"mvs".equals(platform) && !"z64".equals(platform) && !languages.contains(spsSkuData.getLanguage())) continue;
                    if (skuSet.contains(spsSku)) {
                        if (Globals.g_logLevel != 2) continue;
                        Logging.log.info("Attempting to add a duplicate SAS Foundation sku, skipping sku: " + spsSku);
                        continue;
                    }
                    installProducts.add(productArray[j]);
                    skuSet.add(spsSku);
                }
            }
        }
    }

    private static void addMaintenance(ArrayList installProducts, ProductData installData) {
        String platform = installData.getPlatform();
        HashSet<String> languages = new HashSet<String>();
        languages.add("xx");
        languages.add("en");
        StringTokenizer st = new StringTokenizer(Globals.g_selectedLanguages, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            languages.add(st.nextToken());
            ++i;
        }
        if (!installData.getProdCode().equalsIgnoreCase("sasinstall")) {
            ProductData[] maintDataList = Globals.g_deploymentData.getSpsSku(installData.getSpsSku()).getIndb() ? Globals.g_deploymentData.getIndbMaintenance(Globals.g_order, installData.getProdCode(), Utils.getOS_Suffix(), platform, false) : Globals.g_deploymentData.getMaintenance(Globals.g_order, installData.getProdCode(), platform, false);
            for (int i2 = 0; i2 < maintDataList.length; ++i2) {
                if (maintDataList[i2].getChainingRef(false).length() <= 0) continue;
                SpsSkuData spsSku = Globals.g_deploymentData.getSpsSku(maintDataList[i2].getSpsSku());
                if (!"mvs".equals(platform) && !"z64".equals(platform) && !languages.contains(spsSku.getLanguage()) || !spsSku.isMaintLevelGreaterThanZero() || !spsSku.isDeltaRelease()) continue;
                installProducts.add(maintDataList[i2]);
            }
        } else {
            String[] mvaAltSkus = Globals.g_fullMVAAltSkus;
            if (mvaAltSkus == null) {
                Vector<String> allMVAAltSkus = new Vector<String>();
                Vector<String> stdMVAAltSkus = new Vector<String>();
                allMVAAltSkus.addAll(Arrays.asList(Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(platform)));
                for (String spsSku : allMVAAltSkus) {
                    String language = Globals.g_deploymentData.getSpsSku(spsSku).getLanguage();
                    if (!"en".equals(language) && !"ne".equals(language)) continue;
                    stdMVAAltSkus.add(spsSku);
                }
                mvaAltSkus = stdMVAAltSkus.toArray(new String[0]);
            }
            SpsSkuData mvaData = null;
            ProductData maintData = null;
            HashSet<String> skuSet = new HashSet<String>();
            for (int i3 = 0; i3 < mvaAltSkus.length; ++i3) {
                SpsSkuData spsSkuData;
                String spsSku;
                mvaData = Globals.g_deploymentData.getSpsSku(mvaAltSkus[i3]);
                if ("mvs".equals(platform) || "z64".equals(platform)) {
                    ProductData[] maintDataList = Globals.g_deploymentData.getMaintenance(Globals.g_order, mvaData.getProdCode(), platform, false);
                    for (int j = 0; j < maintDataList.length; ++j) {
                        if (maintDataList[j].getChainingRef(false).length() <= 0) continue;
                        spsSku = maintDataList[j].getSpsSku();
                        if (skuSet.contains(spsSku)) {
                            if (Globals.g_logLevel != 2) continue;
                            Logging.log.info("Attempting to add a duplicate SAS Foundation maintenance sku, skipping sku: " + spsSku);
                            continue;
                        }
                        spsSkuData = Globals.g_deploymentData.getSpsSku(spsSku);
                        if (!spsSkuData.isMaintLevelGreaterThanZero() || !spsSkuData.isDeltaRelease()) continue;
                        installProducts.add(maintDataList[j]);
                        skuSet.add(spsSku);
                    }
                    continue;
                }
                for (String language : languages) {
                    maintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, mvaData.getProdCode(), platform, language, false);
                    if (maintData == null || maintData.getChainingRef(false).length() <= 0) continue;
                    spsSku = maintData.getSpsSku();
                    if (skuSet.contains(spsSku)) {
                        if (Globals.g_logLevel != 2) continue;
                        Logging.log.info("Attempting to add a duplicate SAS Foundation language maintenance sku, skipping sku: " + spsSku);
                        continue;
                    }
                    spsSkuData = Globals.g_deploymentData.getSpsSku(spsSku);
                    if (!spsSkuData.isMaintLevelGreaterThanZero() || !spsSkuData.isDeltaRelease()) continue;
                    installProducts.add(maintData);
                    skuSet.add(spsSku);
                }
            }
        }
    }

    public void backEvent() {
    }

    protected boolean isExecutionInProgress() {
        return this._executionInProgress;
    }

    protected void setExecutionInProgress(boolean executionInProgress) {
        this._executionInProgress = executionInProgress;
    }

    public boolean onCancel() {
        return false;
    }

    @Override
    public void bytesMoved(long numBytes) {
        this._totalBytesMoved += numBytes;
        this.progressBar.setValue((int)(this._totalBytesMoved / 0x100000L));
        this.progressBar.setString((int)(this.progressBar.getPercentComplete() * 100.0) + "%");
        this.progressBar.repaint();
        this._overallBytesMoved += numBytes;
        this.overallProgressBar.setValue((int)(this._overallBytesMoved / 0x100000L));
        this.overallProgressBar.setString((int)(this.overallProgressBar.getPercentComplete() * 100.0) + "%");
        this.overallProgressBar.repaint();
        if (this._overallBytesMoved / 0x100000L == (long)this.overallProgressBar.getMaximum()) {
            this.hideOverallProgress();
        }
    }

    public void hideOverallProgress() {
        this.overallProgressBar.setVisible(false);
        this.currentTaskLabel.setVisible(false);
        this.overallProgressLabel.setVisible(false);
    }

    @Override
    public void installCompletedAction() {
    }

    @Override
    public void installStartedAction() {
        if (this.statusTimer != null) {
            this.statusTimer.stop();
        }
        this.progressBar.setValue(0);
        this.progressBar.repaint();
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
        if (!this.statusTimer.isRunning() || !this._busyPrefix.startsWith(this.bundle.getString("PanelExecute.UpdatingFiles.txt"))) {
            this._busyPrefix = this.bundle.getString("PanelExecute.UpdatingFiles.txt");
            this.updateBusyIndicator(false);
            this.startStatusTimer();
        }
    }

    @Override
    public void progressBeginningAction(String description) {
        if (this.m_showJobs && !Globals.g_consoleMode) {
            this.m_installStatus.setText(description);
            return;
        }
        if (!this.statusTimer.isRunning() || !this._busyPrefix.startsWith(this.bundle.getString("PanelExecute.ProcessInstalledFiles.txt"))) {
            this._busyPrefix = this.bundle.getString("PanelExecute.ProcessInstalledFiles.txt");
            this.updateBusyIndicator(false);
            this.startStatusTimer();
        }
    }

    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
    }

    @Override
    public void progressCompleteAction(String description) {
        if (this.m_showJobs && !Globals.g_consoleMode) {
            this.m_installStatus.setText(description);
        }
    }

    public String htmlify(String message) {
        if (message.length() > 500) {
            message = message.substring(0, 500) + "...";
        }
        return "<html><p>" + message + "</html></p>";
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
        if (!(task instanceof ExtractTask || this.statusTimer.isRunning() && this._busyPrefix.startsWith("Processing Installed Files"))) {
            this._busyPrefix = "Processing Installed Files";
            this.updateBusyIndicator(false);
            this.startStatusTimer();
        }
    }

    public void updateBusyIndicator(boolean updateEllipses) {
        if (updateEllipses) {
            ++this._ellipsisCount;
            if (this._ellipsisCount == 1) {
                this._ellipsis = ".";
            } else if (this._ellipsisCount == 2) {
                this._ellipsis = "..";
            } else {
                this._ellipsisCount = 0;
                this._ellipsis = "...";
            }
        }
        this.currentTaskLabel.setText(this._busyPrefix + this._ellipsis);
    }

    public void startStatusTimer() {
        if (!this.statusTimer.isRunning()) {
            this.statusTimer.start();
        }
    }

    @Override
    public void allRollbackCompleteAction() {
    }

    @Override
    public void rollbackBytesMoved(long numBytes) {
        this._totalBytesMoved -= numBytes;
        this.progressBar.setValue((int)(this._totalBytesMoved / 0x100000L));
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        this.progressBar.setString(formatter.format(this.progressBar.getValue()) + " / " + formatter.format(this.progressBar.getMaximum()) + " MB");
        this._overallBytesMoved -= numBytes;
        this.overallProgressBar.setValue((int)(this._overallBytesMoved / 0x100000L));
        this.overallProgressBar.setString(formatter.format(this.overallProgressBar.getValue()) + " / " + formatter.format(this.overallProgressBar.getMaximum()) + " MB");
    }

    @Override
    public void rollbackFailure(String description) {
    }

    @Override
    public void rollbackProgressBeginningAction(String action, EntryData metaData) {
        if (!this.statusTimer.isRunning()) {
            this._busyPrefix = "Restoring Files";
            this.updateBusyIndicator(false);
            this.startStatusTimer();
        }
    }

    @Override
    public void rollbackProgressBeginningAction(String description) {
    }

    @Override
    public void rollbackProgressCompleteAction(String action, EntryData metaData) {
    }

    @Override
    public void rollbackProgressCompleteAction(String description) {
    }

    @Override
    public void allRollbackComplete() {
        this.progressBar.setValue(0);
        this.progressBar.setString("Rollback Complete");
        this.currentTaskLabel.setText(" ");
        Globals.g_wizard.exitWizard(Globals.g_wizard.getReturnCode());
        this.statusTimer.stop();
    }

    @Override
    public void beginInstallAtIndex(int index) {
    }

    @Override
    public void beginRollbackAtIndex(int index) {
    }

    @Override
    public void buildFinished() {
        this.hideOverallProgress();
        this.setExecutionInProgress(false);
        this.statusTimer.stop();
    }

    public HashMap<String, Long> getCheckedSizes() {
        return this._checkedSizes;
    }

    public void setCheckedSizes(HashMap<String, Long> sizes) {
        this._checkedSizes = sizes;
    }

    public long getTotalBytesMoved() {
        return this._totalBytesMoved;
    }

    public long getOverallBytesMoved() {
        return this._overallBytesMoved;
    }

    public long getOverallBytes() {
        return this._overallBytes;
    }

    public void setOverallBytes(long overallBytes) {
        this._overallBytes = overallBytes;
    }

    public void setWarning(boolean warning) {
        this.m_warning = warning;
    }

    @Override
    public void rebootAction(String description) {
        Logging.log.info(description);
        this.m_reboot = true;
    }

    public void reboot() {
        if (this.m_reboot && !Globals.g_noreboot) {
            String initValue;
            Reboot myreboot = new Reboot();
            String eachstepValue = initValue = myreboot.getRebootPendingValue();
            if (!Globals.g_quietMode) {
                if (Globals.g_srwOnly) {
                    JOptionPane.showMessageDialog(Globals.g_wizard.getFrame(), this.bundle.getString("PanelExecute.Reboot.txt"), this.bundle.getString("Common.Title.txt"), -1);
                } else {
                    DlgAutoLogon dlg = new DlgAutoLogon(Globals.g_wizard.getFrame());
                    boolean flag = dlg.loadResponseData();
                    if (!flag) {
                        dlg.setVisible(true);
                        if (dlg.allowed()) {
                            myreboot.setRestartSDW();
                            Globals.g_wizard.setReturnCode(9999);
                            this.m_installChain.setAbort(true);
                        } else if (dlg.exited()) {
                            Globals.g_kit.exitKit(-9999);
                        } else {
                            initValue = eachstepValue;
                            this.m_reboot = false;
                            Logging.log.fine("User cancelled option to reboot.");
                        }
                    } else {
                        myreboot.setRestartSDW();
                        myreboot.setUserInfo(dlg.getDomainName(), dlg.getUserName(), dlg.getDecodedPassword());
                        Globals.g_wizard.setReturnCode(9999);
                        this.m_installChain.setAbort(true);
                    }
                }
            } else if (Globals.g_srwOnly) {
                Logging.log.info(this.bundle.getString("PanelExecute.Reboot.txt"));
            } else {
                myreboot.setRestartSDW();
                if (DlgAutoLogon.loadResponseData()) {
                    myreboot.setUserInfo(DlgAutoLogon.m_domainNameValue, DlgAutoLogon.m_userNameValue, DlgAutoLogon.m_passwordValue);
                } else {
                    myreboot.setUserInfo(Globals.g_restartDomain, Globals.g_restartUserID, Globals.g_restartPassword);
                }
                Globals.g_wizard.setReturnCode(9999);
                this.m_installChain.setAbort(true);
            }
        }
    }

    @Override
    public void setupAction(String action, EntryData metaData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupAction(String description) {
        if (Thread.currentThread() instanceof ExecutionThread) {
            ExecutionThread thread = (ExecutionThread)Thread.currentThread();
            if (thread == null) {
                return;
            }
            String prodCode = thread.getController().getProperty("12ByteCode");
            String matchstr = "sysReq." + prodCode;
            if (!description.startsWith(matchstr)) {
                for (ProductData productData : Globals.g_selectedSRWs) {
                    Object object = this.obj;
                    synchronized (object) {
                        if (productData.getProdCode().compareToIgnoreCase(prodCode) == 0) {
                            this.bf.addCommandLines(description, productData);
                        }
                    }
                }
            }
        }
    }
}

