/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DepotManager;
import com.sas.ssn.Globals;
import com.sas.ssn.HotfixData;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelDestination
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelDestination.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private KitTextField m_destination = null;
    private KitBrowseButton m_browseButton = null;
    private JLabel m_depotLabel = null;
    private JCheckBox m_depotCompressionOption = null;
    private JTextArea m_depotCompressionInfo = null;
    private boolean m_panelLoaded = false;
    private boolean m_depotCompressionPromptActive = false;
    private final long LAST_PORT_DATE_DEPLOYWIZ_15W29 = 1435118400000L;

    public PanelDestination() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        if (Globals.g_mode == 1) {
            return this.bundle.getString("PanelDestination.HeaderESD.txt");
        }
        return this.bundle.getString("PanelDestination.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_mode == 6) {
            return this.bundle.getString("PanelDestination.HeaderDescDCU.txt");
        }
        if (Globals.g_mode == 1) {
            return this.bundle.getString("PanelDestination.HeaderDescESD.txt");
        }
        return this.bundle.getString("PanelDestination.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String destDir = Utils.trimTrailingSlashes(this.m_destination.getText());
        this.m_destination.setText(destDir);
        if (this.m_depotCompressionPromptActive) {
            if (this.m_depotCompressionOption.isSelected()) {
                Globals.g_depotCompressionAfterDownload = true;
                if (Globals.g_control != null) {
                    Globals.g_control.setDepotCompression(true);
                }
                Logging.log.info("Depot Compression selected.");
            } else {
                Globals.g_depotCompressionAfterDownload = false;
                if (Globals.g_control != null) {
                    Globals.g_control.setDepotCompression(false);
                }
                Logging.log.info("Depot Compression not selected.");
            }
        }
        if (destDir.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "DESTINATION_DEPOT");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelDestination.FieldName.txt"));
            }
        }
        if (valid) {
            if (Utils.getOS() == 6) {
                destDir = Utils.VMSToUnixPath(destDir);
            }
            if (Utils.pathContainsValidChars(destDir)) {
                valid = Utils.validatePath(destDir);
                if (!valid) {
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, null);
                    } else {
                        errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelDestination.FieldName.txt"));
                    }
                }
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    String quietMsg = null;
                    quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                    Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, quietMsg);
                } else {
                    errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelDestination.FieldName.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelDestination.FieldName.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelDestination.FieldName.txt")));
                }
            }
        }
        Globals.g_newDir = null;
        File destDirFile = new File(destDir);
        if (!Globals.g_quietMode && valid && !destDirFile.exists()) {
            if (Globals.g_mode == 6) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "Can not create a depot if we need to check it.");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelDepotChecker.Problem.BadDepot.txt", destDirFile), Globals.g_wizard.getWizardTitle(), 0);
                }
            } else {
                switch (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.CreateDirectory.txt"), this.bundle.getString("Common.options.txt"), 0, 3)) {
                    case 0: {
                        valid = true;
                        Globals.g_newDir = destDirFile;
                        break;
                    }
                    case 1: {
                        valid = false;
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
            }
        }
        if (valid && Globals.g_mode == 6) {
            Globals.g_ssdDestDir = destDir;
            return valid;
        }
        if (Globals.g_consoleMode) {
            ConsoleMode.busyMsgStart("");
        }
        if (valid) {
            Globals.g_depotManager = new DepotManager(destDir);
            if (Globals.g_mode != 1 && destDirFile.isDirectory() && Globals.g_depotManager.existingDepot() && Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive() && Utils.isEqualPaths(Globals.g_depotManager.getDepotData().getMediaRoot(), destDir)) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "A depot cannot contain orders that are subsets of orders already in the depot.");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.SubsetToSameDepot.txt"), this.bundle.getString("Common.Error.txt"), 0);
                }
            }
        }
        if (valid && destDirFile.isDirectory()) {
            if (Globals.g_depotManager.existingDepot()) {
                if (Globals.g_ssdType != 0) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "The order you are attempting to add can not be included in an existing SAS Software Depot.");
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.StandAloneOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                } else if (Globals.g_depotManager.containsOrder(Globals.g_order) && Globals.g_depotManager.getDepotType() == 0) {
                    if (!Globals.g_quietMode) {
                        valid = !this.confirmPrompt(this.bundle.getString("PanelDestination.ExistingDepotMsg.txt"));
                    }
                } else if (Globals.g_deploymentData.getOrder(Globals.g_order).isStandAlone()) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "The order you are attempting to add can not be included in an existing SAS Software Depot.");
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.StandAloneOrder.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                } else if (Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() != Globals.g_depotManager.getDepotVersion()) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "The order you are attempting to add is a different version than that of the specified SAS Software Depot.");
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.VersionMismatch.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                } else if (!Globals.g_depotManager.allowMoreOrders()) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "The specified directory contains an existing SAS Software Depot which disallows additional orders.");
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.NoOrdersAllowed.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                } else if (!Globals.g_quietMode) {
                    valid = !this.confirmPrompt(this.bundle.getString("PanelDestination.ExistingDepotMsg.txt"));
                }
            } else if (Utils.pathContainsFiles(destDirFile) && !Globals.g_quietMode) {
                if (Globals.g_ssdType != 0) {
                    valid = false;
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.NewOrEmptyDirMsg.txt"), this.bundle.getString("Common.Error.txt"), 0);
                } else {
                    valid = this.confirmPrompt(this.bundle.getString("PanelDestination.ExistingFilesMsg.txt"));
                }
            }
        }
        if (valid && !(valid = Utils.canWriteToPath(destDir))) {
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "Insufficient permission to write and delete to the specified directory.");
            } else {
                errMsg = this.bundle.messageString("Common.Error.NoPermissions.txt", this.bundle.getString("PanelDestination.FieldName.txt"));
            }
        }
        if (valid) {
            boolean bl = valid = !Globals.g_depotManager.isLocked();
            if (!valid) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "The specified directory contains an existing SAS Software Depot which is locked by another process.");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDestination.Locked.txt"), this.bundle.getString("Common.Error.txt"), 0);
                }
            }
        }
        if (valid) {
            for (File parent = destDirFile.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                Globals.g_newDir = parent;
            }
            boolean bl = valid = (destDirFile.exists() || destDirFile.mkdirs()) && Globals.g_depotManager.setLock(true);
            if (!valid) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "DESTINATION_DEPOT", destDir, "Cannot create and lock the destination directory.");
                } else {
                    errMsg = this.bundle.messageString("PanelDestination.UnableToCreateAndLock.txt");
                }
            }
        }
        if (valid) {
            String orderNumber = null;
            if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
                Pattern p = Pattern.compile(".*(\\d{4}-\\d{2}-\\d{2}-\\d{2}\\.\\d{2}\\.\\d{2})");
                Matcher m = p.matcher(Globals.g_order);
                orderNumber = m.matches() ? m.replaceAll(new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date())) : Globals.g_order + "_" + new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                boolean disablePlanning = false;
                if (!Globals.g_subsetAll) {
                    boolean bl = disablePlanning = Globals.g_subsetData.isSubsetByProducts() || Globals.g_subsetWithRecipe;
                }
                if (Globals.g_mode == 1) {
                    Globals.g_deploymentData.cloneOrder(Globals.g_order, orderNumber, disablePlanning);
                } else {
                    Globals.g_deploymentData.cloneOrder(Globals.g_order, orderNumber, destDir, disablePlanning);
                }
                Globals.g_order = orderNumber;
                Globals.g_subsetData.setSubsetOrderNumber(orderNumber);
            }
            if (Globals.g_mode == 1) {
                Globals.g_downloadDir = Utils.joinPath(destDir, "download");
                File df = new File(Globals.g_downloadDir);
                if (df.exists()) {
                    Utils.deleteFolder(df);
                }
                if (!df.mkdir()) {
                    Logging.log.severe("Unable to create directory: " + Globals.g_downloadDir);
                    valid = false;
                    if (!Globals.g_quietMode) {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("Common.ESD.UnexpectedError.txt"), this.bundle.getString("Common.Error.txt"), 0);
                    }
                    Globals.g_kit.exitKit(-1);
                }
                Utils.copyFile(Globals.g_control.getTmpWorkDirectory(), Globals.g_downloadDir);
                Globals.g_deploymentData.setMediaRoot(Globals.g_downloadDir);
                Globals.g_job = Globals.g_depotManager.createAddJob(Globals.g_deploymentData, Globals.g_order);
                ((DepotManager.AddJob)Globals.g_job).setMode(3);
                if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
                    Globals.g_subsetData.omitSkus();
                }
                Globals.g_control.setAltSkuList(Globals.g_job.getSpsSkusToProcess());
            } else {
                Globals.g_job = Globals.g_depotManager.createAddJob(Globals.g_deploymentData, Globals.g_order);
                if (Globals.g_ssdType == 0) {
                    ((DepotManager.AddJob)Globals.g_job).setMode(1);
                }
                if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
                    Globals.g_subsetData.omitSkus();
                }
            }
            if (!this.checkDiskSpace(destDir)) {
                DecimalFormat gigFormat = new DecimalFormat("###,##0.000");
                String requiredSpace = gigFormat.format((double)Globals.g_job.getTotalSize() / 1.073741824E9);
                if (!Globals.g_quietMode && !(valid = this.confirmPrompt(this.bundle.messageString("PanelDestination.InsufficientSpaceMsg.txt", requiredSpace))) && Globals.g_newDir != null) {
                    Globals.g_depotManager.setLock(false);
                    Utils.deleteFolder(destDirFile);
                    Globals.g_newDir = null;
                }
            }
        }
        if (valid) {
            Globals.g_ssdDestDir = destDir;
            Globals.g_bytesMoved = 0L;
            Globals.g_wizardData.setPreference("LastSSDDir", destDir);
            if (Globals.g_mode == 1) {
                Globals.g_wizardData.setPreference("ActiveDownloadFolder", destDir);
                if (!Globals.g_noHotFix && Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() >= 2) {
                    Globals.g_hotfixData = new HotfixData(Globals.g_order);
                    Globals.g_hotfixData.grabAndAnalyzeHotfixes();
                }
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, Globals.g_wizard.getWizardTitle(), 2);
            }
            this.m_destination.requestFocus();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "confirmdepot";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        wizardFramework.getNextButton().setPreferredSize(null);
        if (this.showOptimizationOption()) {
            this.m_depotCompressionPromptActive = true;
            this.m_depotCompressionOption.setEnabled(true);
            this.m_depotCompressionOption.setVisible(true);
            this.m_depotCompressionInfo.setVisible(true);
            this.m_depotCompressionOption.setSelected(true);
        } else {
            this.m_depotCompressionPromptActive = false;
            this.m_depotCompressionOption.setEnabled(false);
            this.m_depotCompressionOption.setSelected(false);
            this.m_depotCompressionOption.setVisible(false);
            this.m_depotCompressionInfo.setVisible(false);
        }
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_destination.setText(Globals.g_wizardData.getPreference("LastSSDDir", this.getDefaultDestination()));
            }
            this.m_panelLoaded = true;
        }
    }

    private boolean showOptimizationOption() {
        boolean result = true;
        long lastPortDateDeploywizInDepot = 0L;
        if (Globals.g_mode != 1) {
            result = false;
        } else if (Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() < 3) {
            result = false;
        } else {
            SpsSkuData spsSkuData = Globals.g_deploymentData.getNewestSpsSku("deploywiz", null, false);
            if (spsSkuData == null) {
                result = false;
                Logging.log.info("Not displaying depot optimization option because no deploywiz");
            } else {
                lastPortDateDeploywizInDepot = spsSkuData.getLastPortDateAsLong();
                if (lastPortDateDeploywizInDepot < 1435118400000L) {
                    result = false;
                    Logging.log.info("Not displaying depot optimization option because lastPortDateDeploywizInDepot = " + lastPortDateDeploywizInDepot);
                }
            }
        }
        return result;
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        if (this.showOptimizationOption()) {
            this.m_depotCompressionPromptActive = true;
            this.m_depotCompressionOption.setEnabled(true);
            this.m_depotCompressionOption.setSelected(true);
        } else {
            this.m_depotCompressionPromptActive = false;
            this.m_depotCompressionOption.setEnabled(false);
            this.m_depotCompressionOption.setSelected(false);
        }
        if (!this.loadResponseData()) {
            this.m_destination.setText(Globals.g_wizardData.getPreference("LastSSDDir", this.getDefaultDestination()));
        }
        boolean valid = this.validateData();
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] stringArray;
        if (this.m_depotCompressionPromptActive) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "#DESTINATION_DEPOT=<full path>";
            stringArray2[1] = " DESTINATION_DEPOT=";
            stringArray2[2] = "#COMPRESS_DEPOT=yes/no";
            stringArray = stringArray2;
            stringArray2[3] = " COMPRESS_DEPOT=yes";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "#DESTINATION_DEPOT=<full path>";
            stringArray = stringArray3;
            stringArray3[1] = " DESTINATION_DEPOT=";
        }
        String[] data = stringArray;
        if (this.m_panelLoaded) {
            data[1] = " DESTINATION_DEPOT=" + this.m_destination.getText();
            if (this.m_depotCompressionPromptActive && !this.m_depotCompressionOption.isSelected()) {
                data[3] = " COMPRESS_DEPOT=no";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        if (Globals.g_depotManager != null) {
            Globals.g_depotManager.setLock(false);
        }
        Globals.g_depotManager = Globals.g_sourceDepotManager;
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        returnCode = ConsoleMode.promptText(this.m_depotLabel.getText(), this.m_destination);
        if (returnCode > -1 && Globals.g_mode == 1 && this.m_depotCompressionPromptActive) {
            ConsoleMode.printInfoText(this.m_depotCompressionInfo.getText());
            returnCode = ConsoleMode.promptBoolean(this.m_depotCompressionOption);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("DESTINATION_DEPOT", null);
        if (response != null) {
            this.m_destination.setText(response);
            valid = true;
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "DESTINATION_DEPOT");
        }
        String responseInstall = Wizard.getResponse("COMPRESS_DEPOT", null);
        if (responseInstall != null) {
            if (responseInstall.equalsIgnoreCase("yes")) {
                this.m_depotCompressionOption.setSelected(true);
                valid = true;
            } else if (responseInstall.equalsIgnoreCase("no")) {
                this.m_depotCompressionOption.setSelected(false);
                valid = true;
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_destination = new KitTextField();
        String mtxt = this.bundle.getString("Common.Browse1.txt");
        String defaultDir = System.getProperty("user.home");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), defaultDir, 0, this.m_destination, Globals.g_mode == 1 && Utils.getOS() == 9);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        mtxt = this.bundle.getString("PanelDestination.DepotLabel.txt");
        this.m_depotLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_depotLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_depotLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_depotLabel.setLabelFor(this.m_destination);
        mtxt = Globals.g_consoleMode ? this.bundle.getString("PanelDestination.UseSASSoftwareOptimizationLabelConsole.txt") : this.bundle.getString("PanelDestination.UseSASSoftwareOptimizationLabelGUI.txt");
        this.m_depotCompressionOption = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_depotCompressionOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_depotCompressionOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_depotCompressionOption.getFont();
        this.m_depotCompressionOption.setFont(optionFont.deriveFont(1));
        this.m_depotCompressionInfo = Globals.g_consoleMode ? new JTextArea(this.bundle.getString("PanelDestination.UseSASSoftwareOptimizationInfoConsole.txt")) : new JTextArea(this.bundle.getString("PanelDestination.UseSASSoftwareOptimizationInfoGUI.txt"));
        this.m_depotCompressionInfo.setEditable(false);
        this.m_depotCompressionInfo.setFocusable(false);
        this.m_depotCompressionInfo.setLineWrap(true);
        this.m_depotCompressionInfo.setWrapStyleWord(true);
        this.m_depotCompressionInfo.setOpaque(false);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_depotLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_destination, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 3;
        c.insets = new Insets(25, 0, 3, 0);
        this.m_panel.add((Component)this.m_depotCompressionOption, c);
        c.gridy = 4;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_depotCompressionInfo, c);
    }

    private boolean checkDiskSpace(String path) {
        boolean valid = true;
        if (!Globals.g_skipSpaceCheck) {
            long freeSpace;
            Globals.g_freeDiskSpace = freeSpace = Utils.getFreeSpace(path);
            valid = freeSpace >= Globals.g_job.getTotalSize();
        }
        return valid;
    }

    private boolean confirmPrompt(String message) {
        boolean valid = true;
        if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String getHelpTopic() {
        String helpTopic = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
        if (Globals.g_mode == 1) {
            helpTopic = helpTopic + "ESD";
        }
        return helpTopic;
    }

    private String getDefaultDestination() {
        String path = null;
        path = Utils.getOS() == 1 ? Utils.joinPath(Globals.g_windowsSystemDrive, "SAS Software Depot") : "";
        return path;
    }
}

