/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DepotSubsetListData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelDepotSubsetBase;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;

public class PanelDepotSubsetPlatform
extends PanelDepotSubsetBase
implements WizardPanelIface {
    private boolean winJRESelected;
    private boolean wx6JRESelected;
    private boolean lnxJRESelected;
    private boolean laxJRESelected;
    private HashSet<String> wx6JREs = new HashSet();
    private HashSet<String> laxJREs = new HashSet();
    private boolean addwx6;
    private boolean addlax;
    private String wx6Name;
    private String laxName;

    @Override
    public void backEvent(String backPanelID) {
        this.saveSelections();
        Globals.g_subsetData.clearPlatformSelections();
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_subsetData != null) {
            if (Globals.g_subsetData.isSubsetByPlatform()) {
                return true;
            }
            this.listData = Globals.g_subsetData.loadPlatforms();
            if (this.listData != null) {
                if (Globals.g_subsetWithRecipe) {
                    Globals.g_subsetRecipes.loadRecipeData(this.listData);
                } else {
                    this.loadProdInfo();
                    this.selectAll();
                }
            }
        }
        return false;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotSubsetPlatform.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotSubsetPlatform.HeaderDesc.txt");
    }

    @Override
    public String getNextPanelID() {
        return "selectsubsetProducts";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.listData = Globals.g_subsetData.loadPlatforms();
        if (this.listData != null && Globals.g_subsetWithRecipe) {
            Globals.g_subsetRecipes.loadRecipeData(this.listData);
        }
        this.restoreSelections();
        this.loadProdInfo();
        if (Globals.g_subsetResetSelectionsPlatforms) {
            this.selectAll();
            Globals.g_subsetResetSelectionsPlatforms = false;
        }
        if (!this.panelLoaded) {
            this.panelLoaded = true;
        }
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        this.saveSelections();
        if (!this.anythingSelected()) {
            if (Globals.g_quietMode) {
                Logging.log.severe("To subset this order, you must choose at least one of the Platforms.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotSubsetPlatform.RequiredStepMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            }
            valid = false;
        }
        this.scanForSelectedJREs();
        this.select64bitJREsForSelected32bitJREs();
        return valid;
    }

    private void scanForSelectedJREs() {
        SpsSkuData winJRT = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "javaruntime", "WIN", false);
        SpsSkuData wx6JRT = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "javaruntime", "WX6", false);
        SpsSkuData lnxJRT = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "javaruntime", "LNX", false);
        SpsSkuData laxJRT = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "javaruntime", "LAX", false);
        SpsSkuData wx6PJRE = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "privatejre", "WX6", false);
        SpsSkuData laxPJRE = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "privatejre", "LAX", false);
        for (DepotSubsetListData platform : this.listData) {
            for (String altsku : platform.getAltSkus()) {
                if (winJRT != null && altsku.equals(winJRT.getSpsSku())) {
                    if (!platform.isSelected()) continue;
                    this.winJRESelected = true;
                    continue;
                }
                if (wx6JRT != null && altsku.equals(wx6JRT.getSpsSku())) {
                    if (platform.isSelected()) {
                        this.wx6JRESelected = true;
                    }
                    this.wx6JREs.add(altsku);
                    this.wx6Name = wx6JRT.getDisplayName("en");
                    continue;
                }
                if (wx6PJRE != null && altsku.equals(wx6PJRE.getSpsSku())) {
                    this.wx6JREs.add(altsku);
                    continue;
                }
                if (lnxJRT != null && altsku.equals(lnxJRT.getSpsSku())) {
                    if (!platform.isSelected()) continue;
                    this.lnxJRESelected = true;
                    continue;
                }
                if (laxJRT != null && altsku.equals(laxJRT.getSpsSku())) {
                    if (platform.isSelected()) {
                        this.laxJRESelected = true;
                    }
                    this.laxJREs.add(altsku);
                    this.laxName = laxJRT.getDisplayName("en");
                    continue;
                }
                if (laxPJRE == null || !altsku.equals(laxPJRE.getSpsSku())) continue;
                this.laxJREs.add(altsku);
            }
        }
    }

    private void select64bitJREsForSelected32bitJREs() {
        if (this.winJRESelected && !this.wx6JRESelected) {
            this.addwx6 = true;
        }
        if (this.lnxJRESelected && !this.laxJRESelected) {
            this.addlax = true;
        }
    }

    public ArrayList<DepotSubsetListData> getJREs() {
        ArrayList<DepotSubsetListData> results = new ArrayList<DepotSubsetListData>();
        DepotSubsetListData product = null;
        if (this.addwx6) {
            product = new DepotSubsetListData(this.wx6JREs, this.wx6Name, null, false);
            results.add(product);
        }
        if (this.addlax) {
            product = new DepotSubsetListData(this.laxJREs, this.laxName, null, false);
            results.add(product);
        }
        return results;
    }

    public boolean isOnlyWINSelected() {
        boolean isWinSelected = false;
        boolean isWx6Selected = false;
        if (this.listData == null) {
            return false;
        }
        for (DepotSubsetListData platform : this.listData) {
            if ("win".equals(platform.getCode()) && platform.isSelected()) {
                isWinSelected = true;
                continue;
            }
            if (!"wx6".equals(platform.getCode()) || !platform.isSelected()) continue;
            isWx6Selected = true;
        }
        return isWinSelected && !isWx6Selected;
    }

    public boolean isOnlyLNXSelected() {
        boolean isLnxSelected = false;
        boolean isLaxSelected = false;
        if (this.listData == null) {
            return false;
        }
        for (DepotSubsetListData platform : this.listData) {
            if ("lnx".equals(platform.getCode()) && platform.isSelected()) {
                isLnxSelected = true;
                continue;
            }
            if (!"lax".equals(platform.getCode()) || !platform.isSelected()) continue;
            isLaxSelected = true;
        }
        return isLnxSelected && !isLaxSelected;
    }
}

