/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SubsetData;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelDepotSubsetFullOrSubset
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelDepotSubsetFullOrSubset.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JRadioButton m_fullOrderOption = null;
    private JTextArea m_fullOrderInfo = null;
    private JRadioButton m_subsetOrderOption = null;
    private JTextArea m_subsetOrderInfo = null;
    private boolean m_panelLoaded = false;
    private boolean subsetPreviouslySelected = false;

    public PanelDepotSubsetFullOrSubset() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotSubsetFullOrSubset.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotSubsetFullOrSubset.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (valid) {
            if (this.m_subsetOrderOption.isSelected()) {
                Globals.g_subsetData.setSubsetActive(true);
                this.subsetPreviouslySelected = true;
            } else {
                this.subsetPreviouslySelected = false;
                Globals.g_subsetData.setSubsetActive(false);
                Globals.g_subsetData.setSubsetByPlatform(false);
                Globals.g_subsetData.setSubsetByProducts(false);
                Globals.g_subsetData.setSubsetByLanguage(false);
                Globals.g_subsetWithRecipe = false;
                Globals.g_subsetResetSelectionsPlatProdLang = true;
                Globals.g_subsetResetSelectionsPlatforms = true;
                Globals.g_subsetResetSelectionsProducts = true;
                Globals.g_subsetResetSelectionsLanguages = true;
            }
            Globals.g_subsetData.setOrigOrder(Globals.g_order);
            Globals.g_subsetData.setOrigDepot(Globals.g_deploymentData.getMediaRoot());
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_deploymentData.getOrder(Globals.g_order).getDepotVersionAsInt() >= 2;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = this.m_fullOrderOption.isSelected() ? "selectsubsetPlatform" : (Globals.g_subsetWithRecipe ? "selectsubsetrecipe" : "selectbyplatprodlang");
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_fullOrderOption.setEnabled(true);
                this.m_fullOrderOption.setSelected(true);
                this.m_subsetOrderOption.setEnabled(true);
                this.m_subsetOrderOption.setSelected(false);
            }
            Globals.g_subsetData = new SubsetData();
            this.m_panelLoaded = true;
        } else if (Globals.g_subsetData != null) {
            if (Globals.g_subsetData.isSubsetActive()) {
                this.m_fullOrderOption.setSelected(false);
                this.m_fullOrderOption.setEnabled(true);
                this.m_subsetOrderOption.setSelected(true);
                this.m_subsetOrderOption.setEnabled(true);
            } else {
                if (this.subsetPreviouslySelected) {
                    this.m_fullOrderOption.setSelected(false);
                    this.m_subsetOrderOption.setSelected(true);
                } else {
                    this.m_fullOrderOption.setSelected(true);
                    this.m_subsetOrderOption.setSelected(false);
                }
                this.m_fullOrderOption.setEnabled(true);
                this.m_subsetOrderOption.setEnabled(true);
            }
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_fullOrderOption.isSelected() ? this.m_fullOrderOption : (this.m_subsetOrderOption.isSelected() ? this.m_subsetOrderOption : this.m_fullOrderOption);
        return focus;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_subsetData.resetData();
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_fullOrderOption, this.m_subsetOrderOption};
        JTextArea[] infos = new JTextArea[]{this.m_fullOrderInfo, this.m_subsetOrderInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        return valid;
    }

    private void initialize() {
        String NF = null;
        NF = Globals.g_subsetAll || Globals.g_subsetClients ? "NF" : "";
        String mtxt = this.bundle.getString("PanelDepotSubsetFullOrSubset.fullOrderOptionLabel.txt");
        this.m_fullOrderOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_fullOrderOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_fullOrderOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_fullOrderOption.getFont();
        this.m_fullOrderOption.setFont(optionFont.deriveFont(1));
        this.m_fullOrderInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetFullOrSubset.fullOrderOptionInfo.txt"));
        this.m_fullOrderInfo.setEditable(false);
        this.m_fullOrderInfo.setFocusable(false);
        this.m_fullOrderInfo.setLineWrap(true);
        this.m_fullOrderInfo.setWrapStyleWord(true);
        this.m_fullOrderInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelDepotSubsetFullOrSubset.subsetOrderOptionLabel.txt");
        this.m_subsetOrderOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_subsetOrderOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_subsetOrderOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_subsetOrderOption.getFont();
        this.m_subsetOrderOption.setFont(optionFont.deriveFont(1));
        this.m_subsetOrderInfo = new JTextArea(this.bundle.getString("PanelDepotSubsetFullOrSubset.subsetOrderOptionInfo" + NF + ".txt"));
        this.m_subsetOrderInfo.setEditable(false);
        this.m_subsetOrderInfo.setFocusable(false);
        this.m_subsetOrderInfo.setLineWrap(true);
        this.m_subsetOrderInfo.setWrapStyleWord(true);
        this.m_subsetOrderInfo.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_fullOrderOption);
        group.add(this.m_subsetOrderOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 3, 0);
        this.m_panel.add((Component)this.m_fullOrderOption, c);
        c.gridy = 1;
        c.insets = new Insets(2, 20, 2, 0);
        this.m_panel.add((Component)this.m_fullOrderInfo, c);
        c.gridy = 2;
        c.insets = new Insets(3, 0, 3, 0);
        this.m_panel.add((Component)this.m_subsetOrderOption, c);
        c.gridy = 3;
        c.insets = new Insets(2, 20, 3, 0);
        this.m_panel.add((Component)this.m_subsetOrderInfo, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

