/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.DepotSubsetListData;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public abstract class PanelDepotSubsetBase
implements WizardPanelIface {
    protected SSNResource bundle = new SSNResource(this.getClass());
    protected JPanel panel = new JPanel(new GridBagLayout());
    protected JTextArea panelInfo = null;
    protected JTable listTable = null;
    protected JScrollPane listScrollPane = null;
    protected ListTableModel listModel = null;
    protected ActionListener actionListener = null;
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JButton selectAllButton = null;
    protected JButton clearAllButton = null;
    protected boolean panelLoaded = false;
    ArrayList<DepotSubsetListData> listData = null;
    HashMap<String, Boolean> previousSelections = new HashMap();
    private boolean firstTime = true;

    public PanelDepotSubsetBase() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public abstract void backEvent(String var1);

    @Override
    public abstract boolean displayPanel();

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public abstract String getHeader();

    @Override
    public abstract String getHeaderDesc();

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public abstract String getNextPanelID();

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public abstract void preShowUpdates(Wizard var1);

    @Override
    public int consoleEvent() {
        return this.promptMultiChoiceDependency(this.getHeader());
    }

    private boolean loadResponseData() {
        boolean valid = true;
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = null;
        return data;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = true;
        return valid;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public abstract boolean validateData();

    protected void initialize() {
        this.panelInfo = new JTextArea(this.bundle.getString(this.getHelpTopic() + ".Info.txt"));
        this.panelInfo.setEditable(false);
        this.panelInfo.setFocusable(false);
        this.panelInfo.setLineWrap(true);
        this.panelInfo.setWrapStyleWord(true);
        this.panelInfo.setOpaque(false);
        this.listModel = new ListTableModel();
        this.listTable = new JTable(this.listModel);
        this.listTable.setCellSelectionEnabled(true);
        this.listTable.setSelectionMode(0);
        this.listTable.setTableHeader(null);
        this.listTable.setShowGrid(false);
        this.listTable.setOpaque(true);
        this.listTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelDepotSubsetBase.this.listTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.listScrollPane = new JScrollPane(this.listTable);
        this.listScrollPane.getViewport().setBackground(this.listTable.getBackground());
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.selectAllButton = new JButton(txt);
        this.selectAllButton.setMnemonic(mkey);
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.clearAllButton = new JButton(txt);
        this.clearAllButton.setMnemonic(mkey);
        this.actionListener = new SelectClearActionListener();
        this.selectAllButton.addActionListener(this.actionListener);
        this.clearAllButton.addActionListener(this.actionListener);
        this.installRenderers();
    }

    protected void installRenderers() {
        this.listTable.getColumnModel().getColumn(0).setCellRenderer(new ProductCellRenderer());
        this.listTable.getColumnModel().getColumn(0).setCellEditor(new ProductCellEditor(new JCheckBox()));
    }

    private String createToolTipText(String productName, HashSet<DepotSubsetListData> toolText) {
        String result = null;
        if (toolText.size() == 1) {
            result = productName + " " + this.bundle.messageString("PanelDepotSubsetBase.isRequiredBy.txt") + " " + toolText.toArray(new DepotSubsetListData[0])[0].getName();
        } else {
            result = "<html>" + productName + " " + this.bundle.messageString("PanelDepotSubsetBase.isRequiredBy.txt") + "<ul>";
            for (DepotSubsetListData i : toolText) {
                result = result + "<li>" + i.getName();
            }
            result = result + "</ul></html>";
        }
        return result;
    }

    protected void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.panel.add((Component)this.panelInfo, c);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.panel.add((Component)this.listScrollPane, c);
        this.initButtonPanel();
        c.gridy = 2;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.panel.add((Component)this.buttonPanel, c);
    }

    protected void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.buttonPanel.add((Component)this.selectAllButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.clearAllButton, c);
        if (this.selectAllButton.getPreferredSize().getWidth() < this.clearAllButton.getPreferredSize().getWidth()) {
            this.selectAllButton.setPreferredSize(this.clearAllButton.getPreferredSize());
        } else if (this.clearAllButton.getPreferredSize().getWidth() < this.selectAllButton.getPreferredSize().getWidth()) {
            this.clearAllButton.setPreferredSize(this.selectAllButton.getPreferredSize());
        }
    }

    protected void loadProdInfo() {
        int rowHeight;
        this.listModel.setDependencies();
        Collections.sort(this.listData);
        this.listModel.load();
        if (this.firstTime) {
            this.selectAll();
            this.firstTime = false;
        }
        if ((rowHeight = Utils.getPreferredRowHeight(this.listTable)) > 0) {
            this.listTable.setRowHeight(rowHeight);
        }
    }

    protected void selectAll() {
        this.listModel.selectAll(true);
    }

    protected boolean anythingSelected() {
        for (DepotSubsetListData i : this.listData) {
            if (!i.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected void saveSelections() {
        for (DepotSubsetListData i : this.listData) {
            this.previousSelections.put(i.getName(), new Boolean(i.isSelectedByUser()));
        }
    }

    protected void restoreSelections() {
        for (DepotSubsetListData i : this.listData) {
            if (!this.previousSelections.containsKey(i.getName())) continue;
            i.setSelectedByUser(this.previousSelections.get(i.getName()));
        }
    }

    public int promptMultiChoiceDependency(String header) {
        int i;
        boolean finished = false;
        int returnCode = -1;
        String line = null;
        String numOffset = "";
        SSNResource bundle = new SSNResource(ConsoleMode.class);
        ArrayList<String> text = new ArrayList<String>();
        if (header != null) {
            text.add(header);
        }
        for (DepotSubsetListData listItem : this.listData) {
            text.add(listItem.getName());
        }
        String[] alignedText = ConsoleMode.alignText(text.toArray(new String[0]));
        String alignedHeader = null;
        String[] alignedOptions = null;
        if (header != null) {
            alignedHeader = alignedText[0];
            alignedOptions = new String[alignedText.length - 1];
            for (i = 1; i < alignedText.length; ++i) {
                alignedOptions[i - 1] = alignedText[i];
            }
        } else {
            alignedOptions = new String[alignedText.length];
            for (i = 0; i < alignedText.length; ++i) {
                alignedOptions[i] = alignedText[i];
            }
        }
        while (returnCode == -1 && !finished) {
            ConsoleMode.println();
            if (alignedHeader != null) {
                if (this.listData.size() > 99) {
                    ConsoleMode.println("          " + alignedHeader);
                } else if (this.listData.size() > 9) {
                    ConsoleMode.println("         " + alignedHeader);
                } else {
                    ConsoleMode.println("        " + alignedHeader);
                }
            }
            int count = -1;
            for (DepotSubsetListData listItem : this.listData) {
                ++count;
                line = listItem.isSelected() ? "(*) " : "( ) ";
                numOffset = "";
                if (this.listData.size() > 99) {
                    if (count < 10) {
                        numOffset = "  ";
                    } else if (count < 100) {
                        numOffset = " ";
                    }
                } else if (this.listData.size() > 9 && count < 10) {
                    numOffset = " ";
                }
                line = line + Integer.toString(count + 1) + numOffset + " - " + alignedOptions[count];
                if (!listItem.isSelectable()) {
                    line = line + " " + bundle.getString("ConsoleMode.RequiredTag.txt");
                }
                ConsoleMode.println(line);
            }
            ConsoleMode.println();
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt1.txt"));
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt2.txt"));
            if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
                if (Globals.g_wizard.firstDialog()) {
                    ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
                } else {
                    ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
                }
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
            }
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt3.txt"));
            ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
            ConsoleMode.print(bundle.getString("ConsoleMode.MultiPrompt4.txt"));
            String input = ConsoleMode.readLine();
            if (input.length() == 0) {
                finished = true;
                returnCode = 0;
                continue;
            }
            if (input.equalsIgnoreCase("<q>")) {
                returnCode = -2;
                continue;
            }
            if (input.equalsIgnoreCase("<b>") && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
                returnCode = -3;
                continue;
            }
            if (input.equalsIgnoreCase("<h>") && Globals.g_wizard != null) {
                returnCode = -4;
                continue;
            }
            if (input.equalsIgnoreCase("<s>")) {
                this.listModel.selectAll(true);
                continue;
            }
            if (input.equalsIgnoreCase("<c>")) {
                this.listModel.selectAll(false);
                continue;
            }
            int selection = -1;
            String[] selections = input.split(" ");
            for (int i2 = 0; i2 < selections.length; ++i2) {
                DepotSubsetListData listItem;
                try {
                    selection = Integer.parseInt(selections[i2].trim()) - 1;
                }
                catch (Exception e) {
                    selection = -1;
                }
                if (selection <= -1 || selection >= this.listData.size() || !(listItem = this.listData.get(selection)).isSelectable()) continue;
                listItem.setSelectedByUser(!listItem.isSelectedByUser());
                this.listModel.chaseDependencies(listItem, listItem.isSelected(), null);
                this.listModel.setDependencies();
            }
        }
        return returnCode;
    }

    class SelectClearActionListener
    implements ActionListener {
        SelectClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(PanelDepotSubsetBase.this.selectAllButton)) {
                PanelDepotSubsetBase.this.listModel.selectAll(true);
            } else if (e.getSource() == PanelDepotSubsetBase.this.clearAllButton) {
                PanelDepotSubsetBase.this.listModel.selectAll(false);
            }
        }
    }

    protected class ProductCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -5898600422180218541L;
        private JCheckBox m_checkBox;

        public ProductCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    DepotSubsetListData ld = PanelDepotSubsetBase.this.listData.get(row);
                    this.m_checkBox.setText(ld.getName());
                    this.m_checkBox.setSelected(ld.isSelected());
                    this.m_checkBox.setEnabled(ld.isSelectable());
                    if (ld.getRevDependencies() != null) {
                        this.m_checkBox.setToolTipText(PanelDepotSubsetBase.this.createToolTipText(ld.getName(), ld.getRevDependencies()));
                    } else {
                        this.m_checkBox.setToolTipText(null);
                    }
                }
            }
            return this.m_checkBox;
        }
    }

    protected class ProductCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2834857628316565702L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    DepotSubsetListData ld = PanelDepotSubsetBase.this.listData.get(row);
                    this.setText(ld.getName());
                    this.setSelected(ld.isSelected());
                    this.setEnabled(ld.isSelectable());
                    if (ld.getRevDependencies() != null) {
                        this.setToolTipText(PanelDepotSubsetBase.this.createToolTipText(ld.getName(), ld.getRevDependencies()));
                    } else {
                        this.setToolTipText(null);
                    }
                }
            }
            return this;
        }
    }

    class ListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5376335278906768099L;
        public static final int LANGUAGE_COLUMN = 0;

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            if (PanelDepotSubsetBase.this.listData == null) {
                return 0;
            }
            return PanelDepotSubsetBase.this.listData.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return PanelDepotSubsetBase.this.listData.get(rowIndex).isSelected();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DepotSubsetListData ld = PanelDepotSubsetBase.this.listData.get(rowIndex);
            if (ld != null && value instanceof Boolean) {
                boolean selected = (Boolean)value;
                ld.setSelectedByUser(selected);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                this.chaseDependencies(ld, selected, null);
                this.setDependencies();
                this.fireTableDataChanged();
            }
        }

        public void chaseDependencies(DepotSubsetListData ld, boolean selected, HashSet<DepotSubsetListData> beenHere) {
            if (beenHere == null) {
                beenHere = new HashSet();
            }
            if (ld.getDependencies() != null && !beenHere.contains(ld)) {
                for (DepotSubsetListData deps : ld.getDependencies()) {
                    deps.setSelectableByDependency(!selected);
                    deps.setSelectedByDependency(selected);
                    beenHere.add(deps);
                    this.chaseDependencies(deps, selected, beenHere);
                }
            }
        }

        public void setDependencies() {
            for (DepotSubsetListData listItem : PanelDepotSubsetBase.this.listData) {
                if (!listItem.isSelected()) continue;
                this.chaseDependencies(listItem, true, null);
            }
        }

        public void load() {
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelDepotSubsetBase.this.installRenderers();
            PanelDepotSubsetBase.this.selectAllButton.setEnabled(PanelDepotSubsetBase.this.listData.size() > 0);
            PanelDepotSubsetBase.this.clearAllButton.setEnabled(PanelDepotSubsetBase.this.listData.size() > 0);
        }

        public void selectAll(boolean value) {
            for (int i = 0; i < PanelDepotSubsetBase.this.listData.size(); ++i) {
                if (PanelDepotSubsetBase.this.listData == null) continue;
                DepotSubsetListData listItem = PanelDepotSubsetBase.this.listData.get(i);
                listItem.setSelectableByDependency(true);
                listItem.setSelectedByDependency(false);
                if (!listItem.isSelectableByPolicy()) continue;
                listItem.setSelectedByUser(value);
            }
            this.setDependencies();
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelDepotSubsetBase.this.installRenderers();
        }

        public void clear() {
            this.fireTableDataChanged();
        }
    }
}

