/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DepotManager;
import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.vjr.VJREvent;
import com.sas.tools.installs.it.vjr.VJREventHandler;
import com.sas.tools.installs.it.vjr.VJRException;
import com.sas.tools.installs.it.vjr.VJRManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PanelDepotChecker
implements WizardPanelIface,
ActionListener,
Printable {
    private SSNResource bundle = new SSNResource(PanelDepotChecker.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_orderListInstructions = null;
    private JProgressBar m_progressBar = null;
    private JLabel m_scanTypeLabel = null;
    private JLabel m_scanType = null;
    private JLabel m_scanningFileNameLabel = null;
    private JLabel m_scanningFileName = null;
    private JEditorPane m_depotReport = null;
    private JScrollPane m_reportScrollPane = null;
    private JButton m_saveButton = null;
    private JButton m_printButton = null;
    private JButton m_browserButton = null;
    private ArrayList<String> orders = new ArrayList();
    private DeploymentData m_deploymentData;
    private String m_depotLocation;
    private Map<String, DepotFileData> depotFiles = new LinkedHashMap<String, DepotFileData>();
    private DepotManager m_depotManager = null;
    private Thread m_scanners = null;
    private int problemCount = 10;
    private final int STANDARD_PERMISSIONS755 = 493;
    private final int STANDARD_PERMISSIONS644 = 420;
    private final int STANDARD_PERMISSIONS = Utils.getOS() == 8 ? 420 : 493;
    private final int PERMISSIONS_MASK = 511;
    private Timer m_timerProgressBar = null;
    private ActionListener m_timerActionProgressBar = null;
    private Timer m_timerScanFileName = null;
    private ActionListener m_timerActionScanFileName = null;
    private StringBuffer m_currentFileName = new StringBuffer("");
    private volatile boolean m_processing = false;
    private volatile boolean m_finished = false;
    private volatile boolean m_stopButton = false;
    private boolean m_panelLoaded = false;
    private int m_fileCount = 0;
    private int m_maxCount = 0;
    private String m_ls = System.getProperty("line.separator");
    private VJRManager m_vjrm = null;
    private static final String SKIPDIALOG = "SKIPDIALOG";

    public PanelDepotChecker() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelDepotChecker.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelDepotChecker.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        if (this.m_processing) {
            if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelDepotChecker.InterruptMsg.txt", this.bundle.getString("Common.DCUTitle.txt")), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 0) {
                this.m_stopButton = true;
                this.m_processing = false;
            }
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return null;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.m_depotLocation = Globals.g_ssdDestDir;
        this.m_depotReport.setText("");
        this.m_saveButton.setEnabled(false);
        this.m_browserButton.setEnabled(false);
        this.m_printButton.setEnabled(false);
        this.m_processing = true;
        this.m_finished = false;
        if (!this.m_panelLoaded) {
            wizardFramework.clearWizardChain(true);
            String mtxt = this.bundle.getString("PanelDepotChecker.StopButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            wizardFramework.getBackButton().setEnabled(false);
            wizardFramework.getCancelButton().setEnabled(false);
            if (!Globals.g_consoleMode) {
                this.m_timerProgressBar.start();
                this.m_timerScanFileName.start();
                this.m_scanners = new LaunchScannersByThread();
                this.m_scanners.start();
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = false;
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        this.m_depotReport.setText("");
        this.m_depotReport.validate();
        this.m_saveButton.setEnabled(false);
        this.m_browserButton.setEnabled(false);
        this.m_printButton.setEnabled(false);
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        ConsoleMode.printInfoText(this.bundle.messageString("PanelDepotChecker.Console.Inform.txt", this.m_depotLocation));
        ConsoleMode.printInfoText(this.bundle.getString("PanelDepotChecker.Console.Instructions.txt"));
        ConsoleMode.println();
        this.launchScanners();
        ConsoleMode.println(this.bundle.messageString("PanelDepotChecker.Progress.Done.txt", this.depotFiles.size()));
        if (Globals.g_reportFile != null) {
            this.writeReportFile(new File(Globals.g_reportFile));
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        return valid;
    }

    private void initialize() {
        String mtxt = null;
        Font optionFont = null;
        Globals.g_badOrderDataFiles = new HashSet();
        this.m_processing = false;
        this.m_finished = false;
        this.m_orderListInstructions = new JTextArea(this.bundle.getString("PanelDepotChecker.GUI.Instructions.Starting.txt"));
        this.m_orderListInstructions.setFocusable(false);
        this.m_orderListInstructions.setOpaque(false);
        this.m_orderListInstructions.setEditable(false);
        this.m_orderListInstructions.setLineWrap(true);
        this.m_orderListInstructions.setWrapStyleWord(true);
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setStringPainted(true);
        this.m_scanTypeLabel = new JLabel(this.bundle.getString("PanelDepotChecker.Report.ScanTypeLabel.txt"));
        this.m_scanType = new JLabel();
        this.m_scanningFileNameLabel = new JLabel(this.bundle.getString("PanelDepotChecker.Report.ScanningFileNameLabel.txt"));
        this.m_scanningFileName = new JLabel();
        this.m_depotReport = new JEditorPane();
        this.m_depotReport.setOpaque(false);
        this.m_depotReport.setEditable(false);
        if (!Globals.g_consoleMode) {
            this.m_depotReport.setContentType("text/plain");
        }
        this.m_depotReport.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelDepotChecker.this.m_depotReport.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_reportScrollPane = new JScrollPane(this.m_depotReport);
        mtxt = this.bundle.getString("PanelDepotChecker.Save.txt");
        this.m_saveButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_saveButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_saveButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_saveButton.getFont();
        this.m_saveButton.setFont(optionFont.deriveFont(1));
        this.m_saveButton.addActionListener(this);
        mtxt = this.bundle.getString("PanelDepotChecker.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_printButton.getFont();
        this.m_printButton.setFont(optionFont.deriveFont(1));
        this.m_printButton.addActionListener(this);
        mtxt = this.bundle.getString("PanelDepotChecker.Browse.txt");
        this.m_browserButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_browserButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browserButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_browserButton.getFont();
        this.m_browserButton.setFont(optionFont.deriveFont(1));
        this.m_browserButton.addActionListener(this);
        this.m_timerActionProgressBar = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelDepotChecker.this.timerEventProgressBar();
            }
        };
        this.m_timerProgressBar = new Timer(100, this.m_timerActionProgressBar);
        this.m_timerActionScanFileName = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelDepotChecker.this.timerEventScanFileName();
            }
        };
        this.m_timerScanFileName = new Timer(100, this.m_timerActionScanFileName);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_orderListInstructions, c);
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_progressBar, c);
        c.gridy = 2;
        c.gridwidth = 4;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_scanType, c);
        c.gridy = 3;
        c.insets = new Insets(5, 0, 0, 5);
        this.m_panel.add((Component)this.m_scanningFileName, c);
        c.gridx = 0;
        c.gridy = 4;
        c.weighty = 5.0;
        c.gridwidth = 4;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_reportScrollPane, c);
        c.gridx = 0;
        c.weightx = 5.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 16;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add(Box.createGlue(), c);
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = -1;
        c.anchor = 14;
        this.m_panel.add((Component)this.m_saveButton, c);
        c.gridx = 2;
        this.m_panel.add((Component)this.m_browserButton, c);
        c.gridx = 3;
        c.fill = 0;
        this.m_panel.add((Component)this.m_printButton, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_saveButton) {
            this.saveReportToFile();
        } else if (src == this.m_printButton) {
            this.printReport();
        } else if (src == this.m_browserButton) {
            this.sendReportToBrowser();
        }
    }

    public void writeReportHeaders() {
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Report.About.txt"));
        this.displayMsg(this.bundle.messageString("PanelDepotChecker.Report.Date.txt", new SimpleDateFormat("yyyy MMM dd HH:mm:ss", Locale.US).format(new Date())));
        this.displayMsg(this.bundle.messageString("PanelDepotChecker.Report.UserId.txt", System.getProperty("user.name")));
        this.displayMsg(this.bundle.messageString("PanelDepotChecker.Report.DepotLocation.txt", this.m_depotLocation));
        this.displayMsg(null);
    }

    private void checkDepotLocation() throws DepotCheckerException {
        Logging.log.fine("Checking Depot Location: " + this.m_depotLocation);
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckDepotLocation.txt"));
        this.m_depotManager = new DepotManager(this.m_depotLocation);
        boolean badDepot = false;
        if (!Globals.g_badOrderDataFiles.isEmpty()) {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.BadOrderFilesDesc.txt"));
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.BadOrderFilesList.txt"));
            for (String i : Globals.g_badOrderDataFiles) {
                this.displayMsg("  " + i);
            }
            throw new DepotCheckerException(SKIPDIALOG);
        }
        if (!this.m_depotManager.existingDepot()) {
            this.reportProblem(Problem.BADDEPOT, this.m_depotLocation);
            throw new DepotCheckerException(this.bundle.messageString("PanelDepotChecker.Exception.BadDepot.txt", this.m_depotLocation));
        }
        this.m_deploymentData = this.m_depotManager.getDepotData();
        Logging.log.fine("Completed depot location validation");
    }

    private void loadOrders() throws InterruptedException {
        OrderData[] orderDataList;
        Logging.log.fine("Loading order information...");
        for (OrderData orderData : orderDataList = this.m_deploymentData.getOrders()) {
            if (Globals.g_forceOrder != null && orderData.getOrder() != Globals.g_forceOrder || orderData.getDepotVersionAsInt() < 2) continue;
            this.orders.add(orderData.getOrder());
            String[] volsers = orderData.getVolsers(orderData.getMediaType());
            for (int i = 0; i < volsers.length; ++i) {
                VolserData volserData = this.m_deploymentData.getVolser(volsers[i]);
                String[] spsSkus = volserData.getSpsSkus();
                for (int j = 0; j < spsSkus.length; ++j) {
                    if (Thread.currentThread().isInterrupted() || this.m_stopButton) {
                        throw new InterruptedException("Stopped loading orders");
                    }
                    if (!volserData.isPayloadIncluded(spsSkus[j])) continue;
                    SpsSkuData spsSkuData = this.m_deploymentData.getSpsSku(spsSkus[j]);
                    Set<String> productFileList = spsSkuData.getProductFilesDC();
                    Set<String> dataFileList = spsSkuData.getDataFilesDC();
                    for (String filename : productFileList) {
                        this.depotFiles.put(this.normalize(volserData.getProductPath(spsSkus[j]) + "/" + filename), new DepotFileData(spsSkuData.getProductFilesDCsize(filename), spsSkuData.getProductFilesDCchecksum(filename)));
                    }
                    for (String filename : dataFileList) {
                        this.depotFiles.put("product_data/" + spsSkuData.getSpsSku() + "/" + filename, new DepotFileData(spsSkuData.getDataFilesDCsize(filename), spsSkuData.getDataFilesDCchecksum(filename)));
                    }
                }
            }
        }
        this.displayMsg(this.bundle.messageString("PanelDepotChecker.Report.Orders.txt", this.orders.toString()));
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.LoadingOrders.txt"));
        this.displayMsg(null);
        ConsoleMode.println();
    }

    private void initializeVJR() throws InterruptedException {
        this.m_vjrm = VJRManager.getInstance();
        try {
            this.m_vjrm.loadDepot(this.m_depotLocation);
        }
        catch (VJRException e) {
            this.reportProblem(Problem.BADVJR, e.getMessage());
            this.displayMsg(null);
        }
        catch (Exception e) {
            Globals.g_badOrderDataFiles.add(e.getMessage());
            Logging.logStackTrace(e);
        }
    }

    public void setMax() {
        this.m_maxCount = this.depotFiles.size() * 2;
        if (this.m_vjrm != null && this.m_vjrm.isDepotCompressed()) {
            int vjrEventCount = this.m_vjrm.estimateDepotEvents(VJREvent.EventType.VALIDATION);
            Logging.log.fine("Estimated VJR event count: " + vjrEventCount);
            this.m_maxCount += vjrEventCount;
        }
        this.m_progressBar.setMaximum(100);
    }

    public void setProgressBarValue(int value) {
        int newValue = (int)((float)value / (float)this.m_maxCount * 100.0f);
        if (newValue > 98) {
            newValue = 99;
        }
        this.m_progressBar.setValue(newValue);
    }

    public void scanDirs() throws InterruptedException {
        Logging.log.fine("Scanning Dirs...");
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.ScanningDepot.txt"));
        LinkedList<String> searchList = new LinkedList<String>();
        searchList.addFirst(".");
        String[] dirList = null;
        String fullPath = null;
        File sourcePathFile = null;
        String currDir = null;
        File fin = null;
        while (!searchList.isEmpty()) {
            currDir = (String)searchList.remove();
            Logging.log.finer("Scanning directory: " + currDir);
            this.m_scanType.setText(this.bundle.getString("PanelDepotChecker.Report.ScanType.ScanDirs.txt"));
            dirList = null;
            fin = new File(this.m_depotLocation, currDir);
            if (fin != null) {
                dirList = fin.list();
            }
            if (dirList != null) {
                for (String path : new ArrayList<String>(Arrays.asList(dirList))) {
                    if (Thread.currentThread().isInterrupted() || this.m_stopButton) {
                        throw new InterruptedException("Stopped scanning dirs");
                    }
                    fullPath = Utils.joinPath(currDir, path);
                    sourcePathFile = new File(this.m_depotLocation, fullPath);
                    Logging.log.finer("Scanning: " + sourcePathFile.getAbsolutePath());
                    this.m_currentFileName.setLength(0);
                    this.m_currentFileName.append(sourcePathFile.getAbsolutePath());
                    ++this.m_fileCount;
                    if (sourcePathFile.isDirectory()) {
                        searchList.addFirst(fullPath);
                        continue;
                    }
                    DepotFileData dfd = null;
                    String fixedFullPath = this.normalize(fullPath);
                    if (this.depotFiles.containsKey(fixedFullPath)) {
                        dfd = this.depotFiles.get(fixedFullPath);
                        dfd.setStatus(FileStatus.EXISTS_IN_BOTH);
                    } else {
                        dfd = new DepotFileData();
                        dfd.setStatus(FileStatus.EXISTS_IN_DEPOT_ONLY);
                        this.depotFiles.put(fixedFullPath, dfd);
                    }
                    dfd.setActualSize(sourcePathFile.length());
                    if (Utils.getOS() == 1) continue;
                    try {
                        dfd.setActualPermissions(new FileMode(sourcePathFile).getPerm());
                    }
                    catch (NullPointerException e) {
                        Logging.logStackTrace(e);
                    }
                    catch (FileNotFoundException e) {
                        Logging.logStackTrace(e);
                    }
                }
                continue;
            }
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Skipping.txt", Utils.joinPath(this.m_depotLocation, currDir)));
            Logging.log.warning("Could not list files in " + Utils.joinPath(this.m_depotLocation, currDir) + ". Check permissions?");
        }
        this.displayMsg(this.bundle.messageString("PanelDepotChecker.Finishing.ScanningDepot.txt", this.depotFiles.size()));
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void checkMissingFiles() throws InterruptedException {
        boolean problemFound = false;
        int badFileCount = 0;
        Logging.log.fine("Checking for missing files...");
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckMissingFiles.txt"));
        for (Map.Entry<String, DepotFileData> depotFile : this.depotFiles.entrySet()) {
            String filepath = depotFile.getKey();
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(filepath);
            DepotFileData dfd = depotFile.getValue();
            if (dfd.status == FileStatus.EXISTS_IN_DATA_ONLY) {
                this.reportProblem(Problem.MISSINGFILE, this.fullpath(filepath));
                problemFound = true;
                ++badFileCount;
            }
            if (!Thread.currentThread().isInterrupted() && !this.m_stopButton) continue;
            throw new InterruptedException("Stopped scanning dirs");
        }
        if (!problemFound) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckMissingFiles.txt"));
        } else {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.Summary.MissingFiles.txt", badFileCount));
        }
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void checkFileSizes() throws InterruptedException {
        boolean problemFound = false;
        int badFileCount = 0;
        Logging.log.fine("Checking for incorrect file sizes...");
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckFileSizes.txt"));
        for (String filepath : this.depotFiles.keySet()) {
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(filepath);
            DepotFileData dfd = this.depotFiles.get(filepath);
            if (dfd.getStatus() == FileStatus.EXISTS_IN_BOTH && dfd.getExpectedSize() != -1L && dfd.getExpectedSize() != dfd.getActualSize() && !filepath.endsWith("install.xml") && !filepath.endsWith("filelist.xml")) {
                this.reportProblem(Problem.BADSIZE, this.fullpath(filepath), new Long(dfd.getExpectedSize()).toString(), new Long(dfd.getActualSize()).toString());
                problemFound = true;
                ++badFileCount;
            }
            if (!Thread.currentThread().isInterrupted() && !this.m_stopButton) continue;
            throw new InterruptedException("Stopped scanning dirs");
        }
        if (!problemFound) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckFileSizes.txt"));
        } else {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.Summary.BadSize.txt", badFileCount));
        }
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void checkFilePerms() throws InterruptedException {
        boolean problemFound = false;
        int badFileCount = 0;
        if (Utils.getOS() == 1) {
            return;
        }
        Logging.log.fine("Checking for bad permissions...");
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckFilePerms.txt"));
        for (String filepath : this.depotFiles.keySet()) {
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(filepath);
            DepotFileData dfd = this.depotFiles.get(filepath);
            if (dfd.status != FileStatus.EXISTS_IN_DATA_ONLY && (dfd.getActualPermissions() & this.STANDARD_PERMISSIONS) != this.STANDARD_PERMISSIONS) {
                this.reportProblem(Problem.BADPERMISSION, this.fullpath(filepath), String.format("%o", this.STANDARD_PERMISSIONS), String.format("%o", dfd.getActualPermissions() & 0x1FF));
                problemFound = true;
                ++badFileCount;
            }
            if (!Thread.currentThread().isInterrupted() && !this.m_stopButton) continue;
            throw new InterruptedException("Stopped scanning dirs");
        }
        if (!problemFound) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckFilePerms.txt"));
        } else {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.Summary.BadPermissions.txt", badFileCount, this.m_depotLocation));
        }
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void checkSpecialCaseFiles() throws InterruptedException {
        String[] filesToCheck = new String[]{"cd.id", "sassd.txt", "setup.dat", "depotsummary.html"};
        String[] dirsToCheck = new String[]{"media_data", "order_data", "product_data", "sid_files"};
        boolean problemFound = false;
        int badFileCount = 0;
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckSpecialCaseFiles.txt"));
        for (String fileToCheck : filesToCheck) {
            DepotFileData dfd = this.depotFiles.get(fileToCheck);
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(fileToCheck);
            if (dfd == null || dfd.status != FileStatus.EXISTS_IN_DEPOT_ONLY) {
                this.reportProblem(Problem.MISSINGFILE, this.fullpath(fileToCheck));
                ++badFileCount;
                problemFound = true;
            }
            if (!Thread.currentThread().isInterrupted() && !this.m_stopButton) continue;
            throw new InterruptedException("Stopped scanning dirs");
        }
        for (String dirToCheck : dirsToCheck) {
            File dir = new File(this.m_depotLocation, dirToCheck);
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(dir.getName());
            if (!dir.exists() || !dir.isDirectory()) {
                try {
                    this.reportProblem(Problem.MISSINGFILE, dir.getCanonicalPath());
                }
                catch (IOException e) {
                    Logging.logStackTrace(e);
                }
                ++badFileCount;
                problemFound = true;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedException("Stopped scanning dirs");
        }
        if (!problemFound) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckSpecialFiles.txt"));
        } else {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.Summary.MissingSpecialCaseFiles.txt", badFileCount));
        }
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void checkVJR() throws InterruptedException {
        boolean problemFound = false;
        if (this.m_vjrm == null) {
            return;
        }
        Logging.log.fine("Checking VJR...");
        this.m_scanType.setText(this.bundle.getString("PanelDepotChecker.Report.ScanType.CheckVJR.txt"));
        VjrEH vjrEvent = new VjrEH();
        this.m_vjrm.setEventHandler(vjrEvent);
        try {
            if (this.m_vjrm.isDepotCompressed()) {
                this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckVJRFiles.txt"));
                this.m_vjrm.validateDepot();
            }
        }
        catch (VJRException e) {
            if (!this.m_stopButton) {
                this.reportProblem(Problem.BADVJR, e.getMessage());
                Logging.logStackTrace(e);
                problemFound = true;
            }
            throw new InterruptedException("Stopped scanning vjr directory");
        }
        if (!problemFound && this.m_vjrm.isDepotCompressed()) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckVJRFiles.txt"));
        }
        this.displayMsg(null);
    }

    private void checkChecksums() throws InterruptedException {
        boolean problemFound = false;
        int badFileCount = 0;
        Logging.log.fine("Checking checksums...");
        this.displayMsg(this.bundle.getString("PanelDepotChecker.Starting.CheckChecksums.txt"));
        for (String filepath : this.depotFiles.keySet()) {
            if (Thread.currentThread().isInterrupted() || this.m_stopButton) {
                throw new InterruptedException("Stopped checking checksums");
            }
            Logging.log.finer("Checking crc for file: " + filepath);
            this.m_scanType.setText(this.bundle.getString("PanelDepotChecker.Report.ScanType.CheckCheckSums.txt"));
            this.m_currentFileName.setLength(0);
            this.m_currentFileName.append(filepath);
            ++this.m_fileCount;
            DepotFileData dfd = this.depotFiles.get(filepath);
            if (dfd.getStatus() != FileStatus.EXISTS_IN_BOTH || dfd.getExpectedChecksum().length() <= 0 || dfd.getActualSize() != dfd.getExpectedSize() || filepath.endsWith("install.xml")) continue;
            String actualChecksum = com.sas.tools.installs.it.Utils.getMd5sum(new File(this.m_depotLocation, filepath));
            if ("".equals(dfd.getExpectedChecksum()) || dfd.getExpectedChecksum().equalsIgnoreCase(actualChecksum)) continue;
            this.reportProblem(Problem.BADCHECKSUM, this.fullpath(filepath), dfd.expectedChecksum, actualChecksum);
            problemFound = true;
            ++badFileCount;
        }
        if (!problemFound) {
            this.displayMsg(this.bundle.getString("PanelDepotChecker.Finishing.CheckChecksums.txt"));
        } else {
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.Problem.Summary.BadChecksum.txt", badFileCount));
        }
        this.displayMsg(null);
        this.m_currentFileName.setLength(0);
    }

    private void launchScanners() {
        this.m_processing = true;
        try {
            this.writeReportHeaders();
            this.checkDepotLocation();
            this.loadOrders();
            this.initializeVJR();
            this.setMax();
            this.scanDirs();
            this.checkMissingFiles();
            this.checkFileSizes();
            this.checkFilePerms();
            this.checkSpecialCaseFiles();
            this.checkVJR();
            this.checkChecksums();
            this.m_finished = true;
            this.m_processing = false;
        }
        catch (InterruptedException e) {
            if (Globals.g_reportFile != null) {
                this.writeReportFile(new File(Globals.g_reportFile));
            }
        }
        catch (Exception e) {
            if (!SKIPDIALOG.equals(e.getMessage())) {
                Logging.logStackTrace(e);
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.Exception.txt"), this.bundle.getString("Common.Error.txt"), 0);
            }
        }
        finally {
            this.m_processing = false;
            this.m_vjrm = null;
        }
    }

    private void saveReportToFile() {
        int result;
        File chosenFile = null;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(null);
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File("report_depotchecker.txt"));
        int returnValue = fc.showSaveDialog(Globals.g_wizard.getFrame());
        if (returnValue != 0) {
            return;
        }
        chosenFile = fc.getSelectedFile();
        if (chosenFile == null) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.BadSave.txt"), this.bundle.getString("Common.Warning.txt"), 2);
            return;
        }
        String chosenFileString = chosenFile.getAbsolutePath();
        if (!chosenFileString.endsWith(".txt") && !chosenFileString.endsWith(".txt")) {
            chosenFile = new File(chosenFileString + ".txt");
        }
        if (chosenFile.exists() && (result = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.FileExists.txt"), this.bundle.getString("Common.Warning.txt"), 2, 3, 0)) != 0) {
            return;
        }
        this.writeReportFile(chosenFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReportFile(File chosenFile) {
        FileWriter reportFile = null;
        try {
            reportFile = new FileWriter(chosenFile);
            reportFile.write(this.m_depotReport.getText());
            this.displayMsg(this.bundle.messageString("PanelDepotChecker.ReportFileWritten.txt", chosenFile.getAbsoluteFile()));
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.BadSave.txt"), this.bundle.getString("Common.Warning.txt"), 2);
        }
        finally {
            try {
                reportFile.close();
            }
            catch (IOException e) {
                Logging.logStackTrace(e);
            }
        }
    }

    private void sendReportToBrowser() {
        OutputStreamWriter diffReportFile = null;
        try {
            File temp = File.createTempFile("report_depotchecker", ".htm");
            diffReportFile = new FileWriter(temp);
            diffReportFile.write("<html><body><pre>" + this.m_depotReport.getText().replaceAll("\\r\\n", "\n") + "</pre></body></html>");
            KitAction.launchWebBrowser(new URL("file://" + temp.getAbsolutePath()));
        }
        catch (Exception e1) {
            Logging.logStackTrace(e1);
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.BadBrowser"), this.bundle.getString("Common.Warning.txt"), 2);
        }
        finally {
            try {
                diffReportFile.close();
            }
            catch (IOException e2) {
                Logging.logStackTrace(e2);
            }
        }
    }

    private void printReport() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                Logging.logStackTrace(ex);
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.BadPrint"), this.bundle.getString("Common.Warning.txt"), 2);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().printAll(g);
        }
        return 0;
    }

    private void appendText(String msg) {
        Document doc = this.m_depotReport.getDocument();
        try {
            doc.insertString(doc.getLength(), msg, null);
        }
        catch (BadLocationException e) {
            Logging.logStackTrace(e);
        }
        this.m_depotReport.setCaretPosition(doc.getLength());
        this.m_depotReport.revalidate();
    }

    private void displayMsg(String msg) {
        if (msg == null) {
            msg = this.m_ls;
        } else {
            Logging.log.info(msg);
        }
        if (Globals.g_consoleMode) {
            ConsoleMode.println(msg);
        } else {
            msg = msg + this.m_ls;
            this.appendText(msg);
        }
    }

    private void reportProblem(Problem problem, String ... args) {
        String msg = null;
        switch (problem) {
            case BADDEPOT: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.BadDepot.txt", args[0]);
                this.displayMsg(msg);
                break;
            }
            case MISSINGFILE: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Report.MissingFiles.txt", args[0]);
                this.displayMsg(msg);
                --this.problemCount;
                break;
            }
            case BADSIZE: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Report.BadSize.txt", args[0], args[1], args[2]);
                this.displayMsg(msg);
                --this.problemCount;
                break;
            }
            case BADPERMISSION: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Report.BadPermissions.txt", args[0], args[1], args[2]);
                this.displayMsg(msg);
                break;
            }
            case BADVJR: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Report.BadVJR.txt", args[0]);
                this.displayMsg(msg);
                --this.problemCount;
                break;
            }
            case BADCHECKSUM: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Report.BadChecksum.txt", args[0], args[1], args[2]);
                this.displayMsg(msg);
                --this.problemCount;
                break;
            }
            case EXCEPTION: {
                msg = this.bundle.messageString("PanelDepotChecker.Problem.Exception.txt", args[0]);
                this.displayMsg(msg);
                --this.problemCount;
            }
        }
        if (this.problemCount == 0) {
            --this.problemCount;
            int result = CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelDepotChecker.MaxProblems.txt"), this.bundle.getString("Common.Warning.txt"), 0, 3, 0);
            if (result != 0) {
                if (Globals.g_reportFile != null) {
                    this.writeReportFile(new File(Globals.g_reportFile));
                }
                this.m_stopButton = true;
                this.m_processing = false;
            }
        }
    }

    private String normalize(String path) {
        String newPath = path;
        if ((newPath = newPath.replaceAll("\\\\", "/")).startsWith("./")) {
            newPath = newPath.substring(2);
        }
        return newPath;
    }

    private void timerEventProgressBar() {
        this.setProgressBarValue(this.m_fileCount);
        if (!this.m_processing) {
            if (this.m_finished) {
                this.m_progressBar.setValue(100);
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelDepotChecker.FinishHeader.txt"));
                Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelDepotChecker.FinishHeaderDesc.txt"));
                this.m_scanType.setText(null);
                this.m_orderListInstructions.setText(this.bundle.getString("PanelDepotChecker.GUI.Instructions.Finishing.txt"));
                this.displayMsg(this.bundle.messageString("PanelDepotChecker.Progress.Done.txt", this.depotFiles.size()));
            } else {
                this.m_progressBar.setValue(0);
                if (this.m_stopButton) {
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelDepotChecker.StoppedHeader.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelDepotChecker.StoppedHeaderDesc.txt"));
                    this.m_scanType.setText(null);
                    this.m_orderListInstructions.setText("PanelDepotChecker.GUI.Instructions.Finishing.txt");
                    this.m_scanners.interrupt();
                    try {
                        Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                        this.m_scanners.join();
                        Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
                    }
                    catch (InterruptedException e) {
                        Logging.logStackTrace(e);
                    }
                    this.displayMsg(this.bundle.getString("PanelDepotChecker.StoppedHeaderDesc.txt"));
                } else {
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelDepotChecker.ErrorHeader.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelDepotChecker.ErrorHeaderDesc.txt"));
                }
            }
            this.m_saveButton.setEnabled(true);
            this.m_browserButton.setEnabled(true);
            this.m_printButton.setEnabled(true);
            String mtxt = this.bundle.getString("PanelDepotChecker.FinishButton.txt");
            Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Globals.g_wizard.setWizardActive(false);
            Globals.g_wizard.enableButtons();
            this.m_timerProgressBar.stop();
        }
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().validate();
        }
    }

    private void timerEventScanFileName() {
        if (this.m_finished || !this.m_processing) {
            this.m_scanningFileName.setText("");
            this.m_timerScanFileName.stop();
        } else {
            this.m_scanningFileName.setText(this.m_currentFileName.toString());
        }
    }

    private String fullpath(String path) {
        return Utils.joinPath(this.m_depotLocation, path);
    }

    public class LaunchScannersByThread
    extends Thread {
        @Override
        public void run() {
            PanelDepotChecker.this.launchScanners();
        }
    }

    public class DepotCheckerException
    extends Exception {
        private static final long serialVersionUID = -1562150445476421900L;

        public DepotCheckerException() {
        }

        public DepotCheckerException(String message, Throwable cause) {
            super(message, cause);
        }

        public DepotCheckerException(String message) {
            super(message);
        }

        public DepotCheckerException(Throwable cause) {
            super(cause);
        }
    }

    public class DepotFileData {
        private FileStatus status = null;
        private long expectedSize = 0L;
        private long actualSize = 0L;
        private String expectedChecksum = null;
        private String actualChecksum = null;
        private int actualPermissions = -1;

        public DepotFileData() {
        }

        public DepotFileData(Long size, String checksum) {
            this.expectedSize = size;
            this.expectedChecksum = checksum;
            this.status = FileStatus.EXISTS_IN_DATA_ONLY;
        }

        public FileStatus getStatus() {
            return this.status;
        }

        public void setStatus(FileStatus status) {
            this.status = status;
        }

        public long getExpectedSize() {
            return this.expectedSize;
        }

        public void setExpectedSize(long expectedSize) {
            this.expectedSize = expectedSize;
        }

        public long getActualSize() {
            return this.actualSize;
        }

        public void setActualSize(long actualSize) {
            this.actualSize = actualSize;
        }

        public String getExpectedChecksum() {
            return this.expectedChecksum;
        }

        public void setExpectedChecksum(String expectedChecksum) {
            this.expectedChecksum = expectedChecksum;
        }

        public String getActualChecksum() {
            return this.actualChecksum;
        }

        public void setActualChecksum(String actualChecksum) {
            this.actualChecksum = actualChecksum;
        }

        public int getActualPermissions() {
            return this.actualPermissions;
        }

        public void setActualPermissions(int actualPermissions) {
            this.actualPermissions = actualPermissions;
        }
    }

    public class VjrEH
    implements VJREventHandler {
        @Override
        public VJREventHandler.Action notify(VJREvent vjre) {
            if (vjre.getEventType() == VJREvent.EventType.VALIDATION) {
                PanelDepotChecker.this.m_fileCount++;
                Logging.log.fine(vjre.getMessage());
            }
            if (Thread.currentThread().isInterrupted() || PanelDepotChecker.this.m_stopButton) {
                return VJREventHandler.Action.ABORT;
            }
            return VJREventHandler.Action.CONTINUE;
        }
    }

    private static enum FileStatus {
        EXISTS_IN_DATA_ONLY,
        EXISTS_IN_BOTH,
        EXISTS_IN_DEPOT_ONLY;

    }

    private static enum Problem {
        BADDEPOT,
        MISSINGFILE,
        BADSIZE,
        BADPERMISSION,
        BADVJR,
        BADCHECKSUM,
        EXCEPTION;

    }
}

