/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.metadata.remote.TextStore;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DatabaseAccess;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.utils.DynamicJDBCDriver;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PanelConnectionDatabase
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelConnectionDatabase.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_hostnameLabel = null;
    private KitTextField m_hostnameField = null;
    private JLabel m_userLabel = null;
    private KitTextField m_userField = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_passwordField = null;
    private String m_prevConfigDir = "";
    private String m_wipURL = null;
    private String m_dataType = null;
    private String m_hostname_label = this.bundle.getString("PanelConnectionDatabase.HostnameLabel.txt");
    private String m_userid_label = this.bundle.getString("PanelConnectionDatabase.UserLabel.txt");
    private String m_password_label = this.bundle.getString("PanelConnectionDatabase.PasswordLabel.txt");

    public PanelConnectionDatabase() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelConnectionDatabase.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelConnectionDatabase.HeaderDesc.txt");
    }

    private String getWipUrl() {
        String query = "<XMLSelect search=\"TextStore[@Name='Public Configuration Properties'][Objects/SoftwareComponent[@ClassIdentifier='webappsrv']]\" />";
        List components = MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "TextStore", query);
        if (components.isEmpty()) {
            Logging.log.severe("No TextStores were returned for XMLSelect: " + query);
        }
        return MetadataAccess.getTextStoreProperty((TextStore)components.get(0), "webappsrv.jdbc.url");
    }

    private String getDBType() {
        String query = "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='webinfpltfm']\"/>";
        String dataType = MetadataAccess.propQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, query, "data.dbms.type", "");
        if (dataType == null) {
            Logging.log.severe("Could not find WIP Database Type.");
        }
        return dataType;
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String host = null;
        String user = null;
        String password = null;
        String errMsg = null;
        JTextField focusObj = null;
        host = this.m_hostnameField.getText().trim();
        this.m_hostnameField.setText(host);
        user = this.m_userField.getText().trim();
        this.m_userField.setText(user);
        password = String.valueOf(this.m_passwordField.getPassword());
        if (!SasPasswordString.isEncoded(password)) {
            try {
                password = SasPasswordString.encode("sas002", password);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        if (valid & host.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "DATABASE_HOST");
            } else {
                focusObj = this.m_hostnameField;
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", Util.getLabelWithoutMnemonic(this.m_hostname_label));
            }
        }
        if (valid && user.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "DATABASE_USER");
            } else {
                focusObj = this.m_userField;
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", Util.getLabelWithoutMnemonic(this.m_userid_label));
            }
        }
        if (valid && !Globals.g_skipDatabaseCheck) {
            if (this.m_dataType != null) {
                int start = this.m_dataType.equalsIgnoreCase("oracle") ? this.m_wipURL.indexOf("@") + 1 : this.m_wipURL.indexOf("//") + 2;
                int end = this.m_wipURL.indexOf(":", start);
                String beforeHost = this.m_wipURL.substring(0, start);
                String afterHost = this.m_wipURL.substring(end);
                String newWipURL = beforeHost + host + afterHost;
                if (!newWipURL.equals(this.m_wipURL)) {
                    Logging.log.info("Host name doesn't match: Using New WIP URL: " + newWipURL);
                    this.m_wipURL = newWipURL;
                }
            } else {
                Logging.log.severe("Could not find WIP Database Type. Using WIP URL: " + this.m_wipURL);
            }
            valid = DatabaseAccess.testConnection(this.m_wipURL, user, password);
            if (!valid) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "DATABASE_PASSWORD", "", "Unable to connect to the database with the specified connection information.");
                } else {
                    focusObj = this.m_passwordField;
                    errMsg = this.bundle.getString("PanelConnectionDatabase.UnableToConnectMsg.txt");
                }
            }
        }
        if (valid) {
            Globals.g_databaseUser = user;
            Globals.g_databasePassword = password;
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (focusObj != null) {
                focusObj.requestFocus();
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (Globals.g_cmtTask == 0) {
            panelID = "selectusers";
        } else if (Globals.g_cmtTask == 4) {
            panelID = "changehost";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (Globals.g_cmtConfigDir != null && !this.m_prevConfigDir.equals(Globals.g_cmtConfigDir)) {
            String user;
            this.m_hostnameField.setText("");
            this.m_userField.setText("");
            this.m_passwordField.setText("");
            this.loadResponseData();
            this.m_wipURL = this.getWipUrl();
            this.m_dataType = this.getDBType();
            if (this.m_hostnameField.getText().length() == 0) {
                if (this.m_wipURL != null) {
                    if (this.m_dataType != null) {
                        int end;
                        int start = this.m_dataType.equalsIgnoreCase("oracle") ? this.m_wipURL.indexOf("@") + 1 : this.m_wipURL.indexOf("//") + 2;
                        String host = this.m_wipURL.substring(start, end = this.m_wipURL.indexOf(":", start));
                        if (host != null) {
                            Logging.log.info("WIP URL: " + this.m_wipURL);
                            this.m_hostnameField.setText(host);
                        }
                    } else {
                        Logging.log.severe("Could not find WIP Database Type.");
                    }
                } else {
                    Logging.log.severe("Could not find WIP URL. Found: " + this.m_wipURL);
                }
            }
            if (this.m_userField.getText().length() == 0 && (user = MetadataAccess.propQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='webinfpltfm']\"/>", "dbms.biservmid.userid", "")) != null) {
                this.m_userField.setText(user);
            }
            this.loadJdbcJar();
            this.m_prevConfigDir = Globals.g_cmtConfigDir;
        }
    }

    public void loadJdbcJar() {
        URLClassLoader urlClassLoader = null;
        String dbmsDriver = null;
        String dbmsDir = MetadataAccess.propQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='webinfpltfm']\"/>", "dbms.biservmid.jdbc.dir", "");
        if (null != dbmsDir) {
            Logging.log.info("Database directory with JDBC jar: '" + dbmsDir + "'");
            File dbmsDirFile = new File(dbmsDir);
            if (dbmsDirFile.isDirectory()) {
                File[] files = dbmsDirFile.listFiles();
                if (null != files) {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        Logging.log.info("Adding jar to the JDBC Classloader: '" + files[i].getAbsolutePath() + "'");
                        try {
                            urls.add(files[i].toURI().toURL());
                            continue;
                        }
                        catch (Exception e) {
                            Logging.log.severe("Unable to add a database driver file as a URL '" + files[i].getAbsolutePath() + "' to the ArrayList: " + e.getMessage());
                            Logging.logStackTrace(e);
                        }
                    }
                    URL[] urlss = new URL[urls.size()];
                    urlss = urls.toArray(urlss);
                    urlClassLoader = URLClassLoader.newInstance(urlss, Thread.currentThread().getContextClassLoader());
                } else {
                    Logging.log.warning("No files were found in Database driver dir:  '" + dbmsDir + "'");
                }
            } else {
                Logging.log.warning("Database driver dir is not a directory:  '" + dbmsDir + "'");
            }
        } else {
            Logging.log.warning("Database driver dir is null, unable to load the JDBC driver");
        }
        if (null != this.m_dataType) {
            if (this.m_dataType.equalsIgnoreCase("sasTransactional")) {
                dbmsDriver = "com.sas.tkts.TKTSDriver";
            } else if (this.m_dataType.equalsIgnoreCase("mysqldbs")) {
                dbmsDriver = "com.mysql.cj.jdbc.Driver";
            } else if (this.m_dataType.equalsIgnoreCase("oracle")) {
                dbmsDriver = "oracle.jdbc.OracleDriver";
            } else if (this.m_dataType.equalsIgnoreCase("db2")) {
                dbmsDriver = "com.ibm.db2.jcc.DB2Driver";
            } else if (this.m_dataType.equalsIgnoreCase("postgres")) {
                dbmsDriver = "org.postgresql.Driver";
            } else if (this.m_dataType.equalsIgnoreCase("sqlserver")) {
                dbmsDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            } else {
                Logging.log.warning("Database type is unrecognized: '" + this.m_dataType + "'");
            }
        } else {
            Logging.log.warning("Database type is null, unable to load the JDBC driver");
        }
        if (null != urlClassLoader && null != dbmsDriver) {
            Logging.log.info("Registering the JDBC Classloader with the DriverManger for driver: '" + dbmsDriver + "'");
            DynamicJDBCDriver.registerDriver(urlClassLoader, dbmsDriver);
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JTextField focus = null;
        if (this.m_hostnameField.isEditable()) {
            focus = this.m_hostnameField;
        } else if (this.m_userField.getText().length() == 0) {
            focus = this.m_userField;
        } else if (this.m_passwordField.isEditable()) {
            focus = this.m_passwordField;
        }
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.m_wipURL = this.getWipUrl();
            this.m_dataType = this.getDBType();
            this.loadJdbcJar();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#DATABASE_HOST=<host name value>", " DATABASE_HOST=", "#DATABASE_USER=<user name value>", " DATABASE_USER=", "#DATABASE_PASSWORD=<password value>", " DATABASE_PASSWORD="};
        data[1] = " DATABASE_HOST=" + this.m_hostnameField.getText();
        data[3] = " DATABASE_USER=" + this.m_userField.getText();
        String value = String.valueOf(this.m_passwordField.getPassword());
        try {
            if (!SasPasswordString.isEncoded(value)) {
                value = SasPasswordString.encode("sas002", value);
            }
            data[5] = " DATABASE_PASSWORD=" + value;
        }
        catch (Exception e) {
            Logging.log.severe("Unable to encode the password for: DATABASE_PASSWORD");
            Logging.logStackTrace(e);
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_hostnameLabel.getText(), this.m_hostnameField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_userLabel.getText(), this.m_userField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_passwordField);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (valid) {
            String responseHost = Wizard.getResponse("DATABASE_HOST", null);
            if (responseHost != null) {
                this.m_hostnameField.setText(responseHost);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "DATABASE_HOST");
            }
        }
        if (valid) {
            String responseUser = Wizard.getResponse("DATABASE_USER", null);
            if (responseUser != null) {
                this.m_userField.setText(responseUser);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "DATABASE_USER");
            }
        }
        if (valid) {
            String response = Wizard.getResponse("DATABASE_PASSWORD", null);
            if (response != null) {
                String decodedPassword = null;
                try {
                    decodedPassword = SasPasswordString.decode(response);
                    this.m_passwordField.setText(decodedPassword);
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to decode the password for: DATABASE_PASSWORD");
                    Logging.logStackTrace(e);
                }
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "DATABASE_PASSWORD");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_hostnameField = new KitTextField();
        this.m_hostnameField.setEditable(true);
        this.m_hostnameLabel = this.setLabel(this.m_hostnameLabel, this.m_hostnameField, this.m_hostname_label);
        this.m_userField = new KitTextField();
        this.m_userLabel = this.setLabel(this.m_userLabel, this.m_userField, this.m_userid_label);
        this.m_passwordField = new JPasswordField();
        this.m_passwordLabel = this.setLabel(this.m_passwordLabel, this.m_passwordField, this.m_password_label);
    }

    private JLabel setLabel(JLabel label, JTextField field, String property) {
        label = new JLabel(Util.getLabelWithoutMnemonic(property));
        label.setDisplayedMnemonic(Util.getDisplayedMnemonic(property));
        label.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(property));
        label.setLabelFor(field);
        return label;
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        this.m_hostnameLabel = this.setLabel(this.m_hostnameLabel, this.m_hostnameField, this.m_hostname_label);
        this.m_panel.add((Component)this.m_hostnameLabel, c);
        c.gridy = 1;
        this.m_panel.add((Component)this.m_hostnameField, c);
        c.gridy = 2;
        this.m_userLabel = this.setLabel(this.m_userLabel, this.m_userField, this.m_userid_label);
        this.m_panel.add((Component)this.m_userLabel, c);
        c.gridy = 3;
        this.m_panel.add((Component)this.m_userField, c);
        c.gridy = 4;
        this.m_passwordLabel = this.setLabel(this.m_passwordLabel, this.m_passwordField, this.m_password_label);
        this.m_panel.add((Component)this.m_passwordLabel, c);
        c.gridy = 5;
        this.m_panel.add((Component)this.m_passwordField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

