/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConfigureDefaults;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.InstanceData;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PanelConnection
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelConnection.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_hostLabel = null;
    private KitTextField m_hostField = null;
    private JLabel m_portLabel = null;
    private KitTextField m_portField = null;
    private JLabel m_userLabel = null;
    private KitTextField m_userField = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_passwordField = null;
    private String m_hostnameFromMetadata = null;
    private boolean m_panelLoaded = false;
    private int m_prevTask = -1;
    private String m_prevConfigDir = "";
    private String m_responseHost = null;
    private String m_responsePort = null;
    private String m_responseUser = null;

    public PanelConnection() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelConnection.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelConnection.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String host = null;
        String port = null;
        String user = null;
        String password = null;
        String errMsg = null;
        JTextField focusObj = null;
        host = this.m_hostField.getText().trim();
        this.m_hostField.setText(host);
        port = this.m_portField.getText().trim();
        this.m_portField.setText(port);
        user = this.m_userField.getText().trim();
        this.m_userField.setText(user);
        password = String.valueOf(this.m_passwordField.getPassword());
        if (!SasPasswordString.isEncoded(password)) {
            try {
                password = SasPasswordString.encode("sas002", password);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        if (host.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONNECT_HOST");
            } else {
                focusObj = this.m_hostField;
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelConnection.HostFieldName.txt"));
            }
        }
        if (valid && port.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONNECT_PORT");
            } else {
                focusObj = this.m_portField;
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelConnection.PortFieldName.txt"));
            }
        }
        if (valid && user.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONNECT_USER");
            } else {
                focusObj = this.m_userField;
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelConnection.UserFieldName.txt"));
            }
        }
        if (valid && this.checkStatusFileForCode("metadatasrv") && !Globals.g_skipPortCheck) {
            int portNum = 0;
            try {
                portNum = Integer.parseInt(port);
                if (!Utils.isPortListening(host, portNum)) {
                    if (this.restartMetadataServer(host, portNum)) {
                        Logging.log.info("The metadata server was successfully restarted.  Host: " + host + "  Port: " + port);
                    } else {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "CONNECT_PORT", port, "A SAS Metadata Server is not currently running on the Port.");
                        } else {
                            focusObj = this.m_passwordField;
                            errMsg = this.bundle.getString("PanelConnection.ServerNotRunning.txt");
                        }
                    }
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        if (valid && !(valid = MetadataAccess.testConnection(host, port, user, password)) && !Globals.g_quietMode) {
            focusObj = this.m_passwordField;
            errMsg = this.bundle.getString("PanelConnection.UnableToConnectMsg.txt");
        }
        if (valid && !(valid = MetadataAccess.isMetadataAdmin(host, port, user, password))) {
            if (Globals.g_skipAdminCheck) {
                Logging.log.warning("The connection User ID is not an unrestricted user.  The -skipadmincheck option was used to bypass the restriction.");
                valid = true;
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CONNECT_USER", user, "The specified User ID is not an unrestricted user and must be an unrestricted user to perform this task.");
            } else {
                focusObj = this.m_userField;
                errMsg = this.bundle.getString("PanelConnection.UnrestrictedUserRequired.txt");
            }
        }
        if (valid) {
            Globals.g_cmtConnectHost = host;
            Globals.g_cmtConnectPort = port;
            Globals.g_cmtConnectUser = user;
            Globals.g_cmtConnectPassword = password;
            Globals.g_msConfigured = true;
            Globals.g_cmtRunConfigure = true;
            if (Globals.g_cmtNewConfigDir) {
                Globals.g_cmtConnectRepos = MetadataAccess.getRepositoryName(host, port, user, password);
            }
            Globals.g_propertyOwners = new HashMap();
            if (Globals.g_configDefaults == null) {
                Globals.g_configDefaults = new ConfigureDefaults();
            }
            Globals.g_configData.calculateProperties();
            if (Globals.g_cmtTask == 0) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "password");
            } else if (Globals.g_cmtTask == 1) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "rebuild");
            } else if (Globals.g_cmtTask == 34) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "deploywebapps");
            } else if (Globals.g_cmtTask == 2) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "remove");
            } else if (Globals.g_cmtTask == 3) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "updatesid");
            } else if (Globals.g_cmtTask == 4) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "changehost");
            } else if (Globals.g_cmtTask == 5) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "maint");
            } else if (Globals.g_cmtTask == 26) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "addservers");
            } else if (Globals.g_cmtTask == 27) {
                Globals.g_configData.setSDWProperty("wizard.manager.task", "changepassphrase");
            } else {
                Globals.g_configData.setSDWProperty("wizard.manager.task", Globals.g_cmtTaskName);
            }
            if (Globals.g_cmtTask == 3 || Globals.g_cmtTask == 4 || Globals.g_cmtTask == 52 || Globals.g_cmtTask == 49 || Globals.g_cmtTask == 5 || Globals.g_cmtTask == 27 || Globals.g_mode == 5) {
                this.loadStatusFile();
            } else if (Globals.g_cmtTask == 26) {
                this.loadMachineList();
            }
            Globals.g_configData.loadMachineConfiguredList();
            if (Globals.g_cmtTask == 5) {
                Globals.g_cmtDynamicProps = new HashMap();
                DynamicDialogs.loadSDMConfigDialogs();
            }
            if (Globals.g_dynamicInstallDialogs != null && Globals.g_dynamicInstallDialogs.length > 0) {
                File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
                InstanceData[] instanceData = MetadataAccess.getInstanceData(host, port, Globals.g_cmtConnectRepos, user, password, statusFile, true);
                for (int i = 0; i < instanceData.length; ++i) {
                    String code = instanceData[i].getCode();
                    if (code == null || !code.equalsIgnoreCase("levdirroot") || instanceData[i].getProperties() == null) continue;
                    this.m_hostnameFromMetadata = instanceData[i].getProperties().getProperty("os.localhost.fqdn.host.name");
                }
                if (Globals.g_cmtConnectHost != null) {
                    Globals.g_installData.setProperty("iomsrv.metadatasrv.host", Globals.g_cmtConnectHost);
                }
                if (Globals.g_cmtConnectPort != null) {
                    Globals.g_installData.setProperty("iomsrv.metadatasrv.port", Globals.g_cmtConnectPort);
                }
                if (Globals.g_cmtConnectUser != null) {
                    Globals.g_installData.setProperty("oma.person.admin.login.userid", Globals.g_cmtConnectUser);
                }
                if (Globals.g_cmtConnectPassword != null) {
                    Globals.g_installData.setProperty("oma.person.admin.login.passwd", Globals.g_cmtConnectPassword);
                }
                if (Globals.g_cmtConnectRepos != null) {
                    Globals.g_installData.setProperty("oma.repository.foundation.name", Globals.g_cmtConnectRepos);
                }
                if (this.m_hostnameFromMetadata != null) {
                    Globals.g_installData.setProperty("os.localhost.from.metadata", this.m_hostnameFromMetadata);
                }
                if (Globals.g_cmtConnectHost != null) {
                    Globals.g_installData.setProperty("metadata.connection.host", Globals.g_cmtConnectHost);
                }
                if (Globals.g_cmtConnectPort != null) {
                    Globals.g_installData.setProperty("metadata.connection.port", Globals.g_cmtConnectPort);
                }
                if (Globals.g_cmtConnectUser != null) {
                    Globals.g_installData.setProperty("metadata.connection.userid", Globals.g_cmtConnectUser);
                }
                if (Globals.g_cmtConnectPassword != null) {
                    Globals.g_installData.setProperty("metadata.connection.passwd", Globals.g_cmtConnectPassword);
                }
                if (Globals.g_cmtConnectRepos != null) {
                    Globals.g_installData.setProperty("metadata.connection.repository.name", Globals.g_cmtConnectRepos);
                }
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            if (focusObj != null) {
                focusObj.requestFocus();
            }
        }
        if (valid && Globals.g_cmtTask == 5 && this.m_hostnameFromMetadata != null && this.m_hostnameFromMetadata != "") {
            String localHostname = "";
            localHostname = Globals.g_fqHostNameOverride != null && Globals.g_fqHostNameOverride != "" ? Globals.g_fqHostNameOverride : ConfigureData.getDefaultHost();
            if (localHostname != "" && !localHostname.equalsIgnoreCase(this.m_hostnameFromMetadata)) {
                valid = false;
                errMsg = this.bundle.messageString("PanelConnection.LevdirrootHostnameMisaligns.txt", this.m_hostnameFromMetadata, localHostname);
            }
            if (!valid) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CONNECT_HOST", host, errMsg);
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Error.txt"), 0);
                }
            }
        }
        if (valid && Globals.g_cmtTask == 52) {
            valid = false;
            errMsg = this.bundle.getString("PanelConnection.AutoloadDeploymentInvalid.txt");
            if (Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax")) {
                Vector contextResults;
                String metaQuery = "<xmlselect search=\"SoftwareComponent[@ClassIdentifier='bihpgrdc']\"/>";
                Vector componentResults = (Vector)MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "SoftwareComponent", metaQuery);
                if (componentResults.size() > 0 && Globals.g_levdirrootFQID != null && (contextResults = (Vector)MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "ServerContext", metaQuery = "<xmlselect search=\"ServerContext[@PublicType='ApplicationServer'][DependsOnComponents/SoftwareComponent[@Id='" + Globals.g_levdirrootFQID + "']][DependentComponents/LogicalServer[@PublicType='LogicalServer.Workspace']]\"/>")).size() > 0) {
                    valid = true;
                }
            } else {
                errMsg = this.bundle.getString("PanelConnection.AutoloadHostInvalid.txt");
            }
            if (!valid) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CONNECT_HOST", host, this.bundle.getString("PanelConnection.AutoloadInvalid.txt"));
                } else {
                    focusObj = this.m_userField;
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Error.txt"), 0);
                }
                if (focusObj != null) {
                    focusObj.requestFocus();
                }
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (Globals.g_mode == 5) {
            panelID = "apprentice";
        } else if (Globals.g_cmtTask == 27) {
            panelID = "changepassphrase";
        } else if (Globals.g_cmtTask == 49) {
            panelID = "modifyhadoopcmetadata";
        } else if (Globals.g_cmtTask == 0) {
            panelID = this.checkStatusFileForCode("webinfpltfm") ? "connectiondatabase" : "selectusers";
        } else if (Globals.g_cmtTask == 11) {
            panelID = "selecthotfixinstances";
        } else if (Globals.g_cmtTask == 2) {
            panelID = "selectremoveinstances";
        } else if (Globals.g_cmtTask == 1) {
            panelID = "selectrebuildinstances";
        } else if (Globals.g_cmtTask == 34) {
            panelID = "warndeploywebapps";
        } else if (Globals.g_cmtTask == 3) {
            panelID = "selectsid";
        } else if (Globals.g_cmtTask == 4) {
            panelID = this.checkStatusFileForCode("webinfpltfm") ? "connectiondatabase" : "changehost";
        } else if (Globals.g_cmtTask == 52) {
            panelID = "autoloadlasrartifacts";
        } else if (Globals.g_cmtTask == 37) {
            panelID = "warnloadcontent";
        } else if (Globals.g_cmtTask == 38) {
            panelID = "selectupdatecontentinstances";
        } else if (Globals.g_cmtTask == 39) {
            panelID = "selectadjusturlsinstances";
        } else if (Globals.g_cmtTask == 5) {
            panelID = Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0 ? Globals.g_dynamicConfigDialogs[0] : "execute";
        } else if (Globals.g_cmtTask == 26) {
            panelID = "selectconfigs";
        }
        if (panelID == null && Globals.g_dynamicInstallDialogs != null && Globals.g_dynamicInstallDialogs.length > 0) {
            panelID = Globals.g_dynamicInstallDialogs[0];
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (Globals.g_cmtConfigDir != null && !this.m_prevConfigDir.equals(Globals.g_cmtConfigDir) || this.m_prevTask != Globals.g_cmtTask) {
            if (!this.m_panelLoaded) {
                this.loadResponseData();
                this.m_panelLoaded = true;
            }
            this.loadConfigProps();
            this.m_prevConfigDir = Globals.g_cmtConfigDir;
            this.m_prevTask = Globals.g_cmtTask;
        }
        if (Globals.g_cmtTask == 4 || Globals.g_mode == 5 || Globals.g_cmtTask == 35 || this.m_hostField.getText().length() == 0) {
            this.m_hostField.setEditable(true);
            this.m_hostField.setFocusable(true);
        } else {
            this.m_hostField.setEditable(false);
            this.m_hostField.setFocusable(false);
        }
        if (Globals.g_cmtTask == 4 || Globals.g_cmtTask == 35 || this.m_portField.getText().length() == 0) {
            this.m_portField.setEditable(true);
            this.m_portField.setFocusable(true);
        } else {
            this.m_portField.setEditable(false);
            this.m_portField.setFocusable(false);
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        String value;
        JTextField focus = null;
        if (this.m_hostField.isEditable() && this.m_hostField.getText().length() == 0) {
            focus = this.m_hostField;
        } else if (this.m_portField.isEditable() && this.m_portField.getText().length() == 0) {
            focus = this.m_portField;
        } else if (this.m_userField.isEditable() && this.m_userField.getText().length() == 0) {
            focus = this.m_userField;
        } else if (this.m_passwordField.isEditable() && (value = String.valueOf(this.m_passwordField.getPassword())).length() == 0) {
            focus = this.m_passwordField;
        }
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.loadConfigProps();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#CONNECT_HOST=<string value>", " CONNECT_HOST=", "#CONNECT_PORT=<port number value>", " CONNECT_PORT=", "#CONNECT_USER=<user name value>", " CONNECT_USER=", "#CONNECT_PASSWORD=<password value>", " CONNECT_PASSWORD="};
        if (this.m_panelLoaded) {
            data[1] = " CONNECT_HOST=" + this.m_hostField.getText();
            data[3] = " CONNECT_PORT=" + this.m_portField.getText();
            data[5] = " CONNECT_USER=" + this.m_userField.getText();
            String value = String.valueOf(this.m_passwordField.getPassword());
            try {
                if (!SasPasswordString.isEncoded(value)) {
                    value = SasPasswordString.encode("sas002", value);
                }
                data[7] = " CONNECT_PASSWORD=" + value;
            }
            catch (Exception e) {
                Logging.log.severe("Unable to encode the password for: CONNECT_PASSWORD");
                Logging.logStackTrace(e);
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfigProps() {
        boolean valid = true;
        boolean useConnectionFile = false;
        Properties connectionProps = new Properties();
        String connectionPropsFile = Utils.joinPath(Globals.g_cmtConfigDir, "Utilities", "metadata.connection.properties");
        try {
            File connectionFile = new File(connectionPropsFile);
            if (connectionFile.isFile()) {
                useConnectionFile = true;
                FileInputStream connectionInStream = new FileInputStream(connectionFile);
                connectionProps.load(connectionInStream);
                connectionInStream.close();
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading properties file: " + connectionPropsFile);
            Logging.logStackTrace(e);
        }
        Properties configProps = null;
        String configPropsFile = Utils.joinPath(Globals.g_cmtConfigDir, "Utilities", "configuration.properties");
        try {
            File propsFile = new File(configPropsFile);
            if (propsFile.isFile()) {
                FileInputStream fileInStream = new FileInputStream(propsFile);
                configProps = new Properties();
                configProps.load(fileInStream);
                fileInStream.close();
            } else if (Globals.g_cmtTask == 26) {
                this.m_hostField.setText("");
                this.m_portField.setText("");
                this.m_userField.setText("");
                this.m_passwordField.setText("");
                Globals.g_vjrHome = Utils.getVJRHome(Globals.g_cmtSASHome);
            } else {
                Logging.log.warning("Properties file does not exist: " + configPropsFile);
            }
        }
        catch (Exception e) {
            Logging.log.warning("Cannot load properties file: " + configPropsFile);
            Logging.logStackTrace(e);
        }
        if (!useConnectionFile && configProps == null) {
            valid = false;
        }
        if (valid) {
            if (this.m_responseHost == null) {
                String host = null;
                if (Globals.g_cmtTask == 4 && this.checkStatusFileForCode("metadatasrv")) {
                    host = ConfigureData.getDefaultHost();
                }
                if (host == null) {
                    if (useConnectionFile) {
                        host = connectionProps.getProperty("metadata.connection.host", null);
                    }
                    if (host == null && configProps != null) {
                        host = configProps.getProperty("iomsrv.metadatasrv.host", "");
                    }
                }
                this.m_hostField.setText(host);
            }
            if (this.m_responsePort == null) {
                String port = null;
                if (useConnectionFile) {
                    port = connectionProps.getProperty("metadata.connection.port", null);
                }
                if (port == null && configProps != null) {
                    port = configProps.getProperty("iomsrv.metadatasrv.port", "");
                }
                this.m_portField.setText(port);
            }
            if (this.m_responseUser == null) {
                String user = null;
                if (useConnectionFile) {
                    user = connectionProps.getProperty("metadata.connection.userid", null);
                }
                if (user == null && configProps != null) {
                    user = configProps.getProperty("oma.person.admin.login.userid", "");
                }
                this.m_userField.setText(user);
            }
            if (Globals.g_cmtTask == 5 && Globals.g_maintOrder != null) {
                Globals.g_order = Globals.g_maintOrder;
            } else if (Globals.g_cmtSASHome != null) {
                Globals.g_order = null;
                try (RegistryAccess registryAccess = null;){
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    if (registryAccess != null && registryAccess.open()) {
                        Globals.g_order = registryAccess.getLastOrder();
                    }
                }
                if (Globals.g_order == null) {
                    Globals.g_order = this.getGlobalRootOrder();
                }
            }
            if (useConnectionFile) {
                Globals.g_cmtConnectRepos = connectionProps.getProperty("metadata.connection.repository.name", null);
            }
            if (Globals.g_cmtConnectRepos == null && configProps != null) {
                Globals.g_cmtConnectRepos = configProps.getProperty("oma.repository.foundation.name", null);
            }
            Globals.g_vjrHome = Utils.getVJRHome(Globals.g_cmtSASHome);
            String configDirName = "";
            String configHomeDir = "";
            String configLevelName = "";
            String configLevelNum = "";
            if (useConnectionFile) {
                Globals.g_cmtConfigLogsDir = connectionProps.getProperty("config.lev.logs.configure.dir", null);
                configDirName = connectionProps.getProperty("config.dir.name", "");
                configHomeDir = connectionProps.getProperty("config.home.dir", "");
                configLevelName = connectionProps.getProperty("config.level.name", "");
                configLevelNum = connectionProps.getProperty("config.level.num", "");
            }
            if (Globals.g_cmtConfigLogsDir == null && configProps != null) {
                Globals.g_cmtConfigLogsDir = configProps.getProperty("config.lev.logs.configure.dir", null);
            }
            if (configDirName == "" && configProps != null) {
                configDirName = configProps.getProperty("config.dir.name", "");
            }
            Globals.g_configData.setProperty("config.dir.name", configDirName);
            if (configHomeDir == "" && configProps != null) {
                configHomeDir = configProps.getProperty("config.home.dir", "");
            }
            Globals.g_configData.setProperty("config.home.dir", configHomeDir);
            if (configLevelName == "" && configProps != null) {
                configLevelName = configProps.getProperty("config.level.name", "");
            }
            Globals.g_configData.setProperty("config.level.name", configLevelName);
            if (configLevelNum == "" && configProps != null) {
                configLevelNum = configProps.getProperty("config.level.num", "");
            }
            Globals.g_configData.setProperty("config.level.num", configLevelNum);
            if ((Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax") || Utils.getOS_Suffix().equals("mvs") && Globals.g_z64) && Globals.g_cmtSASHome != null) {
                try (RegistryAccess registryAccess = null;){
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    if (registryAccess != null && registryAccess.open()) {
                        ProductData sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", true);
                        String location = null;
                        if (sasinstallData != null && (location = registryAccess.getInstallLoc("sasinstall", sasinstallData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("sasinstall", "default");
                        }
                        if (location == null) {
                            if (Utils.getOS_Suffix().equals("wx6")) {
                                sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "win", true);
                                if (sasinstallData != null && (location = registryAccess.getInstallLoc("sasinstall", sasinstallData.getProdVersion(), "win")) == null) {
                                    location = registryAccess.getInstallLoc("sasinstall", "default", "win");
                                }
                                if (location != null) {
                                    Globals.g_sasinstallPlat = "win";
                                }
                            } else if (Utils.getOS_Suffix().equals("lax")) {
                                sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "lnx", true);
                                if (sasinstallData != null && (location = registryAccess.getInstallLoc("sasinstall", sasinstallData.getProdVersion(), "lnx")) == null) {
                                    location = registryAccess.getInstallLoc("sasinstall", "default", "lnx");
                                }
                                if (location != null) {
                                    Globals.g_sasinstallPlat = "lnx";
                                }
                            } else {
                                sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", "mvs", true);
                                if (sasinstallData != null && (location = registryAccess.getInstallLoc("sasinstall", sasinstallData.getProdVersion(), "z64")) == null) {
                                    location = registryAccess.getInstallLoc("sasinstall", "default", "z64");
                                }
                                if (location != null) {
                                    Globals.g_sasinstallPlat = "z64";
                                }
                            }
                        }
                        ProductData jmpData = Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", true);
                        location = null;
                        if (jmpData != null && (location = registryAccess.getInstallLoc("jmp", jmpData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("jmp", "default");
                        }
                        if (location == null) {
                            if (Utils.getOS_Suffix().equals("wx6")) {
                                jmpData = Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "win", true);
                                if (jmpData != null && (location = registryAccess.getInstallLoc("jmp", jmpData.getProdVersion(), "win")) == null) {
                                    location = registryAccess.getInstallLoc("jmp", "default", "win");
                                }
                                if (location != null) {
                                    Globals.g_jmpPlat = "win";
                                }
                            } else {
                                jmpData = Globals.g_deploymentData.getProduct(Globals.g_order, "jmp", "lnx", true);
                                if (jmpData != null && (location = registryAccess.getInstallLoc("jmp", jmpData.getProdVersion(), "lnx")) == null) {
                                    location = registryAccess.getInstallLoc("jmp", "default", "lnx");
                                }
                                if (location != null) {
                                    Globals.g_jmpPlat = "lnx";
                                }
                            }
                        }
                        ProductData pcfilesrvData = Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", true);
                        location = null;
                        if (pcfilesrvData != null && (location = registryAccess.getInstallLoc("pcfilesrv", pcfilesrvData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("pcfilesrv", "default");
                        }
                        if (location == null && Utils.getOS_Suffix().equals("wx6")) {
                            pcfilesrvData = Globals.g_deploymentData.getProduct(Globals.g_order, "pcfilesrv", "win", true);
                            if (pcfilesrvData != null && (location = registryAccess.getInstallLoc("pcfilesrv", pcfilesrvData.getProdVersion(), "win")) == null) {
                                location = registryAccess.getInstallLoc("pcfilesrv", "default", "win");
                            }
                            if (location != null) {
                                Globals.g_pcfilesrvPlat = "win";
                            }
                        }
                        ProductData eguideData = Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", true);
                        location = null;
                        if (eguideData != null && (location = registryAccess.getInstallLoc("eguide", eguideData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("eguide", "default");
                        }
                        if (location == null && Utils.getOS_Suffix().equals("wx6")) {
                            eguideData = Globals.g_deploymentData.getProduct(Globals.g_order, "eguide", "win", true);
                            if (eguideData != null && (location = registryAccess.getInstallLoc("eguide", eguideData.getProdVersion(), "win")) == null) {
                                location = registryAccess.getInstallLoc("eguide", "default", "win");
                            }
                            if (location != null) {
                                Globals.g_eguidePlat = "win";
                            }
                        }
                        ProductData msofficeintData = Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", true);
                        location = null;
                        if (msofficeintData != null && (location = registryAccess.getInstallLoc("msofficeint", msofficeintData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("msofficeint", "default");
                        }
                        if (location == null && Utils.getOS_Suffix().equals("wx6")) {
                            msofficeintData = Globals.g_deploymentData.getProduct(Globals.g_order, "msofficeint", "win", true);
                            if (msofficeintData != null && (location = registryAccess.getInstallLoc("msofficeint", msofficeintData.getProdVersion(), "win")) == null) {
                                location = registryAccess.getInstallLoc("msofficeint", "default", "win");
                            }
                            if (location != null) {
                                Globals.g_msofficeintPlat = "win";
                            }
                        }
                        ProductData msoffintvaData = Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", true);
                        location = null;
                        if (msoffintvaData != null && (location = registryAccess.getInstallLoc("msoffintva", msoffintvaData.getProdVersion())) == null) {
                            location = registryAccess.getInstallLoc("msoffintva", "default");
                        }
                        if (location == null && Utils.getOS_Suffix().equals("wx6")) {
                            msoffintvaData = Globals.g_deploymentData.getProduct(Globals.g_order, "msoffintva", "win", true);
                            if (msoffintvaData != null && (location = registryAccess.getInstallLoc("msoffintva", msoffintvaData.getProdVersion(), "win")) == null) {
                                location = registryAccess.getInstallLoc("msoffintva", "default", "win");
                            }
                            if (location != null) {
                                Globals.g_msoffintvaPlat = "win";
                            }
                        }
                    }
                }
            }
        }
        return valid;
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_hostLabel.getText(), this.m_hostField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_portLabel.getText(), this.m_portField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_userLabel.getText(), this.m_userField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptPassword(this.m_passwordLabel.getText(), this.m_passwordField);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        this.m_responseHost = Wizard.getResponse("CONNECT_HOST", null);
        if (this.m_responseHost != null) {
            this.m_hostField.setText(this.m_responseHost);
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CONNECT_HOST");
            }
        }
        if (valid) {
            this.m_responsePort = Wizard.getResponse("CONNECT_PORT", null);
            if (this.m_responsePort != null) {
                this.m_portField.setText(this.m_responsePort);
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONNECT_PORT");
                }
            }
        }
        if (valid) {
            this.m_responseUser = Wizard.getResponse("CONNECT_USER", null);
            if (this.m_responseUser != null) {
                this.m_userField.setText(this.m_responseUser);
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONNECT_USER");
                }
            }
        }
        if (valid) {
            String response = Wizard.getResponse("CONNECT_PASSWORD", null);
            if (response != null) {
                String decodedPassword = null;
                try {
                    decodedPassword = SasPasswordString.decode(response);
                    this.m_passwordField.setText(decodedPassword);
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to decode the password for: CONNECT_PASSWORD");
                    Logging.logStackTrace(e);
                }
            } else {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseMissing(this.getHeader(), "CONNECT_PASSWORD");
                }
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_hostField = new KitTextField();
        String mtxt = this.bundle.getString("PanelConnection.HostLabel.txt");
        this.m_hostLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_hostLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_hostLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_hostLabel.setLabelFor(this.m_hostField);
        this.m_portField = new KitTextField();
        mtxt = this.bundle.getString("PanelConnection.PortLabel.txt");
        this.m_portLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_portLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_portLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_portLabel.setLabelFor(this.m_portField);
        this.m_userField = new KitTextField();
        mtxt = this.bundle.getString("PanelConnection.UserLabel.txt");
        this.m_userLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_userLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_userLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_userLabel.setLabelFor(this.m_userField);
        this.m_passwordField = new JPasswordField();
        mtxt = this.bundle.getString("PanelConnection.PasswordLabel.txt");
        this.m_passwordLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_passwordLabel.setLabelFor(this.m_passwordField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        this.m_panel.add((Component)this.m_hostLabel, c);
        c.gridy = 1;
        this.m_panel.add((Component)this.m_hostField, c);
        c.gridy = 2;
        this.m_panel.add((Component)this.m_portLabel, c);
        c.gridy = 3;
        this.m_panel.add((Component)this.m_portField, c);
        c.gridy = 4;
        this.m_panel.add((Component)this.m_userLabel, c);
        c.gridy = 5;
        this.m_panel.add((Component)this.m_userField, c);
        c.gridy = 6;
        this.m_panel.add((Component)this.m_passwordLabel, c);
        c.gridy = 7;
        this.m_panel.add((Component)this.m_passwordField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void loadMachineList() {
        Globals.g_cmtAddObjectSpawnr = true;
        Globals.g_cmtMachineList = new ArrayList();
        File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
        InstanceData[] instanceData = MetadataAccess.getInstanceData(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, statusFile, true);
        String code = null;
        for (int i = 0; i < instanceData.length; ++i) {
            code = instanceData[i].getCode();
            Globals.g_cmtMachineList.add(code);
            if (code.equalsIgnoreCase("levdirroot")) {
                Globals.g_configData.setProperty("levdirroot.configobj.fqid", instanceData[i].getFQID());
                continue;
            }
            if (!code.equalsIgnoreCase("objectspawnr")) continue;
            Globals.g_cmtAddObjectSpawnr = false;
        }
    }

    private void loadStatusFile() {
        Globals.g_planConfigs = null;
        if (Globals.g_cmtTask == 5 || Globals.g_mode == 5) {
            Globals.g_cmtPersistedProps = new HashMap();
        }
        if (Globals.g_configDefaults == null) {
            Globals.g_configDefaults = new ConfigureDefaults();
        }
        DynamicDialogs.loadDialogDefaults(null, 0);
        File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
        if (Globals.g_cmtTask == 5) {
            MetadataAccess.postBIMigration(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, statusFile.getPath());
        }
        InstanceData[] instanceData = MetadataAccess.getInstanceData(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, statusFile, true);
        ArrayList<String> planConfigs = null;
        if (Globals.g_cmtTask == 5) {
            planConfigs = new ArrayList<String>();
            try {
                Globals.g_configStatus = new ConfigStatus(statusFile);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        ArrayList<ProductData> instances = new ArrayList<ProductData>();
        Properties props = null;
        SpsSkuData skuData = null;
        String spsSku = null;
        String[] spsSkus = null;
        String code = null;
        String hotfix = null;
        String hotfixdate = null;
        String order = null;
        String key = null;
        String value = null;
        for (int i = 0; i < instanceData.length; ++i) {
            String[] codeList;
            ProductData[] productData;
            code = instanceData[i].getCode();
            order = instanceData[i].getOrder();
            hotfix = instanceData[i].getHotFix();
            hotfixdate = instanceData[i].getHotFixDate();
            spsSkus = null;
            if (code.equalsIgnoreCase("globalroot")) {
                String[] codeList2 = new String[]{"cfgwizard"};
                ProductData[] productData2 = Globals.g_deploymentData.getConfigured(order, codeList2, true);
                if (productData2 != null && productData2.length == 1) {
                    productData2[0].setInstanceData(instanceData[i]);
                    instances.add(productData2[0]);
                    if (Globals.g_cmtTask == 5) {
                        skuData = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "cfgwizard", Utils.getOS_Suffix(), true);
                        spsSku = skuData.getSpsSku();
                        spsSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("triggers_install", spsSku, Utils.getOS_Suffix());
                    }
                }
                Globals.g_globalrootFQID = instanceData[i].getFQID();
                code = "cfgwizard";
            } else if (code.equalsIgnoreCase("levdirroot")) {
                Globals.g_levdirrootFQID = instanceData[i].getFQID();
                Globals.g_levdirrootProps = instanceData[i].getProperties();
                code = "cfgwizard";
                if (instanceData[i].getProperties() != null) {
                    this.m_hostnameFromMetadata = instanceData[i].getProperties().getProperty("os.localhost.fqdn.host.name");
                }
            } else if (!code.equalsIgnoreCase("cfgwizard") && (productData = Globals.g_deploymentData.getConfigured(order, codeList = new String[]{code}, true)) != null && productData.length == 1) {
                if (Globals.g_cmtTask == 5) {
                    skuData = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, code, Utils.getOS_Suffix(), true);
                    if (skuData != null) {
                        productData[0].setInstanceData(instanceData[i]);
                        if (!Globals.g_DocUpdate || code.equalsIgnoreCase("webdocmd") || Utils.isWebAppServerCode(code)) {
                            instances.add(productData[0]);
                            Logging.log.fine("To reconfig doc product only: " + code);
                        }
                        spsSku = skuData.getSpsSku();
                        spsSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("triggers_install", spsSku, Utils.getOS_Suffix());
                    } else {
                        Logging.log.warning("Product data for code " + code + " is not available in order " + Globals.g_order + ".  This product cannot be updated with this order.");
                    }
                } else {
                    productData[0].setInstanceData(instanceData[i]);
                    instances.add(productData[0]);
                }
            }
            if (planConfigs != null) {
                boolean found = false;
                for (int j = 0; j < planConfigs.size() && !found; ++j) {
                    if (!code.equalsIgnoreCase((String)planConfigs.get(j))) continue;
                    found = true;
                }
                if (!found) {
                    planConfigs.add(code);
                }
            }
            if ((props = instanceData[i].getProperties()) == null) continue;
            if (Utils.isWebAppServerCode(code) && (value = props.getProperty("webappsrv.auto_configure", "")).equalsIgnoreCase("FALSE")) {
                props.setProperty("webapp.auto_deploy", "FALSE");
            }
            if (Globals.g_cmtTask != 5 && Globals.g_mode != 5) continue;
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = props.getProperty(key, null);
                if (value == null) continue;
                Globals.g_configData.setProperty(key, value);
                Globals.g_cmtPersistedProps.put(key, value);
            }
            if (spsSkus == null || planConfigs == null) continue;
            boolean valid = false;
            int instCount = 0;
            String prodCode = null;
            String objType = null;
            String classID = null;
            String xmlSelect = null;
            String[] reqSkus = null;
            ArrayList<String> codeList3 = new ArrayList<String>();
            RegistryAccess regAccess = null;
            for (int j = 0; j < spsSkus.length; ++j) {
                int k;
                reqSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("any_machine_config", spsSkus[j], Utils.getOS_Suffix());
                if (reqSkus != null && reqSkus.length > 0) {
                    valid = false;
                    for (k = 0; k < reqSkus.length && !valid; ++k) {
                        prodCode = Globals.g_deploymentData.getSpsSku(reqSkus[k]).getProdCode();
                        objType = Globals.g_configDefaults.getDefault(prodCode + ".configobj.type", "SoftwareComponent");
                        classID = Globals.g_configDefaults.getDefault(prodCode + ".configobj.classid", prodCode);
                        xmlSelect = "<XMLSelect search=\"" + objType + "[@ClassIdentifier='" + classID + "']\"/>";
                        try {
                            instCount = Integer.parseInt(MetadataAccess.instCount(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, xmlSelect));
                        }
                        catch (Exception e2) {
                            instCount = 0;
                        }
                        valid = instCount > 0;
                    }
                } else {
                    valid = true;
                }
                if (valid && (reqSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("same_machine_install", spsSkus[j], Utils.getOS_Suffix())) != null && reqSkus.length > 0) {
                    valid = false;
                    for (k = 0; k < reqSkus.length && !valid; ++k) {
                        prodCode = Globals.g_deploymentData.getSpsSku(reqSkus[k]).getProdCode();
                        try {
                            if (regAccess == null) {
                                File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                                regAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                            }
                            if (regAccess == null || !regAccess.open()) continue;
                            String[] hosts = regAccess.getInstallHosts();
                            for (int l = 0; l < hosts.length && !valid; ++l) {
                                String[] versions = regAccess.getInstallVersions(prodCode, hosts[l]);
                                if (versions == null || versions.length <= 0) continue;
                                valid = true;
                            }
                            continue;
                        }
                        catch (Exception e3) {
                            Logging.logStackTrace(e3);
                        }
                    }
                }
                if (!valid) continue;
                codeList3.add(Globals.g_deploymentData.getSpsSku(spsSkus[j]).getProdCode());
            }
            if (regAccess != null) {
                regAccess.close();
            }
            boolean found = false;
            String productCode = null;
            ProductData[] productData3 = Globals.g_deploymentData.getConfigured(Globals.g_order, codeList3.toArray(new String[0]), true);
            for (int j = 0; j < productData3.length; ++j) {
                int k;
                productCode = productData3[j].getProdCode();
                found = false;
                for (k = 0; k < instanceData.length && !found; ++k) {
                    if (!productCode.equalsIgnoreCase(instanceData[k].getCode())) continue;
                    found = true;
                }
                if (!found) {
                    for (k = 0; k < planConfigs.size() && !found; ++k) {
                        if (!productCode.equalsIgnoreCase((String)planConfigs.get(k))) continue;
                        found = true;
                    }
                }
                if (found) continue;
                planConfigs.add(productCode);
                InstanceData data = new InstanceData(productCode, productCode, Globals.g_order, hotfix, hotfixdate, null);
                data.setNewProduct(true);
                productData3[j].setInstanceData(data);
                if (Globals.g_DocUpdate && !code.equalsIgnoreCase("webdocmd") && !Utils.isWebAppServerCode(code)) continue;
                instances.add(productData3[j]);
            }
        }
        Globals.g_instances = instances.toArray(new ProductData[0]);
        if (planConfigs != null) {
            Globals.g_planConfigs = planConfigs.toArray(new String[0]);
        }
        if (Globals.g_cmtTask == 5) {
            ProductData[] productData = Globals.g_deploymentData.getConfigured(Globals.g_order, new String[]{"cfgwizard"}, true);
            if (productData != null && productData.length == 1) {
                Globals.g_cmtToDialogVer = Float.parseFloat(productData[0].getProdCustVersion());
            }
            if (Globals.g_overrideDialogVersion != null) {
                try {
                    Globals.g_cmtFromDialogVer = Float.parseFloat(Globals.g_overrideDialogVersion);
                }
                catch (Exception e) {
                    Globals.g_cmtFromDialogVer = Globals.g_cmtToDialogVer;
                }
            } else {
                Globals.g_cmtFromDialogVer = Globals.g_cmtToDialogVer;
                String configTargetsList = Globals.g_configDefaults.getDefault("cfgwizard.applyMaint.target.list", "");
                String[] configTargets = configTargetsList.split(" ");
                boolean isCalled = false;
                String target = null;
                Object productDataDir = null;
                Object prodDefaultsDir = null;
                Object propertyFile = null;
                Object propsFile = null;
                Object fileInStream = null;
                Object configDefaults = null;
                for (int i = 0; i < Globals.g_instances.length; ++i) {
                    Float fromVersion;
                    isCalled = false;
                    for (int j = 0; j < configTargets.length && !isCalled; ++j) {
                        target = configTargets[j];
                        isCalled = Globals.g_configDefaults.getDefault(Globals.g_instances[i].getProdCode() + "." + target + ".target.is_called", "FALSE").equalsIgnoreCase("TRUE");
                    }
                    if (!isCalled || (productData = Globals.g_deploymentData.getConfigured(Globals.g_instances[i].getInstanceData().getOrder(), new String[]{"cfgwizard"}, true)) == null || productData.length != 1 || !((fromVersion = Float.valueOf(Float.parseFloat(productData[0].getProdCustVersion()))).floatValue() < Globals.g_cmtFromDialogVer)) continue;
                    Globals.g_cmtFromDialogVer = fromVersion.floatValue();
                }
            }
            Logging.log.fine("Dynamic dialog version from: " + Float.toString(Globals.g_cmtFromDialogVer));
            Logging.log.fine("Dynamic dialog version to: " + Float.toString(Globals.g_cmtToDialogVer));
        } else {
            Globals.g_cmtToDialogVer = 0.0f;
            Globals.g_cmtFromDialogVer = 0.0f;
        }
    }

    private boolean checkStatusFileForCode(String prodcode) {
        boolean found = false;
        File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
        try {
            ConfigStatus status = new ConfigStatus(statusFile);
            ConfigStatus.StatusEntry[] statusEntries = status.getStatusEntries();
            String code = null;
            for (int i = 0; i < statusEntries.length && !found; ++i) {
                code = statusEntries[i].getCode();
                if (!code.equalsIgnoreCase(prodcode)) continue;
                found = true;
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return found;
    }

    private String getGlobalRootOrder() {
        String order = null;
        File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
        try {
            ConfigStatus status = new ConfigStatus(statusFile);
            ConfigStatus.StatusEntry[] statusEntries = status.getStatusEntries();
            String code = null;
            for (int i = 0; i < statusEntries.length && order == null; ++i) {
                code = statusEntries[i].getCode();
                if (code == null || !code.equalsIgnoreCase("globalroot")) continue;
                order = statusEntries[i].getOrder();
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restartMetadataServer(String host, int port) {
        boolean valid;
        block23: {
            valid = false;
            FileInputStream fileInStream = null;
            String connectionFile = Utils.joinPath(Globals.g_cmtConfigDir, "Utilities", "metadata.connection.properties");
            try {
                File propsFile = new File(connectionFile);
                if (!propsFile.isFile()) break block23;
                fileInStream = new FileInputStream(propsFile);
                Properties connectionProps = new Properties();
                connectionProps.load(fileInStream);
                fileInStream.close();
                String serverOperationType = connectionProps.getProperty("server.operation.type", "scripts");
                String appserverContextDir = connectionProps.getProperty("metadatasrv.config.lev.appservercontext.dir", null);
                String metadatasrvConfigDirName = connectionProps.getProperty("iomsrv.metadatasrv.config.dir.name", null);
                String metadatasrvScriptName = connectionProps.getProperty("iomsrv.metadatasrv.script.name", null);
                String startOption = connectionProps.getProperty("server.command.start.option", null);
                if (appserverContextDir == null || metadatasrvConfigDirName == null || metadatasrvScriptName == null || startOption == null) break block23;
                boolean runAsServices = serverOperationType.equalsIgnoreCase("services");
                String script = "\"" + Utils.joinPath(appserverContextDir, metadatasrvConfigDirName, metadatasrvScriptName) + "\"";
                String fullCmd = null;
                if (runAsServices) {
                    fullCmd = script + " " + startOption + " exit";
                    if (Utils.runProcess(fullCmd).getExitValue() == 0) {
                        if (Utils.isPortListening(host, port)) {
                            valid = true;
                        }
                    } else {
                        Logging.log.warning("The metadata server failed to restart with the following command: " + fullCmd);
                    }
                    break block23;
                }
                fullCmd = script + " " + startOption;
                if (Utils.runProcess(fullCmd, false).getExitValue() != 0) break block23;
                long listenerTimeout = 90L;
                try {
                    listenerTimeout = Long.parseLong(connectionProps.getProperty("server.listener.timeout", "90"));
                }
                catch (Exception e) {
                    listenerTimeout = 90L;
                }
                long endTime = System.currentTimeMillis() + listenerTimeout * 1000L;
                while (System.currentTimeMillis() < endTime && !valid) {
                    if (Utils.isPortListening(host, port)) {
                        valid = true;
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
                if (!valid) {
                    Logging.log.warning("The metadata server failed to restart with the following command: " + fullCmd);
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error loading connection properties file: " + connectionFile);
                Logging.logStackTrace(e);
            }
            finally {
                try {
                    if (fileInStream != null) {
                        fileInStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return valid;
    }
}

