/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelConfirmDepot
implements WizardPanelIface,
HyperlinkListener,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelConfirmDepot.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JScrollPane m_scrollPane = null;
    private PrintableEditorPane m_summaryText = null;
    private JCheckBox m_runSDW = null;
    private JButton m_printButton = null;
    private PageFormat m_pageFormat = null;
    private String m_fileToShow = null;
    private String m_data_depot_location;
    private String m_data_order_description;
    private String m_data_order_number;
    private long m_data_disk_space_needed;
    private long m_data_free_disk_space;
    private int m_data_number_files_download;
    private int m_data_number_files_already_downloaded;
    private int m_data_total_number_files;
    private boolean m_data_existing_depot;
    private String m_data_units;
    private int m_data_number_hotfixes_to_download = 0;
    private long m_data_sizeof_hotfixes_to_download = 0L;
    private String m_consoleText = null;
    private String[] m_consoleTable = null;

    public PanelConfirmDepot() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = Globals.g_mode == 1 ? (Globals.g_control.getDownloadControlListSize() != 0 ? this.bundle.getString("PanelConfirmDepot.DLHeader.txt") : this.bundle.getString("PanelConfirmDepot.NoDLHeader.txt")) : this.bundle.getString("PanelConfirmDepot.SDWHeader.txt");
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String header = null;
        header = Globals.g_mode == 1 ? (Globals.g_control.getDownloadControlListSize() != 0 ? this.bundle.getString("PanelConfirmDepot.DLHeaderDesc.txt") : this.bundle.getString("PanelConfirmDepot.NoDLHeaderDesc.txt")) : (Globals.g_mode == 6 ? this.bundle.getString("PanelConfirmDepot.DCUHeaderDesc.txt") : this.bundle.getString("PanelConfirmDepot.SDWHeaderDesc.txt"));
        return header;
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_mode == 6) {
            return "depotchecker";
        }
        return "progress";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        String mtxt = null;
        if (Globals.g_mode == 1) {
            if (Globals.g_control.getDownloadControlListSize() != 0) {
                mtxt = this.bundle.getString("PanelConfirmDepot.DownloadButton.txt");
                wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            } else {
                mtxt = this.bundle.getString("Wizard.Next.txt");
                wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.NoDLInstructionsESD.txt", this.bundle.getString("Common.ESDTitle.txt")));
            }
        } else if (Globals.g_mode == 6) {
            this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.DCUInstructions.txt"));
            mtxt = this.bundle.getString("PanelConfirmDepot.StartButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        } else {
            this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.SDWInstructions.txt", this.bundle.getString("Common.Title.txt")));
            mtxt = this.bundle.getString("PanelConfirmDepot.StartButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        }
        this.gatherData();
        this.updateTextArea();
        this.m_printButton.setMinimumSize(wizardFramework.getHelpButton().getPreferredSize());
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        File downloadhfDirFile;
        if (Globals.g_mode == 6) {
            return;
        }
        Globals.g_depotManager.setLock(false);
        File downloadDirFile = new File(Globals.g_downloadDir);
        if (downloadDirFile.exists()) {
            Utils.deleteFolder(downloadDirFile);
        }
        if ((downloadhfDirFile = new File(Globals.g_downloadDir + "hf")).exists()) {
            Utils.deleteFolder(downloadhfDirFile);
        }
        if (Globals.g_newDir != null) {
            Utils.deleteFolder(Globals.g_newDir);
            Logging.log.fine("Removed destination directory on goback: " + Globals.g_newDir);
            Globals.g_newDir = null;
        }
        if (Globals.g_subsetData != null && Globals.g_subsetData.isSubsetActive()) {
            Globals.g_order = Globals.g_subsetData.getOrigOrder();
            if (Globals.g_mode == 1) {
                Globals.g_deploymentData.setMediaRoot(Globals.g_subsetData.getOrigDepot());
            }
        }
    }

    @Override
    public int consoleEvent() {
        if (this.m_consoleText != null) {
            ConsoleMode.printInfoText(this.m_consoleText);
        }
        if (this.m_consoleTable != null) {
            ConsoleMode.printTable(this.m_consoleTable);
        }
        return ConsoleMode.promptPause();
    }

    private void initialize() {
        this.m_instructions = new JTextArea();
        if (Globals.g_mode == 1) {
            this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.DLInstructionsESD.txt", this.bundle.getString("Common.ESDTitle.txt")));
        } else if (Globals.g_mode == 6) {
            this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.DCUInstructions.txt", this.bundle.getString("Common.DCUTitle.txt")));
        } else {
            this.m_instructions.setText(this.bundle.messageString("PanelConfirmDepot.SDWInstructions.txt", this.bundle.getString("Common.Title.txt")));
        }
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_summaryText = new PrintableEditorPane();
        this.m_summaryText.setOpaque(false);
        this.m_summaryText.setEditable(false);
        this.m_summaryText.setContentType("text/html");
        this.m_summaryText.addHyperlinkListener(this);
        this.m_scrollPane = new JScrollPane(this.m_summaryText);
        this.m_summaryText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelConfirmDepot.this.m_summaryText.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        String mtxt = this.bundle.getString("Common.Print.txt");
        this.m_printButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_printButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_printButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        if (Globals.g_mode == 6) {
            this.m_printButton.setEnabled(false);
        }
        this.m_printButton.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weightx = 1.0;
        if (this.m_instructions != null) {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 10, 0);
            this.m_panel.add((Component)this.m_instructions, c);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 5, 0, 0);
        this.m_panel.add((Component)this.m_printButton, c);
        if (this.m_runSDW != null) {
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 12;
            c.insets = new Insets(10, 0, 0, 0);
            this.m_panel.add((Component)this.m_runSDW, c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_printButton) {
            this.onPrint();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
            if (this.m_fileToShow != null) {
                try {
                    URL fileToShow = new URL(Utils.pathToURL(this.m_fileToShow));
                    if (event.getURL().sameFile(fileToShow)) {
                        this.m_fileToShow = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void gatherData() {
        this.m_data_depot_location = Globals.g_ssdDestDir;
        if (Globals.g_mode != 6) {
            this.m_data_order_description = Globals.g_orderDesc;
            this.m_data_order_number = Globals.g_order;
            this.m_data_disk_space_needed = Globals.g_job.getTotalSize();
            this.m_data_free_disk_space = Globals.g_freeDiskSpace;
            this.m_data_existing_depot = Globals.g_depotManager.existingDepot();
            if (Globals.g_mode == 1) {
                String[] volsers = Globals.g_deploymentData.getOrder(Globals.g_order).getVolsers("esdm");
                int count = 0;
                for (int i = 0; i < volsers.length; ++i) {
                    count += Globals.g_deploymentData.getVolser(volsers[i]).getSpsSkus().length;
                }
                this.m_data_total_number_files = count;
                this.m_data_number_files_download = Globals.g_control.getDownloadControlListSize();
                this.m_data_number_files_already_downloaded = this.m_data_total_number_files - Globals.g_control.getDownloadControlListSize();
                if (Globals.g_hotfixData != null) {
                    this.m_data_number_hotfixes_to_download = Globals.g_hotfixData.getNumHotfixesToDownload();
                    this.m_data_sizeof_hotfixes_to_download = Globals.g_hotfixData.getTotalSizeOfHotfixes();
                }
            }
        }
    }

    private void updateTextArea() {
        double divideSize = 0.0;
        DecimalFormat numFormat = new DecimalFormat("###,##0.0");
        if ((double)this.m_data_disk_space_needed > 1.073741824E9) {
            divideSize = 1.073741824E9;
            this.m_data_units = this.bundle.messageString("PanelConfirmDepot.GigaBytes.txt");
        } else {
            divideSize = 1048576.0;
            this.m_data_units = this.bundle.messageString("PanelConfirmDepot.MegaBytes.txt");
        }
        String listText = null;
        listText = Globals.g_consoleMode ? "" : "<html>";
        if (Globals.g_mode != 6) {
            listText = Globals.g_mode == 1 ? (this.m_data_number_files_download == 0 && this.m_data_number_hotfixes_to_download == 0 ? listText + this.bundle.messageString("PanelConfirmDepot.NothingToDownload.txt") : (this.m_data_existing_depot ? listText + this.bundle.messageString("PanelConfirmDepot.AddToExistingDepot.txt") : listText + this.bundle.messageString("PanelConfirmDepot.CreateNewDepot.txt"))) : (this.m_data_existing_depot ? listText + this.bundle.messageString("PanelConfirmDepot.SDWAddToExistingDepot.txt") : listText + this.bundle.messageString("PanelConfirmDepot.SDWAddToNewDepot.txt"));
        }
        if (Globals.g_consoleMode) {
            this.m_consoleText = listText;
            ArrayList<String> consoleTable = new ArrayList<String>();
            consoleTable.add(this.bundle.messageString("PanelConfirmDepot.DepotLocation.txt") + "~" + this.m_data_depot_location);
            if (Globals.g_mode != 6) {
                consoleTable.add(this.bundle.messageString("PanelConfirmDepot.OrderNumber.txt") + "~" + this.m_data_order_number);
                consoleTable.add(this.bundle.messageString("PanelConfirmDepot.OrderDescription.txt") + "~" + this.m_data_order_description);
                if (this.m_data_free_disk_space >= 0L) {
                    consoleTable.add(this.bundle.messageString("PanelConfirmDepot.DiskSpaceAvailable.txt", this.m_data_units) + "~" + numFormat.format((double)this.m_data_free_disk_space / divideSize));
                }
                consoleTable.add(this.bundle.messageString("PanelConfirmDepot.DiskSpaceRequired.txt", this.m_data_units) + "~" + numFormat.format((double)this.m_data_disk_space_needed / divideSize));
                if (Globals.g_mode == 1) {
                    consoleTable.add(this.bundle.messageString("PanelConfirmDepot.NumFilesToBeDownloaded.txt") + "~" + this.m_data_number_files_download);
                    if (this.m_data_existing_depot) {
                        consoleTable.add(this.bundle.messageString("PanelConfirmDepot.NumFilesAlreadyDownloaded.txt") + "~" + this.m_data_number_files_already_downloaded);
                    }
                    consoleTable.add(this.bundle.messageString("PanelConfirmDepot.NumHotfixesToDownload.txt") + "~" + this.m_data_number_hotfixes_to_download);
                    if (this.m_data_number_hotfixes_to_download > 0) {
                        consoleTable.add(this.bundle.messageString("PanelConfirmDepot.SizeofHotfixesToDownload.txt", this.m_data_units) + "~" + numFormat.format((double)this.m_data_sizeof_hotfixes_to_download / divideSize));
                        consoleTable.add(this.bundle.messageString("PanelConfirmDepot.TotalSizeOfDownload.txt", this.m_data_units) + "~" + numFormat.format((double)(this.m_data_disk_space_needed + this.m_data_sizeof_hotfixes_to_download) / divideSize));
                    }
                }
            }
            this.m_consoleTable = consoleTable.toArray(new String[0]);
        } else {
            listText = Globals.g_mode == 6 ? listText + "<table valign=top cellspacing=0 cellpadding=1><tr><td>" + this.bundle.messageString("PanelConfirmDepot.DepotLocation.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_depot_location + "</td></tr><tr><td></td></tr></table></html>" : listText + "<br><br><table valign=top cellspacing=0 cellpadding=1><tr><td>" + this.bundle.messageString("PanelConfirmDepot.DepotLocation.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_depot_location + "</td></tr><tr><td>" + this.bundle.messageString("PanelConfirmDepot.OrderNumber.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_order_number + "</td></tr><tr><td>" + this.bundle.messageString("PanelConfirmDepot.OrderDescription.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_order_description + "</td></tr><tr><td>" + (this.m_data_free_disk_space >= 0L ? this.bundle.messageString("PanelConfirmDepot.DiskSpaceAvailable.txt", this.m_data_units) + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + numFormat.format((double)this.m_data_free_disk_space / divideSize) + "</td></tr><tr><td>" : "") + this.bundle.messageString("PanelConfirmDepot.DiskSpaceRequired.txt", this.m_data_units) + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + numFormat.format((double)this.m_data_disk_space_needed / divideSize) + "</td></tr><tr><td>" + (Globals.g_mode == 1 ? this.bundle.messageString("PanelConfirmDepot.NumFilesToBeDownloaded.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_number_files_download + "</td></tr><tr><td>" + (this.m_data_existing_depot ? this.bundle.messageString("PanelConfirmDepot.NumFilesAlreadyDownloaded.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_number_files_already_downloaded + "</td></tr><tr><td>" : "") + this.bundle.messageString("PanelConfirmDepot.NumHotfixesToDownload.txt") + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + this.m_data_number_hotfixes_to_download + "</td></tr><tr><td>" : "") + (this.m_data_number_hotfixes_to_download > 0 ? this.bundle.messageString("PanelConfirmDepot.SizeofHotfixesToDownload.txt", this.m_data_units) + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + numFormat.format((double)this.m_data_sizeof_hotfixes_to_download / divideSize) + "</td></tr><tr><td>" : "") + (this.m_data_number_hotfixes_to_download > 0 ? this.bundle.messageString("PanelConfirmDepot.TotalSizeOfDownload.txt", this.m_data_units) + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + numFormat.format((double)(this.m_data_disk_space_needed + this.m_data_sizeof_hotfixes_to_download) / divideSize) + "</td></tr><tr><td>" : "") + "</td></tr></table></html>";
            this.m_summaryText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.m_summaryText.setText(listText);
            this.m_summaryText.setCaretPosition(0);
            this.m_summaryText.revalidate();
        }
    }

    private void onPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.m_pageFormat == null) {
            this.m_pageFormat = printerJob.defaultPage();
        }
        PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
        printerThread.start();
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.m_printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_printerJob.setPrintable(PanelConfirmDepot.this.m_summaryText, PanelConfirmDepot.this.m_pageFormat);
            this.m_printerJob.validatePage(PanelConfirmDepot.this.m_pageFormat);
            if (this.m_printerJob.printDialog()) {
                try {
                    this.m_printerJob.setPrintable(PanelConfirmDepot.this.m_summaryText, PanelConfirmDepot.this.m_pageFormat);
                    this.m_printerJob.validatePage(PanelConfirmDepot.this.m_pageFormat);
                    this.m_printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

