/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.ConsoleModeEventDriven;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.EsdDownloadStats;
import com.sas.ssn.Globals;
import com.sas.ssn.HotfixData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProgressBar;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PanelCheckForHotFixes
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelCheckForHotFixes.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_headerText = null;
    private ProgressBar m_progressBar = null;
    private Timer m_timer = null;
    private ActionListener m_timerAction = null;
    private DownloadHotFixes m_hfDownload = null;
    private boolean m_panelLoaded = false;
    private boolean m_processing = true;
    private boolean m_downloadActive = false;
    private boolean m_noNewHF = false;
    private int m_displayStatsInterval = 0;
    private AtomicInteger m_displayMsgs = new AtomicInteger();

    public PanelCheckForHotFixes() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        String header = null;
        header = this.m_processing ? this.bundle.getString("PanelCheckForHotFixes.Header.txt") : (this.m_noNewHF ? this.bundle.getString("PanelCheckForHotFixes.noNewHF.FinishHeader.txt") : this.bundle.getString("PanelCheckForHotFixes.FinishHeader.txt"));
        return header;
    }

    @Override
    public String getHeaderDesc() {
        String headerDesc = null;
        headerDesc = this.m_processing ? this.bundle.getString("PanelCheckForHotFixes.HeaderDesc.txt") : (this.m_noNewHF ? this.bundle.getString("PanelCheckForHotFixes.noNewHFFinishHeaderDesc.txt") : this.bundle.getString("PanelCheckForHotFixes.FinishHeaderDesc.txt"));
        return headerDesc;
    }

    @Override
    public boolean validateData() {
        if (this.m_processing) {
            if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelCheckForHotFixes.InterruptMsg.txt"), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 0) {
                this.m_hfDownload.interrupt();
                Globals.g_hotfixData.resetData();
                this.m_timer.stop();
                this.m_processing = false;
                this.m_progressBar.stopped();
                try {
                    Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                    this.m_hfDownload.join();
                }
                catch (InterruptedException e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
                }
                Globals.g_hotfixData.deleteHotfixStagingDir();
                String mtxt = this.bundle.getString("PanelCheckForHotFixes.FinishButton.txt");
                Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                Globals.g_wizard.getNextButton().setEnabled(true);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return null;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            wizardFramework.clearWizardChain(true);
            String mtxt = null;
            mtxt = this.bundle.getString("PanelCheckForHotFixes.StopButton.txt");
            wizardFramework.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            wizardFramework.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            wizardFramework.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            wizardFramework.getNextButton().setPreferredSize(null);
            wizardFramework.getBackButton().setEnabled(false);
            wizardFramework.getCancelButton().setEnabled(false);
            this.startAction();
            this.m_timer.start();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = false;
        this.startAction();
        if (Globals.g_hotfixData.getDownloadComplete()) {
            valid = true;
        } else {
            Logging.log.severe("Quiet mode failure during download of Hot Fixes.");
        }
        Globals.g_depotManager.setLock(false);
        return valid;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_hotfixData.resetData();
        this.m_panelLoaded = false;
    }

    @Override
    public int consoleEvent() {
        if (!Globals.g_hotfixData.getDoDownload()) {
            ConsoleMode.busyMsgStop();
            ConsoleMode.printInfoText(this.bundle.getString("PanelCheckForHotFixes.noNewHF.FinishHeaderDesc.txt"));
        } else {
            try {
                this.m_hfDownload.join();
            }
            catch (InterruptedException e) {
                Logging.logStackTrace(e);
            }
            this.m_processing = false;
            ConsoleMode.busyMsgStop();
            if (Globals.g_hotfixData.getDownloadComplete()) {
                ConsoleMode.printInfoText(this.bundle.getString("PanelCheckForHotFixes.FinishHeaderDesc.txt"));
            } else {
                ConsoleMode.printInfoText(this.bundle.getString("PanelCheckForHotFixes.ErrorHeaderDesc.txt"));
            }
        }
        return ConsoleMode.promptPause();
    }

    private void initialize() {
        this.m_headerText = new JTextArea();
        this.m_headerText.setText(this.bundle.getString("PanelCheckForHotFixes.InfoLabel.txt"));
        this.m_headerText.setEditable(false);
        this.m_headerText.setFocusable(false);
        this.m_headerText.setLineWrap(true);
        this.m_headerText.setWrapStyleWord(true);
        this.m_headerText.setOpaque(false);
        this.m_progressBar = new ProgressBar(100.0, false, true);
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelCheckForHotFixes.this.timerEvent();
            }
        };
        this.m_timer = new Timer(250, this.m_timerAction);
    }

    private void timerEvent() {
        if (!Globals.g_hotfixData.getDoDownload() || this.m_hfDownload == null || !this.m_hfDownload.isAlive()) {
            this.updateStats();
            if (Globals.g_hotfixData.getDownloadComplete()) {
                this.m_progressBar.finished();
                if (this.m_noNewHF) {
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelCheckForHotFixes.noNewHF.FinishHeader.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelCheckForHotFixes.noNewHF.FinishHeaderDesc.txt"));
                    this.m_headerText.setText(this.bundle.getString("PanelCheckForHotFixes.noNewHF.FinishInfoLabel.txt"));
                } else {
                    Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelCheckForHotFixes.FinishHeader.txt"));
                    Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelCheckForHotFixes.FinishHeaderDesc.txt"));
                    this.m_headerText.setText(this.bundle.messageString("PanelCheckForHotFixes.FinishInfoLabel.txt", Globals.g_hotfixData.getNumHotfixesToDownload()));
                }
            } else {
                this.m_progressBar.failed();
                Globals.g_wizard.getHeader().setText(this.bundle.getString("PanelCheckForHotFixes.ErrorHeader.txt"));
                Globals.g_wizard.getHeaderDesc().setText(this.bundle.getString("PanelCheckForHotFixes.ErrorHeaderDesc.txt"));
                this.m_headerText.setText(this.bundle.getString("PanelCheckForHotFixes.ErrorInfoLabel.txt"));
            }
            String mtxt = this.bundle.getString("PanelCheckForHotFixes.FinishButton.txt");
            Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
            Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            Globals.g_wizard.getNextButton().setEnabled(true);
            this.m_processing = false;
        } else {
            this.m_progressBar.setCurrentValue(Globals.g_esdStats.getCurrCount());
            this.updateStats();
        }
        if (!this.m_processing) {
            this.m_timer.stop();
            Globals.g_wizard.getCancelButton().setEnabled(true);
            Globals.g_wizard.setWizardActive(false);
            Globals.g_wizard.enableButtons();
            if (Globals.g_consoleMode) {
                ConsoleModeEventDriven.breakReadLine();
            }
        }
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().validate();
        }
    }

    private void updateStats() {
        if (Globals.g_consoleMode && this.m_downloadActive && this.displayMsgs() && this.m_displayStatsInterval++ % 5 == 0 && this.displayMsgs()) {
            int i;
            int percentage = this.m_progressBar.getValue();
            StringBuilder displayPercentage = new StringBuilder(this.bundle.messageString("ProgressBar.Progress.txt"));
            displayPercentage.append(" <");
            for (i = 0; i < this.m_progressBar.getValue() / 2; ++i) {
                displayPercentage.append("-");
            }
            displayPercentage.append(percentage);
            displayPercentage.append("%");
            for (i = this.m_progressBar.getValue() / 2; i < 50; ++i) {
                displayPercentage.append("-");
            }
            displayPercentage.append(">");
            ConsoleMode.println(displayPercentage.toString());
            ConsoleMode.println(this.m_progressBar.getTimeRemaining().getText());
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_headerText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(20, 0, 0, 0);
        this.m_panel.add((Component)this.m_progressBar, c);
    }

    private void startAction() {
        Globals.g_esdStats = new EsdDownloadStats();
        Globals.g_hotfixData = new HotfixData(Globals.g_order, HotfixData.HFMode.UPDATE);
        Globals.g_hotfixData.grabAndAnalyzeHotfixes();
        if (Globals.g_hotfixData.getDoDownload()) {
            Globals.g_esdStats.addTask("DOWNLOAD", Globals.g_hotfixData.getTotalSizeOfHotfixes());
            this.m_hfDownload = new DownloadHotFixes();
            if (Globals.g_quietMode) {
                this.m_hfDownload.run();
            } else {
                this.m_progressBar.setMaxValue(Globals.g_hotfixData.getTotalSizeOfHotfixes());
                this.m_progressBar.setCurrentValue(1.0);
                this.m_hfDownload.start();
            }
        } else {
            this.m_noNewHF = true;
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    public void pauseProgressBar() {
        this.m_progressBar.pause();
    }

    public void resumeProgressBar() {
        this.m_progressBar.resume();
    }

    private boolean displayMsgs() {
        return this.m_displayMsgs.intValue() == 0;
    }

    public void pauseMsgs() {
        this.m_displayMsgs.incrementAndGet();
    }

    public void unpauseMsgs() {
        if (this.m_displayMsgs.decrementAndGet() < 0) {
            this.m_displayMsgs.set(0);
        }
    }

    public class DownloadHotFixes
    extends Thread {
        protected DownloadHotFixes() {
        }

        @Override
        public void run() {
            this.setName("DownloadHotFixes");
            PanelCheckForHotFixes.this.m_downloadActive = true;
            if (Globals.g_hotfixData.getDoDownload()) {
                Globals.g_hotfixData.downloadHotfixes();
                if (!Globals.g_quietMode && Globals.g_wizard != null) {
                    Globals.g_wizard.getNextButton().setEnabled(false);
                }
                Globals.g_hotfixData.processHotfixes();
                Globals.g_hotfixData.deleteHotfixStagingDir();
            }
            PanelCheckForHotFixes.this.m_downloadActive = false;
        }
    }
}

