/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PanelChangeHostSummary
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelChangeHostSummary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_warningText = null;
    private JLabel m_msInfoLabel = null;
    private KitTextField m_msInfoField = null;
    private JTextArea m_infoText = null;
    private JLabel m_warningImage = null;
    private JTable m_hostList = null;
    private JScrollPane m_listScrollPane = null;
    private ListTableModel m_listTableModel = null;
    private ArrayList m_listData = new ArrayList();
    private boolean m_panelLoaded = false;

    public PanelChangeHostSummary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelChangeHostSummary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelChangeHostSummary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "execute";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_msInfoField.setText(Globals.g_cmtConnectHost + " on port " + Globals.g_cmtConnectPort);
            this.m_panelLoaded = true;
        }
        this.loadHostData();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.printInfoText(this.m_warningText.getText());
        ConsoleMode.promptStaticText(this.m_msInfoLabel.getText(), this.m_msInfoField);
        ConsoleMode.println();
        ConsoleMode.println(this.m_infoText.getText());
        ArrayList<String> tableText = new ArrayList<String>();
        tableText.add(this.bundle.getString("PanelChangeHostSummary.OldHostField.txt") + "~" + this.bundle.getString("PanelChangeHostSummary.NewHostField.txt"));
        ListData data = null;
        for (int i = 0; i < this.m_listData.size(); ++i) {
            data = (ListData)this.m_listData.get(i);
            tableText.add(data.getOldHost() + "~" + data.getNewHost());
        }
        ConsoleMode.printTable(tableText.toArray(new String[0]));
        return ConsoleMode.promptPause();
    }

    private boolean loadResponseData() {
        return true;
    }

    private void initialize() {
        this.m_warningImage = new JLabel();
        this.m_warningImage.setIcon(this.bundle.getImageIcon("Common.warning_small.image"));
        this.m_warningText = new JTextArea(this.bundle.getString("PanelChangeHostSummary.WarningText.txt"));
        this.m_warningText.setEditable(false);
        this.m_warningText.setFocusable(false);
        this.m_warningText.setLineWrap(true);
        this.m_warningText.setWrapStyleWord(true);
        this.m_warningText.setOpaque(false);
        this.m_msInfoField = new KitTextField();
        this.m_msInfoField.setEditable(false);
        this.m_msInfoField.setFocusable(false);
        String mtxt = this.bundle.getString("PanelChangeHostSummary.MSInfoLabel.txt");
        this.m_msInfoLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_msInfoLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_msInfoLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_msInfoLabel.setLabelFor(this.m_msInfoField);
        this.m_infoText = new JTextArea(this.bundle.getString("PanelChangeHostSummary.InfoText.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_listTableModel = new ListTableModel();
        this.m_hostList = new JTable(this.m_listTableModel);
        this.m_hostList.setRowSelectionAllowed(true);
        this.m_hostList.setColumnSelectionAllowed(false);
        this.m_hostList.setSelectionMode(0);
        this.m_hostList.getTableHeader().setResizingAllowed(true);
        this.m_hostList.getTableHeader().setReorderingAllowed(false);
        this.m_hostList.getColumnModel().getColumn(0).setCellRenderer(new StringCellRenderer());
        this.m_hostList.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
        this.m_hostList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelChangeHostSummary.this.m_hostList.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.m_listScrollPane = new JScrollPane(this.m_hostList);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_warningImage, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_warningText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_msInfoLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_msInfoField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_listScrollPane, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void loadHostData() {
        this.m_listData.clear();
        StringTokenizer oldHostList = new StringTokenizer(Globals.g_configData.getProperty("deploymgr.changehost.old.host.name", "temp"), ",");
        StringTokenizer newHostList = new StringTokenizer(Globals.g_configData.getProperty("deploymgr.changehost.new.host.name", "temp"), ",");
        String oldHostItem = null;
        String newHostItem = null;
        while (oldHostList.hasMoreTokens()) {
            oldHostItem = oldHostList.nextToken().trim();
            newHostItem = newHostList.nextToken().trim();
            this.m_listData.add(new ListData(oldHostItem, newHostItem));
        }
    }

    private class ListData {
        private String m_oldHost = null;
        private String m_newHost = null;

        public ListData(String oldHost, String newHost) {
            this.m_oldHost = oldHost;
            this.m_newHost = newHost;
        }

        public String getOldHost() {
            return this.m_oldHost;
        }

        public String getNewHost() {
            return this.m_newHost;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    private class ListTableModel
    extends AbstractTableModel {
        public static final int TABLE_COLUMN_OLD = 0;
        public static final int TABLE_COLUMN_NEW = 1;
        private String[] m_columnNames;

        public ListTableModel() {
            this.m_columnNames = new String[]{PanelChangeHostSummary.this.bundle.getString("PanelChangeHostSummary.OldHostField.txt"), PanelChangeHostSummary.this.bundle.getString("PanelChangeHostSummary.NewHostField.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            int count = 0;
            if (PanelChangeHostSummary.this.m_listData != null) {
                count = PanelChangeHostSummary.this.m_listData.size();
            }
            return count;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String value = null;
            ListData data = (ListData)PanelChangeHostSummary.this.m_listData.get(rowIndex);
            if (data != null) {
                if (columnIndex == 0) {
                    value = data.getOldHost();
                } else if (columnIndex == 1) {
                    value = data.getNewHost();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }
    }
}

