/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelChangeHost
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelChangeHost.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JLabel m_oldHostLabel = null;
    private KitTextField m_oldHostField = null;
    private JLabel m_newHostLabel = null;
    private KitTextField m_newHostField = null;
    private JTextArea m_exactText = null;
    private JCheckBox m_exactCheckBox = null;
    private boolean m_panelLoaded = false;

    public PanelChangeHost() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelChangeHost.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelChangeHost.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        boolean lookup = false;
        String errMsg = null;
        String oldHost = this.m_oldHostField.getText().trim().toLowerCase();
        String newHost = this.m_newHostField.getText().trim().toLowerCase();
        this.m_oldHostField.setText(oldHost);
        this.m_newHostField.setText(newHost);
        if (this.m_exactCheckBox.isSelected()) {
            lookup = true;
        }
        if (valid && oldHost.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CHANGEHOST_OLD_NAME");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelChangeHost.OldHostField.txt"));
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_oldHostField.requestFocus();
            }
        }
        if (valid && newHost.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "CHANGEHOST_NEW_NAME");
            } else {
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelChangeHost.NewHostField.txt"));
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_newHostField.requestFocus();
            }
        }
        StringTokenizer oldHostList = new StringTokenizer(oldHost, ",");
        StringTokenizer newHostList = new StringTokenizer(newHost, ",");
        String oldHostItem = null;
        String newHostItem = null;
        if (valid && oldHostList.countTokens() != newHostList.countTokens()) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", oldHost, this.bundle.getString("PanelChangeHost.MismatchList.txt"));
            } else {
                errMsg = this.bundle.getString("PanelChangeHost.MismatchList.txt");
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_oldHostField.requestFocus();
            }
        }
        String expandedOldHostList = "";
        String expandedNewHostList = "";
        if (!(!valid || Utils.isValidHostNameChars(oldHost) && Utils.isValidHostNameChars(newHost))) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", oldHost, this.bundle.getString("PanelHostName.InvalidChar.txt"));
            } else {
                errMsg = this.bundle.getString("PanelHostName.InvalidChar.txt");
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                if (!Utils.isValidHostNameChars(oldHost)) {
                    this.m_oldHostField.requestFocus();
                } else {
                    this.m_newHostField.requestFocus();
                }
            }
        }
        if (valid && lookup) {
            while (valid && oldHostList.hasMoreTokens()) {
                oldHostItem = oldHostList.nextToken().trim();
                newHostItem = newHostList.nextToken().trim();
                if (valid && this.testDNSLookup(oldHostItem)) {
                    expandedOldHostList = expandedOldHostList.length() > 0 ? expandedOldHostList + "," + this.expandHost(oldHostItem) : this.expandHost(oldHostItem);
                } else if (valid && !this.testDNSLookup(oldHostItem)) {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", oldHostItem, this.bundle.messageString("PanelChangeHost.UnknownHost.txt", oldHostItem));
                    } else {
                        errMsg = this.bundle.messageString("PanelChangeHost.UnknownHost.txt", oldHostItem);
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                        this.m_oldHostField.requestFocus();
                    }
                }
                if (valid && this.testDNSLookup(newHostItem)) {
                    if (expandedNewHostList.length() > 0) {
                        expandedNewHostList = expandedNewHostList + "," + this.expandHost(newHostItem);
                        continue;
                    }
                    expandedNewHostList = this.expandHost(newHostItem);
                    continue;
                }
                if (!valid || this.testDNSLookup(newHostItem)) continue;
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_NEW_NAME", newHostItem, this.bundle.messageString("PanelChangeHost.UnknownHost.txt", newHostItem));
                    continue;
                }
                errMsg = this.bundle.messageString("PanelChangeHost.UnknownHost.txt", newHostItem);
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_newHostField.requestFocus();
            }
        } else if (valid && !lookup) {
            expandedOldHostList = oldHost;
            expandedNewHostList = newHost;
        }
        StringTokenizer exOldHostList = new StringTokenizer(expandedOldHostList, ",");
        StringTokenizer exNewHostList = new StringTokenizer(expandedNewHostList, ",");
        String exOldHostItem = null;
        String exNewHostItem = null;
        ArrayList<String> oldListArray = new ArrayList<String>();
        ArrayList<String> newListArray = new ArrayList<String>();
        while (valid && exOldHostList.hasMoreTokens()) {
            exOldHostItem = exOldHostList.nextToken().trim();
            exNewHostItem = exNewHostList.nextToken().trim();
            if (valid && exOldHostItem.equals(exNewHostItem)) {
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", exOldHostItem, this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exOldHostItem));
                } else {
                    errMsg = this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exOldHostItem);
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_oldHostField.requestFocus();
                }
            }
            if (!valid) continue;
            for (int i = 0; i < newListArray.size(); ++i) {
                for (int j = 0; j < oldListArray.size(); ++j) {
                    if (valid && exOldHostItem.equals((String)oldListArray.get(i))) {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", exOldHostItem, this.bundle.messageString("PanelChangeHost.DuplicateOldHost.txt", exOldHostItem));
                        } else {
                            errMsg = this.bundle.messageString("PanelChangeHost.DuplicateOldHost.txt", exOldHostItem);
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                            this.m_oldHostField.requestFocus();
                        }
                    }
                    if (!valid || !exNewHostItem.equals((String)oldListArray.get(i))) continue;
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", exNewHostItem, this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exNewHostItem));
                        continue;
                    }
                    errMsg = this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exNewHostItem);
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_oldHostField.requestFocus();
                }
                if (!valid || !exOldHostItem.equals((String)newListArray.get(i))) continue;
                valid = false;
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_OLD_NAME", exOldHostItem, this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exOldHostItem));
                    continue;
                }
                errMsg = this.bundle.messageString("PanelChangeHost.SameHostMsg.txt", exOldHostItem);
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
                this.m_oldHostField.requestFocus();
            }
            if (!valid) continue;
            oldListArray.add(exOldHostItem);
            newListArray.add(exNewHostItem);
        }
        if (valid) {
            Globals.g_configData.setProperty("deploymgr.changehost.old.host.name", expandedOldHostList);
            Globals.g_configData.setProperty("deploymgr.changehost.new.host.name", expandedNewHostList);
        }
        return valid;
    }

    public String expandHost(String host) {
        byte[] rawAddress = null;
        String ipAddress = "";
        String longName = "";
        String shortName = "";
        String result = "";
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    ipAddress = address.getHostAddress();
                    longName = Utils.getFullHostName(address);
                    shortName = longName.split("\\.")[0];
                    if ((!(address instanceof Inet6Address) || !ipAddress.equalsIgnoreCase(host)) && (!(address instanceof Inet4Address) || !ipAddress.equalsIgnoreCase(host) && !longName.equalsIgnoreCase(host) && !shortName.equalsIgnoreCase(host))) continue;
                    result = longName + "," + shortName + "," + ipAddress;
                    return result;
                }
            }
            rawAddress = InetAddress.getByName(host).getAddress();
            InetAddress address = InetAddress.getByAddress(rawAddress);
            ipAddress = address.getHostAddress();
            longName = Utils.getFullHostName(address);
            if (longName.indexOf(".") >= 0) {
                shortName = longName.substring(0, longName.indexOf("."));
                result = longName + "," + shortName + "," + ipAddress;
            }
        }
        catch (Exception e) {
            Logging.log.warning("Unable to resolve the DNS host name for: " + host);
            Logging.logStackTrace(e);
        }
        return result;
    }

    public boolean testDNSLookup(String host) {
        boolean valid = false;
        byte[] rawAddress = null;
        try {
            rawAddress = InetAddress.getByName(host).getAddress();
            InetAddress address = InetAddress.getByAddress(rawAddress);
            String ipAddress = address.getHostAddress();
            String longName = Utils.getFullHostName(address);
            if (ipAddress.length() > 0 && longName.indexOf(".") >= 0) {
                valid = true;
            }
        }
        catch (Exception e) {
            Logging.log.warning("Unable to resolve the DNS host name for: " + host);
            return valid;
        }
        if (!valid) {
            Logging.log.warning("Unable to resolve the DNS host name for: " + host);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "changehostsummary";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_oldHostField;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#CHANGEHOST_OLD_NAME=<string value> (Comma-separated list for multiple hosts)", " CHANGEHOST_OLD_NAME=", "#CHANGEHOST_NEW_NAME=<string value> (Comma-separated list for multiple hosts)", " CHANGEHOST_NEW_NAME=", "#CHANGEHOST_REPLACEALL=yes/no", " CHANGEHOST_REPLACEALL=yes"};
        if (this.m_panelLoaded) {
            data[1] = " CHANGEHOST_OLD_NAME=" + this.m_oldHostField.getText().trim();
            data[3] = " CHANGEHOST_NEW_NAME=" + this.m_newHostField.getText().trim();
            if (!this.m_exactCheckBox.isSelected()) {
                data[5] = " CHANGEHOST_REPLACEALL=no";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_oldHostLabel.getText(), this.m_oldHostField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_newHostLabel.getText(), this.m_newHostField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptBoolean(this.m_exactCheckBox);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("CHANGEHOST_OLD_NAME", null);
        if (response != null) {
            this.m_oldHostField.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "CHANGEHOST_OLD_NAME");
        }
        if (valid) {
            response = Wizard.getResponse("CHANGEHOST_NEW_NAME", null);
            if (response != null) {
                this.m_newHostField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "CHANGEHOST_NEW_NAME");
            }
        }
        if (valid) {
            response = Wizard.getResponse("CHANGEHOST_REPLACEALL", null);
            if (response != null) {
                if (response.equalsIgnoreCase("yes")) {
                    this.m_exactCheckBox.setSelected(true);
                } else if (response.equalsIgnoreCase("no")) {
                    this.m_exactCheckBox.setSelected(false);
                } else if (Globals.g_quietMode) {
                    valid = false;
                    Wizard.logResponseInvalid(this.getHeader(), "CHANGEHOST_REPLACEALL", response, null);
                }
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "CHANGEHOST_REPLACEALL");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelChangeHost.InfoText.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        this.m_oldHostField = new KitTextField();
        String mtxt = this.bundle.getString("PanelChangeHost.OldHostLabel.txt");
        this.m_oldHostLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_oldHostLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_oldHostLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_oldHostLabel.setLabelFor(this.m_oldHostField);
        this.m_newHostField = new KitTextField();
        mtxt = this.bundle.getString("PanelChangeHost.NewHostLabel.txt");
        this.m_newHostLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_newHostLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_newHostLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_newHostLabel.setLabelFor(this.m_newHostField);
        this.m_exactText = new JTextArea(this.bundle.getString("PanelChangeHost.ExactText.txt"));
        this.m_exactText.setEditable(false);
        this.m_exactText.setFocusable(false);
        this.m_exactText.setLineWrap(true);
        this.m_exactText.setWrapStyleWord(true);
        this.m_exactText.setOpaque(false);
        mtxt = this.bundle.getString("PanelChangeHost.ExactCheckBox.txt");
        this.m_exactCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt), true);
        this.m_exactCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_exactCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_oldHostLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_oldHostField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_newHostLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_newHostField, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(20, 0, 5, 0);
        this.m_panel.add((Component)this.m_exactText, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_exactCheckBox, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

