/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelAutoloadLasrServer
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelAutoloadLasrServer.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_lasrServerNameLabel = null;
    private KitTextField m_lasrServerNameField = null;
    private JLabel m_lasrServerHostLabel = null;
    private KitTextField m_lasrServerHostField = null;
    private JLabel m_lasrServerPortLabel = null;
    private KitTextField m_lasrServerPortField = null;
    private JLabel m_lasrServerSigFilesPathLabel = null;
    private KitTextField m_lasrServerSigFilesPathField = null;
    private JLabel m_lasrServerTkGridPathLabel = null;
    private KitTextField m_lasrServerTkGridPathField = null;
    private JLabel m_lasrServerTeragramPathLabel = null;
    private KitTextField m_lasrServerTeragramPathField = null;
    private boolean m_panelLoaded = false;

    public PanelAutoloadLasrServer() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAutoloadLasrServer.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAutoloadLasrServer.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String serverName = null;
        String serverHost = null;
        String serverPort = null;
        String sigFilesPath = null;
        String tkGridPath = null;
        String teragramPath = null;
        String missingResponse = null;
        String errMsg = null;
        serverName = this.m_lasrServerNameField.getText();
        if (serverName == null || serverName.length() <= 0) {
            valid = false;
            missingResponse = "LASR_SERVER_NAME";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerNameField.txt"));
        }
        if (valid && ((serverHost = this.m_lasrServerHostField.getText()) == null || serverHost.length() <= 0)) {
            valid = false;
            missingResponse = "LASR_SERVER_HOST";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerHostField.txt"));
        }
        if (valid) {
            serverPort = this.m_lasrServerPortField.getText();
            if (serverPort == null || serverPort.length() <= 0) {
                valid = false;
                missingResponse = "LASR_SERVER_PORT";
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerPortField.txt"));
            }
            if (!(valid = Utils.isValidPortNumber(serverPort))) {
                missingResponse = "LASR_SERVER_PORT";
                errMsg = this.bundle.messageString("PanelAutoloadLasrServer.portInvalid.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerPortField.txt"));
            }
        }
        if (valid && ((sigFilesPath = this.m_lasrServerSigFilesPathField.getText()) == null || sigFilesPath.length() <= 0)) {
            valid = false;
            missingResponse = "LASR_SERVER_SIGFILES_PATH";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerSigFilesPathField.txt"));
        }
        if (valid && this.isLasrMpp() && ((tkGridPath = this.m_lasrServerTkGridPathField.getText()) == null || tkGridPath.length() <= 0)) {
            valid = false;
            missingResponse = "LASR_SERVER_TKGRID_PATH";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerTkGridPathField.txt"));
        }
        if (valid && this.isLasrMpp() && ((teragramPath = this.m_lasrServerTeragramPathField.getText()) == null || teragramPath.length() <= 0)) {
            valid = false;
            missingResponse = "LASR_LINGUISTICS_BINARIES_LOCATION";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrServer.LasrServerTeragramPathField.txt"));
        }
        if (valid) {
            Globals.g_configData.setProperty("cfgwizard.lasrserver.name", serverName);
            Globals.g_configData.setProperty("cfgwizard.lasrserver.host", serverHost);
            Globals.g_configData.setProperty("cfgwizard.lasrserver.port", serverPort);
            Globals.g_configData.setProperty("cfgwizard.lasrserver.sigfiles.path", sigFilesPath);
            if (this.isLasrMpp()) {
                Globals.g_configData.setProperty("cfgwizard.lasrserver.path", tkGridPath);
                Globals.g_configData.setProperty("cfgwizard.teragram.location", teragramPath);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), missingResponse);
        } else {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "autoloadlasrlibrary";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        this.showMppFields();
    }

    private void showMppFields() {
        if (this.isLasrMpp()) {
            this.m_lasrServerTkGridPathLabel.setVisible(true);
            this.m_lasrServerTkGridPathField.setVisible(true);
            this.m_lasrServerTeragramPathLabel.setVisible(true);
            this.m_lasrServerTeragramPathField.setVisible(true);
        } else {
            this.m_lasrServerTkGridPathLabel.setVisible(false);
            this.m_lasrServerTkGridPathField.setVisible(false);
            this.m_lasrServerTeragramPathLabel.setVisible(false);
            this.m_lasrServerTeragramPathField.setVisible(false);
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_lasrServerNameField;
    }

    @Override
    public boolean silentEvent() {
        this.showMppFields();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#LASR_SERVER_NAME=<string value>", " LASR_SERVER_NAME=", "#LASR_SERVER_HOST=<string value>", " LASR_SERVER_HOST=", "#LASR_SERVER_PORT=<port number value>", " LASR_SERVER_PORT=", "#LASR_SERVER_SIGFILES_PATH=<string value>", " LASR_SERVER_SIGFILES_PATH=", "#LASR_SERVER_TKGRID_PATH=<string value>", " LASR_SERVER_TKGRID_PATH=", "#LASR_LINGUISTICS_BINARIES_LOCATION=<string value>", " LASR_LINGUISTICS_BINARIES_LOCATION="};
        if (this.m_panelLoaded) {
            data[1] = " LASR_SERVER_NAME=" + this.m_lasrServerNameField.getText().trim();
            data[3] = " LASR_SERVER_HOST=" + this.m_lasrServerHostField.getText().trim();
            data[5] = " LASR_SERVER_PORT=" + this.m_lasrServerPortField.getText().trim();
            data[7] = " LASR_SERVER_SIGFILES_PATH=" + this.m_lasrServerSigFilesPathField.getText().trim();
            data[9] = " LASR_SERVER_TKGRID_PATH=" + this.m_lasrServerTkGridPathField.getText().trim();
            data[11] = " LASR_LINGUISTICS_BINARIES_LOCATION=" + this.m_lasrServerTeragramPathField.getText().trim();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_lasrServerNameLabel.getText(), this.m_lasrServerNameField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_lasrServerHostLabel.getText(), this.m_lasrServerHostField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_lasrServerPortLabel.getText(), this.m_lasrServerPortField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_lasrServerSigFilesPathLabel.getText(), this.m_lasrServerSigFilesPathField);
        }
        if (returnCode > -1 && this.isLasrMpp()) {
            returnCode = ConsoleMode.promptText(this.m_lasrServerTkGridPathLabel.getText(), this.m_lasrServerTkGridPathField);
        }
        if (returnCode > -1 && this.isLasrMpp()) {
            returnCode = ConsoleMode.promptText(this.m_lasrServerTeragramPathLabel.getText(), this.m_lasrServerTeragramPathField);
        }
        return returnCode;
    }

    private boolean isLasrMpp() {
        String lasrServerType = Globals.g_configData.getProperty("cfgwizard.lasrserver.type", null);
        return lasrServerType != null && lasrServerType.equalsIgnoreCase("cfgwizard.lasrmpp");
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("LASR_SERVER_NAME", null);
        if (response != null) {
            this.m_lasrServerNameField.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_NAME");
        }
        if (valid) {
            response = Wizard.getResponse("LASR_SERVER_HOST", null);
            if (response != null) {
                this.m_lasrServerHostField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_HOST");
            }
        }
        if (valid) {
            response = Wizard.getResponse("LASR_SERVER_PORT", null);
            if (response != null) {
                this.m_lasrServerPortField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_PORT");
            }
        }
        if (valid) {
            response = Wizard.getResponse("LASR_SERVER_SIGFILES_PATH", null);
            if (response != null) {
                this.m_lasrServerSigFilesPathField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_SIGFILES_PATH");
            }
        }
        if (valid && this.isLasrMpp()) {
            response = Wizard.getResponse("LASR_SERVER_TKGRID_PATH", null);
            if (response != null) {
                this.m_lasrServerTkGridPathField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_TKGRID_PATH");
            }
        }
        if (valid && this.isLasrMpp()) {
            response = Wizard.getResponse("LASR_LINGUISTICS_BINARIES_LOCATION", null);
            if (response != null) {
                this.m_lasrServerTeragramPathField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_LINGUISTICS_BINARIES_LOCATION");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_lasrServerNameField = new KitTextField();
        String mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerNameLabel.txt");
        this.m_lasrServerNameLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerNameLabel.setLabelFor(this.m_lasrServerNameField);
        this.m_lasrServerHostField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerHostLabel.txt");
        this.m_lasrServerHostLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerHostLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerHostLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerHostLabel.setLabelFor(this.m_lasrServerHostField);
        this.m_lasrServerPortField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerPortLabel.txt");
        this.m_lasrServerPortLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerPortLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerPortLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerPortLabel.setLabelFor(this.m_lasrServerPortField);
        this.m_lasrServerSigFilesPathField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerSigFilesPathLabel.txt");
        this.m_lasrServerSigFilesPathLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerSigFilesPathLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerSigFilesPathLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerSigFilesPathLabel.setLabelFor(this.m_lasrServerSigFilesPathField);
        this.m_lasrServerTkGridPathField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerTkGridPathLabel.txt");
        this.m_lasrServerTkGridPathLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerTkGridPathLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerTkGridPathLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerTkGridPathLabel.setLabelFor(this.m_lasrServerTkGridPathField);
        this.m_lasrServerTeragramPathField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrServer.LasrServerTeragramPathLabel.txt");
        this.m_lasrServerTeragramPathLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerTeragramPathLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerTeragramPathLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerTeragramPathLabel.setLabelFor(this.m_lasrServerTeragramPathField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerNameLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerNameField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerHostLabel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerHostField, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerPortLabel, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerPortField, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerSigFilesPathLabel, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerSigFilesPathField, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerTkGridPathLabel, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerTkGridPathField, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerTeragramPathLabel, c);
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerTeragramPathField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

