/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.metadata.remote.impl.ServerContextImpl;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelAutoloadLasrLibrary
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelAutoloadLasrLibrary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_lasrLibraryNameLabel = null;
    private KitTextField m_lasrLibraryNameField = null;
    private JLabel m_lasrLibraryLibrefLabel = null;
    private KitTextField m_lasrLibraryLibrefField = null;
    private JLabel m_lasrServerContextLabel = null;
    private JComboBox m_lasrServerContextField = null;
    private boolean m_panelLoaded = false;

    public PanelAutoloadLasrLibrary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAutoloadLasrLibrary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAutoloadLasrLibrary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String libraryName = null;
        String libraryLibref = null;
        String serverContext = null;
        String missingResponse = null;
        String errMsg = null;
        libraryName = this.m_lasrLibraryNameField.getText();
        if (libraryName == null || libraryName.length() <= 0) {
            valid = false;
            missingResponse = "LASR_LIBRARY_NAME";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrLibrary.LasrLibraryNameField.txt"));
        }
        if (valid) {
            libraryLibref = this.m_lasrLibraryLibrefField.getText();
            if (libraryLibref == null || libraryLibref.length() <= 0) {
                valid = false;
                missingResponse = "LASR_LIBRARY_LIBREF";
                errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrLibrary.LasrLibraryLibrefField.txt"));
            } else if (libraryLibref.length() > 8) {
                valid = false;
                missingResponse = "LASR_LIBRARY_LIBREF";
                errMsg = this.bundle.messageString("PanelAutoloadLasrLibrary.LasrLibraryNameInvalid.txt", this.bundle.getString("PanelAutoloadLasrLibrary.LasrLibraryLibrefField.txt"));
            }
        }
        if (valid && ((serverContext = (String)this.m_lasrServerContextField.getSelectedItem()) == null || serverContext.length() <= 0)) {
            valid = false;
            missingResponse = "LASR_SERVER_CONTEXT";
            errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadLasrLibrary.LasrServerContextField.txt"));
        }
        if (valid) {
            Globals.g_configData.setProperty("cfgwizard.lasr.library.name", libraryName);
            Globals.g_configData.setProperty("cfgwizard.lasr.library.libref", libraryLibref);
            Globals.g_configData.setProperty("cfgwizard.lasrserver.context", serverContext);
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), missingResponse);
        } else {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "autoload";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.populateComboBox();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    private void populateComboBox() {
        String metaQuery = "<xmlselect search=\"ServerContext[@PublicType='ApplicationServer'][DependsOnComponents/SoftwareComponent[@Id='" + Globals.g_levdirrootFQID + "']][DependentComponents/LogicalServer[@PublicType='LogicalServer.Workspace']]\"/>";
        Vector results = (Vector)MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "ServerContext", metaQuery);
        for (ServerContextImpl context : results) {
            try {
                this.m_lasrServerContextField.addItem(context.getName());
            }
            catch (RemoteException e) {
                Logging.log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_lasrLibraryNameField;
    }

    @Override
    public boolean silentEvent() {
        this.populateComboBox();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#LASR_LIBRARY_NAME=<string value>", " LASR_LIBRARY_NAME=", "#LASR_LIBRARY_LIBREF=<string value>", " LASR_LIBRARY_LIBREF=", "#LASR_SERVER_CONTEXT=<string value>", " LASR_SERVER_CONTEXT="};
        if (this.m_panelLoaded) {
            data[1] = " LASR_LIBRARY_NAME=" + this.m_lasrLibraryNameField.getText().trim();
            data[3] = " LASR_LIBRARY_LIBREF=" + this.m_lasrLibraryLibrefField.getText().trim();
            data[5] = " LASR_SERVER_CONTEXT=" + ((String)this.m_lasrServerContextField.getSelectedItem()).trim();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_lasrLibraryNameLabel.getText(), this.m_lasrLibraryNameField);
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptText(this.m_lasrLibraryLibrefLabel.getText(), this.m_lasrLibraryLibrefField);
        }
        if (returnCode > -1) {
            returnCode = ConsoleMode.promptComboBox(this.m_lasrServerContextField);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("LASR_LIBRARY_NAME", null);
        if (response != null) {
            this.m_lasrLibraryNameField.setText(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "LASR_LIBRARY_NAME");
        }
        if (valid) {
            response = Wizard.getResponse("LASR_LIBRARY_LIBREF", null);
            if (response != null) {
                this.m_lasrLibraryLibrefField.setText(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_LIBRARY_LIBREF");
            }
        }
        if (valid) {
            response = Wizard.getResponse("LASR_SERVER_CONTEXT", null);
            if (response != null) {
                this.m_lasrServerContextField.setSelectedItem(response);
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseMissing(this.getHeader(), "LASR_SERVER_CONTEXT");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_lasrLibraryNameField = new KitTextField();
        String mtxt = this.bundle.getString("PanelAutoloadLasrLibrary.LasrLibraryNameLabel.txt");
        this.m_lasrLibraryNameLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrLibraryNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrLibraryNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrLibraryNameLabel.setLabelFor(this.m_lasrLibraryNameField);
        this.m_lasrLibraryLibrefField = new KitTextField();
        mtxt = this.bundle.getString("PanelAutoloadLasrLibrary.LasrLibraryLibrefLabel.txt");
        this.m_lasrLibraryLibrefLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrLibraryLibrefLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrLibraryLibrefLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrLibraryLibrefLabel.setLabelFor(this.m_lasrLibraryLibrefField);
        this.m_lasrServerContextField = new JComboBox();
        this.m_lasrServerContextField.removeAllItems();
        this.m_lasrServerContextField.setSelectedItem(0);
        mtxt = this.bundle.getString("PanelAutoloadLasrLibrary.LasrServerContextLabel.txt");
        this.m_lasrServerContextLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrServerContextLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrServerContextLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrServerContextLabel.setLabelFor(this.m_lasrServerContextField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrLibraryNameLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrLibraryNameField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrLibraryLibrefLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrLibraryLibrefField, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrServerContextLabel, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrServerContextField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

