/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.metadata.remote.impl.SASLibraryImpl;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelAutoloadExistingLibrary
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelAutoloadExistingLibrary.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JLabel m_lasrLibraryNameLabel = null;
    private JComboBox m_lasrLibraryNameField = null;
    private boolean m_panelLoaded = false;

    public PanelAutoloadExistingLibrary() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAutoloadExistingLibrary.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAutoloadExistingLibrary.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String libraryName = (String)this.m_lasrLibraryNameField.getSelectedItem();
        if (libraryName == null || libraryName.length() <= 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "LASR_LIBRARY_NAME");
            } else {
                String errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelAutoloadExistingLibrary.LasrLibraryNameField.txt"));
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
        }
        if (valid) {
            Globals.g_configData.setProperty("cfgwizard.lasr.library.name", libraryName);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "autoload";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.populateComboBox();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    private void populateComboBox() {
        String metaQuery = "<xmlselect search=\"SASLibrary[@Engine='SASIOLA']\"/>";
        Vector results = (Vector)MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "SASLibrary", metaQuery);
        for (SASLibraryImpl library : results) {
            try {
                this.m_lasrLibraryNameField.addItem(library.getName());
            }
            catch (RemoteException e) {
                Logging.log.severe(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_lasrLibraryNameField;
    }

    @Override
    public boolean silentEvent() {
        this.populateComboBox();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#EXISTING_LASR_LIBRARY_NAME=<string value>", " EXISTING_LASR_LIBRARY_NAME="};
        if (this.m_panelLoaded) {
            data[1] = " EXISTING_LASR_LIBRARY_NAME=" + ((String)this.m_lasrLibraryNameField.getSelectedItem()).trim();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        return ConsoleMode.promptComboBox(this.m_lasrLibraryNameField);
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("EXISTING_LASR_LIBRARY_NAME", null);
        if (response != null) {
            this.m_lasrLibraryNameField.setSelectedItem(response);
        } else if (Globals.g_quietMode) {
            valid = false;
            Wizard.logResponseMissing(this.getHeader(), "EXISTING_LASR_LIBRARY_NAME");
        }
        return valid;
    }

    private void initialize() {
        this.m_lasrLibraryNameField = new JComboBox();
        this.m_lasrLibraryNameField.removeAllItems();
        this.m_lasrLibraryNameField.setSelectedItem(0);
        String mtxt = this.bundle.getString("PanelAutoloadExistingLibrary.LasrLibraryNameLabel.txt");
        this.m_lasrLibraryNameLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_lasrLibraryNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_lasrLibraryNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_lasrLibraryNameLabel.setLabelFor(this.m_lasrLibraryNameField);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(10, 0, 5, 0);
        this.m_panel.add((Component)this.m_lasrLibraryNameLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_lasrLibraryNameField, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

