/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DialogData;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.PanelExecute;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelApprentice
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelApprentice.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTabbedPane m_tabbedPane = new JTabbedPane();
    private JPanel m_metadataTab = new JPanel(new GridBagLayout());
    private JPanel m_overrideTab = new JPanel(new GridBagLayout());
    private JPanel m_resolveTab = new JPanel(new GridBagLayout());
    private JPanel m_sourceTab = new JPanel(new GridBagLayout());
    private JPanel m_launchTab = new JPanel(new GridBagLayout());
    private JRadioButton m_statusObjects = null;
    private JRadioButton m_configObjects = null;
    private JLabel m_objectsLabel = null;
    private JComboBox m_objects = null;
    private JButton m_loadProperties = null;
    private JTable m_propsTable = null;
    private JLabel m_propsInLabel = null;
    private JTextArea m_propsIn = null;
    private JScrollPane m_inScrollPane = null;
    private JButton m_resolveProps = null;
    private JLabel m_propsOutLabel = null;
    private JTextArea m_propsOut = null;
    private JScrollPane m_outScrollPane = null;
    private JLabel m_findLabel = null;
    private KitTextField m_findText = null;
    private JButton m_findButton = null;
    private JTable m_sourceTable = null;
    private JLabel m_findOLabel = null;
    private KitTextField m_findOText = null;
    private JButton m_findOButton = null;
    private JTable m_overrideTable = null;
    private JTable m_launchTable = null;
    private JButton m_clearButton = null;
    private JButton m_restoreButton = null;
    private JCheckBox m_skipDMUpdate = null;
    private OverrideTableModel m_overrideModel = null;
    private PropertiesTableModel m_tableModel = null;
    private SourceTableModel m_sourceModel = null;
    private LaunchTableModel m_launchModel = null;
    private HashMap<String, DialogData.Property> m_dialogProperties = new HashMap();
    private Properties m_origValues = new Properties();
    private boolean[][] m_initialTargets = new boolean[0][0];
    private boolean m_initialSet = false;
    private String m_connectHost = null;
    private String m_connectPort = null;
    private String m_connectRepos = null;
    private String m_connectUser = null;
    private String m_connectPassword = null;

    public PanelApprentice() {
        this.loadPropData();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelApprentice.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelApprentice.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        if (this.m_overrideModel != null) {
            String logMsg = "";
            String propVal = null;
            String[] ids = this.m_overrideModel.getIds();
            OverrideData data = null;
            HashMap<String, OverrideData> tableData = this.m_overrideModel.getData();
            for (int i = 0; i < ids.length; ++i) {
                data = tableData.get(ids[i]);
                if (data.getOverride() == null || data.getOverride().length() <= 0) continue;
                logMsg = logMsg + Globals.g_eol + "      " + data.getName() + "=" + data.getOverride();
                propVal = propVal == null ? data.getName() : propVal + " " + data.getName();
            }
            if (logMsg.length() > 0) {
                Logging.log.warning("The following properties were overridden using -apprentice:" + logMsg);
                Globals.g_configData.setSDWProperty("wizard.override.properties", propVal);
            }
        }
        if (Globals.g_mode != 5) {
            if (this.m_skipDMUpdate != null) {
                Globals.g_skipDMUpdate = this.m_skipDMUpdate.isSelected();
            }
            String[] prodCodes = this.m_launchModel.getRowNames();
            String[] targets = this.m_launchModel.getColNames();
            for (int row = 0; row < prodCodes.length; ++row) {
                for (int col = 1; col < targets.length; ++col) {
                    if (this.m_launchModel.isSelected(row, col)) {
                        Globals.g_configDefaults.setDefault(prodCodes[row] + "." + targets[col] + ".target.is_called", "TRUE");
                        continue;
                    }
                    Globals.g_configDefaults.setDefault(prodCodes[row] + "." + targets[col] + ".target.is_called", "FALSE");
                }
            }
            PanelExecute panelExecute = (PanelExecute)Globals.g_wizard.getPanel("execute");
            panelExecute.getInstallProducts(true);
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (Globals.g_mode != 5) {
            panelID = "execute";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (Globals.g_mode == 5) {
            if (!(this.m_connectHost != null && this.m_connectHost.equals(Globals.g_cmtConnectHost) && this.m_connectPort != null && this.m_connectPort.equals(Globals.g_cmtConnectPort) && this.m_connectRepos != null && this.m_connectRepos.equals(Globals.g_cmtConnectRepos) && this.m_connectUser != null && this.m_connectUser.equals(Globals.g_cmtConnectUser))) {
                this.m_connectHost = Globals.g_cmtConnectHost;
                this.m_connectPort = Globals.g_cmtConnectPort;
                this.m_connectRepos = Globals.g_cmtConnectRepos;
                this.m_connectUser = Globals.g_cmtConnectUser;
                this.m_connectPassword = Globals.g_cmtConnectPassword;
                this.loadObjects();
            }
        } else {
            boolean configMetadataServer = false;
            for (int i = 0; i < Globals.g_planConfigs.length && !configMetadataServer; ++i) {
                if (!Globals.g_planConfigs[i].equalsIgnoreCase("metadatasrv")) continue;
                configMetadataServer = true;
            }
            this.m_overrideModel.load();
            this.m_launchModel.load();
            this.m_tabbedPane.setEnabledAt(this.m_tabbedPane.getTabCount() - 1, !configMetadataServer);
            if (!(this.m_connectHost != null && this.m_connectHost.equals(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", "")) && this.m_connectPort != null && this.m_connectPort.equals(Globals.g_configData.getProperty("iomsrv.metadatasrv.port", "")) && this.m_connectRepos != null && this.m_connectRepos.equals(Globals.g_configData.getProperty("oma.repository.foundation.name", "")) && this.m_connectUser != null && this.m_connectUser.equals(Globals.g_configData.getProperty("oma.person.admin.login.userid", "")))) {
                this.m_connectHost = Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null);
                this.m_connectPort = Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null);
                this.m_connectRepos = Globals.g_configData.getProperty("oma.repository.foundation.name", null);
                this.m_connectUser = Globals.g_configData.getProperty("oma.person.admin.login.userid", null);
                this.m_connectPassword = Globals.g_configData.getProperty("oma.person.admin.login.passwd", null);
                this.loadObjects();
            }
        }
        this.m_sourceModel.load();
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_tabbedPane;
    }

    @Override
    public boolean silentEvent() {
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        return 0;
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private void initialize() {
        int count = 0;
        String mtxt = null;
        if (Globals.g_mode == 5) {
            this.createMetadataTab();
            mtxt = this.bundle.getString("PanelApprentice.MetadataTab.Title.txt");
            this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_metadataTab, this.bundle.getString("PanelApprentice.MetadataTab.Tip.txt"));
            this.m_tabbedPane.setMnemonicAt(count, Util.getDisplayedMnemonic(mtxt));
            this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
            ++count;
        } else {
            this.createOverrideTab();
            mtxt = this.bundle.getString("PanelApprentice.OverrideTab.Title.txt");
            this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_overrideTab, this.bundle.getString("PanelApprentice.OverrideTab.Tip.txt"));
            this.m_tabbedPane.setMnemonicAt(count, Util.getDisplayedMnemonic(mtxt));
            this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
            ++count;
        }
        this.createResolveTab();
        mtxt = this.bundle.getString("PanelApprentice.PropertiesTab.Title.txt");
        this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_resolveTab, this.bundle.getString("PanelApprentice.PropertiesTab.Tip.txt"));
        this.m_tabbedPane.setMnemonicAt(count, Util.getDisplayedMnemonic(mtxt));
        this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
        this.createDefaultTab();
        mtxt = this.bundle.getString("PanelApprentice.SourceTab.Title.txt");
        this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_sourceTab, this.bundle.getString("PanelApprentice.SourceTab.Tip.txt"));
        this.m_tabbedPane.setMnemonicAt(++count, Util.getDisplayedMnemonic(mtxt));
        this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
        ++count;
        if (Globals.g_mode != 5) {
            this.createLaunchTab();
            mtxt = this.bundle.getString("PanelApprentice.LaunchTab.Title.txt");
            this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_launchTab, this.bundle.getString("PanelApprentice.LaunchTab.Tip.txt"));
            this.m_tabbedPane.setMnemonicAt(count, Util.getDisplayedMnemonic(mtxt));
            this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
            this.createMetadataTab();
            mtxt = this.bundle.getString("PanelApprentice.MetadataTab.Title.txt");
            this.m_tabbedPane.addTab(Util.getLabelWithoutMnemonic(mtxt), null, this.m_metadataTab, this.bundle.getString("PanelApprentice.MetadataTab.Tip.txt"));
            this.m_tabbedPane.setMnemonicAt(++count, Util.getDisplayedMnemonic(mtxt));
            this.m_tabbedPane.setDisplayedMnemonicIndexAt(count, Util.getDisplayedMnemonicIndex(mtxt));
            ++count;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_tabbedPane, c);
    }

    private void createMetadataTab() {
        String mtxt = this.bundle.getString("PanelApprentice.StatusObjects.txt");
        this.m_statusObjects = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_statusObjects.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_statusObjects.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_statusObjects.addActionListener(this);
        this.m_statusObjects.setSelected(true);
        mtxt = this.bundle.getString("PanelApprentice.ConfigObjects.txt");
        this.m_configObjects = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configObjects.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configObjects.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configObjects.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_statusObjects);
        group.add(this.m_configObjects);
        this.m_objects = new JComboBox();
        mtxt = this.bundle.getString("PanelApprentice.ObjectsList.txt");
        this.m_objectsLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_objectsLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_objectsLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_objectsLabel.setLabelFor(this.m_objects);
        mtxt = this.bundle.getString("PanelApprentice.LoadProperties.txt");
        this.m_loadProperties = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_loadProperties.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_loadProperties.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_loadProperties.addActionListener(this);
        this.m_tableModel = new PropertiesTableModel();
        this.m_propsTable = new JTable(this.m_tableModel);
        this.m_propsTable.setAutoCreateRowSorter(true);
        this.m_propsTable.setAutoResizeMode(0);
        this.m_propsTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelApprentice.this.m_propsTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane tablePane = new JScrollPane(this.m_propsTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_metadataTab.add((Component)this.m_statusObjects, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_metadataTab.add((Component)this.m_configObjects, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_metadataTab.add((Component)this.m_objectsLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_metadataTab.add((Component)this.m_objects, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_metadataTab.add((Component)this.m_loadProperties, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_metadataTab.add((Component)tablePane, c);
    }

    private void createOverrideTab() {
        this.m_findOText = new KitTextField();
        this.m_findOText.getDocument().addDocumentListener(new TextChangeListener());
        String mtxt = this.bundle.getString("PanelApprentice.Search.Label.txt");
        this.m_findOLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findOLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findOLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findOLabel.setLabelFor(this.m_findOText);
        mtxt = this.bundle.getString("PanelApprentice.FindNext.Button.txt");
        this.m_findOButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findOButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findOButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findOButton.addActionListener(this);
        this.m_overrideModel = new OverrideTableModel();
        this.m_overrideTable = new JTable(this.m_overrideModel);
        this.m_overrideTable.setAutoCreateRowSorter(true);
        this.m_overrideTable.setAutoResizeMode(0);
        this.m_overrideTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelApprentice.this.m_overrideTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane overridePane = new JScrollPane(this.m_overrideTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_overrideTab.add((Component)this.m_findOLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_overrideTab.add((Component)this.m_findOText, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_overrideTab.add((Component)this.m_findOButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_overrideTab.add((Component)overridePane, c);
    }

    private void createResolveTab() {
        this.m_propsIn = new JTextArea();
        this.m_propsIn.setOpaque(true);
        this.m_propsIn.setEditable(true);
        this.m_inScrollPane = new JScrollPane(this.m_propsIn);
        String mtxt = this.bundle.getString("PanelApprentice.PropsIn.txt");
        this.m_propsInLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_propsInLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_propsInLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_propsInLabel.setLabelFor(this.m_propsIn);
        this.m_propsOut = new JTextArea();
        this.m_propsOut.setOpaque(true);
        this.m_propsOut.setEditable(true);
        this.m_outScrollPane = new JScrollPane(this.m_propsOut);
        mtxt = this.bundle.getString("PanelApprentice.PropsOut.txt");
        this.m_propsOutLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_propsOutLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_propsOutLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_propsOutLabel.setLabelFor(this.m_propsOut);
        mtxt = this.bundle.getString("PanelApprentice.Resolve.txt");
        this.m_resolveProps = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_resolveProps.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_resolveProps.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_resolveProps.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_resolveTab.add((Component)this.m_propsInLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_resolveTab.add((Component)this.m_inScrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_resolveTab.add((Component)this.m_resolveProps, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_resolveTab.add((Component)this.m_propsOutLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_resolveTab.add((Component)this.m_outScrollPane, c);
    }

    private void createDefaultTab() {
        this.m_findText = new KitTextField();
        this.m_findText.getDocument().addDocumentListener(new TextChangeListener());
        String mtxt = this.bundle.getString("PanelApprentice.Search.Label.txt");
        this.m_findLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findLabel.setLabelFor(this.m_findText);
        mtxt = this.bundle.getString("PanelApprentice.FindNext.Button.txt");
        this.m_findButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_findButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_findButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_findButton.addActionListener(this);
        this.m_sourceModel = new SourceTableModel();
        this.m_sourceTable = new JTable(this.m_sourceModel);
        this.m_sourceTable.setAutoCreateRowSorter(true);
        this.m_sourceTable.setAutoResizeMode(0);
        this.m_sourceTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelApprentice.this.m_sourceTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane sourcePane = new JScrollPane(this.m_sourceTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_sourceTab.add((Component)this.m_findLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_sourceTab.add((Component)this.m_findText, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_sourceTab.add((Component)this.m_findButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_sourceTab.add((Component)sourcePane, c);
    }

    private void createLaunchTab() {
        String mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_clearButton.addActionListener(this);
        mtxt = this.bundle.getString("PanelApprentice.Restore.Button.txt");
        this.m_restoreButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_restoreButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_restoreButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_restoreButton.addActionListener(this);
        mtxt = this.bundle.getString("PanelApprentice.SkipDMUpdate.txt");
        this.m_skipDMUpdate = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_skipDMUpdate.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_skipDMUpdate.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_launchModel = new LaunchTableModel();
        this.m_launchTable = new JTable(this.m_launchModel);
        this.m_launchTable.setCellSelectionEnabled(true);
        this.m_launchTable.setSelectionMode(0);
        this.m_launchTable.setAutoResizeMode(0);
        this.m_launchTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PanelApprentice.this.m_launchTable.getParent().dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane launchPane = new JScrollPane(this.m_launchTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_launchTab.add((Component)this.m_restoreButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_launchTab.add((Component)this.m_clearButton, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_launchTab.add((Component)this.m_skipDMUpdate, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_launchTab.add((Component)launchPane, c);
    }

    private void loadPropData() {
        String productDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "cfgwizard", true, true);
        String dialogPropertiesFile = DialogData.getCfgwizardConfigBundlePath();
        String[] osTypes = new String[]{"zos", "win", "unx"};
        for (int osNum = 0; osNum < osTypes.length; ++osNum) {
            DialogData dialogData = null;
            DialogData.Dialog[] dialogs = null;
            try {
                dialogData = new DialogData(dialogPropertiesFile);
                dialogs = dialogData.getDialogs(osTypes[osNum]);
            }
            catch (Exception e) {
                Logging.log.severe("Error loading configure dialog properties file: " + dialogPropertiesFile);
                Logging.logStackTrace(e);
            }
            if (dialogData == null) continue;
            String name = null;
            DialogData.Property[] dialogProperties = null;
            for (int i = 0; i < dialogs.length; ++i) {
                dialogProperties = dialogs[i].getProperties();
                for (int j = 0; j < dialogProperties.length; ++j) {
                    name = dialogProperties[j].getName();
                    if (this.m_dialogProperties.containsKey(name)) continue;
                    this.m_dialogProperties.put(name, dialogProperties[j]);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_loadProperties) {
            this.m_tableModel.load();
        } else if (src == this.m_configObjects || src == this.m_statusObjects) {
            this.loadObjects();
        } else if (src == this.m_resolveProps) {
            this.resolveProperties();
        } else if (src == this.m_findButton) {
            this.findNextProperty();
        } else if (src == this.m_findOButton) {
            this.findONextProperty();
        } else if (src == this.m_clearButton) {
            this.m_launchModel.clearAll();
        } else if (src == this.m_restoreButton) {
            this.m_launchModel.restore();
        }
    }

    private void loadObjects() {
        int i;
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }
        this.m_objects.removeAllItems();
        String[] objectList = null;
        if (this.m_statusObjects.isSelected()) {
            ConfigStatus.StatusEntry[] statusEntries;
            ArrayList<String> filteredList = new ArrayList<String>();
            filteredList.add("<All Products>=0");
            String name = null;
            String fqid = null;
            if (Globals.g_mode == 5) {
                if (Globals.g_levdirrootFQID != null) {
                    name = MetadataAccess.getObjectName(this.m_connectHost, this.m_connectPort, this.m_connectRepos, this.m_connectUser, this.m_connectPassword, Globals.g_levdirrootFQID);
                    filteredList.add(name + "=" + Globals.g_levdirrootFQID);
                }
                for (int i2 = 0; i2 < Globals.g_instances.length; ++i2) {
                    fqid = Globals.g_instances[i2].getInstanceData().getFQID();
                    name = MetadataAccess.getObjectName(this.m_connectHost, this.m_connectPort, this.m_connectRepos, this.m_connectUser, this.m_connectPassword, fqid);
                    if (name == null || name.length() == 0) {
                        name = Globals.g_instances[i2].getProdName();
                    }
                    filteredList.add(name + "=" + fqid);
                }
            } else if (Globals.g_reconfigure && Globals.g_configStatus != null && (statusEntries = Globals.g_configStatus.getStatusEntries()) != null) {
                for (int i3 = 0; i3 < statusEntries.length; ++i3) {
                    fqid = statusEntries[i3].getFQID();
                    name = MetadataAccess.getObjectName(this.m_connectHost, this.m_connectPort, this.m_connectRepos, this.m_connectUser, this.m_connectPassword, fqid);
                    if (name == null || name.length() == 0) {
                        ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, statusEntries[i3].getCode(), true);
                        name = prodData.getProdName();
                    }
                    filteredList.add(name + "=" + fqid);
                }
            }
            objectList = filteredList.toArray(new String[0]);
        } else if (this.m_configObjects.isSelected()) {
            String objects = MetadataAccess.metaQuery(this.m_connectHost, this.m_connectPort, this.m_connectRepos, this.m_connectUser, this.m_connectPassword, "<XMLSelect search=\"SoftwareComponent\"/>");
            objects = "<All Products>=0|" + objects;
            objectList = objects.split("\\|");
            ArrayList<String> filteredList = new ArrayList<String>();
            for (int i4 = 0; i4 < objectList.length; ++i4) {
                String[] parts = objectList[i4].split("=");
                if (parts.length != 2) continue;
                String fqid = parts[1].trim();
                if (fqid.equals("0")) {
                    filteredList.add(objectList[i4]);
                    continue;
                }
                Properties objProps = MetadataAccess.getObjectProperties(this.m_connectHost, this.m_connectPort, this.m_connectRepos, this.m_connectUser, this.m_connectPassword, fqid);
                if (objProps == null || objProps.size() <= 0) continue;
                filteredList.add(objectList[i4]);
            }
            objectList = filteredList.toArray(new String[0]);
        }
        int swapPos = 0;
        String swapData = null;
        for (i = 1; i < objectList.length; ++i) {
            swapPos = i;
            for (int j = i; j < objectList.length; ++j) {
                if (objectList[j].toLowerCase(Locale.ENGLISH).compareTo(objectList[swapPos].toLowerCase(Locale.ENGLISH)) >= 0) continue;
                swapPos = j;
            }
            swapData = objectList[i];
            objectList[i] = objectList[swapPos];
            objectList[swapPos] = swapData;
        }
        for (i = 0; i < objectList.length; ++i) {
            this.m_objects.addItem(objectList[i]);
        }
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void resolveProperties() {
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }
        String outText = "";
        ArrayList<String> outProps = new ArrayList<String>();
        Properties propsIn = new Properties();
        try {
            propsIn.load(new ByteArrayInputStream(this.m_propsIn.getText().getBytes()));
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        String key = null;
        String value = null;
        Enumeration<Object> e = propsIn.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = propsIn.getProperty(key);
            if (key.equalsIgnoreCase("globalroot.configobj.fqid")) {
                System.out.println(value);
            }
            if (PropertyRules.containsProperty(value)) {
                value = PropertyRules.resolveProperties(value, 0);
            }
            outProps.add(key + "=" + value);
        }
        int swapPos = 0;
        String swapData = null;
        for (int i = 0; i < outProps.size(); ++i) {
            swapPos = i;
            for (int j = i; j < outProps.size(); ++j) {
                if (((String)outProps.get(j)).toLowerCase(Locale.ENGLISH).compareTo(((String)outProps.get(swapPos)).toLowerCase(Locale.ENGLISH)) >= 0) continue;
                swapPos = j;
            }
            swapData = (String)outProps.get(i);
            outProps.set(i, (String)outProps.get(swapPos));
            outProps.set(swapPos, swapData);
            outText = outText + (String)outProps.get(i) + "\n";
        }
        this.m_propsOut.setText(outText);
        if (Globals.g_wizard.getFrame() != null) {
            Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void findNextProperty() {
        int rowFound = -1;
        String findText = this.m_findText.getText().trim().toLowerCase();
        if (findText.length() > 0) {
            int i;
            String name = null;
            String value = null;
            String file = null;
            for (i = this.m_sourceTable.getSelectedRow() + 1; rowFound == -1 && i < this.m_sourceTable.getRowCount(); ++i) {
                name = (String)this.m_sourceTable.getValueAt(i, 0);
                value = (String)this.m_sourceTable.getValueAt(i, 1);
                file = (String)this.m_sourceTable.getValueAt(i, 2);
                if (name.toLowerCase().indexOf(findText) <= -1 && value.toLowerCase().indexOf(findText) <= -1 && file.toLowerCase().indexOf(findText) <= -1) continue;
                rowFound = i;
            }
            if (rowFound == -1) {
                for (i = 0; rowFound == -1 && i <= this.m_sourceTable.getSelectedRow(); ++i) {
                    name = (String)this.m_sourceTable.getValueAt(i, 0);
                    value = (String)this.m_sourceTable.getValueAt(i, 1);
                    file = (String)this.m_sourceTable.getValueAt(i, 2);
                    if (name.toLowerCase().indexOf(findText) <= -1 && value.toLowerCase().indexOf(findText) <= -1 && file.toLowerCase().indexOf(findText) <= -1) continue;
                    rowFound = i;
                }
            }
            if (rowFound > -1) {
                this.m_sourceTable.setRowSelectionInterval(rowFound, rowFound);
                this.m_sourceTable.scrollRectToVisible(this.m_sourceTable.getCellRect(rowFound, 0, true));
            } else {
                String title = Globals.g_wizard.getWizardTitle();
                String message = this.bundle.messageString("PanelApprentice.NotFoundMsg.txt", this.m_findText.getText());
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, title, 1);
            }
        }
    }

    private void findONextProperty() {
        int rowFound = -1;
        String findText = this.m_findOText.getText().trim().toLowerCase();
        if (findText.length() > 0) {
            int i;
            String name = null;
            String value = null;
            String override = null;
            for (i = this.m_overrideTable.getSelectedRow() + 1; rowFound == -1 && i < this.m_overrideTable.getRowCount(); ++i) {
                name = (String)this.m_overrideTable.getValueAt(i, 0);
                value = (String)this.m_overrideTable.getValueAt(i, 1);
                override = (String)this.m_overrideTable.getValueAt(i, 2);
                if (name.toLowerCase().indexOf(findText) <= -1 && value.toLowerCase().indexOf(findText) <= -1 && override.toLowerCase().indexOf(findText) <= -1) continue;
                rowFound = i;
            }
            if (rowFound == -1) {
                for (i = 0; rowFound == -1 && i <= this.m_overrideTable.getSelectedRow(); ++i) {
                    name = (String)this.m_overrideTable.getValueAt(i, 0);
                    value = (String)this.m_overrideTable.getValueAt(i, 1);
                    override = (String)this.m_overrideTable.getValueAt(i, 2);
                    if (name.toLowerCase().indexOf(findText) <= -1 && value.toLowerCase().indexOf(findText) <= -1 && override.toLowerCase().indexOf(findText) <= -1) continue;
                    rowFound = i;
                }
            }
            if (rowFound > -1) {
                this.m_overrideTable.setRowSelectionInterval(rowFound, rowFound);
                this.m_overrideTable.scrollRectToVisible(this.m_overrideTable.getCellRect(rowFound, 0, true));
            } else {
                String title = Globals.g_wizard.getWizardTitle();
                String message = this.bundle.messageString("PanelApprentice.NotFoundMsg.txt", this.m_findOText.getText());
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), message, title, 1);
            }
        }
    }

    static /* synthetic */ boolean[][] access$502(PanelApprentice x0, boolean[][] x1) {
        x0.m_initialTargets = x1;
        return x1;
    }

    private class CheckBoxEditor
    extends DefaultCellEditor {
        private JCheckBox m_checkBox;

        public CheckBoxEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = null;
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.m_checkBox.setText("");
            this.m_checkBox.setHorizontalAlignment(0);
            if (value == null) {
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    this.m_checkBox.setSelected(PanelApprentice.this.m_launchModel.isSelected(row, col));
                }
            }
            return this.m_checkBox;
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText("");
            this.setHorizontalAlignment(0);
            if (value == null) {
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    this.setSelected(PanelApprentice.this.m_launchModel.isSelected(row, col));
                }
            }
            return this;
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setDefaultButton();
        }

        private void setDefaultButton() {
            if (Globals.g_wizard.getFrame() != null) {
                if (PanelApprentice.this.m_findText.isVisible() && PanelApprentice.this.m_findText.getText().length() > 0) {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(PanelApprentice.this.m_findButton);
                } else if (PanelApprentice.this.m_findOText.isVisible() && PanelApprentice.this.m_findOText.getText().length() > 0) {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(PanelApprentice.this.m_findOButton);
                } else {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
                }
            }
        }
    }

    class TableData {
        private String m_name = null;
        private String m_value = null;
        private String m_rule = null;
        private String m_owner = null;
        private String m_prompt = null;
        private String m_scope = null;
        private String m_version = null;
        private String m_fqid = null;

        public TableData(String name, String value, String rule, String owner, String prompt, String scope, String version, String fqid) {
            this.m_name = name;
            this.m_value = value;
            this.m_rule = rule;
            this.m_owner = owner;
            this.m_prompt = prompt;
            this.m_scope = scope;
            this.m_version = version;
            this.m_fqid = fqid;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getRule() {
            return this.m_rule;
        }

        public String getOwner() {
            return this.m_owner;
        }

        public String getPrompt() {
            return this.m_prompt;
        }

        public String getScope() {
            return this.m_scope;
        }

        public String getVersion() {
            return this.m_version;
        }

        public String getFQID() {
            return this.m_fqid;
        }
    }

    class SourceData {
        private String m_name = null;
        private String m_value = null;
        private String m_file = null;

        public SourceData(String name, String value, String file) {
            this.m_name = name;
            this.m_value = value;
            this.m_file = file;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getFile() {
            return this.m_file;
        }
    }

    class OverrideData {
        private String m_name = null;
        private String m_value = null;
        private String m_override = null;

        public OverrideData(String name, String value, String override) {
            this.m_name = name;
            this.m_value = value;
            this.m_override = override;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getOverride() {
            return this.m_override;
        }

        public void setOverride(String override) {
            this.m_override = override;
        }
    }

    class PropertiesTableModel
    extends AbstractTableModel {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_VALUE = 1;
        public static final int COLUMN_RULE = 2;
        public static final int COLUMN_OWNER = 3;
        public static final int COLUMN_PROMPT = 4;
        public static final int COLUMN_SCOPE = 5;
        public static final int COLUMN_VERSION = 6;
        public static final int COLUMN_FQID = 7;
        private String[] m_colNames = null;
        private String[] m_ids = null;
        private HashMap<String, TableData> m_properties = new HashMap();

        public PropertiesTableModel() {
            this.m_colNames = new String[]{PanelApprentice.this.bundle.getString("PanelApprentice.Name.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Value.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Rule.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Owner.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Prompt.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Scope.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Version.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.FQID.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_colNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_colNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_properties.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String value = null;
            String id = null;
            if (row < this.m_ids.length) {
                id = this.m_ids[row];
            }
            if (id != null) {
                TableData data = this.m_properties.get(id);
                if (col == 0) {
                    value = data.getName();
                } else if (col == 1) {
                    value = data.getValue();
                } else if (col == 2) {
                    value = data.getRule();
                } else if (col == 3) {
                    value = data.getOwner();
                } else if (col == 4) {
                    value = data.getPrompt();
                } else if (col == 5) {
                    value = data.getScope();
                } else if (col == 6) {
                    value = data.getVersion();
                } else if (col == 7) {
                    value = data.getFQID();
                }
            }
            return value;
        }

        public void load() {
            String[] parts;
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            ArrayList<String> ids = new ArrayList<String>();
            this.m_ids = new String[0];
            this.m_properties.clear();
            String object = (String)PanelApprentice.this.m_objects.getSelectedItem();
            if (object != null && (parts = object.split("=")).length == 2) {
                String fqid = parts[1].trim();
                String[] fqids = null;
                if (fqid.equals("0")) {
                    String item = null;
                    ArrayList<String> fqidList = new ArrayList<String>();
                    for (int i = 0; i < PanelApprentice.this.m_objects.getItemCount(); ++i) {
                        item = (String)PanelApprentice.this.m_objects.getItemAt(i);
                        parts = item.split("=");
                        if (parts.length != 2 || (fqid = parts[1].trim()).equals("0")) continue;
                        fqidList.add(fqid);
                    }
                    fqids = fqidList.toArray(new String[0]);
                } else {
                    fqids = new String[]{fqid};
                }
                for (int fqidCount = 0; fqidCount < fqids.length; ++fqidCount) {
                    Properties objProps = MetadataAccess.getObjectProperties(PanelApprentice.this.m_connectHost, PanelApprentice.this.m_connectPort, PanelApprentice.this.m_connectRepos, PanelApprentice.this.m_connectUser, PanelApprentice.this.m_connectPassword, fqids[fqidCount]);
                    if (objProps == null) continue;
                    DialogData.Property property = null;
                    String id = null;
                    String name = null;
                    String value = null;
                    String rule = null;
                    String owner = null;
                    String prompt = null;
                    String scope = null;
                    String version = null;
                    TableData data = null;
                    Enumeration<Object> e = objProps.keys();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        value = objProps.getProperty(name, null);
                        rule = null;
                        owner = null;
                        prompt = null;
                        scope = null;
                        version = null;
                        property = (DialogData.Property)PanelApprentice.this.m_dialogProperties.get(name);
                        if (property != null) {
                            rule = property.getRule();
                            owner = property.getOwner();
                            prompt = property.getGenPrompt();
                            scope = property.getScope() == 1 ? "Public" : "Private";
                            version = property.getVersion() == 0.0f ? "" : Float.toString(property.getVersion());
                        }
                        data = new TableData(name, value, rule, owner, prompt, scope, version, fqids[fqidCount]);
                        id = name + fqids[fqidCount];
                        ids.add(id);
                        this.m_properties.put(id, data);
                    }
                }
                this.m_ids = ids.toArray(new String[0]);
                this.fireTableDataChanged();
                this.fireTableStructureChanged();
                PanelApprentice.this.m_propsTable.getRowSorter().toggleSortOrder(0);
                PanelApprentice.this.m_propsTable.getTableHeader().setReorderingAllowed(false);
                int colWidth = (int)(PanelApprentice.this.m_propsTable.getPreferredSize().getWidth() / (double)this.m_colNames.length);
                for (int i = 0; i < this.m_colNames.length; ++i) {
                    PanelApprentice.this.m_propsTable.getColumnModel().getColumn(i).setPreferredWidth(colWidth);
                }
            }
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class SourceTableModel
    extends AbstractTableModel {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_VALUE = 1;
        public static final int COLUMN_FILE = 2;
        private String[] m_colNames = null;
        private String[] m_ids = null;
        private HashMap<String, SourceData> m_sourceData = new HashMap();

        public SourceTableModel() {
            this.m_colNames = new String[]{PanelApprentice.this.bundle.getString("PanelApprentice.Name.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Value.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.SourceFile.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_colNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_colNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_sourceData.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String value = null;
            String id = null;
            if (row < this.m_ids.length) {
                id = this.m_ids[row];
            }
            if (id != null) {
                SourceData data = this.m_sourceData.get(id);
                if (col == 0) {
                    value = data.getName();
                } else if (col == 1) {
                    value = data.getValue();
                } else if (col == 2) {
                    value = data.getFile();
                }
            }
            return value;
        }

        public void load() {
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            ArrayList<String> ids = new ArrayList<String>();
            this.m_ids = new String[0];
            this.m_sourceData.clear();
            String name2 = null;
            String value = null;
            String file = null;
            SourceData data = null;
            for (String name2 : Globals.g_configPropsSource.keySet()) {
                value = Globals.g_configDefaults.getDefault(name2, "");
                file = (String)Globals.g_configPropsSource.get(name2);
                data = new SourceData(name2, value, file);
                ids.add(name2);
                this.m_sourceData.put(name2, data);
            }
            this.m_ids = ids.toArray(new String[0]);
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelApprentice.this.m_sourceTable.getRowSorter().toggleSortOrder(0);
            PanelApprentice.this.m_sourceTable.getTableHeader().setReorderingAllowed(false);
            for (int i = 0; i < this.m_colNames.length; ++i) {
                PanelApprentice.this.m_sourceTable.getColumnModel().getColumn(i).setPreferredWidth(200);
            }
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }

        public String[] getIds() {
            return this.m_ids;
        }

        public HashMap<String, SourceData> getData() {
            return this.m_sourceData;
        }
    }

    class OverrideTableModel
    extends AbstractTableModel {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_VALUE = 1;
        public static final int COLUMN_OVERRIDE = 2;
        private String[] m_colNames = null;
        private String[] m_ids = null;
        private HashMap<String, OverrideData> m_overrideData = new HashMap();

        public OverrideTableModel() {
            this.m_colNames = new String[]{PanelApprentice.this.bundle.getString("PanelApprentice.Name.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Value.txt"), PanelApprentice.this.bundle.getString("PanelApprentice.Override.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_colNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_colNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_overrideData.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String value = null;
            String id = null;
            if (row < this.m_ids.length) {
                id = this.m_ids[row];
            }
            if (id != null) {
                OverrideData data = this.m_overrideData.get(id);
                if (col == 0) {
                    value = data.getName();
                } else if (col == 1) {
                    value = data.getValue();
                } else if (col == 2) {
                    value = data.getOverride();
                }
            }
            return value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2 && value != null) {
                String id = null;
                if (row < this.m_ids.length) {
                    id = this.m_ids[row];
                }
                if (id != null) {
                    String propValue = (String)value;
                    OverrideData data = this.m_overrideData.get(id);
                    data.setOverride(propValue);
                    if (propValue.length() > 0) {
                        Globals.g_configData.setProperty(data.getName(), propValue);
                        PanelApprentice.this.m_origValues.setProperty(data.getName(), data.getValue());
                    } else {
                        Globals.g_configData.setProperty(data.getName(), data.getValue());
                        PanelApprentice.this.m_origValues.remove(data.getName());
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean editable = col == 2;
            return editable;
        }

        public void load() {
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            ArrayList<String> ids = new ArrayList<String>();
            this.m_ids = new String[0];
            this.m_overrideData.clear();
            Object var2_2 = null;
            String value = null;
            String override = null;
            OverrideData data = null;
            for (String string : Globals.g_configData.getProperties().keySet()) {
                if (PanelApprentice.this.m_origValues.containsKey(string)) {
                    value = PanelApprentice.this.m_origValues.getProperty(string);
                    override = Globals.g_configData.getProperty(string, "");
                } else {
                    value = Globals.g_configData.getProperty(string, "");
                    override = "";
                }
                data = new OverrideData(string, value, override);
                ids.add(string);
                this.m_overrideData.put(string, data);
            }
            this.m_ids = ids.toArray(new String[0]);
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelApprentice.this.m_overrideTable.getRowSorter().toggleSortOrder(0);
            PanelApprentice.this.m_overrideTable.getTableHeader().setReorderingAllowed(false);
            for (int i = 0; i < this.m_colNames.length; ++i) {
                PanelApprentice.this.m_overrideTable.getColumnModel().getColumn(i).setPreferredWidth(200);
            }
            if (Globals.g_wizard.getFrame() != null) {
                Globals.g_wizard.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }

        public String[] getIds() {
            return this.m_ids;
        }

        public HashMap<String, OverrideData> getData() {
            return this.m_overrideData;
        }
    }

    class LaunchTableModel
    extends AbstractTableModel {
        private String[] m_rowNames = new String[0];
        private String[] m_colNames = new String[0];
        private boolean[][] m_selections = new boolean[0][0];

        @Override
        public int getColumnCount() {
            return this.m_colNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_colNames[index];
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_selections.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object value = null;
            if (row < this.m_rowNames.length) {
                value = col == 0 ? this.m_rowNames[row] : Boolean.valueOf(this.m_selections[row][col - 1]);
            }
            return value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean && col != 0) {
                this.m_selections[row][col - 1] = (Boolean)value;
                this.fireTableCellUpdated(row, col - 1);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void load() {
            int i;
            int i2;
            String targetsList = null;
            targetsList = Globals.g_configData.getProperty("config.migration.is_selected", "False").equalsIgnoreCase("True") ? Globals.g_configDefaults.getDefault("cfgwizard.migration.target.list", "") : Globals.g_configDefaults.getDefault("cfgwizard.initialConfig.target.list", "");
            String[] targets = targetsList.split(" ");
            this.m_selections = new boolean[Globals.g_planConfigs.length][targets.length];
            if (!PanelApprentice.this.m_initialSet) {
                PanelApprentice.access$502(PanelApprentice.this, new boolean[Globals.g_planConfigs.length][targets.length]);
            }
            this.m_rowNames = new String[Globals.g_planConfigs.length];
            for (i2 = 0; i2 < Globals.g_planConfigs.length; ++i2) {
                this.m_rowNames[i2] = Globals.g_planConfigs[i2];
            }
            this.m_colNames = new String[targets.length + 1];
            this.m_colNames[0] = PanelApprentice.this.bundle.getString("PanelApprentice.Product.txt");
            for (i2 = 0; i2 < targets.length; ++i2) {
                this.m_colNames[i2 + 1] = targets[i2];
            }
            String targetProp = null;
            boolean isCalled = false;
            for (i = 0; i < Globals.g_planConfigs.length; ++i) {
                for (int j = 0; j < targets.length; ++j) {
                    targetProp = Globals.g_configDefaults.getDefault(Globals.g_planConfigs[i] + "." + targets[j] + ".target.is_called", "FALSE");
                    if (PropertyRules.containsProperty(targetProp)) {
                        targetProp = PropertyRules.resolveProperties(targetProp, 0);
                    }
                    this.m_selections[i][j] = isCalled = targetProp.equalsIgnoreCase("TRUE");
                    if (PanelApprentice.this.m_initialSet) continue;
                    ((PanelApprentice)PanelApprentice.this).m_initialTargets[i][j] = isCalled;
                }
            }
            PanelApprentice.this.m_initialSet = true;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelApprentice.this.m_launchTable.getTableHeader().setReorderingAllowed(false);
            PanelApprentice.this.m_launchTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            for (i = 1; i < this.m_colNames.length; ++i) {
                PanelApprentice.this.m_launchTable.getColumnModel().getColumn(i).setCellRenderer(new CheckBoxRenderer());
                PanelApprentice.this.m_launchTable.getColumnModel().getColumn(i).setCellEditor(new CheckBoxEditor(new JCheckBox()));
                PanelApprentice.this.m_launchTable.getColumnModel().getColumn(i).setPreferredWidth(120);
            }
        }

        public boolean isSelected(int row, int col) {
            boolean selected = false;
            if (col > 0) {
                selected = this.m_selections[row][col - 1];
            }
            return selected;
        }

        public void clearAll() {
            for (int i = 0; i < this.m_selections.length; ++i) {
                for (int j = 0; j < this.m_selections[i].length; ++j) {
                    this.m_selections[i][j] = false;
                }
            }
            this.fireTableDataChanged();
            PanelApprentice.this.m_skipDMUpdate.setSelected(true);
        }

        public void restore() {
            for (int i = 0; i < this.m_selections.length; ++i) {
                for (int j = 0; j < this.m_selections[i].length; ++j) {
                    this.m_selections[i][j] = PanelApprentice.this.m_initialTargets[i][j];
                }
            }
            this.fireTableDataChanged();
            PanelApprentice.this.m_skipDMUpdate.setSelected(false);
        }

        public String[] getColNames() {
            return this.m_colNames;
        }

        public String[] getRowNames() {
            return this.m_rowNames;
        }
    }
}

