/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixManager;
import com.sas.ssn.HotFixPackages;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelChangeHost;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SecurityUpdates;
import com.sas.ssn.StagedSDM;
import com.sas.ssn.StagedSDMException;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PanelApplyHotFix
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelChangeHost.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JLabel m_packageDirLabel = null;
    private KitTextField m_packageDir = null;
    private KitBrowseButton m_browseButton = null;
    private JCheckBox m_installCheckBox = null;
    private JCheckBox m_configureCheckBox = null;
    private boolean m_panelLoaded = false;

    public PanelApplyHotFix() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelApplyHotFix.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelApplyHotFix.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        ArrayList<String> hotFixesRequiringInitRestart = new ArrayList<String>();
        Globals.g_cmtRunInstall = this.m_installCheckBox.isSelected();
        Globals.g_cmtRunConfigure = this.m_configureCheckBox.isSelected();
        Globals.g_selectedHotFixesToInstall.clear();
        List<Object> hotFixesToInstall = new ArrayList();
        String packageDir = "";
        if (Globals.g_cmtRunInstall) {
            File packageDirFile;
            packageDir = Utils.trimTrailingSlashes(this.m_packageDir.getText());
            this.m_packageDir.setText(packageDir);
            if (packageDir.length() == 0) {
                valid = false;
                if (Globals.g_quietMode) {
                    Logging.log.severe("Selected hot fix package dir is of 0 length");
                    if (!Globals.g_silentHotFix) {
                        Wizard.logResponseMissing(this.getHeader(), "HOTFIX_PACKAGE_DIR");
                    }
                } else {
                    errMsg = this.bundle.messageString("Common.Error.RequiredField.txt", this.bundle.getString("PanelApplyHotFix.PackageDirText.txt"));
                }
            }
            if (valid) {
                String quietMsg;
                if (Utils.pathContainsValidChars(packageDir)) {
                    valid = Utils.validatePath(packageDir);
                    if (!valid) {
                        if (Globals.g_quietMode) {
                            quietMsg = "Invalid hot fix package directory specified";
                            Logging.log.severe(quietMsg + ": " + packageDir);
                            if (!Globals.g_silentHotFix) {
                                Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_PACKAGE_DIR", packageDir, quietMsg);
                            }
                        } else {
                            errMsg = this.bundle.messageString("Common.Error.InvalidField.txt", this.bundle.getString("PanelApplyHotFix.PackageDirText.txt"));
                        }
                    }
                } else {
                    valid = false;
                    if (Globals.g_quietMode) {
                        quietMsg = null;
                        quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                        Logging.log.severe(quietMsg + ": " + packageDir);
                        if (!Globals.g_silentHotFix) {
                            Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_PACKAGE_DIR", packageDir, quietMsg);
                        }
                    } else {
                        errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.bundle.getString("PanelApplyHotFix.PackageDirText.txt")) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.bundle.getString("PanelApplyHotFix.PackageDirText.txt")) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.bundle.getString("PanelApplyHotFix.PackageDirText.txt")));
                    }
                }
            }
            if (!(!valid || (packageDirFile = new File(packageDir)).exists() && packageDirFile.isDirectory())) {
                valid = false;
                if (Globals.g_quietMode) {
                    String quietMsg = "The specified hot fix directory is not found or not valid";
                    Logging.log.severe(quietMsg + ": " + packageDir);
                    if (!Globals.g_silentHotFix) {
                        Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_PACKAGE_DIR", packageDir, quietMsg);
                    }
                } else {
                    errMsg = this.bundle.getString("PanelApplyHotFix.DirDoesNotExit");
                }
            }
            boolean securityUpdatesDir = false;
            if (valid) {
                Object finalSubDir;
                File packageDirFile2 = new File(packageDir);
                File[] fileList = packageDirFile2.listFiles();
                String fileName = null;
                boolean foundZip = false;
                if (fileList != null) {
                    for (int i = 0; !foundZip && i < fileList.length; ++i) {
                        fileName = fileList[i].getName();
                        if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".zip")) continue;
                        foundZip = true;
                    }
                }
                if (!(valid = foundZip)) {
                    String quietMsg = "The specified hot fix directory does not contain any hot fix (zip) packages";
                    Logging.log.severe(quietMsg + ": " + packageDir);
                    if (Globals.g_quietMode) {
                        if (!Globals.g_silentHotFix) {
                            Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_PACKAGE_DIR", packageDir, quietMsg);
                        }
                    } else {
                        errMsg = this.bundle.getString("PanelApplyHotFix.NoHotFixPackages");
                    }
                }
                if (((String)(finalSubDir = packageDirFile2.getName().toLowerCase(Locale.ENGLISH))).equals("securityupdates")) {
                    securityUpdatesDir = true;
                }
            }
            if (valid && !securityUpdatesDir) {
                hotFixesRequiringInitRestart.clear();
                HotFixManager hotFixManager = new HotFixManager("postInstallHotFixes", packageDir, "hot_fix_post_install_index.xml");
                if (hotFixManager.createIndexFromHotFixPackageDirectory()) {
                    HotFixPackages hotFixPackages = new HotFixPackages();
                    hotFixPackages.setIndex(hotFixManager.getHotFixIndex());
                    hotFixPackages.setHotFixPackagesDirectory(packageDir);
                    if (hotFixPackages.loadPackages("postInstallHotFixes", false, Utils.GetSDWVersion())) {
                        if (hotFixPackages.availableHotFixes()) {
                            hotFixesToInstall = hotFixPackages.getPostInstallHotFixesToInstall(true);
                            if (hotFixesToInstall == null) {
                                errMsg = this.bundle.getString("PanelApplyHotFix.ErrorProcessingDeploymentRegistry");
                                Logging.log.severe("An error occurred while determining which hot fixes to install.");
                                valid = false;
                            }
                            if (valid) {
                                if (hotFixPackages.atLeastOneHotFixNotApplicable()) {
                                    hotFixPackages.logHotFixesNotApplicable();
                                }
                                if (hotFixPackages.atLeastOneHotFixAlreadyInstalled()) {
                                    hotFixPackages.logAlreadyInstalledHotFixes();
                                    if (Globals.g_reinstallHotFixes) {
                                        Logging.log.info("The user selected to re-install the already installed hot fixes listed above.");
                                    }
                                }
                                if (hotFixesToInstall.isEmpty()) {
                                    if (hotFixPackages.allHotFixesAlreadyInstalled()) {
                                        errMsg = this.bundle.getString("PanelApplyHotFix.HotFixesAlreadyInstalled");
                                        Logging.log.warning("The hot fixes in the selected directory are already installed: " + packageDir);
                                    } else if (hotFixPackages.noHotFixesForThisHost()) {
                                        errMsg = this.bundle.getString("PanelApplyHotFix.HotFixesNotApplicableForHost");
                                        Logging.log.warning("The hot fixes in the selected directory are not applicable for this host: " + packageDir);
                                    } else if (hotFixPackages.noHotFixesForTheInstalledProducts()) {
                                        errMsg = this.bundle.getString("PanelApplyHotFix.HotFixesNotApplicableForProducts");
                                        Logging.log.warning("The hot fixes in the selected directory are not applicable for the installed products: " + packageDir);
                                    } else {
                                        errMsg = this.bundle.getString("PanelApplyHotFix.NoApplicableHotFixes");
                                        Logging.log.warning("The hot fixes in the selected directory are not applicable: " + packageDir);
                                    }
                                    if (!Globals.g_quietMode) {
                                        valid = false;
                                    } else {
                                        Logging.log.warning("There are no hot fixes to apply, exiting the SAS Deployment Wizard.");
                                        Globals.g_kit.exitKit(0);
                                    }
                                }
                            }
                        } else {
                            errMsg = this.bundle.getString("PanelApplyHotFix.FilesAreNotHotFixPackages");
                            Logging.log.warning("There are no valid hot fix packages in the directory: " + packageDir);
                            valid = false;
                        }
                        if (valid && Globals.g_silentHotFix && hotFixPackages.configurableHotFixesPresent()) {
                            Logging.log.warning("Configurable hot fixes were not configured because the -silenthotfix command line option was used. Return to the SAS Deployment Manager to configure these hot fixes.");
                        }
                    } else {
                        Object failedPackages = "";
                        List<String> failedPackageList = hotFixPackages.getFailedPackages();
                        if (!failedPackageList.isEmpty()) {
                            for (String failedPackage : failedPackageList) {
                                failedPackages = (String)failedPackages + failedPackage + "\n";
                            }
                        }
                        errMsg = this.bundle.messageString("PanelApplyHotFix.ErrorLoadingHotFixPackages", failedPackages);
                        Logging.log.warning("There was a problem loading one or more of the hot fix packages in the directory: " + packageDir);
                        valid = false;
                    }
                    if (valid) {
                        for (HotFix hotFixRequiringInitRestart : hotFixPackages.getHotFixesRequiringInitRestart()) {
                            hotFixesRequiringInitRestart.add(this.bundle.messageString("PanelApplyHotFix.HotFixRequiringRestart.txt", hotFixRequiringInitRestart.getHotFixName(), hotFixRequiringInitRestart.getProdName()));
                        }
                    }
                } else {
                    errMsg = this.bundle.getString("PanelApplyHotFix.ErrorBuildingIndex");
                    Logging.log.warning("Unable to create the index of hot fix packages in the directory: " + packageDir);
                    valid = false;
                }
            }
            Globals.g_hotFixPackageDir = packageDir;
            if (valid) {
                String securityHotFixSubDir = HotFixManager.getSecurityHotFixSubDirectory();
                String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
                String securityHotFixDir = Utils.joinPath(sasHome, securityHotFixSubDir);
                ArrayList hotFixIds = new ArrayList(hotFixesToInstall.size() + 2);
                HotFixManager hotFixSecurityManager = new HotFixManager("postInstallHotFixes", securityHotFixDir, "security_hot_fix_post_install_index.xml");
                SecurityUpdates securityUpdates = new SecurityUpdates(sasHome);
                hotFixesToInstall = securityUpdates.removeOldSecurityHotFixes(hotFixesToInstall);
                HotFixPackages hotFixPackages = new HotFixPackages();
                if (hotFixSecurityManager.createIndexFromSecurityHotFixPackageDirectory()) {
                    hotFixPackages.setHotFixPackagesDirectory(securityHotFixDir);
                    hotFixPackages.setIndex(hotFixSecurityManager.getHotFixIndex());
                    if (hotFixPackages.loadPackages("postInstallHotFixes", false, Utils.GetSDWVersion())) {
                        List<HotFix> hotFixes = hotFixPackages.getPostInstallHotFixesToInstall(true);
                        ArrayList<HotFix> securityHotFixes = new ArrayList<HotFix>(hotFixes.size());
                        for (HotFix hfCandidate : hotFixes) {
                            if (!hfCandidate.isSecurityFix()) continue;
                            securityHotFixes.add(hfCandidate);
                        }
                        int newestIndex = -1;
                        String newest = "";
                        HotFix hfToAdd = null;
                        if (securityHotFixes.size() > 0) {
                            if (securityHotFixes.size() == 1) {
                                newest = ((HotFix)securityHotFixes.get(0)).getHotFixName();
                                newestIndex = 0;
                            } else {
                                int maxIndex = securityHotFixes.size() - 1;
                                for (int i = 0; i <= maxIndex; ++i) {
                                    if (i == 0) {
                                        newest = ((HotFix)securityHotFixes.get(i)).getHotFixName();
                                        newestIndex = 0;
                                        continue;
                                    }
                                    String next = ((HotFix)securityHotFixes.get(i)).getHotFixName();
                                    if (next.compareToIgnoreCase(newest) <= 0) continue;
                                    newest = next;
                                    newestIndex = i;
                                }
                            }
                            if (newestIndex > -1) {
                                hfToAdd = (HotFix)securityHotFixes.get(newestIndex);
                                String hfToAddName = hfToAdd.getHotFixName();
                                boolean hfFound = false;
                                for (HotFix hotFix : hotFixesToInstall) {
                                    String hfName = hotFix.getHotFixName();
                                    if (!hfToAddName.equals(hfName)) continue;
                                    hfFound = true;
                                }
                                if (!hfFound) {
                                    hotFixesToInstall.add(hfToAdd);
                                    hotFixesToInstall = securityUpdates.removeOldSecurityHotFixes(hotFixesToInstall);
                                }
                            }
                        }
                    }
                } else {
                    Logging.log.info("Security updates were not detected in " + securityHotFixDir);
                }
                Globals.g_selectedHotFixesToInstall.clear();
                List<ProductData> sortedHotFixes = HotFixPackages.orderHotFixes(hotFixesToInstall);
                Globals.g_selectedHotFixesToInstall.addAll(sortedHotFixes);
                ProductData installToolData = Globals.g_deploymentData.getProduct(Globals.g_order, "installtool", false);
                installToolData.setProdName(this.bundle.getString("PanelExecute.PostProcess.txt"));
                Globals.g_selectedHotFixesToInstall.add(installToolData);
            }
        }
        if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, this.bundle.getString("Common.Warning.txt"), 2);
            }
            this.m_packageDir.requestFocus();
        }
        if (!Globals.g_recordMode && valid && Utils.getOS() != 8 && Utils.getOS() != 10 && !StagedSDM.isSDMRestartedFromAltLocation() && !hotFixesRequiringInitRestart.isEmpty()) {
            String hotFixMsg = "";
            for (String hotFixEntry : hotFixesRequiringInitRestart) {
                hotFixMsg = hotFixMsg + "\tHot fix " + hotFixEntry + "\n";
            }
            Logging.log.info("The following hot fixes require the SDM to restart before applying:\n" + hotFixMsg);
            if (!Globals.g_quietMode && CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelApplyHotFix.ListOfHotFixesRequiringRestart.txt", hotFixMsg), Globals.g_wizard.getWizardTitle(), 0, 3, 0) == 1) {
                valid = false;
            } else {
                valid = true;
                String sasdmSrcDir = Utils.joinPath(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, true), "..", "..");
                String stagingDir = Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "InstallMisc" + File.separator + "SASDeploymentManager";
                Logging.log.info("Staging the SDM in the following directory for to restart the SDM: " + stagingDir);
                String stagedSDMErrMsg = null;
                StagedSDM stagedSDMRestart = null;
                try {
                    stagedSDMRestart = new StagedSDM(sasdmSrcDir, stagingDir);
                }
                catch (StagedSDMException e) {
                    Logging.log.severe("An error occurred while preparing to stage the SAS Deployment Manager, source directory: " + sasdmSrcDir + " staging directory: " + stagingDir);
                    Logging.logStackTrace(e);
                    stagedSDMErrMsg = this.bundle.getString("PanelApplyHotFix.ErrorPreparingToStageSDM.txt");
                    valid = false;
                }
                if (valid) {
                    try {
                        stagedSDMRestart.copyJREToAltLocation();
                    }
                    catch (StagedSDMException e) {
                        Logging.log.severe("An error occurred while copying the JRE to an alternate location.");
                        Logging.logStackTrace(e);
                        stagedSDMErrMsg = this.bundle.getString("PanelApplyHotFix.ErrorCopyingJREToAltLocation.txt");
                        valid = false;
                    }
                }
                if (valid) {
                    try {
                        stagedSDMRestart.copySDMToAltLocation();
                    }
                    catch (StagedSDMException e) {
                        Logging.log.severe("An error occurred while copying the SAS Deployment Manager to an alrernate location.");
                        Logging.logStackTrace(e);
                        stagedSDMErrMsg = this.bundle.getString("PanelApplyHotFix.ErrorCopyingSDMToAltLocation.txt");
                        valid = false;
                    }
                }
                File responseFile = null;
                if (valid && !Globals.g_quietMode) {
                    try {
                        responseFile = stagedSDMRestart.createPartialPromptResponseFile();
                    }
                    catch (StagedSDMException e) {
                        responseFile = null;
                        Logging.log.warning("Unable to create a partial response file, therefore the SAS Deployment Manager will re-prompt for the task to perform.");
                        Logging.logStackTrace(e);
                    }
                }
                if (valid) {
                    try {
                        File sourceFile = new File(sasdmSrcDir, "sasdm.ini");
                        String partialPromptOption = "";
                        if (responseFile != null) {
                            partialPromptOption = "-partialprompt -responsefile \"" + responseFile.getAbsolutePath() + "\"";
                        }
                        stagedSDMRestart.constructNewSasdmINI(sourceFile, "-hotfixdir \"" + packageDir + "\" " + partialPromptOption);
                    }
                    catch (StagedSDMException e) {
                        Logging.log.severe("An error occurred while creating the sasdm.ini file.");
                        Logging.logStackTrace(e);
                        stagedSDMErrMsg = this.bundle.getString("PanelApplyHotFix.ErrorCreatingSASdmINIFile.txt");
                        valid = false;
                    }
                }
                if (valid) {
                    try {
                        String fileExtension = "";
                        fileExtension = Utils.getOS() == 1 ? ".exe" : ".sh";
                        File sourceFile = new File(sasdmSrcDir, "sasdm" + fileExtension);
                        stagedSDMRestart.copySasdm(sourceFile);
                    }
                    catch (StagedSDMException e) {
                        Logging.log.severe("An error occurred while copying the sasdm launcher to an alternate location.");
                        Logging.logStackTrace(e);
                        stagedSDMErrMsg = "An error occurred while copying the sasdm launcher to an alternate location.";
                        stagedSDMErrMsg = this.bundle.getString("PanelApplyHotFix.ErrorCopyingSasdmLauncher.txt");
                        valid = false;
                    }
                }
                if (!valid) {
                    if (!Globals.g_quietMode && stagedSDMErrMsg != null) {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), stagedSDMErrMsg, this.bundle.getString("Common.Error.txt"), 0);
                    }
                    Globals.g_kit.exitKit(-1);
                } else {
                    int rc = 0;
                    rc = Utils.getOS() == 1 ? 16000 : 126;
                    Globals.g_kit.exitKit(rc);
                }
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        if (Globals.g_cmtRunInstall) {
            panelID = Globals.g_dynamicInstallDialogs != null && Globals.g_dynamicInstallDialogs.length > 0 ? Globals.g_dynamicInstallDialogs[0] : "systemcheck";
        } else if (Globals.g_cmtRunConfigure) {
            panelID = "selectconfigdir";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_installCheckBox.setSelected(true);
                this.m_configureCheckBox.setSelected(false);
                if (this.m_installCheckBox.isSelected()) {
                    this.m_packageDir.setEnabled(true);
                    this.m_browseButton.setEnabled(true);
                } else {
                    this.m_packageDir.setEnabled(false);
                    this.m_browseButton.setEnabled(false);
                }
                if (this.m_packageDir.getText().length() == 0) {
                    this.m_packageDir.setText(HotFixPackages.getDefaultSDMHotFixDir());
                }
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_packageDir;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#HOTFIX_PACKAGE_DIR=<full path>", " HOTFIX_PACKAGE_DIR=", "#HOTFIX_INSTALL=yes/no", " HOTFIX_INSTALL=yes", "#HOTFIX_CONFIGURE=yes/no", " HOTFIX_CONFIGURE=yes"};
        if (this.m_panelLoaded) {
            data[1] = " HOTFIX_PACKAGE_DIR=" + this.m_packageDir.getText();
            if (!this.m_installCheckBox.isSelected()) {
                data[3] = " HOTFIX_CONFIGURE=no";
            }
            if (!this.m_configureCheckBox.isSelected()) {
                data[5] = " HOTFIX_CONFIGURE=no";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = 0;
        if (Globals.g_enableConfigTasks) {
            returnCode = ConsoleMode.promptBoolean(this.m_installCheckBox);
        }
        if (returnCode > -1 && this.m_installCheckBox.isSelected()) {
            returnCode = ConsoleMode.promptText(this.m_packageDirLabel.getText(), this.m_packageDir);
        }
        if (returnCode > -1 && Globals.g_enableConfigTasks) {
            returnCode = ConsoleMode.promptBoolean(this.m_configureCheckBox);
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        String responseConfigure;
        boolean valid = false;
        String responseInstall = Wizard.getResponse("HOTFIX_INSTALL", null);
        if (responseInstall != null) {
            if (responseInstall.equalsIgnoreCase("yes")) {
                this.m_installCheckBox.setSelected(true);
                this.m_packageDir.setEnabled(true);
                this.m_browseButton.setEnabled(true);
                valid = true;
                String responsePackageDir = Wizard.getResponse("HOTFIX_PACKAGE_DIR", null);
                if (responsePackageDir != null) {
                    this.m_packageDir.setText(responsePackageDir);
                } else if (Globals.g_quietMode) {
                    valid = false;
                    Wizard.logResponseMissing(this.getHeader(), "HOTFIX_PACKAGE_DIR");
                }
            } else if (responseInstall.equalsIgnoreCase("no")) {
                this.m_installCheckBox.setSelected(false);
                this.m_packageDir.setEnabled(false);
                this.m_browseButton.setEnabled(false);
                valid = true;
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_INSTALL", responseInstall, null);
            }
        }
        if ((responseConfigure = Wizard.getResponse("HOTFIX_CONFIGURE", null)) != null) {
            if (responseConfigure.equalsIgnoreCase("yes")) {
                this.m_configureCheckBox.setSelected(true);
                valid = true;
            } else if (responseConfigure.equalsIgnoreCase("no")) {
                this.m_configureCheckBox.setSelected(false);
                valid = true;
            } else if (Globals.g_quietMode) {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "HOTFIX_CONFIGURE", responseConfigure, null);
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelApplyHotFix.PackageDirLabel.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelApplyHotFix.InstallLabel.txt");
        this.m_installCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_installCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_installCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installCheckBox.addActionListener(this);
        this.m_packageDir = new KitTextField();
        this.m_packageDir.getDocument().addDocumentListener(new TextChangeListener());
        mtxt = this.bundle.getString("PanelApplyHotFix.PackageDirField.txt");
        this.m_packageDirLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_packageDirLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_packageDirLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_packageDirLabel.setLabelFor(this.m_packageDir);
        mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_packageDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
        mtxt = this.bundle.getString("PanelApplyHotFix.ConfigureLabel.txt");
        this.m_configureCheckBox = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_configureCheckBox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_configureCheckBox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_configureCheckBox.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        if (Globals.g_enableConfigTasks) {
            ++c.gridy;
            c.insets = new Insets(2, 0, 2, 0);
            this.m_panel.add((Component)this.m_installCheckBox, c);
        }
        int leftShift = Globals.g_enableConfigTasks ? 20 : 5;
        ++c.gridy;
        c.insets = new Insets(0, leftShift, 5, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, leftShift + 10, 5, 0);
        this.m_panel.add((Component)this.m_packageDirLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, leftShift + 10, 0, 0);
        this.m_panel.add((Component)this.m_packageDir, c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
        if (Globals.g_enableConfigTasks) {
            c.gridx = 0;
            ++c.gridy;
            c.insets = new Insets(2, 0, 3, 0);
            this.m_panel.add((Component)this.m_configureCheckBox, c);
        }
    }

    @Override
    public String getHelpTopic() {
        return "PanelApplyHotFix" + (Globals.g_enableConfigTasks ? "Planning" : "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_installCheckBox) {
            if (this.m_installCheckBox.isSelected()) {
                this.m_packageDir.setEnabled(true);
                this.m_browseButton.setEnabled(true);
                if (this.m_packageDir.getText().length() == 0) {
                    this.m_packageDir.setText(HotFixPackages.getDefaultSDMHotFixDir());
                }
            } else {
                this.m_packageDir.setEnabled(false);
                this.m_browseButton.setEnabled(false);
            }
        }
        Globals.g_wizard.getNextButton().setEnabled(this.m_installCheckBox.isSelected() || this.m_configureCheckBox.isSelected());
    }

    private void isConfigurable() {
        String packageDir = Utils.trimTrailingSlashes(this.m_packageDir.getText());
        HotFixManager hotFixManager = new HotFixManager("postInstallHotFixes", packageDir, "hot_fix_post_install_index.xml");
        if (hotFixManager.createIndexFromHotFixPackageDirectory()) {
            HotFixPackages hotFixPackages = new HotFixPackages();
            hotFixPackages.setIndex(hotFixManager.getHotFixIndex());
            hotFixPackages.setHotFixPackagesDirectory(packageDir);
            if (hotFixPackages.loadPackages("postInstallHotFixes", false, Utils.GetSDWVersion())) {
                if (hotFixPackages.configurableHotFixesPresent()) {
                    this.m_configureCheckBox.setEnabled(true);
                    this.m_configureCheckBox.setSelected(true);
                } else {
                    this.m_configureCheckBox.setEnabled(false);
                    this.m_configureCheckBox.setSelected(false);
                }
            }
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelApplyHotFix.this.isConfigurable();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelApplyHotFix.this.isConfigurable();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelApplyHotFix.this.isConfigurable();
        }
    }
}

