/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PanelAddOrder
implements WizardPanelIface,
HyperlinkListener {
    private SSNResource bundle = new SSNResource(PanelAddOrder.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_instructions = null;
    private JLabel m_orderNumberLabel = null;
    private JTextField m_orderNumber = null;
    private JEditorPane m_soiLink = null;
    private JLabel m_orderDescLabel = null;
    private KitTextField m_orderDesc = null;
    private JLabel m_notesLabel = null;
    private JTextArea m_notes = null;
    private JScrollPane m_notesScrollPane = null;
    private JLabel m_orderSummaryLabel = null;
    private JEditorPane m_orderSummary = null;
    private JScrollPane m_summaryScrollPane = null;
    private boolean m_panelLoaded = false;
    private String m_previousOrder = "";

    public PanelAddOrder() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelAddOrder.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelAddOrder.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        this.m_orderDesc.setText(this.m_orderDesc.getText().trim());
        Globals.g_orderDesc = this.m_orderDesc.getText();
        Globals.g_orderNotes = this.m_notes.getText();
        if (Globals.g_mode == 1) {
            Globals.g_control.setOrderDesc(Globals.g_orderDesc);
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = Globals.g_mode == 1 ? "selectfullorsubset" : "sawoption";
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_previousOrder.equalsIgnoreCase(Globals.g_order)) {
            String soiLink;
            OrderData orderData;
            if (Globals.g_mode == 1) {
                Globals.g_deploymentData = new DeploymentData(new File(Globals.g_tempLocation, "download"));
                Globals.g_deploymentData.loadOrders();
            }
            if ((orderData = Globals.g_deploymentData.getOrder(Globals.g_order)) != null) {
                this.m_orderNumber.setText(orderData.getOrder());
                this.m_notes.setText("");
                if (!this.loadResponseData()) {
                    this.m_orderDesc.setText(orderData.getDescription(Language.gs_SelectedLanguage));
                    this.m_notes.setText(orderData.getExtendedData().getNote());
                }
                this.updateSummaryText();
            }
            if ((soiLink = this.getSOILink()) == null) {
                this.m_soiLink.setVisible(false);
            } else {
                this.m_soiLink.setVisible(true);
                String linkText = "<html><a href=\"" + soiLink + "\">" + this.bundle.getString("PanelAddOrder.SOILink.txt") + "</a></html>";
                int size = this.m_soiLink.getFont().getSize();
                Logging.log.info("m_soiLink size =" + size);
                size = this.m_orderSummary.getFont().getSize();
                Logging.log.info("m_orderSummary size =" + size);
                this.m_soiLink.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                this.m_soiLink.setText(linkText);
                this.m_soiLink.setCaretPosition(0);
            }
            this.m_previousOrder = Globals.g_order;
        }
        if (!this.m_panelLoaded) {
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_orderDesc;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#ORDER_DESCRIPTION=<description>", " ORDER_DESCRIPTION=", "#ORDER_NOTES=<notes> (\\n marks the end of each line)", " ORDER_NOTES="};
        if (this.m_panelLoaded) {
            data[1] = " ORDER_DESCRIPTION=" + this.m_orderDesc.getText();
            data[3] = " ORDER_NOTES=" + this.m_notes.getText().replaceAll(System.getProperty("line.separator"), "\\\\n");
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_orderDescLabel.getText(), this.m_orderDesc);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("ORDER_DESCRIPTION", null);
        if (response != null) {
            this.m_orderDesc.setText(response);
            valid = true;
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "ORDER_DESCRIPTION");
        }
        response = Wizard.getResponse("ORDER_NOTES", null);
        if (response != null) {
            this.m_notes.setText(response);
        }
        return valid;
    }

    private void initialize() {
        this.m_instructions = Globals.g_sourceSSD ? new JTextArea(this.bundle.getString("PanelAddOrder.Instructions.txt")) : new JTextArea(this.bundle.getString("PanelAddOrder.MediaInstructions.txt"));
        this.m_instructions.setEditable(false);
        this.m_instructions.setFocusable(false);
        this.m_instructions.setLineWrap(true);
        this.m_instructions.setWrapStyleWord(true);
        this.m_instructions.setOpaque(false);
        this.m_orderNumber = new JTextField();
        this.m_orderNumber.setEditable(false);
        String mtxt = this.bundle.getString("PanelAddOrder.OrderNumber.txt");
        this.m_orderNumberLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderNumberLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderNumberLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderNumberLabel.setLabelFor(this.m_orderNumber);
        this.m_soiLink = new JEditorPane();
        this.m_soiLink.setOpaque(false);
        this.m_soiLink.setEditable(false);
        this.m_soiLink.setContentType("text/html");
        this.m_soiLink.addHyperlinkListener(this);
        this.m_soiLink.setVisible(false);
        this.m_orderDesc = new KitTextField();
        mtxt = this.bundle.getString("PanelAddOrder.OrderDesc.txt");
        this.m_orderDescLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderDescLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderDescLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderDescLabel.setLabelFor(this.m_orderDesc);
        this.m_notes = new JTextArea(4, 0);
        this.m_notes.setOpaque(true);
        this.m_notes.setEditable(true);
        this.m_notesScrollPane = new JScrollPane(this.m_notes);
        mtxt = this.bundle.getString("PanelAddOrder.Notes.txt");
        this.m_notesLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_notesLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_notesLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_notesLabel.setLabelFor(this.m_notes);
        this.m_orderSummary = new JEditorPane();
        this.m_orderSummary.setOpaque(false);
        this.m_orderSummary.setEditable(false);
        this.m_orderSummary.setContentType("text/html");
        this.m_summaryScrollPane = new JScrollPane(this.m_orderSummary);
        mtxt = this.bundle.getString("PanelAddOrder.OrderSummary.txt");
        this.m_orderSummaryLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_orderSummaryLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_orderSummaryLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_orderSummaryLabel.setLabelFor(this.m_orderSummary);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 10, 0);
        this.m_panel.add((Component)this.m_instructions, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_orderNumberLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 5, 0);
        this.m_panel.add((Component)this.m_orderNumber, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_orderDescLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_orderDesc, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(8, 0, 5, 0);
        this.m_panel.add((Component)this.m_notesLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 0);
        this.m_panel.add((Component)this.m_notesScrollPane, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_soiLink, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_orderSummaryLabel, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_summaryScrollPane, c);
    }

    private void updateSummaryText() {
        int i;
        String summaryText = "";
        ProductData[] summaryData = Globals.g_deploymentData.getInstallableProducts(Globals.g_order, false);
        int swapPos = 0;
        ProductData swapData = null;
        for (int i2 = 0; i2 < summaryData.length; ++i2) {
            if (summaryData[i2] == null) continue;
            swapPos = i2;
            for (int j = i2 + 1; j < summaryData.length; ++j) {
                if (summaryData[j] == null) continue;
                int comp = summaryData[j].getProdName().compareTo(summaryData[swapPos].getProdName());
                if (comp == 0) {
                    summaryData[j] = null;
                    continue;
                }
                if (comp >= 0) continue;
                swapPos = j;
            }
            if (swapPos == i2) continue;
            swapData = summaryData[i2];
            summaryData[i2] = summaryData[swapPos];
            summaryData[swapPos] = swapData;
        }
        boolean found = false;
        for (i = 0; i < summaryData.length && !found; ++i) {
            if (summaryData[i] == null || !summaryData[i].getProdCode().equalsIgnoreCase("sasinstall")) continue;
            swapData = summaryData[i];
            for (int j = i; j > 0; --j) {
                summaryData[j] = summaryData[j - 1];
            }
            summaryData[0] = swapData;
            found = true;
        }
        summaryText = "<html><ol>";
        for (i = 0; i < summaryData.length; ++i) {
            if (summaryData[i] == null) continue;
            summaryText = summaryText.concat("<li>" + summaryData[i].getProdName());
        }
        summaryText = summaryText + "</ol></html>";
        this.m_orderSummary.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.m_orderSummary.setText(summaryText);
        this.m_orderSummary.setCaretPosition(0);
        this.m_orderSummary.revalidate();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    private String getSOILink() {
        String link = null;
        File orderRoot = Globals.g_mode == 1 ? new File(Globals.g_tempLocation, "download") : new File(Globals.g_startupLocation);
        File soiFile = new File(orderRoot, "install_doc/" + Globals.g_order + "/soi.html");
        if (soiFile.isFile()) {
            link = Utils.pathToURL(soiFile.getAbsolutePath());
        }
        return link;
    }
}

