/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CdId;
import com.sas.ssn.CopyFile;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.ExtendedOrderData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PropsParser;
import com.sas.ssn.SkuData;
import com.sas.ssn.SkuFilterIface;
import com.sas.ssn.SkuRequirementsForOrder;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OrderData
implements Cloneable {
    private File file;
    private Document doc;
    private Element root;
    private String order;
    private String type;
    private String mediaType;
    private String depotVersion;
    private String standAlone;
    private String encoding;
    private String maintLevel;
    private String shipEvent;
    private boolean containsSASINSTALL = false;
    private boolean containsMIT = false;
    Hashtable spsSkuDataHash = new Hashtable();
    Hashtable spsSkuDataHashWithPayload = new Hashtable();
    private Hashtable<String, HashSet<SpsSkuData>> spsSkuDataByProdCode;
    private Hashtable mvaAltSkus = new Hashtable();
    private Hashtable maintenance = new Hashtable();
    private DeploymentData deploymentData;
    private ExtendedOrderData extendedOrderData;
    private Hashtable<String, SkuRequirementsForOrder> skuRequirements = new Hashtable();
    private static SkuFilterIface standardLanguagesSkuFilter;
    private static SkuFilterIface stdLangsAndInOrderSkuFilter;
    private Vector volsers = new Vector();
    private Hashtable description = new Hashtable();
    private Hashtable sids = new Hashtable();
    private Hashtable requirementDataTypes = new Hashtable();
    private File origfile;
    static final List<String> DEFAULT_REQ_TYPES;

    public OrderData(String file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file), deploymentData);
    }

    public OrderData(File file, DeploymentData deploymentData) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        int i;
        this.file = file;
        this.deploymentData = deploymentData;
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
        this.root = this.doc.getDocumentElement();
        this.order = this.root.getAttribute("number");
        this.type = this.root.getAttribute("type").toLowerCase(Locale.ENGLISH);
        this.mediaType = this.root.getAttribute("mediatype").toLowerCase(Locale.ENGLISH);
        this.depotVersion = this.root.getAttribute("depot_version");
        this.standAlone = this.root.getAttribute("sa_depot").toLowerCase(Locale.ENGLISH);
        this.encoding = this.root.getAttribute("encoding");
        this.maintLevel = this.root.getAttribute("maint_level");
        this.shipEvent = this.root.getAttribute("ship_event");
        NodeList data = this.root.getChildNodes();
        if (data != null) {
            for (i = 0; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("description".equals(element.getTagName())) {
                    this.description.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("sid".equals(element.getTagName())) {
                    SIDData sidData = new SIDData(element);
                    this.sids.put(sidData.getSetnumid(), sidData);
                    continue;
                }
                if ("sids".equals(element.getTagName())) {
                    this.loadSIDs(element);
                    continue;
                }
                if (!"volser".equals(element.getTagName())) continue;
                this.link(element);
            }
        }
        this.extendedOrderData = new ExtendedOrderData(deploymentData.getOrderDir() + File.separator + this.order + File.separator + "order_ext.xml", deploymentData);
        this.examineProducts();
        this.loadRequirementsData(file.getParent() + File.separator + "skureq.xml");
        String[] errors = this.getErrors();
        for (i = 0; i < errors.length; ++i) {
            Logging.log.fine(errors[i] + ": " + file.getCanonicalPath());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OrderData clone = (OrderData)super.clone();
        clone.file = new File(this.file.toString());
        clone.doc = (Document)this.doc.cloneNode(true);
        clone.root = clone.doc.getDocumentElement();
        clone.mvaAltSkus = (Hashtable)this.mvaAltSkus.clone();
        clone.maintenance = (Hashtable)this.maintenance.clone();
        clone.deploymentData = this.deploymentData;
        clone.extendedOrderData = (ExtendedOrderData)this.extendedOrderData.clone();
        clone.volsers = (Vector)this.volsers.clone();
        clone.description = (Hashtable)this.description.clone();
        clone.sids = (Hashtable)this.sids.clone();
        return clone;
    }

    public OrderData clone(String newOrder, boolean disablePlanning) {
        OrderData clone = null;
        try {
            String attribute;
            String currentType;
            clone = (OrderData)this.clone();
            clone.order = newOrder;
            clone.root.setAttribute("number", clone.order);
            if (disablePlanning && "planning".equalsIgnoreCase(currentType = clone.root.getAttribute(attribute = "type"))) {
                clone.root.setAttribute(attribute, "nonplanning");
            }
            clone.file = new File(clone.deploymentData.getOrderDir() + File.separator + clone.order + File.separator + "order.xml");
            clone.extendedOrderData = this.extendedOrderData.clone(clone.order);
            NodeList volserElements = clone.root.getElementsByTagName("volser");
            Iterator volserIter = this.volsers.iterator();
            int i = 0;
            while (volserIter.hasNext()) {
                String volser = (String)volserIter.next();
                String newVolser = volser.replaceAll(this.order, clone.order);
                VolserData clonedVolser = this.deploymentData.getVolser(volser).clone(newVolser);
                ((Element)volserElements.item(i)).setAttribute("v", clonedVolser.getVolser());
                clone.deploymentData.mediaCodeList.add(clonedVolser);
                clonedVolser.setOrder(clone.order);
                clone.volsers.set(i, clonedVolser.getVolser());
                ++i;
            }
            new CopyFile(this.file.getParentFile()).copyTo(clone.file.getParentFile(), true);
            clone.write();
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return clone;
    }

    public OrderData clone(String newOrder, String destDir, boolean disablePlanning) {
        OrderData clone = null;
        try {
            String attribute;
            String currentType;
            String stagingDestDir = destDir + File.separator + "staging" + File.separator + newOrder + File.separator + "cloneddata";
            clone = (OrderData)this.clone();
            clone.order = newOrder;
            clone.root.setAttribute("number", clone.order);
            if (disablePlanning && "planning".equalsIgnoreCase(currentType = clone.root.getAttribute(attribute = "type"))) {
                clone.root.setAttribute(attribute, "nonplanning");
            }
            clone.file = new File(clone.deploymentData.getOrderDir(stagingDestDir) + File.separator + clone.order + File.separator + "order.xml");
            clone.origfile = new File(this.deploymentData.getOrderDir() + File.separator + this.order + File.separator + "order.xml");
            if (!clone.file.getParentFile().exists()) {
                clone.file.getParentFile().mkdirs();
            }
            clone.extendedOrderData = this.extendedOrderData.clone(clone.order, stagingDestDir);
            NodeList volserElements = clone.root.getElementsByTagName("volser");
            Iterator volserIter = this.volsers.iterator();
            int i = 0;
            while (volserIter.hasNext()) {
                String volser = (String)volserIter.next();
                String newVolser = volser.replaceAll(this.order, clone.order);
                VolserData clonedVolser = this.deploymentData.getVolser(volser).clone(newVolser, stagingDestDir);
                Globals.g_subsetData.setOldVolser(this.deploymentData.getVolser(volser).getVolser(), clonedVolser.getVolser());
                ((Element)volserElements.item(i)).setAttribute("v", clonedVolser.getVolser());
                clone.deploymentData.mediaCodeList.add(clonedVolser);
                clonedVolser.setOrder(clone.order);
                clone.volsers.set(i, clonedVolser.getVolser());
                ++i;
            }
            new CopyFile(clone.origfile.getParentFile()).copyTo(clone.file.getParentFile(), true);
            clone.write();
        }
        catch (Exception e) {
            Logging.log.warning("Failure in order cloning: " + e.getStackTrace());
            clone = null;
        }
        return clone;
    }

    private String[] getErrors() {
        Vector<String> errors = new Vector<String>();
        if (this.order.length() == 0) {
            errors.add("No NUMBER Value in ORDER Data");
        }
        if (this.volsers.isEmpty()) {
            errors.add("No VOLSERs in ORDER Data");
        }
        return errors.toArray(new String[0]);
    }

    private void link(Element element) {
        String volser = element.getAttribute("v");
        if (volser != null) {
            VolserData volserData = this.deploymentData.getVolser(volser);
            if (volserData != null) {
                Logging.log.fine("Repeated VOLSER in ORDER Data: " + volser);
                volserData.setOrder(this.getOrder());
                this.volsers.add(volser);
            } else {
                String file = this.deploymentData.getMediaDir() + File.separator + volser + ".xml";
                try {
                    volserData = new VolserData(file, this.deploymentData);
                    if (volser.equals(volserData.getVolser())) {
                        this.deploymentData.mediaCodeList.add(volserData);
                        volserData.setOrder(this.getOrder());
                        this.volsers.add(volser);
                    } else {
                        Logging.log.info("Mismatched VOLSER Value in Volser XML File: " + file);
                    }
                }
                catch (FileNotFoundException e) {
                    Logging.log.info("Volser XML File Not Found: " + file);
                    Logging.log.info(e.getMessage());
                }
                catch (IOException e) {
                    Logging.log.info("Error Reading Volser XML File: " + file);
                    Logging.log.info(e.getMessage());
                }
                catch (Exception e) {
                    Logging.log.info("Error Parsing Volser XML File: " + file);
                    Logging.log.info(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineProducts() {
        String[] volsers = null;
        VolserData volserData = null;
        Hashtable<String, VolserData> volserDataHash = new Hashtable<String, VolserData>();
        String[] spsSkus = null;
        String spsSku = null;
        SpsSkuData spsSkuData = null;
        SkuData skuData = null;
        String platform = null;
        CdId id = null;
        SpsSkuData instqualtoolData = null;
        try {
            id = new CdId(new File(this.deploymentData.getMediaRoot(), "cd.id"));
            volsers = this.getVolsers(this.mediaType);
            for (int i = 0; i < volsers.length; ++i) {
                volserData = this.deploymentData.getVolser(volsers[i]);
                volserDataHash.put(volserData.getVolser(), volserData);
                spsSkus = volserData.getSpsSkus();
                for (int j = 0; j < spsSkus.length; ++j) {
                    spsSkuData = this.deploymentData.getSpsSku(spsSkus[j]);
                    spsSku = spsSkuData.getSpsSku();
                    this.spsSkuDataHash.put(spsSku, spsSkuData);
                    if (volserData.isPayloadIncluded(spsSkus[j])) {
                        this.spsSkuDataHashWithPayload.put(spsSku, spsSkuData);
                    }
                    if (!"instqualtool".equals(spsSkuData.getProdCode()) || !spsSkuData.isInstallable() || !spsSkuData.isStandardLanguage()) continue;
                    instqualtoolData = spsSkuData;
                }
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        Enumeration elements = this.spsSkuDataHash.elements();
        while (elements.hasMoreElements()) {
            SkuRequirementsForOrder skuReqs;
            Vector sasAltSkuVector;
            spsSkuData = (SpsSkuData)elements.nextElement();
            spsSku = spsSkuData.getSpsSku();
            platform = Utils.getOS_Suffix();
            skuData = spsSkuData.getSku(platform);
            if (skuData == null) {
                if ("wx6".equals(platform)) {
                    skuData = spsSkuData.getSku("win");
                } else if ("lax".equals(platform)) {
                    skuData = spsSkuData.getSku("lnx");
                } else if ("mvs".equals(platform)) {
                    skuData = spsSkuData.getSku("z64");
                }
                if (skuData != null) {
                    platform = skuData.getPlatform();
                }
            }
            if (spsSkuData.isMaintLevelGreaterThanZero()) {
                if (skuData != null) {
                    if (spsSkuData.getIndb()) {
                        this.maintenance.put(spsSkuData.getProdCode() + ":" + spsSkuData.getDisplayVer("en") + ":" + platform + ":" + spsSkuData.getLanguage() + ":" + spsSkuData.getPlatform(), spsSku);
                    } else {
                        this.maintenance.put(spsSkuData.getProdCode() + ":" + spsSkuData.getDisplayVer("en") + ":" + platform + ":" + spsSkuData.getLanguage(), spsSku);
                    }
                }
            } else if ("sasinstall".equals(spsSkuData.getProdCode())) {
                this.containsSASINSTALL = true;
                if (skuData != null) {
                    sasAltSkuVector = (Vector)this.mvaAltSkus.get(spsSku);
                    if (sasAltSkuVector == null) {
                        sasAltSkuVector = new Vector();
                        this.mvaAltSkus.put(spsSku, sasAltSkuVector);
                    }
                    volserData = null;
                    volsers = spsSkuData.getVolsers();
                    for (int i = 0; volserData == null && i < volsers.length; ++i) {
                        volserData = (VolserData)volserDataHash.get(volsers[i]);
                    }
                    if ("win".equals(platform) || "wx6".equals(platform) || "w64".equals(platform)) {
                        File[] sasDataFiles;
                        File iniSource = new File(this.deploymentData.getMediaRoot(), volserData.getProductPath(spsSku) + "/sas/core/sasinst/data");
                        if (!new File(iniSource, "base.ini").isFile()) {
                            iniSource = new File(this.deploymentData.getOrderDir() + "/" + this.order, spsSku + "/sas/core/sasinst/data");
                        }
                        if ((sasDataFiles = iniSource.listFiles()) != null) {
                            try {
                                PropsParser iniParser = new PropsParser(true);
                                for (int i = 0; i < sasDataFiles.length; ++i) {
                                    SpsSkuData sasAltSkuData;
                                    if (!sasDataFiles[i].isFile()) continue;
                                    iniParser.load(sasDataFiles[i], null);
                                    String sasAltSku = iniParser.getINIValue("Component", "AltSku", null);
                                    if (sasAltSku == null || "none".equalsIgnoreCase(sasAltSku) || (sasAltSkuData = (SpsSkuData)this.spsSkuDataHash.get(sasAltSku)) == null) continue;
                                    sasAltSkuVector.add(sasAltSkuData.getSpsSku());
                                }
                            }
                            catch (Exception iniParser) {}
                        }
                    } else if ("mvs".equals(platform)) {
                        Enumeration mvsSpsSkus = this.spsSkuDataHash.elements();
                        while (mvsSpsSkus.hasMoreElements()) {
                            SkuData mvsSkuData;
                            SpsSkuData mvsSpsSkuData = (SpsSkuData)mvsSpsSkus.nextElement();
                            if (mvsSpsSkuData.isDeltaRelease() || "sasinstall".equals(mvsSpsSkuData.getProdCode()) || (mvsSkuData = mvsSpsSkuData.getSku("mvs")) == null || !"true".equalsIgnoreCase(mvsSkuData.getMiscValue("use_sasinstall"))) continue;
                            sasAltSkuVector.add(mvsSpsSkuData.getSpsSku());
                        }
                    } else {
                        try {
                            FileInputStream stream = null;
                            BufferedReader reader = null;
                            try {
                                File tocFile = new File(this.deploymentData.getOrderDir() + "/" + this.order, spsSku + "/CMTC00EN.TXT");
                                stream = new FileInputStream(tocFile);
                                reader = new BufferedReader(new InputStreamReader(stream));
                                String line = reader.readLine();
                                while (line != null) {
                                    SpsSkuData sasAltSkuData;
                                    StringTokenizer st = new StringTokenizer(line, ":");
                                    if (st.countTokens() == 12 && (sasAltSkuData = (SpsSkuData)this.spsSkuDataHash.get(st.nextToken())) != null && !sasAltSkuVector.contains(sasAltSkuData.getSpsSku())) {
                                        sasAltSkuVector.add(sasAltSkuData.getSpsSku());
                                    }
                                    line = reader.readLine();
                                }
                            }
                            finally {
                                if (stream != null) {
                                    stream.close();
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        catch (IOException stream) {}
                    }
                }
            } else if ("mit".equals(spsSkuData.getProdCode())) {
                this.containsMIT = true;
            }
            if (skuData != null && !spsSkuData.isDeltaRelease() && "true".equalsIgnoreCase(skuData.getMiscValue("is_foundation"))) {
                sasAltSkuVector = (Vector)this.mvaAltSkus.get(platform);
                if (sasAltSkuVector == null) {
                    sasAltSkuVector = new Vector();
                    this.mvaAltSkus.put(platform, sasAltSkuVector);
                }
                sasAltSkuVector.add(spsSkuData.getSpsSku());
            }
            if (!Globals.g_processRequirements) continue;
            if (instqualtoolData != null && spsSkuData.isStandardLanguage() && spsSkuData.isInstallable() && !spsSkuData.getSpsSku().equals(instqualtoolData.getSpsSku())) {
                for (String reqType : DEFAULT_REQ_TYPES) {
                    skuReqs = this.retrieveSkuRequirementsForOrder(reqType);
                    skuReqs.addRequirement(null, spsSkuData.getSpsSku(), instqualtoolData.getSpsSku());
                }
            }
            String[] types = spsSkuData.getTypes(platform);
            for (int i = 0; i < types.length; ++i) {
                skuReqs = this.retrieveSkuRequirementsForOrder(types[i]);
                skuReqs.loadSpsSkuDataReqs(platform, spsSkuData, OrderData.getStandardLanguagesSkuFilter());
            }
        }
    }

    private SkuRequirementsForOrder retrieveSkuRequirementsForOrder(String reqType) {
        SkuRequirementsForOrder skuReqs = this.skuRequirements.get(reqType);
        if (skuReqs == null) {
            skuReqs = new SkuRequirementsForOrder(this, reqType);
            this.skuRequirements.put(reqType, skuReqs);
        }
        return skuReqs;
    }

    public SkuRequirementsForOrder getSkuRequirements(String requirementType) {
        if (requirementType == null) {
            requirementType = "triggers_install";
        }
        return this.skuRequirements.get(requirementType);
    }

    public SkuRequirementsForOrder getSkuRequirements() {
        return this.getSkuRequirements(null);
    }

    public SpsSkuData getSpsSku(String spsSku) {
        return (SpsSkuData)this.spsSkuDataHash.get(spsSku);
    }

    public static SkuFilterIface getStandardLanguagesSkuFilter() {
        if (standardLanguagesSkuFilter == null) {
            standardLanguagesSkuFilter = new SkuFilterIface(){

                @Override
                public String getFilteredSku(String sku, OrderData order, String platform) {
                    return this.getFilteredSku(Globals.g_deploymentData.getSpsSku(sku), order, platform);
                }

                @Override
                public String getFilteredSku(SpsSkuData spsSkuData, OrderData order, String platform) {
                    String includableSku = null;
                    if (spsSkuData != null && spsSkuData.isStandardLanguage()) {
                        includableSku = spsSkuData.getSpsSku();
                    }
                    return includableSku;
                }
            };
        }
        return standardLanguagesSkuFilter;
    }

    public SkuFilterIface getStdLangsAndInOrderSkuFilter() {
        if (stdLangsAndInOrderSkuFilter == null) {
            stdLangsAndInOrderSkuFilter = new SkuFilterIface(){

                @Override
                public String getFilteredSku(String sku, OrderData order, String platform) {
                    return this.getFilteredSku(order.getSpsSku(sku), order, platform);
                }

                @Override
                public String getFilteredSku(SpsSkuData spsSkuData, OrderData order, String platform) {
                    String includableSku = null;
                    if (!(spsSkuData == null || order.getSpsSku(spsSkuData.getSpsSku()) == null || !spsSkuData.isStandardLanguage() || Globals.g_noFonts && "ttfontsvert".equals(spsSkuData.getProdCode()))) {
                        includableSku = spsSkuData.getSpsSku();
                    }
                    return includableSku;
                }
            };
        }
        return stdLangsAndInOrderSkuFilter;
    }

    public String[] chaseRequirements(String type, String spsSku, String platform) {
        String[] reqArray = new String[]{};
        SkuFilterIface chaseReqsSkuFilter = this.getStdLangsAndInOrderSkuFilter();
        SkuRequirementsForOrder skuReqForOrder = this.getSkuRequirements(type);
        if (skuReqForOrder != null) {
            HashSet<String> requirements = skuReqForOrder.getFullSkuRequirements(platform, spsSku, chaseReqsSkuFilter);
            reqArray = requirements.toArray(new String[0]);
        }
        return reqArray;
    }

    public boolean setMediaType(String type) {
        boolean retVal = true;
        this.root.setAttribute("mediatype", type);
        this.mediaType = type.toLowerCase(Locale.ENGLISH);
        return retVal;
    }

    public boolean setStandAlone(boolean value) {
        boolean retVal = true;
        this.standAlone = value ? "true" : "false";
        this.root.setAttribute("sa_depot", this.standAlone);
        return retVal;
    }

    public ExtendedOrderData getExtendedData() {
        return this.extendedOrderData;
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getSetnumids() {
        String[] setnumids = new String[this.sids.size()];
        int index = 0;
        Enumeration keys = this.sids.keys();
        while (keys.hasMoreElements()) {
            setnumids[index++] = (String)keys.nextElement();
        }
        return setnumids;
    }

    public String getSidType(String setnumid) {
        String sidType = null;
        SIDData sidData = (SIDData)this.sids.get(setnumid);
        if (sidData != null) {
            sidType = sidData.getType();
        }
        return sidType;
    }

    public String getSidVersion(String setnumid) {
        String sidVersion = null;
        SIDData sidData = (SIDData)this.sids.get(setnumid);
        if (sidData != null) {
            sidVersion = sidData.getVersion();
        }
        return sidVersion;
    }

    public String getSidRevision(String setnumid) {
        String sidRevision = null;
        SIDData sidData = (SIDData)this.sids.get(setnumid);
        if (sidData != null) {
            sidRevision = sidData.getRevision();
        }
        return sidRevision;
    }

    public Vector<String> getSidProducts(String setnumid) {
        Vector<String> products = null;
        SIDData sidData = (SIDData)this.sids.get(setnumid);
        if (sidData != null) {
            products = new Vector<String>();
            for (String product : sidData.getProducts()) {
                products.add(product.toLowerCase(Locale.ENGLISH));
            }
        }
        return products;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDescription(String loc) {
        String retVal = this.extendedOrderData.getDescription();
        if (retVal == null) {
            retVal = this.getOriginalDescription(loc);
        }
        if (retVal == null) {
            retVal = this.getOriginalDescription("en");
        }
        return retVal;
    }

    public String getOriginalDescription(String loc) {
        return (String)this.description.get(loc.toLowerCase(Locale.ENGLISH));
    }

    public String[] getVolsers() {
        VolserData[] volserData = new VolserData[this.volsers.size()];
        Iterator volserIter = this.volsers.iterator();
        int i = 0;
        while (volserIter.hasNext()) {
            volserData[i] = this.deploymentData.getVolser((String)volserIter.next());
            ++i;
        }
        for (int i2 = volserData.length - 1; i2 > 0; --i2) {
            for (int j = 0; j < i2; ++j) {
                if (volserData[j].getVolnumAsLong() <= volserData[j + 1].getVolnumAsLong()) continue;
                VolserData temp = volserData[j];
                volserData[j] = volserData[j + 1];
                volserData[j + 1] = temp;
            }
        }
        String[] list = new String[volserData.length];
        for (int i3 = 0; i3 < volserData.length; ++i3) {
            list[i3] = volserData[i3].getVolser();
        }
        return list;
    }

    public String[] getVolsers(String type) {
        Vector<String> list = new Vector<String>();
        if (type != null) {
            String lcType = type.toLowerCase(Locale.ENGLISH);
            String[] volsers = this.getVolsers();
            for (int i = 0; i < volsers.length; ++i) {
                if (!lcType.equals(this.deploymentData.getVolser(volsers[i]).getType())) continue;
                list.add(volsers[i]);
            }
        }
        return list.toArray(new String[0]);
    }

    public String[] getMediaTypes() {
        Vector<String> types = new Vector<String>();
        String[] volsers = this.getVolsers();
        for (int i = 0; i < volsers.length; ++i) {
            String type = this.deploymentData.getVolser(volsers[i]).getType();
            if (types.contains(type)) continue;
            types.add(type);
        }
        return types.toArray(new String[0]);
    }

    public String[] getExportMediaTypes() {
        Vector<String> types = new Vector<String>();
        String[] volsers = this.getVolsers();
        for (int i = 0; i < volsers.length; ++i) {
            String type = this.deploymentData.getVolser(volsers[i]).getType();
            if ("esdm".equals(type) || "3480".equals(type) || "3590".equals(type) || types.contains(type)) continue;
            types.add(type);
        }
        return types.toArray(new String[0]);
    }

    public boolean containsSASINSTALL() {
        return this.containsSASINSTALL;
    }

    public boolean containsMIT() {
        return this.containsMIT;
    }

    public boolean isPlanning() {
        return "planning".equals(this.type);
    }

    public boolean isServicePack() {
        return "servicepack".equals(this.type);
    }

    public boolean isWeb() {
        return "web".equals(this.type);
    }

    public String getDepotVersion() {
        return this.depotVersion;
    }

    public int getDepotVersionAsInt() {
        int number = 0;
        try {
            number = Integer.parseInt(this.depotVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return number;
    }

    public boolean isStandAlone() {
        return "true".equals(this.standAlone);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getOrderInfoDir() {
        return this.file.getParent();
    }

    public String getMaintLevel() {
        return this.maintLevel;
    }

    public String getShipEvent() {
        return this.shipEvent;
    }

    public String[] getMVAAltSkus(String spsSku) {
        Vector<String> list = null;
        Vector mvaAltSkusVector = (Vector)this.mvaAltSkus.get(spsSku);
        if (mvaAltSkusVector != null) {
            list = new Vector<String>();
            for (String sku : mvaAltSkusVector) {
                if (!this.spsSkuDataHashWithPayload.containsKey(sku)) continue;
                list.add(sku);
            }
        }
        if (list != null) {
            return list.toArray(new String[0]);
        }
        return null;
    }

    public String getMaintenanceSku(String product, String version, String platform, String language) {
        return (String)this.maintenance.get(product.toLowerCase(Locale.ENGLISH) + ":" + version.toLowerCase(Locale.ENGLISH) + ":" + platform.toLowerCase(Locale.ENGLISH) + ":" + language.toLowerCase(Locale.ENGLISH));
    }

    public String[] getAllMaintenanceSkus(String product, String version, String platform) {
        Vector spsSkus = new Vector();
        Enumeration keys = this.maintenance.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(product.toLowerCase(Locale.ENGLISH) + ":" + version.toLowerCase(Locale.ENGLISH) + ":" + platform.toLowerCase(Locale.ENGLISH) + ":")) continue;
            spsSkus.add(this.maintenance.get(key));
        }
        return spsSkus.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        boolean retVal = false;
        if ((this.file.getParentFile().isDirectory() || this.file.getParentFile().mkdirs()) && !this.file.isFile()) {
            try {
                this.file.createNewFile();
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
            }
        }
        if (this.file.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.file);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(this.doc), new StreamResult(stream));
                retVal = true;
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        retVal = false;
                    }
                }
            }
            Utils.removeBlankLines(this.file);
        }
        return retVal;
    }

    private HashSet<SpsSkuData> getSkuDataByProdCode(String prodCode) {
        HashSet<SpsSkuData> matchingSpsSkuData;
        if (this.spsSkuDataByProdCode == null) {
            this.buildSkuDataByProdCode();
        }
        if ((matchingSpsSkuData = this.spsSkuDataByProdCode.get(prodCode)) == null) {
            matchingSpsSkuData = new HashSet();
        }
        return matchingSpsSkuData;
    }

    private void buildSkuDataByProdCode() {
        this.spsSkuDataByProdCode = new Hashtable();
        for (SpsSkuData spsSkuData : this.spsSkuDataHash.values()) {
            String prodCode = spsSkuData.getProdCode();
            HashSet<SpsSkuData> spsSkusForThisCode = this.spsSkuDataByProdCode.get(prodCode);
            if (spsSkusForThisCode == null) {
                spsSkusForThisCode = new HashSet();
                this.spsSkuDataByProdCode.put(prodCode, spsSkusForThisCode);
            }
            spsSkusForThisCode.add(spsSkuData);
        }
    }

    public SpsSkuData getSpsSkuDataForFullSkuTypes(String prodCode, String platform, SkuFilterIface filter) {
        SpsSkuData foundSkuData = null;
        Iterator<SpsSkuData> spsSkuDataIt = this.getSkuDataByProdCode(prodCode).iterator();
        while (foundSkuData == null && spsSkuDataIt.hasNext()) {
            foundSkuData = spsSkuDataIt.next();
            if (foundSkuData.isDeltaRelease() || foundSkuData.getSku(platform) == null) {
                foundSkuData = null;
                continue;
            }
            if (filter.getFilteredSku(foundSkuData, this, platform) != null) continue;
            foundSkuData = null;
        }
        return foundSkuData;
    }

    private void loadRequirementsData(String file) {
        if (Globals.g_processRequirements) {
            try {
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
                NodeList data = root.getChildNodes();
                if (data != null) {
                    for (String reqType : DEFAULT_REQ_TYPES) {
                        SkuRequirementsForOrder skuReqs = this.retrieveSkuRequirementsForOrder(reqType);
                        for (int i = 0; i < data.getLength(); ++i) {
                            Element element;
                            if (data.item(i).getNodeType() != 1 || !"sku".equals((element = (Element)data.item(i)).getTagName())) continue;
                            skuReqs.loadSkuReqElement(element, reqType);
                        }
                    }
                }
            }
            catch (FileNotFoundException root) {
            }
            catch (IOException e) {
                Logging.log.info("Error Reading Select XML File: " + file);
                Logging.log.info(e.getMessage());
            }
            catch (Exception e) {
                Logging.log.info("Error Parsing Select XML File: " + file);
                Logging.log.info(e.getMessage());
            }
        }
    }

    public void loadSIDs(Element root) {
        NodeList data = root.getChildNodes();
        if (data != null) {
            for (int i = 0; i < data.getLength(); ++i) {
                Element element;
                if (data.item(i).getNodeType() != 1 || !"sid".equals((element = (Element)data.item(i)).getTagName())) continue;
                SIDData sidData = new SIDData(element);
                this.sids.put(sidData.getSetnumid(), sidData);
            }
        }
    }

    static {
        DEFAULT_REQ_TYPES = Arrays.asList("triggers_install", "blocks_uninstall");
    }

    private class SIDData {
        private String type;
        private String setnumid;
        private String version;
        private String revision;
        private Vector<String> products = new Vector();

        private SIDData(Element root) {
            NodeList data;
            this.type = root.getAttribute("fmtype");
            this.setnumid = root.getAttribute("setnumid");
            this.version = root.getAttribute("ver");
            this.revision = root.getAttribute("rev");
            if (!"SPDS".equals(this.type) && !"JMP".equals(this.type) && "NAP".equals(this.type) && (data = root.getChildNodes()) != null) {
                for (int i = 0; i < data.getLength(); ++i) {
                    Element element;
                    if (data.item(i).getNodeType() != 1 || !"prod".equals((element = (Element)data.item(i)).getTagName())) continue;
                    this.products.add(element.getFirstChild().getNodeValue());
                }
            }
        }

        public String getType() {
            return this.type;
        }

        public String getSetnumid() {
            return this.setnumid;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRevision() {
            return this.revision;
        }

        public Vector<String> getProducts() {
            return this.products;
        }
    }
}

