/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrationSchema {
    private final String OS_FAMILY_UNDEFINED = "Undefined";
    private final String OS_FAMILY_UNIX = "Unix";
    private final String OS_FAMILY_WINDOWS = "Windows";
    private final String OS_FAMILY_MAC = "Macintosh";
    private final String OS_FAMILY_MVS = "MVS";
    private final String OS_FAMILY_VMS = "VMS";
    private final String ORIGINALTIERS_NAME = "originalTiers";
    private final String NEWTIERS_NAME = "newTiers";
    private final String TIER_NAME = "tier";
    private final String PRODUCTS_NAME = "products";
    private final String PRODUCT_NAME = "product";
    private final String DEPLOYMENTS_NAME = "deployments";
    private final String DEPLOYMENT_NAME = "deployment";
    private final String COMPLETE_SCHEMA_FILE = "deployment-wizard.xml";
    private Document m_doc = null;
    private Element m_root = null;
    private File m_file = null;
    private ArrayList m_origTiers = new ArrayList();
    private ArrayList m_newTiers = new ArrayList();

    public MigrationSchema(String file) throws IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public MigrationSchema(File file) throws IOException, ParserConfigurationException, SAXException {
        if (file.exists()) {
            File completeSchema = new File(file.getParentFile(), "deployment-wizard.xml");
            this.m_file = completeSchema.isFile() ? completeSchema : file;
            this.m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(this.m_file));
            this.m_root = this.m_doc.getDocumentElement();
            this.loadOrigData();
        } else {
            Logging.log.severe("Migration schema file missing: " + file.getAbsolutePath());
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        String toString = "";
        toString = toString + "New Tiers: " + this.m_newTiers.size() + "\n";
        for (int j = 0; j < this.m_newTiers.size(); ++j) {
            Tier newTier = (Tier)this.m_newTiers.get(j);
            toString = toString + newTier.toString() + "\n";
        }
        return toString;
    }

    public boolean equals(String schema) {
        return this.toString().equals(schema);
    }

    private void loadOrigData() {
        NodeList origTiers = this.m_root.getElementsByTagName("originalTiers");
        if (origTiers.getLength() == 1) {
            NodeList tiers = ((Element)origTiers.item(0)).getElementsByTagName("tier");
            for (int i = 0; i < tiers.getLength(); ++i) {
                this.m_origTiers.add(new Tier((Element)tiers.item(i)));
            }
        }
    }

    public boolean hasNewTiers() {
        return this.m_newTiers.size() >= 1;
    }

    public int newTiersSize() {
        return this.m_newTiers.size();
    }

    public Tier getNewTierWithName(String machineName) {
        for (int i = 0; i < this.m_newTiers.size(); ++i) {
            Tier currentTier = (Tier)this.m_newTiers.get(i);
            if (!machineName.equalsIgnoreCase(currentTier.getName())) continue;
            return currentTier;
        }
        return null;
    }

    public boolean originalTierHasPorts(String tierName) {
        for (int i = 0; i < this.m_origTiers.size(); ++i) {
            Tier currentTier = (Tier)this.m_origTiers.get(i);
            if (!tierName.equalsIgnoreCase(currentTier.getName())) continue;
            return currentTier.hasPorts();
        }
        return false;
    }

    public boolean deleteNewTierWithName(String machineName) {
        for (int i = 0; i < this.m_newTiers.size(); ++i) {
            Tier currentTier = (Tier)this.m_newTiers.get(i);
            if (!machineName.equalsIgnoreCase(currentTier.getName())) continue;
            this.m_newTiers.remove(i);
            return true;
        }
        return false;
    }

    public void deleteNewTiers() {
        this.m_newTiers = new ArrayList();
        this.removeRecursively(this.m_doc, (short)1, "newTiers");
    }

    private void removeRecursively(Node node, short nodeType, String name) {
        if (node.getNodeType() == nodeType && (name == null || node.getNodeName().equals(name))) {
            node.getParentNode().removeChild(node);
        } else {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                this.removeRecursively(list.item(i), nodeType, name);
            }
        }
    }

    public boolean hasMatchingNewTierMachine(String machineName) {
        Tier tier = this.getNewTierWithName(machineName);
        if (tier != null) {
            Logging.log.info("Migration schema: Found newTier with name = " + machineName);
            return true;
        }
        return false;
    }

    public boolean hasMatchingNewTierHost(String machineName, String hostname) {
        Tier tier = this.getNewTierWithName(machineName);
        if (tier != null && hostname.equalsIgnoreCase(tier.getHost())) {
            Logging.log.info("Migration schema: newTier with name = " + machineName + " has host = " + hostname);
            return true;
        }
        return false;
    }

    public ArrayList getOrigMachines(boolean metadataServerOnly) {
        Tier origTier = null;
        ArrayList<String> origMachines = new ArrayList<String>();
        for (int i = 0; i < this.m_origTiers.size(); ++i) {
            origTier = (Tier)this.m_origTiers.get(i);
            if ((!metadataServerOnly || !origTier.isMetadataServer()) && (metadataServerOnly || origTier.isMetadataServer())) continue;
            origMachines.add(origTier.getName());
        }
        return origMachines;
    }

    public String getOldPort(String origTier, String prodCode, String deploymentURL, String portURL, String portProperty) {
        String oldPort = null;
        Tier originalTier = null;
        for (int i = 0; i < this.m_origTiers.size() && originalTier == null; ++i) {
            Tier tier = (Tier)this.m_origTiers.get(i);
            if (!tier.getName().equals(origTier)) continue;
            originalTier = tier;
        }
        ArrayList products = originalTier.getProducts();
        for (int i = 0; i < products.size(); ++i) {
            if (!prodCode.equals(((Product)products.get(i)).getID())) continue;
            ArrayList deployments = ((Product)products.get(i)).getDeployments();
            for (int j = 0; j < deployments.size(); ++j) {
                Element deployment = ((Deployment)deployments.get(j)).getElement();
                if (!deploymentURL.equals(deployment.getAttribute("URL"))) continue;
                NodeList ports = deployment.getElementsByTagName("port");
                for (int k = 0; k < ports.getLength(); ++k) {
                    Element port = (Element)ports.item(k);
                    if (!portURL.equals(port.getAttribute("URL")) || !portProperty.equals(port.getAttribute("sdwprop"))) continue;
                    oldPort = port.getTextContent();
                }
            }
        }
        return oldPort;
    }

    public Tier addNewTier(String origTier) {
        boolean exists = false;
        Element newTier = null;
        Tier tier = null;
        String host = Globals.g_fqHostName;
        for (int i = 0; i < this.m_newTiers.size() && !exists; ++i) {
            tier = (Tier)this.m_newTiers.get(i);
            if (!tier.getHost().equalsIgnoreCase(host)) continue;
            exists = true;
            return tier;
        }
        if (!exists) {
            Tier originalTier = null;
            for (int i = 0; i < this.m_origTiers.size() && originalTier == null; ++i) {
                tier = (Tier)this.m_origTiers.get(i);
                if (!tier.getName().equals(origTier)) continue;
                originalTier = tier;
            }
            if (originalTier != null) {
                Element newTiers = null;
                NodeList nodes = this.m_root.getElementsByTagName("newTiers");
                if (nodes.getLength() == 0) {
                    newTiers = this.m_doc.createElement("newTiers");
                    this.m_root.appendChild(newTiers);
                } else if (nodes.getLength() == 1) {
                    newTiers = (Element)nodes.item(0);
                }
                if (newTiers != null) {
                    String configDir = Utils.joinPath(Globals.g_configData.getProperty("config.home.dir", ""), Globals.g_configData.getProperty("config.level.name", ""));
                    newTier = this.m_doc.createElement("tier");
                    newTier.setAttribute("primary", originalTier.getPrimary());
                    newTier.setAttribute("name", Globals.g_machine.getName());
                    newTier.setAttribute("host", host);
                    newTier.setAttribute("configdir", configDir);
                    newTier.setAttribute("osfamily", this.getOSFamily());
                    newTier.setAttribute("os", Utils.getOS_Suffix());
                    newTiers.appendChild(newTier);
                    Element products = this.m_doc.createElement("products");
                    newTier.appendChild(products);
                    Element product = null;
                    Element deployments = null;
                    Node deployment = null;
                    ArrayList productList = originalTier.getProducts();
                    for (int i = 0; i < productList.size(); ++i) {
                        product = this.m_doc.createElement("product");
                        product.setAttribute("id", ((Product)productList.get(i)).getID());
                        products.appendChild(product);
                        deployments = this.m_doc.createElement("deployments");
                        product.appendChild(deployments);
                        ArrayList deploymentList = ((Product)productList.get(i)).getDeployments();
                        for (int j = 0; j < deploymentList.size(); ++j) {
                            deployment = ((Deployment)deploymentList.get(j)).getElement().cloneNode(true);
                            deployments.appendChild(deployment);
                        }
                    }
                    this.m_newTiers.add(new Tier(newTier));
                }
            }
        }
        return new Tier(newTier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File outputFile) {
        boolean retVal = false;
        File parent = outputFile.getParentFile();
        if ((parent.isDirectory() || parent.mkdirs()) && !outputFile.isFile()) {
            try {
                outputFile.createNewFile();
            }
            catch (IOException e) {
                Logging.log.severe(e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (outputFile.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(outputFile);
                TransformerFactory tfFactory = TransformerFactory.newInstance();
                boolean indent = true;
                try {
                    tfFactory.setAttribute("indent-number", new Integer(4));
                }
                catch (IllegalArgumentException e) {
                    indent = false;
                }
                Transformer transformer = tfFactory.newTransformer();
                if (indent) {
                    transformer.setOutputProperty("indent", "yes");
                }
                transformer.transform(new DOMSource(this.m_doc), new StreamResult(new OutputStreamWriter((OutputStream)stream, "utf-8")));
                retVal = true;
            }
            catch (Exception e) {
                Logging.log.severe("Error creating migration schema file: " + outputFile.getAbsolutePath());
                Logging.log.severe(e.getMessage());
                Logging.logStackTrace(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        retVal = false;
                        Logging.logStackTrace(e);
                    }
                }
            }
            Utils.removeBlankLines(outputFile);
        }
        return retVal;
    }

    private String getOSFamily() {
        switch (Utils.getOS()) {
            case 0: {
                return "Undefined";
            }
            case 1: {
                return "Windows";
            }
            case 2: {
                return "Unix";
            }
            case 3: {
                return "Unix";
            }
            case 4: {
                return "Unix";
            }
            case 5: {
                return "Unix";
            }
            case 6: {
                return "VMS";
            }
            case 7: {
                return "Unix";
            }
            case 8: {
                return "MVS";
            }
            case 9: {
                return "Macintosh";
            }
        }
        return "Undefined";
    }

    public String getProductName(String smuMachine, String code) {
        NodeList m_productList = null;
        String name = code;
        File migratescript = new File(Utils.joinPath(Globals.g_configData.getProperty("config.migration.smu.file", ""), smuMachine), "migratescript.xml");
        if (migratescript.isFile()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(migratescript));
                Element root = doc.getDocumentElement();
                m_productList = root.getElementsByTagName("Project");
            }
            catch (Exception e) {
                Logging.log.warning("Unable to parse the migration script for " + smuMachine + " in: " + migratescript.toString());
                Logging.logStackTrace(e);
            }
        }
        if (m_productList != null) {
            for (int i = 0; i < m_productList.getLength(); ++i) {
                Element node = (Element)m_productList.item(i);
                if (!node.getAttribute("code").equalsIgnoreCase(code)) continue;
                name = node.getAttribute("name");
            }
        }
        return name;
    }

    public class Deployment {
        Element m_element = null;

        public boolean hasPorts() {
            NodeList ports = this.m_element.getElementsByTagName("port");
            return ports.getLength() > 0;
        }

        public Deployment(Element element) {
            this.m_element = element;
        }

        public Element getElement() {
            return this.m_element;
        }

        public String toString() {
            String toString = "\n\t\tURL: " + this.m_element.getAttribute("URL");
            if (this.m_element.hasAttribute("singleton")) {
                toString = toString + ", Singleton: " + this.m_element.getAttribute("singleton");
            }
            if (this.m_element.hasAttribute("label")) {
                toString = toString + ", Label: " + this.m_element.getAttribute("label");
            }
            NodeList ports = this.m_element.getElementsByTagName("port");
            for (int k = 0; k < ports.getLength(); ++k) {
                Element port = (Element)ports.item(k);
                toString = toString + "\n\t\t\t [Port URL: " + port.getAttribute("URL") + ", SDWProperty: " + port.getAttribute("sdwprop") + ", Port: " + port.getTextContent() + "]";
            }
            return toString;
        }
    }

    public class Product {
        String m_id = null;
        ArrayList deploymentsList = new ArrayList();

        public Product(Element element) {
            this.m_id = element.getAttribute("id");
            NodeList deployments = element.getElementsByTagName("deployments");
            if (deployments.getLength() == 1) {
                NodeList deployList = ((Element)deployments.item(0)).getElementsByTagName("deployment");
                for (int i = 0; i < deployList.getLength(); ++i) {
                    this.deploymentsList.add(new Deployment((Element)deployList.item(i)));
                }
            }
        }

        public boolean hasPorts() {
            boolean hasPorts = false;
            for (int i = 0; i < this.deploymentsList.size(); ++i) {
                Deployment currentDeployment = (Deployment)this.deploymentsList.get(i);
                hasPorts = hasPorts || currentDeployment.hasPorts();
            }
            return hasPorts;
        }

        public ArrayList getDeployments() {
            return this.deploymentsList;
        }

        public String getID() {
            return this.m_id;
        }

        public String toString() {
            return "\n\tId: " + this.m_id + ", " + this.deploymentsList.toString();
        }
    }

    public class Tier {
        boolean m_mdServer = false;
        String m_primary = null;
        String m_name = null;
        String m_host = null;
        String m_configDir = null;
        String m_osFamily = null;
        String m_os = null;
        ArrayList m_productsList = new ArrayList();

        public Tier(Element element) {
            this.m_primary = element.getAttribute("primary");
            this.m_name = element.getAttribute("name");
            this.m_host = element.getAttribute("host");
            this.m_configDir = element.getAttribute("configdir");
            this.m_osFamily = element.getAttribute("osfamily");
            this.m_os = element.getAttribute("os");
            if (this.m_primary.equalsIgnoreCase("true")) {
                this.m_mdServer = true;
            }
            Product product = null;
            NodeList products = element.getElementsByTagName("products");
            if (products.getLength() == 1) {
                NodeList prodList = ((Element)products.item(0)).getElementsByTagName("product");
                for (int i = 0; i < prodList.getLength(); ++i) {
                    product = new Product((Element)prodList.item(i));
                    this.m_productsList.add(product);
                }
            }
        }

        public boolean hasPorts() {
            boolean hasPorts = false;
            List<String> plannedConfigs = Arrays.asList(Globals.g_planConfigs);
            for (int i = 0; i < this.m_productsList.size(); ++i) {
                Product currentProduct = (Product)this.m_productsList.get(i);
                hasPorts = hasPorts || currentProduct.hasPorts() && plannedConfigs.contains(currentProduct.getID());
            }
            return hasPorts;
        }

        public ArrayList getProducts() {
            return this.m_productsList;
        }

        public boolean isMetadataServer() {
            return this.m_mdServer;
        }

        public String getPrimary() {
            return this.m_primary;
        }

        public String getName() {
            return this.m_name;
        }

        public String getHost() {
            return this.m_host;
        }

        public String getConfigDir() {
            return this.m_configDir;
        }

        public String getOSFamily() {
            return this.m_osFamily;
        }

        public String getOS() {
            return this.m_os;
        }

        public String toString() {
            return "Name: " + this.m_name + ", Host: " + this.m_host + ", Config Dir: " + this.m_configDir + ", OS Family: " + this.m_osFamily + ", OS: " + this.m_os + ", Metadata Server: " + this.m_mdServer + ", Primary: " + this.m_primary + ", " + this.m_productsList.toString();
        }
    }
}

