/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectBaseXML;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.ssn.ConfigStatus;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.InstanceData;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelConnection;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.tasks.GetObjectProperties;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.omg.CORBA.StringHolder;

public class MetadataAccess {
    private static SSNResource bundle = new SSNResource(PanelConnection.class);
    private static final String COMPONENT_NAME = "SAS Deployment Wizard";
    private static final String TEXT_STORE_NAME = "Migration Schema";
    private static String m_host = "";
    private static String m_port = "";
    private static String m_repository = "";
    private static String m_user = "";
    private static String m_password = "";
    private static String m_repositoryFQID = "";
    private static String m_repositoryID = "";
    private static MdFactory m_mdFactory = null;
    private static MdObjectStore m_mdObjectStore = null;

    private static boolean makeConnection(String host, String port, String repository, String user, String password) {
        boolean valid = true;
        if (host == null || port == null || repository == null || user == null || password == null) {
            valid = false;
        }
        if (Globals.g_metadataRemoved) {
            valid = false;
        } else if (valid && !Globals.g_msConfigured && Globals.g_planConfigs != null) {
            for (int i = 0; i < Globals.g_planConfigs.length && valid; ++i) {
                if (!Globals.g_planConfigs[i].equalsIgnoreCase("metadatasrv")) continue;
                valid = false;
            }
        }
        if (valid && m_mdFactory != null) {
            try {
                MdOMRConnection connection = m_mdFactory.getConnection();
                connection.getServerStatus();
            }
            catch (RemoteException e1) {
                MetadataAccess.closeConnection();
            }
            catch (MdException e) {
                MetadataAccess.closeConnection();
            }
        }
        if (!(!valid || host.equals(m_host) && port.equals(m_port) && user.equals(m_user) && password.equals(m_password))) {
            MetadataAccess.closeConnection();
            try {
                if (m_mdFactory == null) {
                    m_mdFactory = new MdFactoryImpl(false);
                    if (Globals.g_debug) {
                        MetadataAccess.enableLogging();
                    }
                }
                if (m_mdFactory != null) {
                    MdOMRConnection connection = m_mdFactory.getConnection();
                    connection.makeOMRConnection(host, port, user, password);
                    Logging.log.fine("Successful connection to the metadata server: \n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
                    IServer i_conn = connection.MakeIServerConnection();
                    StringHolder out = new StringHolder("");
                    i_conn.Status("<ServerState/>", out, "");
                    if (out.value.toLowerCase().contains("admin")) {
                        valid = false;
                        Logging.log.info("The SAS Metadata Server is in ADMIN mode:" + out.value);
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("PanelConnection.ServerAdmin.txt"), bundle.getString("Common.Info.txt"), 1);
                    }
                    if (valid) {
                        int pollCount = 0;
                        while (!out.value.toLowerCase().contains("online")) {
                            if (pollCount == 0) {
                                Logging.log.fine("The SAS Metadata Server is OFFLINE. Attempting to bring ONLINE");
                                i_conn.Refresh("<OMA FORCE_QUORUM=\"y\"/><CLUSTER RECOMPUTE_QUORUM=\"y\"/>");
                            } else if (pollCount > 30) {
                                Logging.log.fine("Max attempts have been reached.");
                                break;
                            }
                            Thread.sleep(1000L);
                            i_conn.Status("<ServerState/>", out, "");
                            ++pollCount;
                        }
                        if (!out.value.toLowerCase().contains("online")) {
                            valid = false;
                            Logging.log.severe("The SAS Metadata Server is currently OFFLINE:" + out.value);
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("PanelConnection.ServerOffline.txt"), bundle.getString("Common.Error.txt"), 0);
                        } else {
                            Logging.log.fine("The Metadata Server is ONLINE");
                        }
                    }
                } else {
                    valid = false;
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error connecting to the metadata server: " + e.getMessage() + "\n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
                Logging.logStackTrace(e);
            }
            m_host = host;
            m_port = port;
            m_user = user;
            m_password = password;
        }
        if (m_mdFactory == null) {
            valid = false;
        }
        if (valid && m_mdObjectStore == null) {
            try {
                m_mdObjectStore = m_mdFactory.createObjectStore();
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error creating object store: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (valid && !repository.equals(m_repository)) {
            try {
                m_repositoryFQID = null;
                List<CMetadata> repositories = m_mdFactory.getOMIUtil().getRepositories();
                for (CMetadata repos : repositories) {
                    if (!repository.equals(repos.getName())) continue;
                    m_repositoryFQID = repos.getFQID();
                    m_repositoryID = m_repositoryFQID.substring(m_repositoryFQID.indexOf(".") + 1);
                }
                if (m_repositoryFQID == null) {
                    valid = false;
                    Logging.log.severe("Foundation repository not found: " + repository);
                } else {
                    m_repository = repository;
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error finding foundation repository: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        return valid;
    }

    private static void enableLogging() {
        if (m_mdFactory != null) {
            String metadataLogFile = Utils.joinPath(Utils.getSDWDataPath(true), "metadata_client.log");
            String systemOutLogFile = Utils.joinPath(Utils.getSDWDataPath(true), "metadata_system_out.log");
            try {
                m_mdFactory.setDebug(true);
                m_mdFactory.setLoggingEnabled(true);
                m_mdFactory.getUtil().setLogStream(new FileOutputStream(metadataLogFile));
            }
            catch (Exception e) {
                Logging.log.warning("Error setting metadata client log file (" + metadataLogFile + "): " + e.getMessage());
                Logging.logStackTrace(e);
            }
            try {
                m_mdFactory.getUtil().setOutputStream(new FileOutputStream(systemOutLogFile));
            }
            catch (Exception e) {
                Logging.log.warning("Error setting metadata system out log file (" + systemOutLogFile + "): " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
    }

    public static boolean saveMigrationSchema(String host, String port, String repository, String user, String password) {
        boolean valid = MetadataAccess.makeConnection(host, port, repository, user, password);
        MdObjectBaseXML softwareComponent = null;
        boolean found = false;
        if (valid) {
            try {
                String filterString = "<XMLSelect search=\"SoftwareComponent[@Name='SAS Deployment Wizard']\"/>";
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435844, filterString);
                Iterator it = components.iterator();
                while (it.hasNext() && !found) {
                    softwareComponent = (SoftwareComponent)it.next();
                    if (!softwareComponent.getName().equals(COMPONENT_NAME)) continue;
                    found = true;
                }
                if (found) {
                    Logging.log.info("Existing software component found: SAS Deployment Wizard");
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error finding software component: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (valid && !found) {
            try {
                softwareComponent = (SoftwareComponent)m_mdFactory.createComplexMetadataObject(m_mdObjectStore, COMPONENT_NAME, "SoftwareComponent", m_repositoryID);
                softwareComponent.setDesc("SAS Deployment Wizard Data");
                Logging.log.info("New software component created: SAS Deployment Wizard");
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error creating software component: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (valid) {
            try {
                TextStore textStore2;
                if (found) {
                    textStore2 = null;
                    for (TextStore textStore2 : softwareComponent.getNotes()) {
                        if (!textStore2.getName().equals(TEXT_STORE_NAME)) continue;
                        softwareComponent.getNotes().remove(textStore2);
                    }
                }
                textStore2 = (TextStore)m_mdFactory.createComplexMetadataObject(m_mdObjectStore, TEXT_STORE_NAME, "TextStore", m_repositoryID);
                textStore2.setStoredText(MetadataAccess.getSchemaData());
                softwareComponent.getNotes().add(textStore2);
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error creating text store: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (valid) {
            try {
                softwareComponent.updateMetadataAll();
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error saving metadata: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        return valid;
    }

    private static String getSchemaData() {
        String schemaData = "";
        File schemaFile = new File(Globals.g_configData.getProperty("config.migration.schema.file", ""));
        if (schemaFile.isFile()) {
            String line = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(schemaFile));
                line = in.readLine();
                while (line != null) {
                    schemaData = schemaData + line + Globals.g_eol;
                    line = in.readLine();
                }
                in.close();
            }
            catch (Exception e) {
                Logging.log.severe("Error saving migration schema to metadata: " + e.getMessage() + "\n   File: " + schemaFile.getAbsolutePath());
                Logging.logStackTrace(e);
            }
        }
        return schemaData;
    }

    public static boolean loadMigrationSchema(String host, String port, String repository, String user, String password) {
        boolean valid = MetadataAccess.makeConnection(host, port, repository, user, password);
        Root softwareComponent = null;
        boolean found = false;
        if (valid) {
            try {
                String filterString = "<XMLSelect search=\"SoftwareComponent[@Name='SAS Deployment Wizard']\"/>";
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435844, filterString);
                Iterator it = components.iterator();
                while (it.hasNext() && !found) {
                    softwareComponent = (SoftwareComponent)it.next();
                    if (!softwareComponent.getName().equals(COMPONENT_NAME)) continue;
                    found = true;
                }
                if (!found) {
                    valid = false;
                    Logging.log.warning("Error finding software component: SAS Deployment Wizard");
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error finding software component: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (valid) {
            try {
                TextStore textStore = null;
                Iterator it = softwareComponent.getNotes().iterator();
                while (it.hasNext() && textStore == null) {
                    textStore = (TextStore)it.next();
                    if (textStore.getName().equals(TEXT_STORE_NAME)) continue;
                    textStore = null;
                }
                if (textStore != null) {
                    String schemaFile = Utils.joinPath(Globals.g_tempLocation, "schema.xml");
                    PrintWriter outputFile = new PrintWriter(new BufferedWriter(new FileWriter(schemaFile)));
                    outputFile.print(textStore.getStoredText());
                    outputFile.close();
                } else {
                    valid = false;
                    Logging.log.warning("Migration schema not found for: SAS Deployment Wizard");
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error getting migration schema: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        return valid;
    }

    public static boolean isUnique(String host, String port, String repository, String user, String password, String uniqueData, String name) {
        boolean unique = true;
        if (uniqueData == null || name == null) {
            unique = false;
        } else if (MetadataAccess.makeConnection(host, port, repository, user, password)) {
            Root metadataObject = null;
            String query = null;
            String property = null;
            StringTokenizer tokens = new StringTokenizer(uniqueData, ",");
            if (tokens.countTokens() == 1) {
                query = uniqueData;
            } else if (tokens.countTokens() == 2) {
                query = tokens.nextToken().trim();
                property = tokens.nextToken().trim();
            } else {
                Logging.log.severe("Invalid unique parameters: " + uniqueData);
            }
            try {
                Logging.log.fine("unique query: " + query);
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                String fqid = null;
                String prop = null;
                Properties props = null;
                Iterator it = components.iterator();
                while (it.hasNext() && unique) {
                    metadataObject = (Root)it.next();
                    if (property != null) {
                        fqid = metadataObject.getFQID();
                        props = MetadataAccess.getObjectProperties(host, port, repository, user, password, fqid);
                        if (props == null || props.size() <= 0 || (prop = props.getProperty(property, null)) == null || !prop.equalsIgnoreCase(name)) continue;
                        unique = false;
                        continue;
                    }
                    if (!name.equalsIgnoreCase(metadataObject.getName())) continue;
                    unique = false;
                }
            }
            catch (Exception e) {
                unique = false;
                Logging.log.severe("Error using XMLSelect: " + query);
                Logging.logStackTrace(e);
            }
        }
        return unique;
    }

    public static String metaQuery(String host, String port, String repository, String user, String password, String query) {
        String results;
        block5: {
            boolean valid = true;
            results = "";
            valid = query == null ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
            if (valid) {
                Root metadataObject2 = null;
                try {
                    Logging.log.fine("metaquery: " + query);
                    List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                    for (Root metadataObject2 : components) {
                        if (results.length() > 0) {
                            results = results + "|";
                        }
                        results = results + metadataObject2.getName() + "=" + metadataObject2.getFQID();
                    }
                    Logging.log.fine("metaquery results: " + results);
                }
                catch (Exception e) {
                    valid = false;
                    if (Globals.g_mode == 2) break block5;
                    Logging.log.severe("Error using XMLSelect: " + query);
                    Logging.logStackTrace(e);
                }
            }
        }
        return results;
    }

    public static List getMetadataObjects(String host, String port, String repository, String user, String password, String metadataType, String query) {
        List components;
        block3: {
            boolean valid = true;
            components = null;
            valid = query == null ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
            if (valid) {
                try {
                    Logging.log.fine("metadata object query string: " + query);
                    components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, metadataType, 268435864, query);
                }
                catch (Exception e) {
                    valid = false;
                    if (Globals.g_mode == 2) break block3;
                    Logging.log.severe("Error using XMLSelect: " + query);
                    Logging.logStackTrace(e);
                }
            }
        }
        return components;
    }

    public static String getTextStoreProperty(TextStore t, String searchProperty) {
        String propValue;
        block3: {
            String notesText = null;
            StringReader reader = null;
            PropertyMap properties = new PropertyMap();
            propValue = null;
            try {
                notesText = t.getStoredText();
                if (notesText == null) break block3;
                reader = new StringReader(notesText);
                properties.load(reader);
                Iterator<String> iterator = properties.getPropertyIterator();
                while (iterator.hasNext()) {
                    String property = iterator.next();
                    String value = properties.getProperty(property);
                    if (!property.equalsIgnoreCase(searchProperty)) continue;
                    propValue = value;
                    break;
                }
            }
            catch (Exception e) {
                Logging.log.severe("cannnot read TextStore");
                Logging.logStackTrace(e);
            }
        }
        return propValue;
    }

    public static String fqidQuery(String host, String port, String repository, String user, String password, String query) {
        String results;
        block6: {
            boolean valid = true;
            results = "";
            valid = query == null ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
            if (valid) {
                try {
                    Logging.log.fine("fqidquery: " + query);
                    List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                    if (components.size() == 1) {
                        Root metadataObject = (Root)components.get(0);
                        results = metadataObject.getFQID();
                    } else if (components.size() > 1) {
                        Logging.log.severe("More than one object returned for XMLSelect: " + query);
                    }
                    Logging.log.fine("fqidquery results: " + results);
                }
                catch (Exception e) {
                    valid = false;
                    if (!Globals.g_debug) break block6;
                    Logging.log.severe("Error using XMLSelect: " + query);
                    Logging.logStackTrace(e);
                }
            }
        }
        return results;
    }

    public static Hashtable<String, ArrayList<String>> textstoreQuery(String host, String port, String repository, String user, String password, String query) {
        Hashtable<String, ArrayList<String>> hashtable;
        block5: {
            boolean valid = true;
            hashtable = new Hashtable<String, ArrayList<String>>();
            ArrayList<String> textRole = new ArrayList<String>();
            ArrayList<String> siteInfo = new ArrayList<String>();
            valid = query == null ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
            if (valid) {
                try {
                    Logging.log.fine("metaquery: " + query);
                    List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "TextStore", 268435852, query);
                    for (TextStore textStore : components) {
                        Matcher matcher = Pattern.compile("SITEINFO NAME='.*'").matcher(textStore.getStoredText());
                        textRole.add(StringUtils.leftPad(textStore.getTextRole(), 8, "0"));
                        if (matcher.find()) {
                            String[] siteInfoValue = matcher.group(0).split("=");
                            siteInfo.add(siteInfoValue[1]);
                            continue;
                        }
                        siteInfo.add("");
                    }
                    hashtable.put("textRole", textRole);
                    hashtable.put("siteInfo", siteInfo);
                }
                catch (Exception e) {
                    valid = false;
                    if (Globals.g_cmtTask != 3) break block5;
                    Logging.log.severe("Error using XMLSelect: " + query);
                    Logging.logStackTrace(e);
                }
            }
        }
        return hashtable;
    }

    public static List<TextStore> getTextStores(String query) throws RemoteException, MdException {
        return m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "TextStore", 268435852, query);
    }

    public static String propQuery(String host, String port, String repository, String user, String password, String fqid, String property, String value) {
        boolean valid = true;
        String results = "";
        if (value != null) {
            results = value;
        }
        if (fqid == null || property == null) {
            valid = false;
            if (fqid == null) {
                Logging.log.severe("Invalid expression: propquery: fqid is null, property is " + property);
            } else {
                Logging.log.severe("Invalid expression: propquery: fqid is " + fqid + ", property is null");
            }
        } else {
            valid = MetadataAccess.makeConnection(host, port, repository, user, password);
        }
        if (valid) {
            if (fqid.toLowerCase(Locale.ENGLISH).startsWith("<xmlselect")) {
                Logging.log.fine("propquery xmlselect for fqid: " + fqid);
                fqid = MetadataAccess.fqidQuery(host, port, repository, user, password, fqid);
            }
            if (value == null) {
                Logging.log.fine("propquery: " + fqid + ", " + property);
            } else {
                Logging.log.fine("propquery: " + fqid + ", " + property + ", " + value);
            }
            if (fqid.length() > 0) {
                Properties objProps = MetadataAccess.getObjectProperties(host, port, repository, user, password, fqid);
                if (objProps != null && objProps.size() > 0) {
                    String defaultValue = "";
                    if (value != null) {
                        defaultValue = value;
                    }
                    results = objProps.getProperty(property, defaultValue);
                } else if (!PropertyRules.containsProperty(fqid)) {
                    Logging.log.severe("Object properties missing for: " + fqid);
                }
            }
            Logging.log.fine("propquery results: " + results);
        }
        return results;
    }

    public static String instCount(String host, String port, String repository, String user, String password, String query) {
        boolean valid = true;
        String results = "0";
        if (query == null) {
            valid = false;
            Logging.log.severe("Invalid expression for instcount: xmlselect is null");
        } else {
            valid = MetadataAccess.makeConnection(host, port, repository, user, password);
        }
        if (valid) {
            try {
                Logging.log.fine("instcount query: " + query);
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "Root", 268435860, query);
                results = Integer.toString(components.size());
                Logging.log.fine("instcount results: " + results);
            }
            catch (Exception e) {
                valid = false;
                results = "0";
                Logging.log.severe("instcount error querying metadata with: " + query);
                Logging.logStackTrace(e);
            }
        }
        return results;
    }

    public static String getInternalLoginFqid(String host, String port, String repository, String user, String password, String loginUserIdToSearch) {
        boolean valid = true;
        String retfqid = null;
        if (loginUserIdToSearch == null) {
            valid = false;
            Logging.log.severe("Must specify a non-null login ID to search");
        } else {
            valid = MetadataAccess.makeConnection(host, port, repository, user, password);
            if (!valid) {
                Logging.log.fine("No metadata connection could be established to search for login userid");
            }
        }
        if (valid) {
            String name = loginUserIdToSearch.endsWith("@saspw") ? loginUserIdToSearch.substring(0, loginUserIdToSearch.length() - 6) : loginUserIdToSearch;
            String query = "<XMLSelect search=\"InternalLogin[ForIdentity/Person[@Name='" + name + "']]\" />";
            try {
                Logging.log.fine("Login query: " + query);
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "InternalLogin", 128, query);
                if (components != null && components.size() > 0) {
                    Root metadataObject = (Root)components.get(0);
                    retfqid = metadataObject.getFQID();
                    if (components.size() > 1) {
                        Logging.log.fine("Found more than one Login object with the userid: " + loginUserIdToSearch);
                    }
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("getLoginFqid: " + query);
                Logging.logStackTrace(e);
            }
        }
        return retfqid;
    }

    public static String getLDRProp(String host, String port, String repository, String user, String password, String ldrHost, String property) {
        boolean valid = true;
        String results = "";
        valid = ldrHost == null || property == null ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
        if (valid) {
            Logging.log.fine("getldrprop: " + ldrHost + ", " + property);
            String query = "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='levdirroot']\"/>";
            try {
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                Root metadataObject = null;
                String fqid = null;
                Properties objProps = null;
                String hostName = null;
                boolean found = false;
                Iterator it = components.iterator();
                while (it.hasNext() && !found) {
                    metadataObject = (Root)it.next();
                    fqid = metadataObject.getFQID();
                    objProps = MetadataAccess.getObjectProperties(host, port, repository, user, password, fqid);
                    if (objProps != null && objProps.size() > 0) {
                        hostName = objProps.getProperty("os.localhost.host.name", "");
                        found = hostName.equalsIgnoreCase(ldrHost);
                        if (!found) {
                            hostName = objProps.getProperty("os.localhost.fqdn.host.name", "");
                            found = hostName.equalsIgnoreCase(ldrHost);
                        }
                        if (!found) continue;
                        results = objProps.getProperty(property, "");
                        continue;
                    }
                    Logging.log.severe("Object properties missing for: " + fqid);
                }
                Logging.log.fine("getldrprop results: " + results);
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error using XMLSelect: " + query);
                Logging.logStackTrace(e);
            }
        }
        return results;
    }

    public static String getRepositoryName(String host, String port, String user, String password) {
        String reposName = null;
        boolean metadataAvailable = true;
        if (Globals.g_planConfigs != null) {
            for (int i = 0; i < Globals.g_planConfigs.length && metadataAvailable; ++i) {
                if (!Globals.g_planConfigs[i].equalsIgnoreCase("metadatasrv")) continue;
                metadataAvailable = false;
            }
        }
        if (metadataAvailable) {
            try {
                MdFactoryImpl mdFactory = new MdFactoryImpl(false);
                if (mdFactory != null) {
                    MdOMRConnection connection = mdFactory.getConnection();
                    connection.makeOMRConnection(host, port, user, password);
                    reposName = mdFactory.getOMIUtil().getFoundationRepository().getName();
                    connection.closeOMRConnection();
                    connection.dispose();
                    mdFactory.dispose();
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error retrieving foundation repository name: \n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
                Logging.logStackTrace(e);
            }
        }
        return reposName;
    }

    public static void closeConnection() {
        if (m_mdFactory != null) {
            try {
                m_mdObjectStore.dispose();
                m_mdObjectStore = null;
                m_mdFactory.closeOMRConnection();
                m_mdFactory.dispose();
                m_mdFactory = null;
                m_host = "";
                m_port = "";
                m_user = "";
                m_password = "";
                m_repository = "";
                m_repositoryID = "";
                m_repositoryFQID = "";
            }
            catch (Exception e) {
                Logging.log.warning("Error closing metadata server connection: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
    }

    public static boolean testConnection(String host, String port, String user, String password) {
        boolean valid = false;
        try {
            MdFactoryImpl mdFactory = new MdFactoryImpl(false);
            if (mdFactory != null) {
                MdOMRConnection connection = mdFactory.getConnection();
                connection.makeOMRConnection(host, port, user, password);
                connection.closeOMRConnection();
                connection.dispose();
                mdFactory.dispose();
                valid = true;
                Logging.log.fine("Successful connection to the metadata server: \n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error testing connection to the metadata server: " + e.getMessage() + "\n   Host: " + host + "\n   Port: " + port + "\n   User: " + user);
            Logging.logStackTrace(e);
        }
        return valid;
    }

    public static InstanceData[] getInstanceData(String host, String port, String repository, String user, String password, File statusFile) {
        return MetadataAccess.getInstanceData(host, port, repository, user, password, statusFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InstanceData[] getInstanceData(String host, String port, String repository, String user, String password, File statusFile, Boolean listall) {
        ArrayList<InstanceData> instanceData;
        block31: {
            instanceData = new ArrayList<InstanceData>();
            PrintStream origSystemOut = null;
            PrintStream origSystemErr = null;
            try {
                ConfigStatus status = new ConfigStatus(statusFile);
                ConfigStatus.StatusEntry[] statusEntries = status.getStatusEntries();
                String fqid = null;
                String code = null;
                String hotfix = null;
                String hotfixdate = null;
                HashMap noObjectList = new HashMap();
                if (listall.booleanValue()) {
                    boolean noObject = false;
                    for (int i = 0; i < statusEntries.length; ++i) {
                        fqid = statusEntries[i].getFQID();
                        code = statusEntries[i].getCode();
                        hotfix = statusEntries[i].getHotFix();
                        hotfixdate = statusEntries[i].getHotFixDate();
                        if (!code.equalsIgnoreCase(fqid) || noObjectList.containsKey(code)) continue;
                        noObject = true;
                        for (int j = 0; j < statusEntries.length && noObject; ++j) {
                            if (i == j || !code.equalsIgnoreCase(statusEntries[j].getCode()) || code.equalsIgnoreCase(statusEntries[j].getFQID())) continue;
                            noObject = false;
                        }
                        if (!noObject) continue;
                        noObjectList.put(code, null);
                    }
                }
                if (Globals.g_consoleMode) {
                    if (Globals.g_consoleOutStream == null) {
                        try {
                            Globals.g_consoleOutStream = new PrintStream(new FileOutputStream(Globals.g_consoleOutFile));
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                    if (Globals.g_consoleErrStream == null) {
                        try {
                            Globals.g_consoleErrStream = new PrintStream(new FileOutputStream(Globals.g_consoleErrFile));
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                    if (Globals.g_consoleOutStream != null && Globals.g_consoleErrStream != null) {
                        origSystemOut = System.out;
                        origSystemErr = System.err;
                        try {
                            System.setOut(Globals.g_consoleOutStream);
                            System.setErr(Globals.g_consoleErrStream);
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                }
                GetObjectProperties getObjProps = new GetObjectProperties();
                getObjProps.makeConnection(host, port, user, password, repository);
                String order = null;
                String name = null;
                Properties props = null;
                InstanceData data = null;
                for (int i = 0; i < statusEntries.length; ++i) {
                    fqid = statusEntries[i].getFQID();
                    name = MetadataAccess.getObjectName(host, port, repository, user, password, fqid);
                    if (name != null && name.length() > 0) {
                        String webappsrvCode;
                        String prodCode;
                        code = statusEntries[i].getCode();
                        order = statusEntries[i].getOrder();
                        hotfix = statusEntries[i].getHotFix();
                        hotfixdate = statusEntries[i].getHotFixDate();
                        getObjProps.setInclude("All");
                        getObjProps.setFqid(fqid);
                        props = getObjProps.getObjectProperties();
                        if (props != null && (prodCode = props.getProperty("12byte", null)) != null) {
                            String className = null;
                            className = Globals.g_mode == 2 && Globals.g_cmtTask == 5 && Globals.g_configDefaults != null ? Globals.g_configDefaults.getDefault(prodCode + ".configobj.classname", null) : props.getProperty(prodCode + ".configobj.classname", null);
                            if (className != null && className.length() > 0) {
                                getObjProps.setConfigobjClassname(className);
                                props = getObjProps.getObjectProperties();
                                getObjProps.setConfigobjClassname(null);
                            }
                        }
                        if (props == null) continue;
                        if (code.equalsIgnoreCase("webappsrv") && (webappsrvCode = props.getProperty("webappsrv.12byte", null)) != null) {
                            code = webappsrvCode.equalsIgnoreCase("vfabrictcsvr") && props.getProperty("webappsrv.horizontal_cluster", "false").equalsIgnoreCase("true") ? "tcsclusterc" : webappsrvCode;
                        }
                        data = new InstanceData(fqid, code, order, hotfix, hotfixdate, props);
                        instanceData.add(data);
                        if (!Globals.g_debug) continue;
                        String logEntry = "Properties for " + fqid + " (" + code + ")";
                        String key = null;
                        String value = null;
                        Enumeration<?> e = props.propertyNames();
                        while (e.hasMoreElements()) {
                            key = (String)e.nextElement();
                            if (key == null || (value = props.getProperty(key, null)) == null) continue;
                            logEntry = logEntry + "\n" + key + " = " + value;
                        }
                        Logging.log.info(logEntry);
                        continue;
                    }
                    if (!listall.booleanValue()) continue;
                    code = statusEntries[i].getCode();
                    order = statusEntries[i].getOrder();
                    hotfix = statusEntries[i].getHotFix();
                    hotfixdate = statusEntries[i].getHotFixDate();
                    props = null;
                    if (!noObjectList.containsKey(code) || code.equalsIgnoreCase("jboss") || code.equalsIgnoreCase("vfabrictcsvr") || code.equalsIgnoreCase("tcsclusterc") || code.equalsIgnoreCase("weblogic") || code.equalsIgnoreCase("websphereba") || code.equalsIgnoreCase("webspherend") || code.equalsIgnoreCase("levconfig")) continue;
                    data = new InstanceData(fqid, code, order, hotfix, hotfixdate, props);
                    instanceData.add(data);
                }
                getObjProps.closeConnection();
                if (!Globals.g_consoleMode || origSystemOut == null || origSystemErr == null) break block31;
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                break block31;
            }
            try {
                System.setOut(origSystemOut);
                System.setErr(origSystemErr);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            break block31;
            finally {
                if (Globals.g_consoleMode && origSystemOut != null && origSystemErr != null) {
                    try {
                        System.setOut(origSystemOut);
                        System.setErr(origSystemErr);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                }
            }
        }
        if (listall == false) return instanceData.toArray(new InstanceData[0]);
        Globals.g_configData.setCalculatedProperty("machine.configured.list", MetadataAccess.toUpperCaseProdCodeString(instanceData));
        return instanceData.toArray(new InstanceData[0]);
    }

    public static String toUpperCaseProdCodeString(List<InstanceData> instances) {
        TreeSet<String> prodCodeSet = new TreeSet<String>();
        for (InstanceData inst : instances) {
            prodCodeSet.add(inst.getCode().toUpperCase(Locale.ENGLISH));
        }
        StringBuffer sb = new StringBuffer();
        for (String prodCode : prodCodeSet) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(prodCode);
        }
        return sb.toString();
    }

    public static Properties getObjectProperties(String host, String port, String repository, String user, String password, String fqid) {
        String prodCode;
        PrintStream origSystemOut = null;
        PrintStream origSystemErr = null;
        if (Globals.g_consoleMode) {
            if (Globals.g_consoleOutStream == null) {
                try {
                    Globals.g_consoleOutStream = new PrintStream(new FileOutputStream(Globals.g_consoleOutFile));
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            if (Globals.g_consoleErrStream == null) {
                try {
                    Globals.g_consoleErrStream = new PrintStream(new FileOutputStream(Globals.g_consoleErrFile));
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            if (Globals.g_consoleOutStream != null && Globals.g_consoleErrStream != null) {
                origSystemOut = System.out;
                origSystemErr = System.err;
                try {
                    System.setOut(Globals.g_consoleOutStream);
                    System.setErr(Globals.g_consoleErrStream);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
        }
        GetObjectProperties getObjProps = new GetObjectProperties();
        getObjProps.makeConnection(host, port, user, password, repository);
        getObjProps.setInclude("All");
        getObjProps.setFqid(fqid);
        Properties objectProperties = getObjProps.getObjectProperties();
        if (objectProperties != null && (prodCode = objectProperties.getProperty("12byte", null)) != null) {
            String className = null;
            className = Globals.g_mode == 2 && Globals.g_cmtTask == 5 && Globals.g_configDefaults != null ? Globals.g_configDefaults.getDefault(prodCode + ".configobj.classname", null) : objectProperties.getProperty(prodCode + ".configobj.classname", null);
            if (className != null && className.length() > 0) {
                getObjProps.setConfigobjClassname(className);
                objectProperties = getObjProps.getObjectProperties();
            }
        }
        getObjProps.closeConnection();
        if (Globals.g_consoleMode && origSystemOut != null && origSystemErr != null) {
            try {
                System.setOut(origSystemOut);
                System.setErr(origSystemErr);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return objectProperties;
    }

    public static String getObjectName(String host, String port, String repository, String user, String password, String fqid) {
        String name = "";
        if (fqid != null && MetadataAccess.makeConnection(host, port, repository, user, password)) {
            String xmlSelect = "<XMLSelect search=\"*[@Id='" + fqid + "']\"/>";
            try {
                Logging.log.fine("XMLSelect: " + xmlSelect);
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, xmlSelect);
                if (components != null && components.size() == 1) {
                    Root metadataObject = (Root)components.get(0);
                    name = metadataObject.getName();
                }
                Logging.log.fine("XMLSelect results: " + name);
            }
            catch (Exception e) {
                Logging.log.severe("Error using XMLSelect: " + xmlSelect);
                Logging.logStackTrace(e);
            }
        }
        return name;
    }

    public static String[] getDependentComponents(String host, String port, String repository, String user, String password, String fqid) {
        ArrayList<String> dependentComponents = new ArrayList<String>();
        if (fqid != null && MetadataAccess.makeConnection(host, port, repository, user, password)) {
            String xmlSelect = "<XMLSelect search=\"*[@Id='" + fqid + "']\"/>";
            try {
                List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, xmlSelect);
                if (components != null && components.size() == 1) {
                    SoftwareComponent metadataObject = (SoftwareComponent)components.get(0);
                    AssociationList dependents = metadataObject.getDependentComponents();
                    Root dependent2 = null;
                    for (Root dependent2 : dependents) {
                        dependentComponents.add(dependent2.getFQID());
                    }
                }
            }
            catch (Exception e) {
                Logging.log.severe("Error using XMLSelect: " + xmlSelect);
                Logging.logStackTrace(e);
            }
        }
        return dependentComponents.toArray(new String[0]);
    }

    public static boolean isMetadataAdmin(String host, String port, String user, String password) {
        boolean admin = false;
        try {
            MdFactoryImpl mdFactory = new MdFactoryImpl(false);
            if (mdFactory != null) {
                MdOMRConnection connection = mdFactory.getConnection();
                ISecurity_1_1 security = connection.makeISecurityConnection(host, port, user, password);
                if (security != null) {
                    String[][] options = new String[][]{{"ReturnUnrestrictedSource", ""}};
                    VariableArray2dOfStringHolder output = new VariableArray2dOfStringHolder();
                    security.GetInfo("GetIdentityInfo", "", options, output);
                    String keyword = null;
                    for (int i = 0; i < output.value.length && !admin; ++i) {
                        String value;
                        keyword = output.value[i][0];
                        if (keyword == null || !keyword.equals("UserClass") || (value = output.value[i][1]) == null) continue;
                        String userClass = null;
                        StringTokenizer classes = new StringTokenizer(value);
                        while (classes.hasMoreTokens() && !admin) {
                            userClass = classes.nextToken();
                            if (userClass == null || !userClass.equals("Unrestricted")) continue;
                            admin = true;
                        }
                    }
                    connection.closeISecurityConnection(security);
                }
                connection.closeOMRConnection();
                connection.dispose();
                mdFactory.dispose();
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean postBIMigration(String host, String port, String repository, String user, String password, String statusFile) {
        boolean valid = true;
        boolean changed = false;
        String[] searchList = new String[]{"biddata", "bidwipxpoll", "bilschedule", "eguidedata", "mgmtcondata", "msofficedata"};
        if (Globals.g_cmtSASHome == null) {
            Utils.setSASHome();
        }
        if (Globals.g_cmtSASHome != null && new File(statusFile).exists() && MetadataAccess.makeConnection(host, port, repository, user, password)) {
            if (Globals.g_order == null) {
                try (RegistryAccess registryAccess = null;){
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    if (registryAccess != null && registryAccess.open()) {
                        Globals.g_order = registryAccess.getLastOrder();
                    }
                }
            }
            if (Globals.g_cmtTask != 5) {
                Logging.log.info("Migration post-processing info:" + Globals.g_eol + "      SAS Home:              " + Globals.g_cmtSASHome + Globals.g_eol + "      Order:                 " + Globals.g_order + Globals.g_eol + "      Config Dir:            " + Globals.g_cmtConfigDir + Globals.g_eol + "      Metadata User:         " + user + Globals.g_eol + "      Metadata Host:         " + host + Globals.g_eol + "      Metadata Port:         " + port + Globals.g_eol + "      Foundation Repository: " + repository);
            }
            try {
                ConfigStatus status = new ConfigStatus(statusFile);
                ConfigStatus.StatusEntry[] statusEntries = status.getStatusEntries();
                boolean metadataTier = false;
                boolean biLineageTier = false;
                boolean wipTier = false;
                boolean cleanup = true;
                boolean addFQID = false;
                String additionalLog = "";
                String query = null;
                Root metadataObject2 = null;
                for (int i = 0; i < searchList.length; ++i) {
                    cleanup = true;
                    query = "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='" + searchList[i] + "']\"/>";
                    List components = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                    String fqidLogMsg = "";
                    ArrayList<String> fqids = new ArrayList<String>();
                    for (Root metadataObject2 : components) {
                        addFQID = false;
                        if (metadataObject2 != null) {
                            if (searchList[i].equalsIgnoreCase("mgmtcondata")) {
                                if (metadataObject2.getName().equalsIgnoreCase("Mgmt Console Server Data 9.3")) {
                                    addFQID = true;
                                }
                            } else if (searchList[i].equalsIgnoreCase("msofficedata")) {
                                if (metadataObject2.getName().equalsIgnoreCase("Add-In for Office Srvr Data 4.3")) {
                                    addFQID = true;
                                }
                            } else if (searchList[i].equalsIgnoreCase("eguidedata")) {
                                if (metadataObject2.getName().equalsIgnoreCase("Enterprise Guide Srvr Data 4.3")) {
                                    addFQID = true;
                                }
                            } else {
                                addFQID = true;
                            }
                        }
                        if (!addFQID) continue;
                        fqids.add(metadataObject2.getFQID());
                        if (fqidLogMsg.length() == 0) {
                            fqidLogMsg = Globals.g_eol + "         " + metadataObject2.getFQID();
                            continue;
                        }
                        fqidLogMsg = fqidLogMsg + Globals.g_eol + "         " + metadataObject2.getFQID();
                    }
                    fqidLogMsg = fqidLogMsg.length() == 0 ? "      No objects found in metadata" : "      FQIDs found in metadata:" + fqidLogMsg;
                    String statusLogMsg = "";
                    ArrayList<ConfigStatus.StatusEntry> entries = new ArrayList<ConfigStatus.StatusEntry>();
                    for (int j = 0; j < statusEntries.length; ++j) {
                        if (statusEntries[j].getCode().equalsIgnoreCase(searchList[i])) {
                            entries.add(statusEntries[j]);
                            statusLogMsg = statusLogMsg.length() == 0 ? Globals.g_eol + "         " + statusEntries[j].getFQID() : statusLogMsg + Globals.g_eol + "         " + statusEntries[j].getFQID();
                        }
                        if (statusEntries[j].getCode().equalsIgnoreCase("metadatasrv")) {
                            metadataTier = true;
                            continue;
                        }
                        if (statusEntries[j].getCode().equalsIgnoreCase("webinfpltfm")) {
                            wipTier = true;
                            continue;
                        }
                        if (!statusEntries[j].getCode().equalsIgnoreCase("bilschedule")) continue;
                        biLineageTier = true;
                    }
                    statusLogMsg = statusLogMsg.length() == 0 ? "      No entries found in status.xml" : "      Entries found in status.xml:" + statusLogMsg;
                    Logging.log.info("Analyze data for " + searchList[i].toUpperCase(Locale.ENGLISH) + ":" + Globals.g_eol + fqidLogMsg + Globals.g_eol + statusLogMsg);
                    if (searchList[i].equalsIgnoreCase("biddata") || searchList[i].equalsIgnoreCase("eguidedata") || searchList[i].equalsIgnoreCase("mgmtcondata") || searchList[i].equalsIgnoreCase("msofficedata")) {
                        if (!metadataTier) {
                            cleanup = false;
                            if (Globals.g_cmtTask != 5) {
                                Logging.log.info("Not the metadata server machine - post-processing not needed for " + searchList[i].toUpperCase(Locale.ENGLISH));
                            }
                        }
                    } else if (searchList[i].equalsIgnoreCase("bidwipxpoll")) {
                        if (!wipTier) {
                            cleanup = false;
                            query = "<XMLSelect search=\"SoftwareComponent[@ClassIdentifier='webinfpltfm']\"/>";
                            List objects = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "SoftwareComponent", 268435860, query);
                            SoftwareComponent object = null;
                            SoftwareComponent dependsObj = null;
                            AssociationList dependsOn = null;
                            AssociationList notes = null;
                            TextStore notesObj = null;
                            String notesText = null;
                            String wipMachine = null;
                            String propName = null;
                            String propValue = null;
                            Iterator it = objects.iterator();
                            while (it.hasNext() && wipMachine == null) {
                                object = (SoftwareComponent)it.next();
                                if (object == null || (dependsOn = object.getDependsOnComponents()) == null) continue;
                                Iterator depends = dependsOn.iterator();
                                while (depends.hasNext() && wipMachine == null) {
                                    dependsObj = (SoftwareComponent)depends.next();
                                    if (!dependsObj.getClassIdentifier().equalsIgnoreCase("webappsrv") || (notes = dependsObj.getNotes()) == null) continue;
                                    Iterator notesIt = notes.iterator();
                                    while (notesIt.hasNext() && wipMachine == null) {
                                        notesObj = (TextStore)notesIt.next();
                                        if (!notesObj.getName().equalsIgnoreCase("Public Configuration Properties") || (notesText = notesObj.getStoredText()) == null) continue;
                                        StringReader reader = new StringReader(notesText);
                                        PropertyMap properties = new PropertyMap();
                                        properties.load(reader);
                                        Iterator<String> iterator = properties.getPropertyIterator();
                                        while (iterator.hasNext() && wipMachine == null) {
                                            propName = iterator.next();
                                            propValue = properties.getProperty(propName);
                                            if (!propName.equalsIgnoreCase("webappsrv.host")) continue;
                                            wipMachine = propValue;
                                        }
                                    }
                                }
                            }
                            if (wipMachine != null) {
                                additionalLog = additionalLog + Globals.g_eol + "      " + wipMachine;
                            }
                        }
                    } else if (searchList[i].equalsIgnoreCase("bilschedule") && !biLineageTier) {
                        cleanup = false;
                        query = "<XMLSELECT search=\"Machine[DeployedComponents/ServerComponent[@ClassIdentifier='0069e914-b58c-4094-a686-a87df433ec4b']/Properties/Property[@PropertyName='SubType' AND @DefaultValue='BILineage']]\"/>";
                        List servers = m_mdFactory.getOMIUtil().getMetadataObjectsSubset(m_mdObjectStore, m_repositoryFQID, "Machine", 268435860, query);
                        Machine machineObject = null;
                        Iterator it = servers.iterator();
                        while (it.hasNext() && machineObject == null) {
                            machineObject = (Machine)it.next();
                        }
                        if (machineObject != null) {
                            additionalLog = additionalLog + Globals.g_eol + "      " + machineObject.getName();
                        }
                    }
                    boolean productChanged = false;
                    if (cleanup && fqids.size() > 0) {
                        int j;
                        for (j = 0; j < fqids.size(); ++j) {
                            for (int k = 0; k < entries.size() && fqids.get(j) != null; ++k) {
                                if (!((ConfigStatus.StatusEntry)entries.get(k)).getFQID().equalsIgnoreCase((String)fqids.get(j))) continue;
                                fqids.set(j, null);
                                entries.remove(k);
                            }
                        }
                        for (j = 0; j < fqids.size(); ++j) {
                            if (fqids.get(j) == null) continue;
                            for (int k = 0; k < entries.size() && fqids.get(j) != null; ++k) {
                                Logging.log.info("Setting entry in status.xml for " + searchList[i].toUpperCase(Locale.ENGLISH) + " to: " + (String)fqids.get(j));
                                status.updateFQID(((ConfigStatus.StatusEntry)entries.get(k)).getFQID(), (String)fqids.get(j));
                                fqids.set(j, null);
                                productChanged = true;
                            }
                            if (fqids.get(j) == null) continue;
                            Logging.log.info("Setting entry in status.xml for " + searchList[i].toUpperCase(Locale.ENGLISH) + " to: " + (String)fqids.get(j));
                            status.setStatus((String)fqids.get(j), searchList[i], Globals.g_order);
                            fqids.set(j, null);
                            productChanged = true;
                        }
                    }
                    if (productChanged) {
                        changed = true;
                        continue;
                    }
                    Logging.log.info("No changes necessary for " + searchList[i].toUpperCase(Locale.ENGLISH) + ".");
                }
                if (changed) {
                    String backupFile = Utils.joinPath(new File(statusFile).getParent(), "status_backup_" + new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date()) + ".xml");
                    if (Utils.copyFile(statusFile, backupFile) == 0) {
                        Logging.log.info("The status.xml file was backed up to: " + backupFile);
                        if (status.write()) {
                            Logging.log.info("The status.xml file was updated successfully.");
                        }
                    } else {
                        Logging.log.severe("Unable to back up status.xml file to: " + backupFile);
                    }
                } else {
                    Logging.log.info("No changes necessary to status.xml.");
                }
                if (additionalLog.length() > 0) {
                    Logging.log.info("Please run the post-processing on the following additional machines: " + additionalLog);
                }
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error loading status.xml: " + statusFile);
                Logging.logStackTrace(e);
            }
        } else {
            valid = false;
            if (!new File(statusFile).exists()) {
                Logging.log.severe("status.xml file not found: " + statusFile);
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean restartMetadataServer(boolean isStartOption) {
        boolean valid;
        block23: {
            valid = false;
            FileInputStream fileInStream = null;
            String option = null;
            String connectionFile = Utils.joinPath(Globals.g_cmtConfigDir, "Utilities", "metadata.connection.properties");
            try {
                File propsFile = new File(connectionFile);
                if (!propsFile.isFile()) break block23;
                fileInStream = new FileInputStream(propsFile);
                Properties connectionProps = new Properties();
                connectionProps.load(fileInStream);
                fileInStream.close();
                String serverOperationType = connectionProps.getProperty("server.operation.type", "scripts");
                String appserverContextDir = connectionProps.getProperty("metadatasrv.config.lev.appservercontext.dir", null);
                String metadatasrvConfigDirName = connectionProps.getProperty("iomsrv.metadatasrv.config.dir.name", null);
                String metadatasrvScriptName = connectionProps.getProperty("iomsrv.metadatasrv.script.name", null);
                String startOption = connectionProps.getProperty("server.command.start.option", null);
                String stopOption = connectionProps.getProperty("server.command.stop.option", null);
                String host = connectionProps.getProperty("metadata.connection.host", null);
                String port = connectionProps.getProperty("metadata.connection.port", null);
                option = isStartOption ? startOption : stopOption;
                if (appserverContextDir == null || metadatasrvConfigDirName == null || metadatasrvScriptName == null || option == null) break block23;
                boolean runAsServices = serverOperationType.equalsIgnoreCase("services");
                String script = "\"" + Utils.joinPath(appserverContextDir, metadatasrvConfigDirName, metadatasrvScriptName) + "\"";
                String fullCmd = null;
                if (runAsServices) {
                    fullCmd = script + " " + option + " exit";
                    if (Utils.runProcess(fullCmd).getExitValue() == 0) {
                        if (isStartOption && Utils.isPortListening(host, Integer.parseInt(port))) {
                            valid = true;
                        }
                    } else {
                        Logging.log.warning("The metadata server failed to start or stop with the following command: " + fullCmd);
                    }
                    break block23;
                }
                fullCmd = script + " " + option;
                if (Utils.runProcess(fullCmd, false).getExitValue() != 0 || !isStartOption) break block23;
                long listenerTimeout = 90L;
                try {
                    listenerTimeout = Long.parseLong(connectionProps.getProperty("server.listener.timeout", "90"));
                }
                catch (Exception e) {
                    listenerTimeout = 90L;
                }
                long endTime = System.currentTimeMillis() + listenerTimeout * 1000L;
                while (System.currentTimeMillis() < endTime && !valid) {
                    if (Utils.isPortListening(host, Integer.parseInt(port))) {
                        valid = true;
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
                if (!valid) {
                    Logging.log.warning("The metadata server failed to restart with the following command: " + fullCmd);
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error loading connection properties file: " + connectionFile + ". This is expected when performing install only for a configurable hotfix.");
                Logging.logStackTrace(e);
            }
            finally {
                try {
                    if (fileInStream != null) {
                        fileInStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return valid;
    }

    public static String deleteMetadataByFQID(String host, String port, String repository, String user, String password, String objecttype, String objectfqid) {
        boolean valid = true;
        String results = "";
        valid = null == objecttype || null == objectfqid ? false : MetadataAccess.makeConnection(host, port, repository, user, password);
        if (valid) {
            try {
                Logging.log.fine("deleteMetadataByFQID:  objecttype " + objecttype + "  objectfqid " + objectfqid);
                HashMap<String, String> objectMap = new HashMap<String, String>();
                objectMap.put(objectfqid, objecttype);
                List<String> objectListDeleted = m_mdFactory.getOMIUtil().deleteMetadataObjects(objectMap);
                for (String objectfqidDeleted : objectListDeleted) {
                    if (results.length() > 0) {
                        results = results + "|";
                    }
                    results = results + objectfqidDeleted;
                }
                Logging.log.fine("deleteMetadataByFQID results: " + results);
            }
            catch (Exception e) {
                valid = false;
                Logging.log.severe("Error deleteMetadataByFQID:  objecttype " + objecttype + "  objectfqid " + objectfqid);
                Logging.logStackTrace(e);
            }
        }
        return results;
    }
}

