/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.SSNResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ListItemWithGraphic
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -8656238396012201035L;
    protected static SSNResource bundle = new SSNResource(ListItemWithGraphic.class);
    static final ImageIcon successIcon = bundle.getImageIcon("Common.success.image");
    static final ImageIcon warningIcon = bundle.getImageIcon("Common.warning.image");
    static final ImageIcon failureIcon = bundle.getImageIcon("Common.failure.image");
    static final ImageIcon runningIcon = bundle.getImageIcon("Common.running.image");
    static final ImageIcon runningIcon_white = bundle.getImageIcon("Common.running_white.image");
    static final ImageIcon emptyIcon = bundle.getImageIcon("Common.empty.image");
    static final ImageIcon installedIcon = bundle.getImageIcon("Common.info.image");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Font listFont = list.getFont();
        StringTokenizer tokens = new StringTokenizer(value.toString(), "|", false);
        int tokensCount = tokens.countTokens();
        if (tokensCount > 0) {
            this.setText(tokens.nextToken());
            this.setIcon(null);
            if (tokensCount > 1) {
                String iconType = tokens.nextToken();
                if (iconType.equals("1") || iconType.equals("6")) {
                    this.setIcon(successIcon);
                } else if (iconType.equals("2") || iconType.equals("7") || iconType.equals("8")) {
                    this.setIcon(failureIcon);
                } else if (iconType.equals("3")) {
                    Font boldFont;
                    Color background = list.getBackground();
                    if (background.equals(Color.BLACK)) {
                        this.setIcon(runningIcon_white);
                    } else {
                        this.setIcon(runningIcon);
                    }
                    listFont = boldFont = listFont.deriveFont(1);
                } else if (iconType.equals("4") || iconType.equals("9")) {
                    this.setIcon(warningIcon);
                } else if (iconType.equals("5")) {
                    this.setIcon(installedIcon);
                } else if (iconType.equals("-1")) {
                    Font boldFont;
                    listFont = boldFont = listFont.deriveFont(1, listFont.getSize() + 2);
                } else {
                    this.setIcon(emptyIcon);
                }
            }
        }
        this.setBackground(list.getBackground());
        this.setForeground(list.getForeground());
        this.setEnabled(list.isEnabled());
        this.setFont(listFont);
        return this;
    }
}

