/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitAction;
import com.sas.ssn.KitNavPanel;
import com.sas.ssn.KitNodeInfo;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class KitWebPanel
extends JPanel
implements HyperlinkListener,
MouseListener,
KeyListener,
FocusListener {
    protected static SSNResource bundle = new SSNResource(KitWebPanel.class);
    private GridBagConstraints c = new GridBagConstraints();
    private KitNavPanel naviPanel;
    private PrintableEditorPane webPane;
    private JScrollPane scrollPane;
    private PageFormat m_pf = null;
    private String productCode = null;

    public KitWebPanel(String productCode) {
        this.productCode = productCode;
        this.webPane = new PrintableEditorPane();
        this.webPane.setContentType("text/html");
        this.webPane.setEditable(false);
        this.webPane.addMouseListener(this);
        this.naviPanel = new KitNavPanel(this, null);
        this.setLayout(new GridBagLayout());
        this.c.fill = 0;
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(5, 0, 5, 0);
        this.c.anchor = 18;
        this.add((Component)this.naviPanel, this.c);
        this.c.fill = 1;
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.c.anchor = 18;
        this.scrollPane = new JScrollPane(this.webPane);
        this.add((Component)this.scrollPane, this.c);
        MatteBorder matte = BorderFactory.createMatteBorder(0, 5, 0, 5, Color.white);
        Border line = BorderFactory.createLineBorder(Color.white);
        CompoundBorder compound = BorderFactory.createCompoundBorder(line, matte);
        this.webPane.setBorder(compound);
        this.setBorder(BorderFactory.createLineBorder(this.webPane.getBackground(), 1));
        this.scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.scrollPane.getVerticalScrollBar().setFocusable(false);
        this.webPane.addHyperlinkListener(this);
        this.webPane.addKeyListener(this);
        this.webPane.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        MatteBorder matte = BorderFactory.createMatteBorder(0, 5, 0, 5, Color.white);
        Border line = BorderFactory.createLineBorder(Color.yellow);
        CompoundBorder compound = BorderFactory.createCompoundBorder(line, matte);
        this.setBorder(compound);
    }

    @Override
    public void focusLost(FocusEvent e) {
        MatteBorder matte = BorderFactory.createMatteBorder(0, 5, 0, 5, Color.white);
        Border line = BorderFactory.createLineBorder(Color.white);
        CompoundBorder compound = BorderFactory.createCompoundBorder(line, matte);
        this.setBorder(compound);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        URL link = null;
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                link = event.getURL();
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
                System.err.println(e);
            }
            if (link != null) {
                boolean action = true;
                int returnCode = 0;
                String linkString = link.toString();
                if (linkString.toLowerCase(Locale.ENGLISH).startsWith("http://") || linkString.toLowerCase(Locale.ENGLISH).startsWith("https://")) {
                    returnCode = KitAction.launchWebBrowser(link);
                } else if (linkString.toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                    returnCode = KitAction.launchPDFViewer(new File(link.getPath()));
                } else if (this.productCode != null && "__INSTALL_PRODUCT__".equals(new File(linkString).getName())) {
                    String startupLocation = Globals.g_kit.diskSearch(Globals.g_wizard.getFrame(), Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, false));
                    if (startupLocation != null) {
                        ProductData prodData = null;
                        prodData = this.productCode.equalsIgnoreCase("sasinstall") && Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_sasinstallPlat, false) : (this.productCode.equalsIgnoreCase("jmp") && Globals.g_jmpPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_jmpPlat, false) : (this.productCode.equalsIgnoreCase("pcfilesrv") && Globals.g_pcfilesrvPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_pcfilesrvPlat, false) : (this.productCode.equalsIgnoreCase("eguide") && Globals.g_eguidePlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_eguidePlat, false) : (this.productCode.equalsIgnoreCase("msofficeint") && Globals.g_msofficeintPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_msofficeintPlat, false) : (this.productCode.equalsIgnoreCase("msoffintva") && Globals.g_msoffintvaPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, Globals.g_msoffintvaPlat, false) : Globals.g_deploymentData.getProduct(Globals.g_order, this.productCode, false))))));
                        returnCode = KitAction.kitClickAction(prodData, startupLocation, true);
                    }
                } else {
                    action = false;
                }
                if (action) {
                    switch (returnCode) {
                        case 0: {
                            break;
                        }
                        case -4: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitWebPanel.WebBrowserNotFoundMsg.txt") + linkString, bundle.getString("Common.Warning.txt"), 2);
                            break;
                        }
                        case -3: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitWebPanel.AcrobatReaderNotFoundMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                            break;
                        }
                        case -5: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitWebPanel.InvalidOSMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                            break;
                        }
                        case -6: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitWebPanel.NotOSMeetMinReqMsg.txt"), bundle.getString("Common.Warning.txt"), 2);
                            break;
                        }
                        case -2: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("Common.FileNotFound.txt"), bundle.getString("Common.Error.txt"), 2);
                            break;
                        }
                        default: {
                            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.messageString("KitWebPanel.GenericErrorMsg.txt", Integer.toString(returnCode)), bundle.getString("KitWebPanel.GenericErrorTitle.txt"), 2);
                            break;
                        }
                    }
                } else {
                    this.naviPanel.add(link);
                    this.loadPage(link);
                }
            }
        }
    }

    protected void loadPage(URL webPage) {
        try {
            this.webPane.setPage(webPage);
        }
        catch (IOException e) {
            Logging.log.info(e.getMessage());
            System.err.println(e);
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.m_pf == null) {
            this.m_pf = job.defaultPage();
        }
        PrinterDialogThread dialogThread = new PrinterDialogThread(job);
        dialogThread.start();
    }

    public void pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.m_pf == null) {
            this.m_pf = job.defaultPage();
        }
        job.setPrintable(this.webPane, this.m_pf);
        PageSetupThread dialogThread = new PageSetupThread(job);
        dialogThread.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setCopyItemState();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCopyItemState();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setCopyItemState();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCopyItemState();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCopyItemState();
    }

    public void mouseDragged(MouseEvent e) {
        this.setCopyItemState();
    }

    public void setCopyItemState() {
    }

    public void setKitNodeInfo(KitNodeInfo kni) {
        this.naviPanel.setKitNodeInfo(kni);
    }

    public KitNavPanel getNavPanel() {
        return this.naviPanel;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int shifted = e.getModifiers() & 1;
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            switch (shifted) {
                case 0: {
                    this.naviPanel.pageBack();
                    break;
                }
                case 1: {
                    this.naviPanel.pageForward();
                }
            }
        }
        if (e.getKeyCode() == 36) {
            this.naviPanel.goHome();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void setCursor(Cursor c) {
        this.getNavPanel().setCursor(c);
        this.webPane.setCursor(c);
    }

    class PageSetupThread
    extends Thread {
        PrinterJob m_job;

        public PageSetupThread(PrinterJob job) {
            this.m_job = job;
            this.setPriority(1);
        }

        @Override
        public void run() {
            KitWebPanel.this.m_pf = this.m_job.pageDialog(KitWebPanel.this.m_pf);
        }
    }

    class PrinterDialogThread
    extends Thread {
        PrinterJob m_job;

        public PrinterDialogThread(PrinterJob job) {
            this.m_job = job;
            this.setPriority(1);
        }

        @Override
        public void run() {
            this.m_job.setPrintable(KitWebPanel.this.webPane, KitWebPanel.this.m_pf);
            this.m_job.validatePage(KitWebPanel.this.m_pf);
            if (this.m_job.printDialog()) {
                try {
                    this.m_job.setPrintable(KitWebPanel.this.webPane, KitWebPanel.this.m_pf);
                    this.m_job.validatePage(KitWebPanel.this.m_pf);
                    this.m_job.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                    System.err.println(e);
                }
            }
        }
    }
}

