/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.net.MalformedURLException;
import java.net.URL;

public class KitNodeInfo {
    public String bookName;
    public String tabId;
    public URL bookURL;
    private int currentIndex = -1;
    private int maxIndex = -1;
    private URL[] history = new URL[100];

    public KitNodeInfo(String book, String filename) {
        this.bookName = book;
        try {
            this.bookURL = new URL(Utils.pathToURL(System.getProperty("user.dir") + System.getProperty("file.separator") + filename));
        }
        catch (MalformedURLException exc) {
            Logging.log.info("Attempted to create a KitNodeInfo with a bad URL: " + this.bookURL);
            System.err.println("Attempted to create a KitNodeInfo with a bad URL: " + this.bookURL);
            this.bookURL = null;
        }
    }

    public KitNodeInfo(String book, String id, URL webPage) {
        this.bookName = book;
        this.bookURL = webPage;
        this.tabId = id;
        this.history[++this.currentIndex] = webPage;
        this.maxIndex = this.currentIndex;
    }

    public String toString() {
        return this.bookName;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int idx) {
        this.currentIndex = idx;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(int idx) {
        this.maxIndex = idx;
    }

    public URL[] getHistory() {
        return this.history;
    }

    public URL getURL() {
        return this.bookURL;
    }

    public void setURL(URL url) {
        this.bookURL = url;
        this.history[0] = url;
    }

    public String getName() {
        return this.bookName;
    }

    public String getTabid() {
        return this.tabId;
    }
}

