/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

class KitMif {
    private String m_status = null;

    public KitMif() {
        boolean done = false;
        String tmpDir = System.getProperty("java.io.tmpdir");
        String statusFile = Utils.joinPath(tmpDir, "sasstatus.mif");
        File sf = new File(statusFile);
        if (!sf.exists() && !(sf = new File(statusFile = Utils.joinPath(tmpDir, "status.mif"))).exists()) {
            sf = null;
        }
        if (sf != null) {
            String sLine = null;
            String sLCaseLine = null;
            boolean foundNameEqualsStatus = false;
            try {
                BufferedReader in = new BufferedReader(new FileReader(sf));
                sLine = in.readLine();
                while (sLine != null && !done) {
                    String[] valueComponent;
                    sLCaseLine = sLine.toLowerCase(Locale.ENGLISH);
                    if (sLCaseLine.indexOf("name = \"status\"") > 0) {
                        foundNameEqualsStatus = true;
                    }
                    if (foundNameEqualsStatus && sLCaseLine.indexOf("value = ") > 0 && (valueComponent = sLine.split("=")).length > 0) {
                        this.m_status = valueComponent[valueComponent.length - 1];
                        done = true;
                    }
                    sLine = in.readLine();
                }
                in.close();
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
                Logging.logStackTrace(e);
            }
        }
    }

    public String getStatus() {
        return this.m_status;
    }

    public int getStatusRC() {
        String lcStatus = this.m_status.toLowerCase(Locale.ENGLISH);
        if (lcStatus.indexOf("success") > -1) {
            return 0;
        }
        if (lcStatus.indexOf("fail") > -1) {
            return -1;
        }
        if (lcStatus.indexOf("warning") > -1) {
            return 5;
        }
        return 1;
    }

    public static void clearMif() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String statusFile = Utils.joinPath(tmpDir, "sasstatus.mif");
        File sf = new File(statusFile);
        if (sf.exists()) {
            sf.delete();
        }
        if ((sf = new File(statusFile = Utils.joinPath(tmpDir, "status.mif"))).exists()) {
            sf.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createMif(File file, String status, String description) throws IOException {
        boolean success = false;
        if (status != null && description != null) {
            String[] mif = new String[]{"START COMPONENT", "NAME = \"WORKSTATION\"", "  START GROUP", "    NAME = \"ComponentID\"", "    ID = 1", "    CLASS = \"DMTF|ComponentID|1.0\"", "    START ATTRIBUTE", "      NAME = \"Manufacturer\"", "      ID = 1", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(64)", "      VALUE = \"SAS\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Product\"", "      ID = 2", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(64)", "      VALUE = \"SAS Software\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Version\"", "      ID = 3", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(64)", "      VALUE = \"" + Globals.g_majorReleaseVersion + "\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Locale\"", "      ID = 4", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(16)", "      VALUE = \"ENU\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Serial Number\"", "      ID = 5", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(64)", "      VALUE = \"\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Installation\"", "      ID = 6", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(64)", "      VALUE = \"DateTime\"", "    END ATTRIBUTE", "  END GROUP", "  START GROUP", "    NAME = \"InstallStatus\"", "    ID = 2", "    CLASS = \"MICROSOFT|JOBSTATUS|1.0\"", "    START ATTRIBUTE", "      NAME = \"Status\"", "      ID = 1", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(32)", "      VALUE = \"${STATUS}\"", "    END ATTRIBUTE", "    START ATTRIBUTE", "      NAME = \"Description\"", "      ID = 2", "      ACCESS = READ-ONLY", "      STORAGE = SPECIFIC", "      TYPE = STRING(128)", "      VALUE = \"${DESCRIPTION}\"", "    END ATTRIBUTE", "  END GROUP", "END COMPONENT"};
            try (PrintWriter writer = null;){
                writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                String line = null;
                for (int i = 0; i < mif.length; ++i) {
                    line = mif[i];
                    line = Utils.stringReplaceAll(line, "${STATUS}", status);
                    line = Utils.stringReplaceAll(line, "${DESCRIPTION}", description);
                    writer.println(line);
                }
                writer.checkError();
                success = true;
            }
        }
        return success;
    }
}

