/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.KitAction;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PrintableEditorPane;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class KitHelp
implements HyperlinkListener {
    private static final long serialVersionUID = 8738268297532026185L;
    protected static SSNResource bundle = new SSNResource(KitHelp.class);
    private JFrame frame;
    private JFrame parent;
    private PrintableEditorPane helpPane;

    public KitHelp(JFrame parent) {
        try {
            this.frame = new JFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent = parent;
        this.helpPane = new PrintableEditorPane();
        this.helpPane.setContentType("text/html; charset=UTF-8");
        this.helpPane.setEditable(false);
        this.helpPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.helpPane.addHyperlinkListener(this);
        if (this.getFrame() != null) {
            GridBagConstraints c = new GridBagConstraints();
            this.getFrame().getContentPane().setLayout(new GridBagLayout());
            c.fill = 2;
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(5, 0, 5, 0);
            this.getFrame().getContentPane().add((Component)new toolBar(), c);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            c.anchor = 10;
            this.getFrame().getContentPane().add((Component)new JScrollPane(this.helpPane), c);
            this.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    KitHelp.this.getFrame().dispose();
                }
            });
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void show() {
        if (this.getFrame() != null) {
            if (!this.getFrame().isShowing() && this.parent != null) {
                this.getFrame().setTitle(this.parent.getTitle());
                this.getFrame().setIconImage(this.parent.getIconImage());
                this.getFrame().setSize(this.parent.getSize());
                Point location = this.parent.getLocationOnScreen();
                int offset = (int)this.parent.getContentPane().getLocationOnScreen().getY() - this.parent.getY();
                location.translate(offset, offset);
                this.getFrame().setLocation(location);
            }
            this.getFrame().setSize(new Dimension(650, 500));
            this.getFrame().show();
        }
    }

    public void setHelp(String id) {
        if (id != null) {
            File helpFile = new File(id);
            if (helpFile.isFile()) {
                try {
                    Document doc = this.helpPane.getDocument();
                    doc.putProperty("stream", null);
                    this.helpPane.setPage(Utils.pathToURL(id));
                }
                catch (Exception e) {
                    Logging.log.info("Error loading dynamic help file: " + id);
                }
            } else {
                int i = 0;
                String lang = Language.gs_SelectedLanguage;
                String page = "/doc/" + lang + "/deploywiz/html/" + id + ".html";
                URL url = null;
                block9: while (page != null) {
                    try {
                        url = this.getClass().getResource(page);
                        this.helpPane.setPage(url);
                        page = null;
                    }
                    catch (IOException e) {
                        switch (++i) {
                            case 1: {
                                page = "/doc/en/deploywiz/html/" + id + ".html";
                                continue block9;
                            }
                            case 2: {
                                page = "/doc/" + lang + "/deploywiz/html/Overview.html";
                                continue block9;
                            }
                            case 3: {
                                page = "/doc/en/deploywiz/html/Overview.html";
                                continue block9;
                            }
                        }
                        page = null;
                        Logging.log.info("Help Not Found: " + id);
                    }
                }
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    private class PrinterDialogThread
    extends Thread {
        private PrinterJob printerJob;

        public PrinterDialogThread(PrinterJob printerJob) {
            this.printerJob = printerJob;
            this.setPriority(1);
        }

        @Override
        public void run() {
            PageFormat pageFormat = this.printerJob.defaultPage();
            this.printerJob.setPrintable(KitHelp.this.helpPane, pageFormat);
            this.printerJob.validatePage(pageFormat);
            if (this.printerJob.printDialog()) {
                try {
                    this.printerJob.setPrintable(KitHelp.this.helpPane, pageFormat);
                    this.printerJob.validatePage(pageFormat);
                    this.printerJob.print();
                }
                catch (Exception e) {
                    Logging.log.info(e.getMessage());
                }
            }
        }
    }

    private class toolBar
    extends JPanel {
        private JButton printButton;
        private JButton closeButton;
        private JLabel verlabel;
        private KitTextField verinfo;

        public toolBar() {
            String text = bundle.getString("Common.Print.txt");
            this.printButton = new JButton(Util.getLabelWithoutMnemonic(text));
            this.printButton.setMnemonic(Util.getDisplayedMnemonic(text));
            text = bundle.getString("Common.close.txt");
            this.closeButton = new JButton(Util.getLabelWithoutMnemonic(text));
            this.closeButton.setMnemonic(Util.getDisplayedMnemonic(text));
            String version = Utils.GetSDWVersion();
            this.verinfo = new KitTextField();
            this.verinfo.setText(version);
            this.verinfo.setEditable(false);
            text = bundle.getString("KitHelp.Version.txt");
            String txt = Util.getLabelWithoutMnemonic(text);
            this.verlabel = new JLabel(txt);
            this.verlabel.setLabelFor(this.verinfo);
            this.verlabel.setFocusable(false);
            this.verlabel.setFocusable(false);
            this.verlabel.setAlignmentX(1.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 5);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.printButton, c);
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this.closeButton, c);
            c.weightx = 1.0;
            c.anchor = 13;
            c.gridx = 2;
            c.gridy = 0;
            this.add((Component)this.verlabel, c);
            c.weightx = 0.0;
            c.gridx = 3;
            c.gridy = 0;
            this.add((Component)this.verinfo, c);
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PrinterDialogThread printerThread = new PrinterDialogThread(printerJob);
                    printerThread.start();
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KitHelp.this.getFrame().dispose();
                }
            });
        }
    }
}

