/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.ExecuteCommandThread;
import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.JREData;
import com.sas.ssn.KitMif;
import com.sas.ssn.KitUnixOEM;
import com.sas.ssn.KitVMSOEM;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropsParser;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.RuntimeExecutor;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SelectProgramDialog;
import com.sas.ssn.Unzip;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPromptedIface;
import com.sas.tools.deploy.util.SASRuntimeWrapper;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class KitAction {
    public static final int PDF = 10;
    public static final int BROWSER = 11;
    public static final int NOT_OS_MEET_MIN_REQUIREMENTS = -6;
    public static final int ACTION_NOT_VALID_FOR_OS = -5;
    public static final int WEB_BROWSER_NOT_FOUND = -4;
    public static final int ACROBAT_READER_NOT_FOUND = -3;
    public static final int ACTION_FILE_NOT_EXIST = -2;
    public static final int ACTION_ERROR = -1;
    public static final int ACTION_SUCCESS = 0;
    private static SSNResource bundle = new SSNResource(KitAction.class);
    private static final String[] m_searchPath = new String[]{"/usr/local/Acrobat5/bin", "/usr/local/netscape7", "/usr/local/bin", "/usr/bin", "/usr/dt/bin", "/opt/firefox"};
    private static final String[] browserName = new String[]{"netscape", "mozilla", "firefox", "opera"};
    private static final String[] pdfViewerName = new String[]{"acroread", "xpdf"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int kitClickAction(ProductData prodData, String startupLocation, boolean interactive) {
        iStatus = -5;
        if (prodData.getType() == 3 || prodData.getType() == 4) {
            targetFile = new File(prodData.getInstallRef(interactive));
        } else if (prodData.getInstallRef(interactive).endsWith("install.xml") && Globals.g_cmtTask != 41 && Globals.g_cmtTask != 40) {
            installXMLDir = Globals.g_deploymentData.getSpsSkuDataDir(Globals.g_order, prodData.getSpsSku(), false);
            targetFile = new File(installXMLDir, "install.xml");
        } else {
            targetFile = new File(startupLocation, prodData.getInstallRef(interactive));
        }
        lcName = targetFile.getName().toLowerCase(Locale.ENGLISH);
        cmdArgs = prodData.getInstallCmd(interactive);
        spsSku = prodData.getSpsSku();
        prodCode = prodData.getProdCode();
        prodVer = prodData.getProdVersion();
        if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
            langlist = null;
            requiredInstalls = Globals.g_sasHomeStatus.getRequiredInstalls();
            for (i = 0; langlist == null && i < requiredInstalls.length; ++i) {
                if (!spsSku.equals(requiredInstalls[i].getBaseProductData())) continue;
                langlist = "";
                languages = requiredInstalls[i].getExistingLanguages();
                for (j = 0; j < languages.length; ++j) {
                    langlist = j == 0 ? langlist + languages[j] : (Utils.getOS() == 1 ? langlist + "," + languages[j] : langlist + " " + languages[j]);
                }
                cmdArgs = Utils.stringReplaceAll(cmdArgs, "!LANGLIST", langlist);
                if (!prodCode.equalsIgnoreCase("sasinstall")) continue;
                cmdArgs = cmdArgs + " -updatemode";
                cmdArgs = Utils.stringReplaceAll(cmdArgs, "-sid !SID ", "");
                cmdArgs = Utils.stringReplaceAll(cmdArgs, "!SID", "");
                cmdArgs = Utils.stringReplaceAll(cmdArgs, "!SASUPGRADE", "");
            }
        }
        if ((cmdArgs = KitAction.argumentSubstitution(cmdArgs, Language.gs_SelectedLanguage)).indexOf("!PRODCODE") > -1) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PRODCODE", prodCode);
        }
        if (cmdArgs.indexOf("!PRODVER") > -1) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PRODVER", prodData.getProdVersion());
        }
        if (cmdArgs.indexOf("!PRODCUSTVER") > -1) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PRODCUSTVER", prodData.getProdCustVersion());
        }
        if (cmdArgs.indexOf("!PRODMAINT") > -1) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PRODMAINT", prodData.getProdMaint());
        }
        if (cmdArgs.indexOf("!PRODSASREL") > -1) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PRODSASREL", prodData.getProdSASRelease());
        }
        if (cmdArgs.indexOf("!PKGPATH") > -1 && (productDir = Globals.g_deploymentData.getSpsSkuProductDir(Globals.g_order, prodData.getSpsSku(), false)) != null) {
            cmdArgs = Utils.stringReplaceAll(cmdArgs, "!PKGPATH", productDir);
        }
        if (cmdArgs.indexOf("!DFVALUES") > -1) {
            values = KitAction.createDataFluxValues(prodData);
            cmdArgs = values != null ? Utils.stringReplaceAll(cmdArgs, "!DFVALUES", values.getAbsolutePath()) : Utils.stringReplaceAll(cmdArgs, "!DFVALUES", "");
        }
        if (Globals.g_installAllLangs && prodCode.equalsIgnoreCase("sasinstall") && Utils.getOS() == 1) {
            cmdArgs = cmdArgs + " -alllangs";
        }
        if (!targetFile.isFile()) {
            iStatus = -2;
            Logging.log.severe("File Not Found: " + targetFile.getAbsolutePath());
        } else {
            cmdFile = targetFile.getPath();
            reinstallDataFlux = false;
            if ("dfdeploy.exe".equals(lcName) || "dfdeploy.pl".equals(lcName)) {
                regAccess = null;
                try {
                    regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    if (regAccess.open() && regAccess.getMaintDisplayName(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint()) != null) {
                        reinstallDataFlux = true;
                    }
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    if (regAccess != null) {
                        regAccess.close();
                    }
                }
            }
            if (lcName.endsWith(".msi")) {
                if (Utils.getOS() != 1) {
                    iStatus = -5;
                } else {
                    data = WinRegAPI.getWindowsRegistryValue(1, ".msi", "");
                    if (data != null && !data.equals("")) {
                        data = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data, "shell\\open\\command"), "");
                    }
                    if (data == null || data.equals("")) {
                        iStatus = -6;
                    } else {
                        line = data.replaceAll("\"", "");
                        tokens = new StringTokenizer(line, "%", false);
                        token = null;
                        msiCmdLine = "";
                        mysystemroot = null;
                        while (tokens.hasMoreTokens()) {
                            token = tokens.nextToken();
                            if (token.equalsIgnoreCase("systemroot")) {
                                mysystemroot = WinRegAPI.getWindowsRegistryValue(8, "software\\microsoft\\windows nt\\currentversion", "systemroot");
                                msiCmdLine = msiCmdLine.concat(mysystemroot);
                                continue;
                            }
                            if (token.equals("1 ")) {
                                msiCmdLine = msiCmdLine.concat("\"");
                                msiCmdLine = msiCmdLine.concat(targetFile.getPath());
                                msiCmdLine = msiCmdLine.concat("\"");
                                continue;
                            }
                            if (token.equals("*")) {
                                msiCmdLine = msiCmdLine.concat(cmdArgs);
                                continue;
                            }
                            msiCmdLine = msiCmdLine.concat(token);
                        }
                        iStatus = KitAction.executeSetup(prodCode, msiCmdLine, "");
                    }
                }
            } else if (lcName.endsWith("install.xml")) {
                order = Globals.g_order;
                if (Globals.g_cmtTask == 28) {
                    order = prodData.getOrder();
                }
                prodData.getProdCode();
                prodData.getSilentRef();
                if (Globals.g_cmtTask == 28) {
                    Logging.log.info("Uninstall: package=" + prodData.getSilentRef());
                } else if (prodData.getType() == 4) {
                    Logging.log.info("Hot fix: package=" + prodData.getSilentRef());
                }
                iStatus = InstallToolConnector.getConnector().execute(cmdFile, prodData);
            } else if (lcName.endsWith(".jar") || lcName.endsWith(".exe") && Utils.getOS() != 6 || lcName.endsWith(".sh") || lcName.endsWith(".bin") || lcName.endsWith(".pl") || lcName.endsWith("setup_linux") || lcName.endsWith("setup_aix_power") || lcName.endsWith("setup_hpux_11x") || lcName.endsWith("setup_solaris_sparc") || lcName.endsWith("setup_hpux_ia64") || lcName.endsWith("setup_linux_ia64")) {
                if (prodCode.equalsIgnoreCase("mominstall")) {
                    fileName = KitAction.createPropertiesFileForProduct(prodCode);
                    if (Globals.g_cmtTask != 28) {
                        if (fileName != null && fileName != "") {
                            Logging.log.info("Invoking MOM install program");
                            iStatus = KitAction.installMOMProduct(cmdFile, cmdArgs, prodData);
                            Logging.log.info("Return code from mom installer is " + iStatus);
                            if (iStatus == 3010) {
                                iStatus = 0;
                            }
                        } else {
                            iStatus = -1;
                            Logging.log.severe("Missing MOM properties file, unable to invoke MOM install.");
                        }
                        if (iStatus == 0) {
                            regAccess = null;
                            try {
                                regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                                if (!regAccess.open()) ** GOTO lbl161
                                regAccess.setInstallLoc(prodCode, prodVer, prodData.getPlatform(), Globals.g_installData.getProperty("mominstall.products.destination", null));
                                regAccess.setInstallStatus(prodCode, prodVer, prodData.getPlatform(), "0");
                                regAccess.setInstallFamily(prodCode, prodVer, prodData.getPlatform(), prodData.getProdSASRelease());
                                regAccess.setMaintDisplayName(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint(), prodData.getProdCustVersion());
                                regAccess.setMaintLevel(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint());
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                            finally {
                                if (regAccess != null) {
                                    regAccess.close();
                                }
                            }
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dfscrfedsas") && Globals.g_cmtTask == 28) {
                    Logging.log.info("The execution of DFSCRFEDSAS uninstall is bypassed - It will be uninstalled with DFFEDSAS");
                } else {
                    iStatus = KitAction.executeSetup(prodCode, cmdFile, cmdArgs);
                }
lbl161:
                // 6 sources

                if (prodCode.equalsIgnoreCase("javaruntime") && (serverVMZip = new File(targetFile.getParent(), "serverVM.zip")).isFile()) {
                    try {
                        Unzip.getAll(serverVMZip, Globals.g_jreHome);
                        Logging.log.info("Hotspot Server VM extracted to: " + Globals.g_jreHome);
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error extracting the Hotspot Server VM: " + serverVMZip.toString());
                    }
                }
            } else if ("sasinstall".equalsIgnoreCase(prodCode) && Utils.getOS() != 8) {
                iStatus = interactive ? (Utils.getOS() == 6 ? new KitVMSOEM(targetFile.getPath(), cmdArgs).getStatus() : new KitUnixOEM(targetFile.getPath(), cmdArgs).getStatus()) : (Utils.getOS() == 6 ? KitAction.executeSetup(prodCode, cmdFile, cmdArgs) : KitAction.executeSetup(prodCode, cmdFile, cmdArgs + " 1>/dev/null 2>&1"));
            } else if (prodCode.equalsIgnoreCase("privatejre")) {
                Logging.log.info("Execute Command: " + targetFile.getPath());
                sasJreLoc = JREData.getPrivateJREDest();
                JREData.backupJRESecurityFiles();
                JREData.backupTTFontsVert();
                iStatus = JREData.renameInstalledPrivateJRE() == false ? -1 : 0;
                if (iStatus == 0) {
                    if (lcName.endsWith(".tar")) {
                        iStatus = Utils.extractTar(targetFile.getPath(), Globals.g_jreHome, null);
                    } else if (lcName.endsWith(".taz") || lcName.endsWith(".tgz")) {
                        iStatus = Utils.extractTaz(targetFile.getPath(), sasJreLoc, null);
                    } else if (lcName.endsWith(".zip")) {
                        try {
                            Unzip.getAll(targetFile, sasJreLoc);
                            iStatus = 0;
                        }
                        catch (Exception e) {
                            iStatus = -1;
                        }
                    }
                }
                Logging.log.info("Return Code: " + iStatus);
                JREData.restoreJRESecurityFiles();
                JREData.restoreJREFontsFiles();
            } else {
                block230: {
                    Logging.log.info("Extracting file: " + targetFile.getPath());
                    if (lcName.endsWith(".tar")) {
                        iStatus = Utils.extractTar(targetFile.getPath(), Globals.g_wizardData.getPreference("SASHome", ""), null);
                    } else if (lcName.endsWith(".taz")) {
                        iStatus = Utils.extractTaz(targetFile.getPath(), Globals.g_wizardData.getPreference("SASHome", ""), null);
                    } else if (lcName.endsWith(".tar.gz")) {
                        tempFile = null;
                        try {
                            tempFile = File.createTempFile(targetFile.getName(), ".tar");
                        }
                        catch (IOException e) {
                            Logging.log.severe("Could not create temporary file to process .tar.gz file: " + lcName);
                            Logging.logStackTrace(e);
                        }
                        if (tempFile != null && Utils.uncompressGZIP(targetFile.getPath(), tempFile.getPath()) == 0) {
                            iStatus = Utils.extractTar(tempFile.getPath(), Globals.g_wizardData.getPreference("SASHome", ""), null);
                            if (!Globals.g_debug && !tempFile.delete()) {
                                Logging.log.severe("Unable to delete temporary file: " + tempFile.getPath());
                            }
                        }
                    } else if (lcName.endsWith(".zip") || lcName.endsWith(".tgz")) {
                        try {
                            sashome = Globals.g_wizardData.getPreference("SASHome", "");
                            Unzip.getAll(targetFile, sashome);
                            iStatus = 0;
                            path = Unzip.getEntryPath(targetFile, prodCode + "_install.xml", sashome);
                            if (path == null) break block230;
                            regAccess = null;
                            try {
                                regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                                if (regAccess.open()) {
                                    regAccess.setInstallLoc(prodCode, prodVer, sashome + File.separator + path);
                                }
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                            finally {
                                if (regAccess != null) {
                                    regAccess.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            iStatus = -1;
                        }
                    }
                }
                Logging.log.info("Return Code: " + iStatus);
            }
            if (reinstallDataFlux && iStatus == 2) {
                Logging.log.info("Return Code ignored on account of the product already being installed");
                iStatus = 0;
            }
            if (iStatus == 0) {
                if (prodCode.equalsIgnoreCase("privatejre")) {
                    javaexe = JREData.getPrivateJavaCommand();
                    if (javaexe != null) {
                        javaExe = new File(javaexe);
                        if (javaExe != null && javaExe.isFile()) {
                            JREData.removeInstalledPrivateJRE();
                            regAccess = null;
                            try {
                                regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                                if (!regAccess.open()) ** GOTO lbl626
                                regAccess.setInstallLoc(prodCode, prodData.getProdVersion(), JREData.getPlatform(), JREData.getPrivateJREDest());
                                regAccess.setInstallStatus(prodCode, prodData.getProdVersion(), JREData.getPlatform(), "0");
                                jrePanel = (WizardPromptedIface)Globals.g_wizard.getPanel("jre");
                                if (jrePanel == null || jrePanel.getLocation() == null) {
                                    regAccess.setInstallLoc("javaruntime", Globals.g_majorReleaseVersion, JREData.getPlatform(), Globals.g_jreHome);
                                    regAccess.setInstallStatus("javaruntime", Globals.g_majorReleaseVersion, JREData.getPlatform(), "0");
                                }
                                regAccess.setInstallFamily(prodCode, prodVer, prodData.getPlatform(), prodData.getProdSASRelease());
                                regAccess.setMaintDisplayName(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint(), prodData.getProdCustVersion());
                                regAccess.setMaintLevel(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint());
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                            finally {
                                if (regAccess != null) {
                                    regAccess.close();
                                }
                            }
                        } else {
                            iStatus = -1;
                            Logging.log.severe("Java Runtime Environment missing: " + javaExe.getAbsolutePath());
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("txtandocconv") && cmdArgs != null) {
                    cmdUninst = "";
                    installLoc = null;
                    if (Utils.getOS() == 1) {
                        cmdUninst = "uninstall.exe";
                        pattern = Pattern.compile("/dir +\"([^\"]*)", 2);
                    } else {
                        cmdUninst = "uninstall.sh";
                        pattern = Pattern.compile("--dir +\"([^\"]*)", 2);
                    }
                    matcher = pattern.matcher(cmdArgs);
                    if (matcher.find()) {
                        installLoc = new File(matcher.group(1).trim());
                    } else {
                        pattern = Utils.getOS() == 1 ? Pattern.compile("/dir +([^ ]+)", 2) : Pattern.compile("--dir +([^ ]+)", 2);
                        matcher = pattern.matcher(cmdArgs);
                        if (matcher.find()) {
                            installLoc = new File(matcher.group(1).trim());
                        }
                    }
                    if (installLoc != null && installLoc.exists() || Globals.g_cmtTask == 28) {
                        regAccess = null;
                        try {
                            regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                            if (Globals.g_cmtTask == 28) {
                                if (!regAccess.open()) ** GOTO lbl626
                                regAccess.removeInstall(prodCode, prodVer);
                            }
                            if (!regAccess.open()) ** GOTO lbl626
                            regAccess.setInstallLoc(prodCode, prodVer, prodData.getPlatform(), installLoc.getAbsolutePath());
                            regAccess.setInstallStatus(prodCode, prodVer, prodData.getPlatform(), "0");
                            regAccess.setInstallFamily(prodCode, prodVer, prodData.getPlatform(), prodData.getProdSASRelease());
                            regAccess.setMaintDisplayName(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint(), prodData.getProdCustVersion());
                            regAccess.setMaintLevel(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint());
                            regAccess.setMaintUninstallLoc(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint(), "xx", installLoc.getAbsolutePath().concat(File.separator + cmdUninst));
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                        finally {
                            if (regAccess != null) {
                                regAccess.close();
                            }
                        }
                    } else {
                        Logging.log.warning("Unable to determine the install location for txtandocconv");
                    }
                } else if (prodCode.equalsIgnoreCase("dffedsas") || prodCode.equalsIgnoreCase("dfscrfedsas")) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        if (!regAccess.open()) ** GOTO lbl626
                        if (Globals.g_cmtTask == 28) {
                            regAccess.removeInstall(prodCode, prodVer, prodData.getPlatform());
                            if (!prodCode.equalsIgnoreCase("dffedsas")) ** GOTO lbl626
                            regAccess.removeInstall("dfscrfedsas", Globals.PRODVER_DFSCRFEDSAS);
                        }
                        prodHost = regAccess.getInstallLoc(prodCode, prodVer, prodData.getPlatform());
                        if (prodHost == null || prodHost.length() <= 0) ** GOTO lbl626
                        regAccess.setMaintUninstallLoc(prodCode, prodVer, prodData.getPlatform(), prodData.getProdMaint(), "xx", prodHost.concat(File.separator + "Unwise.exe"));
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dmstu") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmstusecure", custProdVersion, platform);
                        regAccess.removeInstall("dmstuncoa", custProdVersion, platform);
                        regAccess.removeInstall("dfqmdm", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dmsvr") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmsvrncoa", custProdVersion, platform);
                        regAccess.removeInstall("dmsvrsecure", custProdVersion, platform);
                        regAccess.removeInstall("dmmdmsvr", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dfweb") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmwebsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dfauthsvr") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dfauthsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dmwebmid") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmwbapsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dffedsvr") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dffedsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dffedsvrclnt") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dffedcsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dffedauthmgr") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmfsapsecure", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("posvr") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                        regAccess.removeInstall("dmposvrscr", custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dfesp") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("dfespclnt") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask != 28) ** GOTO lbl626
                        regAccess.removeInstall(prodCode, custProdVersion, platform);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                } else if (prodCode.equalsIgnoreCase("knwldgebseci") && cmdArgs != null) {
                    regAccess = null;
                    try {
                        regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                        platform = prodData.getPlatform();
                        custProdVersion = prodData.getProdCustVersion();
                        regAccess.open();
                        if (Globals.g_cmtTask == 28) {
                            regAccess.removeInstall(prodCode, custProdVersion, platform);
                        }
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    finally {
                        if (regAccess != null) {
                            regAccess.close();
                        }
                    }
                }
            }
        }
        return iStatus;
    }

    private static int installMOMProduct(String cmdFile, String cmdArgs, ProductData prodData) {
        int rc = 0;
        String pw = Globals.g_installData.getProperty("mominstall.userinfo.localsystempw", null);
        if (pw == null) {
            pw = Globals.g_installData.getProperty("mominstall.userinfo.domainuserpw", null);
        }
        if (pw != null) {
            try {
                pw = SasPasswordString.decode(pw);
            }
            catch (Exception e) {
                pw = "";
                Logging.log.warning("Unable to decode the sasmompassword.");
                Logging.logStackTrace(e);
                return -1;
            }
            String batchName = Utils.joinPath(Globals.g_tempLocation, prodData.getProdCode() + ".bat");
            Boolean ret = KitAction.writeMOMINSTALLBatch(batchName, cmdFile, cmdArgs);
            if (!ret.booleanValue()) {
                Logging.log.severe("Unable to create batch file: " + batchName);
                return -1;
            }
            ArrayList<String> envp = new ArrayList<String>();
            Set<String> envVars = System.getenv().keySet();
            for (String key : envVars) {
                envp.add(key + "=" + System.getenv(key));
            }
            envp.add("sasmompass=" + pw);
            String[] envProps = envp.toArray(new String[0]);
            Object[] cmdArgsArray = new String[]{batchName};
            Process p = null;
            Logging.log.info("Invoking java Runtime.exec() directly to invoke the batch file.");
            Logging.log.info("Command and args array =" + Arrays.toString(cmdArgsArray));
            try {
                p = Runtime.getRuntime().exec((String[])cmdArgsArray, envProps);
                p.waitFor();
                rc = p.exitValue();
                Logging.log.info("Return code from momInstaller is " + rc);
            }
            catch (Exception e) {
                Logging.log.warning("Unable to invoke MOMINSTALL installer");
                Logging.logStackTrace(e);
                rc = -1;
            }
        }
        return rc;
    }

    private static Boolean writeMOMINSTALLBatch(String batchName, String cmdFile, String cmdArgs) {
        String command = "\"" + cmdFile + "\" " + cmdArgs;
        command = command.replace("\"", "^\"");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(batchName, false)));
            out.println("@ echo off");
            out.println("set errorlevel=");
            out.println("set momcmd=" + command);
            out.println("%momcmd%");
            out.println("exit /b %errorlevel%");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            return false;
        }
        return true;
    }

    private static int executeSetup(String prodCode, String cmdFile, String cmdArgs) {
        return KitAction.execute(prodCode, cmdFile, cmdArgs, true, null);
    }

    private static int executeSetup(String prodCode, String cmdFile, String cmdArgs, String[] envp) {
        return KitAction.execute(prodCode, cmdFile, cmdArgs, true, envp);
    }

    private static int execute(String cmdFile, String cmdArgs, boolean wait) {
        return KitAction.execute(null, cmdFile, cmdArgs, wait, null);
    }

    private static int execute(String prodCode, String cmdFile, String cmdArgs, boolean wait, String[] envp) {
        boolean javaInstall = false;
        String cmdLineArgs = cmdArgs;
        String fullCmd = cmdFile;
        String[] envparms = envp;
        if (cmdArgs != null && cmdArgs.length() > 0) {
            fullCmd = fullCmd + " " + cmdArgs;
        }
        String productCode = "";
        String productVersion = "";
        String productCustVersion = "";
        String productMaint = "";
        String productSASRelease = "";
        int returnCode = 0;
        try {
            Process p;
            ExecuteCommandThread cmdThread = null;
            String jar = "";
            if (prodCode != null && !prodCode.equals("")) {
                KitMif mif;
                File jarFile;
                File exe = new File(cmdFile);
                String exeName = exe.getName();
                String prodDir = exe.getParent();
                ProductData productData = Globals.g_deploymentData.getProduct(Globals.g_order, prodCode, false);
                if (productData != null) {
                    productCode = productData.getProdCode();
                    productVersion = productData.getProdVersion();
                    productCustVersion = productData.getProdCustVersion();
                    productMaint = productData.getProdMaint();
                    productSASRelease = productData.getProdSASRelease();
                }
                if (prodDir != null && (exeName.indexOf("setup.jar") == 0 || exeName.indexOf("setup.exe") == 0 || exeName.indexOf("Setup.exe") == 0 || exeName.indexOf("setup_") == 0 || exeName.indexOf("Setup_") == 0 || exeName.indexOf("JRESetup.exe") == 0) && (jarFile = new File(prodDir, "setup.jar")).isFile()) {
                    javaInstall = true;
                    jar = jarFile.getAbsolutePath();
                }
                if (javaInstall) {
                    String javaCmd;
                    File javaCmdFile;
                    if (cmdLineArgs.indexOf("-silent") > -1) {
                        cmdLineArgs = cmdLineArgs.replaceAll("-silent", "-silent -G replaceNewerResponse=noToAll");
                    }
                    if (!(javaCmdFile = new File(javaCmd = Utils.getJavaCommand())).isFile()) {
                        Logging.log.severe("Java executable missing: " + javaCmd);
                    }
                    String javaCmdArgs = " -Xmx512M -Djava.ext.dirs= -cp \"" + jar + (Utils.getOS() == 1 ? "\";\"" : "\":\"") + RegistryData.getDeployRegJar() + "\" run";
                    javaCmdArgs = javaCmdArgs + " " + cmdLineArgs + " -sdwprod \"" + productCode + "\" -sdwver \"" + productVersion + "\"" + (productCustVersion == null || productCustVersion.length() == 0 ? "" : " -sdwcustver \"" + productCustVersion + "\"") + (productMaint == null || productMaint.length() == 0 ? "" : " -sdwmaint \"" + productMaint + "\"") + (productSASRelease == null || productSASRelease.length() == 0 ? "" : " -sdwsasrel \"" + productSASRelease + "\"") + " -jrehome \"" + javaCmd + "\" -wizardlocale " + Language.gs_SelectedLanguage + " -sashome \"" + Globals.g_wizardData.getPreference("SASHome", "") + "\" -vpd \"" + Globals.g_wizardData.getPreference("SASHome", "") + "\"";
                    cmdThread = new ExecuteCommandThread("\"" + javaCmd + "\"" + javaCmdArgs);
                } else {
                    cmdThread = new ExecuteCommandThread(fullCmd);
                }
                Logging.log.info("Execute Command: " + KitAction.filterPasswordsFromLog(cmdThread.getCmd()));
                KitMif.clearMif();
                returnCode = prodCode.equals("mominstall") ? KitAction.executeProcess(cmdThread.getFullCmd(), Globals.g_tempLocation + File.separator + "setupscript", Globals.g_tempLocation + File.separator + ".setuplog", envp) : KitAction.executeProcess(cmdThread.getFullCmd(), Globals.g_tempLocation + File.separator + "setupscript", Globals.g_tempLocation + File.separator + ".setuplog");
                if ((prodCode.equalsIgnoreCase("JMP") || prodCode.equalsIgnoreCase("JMPGENOM") || prodCode.equalsIgnoreCase("JMP64GENOM")) && returnCode == 3010) {
                    returnCode = 0;
                    Logging.log.info("Return Code of 3010 reset to 0 for: " + prodCode);
                }
                if ((mif = new KitMif()).getStatus() != null) {
                    returnCode = mif.getStatusRC();
                }
                Logging.log.info("Return Code: " + returnCode);
                return returnCode;
            }
            if (Utils.getOS() == 6) {
                String vmsScriptName = Globals.g_tempLocation + File.separator + "runit.com";
                cmdThread = new ExecuteCommandThread(vmsScriptName);
                File scriptFile = new File(vmsScriptName);
                PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
                out.println("$ set nover");
                out.println("$ set noon");
                out.println("$ set proc/parse=extend");
                String cmdprefix = cmdFile.indexOf(".com") == -1 ? "$ " : "$@ ";
                if (cmdThread.getParams() != null) {
                    out.println(cmdprefix + fullCmd + " " + cmdThread.getParams());
                } else {
                    out.println(cmdprefix + fullCmd);
                }
                out.close();
                Logging.log.info("Execute Command: " + KitAction.filterPasswordsFromLog(cmdThread.getCmd()));
                p = SASRuntimeWrapper.getRuntime().exec(Utils.unixToVMSPath(cmdThread.getCmd()));
            } else {
                cmdThread = new ExecuteCommandThread(fullCmd);
                Logging.log.info("Execute Command: " + KitAction.filterPasswordsFromLog(cmdThread.getCmd()));
                p = cmdThread.getParams() != null ? SASRuntimeWrapper.getRuntime().exec(cmdThread.getCmd(), cmdThread.getParams()) : SASRuntimeWrapper.getRuntime().exec(cmdThread.getCmd());
            }
            if (wait) {
                p.waitFor();
                returnCode = p.exitValue();
                Logging.log.info("Return Code: " + returnCode);
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String filterPasswordsFromLog(String cmd) {
        String newCmd = null;
        int argPos = cmd.indexOf(" \"AutoPwd:");
        if (argPos > 0) {
            newCmd = cmd.substring(0, argPos + 10) + "***";
            int lastQuotePos = cmd.indexOf("\"", argPos + 11);
            if (lastQuotePos > -1) {
                newCmd = newCmd + cmd.substring(lastQuotePos);
            }
        } else {
            newCmd = cmd;
        }
        return newCmd;
    }

    public static int executeProcess(String command, String script, String rcLog) throws IOException, InterruptedException {
        return KitAction.executeProcess(command, script, rcLog, null, null);
    }

    public static int executeProcess(String command, String script, String rcLog, ProcessBuilder pb) throws IOException, InterruptedException {
        return KitAction.executeProcess(command, script, rcLog, pb, null);
    }

    public static int executeProcess(String command, String script, String rcLog, String[] envp) throws IOException, InterruptedException {
        return KitAction.executeProcess(command, script, rcLog, null, envp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeProcess(String command, String script, String rcLog, ProcessBuilder pb, String[] envp) throws IOException, InterruptedException {
        int returnCode = -1;
        Process p = null;
        if (Utils.getOS() == 1) {
            p = pb != null ? pb.start() : (envp == null ? SASRuntimeWrapper.getRuntime().exec(command) : SASRuntimeWrapper.getRuntime().exec(command, envp));
            p.waitFor();
            returnCode = p.exitValue();
        } else {
            if (command.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            File scriptFile = new File(script);
            File rcFile = new File(rcLog);
            PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
            out.println("#!/bin/sh");
            out.println("if [ -x /usr/bin/echo ]; then ");
            out.println("  echo=/usr/bin/echo");
            out.println("elif [ -x /bin/echo ] ; then ");
            out.println("  echo=/bin/echo");
            out.println("fi");
            out.println("if [ -f \"" + rcFile.getAbsolutePath() + "\" ]; then ");
            out.println("  rm -f \"" + rcFile.getAbsolutePath() + "\"");
            out.println("fi");
            out.println(command);
            out.println("$echo $? >\"" + rcFile.getAbsolutePath() + "\"");
            out.close();
            try {
                FileMode file = new FileMode(scriptFile);
                file.setPerm(493);
                file.commit();
                String[] cmd = new String[]{"/bin/sh", "-c", script};
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
            }
            finally {
                if (scriptFile.isFile() && !Globals.g_debug) {
                    scriptFile.delete();
                }
                if (rcFile.isFile()) {
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(rcFile));
                        returnCode = Integer.parseInt(in.readLine());
                        in.close();
                        in = null;
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                    if (!Globals.g_debug) {
                        rcFile.delete();
                    }
                }
            }
        }
        return returnCode;
    }

    public static int launchPDFViewer(File targetFile) {
        if (Utils.getOS() == 8) {
            return 0;
        }
        if (Utils.getOS() == 1) {
            String data = null;
            String data1 = null;
            if (Globals.g_wizardData.getPreference("SavePDFViewer", false)) {
                data = Globals.g_wizardData.getPreference("PDFViewer", "");
            }
            if ((data == null || data.length() == 0 || data.equals("")) && (data = WinRegAPI.getWindowsRegistryValue(1, ".pdf", "")) != null && !data.equals("")) {
                data1 = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data, "CurVer"), "");
                if (data1 != null && !data1.equals("")) {
                    data = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data1, "shell\\open\\command"), "");
                    if (data == null || data.equals("")) {
                        data = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data1, "shell\\read\\command"), "");
                    }
                } else {
                    data1 = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data, "shell\\open\\command"), "");
                    if (data1 == null || data1.equals("")) {
                        data1 = WinRegAPI.getWindowsRegistryValue(1, Utils.joinPath(data, "shell\\read\\command"), "");
                    }
                    data = data1;
                }
            }
            if (data != null && !data.equals("")) {
                KitAction.execute(KitAction.buildCommandEx(data, targetFile.toString()), "", false);
                return 0;
            }
            return -3;
        }
        if (Utils.getOS() == 6) {
            String vmsPDFViewer = Globals.g_setupLocation + "/xpdf/xpdf.com";
            String command = vmsPDFViewer + " " + targetFile.toString();
            int status = KitAction.execute(command.trim(), "", false);
            status = 0;
            if (status == -1) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitAction.ErrorMessage.txt") + System.getProperty("line.separator") + command, bundle.getString("Common.Error.txt"), 0);
            }
            return status;
        }
        String unixPDFViewer = Globals.g_wizardData.getPreference("PDFViewer", "");
        if (!Globals.g_wizardData.getPreference("SavePDFViewer", false) || unixPDFViewer == null || unixPDFViewer.length() == 0) {
            for (int i = 0; i < pdfViewerName.length && (unixPDFViewer = KitAction.unixSearch(pdfViewerName[i])) == null; ++i) {
            }
            SelectProgramDialog programDialog = new SelectProgramDialog((Frame)Globals.g_wizard.getFrame(), 10, unixPDFViewer, true);
            if (programDialog.buttonClicked() == 1) {
                unixPDFViewer = programDialog.getPath();
                Globals.g_wizardData.setPreference("SavePDFViewer", programDialog.preservePath());
                Globals.g_wizardData.setPreference("PDFViewer", unixPDFViewer);
            } else {
                return 0;
            }
        }
        String command = unixPDFViewer + " " + targetFile.toString();
        int status = KitAction.execute(command.trim(), "", false);
        status = 0;
        if (status == -1) {
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitAction.ErrorMessage.txt") + System.getProperty("line.separator") + command, bundle.getString("Common.Error.txt"), 0);
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int launchWebBrowser(URL webPage) {
        int status = -1;
        if (webPage == null) return status;
        if (Utils.getOS() == 8) {
            return 0;
        }
        if (Utils.getOS() == 9) {
            try {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, webPage.toExternalForm());
                return 0;
            }
            catch (Exception e) {
                Logging.log.severe("Exception attempting to launch browser on mac.");
                Logging.logStackTrace(e);
            }
        }
        if (Utils.getOS() == 1) {
            String data = "rundll32 url.dll,FileProtocolHandler";
            return KitAction.execute(KitAction.buildCommand(data, webPage.toString()), "", false);
        }
        if (Utils.getOS() == 6) {
            String command;
            String vmsWebBrowser = new String(Globals.g_wizardData.getPreference("WebBrowser", ""));
            if (!Globals.g_wizardData.getPreference("SaveBrowser", false) || vmsWebBrowser == null || vmsWebBrowser.length() == 0) {
                vmsWebBrowser = "sys$common:[cswb]mozilla.com";
                SelectProgramDialog programDialog = new SelectProgramDialog((Frame)Globals.g_wizard.getFrame(), 11, vmsWebBrowser, true);
                if (programDialog.buttonClicked() != 1) return 0;
                vmsWebBrowser = programDialog.getPath();
                Globals.g_wizardData.setPreference("SaveBrowser", programDialog.preservePath());
                Globals.g_wizardData.setPreference("WebBrowser", vmsWebBrowser);
            }
            if ((status = KitAction.execute((command = Utils.unixToVMSPath(vmsWebBrowser) + " \"" + webPage.toString() + "\"").trim(), "", false)) != -1) return status;
            Globals.g_wizardData.setPreference("SaveBrowser", false);
            CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitAction.ErrorMessage.txt") + System.getProperty("line.separator") + command, bundle.getString("Common.Error.txt"), 0);
            return status;
        }
        Object unixWebBrowser = new String(Globals.g_wizardData.getPreference("WebBrowser", ""));
        if (!Globals.g_wizardData.getPreference("SaveBrowser", false) || unixWebBrowser == null || ((String)unixWebBrowser).length() == 0) {
            SelectProgramDialog programDialog;
            if (((String)unixWebBrowser).length() == 0) {
                unixWebBrowser = null;
            }
            for (int i = 0; i < browserName.length && unixWebBrowser == null; ++i) {
                unixWebBrowser = KitAction.unixSearch(browserName[i]);
            }
            if (unixWebBrowser != null) {
                Logging.log.info("Found web browser by searching pre-specified directories: " + (String)unixWebBrowser);
            } else {
                Logging.log.finer("No joy finding a web browser in the pre-specified directories");
            }
            if (unixWebBrowser == null) {
                String allBrowserNames = "";
                for (int count = 0; count < browserName.length; ++count) {
                    allBrowserNames = allBrowserNames + " " + browserName[count];
                }
                try {
                    RuntimeExecutor r = new RuntimeExecutor(10000L);
                    Object[] browserPaths = r.execute(new String[]{"/bin/sh", "-c", "paths=`echo $PATH | tr ':' ' '` ;eval \"for i in " + allBrowserNames + " ; do for j in $paths ; do if [ -x \\\"\\$j/\\$i\\\" -a ! -d \\\"\\$j/\\$i\\\" ] ; then echo \\\"\\$j/\\$i\\\"; fi; done; done\""});
                    Logging.log.finer("Full list of web browsers returned: " + Arrays.deepToString(browserPaths));
                    for (int i = 0; i < browserPaths.length; ++i) {
                        File checkBrowserPath = new File((String)browserPaths[i]);
                        if (checkBrowserPath == null || !checkBrowserPath.exists()) continue;
                        unixWebBrowser = browserPaths[i];
                        break;
                    }
                    if (unixWebBrowser != null) {
                        Logging.log.info("Found web browser by searching PATH: " + (String)unixWebBrowser);
                    } else {
                        Logging.log.finer("No joy finding a web browser in the PATH");
                    }
                }
                catch (Exception e) {
                    Logging.log.severe("Got a Runtime exception while trying to find browser by searching PATH with 'which': " + e.getMessage());
                    Logging.logStackTrace(e);
                }
            }
            if ((programDialog = new SelectProgramDialog((Frame)Globals.g_wizard.getFrame(), 11, (String)unixWebBrowser, true)).buttonClicked() != 1) return 0;
            unixWebBrowser = programDialog.getPath();
            Globals.g_wizardData.setPreference("SaveBrowser", programDialog.preservePath());
            Globals.g_wizardData.setPreference("WebBrowser", (String)unixWebBrowser);
        } else {
            Logging.log.info("Using web browser defined in preferences: " + (String)unixWebBrowser);
        }
        String command = (String)unixWebBrowser + " " + Utils.stringReplaceAll(webPage.toString(), " ", "%20");
        status = KitAction.execute(command.trim(), "", false);
        if (status != -1) return status;
        Globals.g_wizardData.setPreference("SaveBrowser", false);
        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), bundle.getString("KitAction.ErrorMessage.txt") + System.getProperty("line.separator") + command, bundle.getString("Common.Error.txt"), 0);
        return status;
    }

    private static String unixSearch(String program) {
        File test = new File(m_searchPath[0], program);
        int i = 1;
        while (i < m_searchPath.length && test != null && !test.exists()) {
            test = new File(m_searchPath[i++], program);
        }
        if (!test.exists()) {
            return null;
        }
        return test.toString();
    }

    private static String buildCommand(String appData, String doc) {
        if (appData.indexOf("%1", 0) < 0) {
            return appData + " " + doc;
        }
        return Utils.stringReplaceAll(appData, "%1", doc);
    }

    private static String buildCommandEx(String appData, String doc) {
        String[] temp_str = appData.split("\"%1\"");
        String temp = "";
        for (int i = 0; i < temp_str.length; ++i) {
            temp = temp.concat(temp_str[i]);
            temp = temp.concat("\"");
            temp = temp.concat(doc);
            temp = temp.concat("\"");
        }
        return temp;
    }

    public static String argumentSubstitution(String inText, String lang) {
        String linkText = inText;
        String subText = "";
        if (linkText.indexOf("%22") > -1) {
            subText = "\"";
            linkText = Utils.stringReplaceAll(linkText, "%22", subText);
        }
        if (linkText.indexOf("!ORDERNUMBER") > -1) {
            subText = Globals.g_order == null ? "" : Globals.g_order;
            linkText = Utils.stringReplaceAll(linkText, "!ORDERNUMBER", subText);
        }
        if (linkText.indexOf("!ORDERDATADIR") > -1) {
            subText = Globals.g_deploymentData == null ? "" : Utils.joinPath(Globals.g_deploymentData.getOrderDir(), Globals.g_order);
            linkText = Utils.stringReplaceAll(linkText, "!ORDERDATADIR", subText);
        }
        if (linkText.indexOf("!PLAN") > -1) {
            subText = Globals.g_plan == null ? "false" : "true";
            linkText = Utils.stringReplaceAll(linkText, "!PLAN", subText);
        }
        if (linkText.indexOf("!NOTPLAN") > -1) {
            subText = Globals.g_plan == null ? "true" : "false";
            linkText = Utils.stringReplaceAll(linkText, "!NOTPLAN", subText);
        }
        if (linkText.indexOf("!MACHINE") > -1) {
            subText = Globals.g_machine == null || Globals.g_machine.getName() == null ? "" : Globals.g_machine.getName();
            linkText = Utils.stringReplaceAll(linkText, "!MACHINE", subText);
        }
        if (linkText.indexOf("!PROJDIR") > -1) {
            subText = Globals.g_plan == null ? "" : Globals.g_plan.getDirectory();
            linkText = Utils.stringReplaceAll(linkText, "!PROJDIR", subText);
        }
        if (linkText.indexOf("!VMDIR") > -1) {
            String jre = System.getProperty("java.home");
            String jcmd = Utils.joinPath(jre, "bin", "java");
            subText = jcmd == null ? "" : jcmd;
            linkText = Utils.stringReplaceAll(linkText, "!VMDIR", subText);
        }
        if (linkText.indexOf("!ISPROLANG") > -1) {
            subText = lang.equals("cs") ? "-l0005" : (lang.equals("da") ? "-l0006" : (lang.equals("de") ? "-l0007" : (lang.equals("el") ? "-l0008" : (lang.equals("en") ? "-l0009" : (lang.equals("em") ? "-l000a" : (lang.equals("es") ? "-l000a" : (lang.equals("fi") ? "-l000b" : (lang.equals("hu") ? "-l000e" : (lang.equals("it") ? "-l0010" : (lang.equals("ja") ? "-l0011" : (lang.equals("ko") ? "-l0012" : (lang.equals("nl") ? "-l0013" : (lang.equals("no") ? "-l0014" : (lang.equals("pl") ? "-l0015" : (lang.equals("ru") ? "-l0019" : (lang.equals("sk") ? "-l001b" : (lang.equals("sv") ? "-l001d" : (lang.equals("th") ? "-l001e" : (lang.equals("tr") ? "-l001f" : (lang.equals("sl") ? "-l0024" : (lang.equals("zt") ? "-l0404" : (lang.equals("fr") ? "-l040c" : (lang.equals("zh") ? "-l0804" : (lang.equals("pt") ? "-l0816" : (lang.equals("fc") ? "-l0c0c" : "")))))))))))))))))))))))));
            linkText = Utils.stringReplaceAll(linkText, "!ISPROLANG", subText);
        }
        if (linkText.indexOf("!ISDEVLANG") > -1) {
            subText = lang.equals("ar") ? "-l1025" : (lang.equals("cs") ? "-l1029" : (lang.equals("da") ? "-l1030" : (lang.equals("de") ? "-l1031" : (lang.equals("el") ? "-l1032" : (lang.equals("en") ? "-l1033" : (lang.equals("em") ? "-l1034" : (lang.equals("es") ? "-l1034" : (lang.equals("fi") ? "-l1035" : (lang.equals("hu") ? "-l1038" : (lang.equals("it") ? "-l1040" : (lang.equals("iw") ? "-l1037" : (lang.equals("ja") ? "-l1041" : (lang.equals("ko") ? "-l1042" : (lang.equals("nl") ? "-l1043" : (lang.equals("no") ? "-l1044" : (lang.equals("pl") ? "-l1045" : (lang.equals("ru") ? "-l1049" : (lang.equals("sk") ? "-l1051" : (lang.equals("sv") ? "-l1053" : (lang.equals("th") ? "-l1054" : (lang.equals("tr") ? "-l1055" : (lang.equals("sl") ? "-l1060" : (lang.equals("zt") ? "-l1028" : (lang.equals("fr") ? "-l1036" : (lang.equals("zh") ? "-l2052" : (lang.equals("pt") ? "-l2070" : (lang.equals("fc") ? "-l3084" : "")))))))))))))))))))))))))));
            linkText = Utils.stringReplaceAll(linkText, "!ISDEVLANG", subText);
        }
        if (linkText.indexOf("!SID") > -1) {
            subText = Globals.g_sid.getFormattedSIDFile().getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SID", subText);
        }
        if (linkText.indexOf("!JMPSID") > -1) {
            subText = Globals.g_jmpSID.getSIDFile().getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!JMPSID", subText);
        }
        if (linkText.indexOf("!SPDSSID") > -1) {
            subText = Globals.g_spdsSID.getSIDFile().getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SPDSSID", subText);
        }
        if (linkText.indexOf("!DEPLOYMNTREG") > -1) {
            subText = RegistryData.getDeployRegJar();
            if (subText == null) {
                subText = "";
            }
            linkText = Utils.stringReplaceAll(linkText, "!DEPLOYMNTREG", subText);
        }
        if (linkText.indexOf("!JREHOME") > -1) {
            linkText = Globals.g_jreHome != null ? Utils.stringReplaceAll(linkText, "!JREHOME", Globals.g_jreHome) : Utils.stringReplaceAll(linkText, "!JREHOME", "");
        }
        if (linkText.indexOf("!MEDIAROOT") > -1) {
            linkText = Utils.stringReplaceAll(linkText, "!MEDIAROOT", Globals.g_currentDiskLocation);
        }
        if (linkText.indexOf("!SSNEXE") > -1) {
            subText = Utils.joinPath(Globals.g_startupLocation, "setup.exe");
            linkText = Utils.stringReplaceAll(linkText, "!SSNEXE", subText);
        }
        if (linkText.indexOf("!SSNKEY") > -1) {
            ProductData product = Globals.g_deploymentData.getProduct(Globals.g_order, "sdwstartup", false);
            subText = new File(Globals.g_startupLocation, Globals.g_deploymentData.getVolser(product.getMediaCode()).getDataPath(product.getSpsSku()) + "/product.xml").getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SSNKEY", subText);
        }
        if (linkText.indexOf("!SSNLABEL") > -1) {
            subText = "SAS Deployment Wizard";
            linkText = Utils.stringReplaceAll(linkText, "!SSNLABEL", subText);
        }
        if (linkText.indexOf("!CMDLINEFILE") > -1) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            int count = 0;
            File newFile = new File(tempDir, "cmdfile" + Integer.toString(count) + ".tmp");
            for (int i = 0; i < 999 && newFile.exists(); ++i) {
                newFile = new File(tempDir, "cmdfile" + Integer.toString(++count) + ".tmp");
            }
            if (!newFile.exists()) {
                try {
                    PropsParser cmdFile = new PropsParser(true);
                    cmdFile.setINIValue("Options", "LaunchCmdLine", Globals.g_commandLine);
                    cmdFile.save(newFile.toString(), true);
                }
                catch (Exception e) {
                    Logging.log.warning("Could not create command line file for the System Requirements Wizard:" + newFile.getAbsolutePath());
                }
                if (newFile.exists()) {
                    linkText = Utils.stringReplaceAll(linkText, "!CMDLINEFILE", newFile.getAbsolutePath());
                }
            }
            linkText = Utils.stringReplaceAll(linkText, "!CMDLINEFILE", "");
        }
        if (linkText.indexOf("!SASHOME") > -1) {
            subText = Globals.g_wizardData.getPreference("SASHome", "");
            linkText = Utils.stringReplaceAll(linkText, "!SASHOME", subText);
        }
        if (linkText.indexOf("!CONFIGWIZ_SASHOME") > -1) {
            subText = Globals.g_wizardData.getPreference("SASHome", "");
            subText = Utils.stringReplaceAll(subText, "\\", "\\\\");
            linkText = Utils.stringReplaceAll(linkText, "!CONFIGWIZ_SASHOME", subText);
        }
        if (linkText.indexOf("!WINSYSDRIVE") > -1) {
            if (Utils.getOS() == 1) {
                subText = Globals.g_windowsSystemDrive;
                if (subText == null) {
                    subText = "";
                }
                linkText = Utils.stringReplaceAll(linkText, "!WINSYSDRIVE", subText);
            } else {
                linkText = Utils.stringReplaceAll(linkText, "!WINSYSDRIVE", "");
            }
        }
        if (linkText.indexOf("!SAWTARGET") > -1) {
            ProductData sasData = null;
            sasData = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", Globals.g_sasinstallPlat, false) : Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false);
            subText = new File(Globals.g_ssdDestDir, Globals.g_deploymentData.getVolser(sasData.getMediaCode()).getProductPath(sasData.getSpsSku())).getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SAWTARGET", subText);
        }
        if (linkText.indexOf("!SAWTYPE") > -1) {
            subText = Globals.g_ssdType == 1 ? "client" : "personal";
            linkText = Utils.stringReplaceAll(linkText, "!SAWTYPE", subText);
        }
        if (linkText.indexOf("!SAWFILTER") > -1) {
            subText = new File(Globals.g_tempLocation, "sawfilter.txt").getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SAWFILTER", subText);
        }
        if (linkText.indexOf("!SAWINSTALL") > -1) {
            subText = new File(Globals.g_tempLocation, "sawinstall.txt").getAbsolutePath();
            linkText = Utils.stringReplaceAll(linkText, "!SAWINSTALL", subText);
        }
        if (linkText.indexOf("!JRESILENTFILE_W64") > -1) {
            subText = KitAction.getW64JRESilentFile();
            linkText = Utils.stringReplaceAll(linkText, "!JRESILENTFILE_W64", subText);
        }
        if (linkText.indexOf("!LOCALE2BYTES") > -1) {
            subText = Utils.localeTwoLangCode(Locale.getDefault());
            linkText = Utils.stringReplaceAll(linkText, "!LOCALE2BYTES", subText);
        }
        if (linkText.indexOf("!SASALTSKU") > -1) {
            subText = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", Globals.g_sasinstallPlat, false).getSpsSku() : Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false).getSpsSku();
            linkText = Utils.stringReplaceAll(linkText, "!SASALTSKU", subText);
        }
        if (linkText.indexOf("!SDWTEMPDIR") > -1) {
            subText = Globals.g_tempLocation;
            linkText = Utils.stringReplaceAll(linkText, "!SDWTEMPDIR", subText);
        }
        if (linkText.indexOf("!LANGLIST") > -1) {
            subText = Globals.g_selectedLanguages;
            if (Utils.getOS() != 1) {
                subText = Utils.stringReplaceAll(Globals.g_selectedLanguages, ",", " ");
            }
            linkText = Utils.stringReplaceAll(linkText, "!LANGLIST", subText);
        }
        if (linkText.indexOf("!CMPLIST") > -1) {
            subText = Globals.g_selectedMVAProdsCmdOp;
            linkText = Utils.stringReplaceAll(linkText, "!CMPLIST", subText);
        }
        if (linkText.indexOf("!NOREBOOT") > -1) {
            subText = Globals.g_noreboot ? "-noreboot" : "";
            linkText = Utils.stringReplaceAll(linkText, "!NOREBOOT", subText);
        }
        int argPos = linkText.indexOf("!INSTALLPROP(");
        int namePos = 0;
        String name = null;
        while (argPos > -1) {
            namePos = argPos + "!INSTALLPROP(".length();
            name = linkText.substring(namePos, linkText.indexOf(")", namePos));
            subText = Globals.g_installData != null ? Globals.g_installData.getProperty(name, "") : "";
            if (name.equalsIgnoreCase("msofficeint.office.excel") && subText.length() == 0) {
                subText = "true";
            } else if (name.equalsIgnoreCase("msofficeint.office.word") && subText.length() == 0) {
                subText = KitAction.orderContainsProdCode("BIWEBPTSMSSP") ? "true" : "false";
            } else if (name.equalsIgnoreCase("msofficeint.office.powerpoint") && subText.length() == 0) {
                subText = KitAction.orderContainsProdCode("BIWEBPTSMSSP") ? "true" : "false";
            } else if (name.equalsIgnoreCase("msofficeint.office.outlook") && subText.length() == 0) {
                subText = "false";
            } else if (name.equalsIgnoreCase("msofficeint.is_lite") && subText.length() == 0) {
                subText = KitAction.orderContainsProdCode("BIWEBPTSMSSP") ? "false" : "true";
            }
            linkText = Utils.stringReplaceAll(linkText, "!INSTALLPROP(" + name + ")", subText);
            argPos = linkText.indexOf("!INSTALLPROP(", argPos + 1);
        }
        return linkText;
    }

    private static boolean orderContainsProdCode(String prodCode) {
        boolean contains = false;
        if (Globals.g_deploymentData != null && Globals.g_order != null) {
            ProductData[] allProducts = Globals.g_deploymentData.getAllProducts(Globals.g_order, false);
            for (int i = 0; i < allProducts.length && !contains; ++i) {
                if (!allProducts[i].getProdCode().equalsIgnoreCase(prodCode)) continue;
                contains = true;
            }
        }
        return contains;
    }

    private static String getW64JRESilentFile() {
        String silentJREFile = Utils.joinPath(Globals.g_tempLocation, "silentjre_w64.xml");
        try {
            File silentFile = new File(silentJREFile);
            if (!silentFile.exists()) {
                PrintStream out = new PrintStream(new FileOutputStream(silentFile));
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                out.println("<domain-template-descriptor>");
                out.println("   <input-fields>");
                out.println("      <data-value name=\"USER_INSTALL_DIR\" value=\"" + Globals.g_jreHome + "\" />");
                out.println("   </input-fields>");
                out.println("</domain-template-descriptor>");
                out.close();
                Logging.log.fine("Silent JRE response file created: " + silentJREFile);
            } else if (!silentFile.isFile()) {
                Logging.log.severe("Error creating silent JRE response file: " + silentJREFile);
                silentJREFile = "";
            }
        }
        catch (Exception e) {
            Logging.log.severe("Error creating silent JRE response file: " + silentJREFile);
            silentJREFile = "";
        }
        return silentJREFile;
    }

    private static void readStream(InputStream s) {
        byte[] data = new byte[2048];
        String blah = null;
        try {
            int bytesread;
            boolean i = false;
            while ((bytesread = s.read(data)) > 0) {
                blah = new String(data, 0, bytesread);
                System.err.print(blah);
            }
        }
        catch (IOException ioe) {
            Logging.logStackTrace(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createDataFluxValues(ProductData prodData) {
        File valueFile = null;
        if (prodData != null) {
            try (PrintStream stream = null;){
                valueFile = File.createTempFile("dfvalue", ".properties", new File(Globals.g_tempLocation));
                stream = new PrintStream((OutputStream)new FileOutputStream(valueFile), false, "UTF-8");
                stream.println("SILENT_SAS_INSTALL=Y");
                stream.println("SILENT_SAS_REG_VERSION=" + prodData.getProdVersion());
                stream.println("SILENT_SAS_REG_MAINT_NAME=" + prodData.getProdCustVersion());
                stream.println("SILENT_SAS_REG_MAINT_LEVEL=" + prodData.getProdMaint());
                stream.println("SILENT_SAS_DEPLOYMENT_REG=" + RegistryData.getDeployRegJar());
                stream.println("SILENT_SAS_JAVA_PATH=" + (Globals.g_jreHome == null ? "" : Globals.g_jreHome));
                stream.println("SILENT_SAS_12BYTE=" + prodData.getProdCode());
                stream.println("SILENT_SAS_FAMILY_RELEASE=" + prodData.getProdSASRelease());
                stream.checkError();
            }
        }
        return valueFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createPropertiesFileForProduct(String prodName) {
        String propsFileString = "";
        File propsFile = null;
        if (prodName != null && prodName.length() >= 1) {
            try (PrintStream stream = null;){
                String valueFileName = prodName + ".properties";
                String valueFileDirName = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc", prodName);
                File valueFileDir = new File(valueFileDirName);
                if (!valueFileDir.exists()) {
                    valueFileDir.mkdirs();
                }
                propsFile = new File(valueFileDirName, valueFileName);
                stream = new PrintStream((OutputStream)new FileOutputStream(propsFile), false, "UTF-8");
                Enumeration<Object> e = Globals.g_installData.getProperties().keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(prodName)) continue;
                    if (key.equalsIgnoreCase("mominstall.products.sidlocation")) {
                        String val = Globals.g_installData.getProperty(key, null);
                        if (val == null) continue;
                        File file = new File(val);
                        val = file.getName();
                        val = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "licenses", val);
                        stream.println(key + "=" + val);
                        continue;
                    }
                    if (key.equalsIgnoreCase("mominstall.userinfo.localsystempw") && key.equalsIgnoreCase("mominstall.userinfo.domainuserpw")) continue;
                    String value = Globals.g_installData.getProperty(key, null);
                    if (value.equalsIgnoreCase("true")) {
                        value = "yes";
                    } else if (value.equalsIgnoreCase("false")) {
                        value = "no";
                    }
                    stream.println(key + "=" + value);
                }
                stream.println("mominstall.products.sashome=" + Globals.g_wizardData.getPreference("SASHome", ""));
                stream.checkError();
            }
        }
        if (propsFile != null) {
            return propsFile.getAbsolutePath();
        }
        return propsFileString;
    }
}

