/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class JREData {
    private static String privateJre = null;
    private static String platform = null;
    private static String[] installVersions = null;
    private static String installedPath = null;
    private static boolean isprivatejreNeeded = false;
    private static boolean installedJRE = false;
    public static boolean jreNeeded = false;
    public static boolean g_jrePrompted = false;
    public static boolean copyJREToSASHomeMVS = false;
    private static String jreSecurityDir;
    private static String jreSecurityBkupDir;
    private static boolean olderJreExists;
    private static String fontsBackupDir;

    static void setJREData(String host, boolean needed) {
        RegistryAccess registryAccess = null;
        JREData.setJREData(host, needed, registryAccess);
    }

    static void setJREData(String host, boolean needed, RegistryAccess registryAccess) {
        platform = host == null ? Utils.getOS_Suffix() : host;
        String path = null;
        if (needed) {
            JREData.prevInstalledPrivateJRE(registryAccess);
            path = JREData.getInstalledJREpath(platform, registryAccess);
        }
        if (path == null) {
            installedJRE = false;
            privateJre = JREData.setPrivateJreDest();
            isprivatejreNeeded = needed;
        } else {
            installedJRE = true;
            privateJre = path;
            isprivatejreNeeded = JREData.isJRENewer(registryAccess);
        }
        jreSecurityDir = Utils.joinPath(privateJre, "jre/lib/security");
        String sashome = Globals.g_wizardData.getPreference("SASHome", "");
        String date = JREData.getDate();
        String datedDirectory = String.format("InstallMisc/JreSecurity/backup-%s", date);
        jreSecurityBkupDir = Utils.joinPath(sashome, datedDirectory);
        olderJreExists = JREData.doesOlderJreExist();
        String FontsDatedDirectory = String.format("InstallMisc/jreFonts/backup-%s", date);
        fontsBackupDir = Utils.joinPath(sashome, FontsDatedDirectory);
    }

    private static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    static void setPrivarejreNeeded(boolean flag) {
        isprivatejreNeeded = flag;
        Logging.log.fine("setPrivarejreNeeded isprivatejreNeeded=" + isprivatejreNeeded);
    }

    static boolean isPrivateJreNeeded() {
        Logging.log.fine(" isprivatejreNeeded=" + isprivatejreNeeded);
        return isprivatejreNeeded;
    }

    static boolean isJREInstalled() {
        Logging.log.fine(" isprivatejreInstalled=" + installedJRE);
        return installedJRE;
    }

    static String getPlatform() {
        return platform;
    }

    static String getPrivateJREDest() {
        return privateJre;
    }

    static void setPrivateJREDest(String path) {
        privateJre = path;
    }

    static String getPrivateJREHOME() {
        return Utils.joinPath(privateJre, "jre");
    }

    private static String setPrivateJreDest() {
        String dest;
        if (Utils.getOS() == 8 || Utils.getOS() == 10) {
            dest = null;
        } else {
            ProductData jData = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", platform, false);
            if (jData != null) {
                dest = platform.equalsIgnoreCase("win") && Utils.getOS_Suffix().equalsIgnoreCase("wx6") ? Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "x86") : Globals.g_wizardData.getPreference("SASHome", "");
                if (dest != null) {
                    dest = Utils.joinPath(dest, jData.getProdName().replaceAll(" ", ""), Globals.g_majorReleaseVersion);
                }
            } else {
                dest = null;
            }
        }
        Logging.log.fine("dest=" + dest);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledJREpath(String host, RegistryAccess registryAccess) {
        if (installedPath != null) {
            return installedPath;
        }
        ProductData jreData = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", host, false);
        if (installVersions != null && installVersions.length > 0) {
            if (registryAccess != null) {
                installedPath = registryAccess.getInstallLoc(jreData.getProdCode(), installVersions[0], host);
                return installedPath;
            }
            try (RegistryAccess registryAccessLocal = null;){
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccessLocal = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccessLocal.open()) {
                    String string = installedPath = registryAccessLocal.getInstallLoc(jreData.getProdCode(), installVersions[0], host);
                    return string;
                }
            }
        }
        return null;
    }

    static String getPrivateJavaCommand() {
        if (isprivatejreNeeded) {
            return JREData.getJavaCommand("privatejre");
        }
        return null;
    }

    private static void prevInstalledPrivateJRE(RegistryAccess registryAccess) {
        if (installVersions == null) {
            if (registryAccess != null) {
                installVersions = registryAccess.getInstallVersions("privatejre", platform);
            } else {
                try (RegistryAccess registryAccessLocal = null;){
                    RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                    registryAccessLocal = new RegistryAccess(RegistryData.getDeployRegJar());
                    if (registryAccessLocal.open()) {
                        installVersions = registryAccessLocal.getInstallVersions("privatejre", platform);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameInstalledPrivateJRE() {
        boolean value = true;
        if (installVersions != null && installVersions.length != 0) {
            try (RegistryAccess registryAccess = null;){
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (registryAccess.open()) {
                    for (int i = 0; i < installVersions.length; ++i) {
                        String installdir = registryAccess.getInstallLoc("privatejre", installVersions[i], platform);
                        String tempdir = installdir + ".delete";
                        if (installdir == null || installdir.length() <= 0) continue;
                        File jrepath = new File(installdir);
                        File tmpfile = new File(tempdir);
                        if (!jrepath.isDirectory() || (value = Utils.rename(jrepath, tmpfile))) continue;
                        Logging.log.severe("Unable to rename the Private JRE. It might be in use by a Windows service if this is Windows.");
                    }
                }
            }
        }
        return value;
    }

    private static boolean doesOlderJreExist() {
        ProductData jData = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", platform, false);
        if (jData == null) {
            return false;
        }
        String jreVersionToDeploy = jData.getProdVersion();
        if (installVersions != null && installVersions.length > 0) {
            for (String version : installVersions) {
                int result = jreVersionToDeploy.compareTo(version);
                if (result <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void backupJRESecurityFiles() {
        if (!olderJreExists) {
            return;
        }
        boolean result = Utils.createDir(jreSecurityBkupDir);
        if (!result) {
            String msg = String.format("Unable to create backup directory for JRE security files: %s", jreSecurityBkupDir);
            Logging.log.warning(msg);
            return;
        }
        ArrayList<String> jreSecurityFiles = new ArrayList<String>(5);
        Logging.log.info("Temporarily backing up JRE security files.");
        jreSecurityFiles.add("jssecacerts");
        jreSecurityFiles.add("cacerts");
        jreSecurityFiles.add("local_policy.jar");
        jreSecurityFiles.add("US_export_policy.jar");
        JREData.copyJreFiles(jreSecurityDir, jreSecurityBkupDir, jreSecurityFiles);
    }

    private static void copyJreFiles(String source, String destination, List<String> files) {
        for (String file : files) {
            JREData.copyJreFile(source, destination, file);
        }
    }

    private static void copyJreFile(String source, String destination, String fileName) {
        File sourceFile = new File(source, fileName);
        if (!sourceFile.exists()) {
            String msg = String.format("JRE file %s does not exist, skipping.", sourceFile.getAbsolutePath());
            Logging.log.info(msg);
            return;
        }
        File destinationFile = new File(destination, fileName);
        int returnCode = Utils.copyFile(sourceFile, destinationFile);
        if (returnCode != 0) {
            String msg = String.format("Unable to copy JRE file %s to %s, return code: %d", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath(), returnCode);
            Logging.log.warning(msg);
            return;
        }
        String msg = String.format("JRE file copied from %s to %s", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
        Logging.log.info(msg);
    }

    public static void restoreJRESecurityFiles() {
        File dir = new File(jreSecurityBkupDir);
        if (!dir.isDirectory()) {
            return;
        }
        ArrayList<String> jreSecurityFiles = new ArrayList<String>(5);
        Logging.log.info("Restoring security files from previous JRE to updated JRE.");
        jreSecurityFiles.add("jssecacerts");
        jreSecurityFiles.add("local_policy.jar");
        jreSecurityFiles.add("US_export_policy.jar");
        JREData.copyJreFiles(jreSecurityBkupDir, jreSecurityDir, jreSecurityFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeInstalledPrivateJRE() {
        boolean value = true;
        if (installVersions != null && installVersions.length != 0) {
            try (RegistryAccess registryAccess = null;){
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                String curVersion = Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", platform, false).getProdVersion();
                if (registryAccess.open()) {
                    for (int i = 0; i < installVersions.length; ++i) {
                        File jrepath;
                        String installdir = registryAccess.getInstallLoc("privatejre", installVersions[i], platform);
                        if ((installdir = installdir + ".delete") != null && installdir.length() > 0 && (jrepath = new File(installdir)).isDirectory()) {
                            Utils.deleteFolder(jrepath);
                        }
                        if (installVersions[i].equalsIgnoreCase(curVersion)) continue;
                        registryAccess.removeInstall("privatejre", installVersions[i], platform);
                    }
                }
            }
        }
        return value;
    }

    public static boolean isJRENewer() {
        RegistryAccess registryAccess = null;
        return JREData.isJRENewer(registryAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJRENewer(RegistryAccess registryAccess) {
        boolean rc = false;
        boolean isLocalRegistryAccess = false;
        if (registryAccess == null) {
            isLocalRegistryAccess = true;
        }
        ProductData jreData = platform == null ? Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", Utils.getOS_Suffix(), false) : Globals.g_deploymentData.getProduct(Globals.g_order, "privatejre", platform, false);
        RegistryAccess registryAccessLocal = null;
        if (isLocalRegistryAccess) {
            RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
            try {
                registryAccessLocal = new RegistryAccess(RegistryData.getDeployRegJar());
            }
            catch (Exception e) {
                return true;
            }
        } else {
            registryAccessLocal = registryAccess;
        }
        if (registryAccessLocal != null) {
            try {
                if (isLocalRegistryAccess && !registryAccessLocal.open()) {
                    boolean e = true;
                    return e;
                }
                String portDate1 = jreData.getLastPortDate();
                String portDate2 = registryAccessLocal.getInstallLastPortDate(jreData.getProdCode(), jreData.getProdVersion(), platform);
                if (portDate1 != null || portDate2 != null) {
                    long time1 = 0L;
                    long time2 = 0L;
                    if (portDate1 != null && portDate1.length() == 9) {
                        time1 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate1, new ParsePosition(0)).getTime();
                    }
                    if (portDate2 != null && portDate2.length() == 9) {
                        time2 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate2, new ParsePosition(0)).getTime();
                    }
                    if (time1 > time2) {
                        rc = true;
                    }
                }
            }
            catch (Exception e) {
                rc = true;
            }
            finally {
                if (registryAccessLocal != null && isLocalRegistryAccess) {
                    registryAccessLocal.close();
                }
            }
        }
        return rc;
    }

    static String getJavaCommand(String prodCode) {
        String javaRoot = prodCode.equalsIgnoreCase("privatejre") ? (Utils.getOS_Suffix() == "mvs" ? Globals.g_jreHome : Utils.joinPath(privateJre, "jre")) : (prodCode.equalsIgnoreCase("javaruntime") ? Globals.g_jreHome : null);
        if (javaRoot == null && Utils.getOS() == 8) {
            javaRoot = System.getProperty("java.home");
        }
        Logging.log.info("JavajavaRoot = " + javaRoot);
        return Utils.buildJavaCommand(javaRoot);
    }

    public static void backupTTFontsVert() {
        File[] srcFiles;
        if (!olderJreExists) {
            return;
        }
        if (TaskHelper.isWindows() || Utils.getOS() == 8 || Utils.getOS() == 10) {
            return;
        }
        boolean result = Utils.createDir(fontsBackupDir);
        if (!result) {
            String msg = String.format("Unable to create backup directory for ttfonts files: %s", fontsBackupDir);
            Logging.log.warning(msg);
            return;
        }
        String fontsSrcDir = Utils.joinPath(privateJre, "jre/lib/fonts");
        File srcDir = new File(fontsSrcDir);
        for (File fileName : srcFiles = srcDir.listFiles()) {
            if (fileName.getName().startsWith("Lucida")) continue;
            JREData.copyJreFile(fontsSrcDir, fontsBackupDir, fileName.getName());
        }
    }

    public static void restoreJREFontsFiles() {
        File[] srcFiles;
        File fontsSrcDir = new File(fontsBackupDir);
        if (!fontsSrcDir.isDirectory()) {
            return;
        }
        String fontsDestDir = Utils.joinPath(privateJre, "jre/lib/fonts");
        for (File fileName : srcFiles = fontsSrcDir.listFiles()) {
            JREData.copyJreFile(fontsBackupDir, fontsDestDir, fileName.getName());
        }
        Utils.deleteFolder(fontsSrcDir);
    }
}

