/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DefaultFileTypeAssociations;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.AuditLogger;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.DeploymentPackage;
import com.sas.tools.installs.it.DeploymentParameters;
import com.sas.tools.installs.it.PreExecuteRunnable;
import com.sas.tools.installs.it.PreExecuteThreadPool;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;

public class InstallToolConnector {
    protected static Controller itController;
    protected Vector<PreExecuteRunnable> preExecuteRunnables = new Vector();
    protected ExecutorService threadPool = null;
    private static boolean postProcessingCalled;
    private static boolean postProcessingSuccessful;
    private static String sHome_Base;
    private static SSNResource bundle;
    private static DeploymentParameters packageCollection;
    protected static InstallToolConnector connector;

    public static void clearITController() {
        itController = null;
    }

    public static void resetITMvsextractTask() {
        itController.resetMvsextractTask();
    }

    public static void stopITLogManagerandCopyLogFile() {
        if (itController != null) {
            itController.copyITLogFileToSDWPath();
        }
    }

    public static Controller itController() {
        if (itController == null) {
            try {
                packageCollection = new DeploymentParameters();
                itController = new Controller(packageCollection);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        if (itController != null) {
            if (Globals.g_recordMode && Globals.g_recordOnly || Globals.g_srwOnly) {
                itController.setLogPath(new File(Utils.getSDWDataPath(false)));
            } else {
                itController.setLogPath(new File(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc/InstallLogs"));
            }
        }
        return itController;
    }

    public static InstallToolConnector getConnector() {
        if (connector == null) {
            try {
                connector = new InstallToolConnector();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                Logging.log.severe("Error inititializing the InstallTooling");
            }
        }
        return connector;
    }

    public static int getProcessedFileCountForInstall(String altSku) {
        int retval = 0;
        Vector<InstallationTask> tasks = InstallToolConnector.itController().getInstallTasksPerAltSku().get(altSku);
        if (tasks == null) {
            return retval;
        }
        for (InstallationTask task : tasks) {
            retval += task.getFileCount();
        }
        return retval;
    }

    public static void primeInstallTool(String installXML, ProductData productData) throws Exception {
        InstallToolConnector.primeInstallTool(installXML, productData, false);
    }

    public static void primeInstallTool(String installXML, ProductData productData, boolean forceInitialization) throws Exception {
        String targetProp;
        String jreDest;
        File installXMLFile = new File(installXML);
        File productXMLFile = null;
        if (Globals.g_cmtTask == 28) {
            productXMLFile = new File(Globals.g_deploymentData.getSpsSkuDataDir(productData.getOrder(), productData.getSpsSku(), forceInitialization), "product.xml");
            if (!productXMLFile.exists()) {
                Logging.log.info("productXMLFile was not found using the order, so try using product.xml associated with " + productData.getInteractiveRef());
                File hfFile = new File(productData.getInteractiveRef());
                hfFile = new File(hfFile.getParent(), "product.xml");
                if (hfFile.exists()) {
                    productXMLFile = hfFile;
                } else {
                    Logging.log.severe("Product file was not found: " + productXMLFile.getPath() + " not found." + hfFile.getPath() + "not found");
                }
            }
        } else {
            productXMLFile = productData.getType() == 4 ? new File(((HotFix)productData).getHotFixSkuDataDir(), "product.xml") : (Globals.g_cmtTask == 10 ? new File(installXMLFile.getParent(), "product.xml") : (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40 ? new File(Utils.joinPath(Globals.g_deploywizDepotLocation, "product_data", productData.getSpsSku()), "product.xml") : new File(Globals.g_deploymentData.getSpsSkuDataDir(Globals.g_order, productData.getSpsSku(), forceInitialization), "product.xml")));
        }
        if (!forceInitialization && InstallToolConnector.itController().getAllInstallAltskus().contains(productData.getSpsSku())) {
            Vector<String> altSkus = new Vector<String>();
            altSkus.add(productData.getSpsSku());
            InstallToolConnector.itController().setAltSkus(altSkus);
            InstallToolConnector.itController().setInstallFile(installXMLFile);
            InstallToolConnector.itController().setAltSku(productData.getSpsSku());
            if (productData.getType() == 4) {
                InstallToolConnector.itController().getCurrentContext().setPayloadDir(new File(((HotFix)productData).getHotFixSkuPayloadDir()));
            } else if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
                InstallToolConnector.itController().getCurrentContext().setPayloadDir(new File(Utils.joinPath(Globals.g_deploywizDepotLocation, "product", productData.getSpsSku())));
            } else if (Globals.g_cmtTask != 28 && Globals.g_cmtTask != 43 && Globals.g_cmtTask != 46 && Globals.g_cmtTask != 47) {
                InstallToolConnector.itController().getCurrentContext().setPayloadDir(new File(Globals.g_deploymentData.getSpsSkuProductDir(Globals.g_order, productData.getSpsSku(), false)));
            }
            return;
        }
        if (sHome_Base == null && !Globals.g_baseSelected && (sHome_Base = InstallToolConnector.getHome_Base()) != null) {
            DeploymentPackage base = new DeploymentPackage("base");
            base.setDestination(sHome_Base);
            packageCollection.addPackage("base", base);
        }
        if ((jreDest = JREData.getPrivateJREDest()) != null && !jreDest.equals("")) {
            DeploymentPackage privatejre = new DeploymentPackage("privatejre");
            privatejre.setDestination(jreDest);
            packageCollection.addPackage("privatejre", privatejre);
        }
        if (Globals.g_vjrHome == null || !Globals.g_vjrHome.equals(Utils.getVJRHome(Globals.g_wizardData.getPreference("SASHome", "")))) {
            Globals.g_vjrHome = Utils.getVJRHome(Globals.g_wizardData.getPreference("SASHome", ""));
        }
        if (Globals.g_sid != null) {
            Globals.g_sid.writeFormattedSIDFile(Globals.g_tempLocation);
        }
        Vector<String> args = new Vector<String>(Arrays.asList("-skipversioncheck", "-skiplanguagecheck", "-file", installXML, "-productData", productXMLFile.getAbsolutePath(), "-platform", productData.getPlatform(), "-sashome", Globals.g_wizardData.getPreference("SASHome", "")));
        String sasHome32 = InstallToolConnector.getSASHome32(productData);
        if (sasHome32 != null) {
            DeploymentPackage pkg = new DeploymentPackage(productData.getProdCode());
            pkg.setAlternateSASHome(sasHome32);
            packageCollection.addPackage(productData.getSpsSku(), pkg);
        }
        if (Globals.g_majorReleaseVersion != null) {
            args.add("-release");
            args.add(Globals.g_majorReleaseVersion);
        }
        if (Globals.g_cmtTask == 11 && Globals.g_skipAdminCheck) {
            args.add("-skipusercheck");
        }
        if (Globals.g_alwaysOverWrite) {
            args.add("-alwaysoverwrite");
        }
        if (Globals.g_vjrHome != null) {
            args.add("-vjrhome");
            args.add(Globals.g_vjrHome);
        }
        if (Globals.g_sid != null && Globals.g_sid.getFormattedSIDFile() != null) {
            args.add("-sid");
            args.add(Globals.g_sid.getFormattedSIDFile().getAbsolutePath());
        }
        args.add("-silent");
        args.add("-view");
        args.add("com.sas.tools.installs.it.view.HeadlessView");
        if (Utils.getOS() == 1) {
            args.add("-scc");
            args.add(Globals.SHARED_COMP_CONSUMER_KEY);
        }
        String targetList = null;
        if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
            targetList = "postinstall";
        } else if (Globals.g_mode == 2) {
            if (Globals.g_cmtInstallTargets != null) {
                for (int i = 0; i < Globals.g_cmtInstallTargets.length; ++i) {
                    if (targetList != null) {
                        targetList = targetList + ",";
                        targetList = targetList + Globals.g_cmtInstallTargets[i];
                        continue;
                    }
                    targetList = Globals.g_cmtInstallTargets[i];
                }
            } else if (Globals.g_cmtTask == 28) {
                if (Globals.g_uninstallAll) {
                    targetList = "preuninstall,preinstall,uninstall,install,postinstall,postuninstall";
                } else if (Globals.g_installData != null) {
                    targetList = Globals.g_installData.getProperty("deploywiz.uninstall.target.list", null);
                }
            } else if (Globals.g_cmtTask == 11) {
                targetList = "preinstall,install,postinstall,config";
            }
        } else if (Globals.g_installData != null && (targetProp = Globals.g_installData.getProperty("deploywiz.install.target.list", null)) != null) {
            String targetEnabled = null;
            String[] targets = targetProp.split(",");
            for (int i = 0; i < targets.length; ++i) {
                targetEnabled = Globals.g_installData.getProperty("ittarget." + targets[i] + "." + productData.getProdCode(), null);
                if (targetEnabled == null) {
                    targetEnabled = Globals.g_installData.getProperty("ittarget." + targets[i] + ".enabled.all", "false");
                }
                if (!targetEnabled.equalsIgnoreCase("true")) continue;
                if (targetList != null) {
                    targetList = targetList + ",";
                    targetList = targetList + targets[i];
                    continue;
                }
                targetList = targets[i];
            }
        }
        if (targetList != null) {
            args.add("-target");
            args.add(targetList);
        }
        Logging.log.info("IT Parameters: " + args);
        InstallToolConnector.itController().setupInstallationForArgs(args.toArray(new String[args.size()]));
        if (Globals.g_cmtTask == 11) {
            AuditLogger auditLogger = InstallToolConnector.itController().getAuditLogger();
            String preExecutionLogPath = null;
            if (auditLogger != null) {
                preExecutionLogPath = auditLogger.preExecutionLogPath();
            }
            productData.setPreExecuteAuditLogPath(preExecutionLogPath);
        }
    }

    private static String getSASHome32(ProductData productData) {
        String prodCode;
        String sasHome32 = null;
        if (Utils.getOS_Suffix() == "wx6" && productData.getPlatform().equals("win") && ((prodCode = productData.getProdCode()).equals("eguide") || prodCode.equals("msofficeint") || prodCode.equals("webedtr"))) {
            String programFiles64 = System.getenv("ProgramW6432");
            String programFiles32 = System.getenv("ProgramFiles(x86)");
            String selectedSASHome = Globals.g_wizardData.getPreference("SASHome", "");
            String selectedSASHomeLowerCase = selectedSASHome.toLowerCase();
            if (selectedSASHomeLowerCase.startsWith(programFiles64.toLowerCase()) && !selectedSASHomeLowerCase.startsWith(programFiles32.toLowerCase())) {
                boolean result;
                int end;
                int start = programFiles64.length();
                if (start < (end = selectedSASHome.length())) {
                    sasHome32 = selectedSASHome.substring(start, end);
                    sasHome32 = programFiles32 + sasHome32;
                }
                Logging.log.info("Alternative 32bit SASHOME directory is: " + sasHome32);
                File sasHomeDir = new File(sasHome32);
                if (!sasHomeDir.exists() && !(result = sasHomeDir.mkdirs())) {
                    Logging.log.severe("Can not create alternate sashome directory " + sasHomeDir.getAbsolutePath());
                }
            }
        }
        return sasHome32;
    }

    public static Properties getProperties() {
        String environmentUrl;
        String sashome;
        String value;
        Properties properties = new Properties();
        String key = "deploywiz.altsku";
        SpsSkuData deploywizData = null;
        try {
            deploywizData = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "deploywiz", Utils.getOS_Suffix(), false);
        }
        catch (NullPointerException e) {
            if (!Globals.g_quietMode) {
                CustMsgBox.showErrorMessage(bundle.getString("PanelExecute.InstallPrompt.installtool.uninstall.fail.txt"));
            }
            Logging.log.severe(String.format("NullPointerException in InstallToolConnector.getProperties() likely due to missing order from DeploymentData.orderList \nGlobals.g_order == \"%s\"\nOS == \"%s\"", Globals.g_order.toString(), Utils.getOS_Suffix()));
            Globals.g_kit.exitKit(-1);
        }
        if (deploywizData != null && (value = deploywizData.getSpsSku()) != null) {
            properties.setProperty(key, value);
        }
        key = "data.loc";
        value = Globals.g_installDataLoc;
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "deployment.registry.view";
        value = Globals.g_deploymentRegistryView;
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "create.batch.file";
        if (Globals.g_createBatch) {
            properties.setProperty(key, "TRUE");
        } else {
            properties.setProperty(key, "FALSE");
        }
        key = "sdm.postinstall";
        if (Globals.g_cmtTask == 40 || Globals.g_cmtTask == 41) {
            properties.setProperty(key, "TRUE");
        } else {
            properties.setProperty(key, "FALSE");
        }
        key = "sdw.resume.chain";
        value = Globals.g_resumeChain ? "TRUE" : "FALSE";
        properties.setProperty(key, value);
        key = "sdw.srwonly";
        value = Globals.g_srwOnly ? "TRUE" : "FALSE";
        properties.setProperty(key, value);
        key = "sdw.log.path";
        value = Utils.getSDWDataPath(false);
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "ssd.dir";
        value = Globals.g_startupLocation;
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "sdm.dir";
        value = Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", null));
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "jre.home";
        value = Globals.g_jreHome;
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "deployment.jre.home";
        value = Globals.g_jreHome;
        if (value == null && Globals.g_deploymentJREHome != null && Utils.getOS_Suffix() == "mvs") {
            value = Globals.g_deploymentJREHome;
            Logging.log.fine("deployment.jre.home as Globals.g_deploymentJREHome=" + Globals.g_deploymentJREHome);
        }
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "order.encoding";
        String encoding2 = value = Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding();
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "zos.sashome";
        value = Globals.g_wizardData.getPreference("SASHome", null);
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "zos.shell.encoding";
        if (!Globals.g_installData.getProperties().containsKey(key) && (value = Globals.g_installData.getProperty("zos." + encoding2 + ".shell.encoding", Globals.g_installData.getProperty("zos.W0.shell.encoding", null))) != null) {
            Globals.g_installData.setProperty(key, value);
        }
        if (Globals.g_cmtTask == 40 || Globals.g_cmtTask == 41) {
            key = "base.home";
            value = InstallToolConnector.getHome_Base();
            if (value != null) {
                properties.setProperty(key, value);
            }
        }
        key = "sdm.applyhotfix";
        value = Globals.g_mode == 2 && Globals.g_cmtTask == 11 ? "TRUE" : "FALSE";
        properties.setProperty(key, value);
        key = "selected.languages";
        value = Globals.g_selectedLanguages;
        if (value != null) {
            if (Utils.getOS() == 1) {
                value = value + ",";
                value = value + "1d";
            }
            properties.setProperty(key, value);
        }
        key = "selected.or.installed.languages";
        value = "";
        if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
            boolean firstLang = true;
            for (String language : Globals.g_sasHomeStatus.getInstalledLanguages()) {
                if (firstLang) {
                    firstLang = false;
                } else {
                    value = value + ",";
                }
                value = value + language;
            }
        } else {
            value = Globals.g_selectedLanguages;
        }
        if (value != null) {
            if (Utils.getOS() == 1) {
                value = value + ",";
                value = value + "1d";
            }
            properties.setProperty(key, value);
        }
        key = "jmp.sid";
        value = null;
        if (Globals.g_jmpSID != null && (sashome = Globals.g_wizardData.getPreference("SASHome", null)) != null) {
            value = sashome + File.separator + "licenses" + File.separator + Globals.g_jmpSID.getSIDFile().getName();
        }
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "spds.sid";
        value = null;
        if (Globals.g_spdsSID != null && (sashome = Globals.g_wizardData.getPreference("SASHome", null)) != null) {
            value = sashome + File.separator + "licenses" + File.separator + Globals.g_spdsSID.getSIDFile().getName();
        }
        if (value != null) {
            properties.setProperty(key, value);
        }
        key = "update.mode";
        value = Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired() ? "TRUE" : "FALSE";
        properties.setProperty(key, value);
        if (Globals.g_cmtTask == 11) {
            key = "zos.hotfix";
            value = "TRUE";
            properties.setProperty(key, value);
            key = "zos.bit.count";
            value = "31";
            if (Globals.g_z64) {
                value = "64";
            }
            properties.setProperty(key, value);
            key = "zos.job.submit";
            if (Globals.g_z64) {
                key = "z64.job.submit";
            }
            value = "FALSE";
            if (Globals.g_zosJobSubmit) {
                value = "TRUE";
            }
            properties.setProperty(key, value);
            key = "zos.job.chain";
            if (Globals.g_z64) {
                key = "z64.job.chain";
            }
            value = "FALSE";
            if (Globals.g_zosJobChain) {
                value = "TRUE";
            }
            properties.setProperty(key, value);
        } else {
            key = "zos.hotfix.included";
            value = "true";
            properties.setProperty(key, value);
        }
        key = "sascfg.sasuser";
        value = Globals.g_suppliedSasuser;
        String defaultSasUser = null;
        defaultSasUser = Utils.getOS() == 1 ? "?FOLDERID_Documents\\My SAS Files\\9.4" : "~/sasuser.v94";
        if (value != null) {
            File sasUserPath = new File(value);
            if (!(sasUserPath.exists() && Utils.canWriteToPath(sasUserPath) || InstallToolConnector.isRedirectPathValidated(value))) {
                if (!sasUserPath.exists()) {
                    Logging.log.warning("The specified path for -sasuser " + value + " does not exist. The default value " + defaultSasUser + " will be used.");
                } else if (!Utils.canWriteToPath(sasUserPath)) {
                    Logging.log.warning("The specified path for -sasuser " + value + " is not writable. The default value " + defaultSasUser + " will be used.");
                }
                properties.setProperty(key, defaultSasUser);
            } else {
                properties.setProperty(key, value);
            }
        } else {
            properties.setProperty(key, defaultSasUser);
        }
        key = "sascfg.work";
        value = Globals.g_suppliedWork;
        String defaultWork = null;
        defaultWork = Utils.getOS() == 1 ? "!TEMP\\SAS Temporary Files" : System.getProperty("java.io.tmpdir");
        if (value != null) {
            File sasWork = new File(value);
            if (!(sasWork.exists() && Utils.canWriteToPath(sasWork) || InstallToolConnector.isRedirectPathValidated(value))) {
                if (!sasWork.exists()) {
                    Logging.log.warning("The specified path for -work " + value + " does not exist. The default value " + defaultWork + " will be used.");
                } else if (!Utils.canWriteToPath(sasWork)) {
                    Logging.log.warning("The specified path for -work " + value + " is not writable. The default value " + defaultWork + " will be used.");
                }
                properties.setProperty(key, defaultWork);
            } else {
                properties.setProperty(key, value);
            }
        } else {
            properties.setProperty(key, defaultWork);
        }
        ArrayList<String> logList = null;
        if (Globals.g_install || Globals.g_cmtTask == 11) {
            logList = new ArrayList<String>();
        }
        if ((environmentUrl = Globals.g_installData.getProperty("sas.environments.url", null)) != null && environmentUrl.length() > 0) {
            environmentUrl = Utils.toLowerCaseHostNameForUrl(environmentUrl);
            Globals.g_installData.setProperty("sas.environments.url", environmentUrl);
        }
        Enumeration<Object> e = Globals.g_installData.getProperties().keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = Globals.g_installData.getProperty(key, null);
            if ("zos.install.action".equals(key) && value != null && value.length() > 0) {
                value = value.substring(0, 1);
            } else if ("z64.install.action".equals(key) && value != null && value.length() > 0) {
                value = value.substring(0, 1);
            }
            if (value == null) continue;
            if (!"zos.host.logon.password".equals(key) && logList != null) {
                boolean found = false;
                String logText = Globals.g_eol + "      " + key + " = " + value;
                for (int i = 0; i < logList.size() && !found; ++i) {
                    if (((String)logList.get(i)).compareTo(logText) <= 0) continue;
                    found = true;
                    logList.add(i, logText);
                }
                if (!found) {
                    logList.add(logText);
                }
            }
            properties.setProperty(key, value);
        }
        if (logList != null) {
            String installProps = "Install Properties:";
            for (int i = 0; i < logList.size(); ++i) {
                installProps = installProps + (String)logList.get(i);
            }
            Logging.log.info(installProps);
        }
        return properties;
    }

    private static boolean isRedirectPathValidated(String sRedirectSASPah) {
        if (Utils.getOS() == 1) {
            return sRedirectSASPah.indexOf("!") > 0;
        }
        return false;
    }

    public int execute(String installXML, ProductData productData) {
        try {
            InstallToolConnector.primeInstallTool(installXML, productData);
            if (Globals.g_cmtTask == 11) {
                AuditLogger auditLogger = InstallToolConnector.itController().getAuditLogger();
                String postExecutionLogPath = null;
                if (auditLogger != null) {
                    postExecutionLogPath = auditLogger.postExecutionLogPath();
                }
                productData.setPostExecuteAuditLogPath(postExecutionLogPath);
                productData.setUpdateBackupDirectory(InstallToolConnector.itController().getBackupRootDirectory());
            }
            Integer retVal = InstallToolConnector.itController().runInstallation();
            Logging.log.info("Return Code: " + retVal);
            return retVal;
        }
        catch (Exception f) {
            Logging.logStackTrace(f);
            return -1;
        }
    }

    public void preExecute(File installXML, File productData, String altsku) {
        PreExecuteRunnable preExecute = new PreExecuteRunnable(installXML, productData, altsku);
        this.preExecuteRunnables.add(preExecute);
        this.getPreExecuteThreadPool().submit(preExecute);
    }

    public int postProcess() {
        postProcessingCalled = true;
        postProcessingSuccessful = true;
        int result = -1;
        if (Globals.g_installToolBasedProds.isEmpty()) {
            return 0;
        }
        if (Utils.getOS() == 1) {
            File extRegFile = new File(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc\\extensionRegistry.xml");
            if (extRegFile.exists()) {
                DefaultFileTypeAssociations defaultFileTypeAssociations = new DefaultFileTypeAssociations(extRegFile, Globals.g_defaultProductForFileTypes, Globals.g_fullInstalls);
                if (!defaultFileTypeAssociations.register(Globals.g_ProductsWithSharedFileTypesAlreadyInstalled)) {
                    Logging.log.warning("There was a problem registering one or more default file type actions.");
                }
            } else {
                Logging.log.info("Extension registery does not exist, therefore there are not any file extensions to register.  Expected extension registry file: " + extRegFile.getAbsolutePath());
            }
        }
        try {
            result = InstallToolConnector.itController().postProcess();
            Logging.log.info("Return Code: " + result);
        }
        catch (Exception f) {
            Logging.logStackTrace(f.getCause());
        }
        if (!(!Globals.g_checkDeploymentAgentUp || Globals.g_recordMode && Globals.g_recordOnly || Globals.g_quietMode || Utils.startDeploymentAgentIfNotStarted())) {
            result = -1;
            int iPrompt = 0;
            String sdwLogFileName = Utils.joinPath(Utils.getSDWDataPath(false), "SDW" + Logging.getTimeStamp() + ".log");
            String msgTxt = bundle.messageString("PanelSelectServicesToStart.Failed.txt", sdwLogFileName);
            boolean retry = false;
            do {
                try {
                    retry = false;
                    iPrompt = CustMsgBox.showConfirmRetryNoQuitPrompt(msgTxt);
                    if (iPrompt == 0) {
                        if (Utils.startDeploymentAgentIfNotStarted()) continue;
                        retry = true;
                        continue;
                    }
                    if (iPrompt == 1) {
                        Logging.log.info("Continue the SAS Deployment Wizard without an active SAS Deployment Agent.");
                        continue;
                    }
                    if (iPrompt != 2) continue;
                    Logging.log.info("Quit the SAS Deployment Wizard as SAS Deployment Agent can't be restarted.");
                    Globals.g_kit.exitKit(-1);
                }
                catch (Exception e) {
                    Controller.stackTraceForError(e);
                }
            } while (retry);
        }
        if (result != 0) {
            postProcessingSuccessful = false;
        }
        return result;
    }

    public Vector<PreExecuteRunnable> getPreExecuteRunnables() {
        return this.preExecuteRunnables;
    }

    public static boolean checkMvsDataSetParams(int function, String value, Properties dsProperties, Logger log, boolean quiet, StringBuffer msgs) {
        return InstallToolConnector.itController().checkMvsDataSetParams(function, value, dsProperties, log, quiet, msgs);
    }

    public static String getMvsUserParam(String key) {
        return InstallToolConnector.itController().getMvsUserParam(key);
    }

    public static List<String> getMvsFinalJobNames() {
        return InstallToolConnector.itController().getMvsFinalJobNames();
    }

    public static Map<String, String> getMvsJobStatus() {
        return InstallToolConnector.itController().getMvsJobStatus();
    }

    public static boolean isMvsHelpJobPresent() {
        return InstallToolConnector.itController().isMvsHelpJobPresent();
    }

    public static boolean isMvsStagedInstall() {
        return InstallToolConnector.itController().isMvsStagedInstall();
    }

    public static boolean postProcessingCalled() {
        return postProcessingCalled;
    }

    public static boolean postProcessingSuccessful() {
        return postProcessingSuccessful;
    }

    public DeploymentParameters getDeploymentParameters() {
        return packageCollection;
    }

    public void setDestination(String altSku, String destination) {
        DeploymentPackage pkg = packageCollection.getSkuPackage(altSku);
        if (pkg == null) {
            Logging.log.warning("Package for sku " + altSku + " not found");
        } else {
            pkg.setDestination(destination);
        }
    }

    public ExecutorService getPreExecuteThreadPool() {
        if (this.threadPool == null) {
            if (Globals.g_singleThread) {
                this.threadPool = PreExecuteThreadPool.newPreExecuteThreadPool(1);
                return this.threadPool;
            }
            this.threadPool = PreExecuteThreadPool.newPreExecuteThreadPool();
        }
        return this.threadPool;
    }

    public static String getHome_Base() {
        RegistryAccess m_registryAccess;
        ProductData sasProdData;
        String sasInstallLoc;
        block14: {
            sHome_Base = null;
            sasInstallLoc = null;
            sasProdData = null;
            m_registryAccess = null;
            try {
                if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
                    if (Globals.g_bitnessSASLocation != null) {
                        return Globals.g_bitnessSASLocation;
                    }
                    return Utils.joinPath(Globals.g_cmtSASHome, "SASFoundation", Globals.g_majorReleaseVersion);
                }
                if (!Globals.g_resumeChain && Globals.g_cmtSASHome != null) {
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    m_registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    break block14;
                }
                File deployRegJar = new File(Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "deploymntreg"), "sas.tools.deploymntreg.jar");
                if (deployRegJar.exists()) {
                    m_registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                    break block14;
                }
                return null;
            }
            catch (Exception e) {
                m_registryAccess = null;
                Logging.logStackTrace(e);
            }
        }
        sasProdData = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "base", Globals.g_sasinstallPlat, false) : Globals.g_deploymentData.getProduct(Globals.g_order, "base", false);
        if (sasProdData != null && m_registryAccess != null && m_registryAccess.open()) {
            if (Globals.g_sasinstallPlat != null) {
                if (Utils.getOS() == 1) {
                    if (Utils.getOS_Suffix().equals("wx6") && (sasInstallLoc = m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), "wx6")) == null) {
                        sasInstallLoc = m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), "win");
                    }
                } else {
                    sasInstallLoc = m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), Globals.g_sasinstallPlat);
                    if (sasInstallLoc == null) {
                        sasInstallLoc = m_registryAccess.getInstallLoc("base", "default", Globals.g_sasinstallPlat);
                    }
                }
            } else {
                sasInstallLoc = m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion());
                if (sasInstallLoc == null) {
                    sasInstallLoc = m_registryAccess.getInstallLoc("base", "default");
                }
            }
            sHome_Base = sasInstallLoc;
            Logging.log.info("${home_base} is " + sHome_Base);
            m_registryAccess.close();
        }
        return sHome_Base;
    }

    static {
        postProcessingCalled = false;
        postProcessingSuccessful = false;
        sHome_Base = null;
        bundle = new SSNResource(InstallToolConnector.class);
        packageCollection = null;
    }
}

