/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class InstallDefaults {
    private Properties m_installDefaults = new Properties();

    public InstallDefaults() {
        Globals.g_installPropsSource = new TreeMap<String, String>();
    }

    public boolean load(String properties) {
        boolean valid = false;
        try {
            File propsFile = new File(properties);
            if (propsFile.isFile()) {
                FileInputStream fis = new FileInputStream(propsFile);
                this.m_installDefaults.load(fis);
                fis.close();
                valid = true;
                Properties props = new Properties();
                fis = new FileInputStream(propsFile);
                props.load(fis);
                fis.close();
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    Globals.g_installPropsSource.put((String)e.nextElement(), properties);
                }
            } else {
                Logging.log.fine("Properties file does not exist: " + properties);
            }
        }
        catch (Exception e) {
            Logging.log.info("Error loading properties file: " + properties);
        }
        return valid;
    }

    public boolean save() {
        boolean valid = false;
        String defaults = Utils.joinPath(System.getProperty("user.home"), "all_install_default.properties");
        try {
            File defaultsFile = new File(defaults);
            FileOutputStream fos = new FileOutputStream(defaultsFile);
            this.m_installDefaults.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e) {
            Logging.log.info("Error saving install all default properties file: " + defaults);
        }
        return valid;
    }

    public Enumeration getNames() {
        return this.m_installDefaults.propertyNames();
    }

    public void setDefault(String key, String value) {
        this.m_installDefaults.setProperty(key, value);
    }

    public String getDefault(String key, String defaultValue) {
        return this.m_installDefaults.getProperty(key, defaultValue);
    }
}

