/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixIndex;
import com.sas.ssn.HotFixIndexException;
import com.sas.ssn.HotFixManager;
import com.sas.ssn.HotFixPackageData;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.ResponseData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HotFixPackages {
    private RegistryAccess registryAccess = null;
    private Map<String, Map<String, HotFix>> installableHotFixesByKey = new HashMap<String, Map<String, HotFix>>();
    private List<HotFix> hotFixesToInstall = new ArrayList<HotFix>();
    private List<String> failedPackages = new ArrayList<String>();
    private String orderToProcess = null;
    private String hotFixesDirectory = Utils.joinPath(Globals.g_startupLocation, HotFixManager.getHotFixSubDir());
    private HotFixIndex hotFixIndex = null;
    private boolean emptySASHome = false;
    private boolean atLeastOneHotFix = false;
    private boolean atLeastOneHotFixForHost = false;
    private boolean atLeastOneHotFixForProduct = false;
    private static String extractLocation = null;
    private List<HotFix> hotFixesRequiringInitRestart = new ArrayList<HotFix>();
    public static final String SECURITY_FIX = "W83001";
    private static final int SECURITY_FIX_SEQUENCE = 10;

    public boolean loadIndex(String order) {
        File hotFixIndexFile = HotFixManager.findIndexFile(this.hotFixesDirectory, order);
        if (!hotFixIndexFile.exists()) {
            Logging.log.info("Hot fix index file not present, hot fixes are not available for installation from this depot.");
            return false;
        }
        if (this.hotFixIndex == null) {
            try {
                this.hotFixIndex = new HotFixIndex(hotFixIndexFile);
            }
            catch (HotFixIndexException e) {
                Logging.log.warning("Error occurred loading hot fix index file " + e.getPath());
                Logging.log.warning(e.getLogMessage());
                return false;
            }
        }
        Logging.log.info("Hot fix index file successfully loaded: " + hotFixIndexFile.getPath());
        return true;
    }

    public void setIndex(HotFixIndex hotFixIndex) {
        this.hotFixIndex = hotFixIndex;
    }

    public void setHotFixPackagesDirectory(String directory) {
        this.hotFixesDirectory = directory;
    }

    public boolean loadPackages(String order, boolean emptySASHome, String sdwVersion) {
        this.installableHotFixesByKey.clear();
        Globals.g_configurableHotFixes.clear();
        this.atLeastOneHotFix = false;
        this.atLeastOneHotFixForHost = false;
        this.failedPackages.clear();
        if (this.hotFixIndex == null) {
            Logging.log.warning("Hot fix index file has not been loaded.");
            return false;
        }
        boolean result = true;
        this.emptySASHome = emptySASHome;
        this.orderToProcess = order;
        List<Object> hotFixPackageFilenames = new ArrayList();
        if (emptySASHome) {
            Logging.log.info("Active hot fixes are being processed for an empty sashome.");
            hotFixPackageFilenames = this.hotFixIndex.getActiveHotFixePackageFilenamesForOrder(this.orderToProcess);
        } else {
            hotFixPackageFilenames = this.hotFixIndex.getAllHotFixPackageFilenamesForOrder(this.orderToProcess);
        }
        for (String string : hotFixPackageFilenames) {
            if (this.hotFixIndex.isHotFixExcludedForSDWVersion(order, string, sdwVersion)) {
                Logging.log.info("Hot fix package " + string + " will not be procssed as the hot fix is not compatible with this SDW version " + sdwVersion + " for the order " + order);
                continue;
            }
            if (this.hotFixIndex.isHotFixInstallable(order, string)) {
                File hotFixPackageFile = new File(this.hotFixesDirectory, string);
                if (Globals.g_hfInclOnly && !this.hotFixIndex.isSecurityFix(order, string)) continue;
                HotFixPackageData hotFixPackageData = new HotFixPackageData(hotFixPackageFile);
                if (hotFixPackageData.loadHotFixPackage(this.hotFixIndex.getHotFixPackageForOrder(this.orderToProcess, string), emptySASHome)) {
                    this.atLeastOneHotFix = true;
                    if (hotFixPackageData.getInstallableHotFixes().size() > 0) {
                        this.addHotFixesByKey(hotFixPackageData.getInstallableHotFixes());
                        if (hotFixPackageData.isAtLeastOneHotFixValidForHost()) {
                            this.atLeastOneHotFixForHost = true;
                        }
                    }
                    if (hotFixPackageData.getConfigurableHotFixes().size() <= 0) continue;
                    Globals.g_configurableHotFixes.addAll(hotFixPackageData.getConfigurableHotFixes());
                    continue;
                }
                String packagePath = hotFixPackageFile.getAbsolutePath();
                Logging.log.warning("Error occurred while processing hot fix package file: " + packagePath);
                this.failedPackages.add(packagePath);
                result = false;
                continue;
            }
            Logging.log.info("Hot fix package " + string + " will not be processed as the user has disabled this packageby setting the install value to false in the hot fix index (hot_fix/hot_fix_index.xml) for this hot fix package for the order " + order);
        }
        return result;
    }

    public boolean configurableHotFixesPresent() {
        return Globals.g_configurableHotFixes.size() > 0;
    }

    public List<String> getFailedPackages() {
        return this.failedPackages;
    }

    public boolean availableHotFixesToInstall() {
        return !this.installableHotFixesByKey.isEmpty();
    }

    public boolean availableHotFixes() {
        return this.atLeastOneHotFix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HotFix> getHotFixesToInstall(List<ProductData> installChain, boolean clear) {
        if (clear) {
            this.hotFixesToInstall.clear();
            this.resetInstallableStatus();
            try {
                if (!this.emptySASHome && !this.getDeploymentRegistryAccess()) {
                    Logging.log.severe("An error occurred while opening the deployment registry.");
                    if (this.registryAccess != null) {
                        this.registryAccess.close();
                    }
                    List<HotFix> list = this.hotFixesToInstall;
                    return list;
                }
                for (ProductData productToInstall : installChain) {
                    if (productToInstall.getType() != 1) continue;
                    this.hotFixesToInstall.addAll(this.getFilteredHotFixes(Globals.g_deploymentData.getSpsSku(productToInstall.getSpsSku())));
                }
                if (!this.emptySASHome) {
                    this.addHotFixesToForceInstall();
                }
            }
            catch (Exception e) {
                this.hotFixesToInstall.clear();
                Logging.log.severe("An error occurred while processing the deployment registry to determine which hot fixes to install.");
                Logging.logStackTrace(e);
            }
            finally {
                if (this.registryAccess != null) {
                    this.registryAccess.close();
                }
            }
        }
        return this.hotFixesToInstall;
    }

    private void addHotFixesToForceInstall() {
        for (HotFix hotFix : this.getAllLoadedHotFixes()) {
            if (!hotFix.forceDuringUpdate() || hotFix.forceOnlyInChain() || this.hotFixesToInstall.contains(hotFix)) continue;
            Logging.log.fine(String.format("Checking HotFix %s for applicability to installed version of %s (%s)", hotFix.getHotFixName(), hotFix.getProdCode(), hotFix.getProdVersion()));
            if (!this.addHotFixToInstall(hotFix)) continue;
            Logging.log.fine(String.format("Hotfix %s has been added to the install chain", hotFix.getHotFixName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HotFix> getPostInstallHotFixesToInstall(boolean clear) {
        if (clear) {
            this.hotFixesToInstall.clear();
            this.resetInstallableStatus();
            this.atLeastOneHotFixForProduct = false;
            try {
                if (this.getDeploymentRegistryAccess()) {
                    for (HotFix hotFix : this.getAllLoadedHotFixes()) {
                        this.addHotFixToInstall(hotFix);
                    }
                } else {
                    Logging.log.severe("An error occurred while opening the deployment registry.");
                    this.hotFixesToInstall.clear();
                }
            }
            catch (Exception e) {
                this.hotFixesToInstall.clear();
                Logging.log.severe("An error occurred while processing the deployment registry to determine which hot fixes to install.");
                Logging.logStackTrace(e);
            }
            finally {
                if (this.registryAccess != null) {
                    this.registryAccess.close();
                }
            }
        }
        this.hotFixesToInstall = HotFixPackages.sortHotFixInstallChain(this.hotFixesToInstall);
        return this.hotFixesToInstall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addHotFixToInstall(HotFix hotFix) {
        boolean addedToChain = false;
        boolean productInstalled = false;
        String productCode = hotFix.getProdCode();
        String productVersion = hotFix.getProdVersion();
        String platform = hotFix.getPlatform();
        try {
            if (!this.getDeploymentRegistryAccess()) {
                boolean bl = false;
                return bl;
            }
            String installedProductMaintVer = this.registryAccess.getMaintLevel(productCode, productVersion, platform);
            if (installedProductMaintVer == null) {
                Logging.log.severe("An error occurred while obtaining the product maintenance version from the registry for " + productCode);
                boolean bl = false;
                return bl;
            }
            boolean hasRequiredMaint = this.hasRequiredMaintenanceForHotFix(hotFix.getHotFixMinMaintVersion(), hotFix.getHotFixMaxMaintVersion(), hotFix.isHotFixMaintVerExclusive(), installedProductMaintVer);
            if (hasRequiredMaint) {
                if (hotFix.getSpsSkuData().isStandardLanguage()) {
                    productInstalled = true;
                } else {
                    String encoding;
                    String[] languages = this.registryAccess.getInstallLanguages(productCode, productVersion, platform);
                    if ((platform.equalsIgnoreCase("mvs") || platform.equalsIgnoreCase("z64")) && languages.length == 0 && (encoding = this.registryAccess.getSashomeEncodingTwoByte()) != null && !encoding.isEmpty()) {
                        languages = new String[]{encoding};
                    }
                    for (String language : languages) {
                        if (!language.equalsIgnoreCase(hotFix.getSpsSkuData().getLanguage())) continue;
                        productInstalled = true;
                        break;
                    }
                }
            }
            if (productInstalled) {
                this.atLeastOneHotFixForProduct = true;
                List<String> installedHotFixes = this.getInstalledHotFixesForProduct(productCode, productVersion, platform);
                if (installedHotFixes != null && installedHotFixes.contains(hotFix.getHotFixName().toLowerCase())) {
                    hotFix.setHotFixAlreadyInstalled(true);
                    if (Globals.g_reinstallHotFixes) {
                        hotFix.setInstallableStatus("readyToInstall");
                        this.hotFixesToInstall.add(hotFix);
                        if (hotFix.requireInitRestart()) {
                            this.hotFixesRequiringInitRestart.add(hotFix);
                        }
                    } else {
                        hotFix.setInstallableStatus("notInstallableDueToReinstallDisabled");
                    }
                } else {
                    hotFix.setInstallableStatus("readyToInstall");
                    this.hotFixesToInstall.add(hotFix);
                    addedToChain = true;
                    if (hotFix.requireInitRestart()) {
                        this.hotFixesRequiringInitRestart.add(hotFix);
                    }
                }
            } else {
                hotFix.setInstallableStatus("productNotInstalled");
            }
        }
        catch (Exception e) {
            Logging.log.severe("An error occurred while processing the deployment registry to determine which hot fixes to install.");
            Logging.logStackTrace(e);
        }
        finally {
            if (this.registryAccess != null) {
                this.registryAccess.close();
            }
        }
        return addedToChain;
    }

    public boolean allHotFixesAlreadyInstalled() {
        return this.atLeastOneHotFixAlreadyInstalled() && this.hotFixesToInstall.size() == 0;
    }

    public boolean noHotFixesForThisHost() {
        return !this.atLeastOneHotFixForHost;
    }

    public boolean noHotFixesForTheInstalledProducts() {
        return !this.atLeastOneHotFixForProduct;
    }

    public boolean atLeastOneHotFixAlreadyInstalled() {
        return this.getAlreadyInstalledHotFixes().size() > 0;
    }

    public boolean atLeastOneHotFixNotApplicable() {
        return this.getNotApplicableHotFixes().size() > 0;
    }

    public void logHotFixesToInstall() {
        StringBuffer hotFixLogEntries = new StringBuffer();
        hotFixLogEntries.append("Below is a list of hot fixes to be installed upon completion of this installation:\n");
        for (HotFix hotFix : this.hotFixesToInstall) {
            hotFixLogEntries.append("* ");
            hotFixLogEntries.append(hotFix.getProdNameExtended());
            hotFixLogEntries.append(" (");
            hotFixLogEntries.append(hotFix.getHotFixPackageFilename());
            hotFixLogEntries.append(", ");
            hotFixLogEntries.append(hotFix.getSpsSku());
            hotFixLogEntries.append(")");
            hotFixLogEntries.append("\n");
            if (!hotFix.isConfigurable()) continue;
            hotFixLogEntries.append(" (Configurable)");
        }
        Logging.log.info(hotFixLogEntries.toString());
    }

    public void logHotFixesNotApplicable() {
        StringBuffer hotFixLogEntries = new StringBuffer();
        hotFixLogEntries.append("Below is a list of hot fixes that will not be installed:\n");
        for (HotFix hotFix : this.getNotApplicableHotFixes()) {
            hotFixLogEntries.append("* ");
            hotFixLogEntries.append(hotFix.getProdNameExtended());
            hotFixLogEntries.append(" (");
            hotFixLogEntries.append(hotFix.getProdCode());
            hotFixLogEntries.append(")");
            if (hotFix.getInstallableStatus() == "notInstallableDueToExistingSASHome") {
                hotFixLogEntries.append("\n  --> reason: hot fixes for newly installed products are not installable to an existing sas home.");
            } else if (hotFix.getInstallableStatus() == "notInstallableDueToReinstallDisabled") {
                hotFixLogEntries.append("\n  --> reason: hot fix is already installed.");
            } else {
                if (this.emptySASHome) {
                    hotFixLogEntries.append("\n --> reason: the product is not being installed: ");
                } else {
                    hotFixLogEntries.append("\n --> reason: the product is not installed: ");
                }
                hotFixLogEntries.append(hotFix.getProdName());
                String language = hotFix.getSpsSkuData().getLanguage();
                if (!"xx".equalsIgnoreCase(language)) {
                    hotFixLogEntries.append(", language: ");
                    hotFixLogEntries.append(language);
                }
                hotFixLogEntries.append(", version: ");
                hotFixLogEntries.append(hotFix.getSpsSkuData().getDisplayVer("en"));
                hotFixLogEntries.append(", maintenance level: ");
                hotFixLogEntries.append(hotFix.getSpsSkuData().getMaintLevel());
                hotFixLogEntries.append(", for the platform: ");
                String platform = this.getPlatformToDeploy(hotFix.getPlatform());
                hotFixLogEntries.append(platform);
            }
            hotFixLogEntries.append("\n");
        }
        Logging.log.info(hotFixLogEntries.toString());
    }

    public void logAlreadyInstalledHotFixes() {
        StringBuffer hotFixLogEntries = new StringBuffer();
        hotFixLogEntries.append("Below is a list of hot fixes that are already installed:\n");
        for (HotFix hotFix : this.getAlreadyInstalledHotFixes()) {
            hotFixLogEntries.append("* ");
            hotFixLogEntries.append(hotFix.getProdNameExtended());
            hotFixLogEntries.append(" (");
            hotFixLogEntries.append(hotFix.getProdCode());
            hotFixLogEntries.append(")");
            hotFixLogEntries.append("\n");
        }
        Logging.log.info(hotFixLogEntries.toString());
    }

    public static void createHotFixReponseData() {
        ResponseData.getInstance().setProperty("MANAGE_TASK", "applyhotfix");
        String hotFixPackageDir = HotFixPackages.getDefaultSDMHotFixDir();
        if (Globals.g_hotFixPackageDir != null) {
            hotFixPackageDir = Globals.g_hotFixPackageDir;
        }
        ResponseData.getInstance().setProperty("HOTFIX_PACKAGE_DIR", hotFixPackageDir);
        ResponseData.getInstance().setProperty("HOTFIX_INSTALL", "yes");
        ResponseData.getInstance().setProperty("HOTFIX_CONFIGURE", "no");
    }

    public static String getDefaultSDMHotFixDir() {
        if (Globals.g_hotFixPackageDir != null && !Globals.g_hotFixPackageDir.equals("")) {
            return Globals.g_hotFixPackageDir;
        }
        return Utils.joinPath(Utils.joinPath(Globals.g_cmtSASHome, "InstallMisc"), "HotFixes", "New");
    }

    private static List<HotFix> sortHotFixInstallChain(List<HotFix> unsortedHotFixInstallChain) {
        ArrayList<HotFix> sortedHotFixInstallChain = new ArrayList<HotFix>(unsortedHotFixInstallChain);
        ArrayList<String> sortedKeys = new ArrayList<String>();
        HashMap<String, HotFix> hotFixesByKey = new HashMap<String, HotFix>();
        for (HotFix hotFix : sortedHotFixInstallChain) {
            String hotFixKey = hotFix.getProdNameExtended() + "~" + hotFix.getSpsSku();
            if (hotFixesByKey.containsKey(hotFixKey)) {
                Logging.log.warning("Sorting process detected a duplicate key: " + hotFixKey + ", one or more hot fix packages will not be deployed as a result.");
            }
            hotFixesByKey.put(hotFixKey, hotFix);
            sortedKeys.add(hotFixKey);
        }
        Collections.sort(sortedKeys);
        sortedHotFixInstallChain.clear();
        for (String key : sortedKeys) {
            sortedHotFixInstallChain.add((HotFix)hotFixesByKey.get(key));
        }
        return sortedHotFixInstallChain;
    }

    private String getPlatformToDeploy(String hotFixPlatform) {
        String platform = null;
        platform = "prt".equalsIgnoreCase(hotFixPlatform) ? Utils.getOS_Suffix() : hotFixPlatform;
        return platform;
    }

    private boolean getDeploymentRegistryAccess() {
        try {
            if (this.registryAccess == null) {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            }
            if (!this.registryAccess.open()) {
                boolean ret = this.registryAccess.close();
                if (!this.registryAccess.open()) {
                    Logging.log.warning("The attempt to close registryAccess returned " + ret);
                    Logging.log.warning("Unable to open deployment registry for hot fix processing: " + RegistryData.getDeployRegJar());
                    return false;
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.logStackTrace(e);
            Logging.log.warning("Unable to open deployment registry for hot fix processing: file not found: " + RegistryData.getDeployRegJar());
            return false;
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            Logging.log.warning("Unable to open deployment registry for hot fix processing: general error: " + RegistryData.getDeployRegJar());
            return false;
        }
        return true;
    }

    private void addHotFixesByKey(List<HotFix> hotFixes) {
        for (HotFix hotFix : hotFixes) {
            String key = HotFixPackages.getHotFixProductKey(hotFix.getSpsSkuData());
            if (this.installableHotFixesByKey.containsKey(key)) {
                this.installableHotFixesByKey.get(key).put(hotFix.getSpsSku(), hotFix);
                continue;
            }
            HashMap<String, HotFix> hotFixMap = new HashMap<String, HotFix>();
            hotFixMap.put(hotFix.getSpsSku(), hotFix);
            this.installableHotFixesByKey.put(key, hotFixMap);
        }
    }

    public List<HotFix> getHotFixesByKey(String key) {
        ArrayList<HotFix> hotFixes = null;
        Map<String, HotFix> hotFixMap = this.installableHotFixesByKey.get(key);
        if (hotFixMap != null) {
            hotFixes = new ArrayList<HotFix>();
            hotFixes.addAll(hotFixMap.values());
        }
        return hotFixes;
    }

    protected List<HotFix> getAllLoadedHotFixes() {
        ArrayList<HotFix> hotFixes = new ArrayList<HotFix>();
        Set<String> keys = this.installableHotFixesByKey.keySet();
        for (String key : keys) {
            for (HotFix hotFix : this.getHotFixesByKey(key)) {
                hotFixes.add(hotFix);
            }
        }
        return hotFixes;
    }

    private void resetInstallableStatus() {
        for (HotFix hotFix : this.getAllLoadedHotFixes()) {
            hotFix.setInstallableStatus("productNotInstalled");
            hotFix.setHotFixAlreadyInstalled(false);
        }
    }

    private List<HotFix> getNotApplicableHotFixes() {
        ArrayList<HotFix> hotFixes = new ArrayList<HotFix>();
        for (HotFix hotFix : this.getAllLoadedHotFixes()) {
            if (hotFix.getInstallableStatus() != "productNotInstalled" && hotFix.getInstallableStatus() != "notInstallableDueToExistingSASHome" && hotFix.getInstallableStatus() != "notInstallableDueToReinstallDisabled") continue;
            hotFixes.add(hotFix);
        }
        return hotFixes;
    }

    private List<HotFix> getAlreadyInstalledHotFixes() {
        ArrayList<HotFix> hotFixes = new ArrayList<HotFix>();
        for (HotFix hotFix : this.getAllLoadedHotFixes()) {
            if (!hotFix.isHotFixAlreadyInstalled()) continue;
            hotFixes.add(hotFix);
        }
        return hotFixes;
    }

    private List<HotFix> getFilteredHotFixes(SpsSkuData productSkuData) {
        ArrayList<HotFix> filteredHotFixes = new ArrayList<HotFix>();
        String key = HotFixPackages.getHotFixProductKey(productSkuData);
        List<HotFix> hotFixes = this.getHotFixesByKey(key);
        List<String> installedHotFixes = null;
        if (hotFixes != null) {
            if (!this.emptySASHome) {
                installedHotFixes = this.getInstalledHotFixesForProduct(productSkuData);
            }
            for (HotFix hotFix : hotFixes) {
                if (!this.hasRequiredMaintenanceForHotFix(hotFix.getHotFixMinMaintVersion(), hotFix.getHotFixMaxMaintVersion(), hotFix.isHotFixMaintVerExclusive(), productSkuData.getMaintLevel())) continue;
                if (hotFix.getSpsSkuData().getPlatform().equalsIgnoreCase("prt")) {
                    hotFix.setPlatform(productSkuData.platformToDeploy(Utils.getOS_Suffix()));
                }
                boolean hotFixInstalled = false;
                if (installedHotFixes != null) {
                    hotFixInstalled = installedHotFixes.contains(hotFix.getHotFixName().toLowerCase());
                }
                if (hotFixInstalled) {
                    hotFix.setHotFixAlreadyInstalled(true);
                }
                if (this.emptySASHome || hotFixInstalled || hotFix.forceDuringUpdate()) {
                    if (hotFix.forceDuringUpdate()) {
                        Logging.log.info("The following hot fix has been forced to apply during an update: " + hotFix.getHotFixName());
                    }
                    hotFix.setInstallableStatus("readyToInstall");
                    filteredHotFixes.add(hotFix);
                    continue;
                }
                if (this.emptySASHome) continue;
                hotFix.setInstallableStatus("notInstallableDueToExistingSASHome");
            }
        }
        return filteredHotFixes;
    }

    private List<String> getInstalledHotFixesForProduct(SpsSkuData skuData) {
        return this.getInstalledHotFixesForProduct(skuData.getProdCode(), skuData.getDisplayVer("en"), skuData.platformToDeploy(Utils.getOS_Suffix()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getInstalledHotFixesForProduct(String productCode, String version, String platform) {
        ArrayList<String> installedHotFixes = new ArrayList<String>();
        String maintLevel = null;
        String[] maintVersions = null;
        try {
            if (!this.getDeploymentRegistryAccess()) {
                Logging.log.severe("An error occurred while opening the deployment registry.");
                List<String> list = null;
                return list;
            }
            maintLevel = this.registryAccess.getMaintLevel(productCode, version, platform);
            maintVersions = this.registryAccess.getMaintVersions(productCode, version, platform);
        }
        catch (Exception e) {
            Logging.log.severe("An error occurred while processing the deployment registry to determine which hot fixes to install.");
            Logging.logStackTrace(e);
        }
        finally {
            if (this.registryAccess != null) {
                this.registryAccess.close();
            }
        }
        boolean maintLevelFound = false;
        for (int i = 0; i < maintVersions.length; ++i) {
            String maintenance = maintVersions[i];
            if (maintenance == null) {
                return null;
            }
            if (maintLevelFound) {
                installedHotFixes.add(maintenance.toLowerCase());
                continue;
            }
            if (!maintenance.equals(maintLevel)) continue;
            maintLevelFound = true;
        }
        return installedHotFixes;
    }

    private boolean hasRequiredMaintenanceForHotFix(String hotFixMinMaintVer, String hotFixMaxMaintVer, boolean maintVerExclusive, String productMaintVer) {
        boolean verCompatible = true;
        Integer actual = Integer.valueOf(productMaintVer);
        if (hotFixMinMaintVer != null) {
            boolean bl = verCompatible = verCompatible && actual >= Integer.valueOf(hotFixMinMaintVer);
        }
        if (hotFixMaxMaintVer != null) {
            verCompatible = maintVerExclusive ? verCompatible && actual < Integer.valueOf(hotFixMaxMaintVer) : verCompatible && actual <= Integer.valueOf(hotFixMaxMaintVer);
        }
        return verCompatible;
    }

    public static String getHotFixProductKey(SpsSkuData skuData) {
        return HotFixPackages.getHotFixProductKey(skuData.getProdCode(), skuData.getDisplayVer("en"), skuData.getPlatform(), skuData.getLanguage());
    }

    public static String getHotFixProductKey(String productCode, String dispayVersion, String platform, String language) {
        return (productCode + "~" + dispayVersion + "~" + platform + "~" + language).toLowerCase();
    }

    public static ArrayList<ProductData> insertHotFixPackages(List<ProductData> sortedProductList, List<HotFix> hotFixList) {
        ArrayList<ProductData> sortedProductListWithHotFixes = new ArrayList<ProductData>(sortedProductList);
        List<HotFix> sortedHotFixList = HotFixPackages.sortHotFixInstallChain(hotFixList);
        TreeMap<Integer, HotFix> securityFixList = new TreeMap<Integer, HotFix>();
        for (HotFix hotFix : sortedHotFixList) {
            int lastProductListIndex;
            boolean insertionPointFound = false;
            if (hotFix.getHotFixName().equalsIgnoreCase(SECURITY_FIX)) {
                hotFix.setSecurityFixSequence(10);
                hotFix.setSecurityFix(true);
            }
            if (hotFix.isSecurityFix()) {
                securityFixList.put(hotFix.getSecurityFixSequence(), hotFix);
            }
            String hotFixKey = HotFixPackages.getHotFixProductKey(hotFix.getProdCode(), hotFix.getProdMaint(), hotFix.getPlatform(), hotFix.getSpsSkuData().getLanguage());
            for (int i = lastProductListIndex = sortedProductListWithHotFixes.size() - 1; i >= 0; --i) {
                SpsSkuData spsSkuData = sortedProductListWithHotFixes.get(i).getType() == 4 ? ((HotFix)sortedProductListWithHotFixes.get(i)).getSpsSkuData() : Globals.g_deploymentData.getSpsSku(sortedProductListWithHotFixes.get(i).getSpsSku());
                String productKey = HotFixPackages.getHotFixProductKey(sortedProductListWithHotFixes.get(i).getProdCode(), sortedProductListWithHotFixes.get(i).getProdMaint(), sortedProductListWithHotFixes.get(i).getPlatform(), spsSkuData.getLanguage());
                if (!hotFixKey.equals(productKey)) continue;
                sortedProductListWithHotFixes.add(i + 1, hotFix);
                insertionPointFound = true;
                i = -1;
            }
            if (insertionPointFound) continue;
            Logging.log.warning("Insertion point not found, inserting at the end of the install chain: " + hotFix.getSpsSku());
            sortedProductListWithHotFixes.add(hotFix);
        }
        HotFixPackages.moveSecurityFixes(securityFixList, sortedProductListWithHotFixes);
        return sortedProductListWithHotFixes;
    }

    public static List<ProductData> orderHotFixes(List<HotFix> hotFixes) {
        TreeMap<Integer, HotFix> securityFixList = new TreeMap<Integer, HotFix>();
        for (HotFix hotFix : hotFixes) {
            if (hotFix.getHotFixName().equals(SECURITY_FIX)) {
                hotFix.setSecurityFixSequence(10);
                hotFix.setSecurityFix(true);
            }
            if (!hotFix.isSecurityFix()) continue;
            securityFixList.put(hotFix.getSecurityFixSequence(), hotFix);
        }
        ArrayList<ProductData> hotFixList = new ArrayList<ProductData>(hotFixes.size());
        hotFixList.addAll(hotFixes);
        HotFixPackages.moveSecurityFixes(securityFixList, hotFixList);
        return hotFixList;
    }

    private static void moveSecurityFixes(Map<Integer, HotFix> securityFixList, List<ProductData> productList) {
        if (securityFixList.isEmpty()) {
            return;
        }
        for (Integer securityFixSeq : securityFixList.keySet()) {
            HotFix securityFix = securityFixList.get(securityFixSeq);
            int securityFixIndex = productList.indexOf(securityFix);
            int lastIndex = productList.size() - 1;
            if (securityFixIndex == -1 || securityFixIndex >= lastIndex) continue;
            productList.remove(securityFixIndex);
            productList.add(securityFix);
        }
    }

    public static String getExtractLocation(String location) {
        if (extractLocation == null) {
            extractLocation = Utils.joinPath(location, "hotfixes", "extracted");
            if (Utils.getOS() == 8) {
                String hotFixSubDir = Utils.joinPath("InstallMisc", "hotfixes");
                extractLocation = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), hotFixSubDir, "extracted");
            }
        }
        return extractLocation;
    }

    public static void extractProductDataForConfigOnlyHotFixes(String sdmHome) {
        for (ProductData productData : Globals.g_configurableHotFixes) {
            if (!((HotFix)productData).isConfigurationDataOnly()) continue;
            String extractLocation = Utils.joinPath(sdmHome, "hot_fix");
            Logging.log.info("Extracting config data only hot fix: " + ((HotFix)productData).getHotFixName() + " from container " + ((HotFix)productData).getContainerId() + " to " + extractLocation);
            ((HotFix)productData).extractHotFix(extractLocation);
        }
    }

    public List<HotFix> getHotFixesRequiringInitRestart() {
        return this.hotFixesRequiringInitRestart;
    }
}

