/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixContainer;
import com.sas.ssn.HotFixIndexData;
import com.sas.ssn.Logging;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.DeploymentXMLReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HotFixPackageData {
    private RegistryAccess registryAccess = null;
    private File hotFixPackageFile = null;
    private List<HotFix> installableHotFixPackages = new ArrayList<HotFix>();
    private List<HotFix> configurableHotFixPackages = new ArrayList<HotFix>();
    HotFixContainer hotFixContainer = null;
    private String[] installHosts = null;
    private boolean atLeastOneHotFixValidForHost = false;
    private static final String ZOS_MVS = "mvs";
    private static final String ZOS_Z64 = "z64";
    private static Map<String, File> manifestFiles = new HashMap<String, File>();

    public HotFixPackageData(File hotFixPackage) {
        this.hotFixPackageFile = hotFixPackage;
    }

    public boolean loadHotFixPackage(HotFixIndexData hotFixIndexData, boolean emptySASHome) {
        boolean atLeastOneHotFix = false;
        String hotFixDataDirectory = null;
        HashSet<String> skus = new HashSet<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.hotFixPackageFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.log.warning("Error loading hot fix package file: " + this.hotFixPackageFile.getAbsolutePath());
            return false;
        }
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.isDirectory()) continue;
            File zipEntryDir = new File(zipEntry.getName());
            String parentDir = zipEntryDir.getParent();
            if (parentDir != null && parentDir.equalsIgnoreCase("product_data")) {
                skus.add(zipEntryDir.getName());
                continue;
            }
            if (parentDir == null || !parentDir.equalsIgnoreCase("hot_fix_data")) continue;
            hotFixDataDirectory = zipEntryDir.getName();
        }
        String key = "";
        if (hotFixDataDirectory != null) {
            key = "hot_fix_data/" + hotFixDataDirectory + "/manifest.xml";
            ZipEntry manifestXml = zipFile.getEntry(key);
            try {
                this.hotFixContainer = new HotFixContainer(zipFile.getInputStream(manifestXml));
                HotFixPackageData.extractManifest(manifestXml, zipFile, this.hotFixContainer.getContainerId());
            }
            catch (IOException e) {
                Logging.log.severe("Error extracting manifest file " + key + " from the zip file " + zipFile.getName());
                Logging.logStackTrace(e);
            }
        }
        for (String sku : skus) {
            key = "product_data/" + sku + "/product.xml";
            HotFix hotFix = null;
            ZipEntry productXmlEntry = zipFile.getEntry(key);
            if (productXmlEntry == null) {
                Logging.log.severe("Could not find product.xml, skipping sku: " + key);
                continue;
            }
            SpsSkuData spsSkuData = null;
            try {
                spsSkuData = new SpsSkuData(zipFile.getInputStream(productXmlEntry));
            }
            catch (IOException e) {
                Logging.log.severe("Read error while loading product.xml for: " + productXmlEntry.getName() + ", skipping sku: " + key);
                Logging.logStackTrace(e);
                continue;
            }
            catch (ParserConfigurationException e) {
                Logging.log.severe("Parsing error while loading product.xml for: " + productXmlEntry.getName() + ", skipping sku: " + key);
                Logging.logStackTrace(e);
                continue;
            }
            catch (SAXException e) {
                Logging.log.severe("Parsing(SAX) error while loading product.xml for: " + productXmlEntry.getName() + ", skipping sku: " + key);
                Logging.logStackTrace(e);
                continue;
            }
            key = "product_data/" + sku + "/deployment.xml";
            ZipEntry deploymentXmlEntry = zipFile.getEntry(key);
            DeploymentXMLReader deploymentXmlData = null;
            if (deploymentXmlEntry != null) {
                try {
                    deploymentXmlData = new DeploymentXMLReader(zipFile.getInputStream(deploymentXmlEntry));
                }
                catch (JAXBException e) {
                    Logging.log.severe("Parsing error while loading deployment.xml for: " + deploymentXmlEntry.getName() + ", skipping sku: " + key);
                    Logging.logStackTrace(e);
                    continue;
                }
                catch (IOException e) {
                    Logging.log.severe("Read error while loading deployment.xml for: " + deploymentXmlEntry.getName() + ", skipping sku: " + key);
                    Logging.logStackTrace(e);
                    continue;
                }
            }
            atLeastOneHotFix = true;
            String platform = HotFixPackageData.getPlatformToDeploy(spsSkuData.getPlatform());
            if (!emptySASHome) {
                if (this.isPlatformValid(platform)) {
                    if (!hotFixIndexData.getSecurityFix()) {
                        this.atLeastOneHotFixValidForHost = true;
                    }
                } else {
                    Logging.log.info("Skipping hot fix sku " + sku + " in hot fix package " + this.hotFixPackageFile.getAbsolutePath() + " with a platform value of " + platform + " because it is not applicable for this host.");
                    continue;
                }
            }
            if (Utils.getOS_Suffix() == ZOS_MVS && !this.isMVSPlatformValid(spsSkuData.getPlatform())) {
                String mvsHostMsg = null;
                mvsHostMsg = Globals.g_z64 ? "z/OS (64-bit)" : "z/OS (31-bit)";
                Logging.log.info("Skipping hot fix sku " + sku + " in hot fix package " + this.hotFixPackageFile.getAbsolutePath() + " with a platform value of " + spsSkuData.getPlatform() + " because it is not applicable for the selected z/OS platform: " + mvsHostMsg);
                continue;
            }
            hotFix = HotFixPackageData.constructHotFixObject(this.hotFixContainer, spsSkuData, deploymentXmlData, platform, hotFixIndexData.getHotFixPackageFilename(), this.hotFixPackageFile, hotFixIndexData.forceDuringUpdate(), hotFixIndexData.forceOnlyInChain(), hotFixIndexData.getSecurityFix());
            hotFix.setDisplayName(hotFixIndexData.getDisplayName());
            hotFix.setiDoc(hotFixIndexData.getIdoc());
            hotFix.setDisplayVersion(hotFixIndexData.getDisplayVersion());
            hotFix.setReleaseDate(hotFixIndexData.getReleaseDate());
            hotFix.setDocFilename(hotFixIndexData.getDocFilename(platform));
            hotFix.setHotFixID(hotFixIndexData.getHotFixPackageIdentifier());
            if (hotFix.isConfigurable()) {
                this.configurableHotFixPackages.add(hotFix);
            }
            if (hotFix.isInstallable()) {
                this.installableHotFixPackages.add(hotFix);
            }
            Logging.log.info("Loading hot fix data: " + hotFix.getProdNameExtended() + ", from package: " + this.hotFixPackageFile.getAbsolutePath());
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            Logging.log.warning("Error closing hot fix package file: " + zipFile.getName());
            Logging.logStackTrace(e);
        }
        if (!atLeastOneHotFix) {
            Logging.log.warning("There were no valid hot fixes in the hot fix package: " + this.hotFixPackageFile.getAbsolutePath());
        }
        return atLeastOneHotFix;
    }

    public List<HotFix> getInstallableHotFixes() {
        return this.installableHotFixPackages;
    }

    public List<HotFix> getConfigurableHotFixes() {
        return this.configurableHotFixPackages;
    }

    public boolean isAtLeastOneHotFixValidForHost() {
        return this.atLeastOneHotFixValidForHost;
    }

    public static HotFix constructHotFixObject(HotFixContainer hotFixContainer, SpsSkuData spsSkuData, DeploymentXMLReader deploymentXmlData, String platform) {
        return HotFixPackageData.constructHotFixObject(hotFixContainer, spsSkuData, deploymentXmlData, platform, null, null, false, false, false);
    }

    public static HotFix constructHotFixObject(HotFixContainer hotFixContainer, SpsSkuData spsSkuData, DeploymentXMLReader deploymentXmlData, String platform, String hotFixPackageFilename, File hotFixPackageFile, boolean forceDuringUpdate, boolean forceOnlyInChain, boolean securityFix) {
        String product = spsSkuData.getProdCode();
        String sku = spsSkuData.getSpsSku();
        HotFix hotFix = new HotFix(product, sku, platform, spsSkuData.getDisplayVer("en"), spsSkuData.getCustomerVer("en"), spsSkuData.getMaintLevel(), spsSkuData.getLastPortDate(), spsSkuData.getSASRelease(), spsSkuData.getDisplayName("en"), 4, 0, 0, false, "", "", "", "", "", false, false, false, false, false, "", "", 0L);
        String hotFixName = null;
        int securityFixSequence = 0;
        boolean isSecurityFix = securityFix;
        if (deploymentXmlData != null) {
            hotFixName = deploymentXmlData.getHotFixName();
            hotFix.setHotFixMinMaintVersion(deploymentXmlData.getHotFixMinMaintVersion());
            hotFix.setHotFixMaxMaintVersion(deploymentXmlData.getHotFixMaxMaintVersion());
            hotFix.setHotFixMaintVerExclusive(deploymentXmlData.isHotFixMaintVersionExclusive());
            isSecurityFix = deploymentXmlData.getHotFixSecurityFix();
            securityFixSequence = deploymentXmlData.getHotFixSecuritySequence();
            if (deploymentXmlData.isToolingRestartRequiredBeforeApplying()) {
                hotFix.initRestartRequired(true);
            }
        }
        if (hotFixContainer != null) {
            if (hotFixName == null) {
                hotFixName = hotFixContainer.getMemberIdForSku(sku);
            }
            hotFix.setContainerId(hotFixContainer.getContainerId());
            hotFix.setConfigurable(hotFixContainer.isHotFixConfigurable(hotFixName));
            if (hotFixContainer.isHotFixConfigureDataOnly(hotFixName)) {
                hotFix.setInstallable(false);
            }
            if (hotFixContainer.isUpdatePaired(hotFixName)) {
                hotFix.setPairedInstallHotFixName(hotFixContainer.getInstallUpdate(hotFixName));
                hotFix.setPairedConfigureHotFixName(hotFixContainer.getConfigUpdate(hotFixName));
            }
        }
        hotFix.setHotFixName(hotFixName);
        hotFix.setHotFixPackageFilename(hotFixPackageFilename);
        hotFix.setHotFixPackageFile(hotFixPackageFile);
        hotFix.setSpsSkuData(spsSkuData);
        hotFix.setType(4);
        hotFix.setForceDuringUpdate(forceDuringUpdate);
        hotFix.setForceOnlyInChain(forceOnlyInChain);
        hotFix.setSecurityFix(isSecurityFix);
        if (isSecurityFix) {
            hotFix.setSecurityFixSequence(securityFixSequence);
        }
        return hotFix;
    }

    public static String getPlatformToDeploy(String hotFixPlatform) {
        String platform = null;
        platform = "prt".equalsIgnoreCase(hotFixPlatform) ? Utils.getOS_Suffix() : hotFixPlatform;
        return platform;
    }

    private static boolean extractManifest(ZipEntry manifestXml, ZipFile zipFile, String containerId) {
        String extractLocation = Utils.joinPath(Globals.g_tempLocation, "hotfixes");
        File manifestXmlFile = new File(manifestXml.getName());
        File outputFile = Utils.extractFileFromZip(zipFile, manifestXmlFile, extractLocation);
        if (outputFile == null) {
            Logging.log.severe("An error occurred while extracting " + manifestXmlFile.getPath() + " from " + zipFile.getName() + " to " + extractLocation);
            return false;
        }
        manifestFiles.put(containerId, outputFile);
        return true;
    }

    private boolean isPlatformValid(String hostToCheck) {
        if (this.installHosts == null) {
            this.getInstallHosts();
        }
        if (this.installHosts != null) {
            for (String host : this.installHosts) {
                if (!host.equalsIgnoreCase(hostToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMVSPlatformValid(String platformToCheck) {
        String mvsPlatform = ZOS_MVS;
        if (Globals.g_z64) {
            mvsPlatform = ZOS_Z64;
        }
        if (platformToCheck.equalsIgnoreCase(ZOS_MVS) || platformToCheck.equalsIgnoreCase(ZOS_Z64)) {
            return mvsPlatform.equalsIgnoreCase(platformToCheck);
        }
        return true;
    }

    private void getInstallHosts() {
        if (this.getDeploymentRegistryAccess()) {
            this.installHosts = this.registryAccess.getInstallHosts();
        }
        if (this.registryAccess != null) {
            this.registryAccess.close();
        }
    }

    private boolean getDeploymentRegistryAccess() {
        try {
            RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
            this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (!this.registryAccess.open()) {
                Logging.log.warning("Unable to open deployment registry for hot fix processing: " + RegistryData.getDeployRegJar());
                return false;
            }
        }
        catch (FileNotFoundException e) {
            Logging.logStackTrace(e);
            Logging.log.warning("Unable to open deployment registry for hot fix processing: file not found: " + RegistryData.getDeployRegJar());
            return false;
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            Logging.log.warning("Unable to open deployment registry for hot fix processing: general error: " + RegistryData.getDeployRegJar());
            return false;
        }
        return true;
    }

    public static void copyHotFixManifests(String sdmHome) {
        String hotFixDataDir = Utils.joinPath(sdmHome, "hot_fix", "hot_fix_data");
        for (String containerId : manifestFiles.keySet()) {
            File source = manifestFiles.get(containerId);
            File targetDir = new File(hotFixDataDir, containerId);
            targetDir.mkdirs();
            File target = new File(targetDir, "manifest.xml");
            Logging.log.info("Copy hot fix container manifest: source: " + source.getAbsolutePath() + " target: " + target.getAbsolutePath());
            Utils.copyFile(source, target);
        }
    }
}

