/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFixIndex;
import com.sas.ssn.HotFixIndexData;
import com.sas.ssn.HotFixIndexException;
import com.sas.ssn.HotFixManagerException;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HotFixManager {
    private SSNResource bundle = new SSNResource(HotFixManager.class);
    private static final String hotFixSubDirectory = "hot_fix";
    private static final String securityHotFixSubDirectory = "InstallMisc/HotFixes/SecurityUpdates";
    private static final String hotFixDownloadDataSubDir = "download_data";
    private static final String hotFixIndexFilename = "hot_fix_index.xml";
    HotFixIndex hotFixIndex = null;
    private List<HotFixIndexData> hotFixesForOrder = new ArrayList<HotFixIndexData>();
    private List<String> hotFixesToDownload = null;
    private String hotFixDirectory = "";
    private String orderToProcess = "";
    public static final String postInstallHotFixesOrder = "postInstallHotFixes";
    public static final String postInstallHotFixIndexFilename = "hot_fix_post_install_index.xml";
    public static final String postInstallSecurityHotFixIndexFilename = "security_hot_fix_post_install_index.xml";

    public HotFixManager(String ssdDir, String order) throws HotFixManagerException {
        this.hotFixDirectory = Utils.joinPath(ssdDir, hotFixSubDirectory);
        this.orderToProcess = order;
        File indexFile = HotFixManager.findIndexFile(this.hotFixDirectory, this.orderToProcess);
        if (indexFile != null) {
            this.hotFixIndex = this.getHotFixIndex(indexFile);
        }
    }

    public HotFixManager(String order, String hotFixPackagesDirectory, String hotFixIndexFilename) throws HotFixManagerException {
        this.hotFixDirectory = hotFixPackagesDirectory;
        this.orderToProcess = order;
        this.hotFixIndex = this.getHotFixIndex(new File(this.hotFixDirectory, hotFixIndexFilename));
    }

    private HotFixIndex getHotFixIndex(File hotFixIndexFile) throws HotFixManagerException {
        HotFixIndex hFIfile = null;
        try {
            hFIfile = new HotFixIndex(hotFixIndexFile);
        }
        catch (HotFixIndexException e) {
            Logging.log.warning("An error occurred opening hot fix index file " + hotFixIndexFile);
            Logging.log.warning(e.getLogMessage());
            throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorOpeningHotFixIndex.txt", hotFixIndexFile));
        }
        return hFIfile;
    }

    public static File findIndexFile(String hotfixdir, String order) {
        File indexFile = null;
        File indexFilePerOrder = new File(Utils.joinPaths(hotfixdir, "index", order, hotFixIndexFilename));
        File indexFileAllInOne = new File(hotfixdir, hotFixIndexFilename);
        indexFile = indexFilePerOrder.exists() ? indexFilePerOrder : (indexFileAllInOne.exists() ? indexFileAllInOne : (Globals.g_onlydownloadhotfixes ? indexFilePerOrder : indexFileAllInOne));
        return indexFile;
    }

    public void setHotFixes(List<HotFixIndexData> hotFixes) {
        this.hotFixesForOrder.clear();
        this.hotFixesForOrder.addAll(hotFixes);
    }

    public List<HotFixIndexData> getHotFixes() {
        return this.hotFixesForOrder;
    }

    public List<String> missingHotFixes() {
        this.hotFixesToDownload = new ArrayList<String>();
        File hotFixPackageFile = null;
        for (HotFixIndexData hotFixData : this.hotFixesForOrder) {
            String hotFixPackage = hotFixData.getHotFixPackageFilename();
            hotFixPackageFile = new File(this.hotFixDirectory, hotFixPackage);
            String identifier = hotFixData.getHotFixPackageIdentifier();
            if (this.hotFixIndex.getOrderIdsForPackage(hotFixPackage).isEmpty()) {
                this.hotFixesToDownload.add(hotFixPackage);
                continue;
            }
            if ("w83001".equalsIgnoreCase(identifier) || hotFixData.getSecurityFix()) {
                this.hotFixesToDownload.add(hotFixPackage);
                continue;
            }
            if (hotFixPackageFile.exists()) continue;
            this.hotFixesToDownload.add(hotFixPackage);
        }
        return this.hotFixesToDownload;
    }

    public void commitHotFixes(String sourceDirectory, String hotFixDownloadDataFilePath) throws Exception {
        this.commitHotFixes(sourceDirectory, true, hotFixDownloadDataFilePath);
    }

    private void commitHotFixes(String sourceDirectory, boolean move, String hotFixDownloadDataFilePath) throws HotFixManagerException {
        File hotFixDownloadDataFile;
        File hotFixDownloadDataDir = new File(this.hotFixDirectory, hotFixDownloadDataSubDir);
        if (!hotFixDownloadDataDir.exists()) {
            hotFixDownloadDataDir.mkdirs();
        }
        if ((hotFixDownloadDataFile = new File(hotFixDownloadDataFilePath)).exists()) {
            File target = new File(hotFixDownloadDataDir, hotFixDownloadDataFile.getName());
            if (Utils.copyFile(hotFixDownloadDataFile, target) == -1) {
                Logging.log.warning("Unable to copy hot fix download data file from: " + hotFixDownloadDataFile.getAbsolutePath() + " to: " + target.getAbsolutePath());
            }
        } else {
            Logging.log.warning("Hot fix download data file not found: " + hotFixDownloadDataFile.getAbsolutePath());
        }
        this.hotFixIndex.addOrder(this.orderToProcess);
        this.hotFixIndex.setHotFixesInactive(this.orderToProcess);
        for (HotFixIndexData hotFixData : this.hotFixesForOrder) {
            String hotFixPackage = hotFixData.getHotFixPackageFilename();
            if (this.hotFixIndex.isHotFixPackageFileInOrder(this.orderToProcess, hotFixPackage)) {
                this.hotFixIndex.setHotFixActive(this.orderToProcess, hotFixPackage);
            } else {
                this.hotFixIndex.addHotFixPackageDataForOrder(this.orderToProcess, hotFixData);
                this.hotFixIndex.setHotFixActive(this.orderToProcess, hotFixPackage);
            }
            this.hotFixIndex.refreshHotFixData(this.orderToProcess, hotFixPackage, hotFixData.getPackageChecksum(), hotFixData.getSizeOfPackage());
            if (this.hotFixesToDownload != null && !this.hotFixesToDownload.contains(hotFixPackage)) continue;
            File source = new File(sourceDirectory, hotFixPackage);
            if (source.exists()) {
                File target = new File(this.hotFixDirectory, hotFixPackage);
                if (move && !Utils.movefilesWithRetry(source, target)) {
                    Logging.log.warning("An error occurred while moving a hot fix package:  source location=" + source.getAbsolutePath() + "  destination location=" + target.getAbsolutePath());
                    throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorMovingHotFixPackage.txt", source.getAbsolutePath(), target.getAbsolutePath()));
                }
                if (!move && Utils.copyFile(source, target) == -1) {
                    Logging.log.warning("An error occurred while copying a hot fix package:  source location=" + source.getAbsolutePath() + "  destination location=" + target.getAbsolutePath());
                    throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorCopyingHotFixPackage.txt", source.getAbsolutePath(), target.getAbsolutePath()));
                }
                if (!hotFixData.getIdoc()) continue;
                for (String host : hotFixData.getDocs().keySet()) {
                    String docfn = hotFixData.getDocFilename(host);
                    source = new File(sourceDirectory, docfn);
                    target = new File(this.hotFixDirectory, docfn);
                    if (move && !Utils.movefilesWithRetry(source, target)) {
                        Logging.log.warning("An error occurred while moving a hot fix doc:  source location=" + source.getAbsolutePath() + "  destination location=" + target.getAbsolutePath());
                        throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorMovingHotFixPackage.txt", source.getAbsolutePath(), target.getAbsolutePath()));
                    }
                    if (move || Utils.copyFile(source, target) != -1) continue;
                    Logging.log.warning("An error occurred while copying a hot fix doc:  source location=" + source.getAbsolutePath() + "  destination location=" + target.getAbsolutePath());
                    throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorCopyingHotFixPackage.txt", source.getAbsolutePath(), target.getAbsolutePath()));
                }
                continue;
            }
            Logging.log.warning("Hot fix package file not found in staging directory: " + source.getAbsolutePath());
        }
        try {
            this.hotFixIndex.writeDataToFile();
        }
        catch (HotFixIndexException e) {
            Logging.log.warning("An error occurred writing hot fix index file " + e.getPath());
            Logging.log.warning(e.getLogMessage());
            throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorWritingHotFixIndex.txt", e.getPath()));
        }
    }

    public void copyHotFixes(String sourceHotFixDirectory, String sourceOrder, String hotFixDownloadDataFile) throws HotFixManagerException {
        HotFixIndex sourceHotFixIndex = null;
        File indexFile = HotFixManager.findIndexFile(sourceHotFixDirectory, sourceOrder);
        if (indexFile != null) {
            sourceHotFixIndex = this.getHotFixIndex(indexFile);
        }
        this.setHotFixes(sourceHotFixIndex.getAllHotFixPackagesForOrder(sourceOrder));
        this.missingHotFixes();
        try {
            this.commitHotFixes(sourceHotFixDirectory, false, hotFixDownloadDataFile);
        }
        catch (HotFixManagerException e) {
            Logging.log.warning("An error occurred copying hot fixes from " + sourceHotFixDirectory + " to " + this.hotFixDirectory);
            Logging.log.warning(e.getMessage());
            Logging.logStackTrace(e);
            throw new HotFixManagerException(this.bundle.messageString("HotFixManager.ErrorCopyingHotFixPackages.txt", sourceHotFixDirectory, this.hotFixDirectory));
        }
    }

    public boolean createIndexFromHotFixPackageDirectory() {
        File hotFixDir = new File(this.hotFixDirectory);
        class ZipFilter
        implements FileFilter {
            ZipFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".zip");
            }
        }
        File[] hotFixPackageFiles = hotFixDir.listFiles(new ZipFilter());
        if (hotFixPackageFiles == null) {
            Logging.log.warning("There are no files in the hot fix package directory: " + this.hotFixDirectory);
            return false;
        }
        this.hotFixIndex.addOrder(this.orderToProcess);
        for (File hotFixPkgFile : hotFixPackageFiles) {
            this.hotFixIndex.addHotFixPackageFileForOrder(this.orderToProcess, hotFixPkgFile.getName());
            this.hotFixIndex.setHotFixActive(this.orderToProcess, hotFixPkgFile.getName());
        }
        return true;
    }

    public boolean createIndexFromSecurityHotFixPackageDirectory() {
        File hotFixDir = new File(this.hotFixDirectory);
        class ZipFilter
        implements FileFilter {
            ZipFilter() {
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".zip");
            }
        }
        File[] hotFixPackageFiles = hotFixDir.listFiles(new ZipFilter());
        if (hotFixPackageFiles == null) {
            Logging.log.warning("There are no files in the hot fix package directory: " + this.hotFixDirectory);
            return false;
        }
        this.hotFixIndex.addOrder(this.orderToProcess);
        HashMap<String, File> packages = new HashMap<String, File>(2);
        for (File hotFixPkgFile : hotFixPackageFiles) {
            String fileName = hotFixPkgFile.getName().toLowerCase(Locale.ENGLISH);
            if (fileName.length() < 6) {
                Logging.log.warning(fileName + " is not a valid named security update, update will be skipped.");
                continue;
            }
            String key = fileName.substring(0, 3);
            if (packages.containsKey(key)) {
                File previousFile = (File)packages.get(key);
                String previousFileName = previousFile.getName().toLowerCase(Locale.ENGLISH);
                if (previousFileName.compareTo(fileName) >= 0) continue;
                packages.put(key, hotFixPkgFile);
                continue;
            }
            packages.put(key, hotFixPkgFile);
        }
        for (Map.Entry entry : packages.entrySet()) {
            String hotFixPkgName = ((File)entry.getValue()).getName();
            this.hotFixIndex.addHotFixPackageFileForOrder(this.orderToProcess, hotFixPkgName);
            this.hotFixIndex.setHotFixActive(this.orderToProcess, hotFixPkgName);
        }
        return true;
    }

    public HotFixIndex getHotFixIndex() {
        return this.hotFixIndex;
    }

    public static String getHotFixSubDir() {
        return hotFixSubDirectory;
    }

    public static String getHotFixDownloadDataSubDir() {
        return hotFixDownloadDataSubDir;
    }

    public static String getSecurityHotFixSubDirectory() {
        return securityHotFixSubDirectory;
    }
}

