/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class HotFixInstructions {
    private static String HOTFIX_INSTRUCTIONS_FILE = "HotFixInstructions.html";
    private String hotFixDocDir = "";
    private String hotFixInstructionsDir = "";
    private String hotFixInstructionsPath = "";
    private String hotFixInstructionsBackupDir = "";
    private static String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
    private static boolean fileCreated = false;
    private boolean valid = false;

    public HotFixInstructions() {
        this.setHotFixDirs();
        this.createHotFixDirs();
    }

    private void setHotFixDirs() {
        String startingPoint = Utils.joinPath(sasHome, "InstallMisc", "HotFixes");
        this.hotFixDocDir = Utils.joinPath(startingPoint, "Documents");
        this.hotFixInstructionsPath = Utils.joinPath(this.hotFixDocDir, HOTFIX_INSTRUCTIONS_FILE);
        this.hotFixInstructionsBackupDir = Utils.joinPath(this.hotFixDocDir, "Backup");
        this.hotFixInstructionsDir = Utils.joinPath(this.hotFixDocDir, "Instructions");
    }

    private void createHotFixDirs() {
        File dir = new File(this.hotFixDocDir);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            Logging.log.severe("Unable to create hot fix instructions directory: " + this.hotFixDocDir);
            return;
        }
        dir = new File(this.hotFixInstructionsBackupDir);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            Logging.log.severe("Unable to create hot fix instructions backup directory: " + this.hotFixInstructionsBackupDir);
            return;
        }
        dir = new File(this.hotFixInstructionsDir);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            Logging.log.severe("Unable to create hot fix documents directory: " + this.hotFixInstructionsDir);
            return;
        }
        this.valid = true;
    }

    public String getHotFixInstructionsDir() {
        return this.hotFixInstructionsDir;
    }

    public String getHotFixInstructionsPath() {
        return this.hotFixInstructionsPath;
    }

    public boolean writeInstructionsFile() {
        if (fileCreated) {
            return true;
        }
        if (!this.valid) {
            return false;
        }
        if (Globals.g_hotFixesInChainWithCustomDoc == null) {
            Logging.log.warning("No hot fixes with custom docs in install chain");
            return false;
        }
        HashMap<String, String> tableRows = new HashMap<String, String>(Globals.g_hotFixesInChainWithCustomDoc.size());
        this.createTableRows(tableRows);
        try {
            File instructionsFile = new File(this.getHotFixInstructionsPath());
            String displayFormat = "yyyy MMM dd HH:mm";
            String displayTimeStamp = new SimpleDateFormat(displayFormat).format(new Date());
            String backupFormat = "yyyy-MM-dd-HH.mm";
            String backupTimeStamp = new SimpleDateFormat(backupFormat).format(new Date());
            if (instructionsFile.exists()) {
                this.backupFile(instructionsFile, backupTimeStamp);
            }
            FileOutputStream output = new FileOutputStream(instructionsFile);
            PrintStream content = new PrintStream((OutputStream)output, false, "UTF-8");
            this.createContent(tableRows, displayTimeStamp, content);
            content.flush();
            content.close();
            fileCreated = true;
        }
        catch (Exception e) {
            Logging.log.severe("There is a problem creating the hot fix instructions file");
            Logging.log.severe(e.getMessage());
            return false;
        }
        return true;
    }

    private void createTableRows(HashMap<String, String> tableRows) {
        for (HotFix hotFix : Globals.g_hotFixesInChainWithCustomDoc) {
            String released = hotFix.getReleaseDate();
            String displayName = hotFix.getDisplayNamePlusPlatform();
            String idocName = hotFix.getDocFilename();
            String hfId = hotFix.getHotFixID();
            String prodDocPath = Utils.joinPath(this.hotFixInstructionsDir, idocName);
            String href = "<a href=\"" + prodDocPath + "\">" + idocName + "</a>";
            String row = String.format("<tr>\n<td>%s</td>\n<td>%s</td>\n<td>%s</td>\n<td>%s</td>\n</tr>", displayName, hfId, released, href);
            if (tableRows.containsKey(prodDocPath)) continue;
            tableRows.put(prodDocPath, row);
        }
    }

    private void createContent(HashMap<String, String> tableRows, String timeStamp, PrintStream content) {
        if (content != null) {
            content.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
            content.println("<HTML>");
            content.println("<head>");
            content.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            content.println("<style>");
            content.println("table, th, td {");
            content.println("border: 1px solid black;");
            content.println("border-collapse: collapse;");
            content.println("}");
            content.println("th, td {");
            content.println("padding: 15px;");
            content.println("text-align: left");
            content.println("}");
            content.println("</style>");
            content.println("</head>");
            content.println("<BODY>");
            content.println("<h1 align=\"center\">SAS Hot Fix Post-Installation Instructions</h1>");
            content.println("<h3>Date: " + timeStamp + "</h3>");
            content.println("<p>The following hot fixes have post-installation instructions that are not performed by the deployment process and must be performed by the user. Click on the documentation links to see the specific instructions for each hot fix. If the table is empty, there are no hot fixes requiring manual post-installation steps.</p>");
            content.println("<br>");
            content.println("<table width=\"100%\">");
            content.println("<thead>");
            content.println("<tr>");
            content.println("<th>Product</th>");
            content.println("<th>Hot Fix</th>");
            content.println("<th>Released</th>");
            content.println("<th>Documentation</th>");
            content.println("</tr>");
            content.println("</thead>");
            content.println("<tbody>");
            for (String key : tableRows.keySet()) {
                content.println(tableRows.get(key));
            }
            content.println("</tbody>");
            content.println("</table>");
            content.println("</body>");
            content.println("</html>");
        }
    }

    private void backupFile(File newFile, String timeStamp) {
        File backupDir = new File(this.hotFixInstructionsBackupDir);
        String backupName = Utils.joinPath(backupDir.getAbsolutePath(), newFile.getName() + "_" + timeStamp + ".bak");
        File backup = new File(backupName);
        Utils.copyFile(newFile, backup);
        newFile.delete();
    }
}

