/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.HotFixIndexData;
import com.sas.ssn.HotFixIndexException;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import com.sas.ssn.schema.hotfix.gen.Doc;
import com.sas.ssn.schema.hotfix.gen.Docs;
import com.sas.ssn.schema.hotfix.gen.HotFixPackage;
import com.sas.ssn.schema.hotfix.gen.HotFixPackagesIndex;
import com.sas.ssn.schema.hotfix.gen.Order;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

public class HotFixIndex {
    private HotFixPackagesIndex hotFixPackagesIndex = null;
    private File indexFile = null;
    private static Unmarshaller hotfixIndexUnmarshaller = null;

    private static Unmarshaller getHotFixIndexUnmarshaller() throws JAXBException {
        if (hotfixIndexUnmarshaller == null) {
            JAXBContext jc = JAXBContext.newInstance("com.sas.ssn.schema.hotfix.gen", HotFixIndex.class.getClassLoader());
            hotfixIndexUnmarshaller = jc.createUnmarshaller();
        }
        return hotfixIndexUnmarshaller;
    }

    public HotFixIndex(File hotFixIndexFile) throws HotFixIndexException {
        this.indexFile = hotFixIndexFile;
        if (this.indexFile.exists()) {
            try {
                JAXBElement<HotFixPackagesIndex> hotFixPackagesIndexJAXB = HotFixIndex.getHotFixIndexUnmarshaller().unmarshal(new StreamSource(this.indexFile), HotFixPackagesIndex.class);
                this.hotFixPackagesIndex = hotFixPackagesIndexJAXB.getValue();
            }
            catch (JAXBException e) {
                throw new HotFixIndexException("Error unmarshalling " + this.indexFile.getAbsolutePath(), e, this.indexFile.getAbsolutePath());
            }
        } else {
            this.hotFixPackagesIndex = new HotFixPackagesIndex();
        }
    }

    public HotFixIndex(String hotFixDirectory, String hotFixIndexFilename) throws HotFixIndexException {
        this(new File(hotFixDirectory, hotFixIndexFilename));
    }

    public void writeDataToFile() throws HotFixIndexException {
        File directory = this.indexFile.getParentFile();
        if (this.indexFile.exists()) {
            this.backupHotFixIndex(directory.getAbsolutePath(), this.indexFile.getName());
        } else if (!directory.exists() && !directory.mkdirs()) {
            throw new HotFixIndexException("Error creating directories " + directory.getAbsolutePath());
        }
        FileOutputStream outputStream = null;
        try {
            JAXBContext jc = JAXBContext.newInstance("com.sas.ssn.schema.hotfix.gen", this.getClass().getClassLoader());
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", "UTF-8");
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            outputStream = new FileOutputStream(this.indexFile.getAbsolutePath());
            m.marshal((Object)this.hotFixPackagesIndex, outputStream);
        }
        catch (JAXBException e) {
            throw new HotFixIndexException("Error writing " + this.indexFile.getAbsolutePath(), e, this.indexFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new HotFixIndexException("File not found " + this.indexFile.getAbsolutePath(), e, this.indexFile.getAbsolutePath());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    Logging.log.warning("Error closing " + this.indexFile.getAbsolutePath());
                    Logging.logStackTrace(e);
                }
            }
        }
    }

    private void backupHotFixIndex(String path, String filename) {
        File sourceFile = new File(path, filename);
        File backupFile = null;
        Integer extNum = 0;
        while (extNum < 1000) {
            backupFile = extNum < 10 ? new File(path, filename + ".00" + extNum.toString()) : (extNum < 100 ? new File(path, filename + ".0" + extNum.toString()) : new File(path, filename + "." + extNum.toString()));
            if (backupFile.exists()) {
                Integer n = extNum;
                Integer n2 = extNum = Integer.valueOf(extNum + 1);
                continue;
            }
            extNum = 1001;
            Utils.copyFile(sourceFile, backupFile);
        }
    }

    public List<String> getOrderIds() {
        ArrayList<String> orderIds = new ArrayList<String>();
        for (Order ord : this.getOrdersFromIndexFile()) {
            orderIds.add(ord.getId());
        }
        return orderIds;
    }

    public List<String> getOrderIdsForPackage(String hotFixPackage) {
        ArrayList<String> orderIds = new ArrayList<String>();
        for (Order ord : this.getOrdersFromIndexFile()) {
            if (!this.checkHotFixFromIndexFileForOrder(ord, hotFixPackage)) continue;
            orderIds.add(ord.getId());
        }
        return orderIds;
    }

    public boolean checkOrder(String order) {
        return this.getOrderFromIndexFileForOrder(order) != null;
    }

    public void addOrder(String order) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMMyyyy HH:mm:ss");
        Date date = new Date();
        String time = dateFormat.format(date.getTime());
        Order existingOrder = this.getOrderFromIndexFileForOrder(order);
        if (existingOrder == null) {
            Order newOrder = new Order();
            newOrder.setId(order);
            newOrder.setLastModified(time);
            this.getOrdersFromIndexFile().add(newOrder);
        } else {
            existingOrder.setLastModified(time);
        }
    }

    public void clearOrder(String order) {
        Order ord = this.getOrderFromIndexFileForOrder(order);
        if (ord != null) {
            this.getOrdersFromIndexFile().remove(ord);
        }
    }

    public List<String> getAllHotFixPackageFilenames() {
        HashSet<String> hotFixPackages = new HashSet<String>();
        for (Order ord : this.getOrdersFromIndexFile()) {
            for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(ord)) {
                hotFixPackages.add(hf.getPackageFile());
            }
        }
        return new ArrayList<String>(hotFixPackages);
    }

    public List<String> getAllHotFixPackageFilenamesForOrder(String order) {
        ArrayList<String> hotFixPackages = new ArrayList<String>();
        for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(this.getOrderFromIndexFileForOrder(order))) {
            hotFixPackages.add(hf.getPackageFile());
        }
        return hotFixPackages;
    }

    public List<HotFixIndexData> getAllHotFixPackagesForOrder(String order) {
        ArrayList<HotFixIndexData> hotFixIndexData = new ArrayList<HotFixIndexData>();
        for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(this.getOrderFromIndexFileForOrder(order))) {
            hotFixIndexData.add(this.getHotFixPackageForOrder(order, hf.getPackageFile()));
        }
        return hotFixIndexData;
    }

    public HotFixIndexData getHotFixPackageForOrder(String order, String hotFixPackageName) {
        HotFixIndexData hotFixIndexData = null;
        for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(this.getOrderFromIndexFileForOrder(order))) {
            if (!hf.getPackageFile().equalsIgnoreCase(hotFixPackageName)) continue;
            hotFixIndexData = new HotFixIndexData(hf.getId(), hf.getPackageFile(), hf.getChecksum(), hf.getSize(), hf.getExcludedSDWVersions(), hf.getDisplayname(), hf.getDisplayversion(), hf.getReleasedate());
            if (hf.isInstall() != null) {
                hotFixIndexData.setInstall(hf.isInstall());
            }
            if (hf.isActive() != null) {
                hotFixIndexData.setActive(hf.isActive());
            }
            if (hf.isForceuip() != null) {
                hotFixIndexData.setForceDuringUpdate(hf.isForceuip());
            }
            if (hf.isOnlyinchain() != null) {
                hotFixIndexData.setForceOnlyInChain(hf.isOnlyinchain());
            }
            if (hf.isSecurityfix() != null) {
                hotFixIndexData.setSecurityFix(hf.isSecurityfix());
            }
            if (hf.isIdoc() != null) {
                hotFixIndexData.setIdoc(hf.isIdoc());
                if (hf.isIdoc().booleanValue()) {
                    hotFixIndexData.setDisplayName(hf.getDisplayname());
                    hotFixIndexData.setDisplayVersion(hf.getDisplayversion());
                    hotFixIndexData.setReleaseDate(hf.getReleasedate());
                    String host = Utils.getOS_Suffix();
                    hotFixIndexData.getDocFilename(host);
                }
            }
            if (hf.getDocs() == null) break;
            for (Doc i : hf.getDocs().getDoc()) {
                hotFixIndexData.addDocs(i.getHost(), i.getUrl());
            }
        }
        return hotFixIndexData;
    }

    public boolean isHotFixPackageFileInOrder(String order, String hotFixPackage) {
        for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(this.getOrderFromIndexFileForOrder(order))) {
            if (!hf.getPackageFile().equalsIgnoreCase(hotFixPackage)) continue;
            return true;
        }
        return false;
    }

    public void addHotFixPackageFileForOrder(String order, String hotFixPackage) {
        HotFixIndexData hotFixData = new HotFixIndexData("", hotFixPackage, "", "", "", "", "", "");
        this.addHotFixPackageDataForOrder(order, hotFixData);
    }

    public void addHotFixPackageDataForOrder(String order, HotFixIndexData hotFix) {
        Order ord = this.getOrderFromIndexFileForOrder(order);
        if (ord != null && !this.checkHotFixFromIndexFileForOrder(ord, hotFix.getHotFixPackageFilename())) {
            HotFixPackage hf = new HotFixPackage();
            hf.setPackageFile(hotFix.getHotFixPackageFilename());
            hf.setId(hotFix.getHotFixPackageIdentifier());
            hf.setInstall(hotFix.install());
            hf.setForceuip(hotFix.forceDuringUpdate());
            hf.setOnlyinchain(hotFix.forceOnlyInChain());
            hf.setSecurityfix(hotFix.getSecurityFix());
            hf.setChecksum(hotFix.getPackageChecksum());
            hf.setSize(hotFix.getSizeOfPackage());
            hf.setIdoc(hotFix.getIdoc());
            hf.setDisplayname(hotFix.getDisplayName());
            hf.setDisplayversion(hotFix.getDisplayVersion());
            hf.setReleasedate(hotFix.getReleaseDate());
            String excludedVersions = hotFix.getExcludedSDWVersions();
            if (excludedVersions != null && !excludedVersions.equals("")) {
                hf.setExcludedSDWVersions(hotFix.getExcludedSDWVersions());
            }
            for (String host : hotFix.getDocs().keySet()) {
                Doc newdoc = new Doc();
                newdoc.setHost(host);
                newdoc.setUrl(hotFix.getDocUrl(host));
                if (hf.getDocs() == null) {
                    hf.setDocs(new Docs());
                }
                hf.getDocs().getDoc().add(newdoc);
            }
            ord.getHotFixPackage().add(hf);
        }
    }

    public List<String> getActiveHotFixePackageFilenamesForOrder(String order) {
        ArrayList<String> hotFixPackages = new ArrayList<String>();
        for (HotFixIndexData hotFix : this.getAllHotFixPackagesForOrder(order)) {
            if (!hotFix.isActive()) continue;
            hotFixPackages.add(hotFix.getHotFixPackageFilename());
        }
        return hotFixPackages;
    }

    public void setHotFixesInactive(String order) {
        Order ord = this.getOrderFromIndexFileForOrder(order);
        if (ord != null) {
            for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(ord)) {
                hf.setActive(false);
            }
        }
    }

    public void setHotFixActive(String order, String hotFixPackage) {
        HotFixPackage hf = this.getHotFixPackageFromIndexFile(order, hotFixPackage);
        if (hf != null) {
            hf.setActive(true);
        }
    }

    public void refreshHotFixData(String order, String hotFixPackage, String packageChecksum, String sizeOfPackage) {
        HotFixPackage hf = this.getHotFixPackageFromIndexFile(order, hotFixPackage);
        if (hf != null) {
            hf.setChecksum(packageChecksum);
            hf.setSize(sizeOfPackage);
        }
    }

    public boolean isHotFixInstallable(String order, String hotFixPackage) {
        boolean result = false;
        HotFixPackage hf = this.getHotFixPackageFromIndexFile(order, hotFixPackage);
        if (hf != null && hf.isInstall() != null) {
            result = hf.isInstall();
        }
        return result;
    }

    public boolean isSecurityFix(String order, String hotFixPackage) {
        boolean result = false;
        HotFixPackage hf = this.getHotFixPackageFromIndexFile(order, hotFixPackage);
        if (hf != null && hf.isSecurityfix() != null) {
            result = hf.isSecurityfix();
        }
        if (hf.getId().equals("W83001")) {
            result = true;
        }
        return result;
    }

    public boolean isHotFixExcludedForSDWVersion(String order, String hotFixPackage, String sdwVersion) {
        if (sdwVersion == null || sdwVersion.equals("")) {
            return false;
        }
        HotFixPackage hf = this.getHotFixPackageFromIndexFile(order, hotFixPackage);
        if (hf == null) {
            return false;
        }
        String excludedVersions = hf.getExcludedSDWVersions();
        if (excludedVersions == null || excludedVersions.equals("")) {
            return false;
        }
        List<String> excludedVersionList = Arrays.asList(excludedVersions.split(","));
        for (String excludedVersion : excludedVersionList) {
            if (!excludedVersion.equalsIgnoreCase(sdwVersion)) continue;
            return true;
        }
        return false;
    }

    private HotFixPackage getHotFixPackageFromIndexFile(String order, String hotFixPackageName) {
        for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(this.getOrderFromIndexFileForOrder(order))) {
            if (!hf.getPackageFile().equalsIgnoreCase(hotFixPackageName)) continue;
            return hf;
        }
        return null;
    }

    private List<Order> getOrdersFromIndexFile() {
        return this.hotFixPackagesIndex.getOrder();
    }

    private Order getOrderFromIndexFileForOrder(String order) {
        Order foundOrder = null;
        for (Order ord : this.getOrdersFromIndexFile()) {
            if (!ord.getId().equals(order)) continue;
            foundOrder = ord;
        }
        return foundOrder;
    }

    private List<HotFixPackage> getHotFixPackagesFromIndexFileForOrder(Order order) {
        List<HotFixPackage> hotfixes = new ArrayList<HotFixPackage>();
        if (order != null) {
            hotfixes = order.getHotFixPackage();
        }
        return hotfixes;
    }

    private boolean checkHotFixFromIndexFileForOrder(Order order, String hotFixPackage) {
        if (order != null) {
            for (HotFixPackage hf : this.getHotFixPackagesFromIndexFileForOrder(order)) {
                if (!hf.getPackageFile().equalsIgnoreCase(hotFixPackage)) continue;
                return true;
            }
        }
        return false;
    }
}

