/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.HotFixContainerException;
import com.sas.ssn.Logging;
import com.sas.ssn.schema.hotfix.package_manifest.gen.ContainerManifest;
import com.sas.ssn.schema.hotfix.package_manifest.gen.InstallAndConfigPair;
import com.sas.ssn.schema.hotfix.package_manifest.gen.InstallAndConfigPairs;
import com.sas.ssn.schema.hotfix.package_manifest.gen.Skus;
import com.sas.ssn.schema.hotfix.package_manifest.gen.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

public class HotFixContainer {
    private ContainerManifest hotFixContainerManifest = null;
    private String containerId = "";
    public static final String manifestDataSubDir = "hot_fix_data";
    public static final String manifestFilename = "manifest.xml";
    private static Unmarshaller manifestUnmarshaller = null;

    private static Unmarshaller getManifestUnmarshaller() throws JAXBException {
        if (manifestUnmarshaller == null) {
            JAXBContext jc = JAXBContext.newInstance("com.sas.ssn.schema.hotfix.package_manifest.gen", HotFixContainer.class.getClassLoader());
            manifestUnmarshaller = jc.createUnmarshaller();
        }
        return manifestUnmarshaller;
    }

    public HotFixContainer(File manifestFile) throws HotFixContainerException {
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            this.loadHotFixContainer(inputStream);
        }
        catch (HotFixContainerException e) {
            throw new HotFixContainerException("Error occurred while loading the manifest file: " + manifestFile.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            throw new HotFixContainerException("Manifest file does not exist: " + manifestFile.getAbsolutePath(), e);
        }
    }

    public HotFixContainer(InputStream inputStream) throws HotFixContainerException {
        try {
            this.loadHotFixContainer(inputStream);
        }
        catch (HotFixContainerException e) {
            throw new HotFixContainerException("Error occurred while loading hot fix container input stream", e);
        }
    }

    private void loadHotFixContainer(InputStream inputStream) throws HotFixContainerException {
        try {
            JAXBElement<ContainerManifest> containerManifestJAXB = HotFixContainer.getManifestUnmarshaller().unmarshal(new StreamSource(inputStream), ContainerManifest.class);
            this.hotFixContainerManifest = containerManifestJAXB.getValue();
            this.containerId = this.hotFixContainerManifest.getContainerId();
        }
        catch (JAXBException e) {
            throw new HotFixContainerException("Error unmarshalling ", e);
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            Logging.log.warning("Error occurred while closing input stream for hot fix container");
        }
    }

    @Deprecated
    public HotFixContainer(ContainerManifest hotFixContainerManifest) {
        this.hotFixContainerManifest = hotFixContainerManifest;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public boolean isHotFixConfigurable(String memberId) {
        Update hotFixMember = this.getHotFixMember(memberId);
        if (hotFixMember != null) {
            return hotFixMember.isConfig();
        }
        return false;
    }

    public boolean isHotFixConfigureDataOnly(String memberId) {
        Update hotFixMember = this.getHotFixMember(memberId);
        if (hotFixMember != null) {
            return hotFixMember.isConfigureDataOnly();
        }
        return false;
    }

    public String getInstallUpdate(String configUpdate) {
        InstallAndConfigPairs installAndConfigPairs = this.hotFixContainerManifest.getInstallAndConfigPairs();
        if (installAndConfigPairs != null) {
            for (InstallAndConfigPair installAndConfigPair : this.hotFixContainerManifest.getInstallAndConfigPairs().getInstallAndConfigPair()) {
                if (!configUpdate.equalsIgnoreCase(installAndConfigPair.getConfigUpdate())) continue;
                return installAndConfigPair.getInstallUpdate();
            }
        }
        return null;
    }

    public String getConfigUpdate(String installUpdate) {
        InstallAndConfigPairs installAndConfigPairs = this.hotFixContainerManifest.getInstallAndConfigPairs();
        if (installAndConfigPairs != null) {
            for (InstallAndConfigPair installAndConfigPair : this.hotFixContainerManifest.getInstallAndConfigPairs().getInstallAndConfigPair()) {
                if (!installUpdate.equalsIgnoreCase(installAndConfigPair.getInstallUpdate())) continue;
                return installAndConfigPair.getConfigUpdate();
            }
        }
        return null;
    }

    public boolean isUpdatePaired(String update) {
        InstallAndConfigPairs installAndConfigPairs = this.hotFixContainerManifest.getInstallAndConfigPairs();
        if (installAndConfigPairs != null) {
            for (InstallAndConfigPair installAndConfigPair : this.hotFixContainerManifest.getInstallAndConfigPairs().getInstallAndConfigPair()) {
                if (!update.equalsIgnoreCase(installAndConfigPair.getInstallUpdate()) && !update.equalsIgnoreCase(installAndConfigPair.getConfigUpdate())) continue;
                return true;
            }
        }
        return false;
    }

    public String getMemberIdForSku(String sku) {
        for (Update update : this.hotFixContainerManifest.getUpdate()) {
            Skus skus = update.getSkus();
            if (skus == null || !skus.getSku().contains(sku)) continue;
            return update.getId();
        }
        return null;
    }

    private Update getHotFixMember(String memberId) {
        for (Update update : this.hotFixContainerManifest.getUpdate()) {
            if (!memberId.equals(update.getId())) continue;
            return update;
        }
        return null;
    }
}

