/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanFactory;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.StandardDeploymentPlan;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class GetPlans {
    private Vector<String> planFileVector = new Vector();
    private final Map<String, StandardDeploymentPlan> planMap = new TreeMap<String, StandardDeploymentPlan>();
    private SortedSet<String> machineCounts = new TreeSet<String>();
    private SortedSet<String> uniquePlanKeySet = new TreeSet<String>();
    private SortedSet<String> sortByNameSet = new TreeSet<String>();

    public GetPlans(String stdDepPlansPath) {
        this.findPlanPaths(stdDepPlansPath);
        this.createStdPlanObjects();
    }

    private void findPlanPaths(String stdDepPlansPath) {
        File stdPlansRoot = new File(stdDepPlansPath);
        String[] allStdPlans = stdPlansRoot.list();
        int size = allStdPlans.length;
        File tmpFile = null;
        for (int i = 0; i < size; ++i) {
            tmpFile = new File(stdDepPlansPath, allStdPlans[i]);
            if (!tmpFile.isDirectory()) continue;
            String searchPath = "";
            for (int pathCheck = 1; pathCheck > 0; ++pathCheck) {
                File planFile;
                if (pathCheck == 1) {
                    searchPath = Utils.joinPath(stdDepPlansPath, allStdPlans[i], Language.gs_SelectedLanguage);
                } else if (pathCheck == 2) {
                    searchPath = Utils.joinPath(stdDepPlansPath, allStdPlans[i], "en");
                } else if (pathCheck == 3) {
                    searchPath = Utils.joinPath(stdDepPlansPath, allStdPlans[i]);
                } else {
                    pathCheck = -1;
                }
                if (pathCheck <= 0 || !(planFile = new File(searchPath, "plan.xml")).isFile()) continue;
                this.planFileVector.add(planFile.getAbsolutePath());
                pathCheck = -1;
            }
        }
    }

    private void createStdPlanObjects() {
        try {
            for (int i = 0; i < this.planFileVector.size(); ++i) {
                String planPath = this.planFileVector.get(i);
                String planName = "";
                String planType = "";
                int machCount = 0;
                Plan depPlan = PlanFactory.getPlanFromFile(new File(planPath));
                planName = depPlan.getName();
                List<Machine> machList = depPlan.getMachines();
                for (Machine currMach : machList) {
                    if (currMach.isOptional()) continue;
                    ++machCount;
                }
                String sortByName = planName.trim();
                if (planName.contains(",")) {
                    sortByName = planName.substring(0, planName.lastIndexOf(",")).replace(",", " ").replaceAll(" +", " ");
                }
                sortByName = this.findUniqueKeyName(sortByName, this.sortByNameSet);
                this.sortByNameSet.add(sortByName);
                String uniqueKeyName = this.findUniqueKeyName(planName, this.uniquePlanKeySet);
                this.uniquePlanKeySet.add(uniqueKeyName);
                StandardDeploymentPlan stdDeployPlan = new StandardDeploymentPlan(planName, sortByName, machCount, planType, planPath, uniqueKeyName);
                this.machineCounts.add(stdDeployPlan.getMachineCount().toString());
                this.planMap.put(uniqueKeyName, stdDeployPlan);
            }
        }
        catch (FileNotFoundException fnfe) {
            Logging.log.warning(fnfe.getMessage());
            Logging.logStackTrace(fnfe);
        }
        catch (ParseException pe) {
            Logging.log.warning(pe.getMessage());
            Logging.logStackTrace(pe);
        }
    }

    private String findUniqueKeyName(String key, Set<String> keys) {
        return this.findUniqueKeyName(key, keys, 0);
    }

    private String findUniqueKeyName(String key, Set<String> keys, int index) {
        String newKey = key + "_" + index;
        if (keys.contains(newKey)) {
            newKey = this.findUniqueKeyName(key, keys, ++index);
        }
        return newKey;
    }

    public final Map<String, StandardDeploymentPlan> getPlanMap() {
        return this.planMap;
    }

    public final SortedSet<String> getMachineCounts() {
        return this.machineCounts;
    }
}

